////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements plain text format I/O
////////////////////////////////////////////////////////////////////////////

#include "FormatIOTxt.h"
#include "DocumentIterator.h"
#include "debug.h"
#include <stdio.h>	//fopen
#ifdef _WIN32
 #ifndef __MINGW32__
  #define snprintf _snprintf
 #endif
#endif

FormatIO_Txt::FormatIO_Txt()
{
}

FormatIO_Txt::~FormatIO_Txt()
{
}

int FormatIO_Txt::Load(const char *szFile, NoteDocument &doc)
{
	return DOC_LOAD_NOT_SUPPORTED;	//not supported
}

int FormatIO_Txt::Save(const char *szFile, NoteDocument &doc)
{
	FILE *pOutFile = fopen(szFile, "w");
	if(NULL == pOutFile)
		return DOC_SAVE_ERR_FILE_OPEN;

	DocumentIterator it(doc);

	//write node contents in depth search order (recursive index)
	int nCnt = doc.GetNodeCount();

	for(int i=0; i<nCnt; i++)
	{
		int nIdx = it.RecursiveIdx2NodeIdx(i);
		ASSERT(nIdx >= 0);

		//calculate depth info "2.1.5"
		int nIdxTmp = nIdx;
		std::string strIndex;
		char szBuffer[20]; 
		for(;;)
		{
			NoteNode &note = doc.GetNodeByIdx(nIdxTmp);

			// add current sibling at the start of the string
			int nSIB = note.m_nSiblingIdx;
			snprintf(szBuffer, sizeof(szBuffer), "%d.", nSIB+1);
			std::string strTmp(strIndex);
			strIndex  = szBuffer;
			strIndex += strTmp;

			// go to parent node
			int nPID = note.m_nParentID;
			if(nPID < 0)	
				break;
			nIdxTmp = doc.GetIdxFromID(nPID);
		}
		strIndex.erase(strIndex.begin()+strIndex.size()-1);

		//write node title line
		fprintf(pOutFile, "* %s: %s\n\n", strIndex.c_str(), doc.GetNodeByIdx(nIdx).GetTitle().c_str());

		//write	node contents
		fprintf(pOutFile, "%s\n\n", doc.GetNodeByIdx(nIdx).GetText().c_str());
	}
	
	fclose(pOutFile);
	return DOC_SAVE_OK;
}

