# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

"""Tests for Notes app"""

from __future__ import absolute_import

from testtools.matchers import Equals
from autopilot.matchers import Eventually

from notes_app.tests import NotesTestCaseBaseWithHTTPServer, DatabaseMixin

import sqlite3


class BaseForTestImages(NotesTestCaseBaseWithHTTPServer, DatabaseMixin):
    def setUp(self):
        self.setup_db(self.IMAGE)
        super(BaseForTestImages, self).setUp()

    def setup_db(self, image):
        note_data = """{ "elements" : [
        {"content":"http://localhost:8129/""" + image + """","type":"image"}
        ]}"""

        path = self.find_db()
        if path is None:
            self.launch_and_quit_app()
            path = self.find_db()
            if path is None:
                self.assertNotEquals(path, None)

        conn = sqlite3.connect(path)
        cursor = conn.cursor()
        cursor.execute("DELETE FROM notes")
        cursor.execute("INSERT INTO notes (date, note) VALUES ('2013-04-07', '" + note_data + "')")
        conn.commit()
        conn.close()

    def verify_loader_item(self, loader, obj_type):
        self.assertThat(loader.progress, Eventually(Equals(1)))
        children = loader.get_children_by_type(obj_type)
        self.assertThat(len(children), Equals(1))
        return children[0]


class MixinForTestImage(object):
    def test_no_crash(self):
        note = self.main_window.get_notes()[0]
        self.main_window.wait_collapsed_note_filled(note)

        # Expand the note
        self.pointing_device.click_object(note)
        note.height.wait_for(note.actualExpandedHeight)

        # Verify that the note we inserted has the right parts
        parts = self.main_window.get_note_parts(note)
        self.assertThat(len(parts), Equals(1))
        self.verify_loader_item(parts[0], "ImageDelegate")


class TestImageLargeWide(BaseForTestImages, MixinForTestImage):
    IMAGE = "large_wide.png"


class TestImageSmallWide(BaseForTestImages, MixinForTestImage):
    IMAGE = "small_wide.png"


class TestImageLargeHigh(BaseForTestImages, MixinForTestImage):
    IMAGE = "large_high.png"


class TestImageSmallHigh(BaseForTestImages, MixinForTestImage):
    IMAGE = "small_high.png"
