[comment {-*- tcl -*- nxsh manpage}]

[include version.inc]
[manpage_begin nxsh 1 [vset VERSION]]

[copyright {2014-16 Stefan Sobernig <stefan.sobernig@wu.ac.at>, Gustaf Neumann <gustaf.neumann@wu.ac.at>; available under the Creative Commons Attribution 3.0 Austria license (CC BY 3.0 AT).}]

[titledesc {Simple shell containing NSF/NX interpreter}]
[moddesc {Command-line interface}]

[description]

[list_begin definitions]

[call [syscmd "nxsh"] [opt "[option -c] [opt [arg arg1]]"] [opt "[arg arg2] ..."]]

[syscmd "nxsh"] is a shell-like application that reads NX and Tcl
commands from different sources and evaluates them.

[para]

If invoked without any arguments, [syscmd "nxsh"] runs in
read-eval-print mode (REPL, interactive) similar to [syscmd "tclsh"]. In
this mode, it reads commands from standard input interactively and
prints command results as well as error messages to standard
output. It remains active until the exit command is invoked or until
it reaches end-of-file on its standard input.

[para]

If invoked with at least one positional argument [arg arg1], [syscmd "nxsh"] runs
a NX/Tcl script sourced from a file identified by [arg arg1] using [cmd source].

[para]

Passing the [option -c] flag makes [syscmd nxsh] accept commands from
the command line provided by [arg arg1]. If [arg arg1] is omitted,
[syscmd nxsh] takes commands from standard input (e.g., in a pipe).

[para] 

[syscmd "nxsh"] can be used like [syscmd "tclsh"] to make NX scripts directly invokable from the shell, by providing the following first line ("shebang") in the respective script:

[example {
	#! /usr/bin/env nxsh 
}]

A (more portable) alternative is:

[example_begin]
	#! /bin/sh
	# the next line restarts using nxsh \
	    exec nxsh "$0" "$@"
[example_end]

[list_end]

[manpage_end]
