
#include <iostream>
#include <QEventLoop>
#include <QCoreApplication>

#include <ntrackutil.h>

#include "QNtrack.h"

class Test : public QNtrackListener
{
public:
	void stateChanged (QNTrackState oldState, QNTrackState newState) {
		std::cout <<
		  "\t=> state changed: " << 
		  ntrack_util_state_to_ascii (oldState) << 
		  " -> " <<
		  ntrack_util_state_to_ascii (newState) <<
		  std::endl;
	}
};

int main(int argc, char **argv)
{
  // We must always have an application
  QCoreApplication a(argc, argv);
  Test *test = new Test();
  QNtrack *monitor = QNtrack::instance();

  QObject::connect(monitor, SIGNAL (stateChanged (QNTrackState, QNTrackState)),
                   test, SLOT (stateChanged (QNTrackState, QNTrackState)));

  std::cout << "initial state: " << ntrack_util_state_to_ascii (monitor->networkState()) << std::endl;

  std::cout << "\tmanual action needed:" << std::endl;
  std::cout << "\t... please turn on/off your network ..." << std::endl;

  return a.exec();              // And run!
} 
