#!/usr/bin/twistd -y
# -*- coding: utf-8 -*-

"""
Copyright(C) 2007 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


$Id: nulog.tac 11829 2007-12-27 11:12:31Z romain $
"""

from twisted.application import service
from nevow import rend, loaders, tags
from nevow import appserver
from twisted.application import internet
from nevow import inevow
import twisted
import sys
import os
from twisted.internet import defer

from ConfigParser import SafeConfigParser
from twisted.python import log
from nucentral import client, core

wrapper_conf = "wrapper.conf"
wrapper_defconf = "default.wrapper.conf"
etcpath = '/etc/nulog/'

class Service:

    def __init__(self, name, function, synchronous=False):
        self.name = name
        self.function = function
        self.synchronous = synchronous

    def check_permissions(self):
        return True

    def __call__(self, *args):

        if self.check_permissions() == False:
            return "Permission denied"

        try:
            output = self.function(*args)
        except Exception, inst:
            output = "Service execution failed: %s" % inst.__str__()

        return output


class Wrapper:

    def __init__(self, filenames, site):

        self.components = {}
        self.site = site
        self.config = SafeConfigParser()
        self.config.read(filenames)
        self.modules_list = {}
        client.Service.callService = self.callService
        client.Service.callService_s = self.callService_s
        client.Service.core = self

        try:
            self.var_dir = self.config.get('server', 'vardir')
        except:
            log.msg( '**************************************' )
            log.msg( 'Please give the vardir in config file.' )
            log.msg( 'Datas will not be saved!' )
            log.msg( '**************************************' )
            self.var_dir = None

        try:
            try:
                sys.path += [self.config.get('server', 'modulespath')]
            except:
                pass

            modules = self.config.items('modules')

            for name, yeah in modules:
                if yeah == 'yes':
                    log.msg('Loading', name, 'module...')
                    self.registerModule(name)

            site = appserver.NevowSite(site)

            server = internet.TCPServer(self.config.getint('server', 'port'), site)

            server.setServiceParent(application)

        except KeyError:
            raise Exception("Unable to read configuration")

    def registerModule(self,module_path):
        try:
            module = __import__(module_path)

            services = {}
            pages = {}

            if hasattr(module, "getComponentName"):
                module_name = module.getComponentName()
                self.registerComponent(module_name)
            else:
                raise Exception("There isn't any 'getComponentName' function")

            if hasattr(module, "getSyncServiceList"):
                services = module.getSyncServiceList()
                for service in services:
                    self.registerService(module_name, service, Service(service, services[service], synchronous=True))

            if hasattr(module, "getServiceList"):
                aservices = module.getServiceList()
                for service in aservices:
                    self.registerService(module_name, service, Service(service, aservices[service]))
                services.update(aservices)

            if hasattr(module, "getPageList"):
                pages = module.getPageList()
                for page in pages:
                    self.registerPage(page, pages[page])
            self.modules_list[module_name] = (module_path, services, pages)

        except Exception,e:
            log.msg('The following exception was caught while trying to load',module_path)
            log.msg('  %s' % e)
            raise


    def registerComponent(self,component):

            self.components[component] = { }

    def registerService(self,component, servicename, service):

        try:
                c = self.components[component]
        except KeyError:
                return "No component registered with this name"
        self.components[component][servicename] = service

    def registerPage(self, name, page):

        if not hasattr(self.site, "childdren"):
            self.site.children = dict()

        self.site.children[name] = page

    def __getService(self, component, servicename):
        """ Get a service from his component name and his name """

        c = {}
        s = None
        try:
                c = self.components[component]
        except KeyError:
                raise Exception("No component registered with this name")

        try:
                s = c[servicename]
        except KeyError:
                raise Exception("No service registered with this name")

        return s

    def callService(self,component,servicename,*args):

	def eb(result):
		if hasattr(result, 'value'):
			result = result.value

		return 'Service execution error: %s' % result

        try:
                service = self.__getService(component, servicename)
        except Exception, inst:
                return defer.succeed(str(inst))

        result = service(*args)

        if isinstance(result, defer.Deferred):
            return result.addErrback(eb)
        else:
            return defer.succeed(result)

    def callService_s(self, component, servicename, *args):
        """ Synchronous service call """

        try:
            service = self.__getService(component, servicename)
        except Exception, e:
            return str(e)

        if not service.synchronous:
            return "You try to call a non synchronous service."

        return service(*args)

class NevowSite(rend.Page):
    """ This is an useless root nevowsite...
        Components can add children.
    """

    def renderHTTP(self, ctx):

	request = inevow.IRequest(ctx)
        request.setResponseCode(302)
        request.setHeader('location', 'nulog')

	return ''# rend.Page.renderHTTP(self, ctx)

application = service.Application('nulog')

try:
    app = Wrapper([etcpath + wrapper_defconf, wrapper_defconf, etcpath + wrapper_conf, wrapper_conf], NevowSite())
except core.LoadError, e:
    log.msg("A module raised an error: %s" % e)
    exit()

