/* food.h */

/*
    NUT nutrition software 
    Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef FOOD_H
#define FOOD_H

#include <stdio.h>
#include "nut.h"

#define MAX_FOOD 9000
#define DV_COUNT 39

struct food
 {
 int   ndb_no;
 int   food_no;
 char  name[61];
 float qty;
 char  unit[51];
 int   refuse;
 float prot_cal_factor;
 float fat_cal_factor;
 float cho_cal_factor;
 float grams;
 float nutrient[NUTRIENT_COUNT];
 struct food *next;
 };

extern struct food food_root, recipe_root, food_work, *new_food, *new_recipe, *FoodIndex[];
extern char *Nutrient[];
extern char *Unit[];
extern float DV[];
extern float DVBase[];
extern float NoData;
extern int DVMap[];
extern int DV1Map[];
extern int CarbAminoMap[];
extern int MiscMap[];
extern int SatMap[];
extern int UnsatMap[];
extern int *ScreenMap[];
extern char *ScreenTitle[];
extern int MaxScreen;
extern int LookupNutrNo[];
extern int LookupNut[];
extern int FoodCount;

void initializations(void);
int order_new_food(void);
void order_new_food_already_sorted(void);
int namestrcmp(char *, char *);
int substring_finder(char *, char *);
struct food *food_choice(char *, int);
void food_subcat(char *, char *, struct food **, int);
void food_show(struct food *, float *);
void make_food_index(void);
int modify_food_index(int, struct food *);
struct food *food_number(int);
int find_ndbno(int);
struct food *find_ndbno_ptr(int);
void clear_work(void);
void food_display(FILE *);
void food_display_line(FILE *, int, int, int, int, int);
void order_new_recipe(void);
void modify_recipe_food(int, char *);
void compute_derived_fields(struct food *);
float dv_fat(void);
float dv_cho(void);
float dv_pro(void);
char *format_serving(char *, float *, struct food *);
float n6hufa(float, float, float, float, float, float);

#endif
