/* PersonalOptions.h */

/*
    NUT nutrition software 
    Copyright (C) 1996-2014 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PERSONALOPTIONS_H
#define PERSONALOPTIONS_H

#include <FL/Fl_Wizard.H>
#include "Nut_LightButton.h"
#include "WeightCharts.h"
#include "WeightLogWidget.h"

class PersonalOptions : public Fl_Wizard
{
public:
PersonalOptions(int x, int y, int w, int h, Fl_Color widgetcolor);
void update(void);
void initializeWeightLog(void);
void initializeWeightLogAutoCal(void);
void clearWeightLog(void);
void accept(double weight, double bodyfat);

private:
int n, nfat;
float weightslope, fatslope, weightyintercept, fatyintercept, earliestrdate;
WeightCharts *weightcharts;
WeightLogWidget *weightlogwidget;
Fl_Group *weightlog;
};

#endif
