/* everups.c - support for Ever UPS models

   Copyright (C) 2001  Bartek Szady <bszx@bszxdomain.edu.eu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "main.h"
#include <sys/ioctl.h>


	unsigned char	upstype = 0;

void init_serial(void)
{
        int     clr_bit = TIOCM_DTR | TIOCM_RTS;
        ioctl(upsfd, TIOCMBIC, &clr_bit);
}

int Code(int tries)
{
	unsigned char cRecv;
	do {
		upssendchar(208);
		upsrecvchars((char*) &cRecv,1);
		if (cRecv==208)
			return 1;
	} while (--tries>0);
	return 0;
}

int InitUpsType()
{
	if (Code(1)) {
		upssendchar(173);
		upsrecvchars((char*) &upstype,1);
		return 1;
	} else
		return 0;
}

char *GetTypeUpsName()
{
        switch(upstype)
        {
	        case 67: return "NET 500-DPC";
		case 68: return "NET 700-DPC";
		case 69: return "NET 1000-DPC";
		case 70: return "NET 1400-DPC";
		case 71: return "NET 2200-DPC";
		case 81: return "AP 450-PRO";
		case 82: return "AP 650-PRO";
		default:
			return "Unknown";
	}
}

void upsdrv_initinfo(void)
{
	dstate_setinfo("ups.mfr", "Ever");
	dstate_setinfo("ups.model", "%s", GetTypeUpsName());
}

void upsdrv_updateinfo(void)
{
	int	battery=0,standby=0;
	unsigned char recBuf[2];
	unsigned long acuV;
	unsigned long lineV;
	double	fVal;
	
	if (!Code(2)) {
		upslog(LOG_INFO, "Code failed");
		dstate_datastale();
		return;
	}
	/*Line status*/
	upssendchar(175);
	upsrecvchars((char*)recBuf,1);
	if ((recBuf[0] & 1) !=0)
		standby=1;
	else 
		battery=(recBuf[0] &4) !=0;
	if (Code(1)) {  /*Accumulator voltage value*/
		upssendchar(189);
		upsrecvchars((char*)recBuf,1);
		acuV=((unsigned long)recBuf[0])*150;
		acuV/=255;
	} else {
		upslog(LOG_INFO, "Code failed");
		dstate_datastale();
		return;
	}
	if (Code(1)) {  /*Line voltage*/
		upssendchar(245);
		upsrecvchars((char*) recBuf,2);
		lineV=(recBuf[0]*100+recBuf[1]*25600)/372;
	} else {
		upslog(LOG_INFO, "Code failed");
		dstate_datastale();
		return;
	}

	status_init();

	if (battery && acuV<105)
		status_set("LB");	/* low battery */

	if (battery)
		status_set("OB");	/* on battery */
	else
		status_set("OL");	/* on line */

	status_commit();

	dstate_setinfo("input.voltage", "%03ld", lineV);
	dstate_setinfo("battery.voltage", "%03.2f", (double)acuV /10.0);

	fVal=((double)acuV-95.0)*100.0;
	if (standby)
	  fVal/=(135.5-95.0);
	else
	  fVal/=(124.5-95.0);
	if (fVal>100)
		fVal=100;
	else if (fVal<0)
		fVal=0;

	dstate_setinfo("battery.charge", "%03.1f", fVal);

	dstate_dataok();
}

void upsdrv_shutdown(void)
{
	if (!Code(2)) {
		upslogx(LOG_INFO, "Code failed: %m\n");
		return;
	}
	upssendchar(28);
	upssendchar(1);  /* 1.28 sec */
	if (!Code(1)) {
		upslogx(LOG_INFO, "Code failed: %m\n");
		return;
	}
	upssendchar(13);
	upssendchar(8);
}

void upsdrv_help(void)
{
}

/* list flags and values that you want to receive via -x */
void upsdrv_makevartable(void)
{
	/* allow '-x xyzzy' */
	/* addvar(ARG_FLAG, "xyzzy", "Enable xyzzy mode"); */

	/* allow '-x foo=<some value>' */
	/* addvar(ARG_VALUE, "foo", "Override foo setting"); */
}

void upsdrv_banner(void)
{
	printf("Network UPS Tools - Ever UPS driver 0.01 (%s)\n\n", UPS_VERSION);
}

void upsdrv_initups(void)
{
	open_serial (device_path,B300);
	init_serial();
	InitUpsType();
}

void upsdrv_cleanup(void)
{
}
