/* netcmds.h - upsd support structure details

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "ctype.h"
#include "levels.h"

/* things still in upsd.c */
static void do_sendver(ctype *client, char *arg, char *rest);
static void do_sendhelp(ctype *client, char *arg, char *rest);
static void do_logout(ctype *client, char *arg, char *rest);
static void do_login(ctype *client, char *arg, char *rest);
static void do_password(ctype *client, char *arg, char *rest);
static void do_fsd(ctype *client, char *arg, char *rest);
static void do_master(ctype *client, char *arg, char *rest);
static void do_username(ctype *client, char *arg, char *rest);

/* everything else */
void do_sendans(ctype *client, char *arg, char *rest);
void do_listvars(ctype *client, char *arg, char *rest);
void do_listrw(ctype *client, char *arg, char *rest);
void do_vartype(ctype *client, char *arg, char *rest);
void do_vardesc(ctype *client, char *arg, char *rest);
void do_enum(ctype *client, char *arg, char *rest);
void do_set(ctype *client, char *arg, char *rest);
void do_instcmd(ctype *client, char *arg, char *rest);
void do_listinstcmd(ctype *client, char *arg, char *rest);
void do_instcmddesc(ctype *client, char *arg, char *rest);
void do_starttls(ctype *client, char *arg, char *rest);

/* flags for the netcmds */

#define FLAG_TCP	0x0001		/* must be on a TCP connection      */
#define FLAG_USER	0x0002		/* requires valid username+password */
#define FLAG_CMD	0x0004		/* command must be allowed          */

/* netcmds[] - map net commands to functions */

struct {
	char	*name;
	void	(*func)(ctype *client, char *arg, char *rest);
	int	flags;
	int	level;
}	netcmds[] =
{
	{ "VER",	do_sendver,	0,		LEVEL_BASE	},
	{ "HELP",	do_sendhelp,	0,		LEVEL_BASE	},

	{ "REQ",	do_sendans,	0,		LEVEL_MONITOR	},
	{ "LISTVARS",	do_listvars,	0,		LEVEL_MONITOR	},
	{ "LISTRW",	do_listrw,	0,		LEVEL_MONITOR	},
	{ "VARTYPE",	do_vartype,	0,		LEVEL_MONITOR	},
	{ "VARDESC",	do_vardesc,	0,		LEVEL_MONITOR	},
	{ "ENUM",	do_enum,	0,		LEVEL_MONITOR	},
	{ "LISTINSTCMD",do_listinstcmd,	0,		LEVEL_MONITOR	},
	{ "INSTCMDDESC",do_instcmddesc,	0,		LEVEL_MONITOR	},

	{ "LOGOUT", 	do_logout,	FLAG_TCP,	LEVEL_BASE	},
	{ "STARTTLS",	do_starttls,	FLAG_TCP,	LEVEL_BASE	},
	{ "USERNAME",	do_username,	FLAG_TCP,	LEVEL_BASE	},
	{ "PASSWORD",	do_password,	FLAG_TCP,	LEVEL_BASE	},

	/* things that authenticate through upsd.users */

	{ "LOGIN",	do_login,	FLAG_TCP|FLAG_USER,	LEVEL_MONITOR },
	{ "MASTER",	do_master,	FLAG_TCP|FLAG_USER,	LEVEL_MONITOR },

	{ "SET",	do_set,		FLAG_TCP|FLAG_USER,	LEVEL_MONITOR },
	{ "FSD",	do_fsd,		FLAG_TCP|FLAG_USER,	LEVEL_MONITOR },

	{ "INSTCMD",	do_instcmd,	FLAG_TCP|FLAG_USER|FLAG_CMD,	LEVEL_MONITOR },

	{ NULL,		(void(*)())(NULL), 0, 0	}
};

/* --- new net parsing work --- */

struct new_netcmds_t {
	char	*name;
	int	(*func)(ctype *client, int numargs, char **arg);
	int	flags;
	int	level;
};

int net_get(ctype *client, int numarg, char **arg);
int net_list(ctype *client, int numarg, char **arg);
int net_set(ctype *client, int numarg, char **arg);
int net_instcmd(ctype *client, int numarg, char **arg);

struct new_netcmds_t new_netcmds[] =
{
	{ "GET",	net_get,	0,			LEVEL_MONITOR,	},
	{ "LIST",	net_list,	0,			LEVEL_MONITOR,	},
	{ "SET",	net_set,	FLAG_USER,		LEVEL_MONITOR,	},
	{ "INSTCMD",	net_instcmd,	FLAG_USER|FLAG_CMD,	LEVEL_MONITOR,	},

	{ NULL,		(int(*)())(NULL), 0, 0 }
};
