      subroutine tce_multipole_create(rtdb,d_d1,l_d1_offset,k_d1_offset)
c
c $Id: tce_multipole_create.F,v 1.2 2008-05-05 18:17:54 jhammond Exp $
c 
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by 
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "rtdb.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
#include "tce.fh"
#include "tce_main.fh"
c#include "tce_prop.fh"
#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      integer rtdb             ! Run-time database
      logical nodezero         ! True if node 0
      double precision cpu     ! CPU sec counter
      double precision wall    ! WALL sec counter
      double precision ref     ! Ground state energy
      integer dummy            ! Dummy argument for DIIS
      integer l_shell,l_subshell,l_sh_size
      character*255 filename
      character*4 irrepname
      integer i
      integer j
      double precision dipole_scf(3) ! Dipole moment
      double precision dipole_cor(3) ! Dipole moment
      double precision dipole_exc(3) ! Dipole moment
      double precision cdipole   ! Dipole moment correlation
      double precision ddotfile
      external ddotfile
      integer sym_abelian_axis ! Move this and the following to "sym.fh"
      external sym_abelian_axis
      character*255 modelname
c
      nodezero=(ga_nodeid().eq.0)
c
c     ================================
c     Parallel integral transformation
c     ================================
c
      if (left) then
        cpu = - util_cpusec()
        wall = - util_wallsec()
        call tce_nud1(dipole_scf)
        call tce_aod1(rtdb,g_aod1,dipole_scf)
        cpu = cpu + util_cpusec()
        wall = wall + util_wallsec()
        if (nodezero.and.util_print('mod1',print_default)) then
          write(LuOut,9430) "SCF",dipole_scf(1),dipole_scf(1)*debye,
     1                            dipole_scf(2),dipole_scf(2)*debye,
     2                            dipole_scf(3),dipole_scf(3)*debye
          write(LuOut,*)
          write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
        endif
        do axis = 1, 3
          irrep_d=sym_abelian_axis(geom,axis)
          call sym_irrepname(geom,irrep_d+1,irrepname)
          if (nodezero.and.util_print('mod1',print_default)) then
            write(LuOut,*)
            write(LuOut,9440) axisname(axis),irrepname
          endif
          call tce_mod1_offset(l_d1_offset(axis),k_d1_offset(axis),
     1      size_d1(axis))
          call tce_filename(dfilename(axis),filename)
          call createfile(filename,d_d1(axis),size_d1(axis))
          if (nodezero.and.util_print('mod1',print_default)) then
            write(LuOut,*)
            write(LuOut,9000) 'dipole',size_d1(axis)
            write(LuOut,9010) 'dipole',filename(1:20)
          endif
        enddo
        call tce_mod1(g_aod1,d_d1)
        do axis = 1, 3
          call gatoeaf(d_d1(axis))
        enddo
      endif
c      if(nodezero) write(LuOut,*) 'multipole = ',multipole
      if (multipole.gt.0) then
      endif
c      call errquit('tce_property: DEBUGGING',0,UNKNOWN_ERR)
c
      return
c
c     ======
c     Format
c     ======
c
 9000 format(1x,A,' file size   = ',i16)
 9010 format(1x,A,' file name   = ',A)
 9090 format(1x,A,' file handle = ',i10)
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
 9100 format(1x,i4,2f18.13,2f8.1)
 9120 format(1x,A)
 9430 format(/,1x,A,' dipole moments / hartree & Debye',/,
     1  1x,'--------------------------------',/
     2  1x,'X ',2f15.7,/
     3  1x,'Y ',2f15.7,/
     4  1x,'Z ',2f15.7,/
     5  1x,'--------------------------------')
 9440 format(1x,A3,' axis ( ',A4,'symmetry)')
      end
