C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_m05.F 
C> The nwxcm_c_m05 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_m05 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{32}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{0.06\,{\it t_{37}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{31}}
C>    \,{\it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{32}}+{
C>    \it t_{30}}\right)+{\it t_{29}}\right)+{\it t_{28}}\right)+{
C>    \it t_{26}}\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06
C>    \,{\it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{22}}\,\sigma_{\alpha\alpha}
C>    \,{\it t_{27}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_\alpha
C>    -{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\tau_\alpha}}+1.0\,\left({
C>    \it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}\,{
C>    \it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}+1.0\right)
C>    \,{\it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{
C>    \it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{\it t_{24}}\,{
C>    \it t_{25}}\,\left(0.0031\,{\it param}\left(5\right)\,{
C>    \it t_{24}}\,{\it t_{25}}+{\it param}\left(4\right)\right)+{
C>    \it param}\left(3\right)\right)+{\it param}\left(2\right)\right)
C>    +{\it param}\left(1\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{36}}+2.225569421150687\,{\it t_{35}}+0.8004286349993635
C>    \,{\it t_{34}}+0.1897004325747558\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{35}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{36}}+3.844746237447211\,{\it t_{35}}+1.644733775567609
C>    \,{\it t_{34}}+0.2405871291288192\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{35}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}
C>    \,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{37}}\,\sigma_{ss}\,{
C>    \it t_{38}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, NE Schultz, DG Truhlar, J.Chem.Phys. 123
C>    , 161103 (2005)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2126975 "> 
C> 10.1063/1.2126975 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m05(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(5)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(4)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(3)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(2)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(1)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = 6.0d-2*gammaaa*t1+1.0d+0
              t25 = 1/t24
              t26 = param(10)
              t27 = 6.0d-2*gammaaa*t1*t25*t26+param(9)
              t28 = 6.0d-2*gammaaa*t1*t25*t27+param(8)
              t29 = 6.0d-2*gammaaa*t1*t25*t28+param(7)
              t30 = 6.0d-2*gammaaa*t1*t25*t29+param(6)
              t31 = 1/taua
              t32 = 1/rhoa
              t33 = 2.0d+0*taua-2.5d-1*gammaaa*t32
              t34 = 1.414213562373095d+0
              t35 = 7.937005259840998d-1
              t36 = 1.1950378408754898d-1*t9+2.2255694211506874d+0*t12*t
     1           35+8.004286349993635d-1*t11/t34+5.329846514438382d+0*t1
     2           3
              t37 = 1.6081979498692536d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.3256889990520176d-1*t12*t35+1.0d+0
              t40 = 1/rhoa**1.6666666666666669d+0
              t41 = 1/t10**3
              t42 = 1/rhoa**1.3333333333333333d+0
              t43 = 1/rhoa**1.1666666666666667d+0
              t44 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t4
     1           3-7.418564737168958d-1*t42-4.002143174996817d-1*t41-1.2
     2           64669550498372d-1*t40)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t43-1.2815820791490704d+0*t42-8.2236688
     4           77838045d-1*t41-1.6039141941921276d-1*t40)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t42+1.3210398931339265d-3*t
     6           16*t42
              t45 = 3.968502629920499d-1
              t46 = gammaaa**2
              t47 = 1/t2**2
              t48 = 1/rhoa**6.333333333333333d+0
              t49 = 1/rhoa**3.6666666666666664d+0
              t50 = t23-1.243628d-1*rhoa*t38*t39
              t51 = 1/t24**2
              t52 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = (1.0d+0*t8*(t23-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.195037
     2           84087549d-1*t9+5.329846514438383d+0*t13+1.7664356201814
     3           29d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rho
     4           a*t22*t30*t31*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*(2*rhoa*(1.0d+0*t39*(-7.418564737
     1           168958d-1*t42*t45-4.4415387620319857d-1*t43-4.002143174
     2           996817d-1*t41/t34**3-3.9834594695849657d-2*t40)/(t36**2
     3           *t37)+2.747773264188437d-3*t38*t42*t45)-rhoa*t44-6.2181
     4           4d-2*t38*t39+6.903522198342671d-18*t20*t21+3.1090699999
     5           999993d-2*t16*t17)*t8+1.0d+0*t50*(-8.266666666666665d-3
     6           *gammaaa*t3*t49*t7+5.125333333333332d-5*t46*t47*t48*t7+
     7           6.2d-3*gammaaa*t1*t3*(-8.266666666666665d-3*gammaaa*t3*
     8           t49*t6+5.125333333333332d-5*t46*t47*t48*t6+6.2d-3*gamma
     9           aa*t1*t3*(-8.266666666666665d-3*gammaaa*t3*t49*t5+5.125
     :           333333333332d-5*t46*t47*t48*t5+6.2d-3*gammaaa*t1*t3*(5.
     ;           125333333333332d-5*t4*t46*t47*t48-8.266666666666665d-3*
     <           gammaaa*t3*t4*t49))))+t31*(5.0d-1*rhoa*t22*t33*(6.0d-2*
     =           gammaaa*t1*t25*(6.0d-2*gammaaa*t1*t25*(6.0d-2*gammaaa*t
     >           1*t25*(9.599999999999997d-3*t26*t46*t48*t51-1.599999999
     ?           9999998d-1*gammaaa*t25*t26*t49)+9.599999999999997d-3*t2
     @           7*t46*t48*t51-1.5999999999999998d-1*gammaaa*t25*t27*t49
     1           )+9.599999999999997d-3*t28*t46*t48*t51-1.59999999999999
     2           98d-1*gammaaa*t25*t28*t49)+9.599999999999997d-3*t29*t46
     3           *t48*t51-1.5999999999999998d-1*gammaaa*t25*t29*t49)+5.0
     4           d-1*rhoa*t30*t33*t44+5.0d-1*t22*t30*t33)+1.25d-1*gammaa
     5           a*t22*t30*t31*t32)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (1.0d+0*t50*(-1.9219999999999998d-5*gamm
     1           aaa*t47*t52*t7+3.1d-3*t1*t3*t7+6.2d-3*gammaaa*t1*t3*(-1
     2           .9219999999999998d-5*gammaaa*t47*t52*t6+3.1d-3*t1*t3*t6
     3           +6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(3.1d-3*t1*
     4           t3*t4-1.9219999999999998d-5*gammaaa*t4*t47*t52)-1.92199
     5           99999999998d-5*gammaaa*t47*t5*t52+3.1d-3*t1*t3*t5)))+t3
     6           1*(5.0d-1*rhoa*t22*t33*(6.0d-2*gammaaa*t1*t25*(6.0d-2*g
     7           ammaaa*t1*t25*(6.0d-2*gammaaa*t1*t25*(6.0d-2*t1*t25*t26
     8           -3.6d-3*gammaaa*t26*t51*t52)-3.6d-3*gammaaa*t27*t51*t52
     9           +6.0d-2*t1*t25*t27)-3.6d-3*gammaaa*t28*t51*t52+6.0d-2*t
     :           1*t25*t28)-3.6d-3*gammaaa*t29*t51*t52+6.0d-2*t1*t25*t29
     ;           )-1.25d-1*t22*t30))*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t22*t30*t31-5.0d-1*rhoa*t22*
     1           t30*t33/taua**2)*wght+Mmat(iq,D1_TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 2.4799999999999997d-52*t1+1.0d+0
              t24 = 1/t23
              t25 = param(5)
              t26 = 2.4799999999999997d-52*t1*t24*t25+param(4)
              t27 = 2.4799999999999997d-52*t1*t24*t26+param(3)
              t28 = 2.4799999999999997d-52*t1*t24*t27+param(2)
              t29 = 2.4799999999999997d-52*t1*t24*t28+param(1)
              t30 = -2*rhoa*t22
              t31 = 1/t10**3
              t32 = 1/rhoa**1.3333333333333333d+0
              t33 = 1/rhoa**1.1666666666666667d+0
              t34 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t3
     1           3-7.418564737168958d-1*t32-4.002143174996817d-1*t31-1.2
     2           64669550498372d-1*t1)/(t18**2*t19)+1.0d+0*t17*(-1.85339
     3           58105157808d+0*t33-1.2815820791490704d+0*t32-8.22366887
     4           7838045d-1*t31-1.6039141941921276d-1*t1)/(t14**2*t15)+3
     5           .0506411443514264d-19*t20*t32+1.3210398931339265d-3*t16
     6           *t32
              t35 = 1/t2**2
              t36 = 1/rhoa**4.333333333333333d+0
              t37 = 1/rhoa**2.6666666666666666d+0
              t38 = 1.414213562373095d+0
              t39 = 7.937005259840998d-1
              t40 = 1.1950378408754898d-1*t9+2.2255694211506874d+0*t12*t
     1           39+8.004286349993635d-1*t11/t38+5.329846514438382d+0*t1
     2           3
              t41 = 1.6081979498692536d+1/t40+1.0d+0
              t42 = log(t41)
              t43 = 1.3256889990520176d-1*t12*t39+1.0d+0
              t44 = 3.968502629920499d-1
              t45 = 1/t23**2
              fnc(iq) = (1.0d+0*t29*(t30-1.243628d-1*rhoa*(1.05220005583
     1           89212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.19503
     2           784087549d-1*t9+5.329846514438383d+0*t13+1.766435620181
     3           429d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rh
     4           oa*t22*t8)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t34*t8+5.0d-1*t22*t8+5.0d-1*
     1           rhoa*t22*(-4.0d-51*t3*t37*t7+9.6d-102*t35*t36*t7+2.4d-5
     2           1*t1*t3*(-4.0d-51*t3*t37*t6+9.6d-102*t35*t36*t6+2.4d-51
     3           *t1*t3*(-4.0d-51*t3*t37*t5+9.6d-102*t35*t36*t5+2.4d-51*
     4           t1*t3*(9.6d-102*t35*t36*t4-4.0d-51*t3*t37*t4))))+1.0d+0
     5           *(t30-1.243628d-1*rhoa*t42*t43)*(2.4799999999999997d-52
     6           *t1*t24*(2.4799999999999997d-52*t1*t24*(2.4799999999999
     7           997d-52*t1*t24*(5.125333333333333d-104*t25*t36*t45-2.06
     8           66666666666667d-52*t24*t25*t37)+5.125333333333333d-104*
     9           t26*t36*t45-2.0666666666666667d-52*t24*t26*t37)+5.12533
     :           3333333333d-104*t27*t36*t45-2.0666666666666667d-52*t24*
     ;           t27*t37)+5.125333333333333d-104*t28*t36*t45-2.066666666
     <           6666667d-52*t24*t28*t37)+1.0d+0*t29*(2*rhoa*(1.0d+0*t43
     =           *(-7.418564737168958d-1*t32*t44-4.002143174996817d-1*t3
     >           1/t38**3-4.4415387620319857d-1*t33-3.9834594695849657d-
     ?           2*t1)/(t40**2*t41)+2.747773264188437d-3*t32*t42*t44)-6.
     @           21814d-2*t42*t43-rhoa*t34+6.903522198342671d-18*t20*t21
     1           +3.1090699999999993d-2*t16*t17))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(5)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 1/rhob**2.6666666666666666d+0
              t4 = gammabb*t3+gammaaa*t2
              t5 = 3.1d-3*t4+1.0d+0
              t6 = 1/t5
              t7 = 3.1d-3*t1*t4*t6+param(4)
              t8 = 3.1d-3*t4*t6*t7+param(3)
              t9 = 3.1d-3*t4*t6*t8+param(2)
              t10 = 3.1d-3*t4*t6*t9+param(1)
              t11 = 1/rhoa**6.666666666666666d-1
              t12 = rhoa**5.0d-1
              t13 = 1/t12
              t14 = 1/rhoa**3.333333333333333d-1
              t15 = 1/rhoa**1.6666666666666666d-1
              t16 = 1.1120374863094686d+1*t15+3.8447462374472113d+0*t14+
     1           1.644733775567609d+0*t13+2.4058712912881916d-1*t11
              t17 = 3.216395899738507d+1/t16+1.0d+0
              t18 = log(t17)
              t19 = 1.274696188700087d-1*t14+1.0d+0
              t20 = 5.982550435771079d+0*t15+2.2255694211506874d+0*t14+8
     1           .004286349993635d-1*t13+1.8970043257475583d-1*t11
              t21 = 1.6081979498692536d+1/t20+1.0d+0
              t22 = log(t21)
              t23 = 1.3256889990520176d-1*t14+1.0d+0
              t24 = -6.903522198342671d-18*t22*t23-3.1090699999999993d-2
     1           *t18*t19
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = rhob+rhoa
              t40 = 1/t39**3.333333333333333d-1
              t41 = 1.3256889990520176d-1*t40+1.0d+0
              t42 = rhoa-rhob
              t43 = t42**4
              t44 = 1/t39**4
              t45 = 1/t39
              t46 = 1.0d+0-t42*t45
              t47 = t42*t45+1.0d+0
              t48 = t47**1.3333333333333333d+0+t46**1.3333333333333333d+
     1           0-2.0d+0
              t49 = -1.923661050931536d+0*t43*t44*t48
              t50 = t49+1.0d+0
              t51 = 1/t39**6.666666666666666d-1
              t52 = t39**5.0d-1
              t53 = 1/t52
              t54 = 1/t39**1.6666666666666666d-1
              t55 = 5.982550435771079d+0*t54+8.004286349993635d-1*t53+1.
     1           8970043257475583d-1*t51+2.2255694211506874d+0*t40
              t56 = 1.6081979498692536d+1/t55+1.0d+0
              t57 = log(t56)
              t58 = -6.21814d-2*t41*t50*t57
              t59 = 6.901399211255825d-2*t40+1.0d+0
              t60 = t49+1.923661050931536d+0*t48
              t61 = 8.157414703487641d+0*t54+4.3009724712766434d-1*t53+1
     1           .9115125951273373d-1*t51+2.247591863577616d+0*t40
              t62 = 2.9608813203268075d+1/t61+1.0d+0
              t63 = log(t62)
              t64 = 1.9751631321680768d-2*t59*t60*t63
              t65 = 1.274696188700087d-1*t40+1.0d+0
              t66 = 1.1120374863094686d+1*t54+1.644733775567609d+0*t53+2
     1           .4058712912881916d-1*t51+3.8447462374472113d+0*t40
              t67 = 3.216395899738507d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -5.980796863619711d-2*t43*t44*t48*t65*t68
              t70 = t39*(t69+t64+t58)-rhob*t38-rhoa*t24
              t71 = param(6)
              t72 = 6.0d-2*gammaaa*t2+1.0d+0
              t73 = 1/t72
              t74 = param(7)
              t75 = param(8)
              t76 = param(9)
              t77 = param(10)
              t78 = 6.0d-2*gammaaa*t2*t73*t77+t76
              t79 = 6.0d-2*gammaaa*t2*t73*t78+t75
              t80 = 6.0d-2*gammaaa*t2*t73*t79+t74
              t81 = 6.0d-2*gammaaa*t2*t73*t80+t71
              t82 = 1/taua
              t83 = 1/rhoa
              t84 = 2.0d+0*taua-2.5d-1*gammaaa*t83
              t85 = 6.0d-2*gammabb*t3+1.0d+0
              t86 = 1/t85
              t87 = 6.0d-2*gammabb*t3*t77*t86+t76
              t88 = 6.0d-2*gammabb*t3*t86*t87+t75
              t89 = 6.0d-2*gammabb*t3*t86*t88+t74
              t90 = 6.0d-2*gammabb*t3*t86*t89+t71
              t91 = 1/taub
              t92 = 1/rhob
              t93 = 2.0d+0*taub-2.5d-1*gammabb*t92
              t94 = 1/rhoa**1.6666666666666669d+0
              t95 = 1/t12**3
              t96 = 1/rhoa**1.3333333333333333d+0
              t97 = 1/rhoa**1.1666666666666667d+0
              t98 = 1.1102230246251565d-16*t23*(-9.970917392951799d-1*t9
     1           7-7.418564737168958d-1*t96-4.002143174996817d-1*t95-1.2
     2           64669550498372d-1*t94)/(t20**2*t21)+1.0d+0*t19*(-1.8533
     3           958105157808d+0*t97-1.2815820791490704d+0*t96-8.2236688
     4           77838045d-1*t95-1.6039141941921276d-1*t94)/(t16**2*t17)
     5           +3.0506411443514264d-19*t22*t96+1.3210398931339265d-3*t
     6           18*t96
              t99 = 1/t39**1.6666666666666669d+0
              t100 = 1/t52**3
              t101 = 1/t39**1.3333333333333333d+0
              t102 = 1/t39**1.1666666666666667d+0
              t103 = 1.0d+0*t41*t50*(-1.264669550498372d-1*t99-9.9709173
     1           92951799d-1*t102-7.418564737168958d-1*t101-4.0021431749
     2           96817d-1*t100)/(t55**2*t56)
              t104 = -5.848223622634647d-1*t59*t60*(-1.2743417300848914d
     1           -1*t99-1.3595691172479402d+0*t102-7.491972878592053d-1*
     2           t101-2.1504862356383217d-1*t100)/(t61**2*t62)
              t105 = 1.923661050931536d+0*t43*t44*t48*t65*(-1.6039141941
     1           921276d-1*t99-1.8533958105157808d+0*t102-1.281582079149
     2           0704d+0*t101-8.223668877838045d-1*t100)/(t66**2*t67)
              t106 = 1/t39**2
              t107 = t106*t42
              t108 = -t45
              t109 = t46**3.333333333333333d-1
              t110 = -t106*t42
              t111 = t47**3.333333333333333d-1
              t112 = 1.3333333333333333d+0*t111*(t45+t110)+1.33333333333
     1           33333d+0*(t108+t107)*t109
              t113 = -1.923661050931536d+0*t112*t43*t44
              t114 = 1/t39**5
              t115 = 7.694644203726144d+0*t114*t43*t48
              t116 = t42**3
              t117 = -7.694644203726144d+0*t116*t44*t48
              t118 = 2.747773264188437d-3*t101*t50*t57
              t119 = -4.5437964274821163d-4*t101*t60*t63
              t120 = 2.541232989148493d-3*t43*t48*t68/t39**5.33333333333
     1           3333d+0
              t121 = 2.3923187454478842d-1*t114*t43*t48*t65*t68
              t122 = 1/rhoa**3.6666666666666664d+0
              t123 = 1/t5**2
              t124 = gammaaa**2
              t125 = 1/t72**2
              t126 = 1/rhoa**6.333333333333333d+0
              t127 = 1/rhob**1.6666666666666669d+0
              t128 = 1/t26**3
              t129 = 1/rhob**1.3333333333333333d+0
              t130 = 1/rhob**1.1666666666666667d+0
              t131 = 1.1102230246251565d-16*(-9.970917392951799d-1*t130-
     1           7.418564737168958d-1*t129-4.002143174996817d-1*t128-1.2
     2           64669550498372d-1*t127)*t37/(t34**2*t35)+3.050641144351
     3           4264d-19*t129*t36+1.0d+0*(-1.8533958105157808d+0*t130-1
     4           .2815820791490704d+0*t129-8.223668877838045d-1*t128-1.6
     5           039141941921276d-1*t127)*t33/(t30**2*t31)+1.32103989313
     6           39265d-3*t129*t32
              t132 = 1.3333333333333333d+0*t109*(t45+t107)+1.33333333333
     1           33333d+0*(t110+t108)*t111
              t133 = -1.923661050931536d+0*t132*t43*t44
              t134 = 7.694644203726144d+0*t116*t44*t48
              t135 = 1/rhob**3.6666666666666664d+0
              t136 = gammabb**2
              t137 = 1/t85**2
              t138 = 1/rhob**6.333333333333333d+0
              t139 = 1/rhoa**5.333333333333333d+0
              t140 = 1/rhob**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t38*t90*t91*t93+5.0d-1*rhoa*t24*t81
     1           *t82*t84+1.0d+0*t10*t70)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t82*(5.0d-1*rhoa*t81*t84*t98+5.0d-1*t24*
     1           t81*t84+5.0d-1*rhoa*t24*(-1.5999999999999998d-1*gammaaa
     2           *t122*t73*t80+9.599999999999997d-3*t124*t125*t126*t80+6
     3           .0d-2*gammaaa*t2*t73*(-1.5999999999999998d-1*gammaaa*t1
     4           22*t73*t79+9.599999999999997d-3*t124*t125*t126*t79+6.0d
     5           -2*gammaaa*t2*t73*(-1.5999999999999998d-1*gammaaa*t122*
     6           t73*t78+9.599999999999997d-3*t124*t125*t126*t78+6.0d-2*
     7           gammaaa*t2*t73*(9.599999999999997d-3*t124*t125*t126*t77
     8           -1.5999999999999998d-1*gammaaa*t122*t73*t77))))*t84)+1.
     9           0d+0*t10*(-rhoa*t98+t69+t39*(-2.3923187454478842d-1*t11
     :           6*t44*t48*t65*t68-5.980796863619711d-2*t112*t43*t44*t65
     ;           *t68+1.9751631321680768d-2*(t117+t115+t113+1.9236610509
     <           31536d+0*t112)*t59*t63-6.21814d-2*(t117+t115+t113)*t41*
     =           t57+t121+t120+t119+t118+t105+t104+t103)+t64+t58+6.90352
     >           2198342671d-18*t22*t23+3.1090699999999993d-2*t18*t19)+1
     ?           .0d+0*t70*(-8.266666666666665d-3*gammaaa*t122*t6*t9+2.5
     @           62666666666666d-5*gammaaa*t122*t123*t4*t9+3.1d-3*t4*t6*
     1           (-8.266666666666665d-3*gammaaa*t122*t6*t8+2.56266666666
     2           6666d-5*gammaaa*t122*t123*t4*t8+3.1d-3*t4*t6*(-8.266666
     3           666666665d-3*gammaaa*t122*t6*t7+2.562666666666666d-5*ga
     4           mmaaa*t122*t123*t4*t7+3.1d-3*t4*t6*(2.562666666666666d-
     5           5*gammaaa*t1*t122*t123*t4-8.266666666666665d-3*gammaaa*
     6           t1*t122*t6))))+1.25d-1*gammaaa*t24*t81*t82*t83)*wght+Am
     7           at(iq,D1_RA)
              Amat(iq,D1_RB) = (t91*(5.0d-1*t38*t90*t93+5.0d-1*rhob*t131
     1           *t90*t93+5.0d-1*rhob*t38*(-1.5999999999999998d-1*gammab
     2           b*t135*t86*t89+9.599999999999997d-3*t136*t137*t138*t89+
     3           6.0d-2*gammabb*t3*t86*(-1.5999999999999998d-1*gammabb*t
     4           135*t86*t88+9.599999999999997d-3*t136*t137*t138*t88+6.0
     5           d-2*gammabb*t3*t86*(-1.5999999999999998d-1*gammabb*t135
     6           *t86*t87+9.599999999999997d-3*t136*t137*t138*t87+6.0d-2
     7           *gammabb*t3*t86*(9.599999999999997d-3*t136*t137*t138*t7
     8           7-1.5999999999999998d-1*gammabb*t135*t77*t86))))*t93)+1
     9           .25d-1*gammabb*t38*t90*t91*t92+1.0d+0*t70*(-8.266666666
     :           666665d-3*gammabb*t135*t6*t9+2.562666666666666d-5*gamma
     ;           bb*t123*t135*t4*t9+3.1d-3*t4*t6*(-8.266666666666665d-3*
     <           gammabb*t135*t6*t8+2.562666666666666d-5*gammabb*t123*t1
     =           35*t4*t8+3.1d-3*t4*t6*(-8.266666666666665d-3*gammabb*t1
     >           35*t6*t7+2.562666666666666d-5*gammabb*t123*t135*t4*t7+3
     ?           .1d-3*t4*t6*(2.562666666666666d-5*gammabb*t1*t123*t135*
     @           t4-8.266666666666665d-3*gammabb*t1*t135*t6))))+1.0d+0*t
     1           10*(t69+t39*(2.3923187454478842d-1*t116*t44*t48*t65*t68
     2           -5.980796863619711d-2*t132*t43*t44*t65*t68+1.9751631321
     3           680768d-2*(t134+t133+1.923661050931536d+0*t132+t115)*t5
     4           9*t63-6.21814d-2*(t134+t133+t115)*t41*t57+t121+t120+t11
     5           9+t118+t105+t104+t103)+t64+t58+6.903522198342671d-18*t3
     6           6*t37+3.1090699999999993d-2*t32*t33-rhob*t131))*wght+Am
     7           at(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*t70*(3.1d-3*t2*t6*t9-9.61d-6*t12
     1           3*t2*t4*t9+3.1d-3*t4*t6*(3.1d-3*t2*t6*t8-9.61d-6*t123*t
     2           2*t4*t8+3.1d-3*t4*t6*(3.1d-3*t2*t6*t7-9.61d-6*t123*t2*t
     3           4*t7+3.1d-3*t4*t6*(3.1d-3*t1*t2*t6-9.61d-6*t1*t123*t2*t
     4           4))))+t82*(5.0d-1*rhoa*t24*(6.0d-2*t2*t73*t80-3.6d-3*ga
     5           mmaaa*t125*t139*t80+6.0d-2*gammaaa*t2*t73*(6.0d-2*t2*t7
     6           3*t79-3.6d-3*gammaaa*t125*t139*t79+6.0d-2*gammaaa*t2*t7
     7           3*(6.0d-2*t2*t73*t78-3.6d-3*gammaaa*t125*t139*t78+6.0d-
     8           2*gammaaa*t2*t73*(6.0d-2*t2*t73*t77-3.6d-3*gammaaa*t125
     9           *t139*t77))))*t84-1.25d-1*t24*t81))*wght+Cmat(iq,D1_GAA
     :           )
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t91*(5.0d-1*rhob*t38*(6.0d-2*t3*t86*t89
     1           -3.6d-3*gammabb*t137*t140*t89+6.0d-2*gammabb*t3*t86*(6.
     2           0d-2*t3*t86*t88-3.6d-3*gammabb*t137*t140*t88+6.0d-2*gam
     3           mabb*t3*t86*(6.0d-2*t3*t86*t87-3.6d-3*gammabb*t137*t140
     4           *t87+6.0d-2*gammabb*t3*t86*(6.0d-2*t3*t77*t86-3.6d-3*ga
     5           mmabb*t137*t140*t77))))*t93-1.25d-1*t38*t90)+1.0d+0*t70
     6           *(3.1d-3*t3*t6*t9-9.61d-6*t123*t3*t4*t9+3.1d-3*t4*t6*(3
     7           .1d-3*t3*t6*t8-9.61d-6*t123*t3*t4*t8+3.1d-3*t4*t6*(3.1d
     8           -3*t3*t6*t7-9.61d-6*t123*t3*t4*t7+3.1d-3*t4*t6*(3.1d-3*
     9           t1*t3*t6-9.61d-6*t1*t123*t3*t4)))))*wght+Cmat(iq,D1_GBB
     :           )
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t24*t81*t82-5.0d-1*rhoa*t24*
     1           t81*t84/taua**2)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t38*t90*t91-5.0d-1*rhob*t38*
     1           t90*t93/taub**2)*wght+Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhoa**2.6666666666666666d+0
              t28 = gammaaa*t27+4.0d-50*t2
              t29 = 3.1d-3*t28+1.0d+0
              t30 = 1/t29
              t31 = param(5)
              t32 = 3.1d-3*t28*t30*t31+param(4)
              t33 = 3.1d-3*t28*t30*t32+param(3)
              t34 = 3.1d-3*t28*t30*t33+param(2)
              t35 = 3.1d-3*t28*t30*t34+param(1)
              t36 = 1/rhoa**6.666666666666666d-1
              t37 = rhoa**5.0d-1
              t38 = 1/t37
              t39 = 1/rhoa**3.333333333333333d-1
              t40 = 1/rhoa**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhoa*t49-rhob*t26
              t82 = 6.0d-2*gammaaa*t27+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammaaa*t27*t8*t83+t7
              t85 = 6.0d-2*gammaaa*t27*t83*t84+t6
              t86 = 6.0d-2*gammaaa*t27*t83*t85+t5
              t87 = 6.0d-2*gammaaa*t27*t83*t86+t1
              t88 = 1/taua
              t89 = 1/rhoa
              t90 = 2.0d+0*taua-2.5d-1*gammaaa*t89
              t91 = 1/rhoa**1.6666666666666669d+0
              t92 = 1/t37**3
              t93 = 1/rhoa**1.3333333333333333d+0
              t94 = 1/rhoa**1.1666666666666667d+0
              t95 = 1.1102230246251565d-16*t48*(-9.970917392951799d-1*t9
     1           4-7.418564737168958d-1*t93-4.002143174996817d-1*t92-1.2
     2           64669550498372d-1*t91)/(t45**2*t46)+1.0d+0*t44*(-1.8533
     3           958105157808d+0*t94-1.2815820791490704d+0*t93-8.2236688
     4           77838045d-1*t92-1.6039141941921276d-1*t91)/(t41**2*t42)
     5           +3.0506411443514264d-19*t47*t93+1.3210398931339265d-3*t
     6           43*t93
              t96 = 1/t50**1.6666666666666669d+0
              t97 = 1/t63**3
              t98 = 1/t50**1.3333333333333333d+0
              t99 = 1/t50**1.1666666666666667d+0
              t100 = 1.0d+0*t52*t61*(-9.970917392951799d-1*t99-7.4185647
     1           37168958d-1*t98-4.002143174996817d-1*t97-1.264669550498
     2           372d-1*t96)/(t66**2*t67)
              t101 = -5.848223622634647d-1*t70*t71*(-1.3595691172479402d
     1           +0*t99-7.491972878592053d-1*t98-2.1504862356383217d-1*t
     2           97-1.2743417300848914d-1*t96)/(t72**2*t73)
              t102 = 1.923661050931536d+0*t54*t55*t59*t76*(-1.8533958105
     1           157808d+0*t99-1.2815820791490704d+0*t98-8.2236688778380
     2           45d-1*t97-1.6039141941921276d-1*t96)/(t77**2*t78)
              t103 = 1/t50**2
              t104 = t103*t53
              t105 = -t56
              t106 = t57**3.333333333333333d-1
              t107 = -t103*t53
              t108 = t58**3.333333333333333d-1
              t109 = 1.3333333333333333d+0*t108*(t56+t107)+1.33333333333
     1           33333d+0*(t105+t104)*t106
              t110 = -1.923661050931536d+0*t109*t54*t55
              t111 = 1/t50**5
              t112 = 7.694644203726144d+0*t111*t54*t59
              t113 = t53**3
              t114 = -7.694644203726144d+0*t113*t55*t59
              t115 = 2.747773264188437d-3*t61*t68*t98
              t116 = -4.5437964274821163d-4*t71*t74*t98
              t117 = 2.541232989148493d-3*t54*t59*t79/t50**5.33333333333
     1           3333d+0
              t118 = 2.3923187454478842d-1*t111*t54*t59*t76*t79
              t119 = 1/rhoa**3.6666666666666664d+0
              t120 = 1/t29**2
              t121 = gammaaa**2
              t122 = 1/t82**2
              t123 = 1/rhoa**6.333333333333333d+0
              t124 = 1/t14**3
              t125 = 1/rhob**1.3333333333333333d+0
              t126 = 1/rhob**1.1666666666666667d+0
              t127 = 1.1102230246251565d-16*(-1.264669550498372d-1*t2-9.
     1           970917392951799d-1*t126-7.418564737168958d-1*t125-4.002
     2           143174996817d-1*t124)*t25/(t22**2*t23)+3.05064114435142
     3           64d-19*t125*t24+1.0d+0*(-1.6039141941921276d-1*t2-1.853
     4           3958105157808d+0*t126-1.2815820791490704d+0*t125-8.2236
     5           68877838045d-1*t124)*t21/(t18**2*t19)+1.321039893133926
     6           5d-3*t125*t20
              t128 = 1/t3**2
              t129 = 1/rhob**4.333333333333333d+0
              t130 = 1/rhob**2.6666666666666666d+0
              t131 = 1.3333333333333333d+0*t106*(t56+t104)+1.33333333333
     1           33333d+0*(t107+t105)*t108
              t132 = -1.923661050931536d+0*t131*t54*t55
              t133 = 7.694644203726144d+0*t113*t55*t59
              t134 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhoa*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhob*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t88*(5.0d-1*rhoa*t87*t90*t95+5.0d-1*t49*
     1           t87*t90+5.0d-1*rhoa*t49*(-1.5999999999999998d-1*gammaaa
     2           *t119*t83*t86+9.599999999999997d-3*t121*t122*t123*t86+6
     3           .0d-2*gammaaa*t27*t83*(-1.5999999999999998d-1*gammaaa*t
     4           119*t83*t85+9.599999999999997d-3*t121*t122*t123*t85+6.0
     5           d-2*gammaaa*t27*t83*(-1.5999999999999998d-1*gammaaa*t11
     6           9*t83*t84+9.599999999999997d-3*t121*t122*t123*t84+6.0d-
     7           2*gammaaa*t27*t83*(9.599999999999997d-3*t121*t122*t123*
     8           t8-1.5999999999999998d-1*gammaaa*t119*t8*t83))))*t90)+1
     9           .0d+0*t35*(-rhoa*t95+t80+t50*(-2.3923187454478842d-1*t1
     :           13*t55*t59*t76*t79-5.980796863619711d-2*t109*t54*t55*t7
     ;           6*t79+1.9751631321680768d-2*(t114+t112+t110+1.923661050
     <           931536d+0*t109)*t70*t74-6.21814d-2*(t114+t112+t110)*t52
     =           *t68+t118+t117+t116+t115+t102+t101+t100)+t75+t69+6.9035
     >           22198342671d-18*t47*t48+3.1090699999999993d-2*t43*t44)+
     ?           1.25d-1*gammaaa*t49*t87*t88*t89+1.0d+0*(-8.266666666666
     @           665d-3*gammaaa*t119*t30*t34+2.562666666666666d-5*gammaa
     1           a*t119*t120*t28*t34+3.1d-3*t28*t30*(-8.266666666666665d
     2           -3*gammaaa*t119*t30*t33+2.562666666666666d-5*gammaaa*t1
     3           19*t120*t28*t33+3.1d-3*t28*t30*(-8.266666666666665d-3*g
     4           ammaaa*t119*t30*t32+2.562666666666666d-5*gammaaa*t119*t
     5           120*t28*t32+3.1d-3*t28*t30*(2.562666666666666d-5*gammaa
     6           a*t119*t120*t28*t31-8.266666666666665d-3*gammaaa*t119*t
     7           30*t31))))*t81)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (5.0d-1*rhob*t26*(2.4d-51*t2*t4*(2.4d-51*
     1           t2*t4*(-4.0d-51*t130*t4*t9+9.6d-102*t128*t129*t9+2.4d-5
     2           1*t2*t4*(9.6d-102*t128*t129*t8-4.0d-51*t130*t4*t8))-4.0
     3           d-51*t10*t130*t4+9.6d-102*t10*t128*t129)-4.0d-51*t11*t1
     4           30*t4+9.6d-102*t11*t128*t129)+1.0d+0*(-2.06666666666666
     5           67d-52*t130*t30*t34+6.406666666666666d-55*t120*t130*t28
     6           *t34+3.1d-3*t28*t30*(-2.0666666666666667d-52*t130*t30*t
     7           33+6.406666666666666d-55*t120*t130*t28*t33+3.1d-3*t28*t
     8           30*(-2.0666666666666667d-52*t130*t30*t32+6.406666666666
     9           666d-55*t120*t130*t28*t32+3.1d-3*t28*t30*(6.40666666666
     :           6666d-55*t120*t130*t28*t31-2.0666666666666667d-52*t130*
     ;           t30*t31))))*t81+1.0d+0*t35*(t80+t50*(2.3923187454478842
     <           d-1*t113*t55*t59*t76*t79-5.980796863619711d-2*t131*t54*
     =           t55*t76*t79+1.9751631321680768d-2*(t133+t132+1.92366105
     >           0931536d+0*t131+t112)*t70*t74-6.21814d-2*(t133+t132+t11
     ?           2)*t52*t68+t118+t117+t116+t115+t102+t101+t100)+t75+t69+
     @           6.903522198342671d-18*t24*t25+3.1090699999999993d-2*t20
     1           *t21-rhob*t127)+5.0d-1*t12*t26+5.0d-1*rhob*t12*t127)*wg
     2           ht+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t88*(5.0d-1*rhoa*t49*(6.0d-2*t27*t83*t8
     1           6-3.6d-3*gammaaa*t122*t134*t86+6.0d-2*gammaaa*t27*t83*(
     2           6.0d-2*t27*t83*t85-3.6d-3*gammaaa*t122*t134*t85+6.0d-2*
     3           gammaaa*t27*t83*(6.0d-2*t27*t83*t84-3.6d-3*gammaaa*t122
     4           *t134*t84+6.0d-2*gammaaa*t27*t83*(6.0d-2*t27*t8*t83-3.6
     5           d-3*gammaaa*t122*t134*t8))))*t90-1.25d-1*t49*t87)+1.0d+
     6           0*(3.1d-3*t27*t30*t34-9.61d-6*t120*t27*t28*t34+3.1d-3*t
     7           28*t30*(3.1d-3*t27*t30*t33-9.61d-6*t120*t27*t28*t33+3.1
     8           d-3*t28*t30*(3.1d-3*t27*t30*t32-9.61d-6*t120*t27*t28*t3
     9           2+3.1d-3*t28*t30*(3.1d-3*t27*t30*t31-9.61d-6*t120*t27*t
     :           28*t31))))*t81)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t49*t87*t88-5.0d-1*rhoa*t49*
     1           t87*t90/taua**2)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = param(5)
              t28 = 1/rhob**2.6666666666666666d+0
              t29 = gammabb*t28+4.0d-50*t2
              t30 = 3.1d-3*t29+1.0d+0
              t31 = 1/t30
              t32 = 3.1d-3*t27*t29*t31+param(4)
              t33 = 3.1d-3*t29*t31*t32+param(3)
              t34 = 3.1d-3*t29*t31*t33+param(2)
              t35 = 3.1d-3*t29*t31*t34+param(1)
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhob*t49-rhoa*t26
              t82 = 6.0d-2*gammabb*t28+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammabb*t28*t8*t83+t7
              t85 = 6.0d-2*gammabb*t28*t83*t84+t6
              t86 = 6.0d-2*gammabb*t28*t83*t85+t5
              t87 = 6.0d-2*gammabb*t28*t83*t86+t1
              t88 = 1/taub
              t89 = 1/rhob
              t90 = 2.0d+0*taub-2.5d-1*gammabb*t89
              t91 = 1/t14**3
              t92 = 1/rhoa**1.3333333333333333d+0
              t93 = 1/rhoa**1.1666666666666667d+0
              t94 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t9
     1           3-7.418564737168958d-1*t92-4.002143174996817d-1*t91-1.2
     2           64669550498372d-1*t2)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t93-1.2815820791490704d+0*t92-8.22366887
     4           7838045d-1*t91-1.6039141941921276d-1*t2)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t92+1.3210398931339265d-3*t20
     6           *t92
              t95 = 1/t3**2
              t96 = 1/rhoa**4.333333333333333d+0
              t97 = 1/rhoa**2.6666666666666666d+0
              t98 = 1/t50**1.6666666666666669d+0
              t99 = 1/t63**3
              t100 = 1/t50**1.3333333333333333d+0
              t101 = 1/t50**1.1666666666666667d+0
              t102 = 1.0d+0*t52*t61*(-4.002143174996817d-1*t99-1.2646695
     1           50498372d-1*t98-9.970917392951799d-1*t101-7.41856473716
     2           8958d-1*t100)/(t66**2*t67)
              t103 = -5.848223622634647d-1*t70*t71*(-2.1504862356383217d
     1           -1*t99-1.2743417300848914d-1*t98-1.3595691172479402d+0*
     2           t101-7.491972878592053d-1*t100)/(t72**2*t73)
              t104 = 1.923661050931536d+0*t54*t55*t59*t76*(-8.2236688778
     1           38045d-1*t99-1.6039141941921276d-1*t98-1.85339581051578
     2           08d+0*t101-1.2815820791490704d+0*t100)/(t77**2*t78)
              t105 = 1/t50**2
              t106 = t105*t53
              t107 = -t56
              t108 = t57**3.333333333333333d-1
              t109 = -t105*t53
              t110 = t58**3.333333333333333d-1
              t111 = 1.3333333333333333d+0*t110*(t56+t109)+1.33333333333
     1           33333d+0*(t107+t106)*t108
              t112 = -1.923661050931536d+0*t111*t54*t55
              t113 = 1/t50**5
              t114 = 7.694644203726144d+0*t113*t54*t59
              t115 = t53**3
              t116 = -7.694644203726144d+0*t115*t55*t59
              t117 = 2.747773264188437d-3*t100*t61*t68
              t118 = -4.5437964274821163d-4*t100*t71*t74
              t119 = 2.541232989148493d-3*t54*t59*t79/t50**5.33333333333
     1           3333d+0
              t120 = 2.3923187454478842d-1*t113*t54*t59*t76*t79
              t121 = 1/t30**2
              t122 = 1/rhob**1.6666666666666669d+0
              t123 = 1/t37**3
              t124 = 1/rhob**1.3333333333333333d+0
              t125 = 1/rhob**1.1666666666666667d+0
              t126 = 1.1102230246251565d-16*(-9.970917392951799d-1*t125-
     1           7.418564737168958d-1*t124-4.002143174996817d-1*t123-1.2
     2           64669550498372d-1*t122)*t48/(t45**2*t46)+3.050641144351
     3           4264d-19*t124*t47+1.0d+0*(-1.8533958105157808d+0*t125-1
     4           .2815820791490704d+0*t124-8.223668877838045d-1*t123-1.6
     5           039141941921276d-1*t122)*t44/(t41**2*t42)+1.32103989313
     6           39265d-3*t124*t43
              t127 = 1.3333333333333333d+0*t108*(t56+t106)+1.33333333333
     1           33333d+0*(t109+t107)*t110
              t128 = -1.923661050931536d+0*t127*t54*t55
              t129 = 7.694644203726144d+0*t115*t55*t59
              t130 = 1/rhob**3.6666666666666664d+0
              t131 = gammabb**2
              t132 = 1/t82**2
              t133 = 1/rhob**6.333333333333333d+0
              t134 = 1/rhob**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhoa*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t26*(2.4d-51*t2*t4*(2.4d-51*
     1           t2*t4*(2.4d-51*t2*t4*(9.6d-102*t8*t95*t96-4.0d-51*t4*t8
     2           *t97)-4.0d-51*t4*t9*t97+9.6d-102*t9*t95*t96)-4.0d-51*t1
     3           0*t4*t97+9.6d-102*t10*t95*t96)-4.0d-51*t11*t4*t97+9.6d-
     4           102*t11*t95*t96)+1.0d+0*t81*(3.1d-3*t29*t31*(3.1d-3*t29
     5           *t31*(3.1d-3*t29*t31*(6.406666666666666d-55*t121*t27*t2
     6           9*t97-2.0666666666666667d-52*t27*t31*t97)-2.06666666666
     7           66667d-52*t31*t32*t97+6.406666666666666d-55*t121*t29*t3
     8           2*t97)-2.0666666666666667d-52*t31*t33*t97+6.40666666666
     9           6666d-55*t121*t29*t33*t97)-2.0666666666666667d-52*t31*t
     :           34*t97+6.406666666666666d-55*t121*t29*t34*t97)+1.0d+0*t
     ;           35*(-rhoa*t94+t80+t50*(-2.3923187454478842d-1*t115*t55*
     <           t59*t76*t79-5.980796863619711d-2*t111*t54*t55*t76*t79+1
     =           .9751631321680768d-2*(t116+t114+t112+1.923661050931536d
     >           +0*t111)*t70*t74-6.21814d-2*(t116+t114+t112)*t52*t68+t1
     ?           20+t119+t118+t117+t104+t103+t102)+t75+t69+6.90352219834
     @           2671d-18*t24*t25+3.1090699999999993d-2*t20*t21)+5.0d-1*
     1           rhoa*t12*t94+5.0d-1*t12*t26)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t88*(5.0d-1*t49*t87*t90+5.0d-1*rhob*t126
     1           *t87*t90+5.0d-1*rhob*t49*(-1.5999999999999998d-1*gammab
     2           b*t130*t83*t86+9.599999999999997d-3*t131*t132*t133*t86+
     3           6.0d-2*gammabb*t28*t83*(-1.5999999999999998d-1*gammabb*
     4           t130*t83*t85+9.599999999999997d-3*t131*t132*t133*t85+6.
     5           0d-2*gammabb*t28*t83*(-1.5999999999999998d-1*gammabb*t1
     6           30*t83*t84+9.599999999999997d-3*t131*t132*t133*t84+6.0d
     7           -2*gammabb*t28*t83*(9.599999999999997d-3*t131*t132*t133
     8           *t8-1.5999999999999998d-1*gammabb*t130*t8*t83))))*t90)+
     9           1.25d-1*gammabb*t49*t87*t88*t89+1.0d+0*(-8.266666666666
     :           665d-3*gammabb*t130*t31*t34+2.562666666666666d-5*gammab
     ;           b*t121*t130*t29*t34+3.1d-3*t29*t31*(-8.266666666666665d
     <           -3*gammabb*t130*t31*t33+2.562666666666666d-5*gammabb*t1
     =           21*t130*t29*t33+3.1d-3*t29*t31*(-8.266666666666665d-3*g
     >           ammabb*t130*t31*t32+2.562666666666666d-5*gammabb*t121*t
     ?           130*t29*t32+3.1d-3*t29*t31*(2.562666666666666d-5*gammab
     @           b*t121*t130*t27*t29-8.266666666666665d-3*gammabb*t130*t
     1           27*t31))))*t81+1.0d+0*t35*(t80+t50*(2.3923187454478842d
     2           -1*t115*t55*t59*t76*t79-5.980796863619711d-2*t127*t54*t
     3           55*t76*t79+1.9751631321680768d-2*(t129+t128+1.923661050
     4           931536d+0*t127+t114)*t70*t74-6.21814d-2*(t129+t128+t114
     5           )*t52*t68+t120+t119+t118+t117+t104+t103+t102)+t75+t69+6
     6           .903522198342671d-18*t47*t48+3.1090699999999993d-2*t43*
     7           t44-rhob*t126))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t88*(5.0d-1*rhob*t49*(6.0d-2*t28*t83*t8
     1           6-3.6d-3*gammabb*t132*t134*t86+6.0d-2*gammabb*t28*t83*(
     2           6.0d-2*t28*t83*t85-3.6d-3*gammabb*t132*t134*t85+6.0d-2*
     3           gammabb*t28*t83*(6.0d-2*t28*t83*t84-3.6d-3*gammabb*t132
     4           *t134*t84+6.0d-2*gammabb*t28*t83*(6.0d-2*t28*t8*t83-3.6
     5           d-3*gammabb*t132*t134*t8))))*t90-1.25d-1*t49*t87)+1.0d+
     6           0*(3.1d-3*t28*t31*t34-9.61d-6*t121*t28*t29*t34+3.1d-3*t
     7           29*t31*(3.1d-3*t28*t31*t33-9.61d-6*t121*t28*t29*t33+3.1
     8           d-3*t29*t31*(3.1d-3*t28*t31*t32-9.61d-6*t121*t28*t29*t3
     9           2+3.1d-3*t29*t31*(3.1d-3*t27*t28*t31-9.61d-6*t121*t27*t
     :           28*t29))))*t81)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t49*t87*t88-5.0d-1*rhob*t49*
     1           t87*t90/taub**2)*wght+Mmat(iq,D1_TB)
            else 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.4d-51*t27+1.0d+0
              t29 = 1/t28
              t30 = 2.4d-51*t27*t29*t8+t7
              t31 = t6+2.4d-51*t27*t29*t30
              t32 = t5+2.4d-51*t27*t29*t31
              t33 = 2.4d-51*t27*t29*t32+t1
              t34 = 1/rhob**6.666666666666666d-1
              t35 = rhob**5.0d-1
              t36 = 1/t35
              t37 = 1/rhob**3.333333333333333d-1
              t38 = 1/rhob**1.6666666666666666d-1
              t39 = 1.1120374863094686d+1*t38+3.8447462374472113d+0*t37+
     1           1.644733775567609d+0*t36+2.4058712912881916d-1*t34
              t40 = 3.216395899738507d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.274696188700087d-1*t37+1.0d+0
              t43 = 5.982550435771079d+0*t38+2.2255694211506874d+0*t37+8
     1           .004286349993635d-1*t36+1.8970043257475583d-1*t34
              t44 = 1.6081979498692536d+1/t43+1.0d+0
              t45 = log(t44)
              t46 = 1.3256889990520176d-1*t37+1.0d+0
              t47 = -6.903522198342671d-18*t45*t46-3.1090699999999993d-2
     1           *t41*t42
              t48 = 4.0d-50*t27+4.0d-50*t2
              t49 = 3.1d-3*t48+1.0d+0
              t50 = 1/t49
              t51 = param(5)
              t52 = 3.1d-3*t48*t50*t51+param(4)
              t53 = 3.1d-3*t48*t50*t52+param(3)
              t54 = 3.1d-3*t48*t50*t53+param(2)
              t55 = 3.1d-3*t48*t50*t54+param(1)
              t56 = rhob+rhoa
              t57 = 1/t56**3.333333333333333d-1
              t58 = 1.3256889990520176d-1*t57+1.0d+0
              t59 = rhoa-rhob
              t60 = t59**4
              t61 = 1/t56**4
              t62 = 1/t56
              t63 = 1.0d+0-t59*t62
              t64 = t59*t62+1.0d+0
              t65 = t64**1.3333333333333333d+0+t63**1.3333333333333333d+
     1           0-2.0d+0
              t66 = -1.923661050931536d+0*t60*t61*t65
              t67 = t66+1.0d+0
              t68 = 1/t56**6.666666666666666d-1
              t69 = t56**5.0d-1
              t70 = 1/t69
              t71 = 1/t56**1.6666666666666666d-1
              t72 = 5.982550435771079d+0*t71+8.004286349993635d-1*t70+1.
     1           8970043257475583d-1*t68+2.2255694211506874d+0*t57
              t73 = 1.6081979498692536d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = -6.21814d-2*t58*t67*t74
              t76 = 6.901399211255825d-2*t57+1.0d+0
              t77 = t66+1.923661050931536d+0*t65
              t78 = 8.157414703487641d+0*t71+4.3009724712766434d-1*t70+1
     1           .9115125951273373d-1*t68+2.247591863577616d+0*t57
              t79 = 2.9608813203268075d+1/t78+1.0d+0
              t80 = log(t79)
              t81 = 1.9751631321680768d-2*t76*t77*t80
              t82 = 1.274696188700087d-1*t57+1.0d+0
              t83 = 1.1120374863094686d+1*t71+1.644733775567609d+0*t70+2
     1           .4058712912881916d-1*t68+3.8447462374472113d+0*t57
              t84 = 3.216395899738507d+1/t83+1.0d+0
              t85 = log(t84)
              t86 = -5.980796863619711d-2*t60*t61*t65*t82*t85
              t87 = t56*(t86+t81+t75)-rhob*t47-rhoa*t26
              t88 = 1/t14**3
              t89 = 1/rhoa**1.3333333333333333d+0
              t90 = 1/rhoa**1.1666666666666667d+0
              t91 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t9
     1           0-7.418564737168958d-1*t89-4.002143174996817d-1*t88-1.2
     2           64669550498372d-1*t2)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t90-1.2815820791490704d+0*t89-8.22366887
     4           7838045d-1*t88-1.6039141941921276d-1*t2)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t89+1.3210398931339265d-3*t20
     6           *t89
              t92 = 1/t3**2
              t93 = 1/rhoa**4.333333333333333d+0
              t94 = 1/rhoa**2.6666666666666666d+0
              t95 = 1/t56**1.6666666666666669d+0
              t96 = 1/t69**3
              t97 = 1/t56**1.3333333333333333d+0
              t98 = 1/t56**1.1666666666666667d+0
              t99 = 1.0d+0*t58*t67*(-9.970917392951799d-1*t98-7.41856473
     1           7168958d-1*t97-4.002143174996817d-1*t96-1.2646695504983
     2           72d-1*t95)/(t72**2*t73)
              t100 = -5.848223622634647d-1*t76*t77*(-1.3595691172479402d
     1           +0*t98-7.491972878592053d-1*t97-2.1504862356383217d-1*t
     2           96-1.2743417300848914d-1*t95)/(t78**2*t79)
              t101 = 1.923661050931536d+0*t60*t61*t65*t82*(-1.8533958105
     1           157808d+0*t98-1.2815820791490704d+0*t97-8.2236688778380
     2           45d-1*t96-1.6039141941921276d-1*t95)/(t83**2*t84)
              t102 = 1/t56**2
              t103 = t102*t59
              t104 = -t62
              t105 = t63**3.333333333333333d-1
              t106 = -t102*t59
              t107 = t64**3.333333333333333d-1
              t108 = 1.3333333333333333d+0*t107*(t62+t106)+1.33333333333
     1           33333d+0*(t104+t103)*t105
              t109 = -1.923661050931536d+0*t108*t60*t61
              t110 = 1/t56**5
              t111 = 7.694644203726144d+0*t110*t60*t65
              t112 = t59**3
              t113 = -7.694644203726144d+0*t112*t61*t65
              t114 = 2.747773264188437d-3*t67*t74*t97
              t115 = -4.5437964274821163d-4*t77*t80*t97
              t116 = 2.541232989148493d-3*t60*t65*t85/t56**5.33333333333
     1           3333d+0
              t117 = 2.3923187454478842d-1*t110*t60*t65*t82*t85
              t118 = 1/t49**2
              t119 = 1/t35**3
              t120 = 1/rhob**1.3333333333333333d+0
              t121 = 1/rhob**1.1666666666666667d+0
              t122 = 1.1102230246251565d-16*(-1.264669550498372d-1*t27-9
     1           .970917392951799d-1*t121-7.418564737168958d-1*t120-4.00
     2           2143174996817d-1*t119)*t46/(t43**2*t44)+3.0506411443514
     3           264d-19*t120*t45+1.0d+0*(-1.6039141941921276d-1*t27-1.8
     4           533958105157808d+0*t121-1.2815820791490704d+0*t120-8.22
     5           3668877838045d-1*t119)*t42/(t39**2*t40)+1.3210398931339
     6           265d-3*t120*t41
              t123 = 1/t28**2
              t124 = 1/rhob**4.333333333333333d+0
              t125 = 1/rhob**2.6666666666666666d+0
              t126 = 1.3333333333333333d+0*t105*(t62+t103)+1.33333333333
     1           33333d+0*(t106+t104)*t107
              t127 = -1.923661050931536d+0*t126*t60*t61
              t128 = 7.694644203726144d+0*t112*t61*t65
              fnc(iq) = (1.0d+0*t55*t87+5.0d-1*rhob*t33*t47+5.0d-1*rhoa*
     1           t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t55*(t56*(t99-2.3923187454478842d
     1           -1*t112*t61*t65*t82*t85-5.980796863619711d-2*t108*t60*t
     2           61*t82*t85+1.9751631321680768d-2*(t113+t111+t109+1.9236
     3           61050931536d+0*t108)*t76*t80-6.21814d-2*(t113+t111+t109
     4           )*t58*t74+t117+t116+t115+t114+t101+t100)-rhoa*t91+t86+t
     5           81+t75+6.903522198342671d-18*t24*t25+3.1090699999999993
     6           d-2*t20*t21)+5.0d-1*rhoa*t26*(2.4d-51*t2*t4*(2.4d-51*t2
     7           *t4*(2.4d-51*t2*t4*(9.6d-102*t8*t92*t93-4.0d-51*t4*t8*t
     8           94)-4.0d-51*t4*t9*t94+9.6d-102*t9*t92*t93)-4.0d-51*t10*
     9           t4*t94+9.6d-102*t10*t92*t93)-4.0d-51*t11*t4*t94+9.6d-10
     :           2*t11*t92*t93)+1.0d+0*t87*(3.1d-3*t48*t50*(3.1d-3*t48*t
     ;           50*(3.1d-3*t48*t50*(6.406666666666666d-55*t118*t48*t51*
     <           t94-2.0666666666666667d-52*t50*t51*t94)-2.0666666666666
     =           667d-52*t50*t52*t94+6.406666666666666d-55*t118*t48*t52*
     >           t94)-2.0666666666666667d-52*t50*t53*t94+6.4066666666666
     ?           66d-55*t118*t48*t53*t94)-2.0666666666666667d-52*t50*t54
     @           *t94+6.406666666666666d-55*t118*t48*t54*t94)+5.0d-1*rho
     1           a*t12*t91+5.0d-1*t12*t26)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t55*(t56*(t99+2.3923187454478842d
     1           -1*t112*t61*t65*t82*t85-5.980796863619711d-2*t126*t60*t
     2           61*t82*t85+1.9751631321680768d-2*(t128+t127+1.923661050
     3           931536d+0*t126+t111)*t76*t80-6.21814d-2*(t128+t127+t111
     4           )*t58*t74+t117+t116+t115+t114+t101+t100)+t86+t81+t75+6.
     5           903522198342671d-18*t45*t46+3.1090699999999993d-2*t41*t
     6           42-rhob*t122)+1.0d+0*(-2.0666666666666667d-52*t125*t50*
     7           t54+6.406666666666666d-55*t118*t125*t48*t54+3.1d-3*t48*
     8           t50*(-2.0666666666666667d-52*t125*t50*t53+6.40666666666
     9           6666d-55*t118*t125*t48*t53+3.1d-3*t48*t50*(-2.066666666
     :           6666667d-52*t125*t50*t52+6.406666666666666d-55*t118*t12
     ;           5*t48*t52+3.1d-3*t48*t50*(6.406666666666666d-55*t118*t1
     <           25*t48*t51-2.0666666666666667d-52*t125*t50*t51))))*t87+
     =           5.0d-1*rhob*t47*(2.4d-51*t27*t29*(2.4d-51*t27*t29*(2.4d
     >           -51*t27*t29*(9.6d-102*t123*t124*t8-4.0d-51*t125*t29*t8)
     ?           -4.0d-51*t125*t29*t30+9.6d-102*t123*t124*t30)-4.0d-51*t
     @           125*t29*t31+9.6d-102*t123*t124*t31)-4.0d-51*t125*t29*t3
     1           2+9.6d-102*t123*t124*t32)+5.0d-1*t33*t47+5.0d-1*rhob*t1
     2           22*t33)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/rhoa**1.6666666666666669d+0
              t27 = 1/t10**3
              t28 = 1/rhoa**1.3333333333333333d+0
              t29 = 1/rhoa**1.1666666666666667d+0
              t30 = gammaaa**2
              t31 = 1/t2**2
              t32 = 1/rhoa**6.333333333333333d+0
              t33 = 1/rhoa**3.6666666666666664d+0
              t34 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*(1.1102230246251565d
     1           -16*t21*(-9.970917392951799d-1*t29-7.418564737168958d-1
     2           *t28-4.002143174996817d-1*t27-1.264669550498372d-1*t26)
     3           /(t18**2*t19)+1.0d+0*t17*(-1.8533958105157808d+0*t29-1.
     4           2815820791490704d+0*t28-8.223668877838045d-1*t27-1.6039
     5           141941921276d-1*t26)/(t14**2*t15)+3.0506411443514264d-1
     6           9*t20*t28+1.3210398931339265d-3*t16*t28)*t8*wght+5.0d-1
     7           *t22*t25*t8*wght+5.0d-1*rhoa*t22*t25*(-1.59999999999999
     8           98d-1*gammaaa*t3*t33*t7+9.599999999999997d-3*t30*t31*t3
     9           2*t7+6.0d-2*gammaaa*t1*t3*(-1.5999999999999998d-1*gamma
     :           aa*t3*t33*t6+9.599999999999997d-3*t30*t31*t32*t6+6.0d-2
     ;           *gammaaa*t1*t3*(-1.5999999999999998d-1*gammaaa*t3*t33*t
     <           5+9.599999999999997d-3*t30*t31*t32*t5+6.0d-2*gammaaa*t1
     =           *t3*(9.599999999999997d-3*t30*t31*t32*t4-1.599999999999
     >           9998d-1*gammaaa*t3*t33*t4))))*wght)+1.25d-1*gammaaa*t22
     ?           *t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*(-3.6d-3*gammaa
     1           a*t31*t34*t7+6.0d-2*t1*t3*t7+6.0d-2*gammaaa*t1*t3*(-3.6
     2           d-3*gammaaa*t31*t34*t6+6.0d-2*t1*t3*t6+6.0d-2*gammaaa*t
     3           1*t3*(-3.6d-3*gammaaa*t31*t34*t5+6.0d-2*t1*t3*t5+6.0d-2
     4           *gammaaa*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t31*t34*
     5           t4))))*wght-1.25d-1*t22*t8*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t8*wght/taua**2+1.0d
     1           +0*rhoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/rhoa**1.6666666666666669d+0
              t27 = 1/t10**3
              t28 = 1/rhoa**1.3333333333333333d+0
              t29 = 1/rhoa**1.1666666666666667d+0
              t30 = gammaaa**2
              t31 = 1/t2**2
              t32 = 1/rhoa**6.333333333333333d+0
              t33 = 1/rhoa**3.6666666666666664d+0
              t34 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*(1.1102230246251565d
     1           -16*t21*(-9.970917392951799d-1*t29-7.418564737168958d-1
     2           *t28-4.002143174996817d-1*t27-1.264669550498372d-1*t26)
     3           /(t18**2*t19)+1.0d+0*t17*(-1.8533958105157808d+0*t29-1.
     4           2815820791490704d+0*t28-8.223668877838045d-1*t27-1.6039
     5           141941921276d-1*t26)/(t14**2*t15)+3.0506411443514264d-1
     6           9*t20*t28+1.3210398931339265d-3*t16*t28)*t8*wght+5.0d-1
     7           *t22*t25*t8*wght+5.0d-1*rhoa*t22*t25*(-1.59999999999999
     8           98d-1*gammaaa*t3*t33*t7+9.599999999999997d-3*t30*t31*t3
     9           2*t7+6.0d-2*gammaaa*t1*t3*(-1.5999999999999998d-1*gamma
     :           aa*t3*t33*t6+9.599999999999997d-3*t30*t31*t32*t6+6.0d-2
     ;           *gammaaa*t1*t3*(-1.5999999999999998d-1*gammaaa*t3*t33*t
     <           5+9.599999999999997d-3*t30*t31*t32*t5+6.0d-2*gammaaa*t1
     =           *t3*(9.599999999999997d-3*t30*t31*t32*t4-1.599999999999
     >           9998d-1*gammaaa*t3*t33*t4))))*wght)+1.25d-1*gammaaa*t22
     ?           *t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*(-3.6d-3*gammaa
     1           a*t31*t34*t7+6.0d-2*t1*t3*t7+6.0d-2*gammaaa*t1*t3*(-3.6
     2           d-3*gammaaa*t31*t34*t6+6.0d-2*t1*t3*t6+6.0d-2*gammaaa*t
     3           1*t3*(-3.6d-3*gammaaa*t31*t34*t5+6.0d-2*t1*t3*t5+6.0d-2
     4           *gammaaa*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t31*t34*
     5           t4))))*wght-1.25d-1*t22*t8*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t8*wght/taua**2+1.0d
     1           +0*rhoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t10**3
              t24 = 1/rhoa**1.3333333333333333d+0
              t25 = 1/rhoa**1.1666666666666667d+0
              t26 = 1/t2**2
              t27 = 1/rhoa**4.333333333333333d+0
              t28 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*(1.1102230246251565d-16*t21*(
     1           -9.970917392951799d-1*t25-7.418564737168958d-1*t24-4.00
     2           2143174996817d-1*t23-1.264669550498372d-1*t1)/(t18**2*t
     3           19)+1.0d+0*t17*(-1.8533958105157808d+0*t25-1.2815820791
     4           490704d+0*t24-8.223668877838045d-1*t23-1.60391419419212
     5           76d-1*t1)/(t14**2*t15)+3.0506411443514264d-19*t20*t24+1
     6           .3210398931339265d-3*t16*t24)*t8*wght+5.0d-1*t22*t8*wgh
     7           t+5.0d-1*rhoa*t22*(-4.0d-51*t28*t3*t7+9.6d-102*t26*t27*
     8           t7+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t6+9.6d-102*t26*t27*t
     9           6+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t5+9.6d-102*t26*t27*t5
     :           +2.4d-51*t1*t3*(9.6d-102*t26*t27*t4-4.0d-51*t28*t3*t4))
     ;           ))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t10**3
              t24 = 1/rhoa**1.3333333333333333d+0
              t25 = 1/rhoa**1.1666666666666667d+0
              t26 = 1/t2**2
              t27 = 1/rhoa**4.333333333333333d+0
              t28 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*(1.1102230246251565d-16*t21*(
     1           -9.970917392951799d-1*t25-7.418564737168958d-1*t24-4.00
     2           2143174996817d-1*t23-1.264669550498372d-1*t1)/(t18**2*t
     3           19)+1.0d+0*t17*(-1.8533958105157808d+0*t25-1.2815820791
     4           490704d+0*t24-8.223668877838045d-1*t23-1.60391419419212
     5           76d-1*t1)/(t14**2*t15)+3.0506411443514264d-19*t20*t24+1
     6           .3210398931339265d-3*t16*t24)*t8*wght+5.0d-1*t22*t8*wgh
     7           t+5.0d-1*rhoa*t22*(-4.0d-51*t28*t3*t7+9.6d-102*t26*t27*
     8           t7+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t6+9.6d-102*t26*t27*t
     9           6+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t5+9.6d-102*t26*t27*t5
     :           +2.4d-51*t1*t3*(9.6d-102*t26*t27*t4-4.0d-51*t28*t3*t4))
     ;           ))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/rhob**1.6666666666666669d+0
              t27 = 1/t10**3
              t28 = 1/rhob**1.3333333333333333d+0
              t29 = 1/rhob**1.1666666666666667d+0
              t30 = gammabb**2
              t31 = 1/t2**2
              t32 = 1/rhob**6.333333333333333d+0
              t33 = 1/rhob**3.6666666666666664d+0
              t34 = 1/rhob**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*(1.1102230246251565d
     1           -16*t21*(-9.970917392951799d-1*t29-7.418564737168958d-1
     2           *t28-4.002143174996817d-1*t27-1.264669550498372d-1*t26)
     3           /(t18**2*t19)+1.0d+0*t17*(-1.8533958105157808d+0*t29-1.
     4           2815820791490704d+0*t28-8.223668877838045d-1*t27-1.6039
     5           141941921276d-1*t26)/(t14**2*t15)+3.0506411443514264d-1
     6           9*t20*t28+1.3210398931339265d-3*t16*t28)*t8*wght+5.0d-1
     7           *t22*t25*t8*wght+5.0d-1*rhob*t22*t25*(-1.59999999999999
     8           98d-1*gammabb*t3*t33*t7+9.599999999999997d-3*t30*t31*t3
     9           2*t7+6.0d-2*gammabb*t1*t3*(-1.5999999999999998d-1*gamma
     :           bb*t3*t33*t6+9.599999999999997d-3*t30*t31*t32*t6+6.0d-2
     ;           *gammabb*t1*t3*(-1.5999999999999998d-1*gammabb*t3*t33*t
     <           5+9.599999999999997d-3*t30*t31*t32*t5+6.0d-2*gammabb*t1
     =           *t3*(9.599999999999997d-3*t30*t31*t32*t4-1.599999999999
     >           9998d-1*gammabb*t3*t33*t4))))*wght)+1.25d-1*gammabb*t22
     ?           *t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*(-3.6d-3*gammab
     1           b*t31*t34*t7+6.0d-2*t1*t3*t7+6.0d-2*gammabb*t1*t3*(-3.6
     2           d-3*gammabb*t31*t34*t6+6.0d-2*t1*t3*t6+6.0d-2*gammabb*t
     3           1*t3*(-3.6d-3*gammabb*t31*t34*t5+6.0d-2*t1*t3*t5+6.0d-2
     4           *gammabb*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammabb*t31*t34*
     5           t4))))*wght-1.25d-1*t22*t8*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t8*wght/taub**2+1.0d
     1           +0*rhob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t10**3
              t24 = 1/rhob**1.3333333333333333d+0
              t25 = 1/rhob**1.1666666666666667d+0
              t26 = 1/t2**2
              t27 = 1/rhob**4.333333333333333d+0
              t28 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*(1.1102230246251565d-16*t21*(
     1           -9.970917392951799d-1*t25-7.418564737168958d-1*t24-4.00
     2           2143174996817d-1*t23-1.264669550498372d-1*t1)/(t18**2*t
     3           19)+1.0d+0*t17*(-1.8533958105157808d+0*t25-1.2815820791
     4           490704d+0*t24-8.223668877838045d-1*t23-1.60391419419212
     5           76d-1*t1)/(t14**2*t15)+3.0506411443514264d-19*t20*t24+1
     6           .3210398931339265d-3*t16*t24)*t8*wght+5.0d-1*t22*t8*wgh
     7           t+5.0d-1*rhob*t22*(-4.0d-51*t28*t3*t7+9.6d-102*t26*t27*
     8           t7+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t6+9.6d-102*t26*t27*t
     9           6+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t5+9.6d-102*t26*t27*t5
     :           +2.4d-51*t1*t3*(9.6d-102*t26*t27*t4-4.0d-51*t28*t3*t4))
     ;           ))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/rhob**1.6666666666666669d+0
              t27 = 1/t10**3
              t28 = 1/rhob**1.3333333333333333d+0
              t29 = 1/rhob**1.1666666666666667d+0
              t30 = gammabb**2
              t31 = 1/t2**2
              t32 = 1/rhob**6.333333333333333d+0
              t33 = 1/rhob**3.6666666666666664d+0
              t34 = 1/rhob**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*(1.1102230246251565d
     1           -16*t21*(-9.970917392951799d-1*t29-7.418564737168958d-1
     2           *t28-4.002143174996817d-1*t27-1.264669550498372d-1*t26)
     3           /(t18**2*t19)+1.0d+0*t17*(-1.8533958105157808d+0*t29-1.
     4           2815820791490704d+0*t28-8.223668877838045d-1*t27-1.6039
     5           141941921276d-1*t26)/(t14**2*t15)+3.0506411443514264d-1
     6           9*t20*t28+1.3210398931339265d-3*t16*t28)*t8*wght+5.0d-1
     7           *t22*t25*t8*wght+5.0d-1*rhob*t22*t25*(-1.59999999999999
     8           98d-1*gammabb*t3*t33*t7+9.599999999999997d-3*t30*t31*t3
     9           2*t7+6.0d-2*gammabb*t1*t3*(-1.5999999999999998d-1*gamma
     :           bb*t3*t33*t6+9.599999999999997d-3*t30*t31*t32*t6+6.0d-2
     ;           *gammabb*t1*t3*(-1.5999999999999998d-1*gammabb*t3*t33*t
     <           5+9.599999999999997d-3*t30*t31*t32*t5+6.0d-2*gammabb*t1
     =           *t3*(9.599999999999997d-3*t30*t31*t32*t4-1.599999999999
     >           9998d-1*gammabb*t3*t33*t4))))*wght)+1.25d-1*gammabb*t22
     ?           *t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*(-3.6d-3*gammab
     1           b*t31*t34*t7+6.0d-2*t1*t3*t7+6.0d-2*gammabb*t1*t3*(-3.6
     2           d-3*gammabb*t31*t34*t6+6.0d-2*t1*t3*t6+6.0d-2*gammabb*t
     3           1*t3*(-3.6d-3*gammabb*t31*t34*t5+6.0d-2*t1*t3*t5+6.0d-2
     4           *gammabb*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammabb*t31*t34*
     5           t4))))*wght-1.25d-1*t22*t8*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t8*wght/taub**2+1.0d
     1           +0*rhob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t10**3
              t24 = 1/rhob**1.3333333333333333d+0
              t25 = 1/rhob**1.1666666666666667d+0
              t26 = 1/t2**2
              t27 = 1/rhob**4.333333333333333d+0
              t28 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*(1.1102230246251565d-16*t21*(
     1           -9.970917392951799d-1*t25-7.418564737168958d-1*t24-4.00
     2           2143174996817d-1*t23-1.264669550498372d-1*t1)/(t18**2*t
     3           19)+1.0d+0*t17*(-1.8533958105157808d+0*t25-1.2815820791
     4           490704d+0*t24-8.223668877838045d-1*t23-1.60391419419212
     5           76d-1*t1)/(t14**2*t15)+3.0506411443514264d-19*t20*t24+1
     6           .3210398931339265d-3*t16*t24)*t8*wght+5.0d-1*t22*t8*wgh
     7           t+5.0d-1*rhob*t22*(-4.0d-51*t28*t3*t7+9.6d-102*t26*t27*
     8           t7+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t6+9.6d-102*t26*t27*t
     9           6+2.4d-51*t1*t3*(-4.0d-51*t28*t3*t5+9.6d-102*t26*t27*t5
     :           +2.4d-51*t1*t3*(9.6d-102*t26*t27*t4-4.0d-51*t28*t3*t4))
     ;           ))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m05 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{32}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{0.06\,{\it t_{37}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{31}}
C>    \,{\it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{32}}+{
C>    \it t_{30}}\right)+{\it t_{29}}\right)+{\it t_{28}}\right)+{
C>    \it t_{26}}\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06
C>    \,{\it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{22}}\,\sigma_{\alpha\alpha}
C>    \,{\it t_{27}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_\alpha
C>    -{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\tau_\alpha}}+1.0\,\left({
C>    \it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}\,{
C>    \it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}+1.0\right)
C>    \,{\it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{
C>    \it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{\it t_{24}}\,{
C>    \it t_{25}}\,\left(0.0031\,{\it param}\left(5\right)\,{
C>    \it t_{24}}\,{\it t_{25}}+{\it param}\left(4\right)\right)+{
C>    \it param}\left(3\right)\right)+{\it param}\left(2\right)\right)
C>    +{\it param}\left(1\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{36}}+2.225569421150687\,{\it t_{35}}+0.8004286349993635
C>    \,{\it t_{34}}+0.1897004325747558\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{35}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{36}}+3.844746237447211\,{\it t_{35}}+1.644733775567609
C>    \,{\it t_{34}}+0.2405871291288192\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{35}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}
C>    \,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{37}}\,\sigma_{ss}\,{
C>    \it t_{38}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, NE Schultz, DG Truhlar, J.Chem.Phys. 123
C>    , 161103 (2005)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2126975 "> 
C> 10.1063/1.2126975 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m05_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(5)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(4)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(3)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(2)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(1)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = 6.0d-2*gammaaa*t1+1.0d+0
              t25 = 1/t24
              t26 = param(10)
              t27 = 6.0d-2*gammaaa*t1*t25*t26+param(9)
              t28 = 6.0d-2*gammaaa*t1*t25*t27+param(8)
              t29 = 6.0d-2*gammaaa*t1*t25*t28+param(7)
              t30 = 6.0d-2*gammaaa*t1*t25*t29+param(6)
              t31 = 1/taua
              t32 = 1/rhoa
              t33 = 2.0d+0*taua-2.5d-1*gammaaa*t32
              t34 = 6.299605249474366d-1
              t35 = 1.414213562373095d+0
              t36 = 1/t35
              t37 = 7.937005259840998d-1
              t38 = 8.908987181403393d-1
              t39 = 1.8970043257475583d-1*t34*t9+5.982550435771079d+0*t1
     1           3*t38+2.2255694211506874d+0*t12*t37+8.004286349993635d-
     2           1*t11*t36
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t12*t37+1.0d+0
              t43 = 1/t19
              t44 = 1/rhoa**1.6666666666666669d+0
              t45 = 1/t10**3
              t46 = 1/rhoa**1.3333333333333333d+0
              t47 = 1/rhoa**1.1666666666666667d+0
              t48 = -9.970917392951799d-1*t47-7.418564737168958d-1*t46-4
     1           .002143174996817d-1*t45-1.264669550498372d-1*t44
              t49 = 1/t18**2
              t50 = 1/t15
              t51 = -1.8533958105157808d+0*t47-1.2815820791490704d+0*t46
     1           -8.223668877838045d-1*t45-1.6039141941921276d-1*t44
              t52 = 1/t14**2
              t53 = 1.0d+0*t17*t50*t51*t52+1.1102230246251565d-16*t21*t4
     1           3*t48*t49+3.0506411443514264d-19*t20*t46+1.321039893133
     2           9265d-3*t16*t46
              t54 = 1/t40
              t55 = 3.968502629920499d-1
              t56 = -7.418564737168958d-1*t46*t55-4.4415387620319857d-1*
     1           t47-4.002143174996817d-1*t45/t35**3-3.9834594695849657d
     2           -2*t44
              t57 = 1/t39**2
              t58 = 2*rhoa*(1.0d+0*t42*t54*t56*t57+2.747773264188437d-3*
     1           t41*t46*t55)-rhoa*t53-6.21814d-2*t41*t42+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t59 = gammaaa**2
              t60 = 1/t2**2
              t61 = 1/rhoa**6.333333333333333d+0
              t62 = 1/rhoa**3.6666666666666664d+0
              t63 = 5.125333333333332d-5*t4*t59*t60*t61-8.26666666666666
     1           5d-3*gammaaa*t3*t4*t62
              t64 = 6.2d-3*gammaaa*t1*t3*t63-8.266666666666665d-3*gammaa
     1           a*t3*t5*t62+5.125333333333332d-5*t5*t59*t60*t61
              t65 = 6.2d-3*gammaaa*t1*t3*t64-8.266666666666665d-3*gammaa
     1           a*t3*t6*t62+5.125333333333332d-5*t59*t6*t60*t61
              t66 = -8.266666666666665d-3*gammaaa*t3*t62*t7+5.1253333333
     1           33332d-5*t59*t60*t61*t7+6.2d-3*gammaaa*t1*t3*t65
              t67 = t23-1.243628d-1*rhoa*t41*t42
              t68 = 1/t24**2
              t69 = 9.599999999999997d-3*t26*t59*t61*t68-1.5999999999999
     1           998d-1*gammaaa*t25*t26*t62
              t70 = 6.0d-2*gammaaa*t1*t25*t69+9.599999999999997d-3*t27*t
     1           59*t61*t68-1.5999999999999998d-1*gammaaa*t25*t27*t62
              t71 = 6.0d-2*gammaaa*t1*t25*t70+9.599999999999997d-3*t28*t
     1           59*t61*t68-1.5999999999999998d-1*gammaaa*t25*t28*t62
              t72 = 6.0d-2*gammaaa*t1*t25*t71+9.599999999999997d-3*t29*t
     1           59*t61*t68-1.5999999999999998d-1*gammaaa*t25*t29*t62
              t73 = 1/rhoa**5.333333333333333d+0
              t74 = 3.1d-3*t1*t3*t4-1.9219999999999998d-5*gammaaa*t4*t60
     1           *t73
              t75 = 6.2d-3*gammaaa*t1*t3*t74-1.9219999999999998d-5*gamma
     1           aa*t5*t60*t73+3.1d-3*t1*t3*t5
              t76 = 6.2d-3*gammaaa*t1*t3*t75-1.9219999999999998d-5*gamma
     1           aa*t6*t60*t73+3.1d-3*t1*t3*t6
              t77 = 6.2d-3*gammaaa*t1*t3*t76-1.9219999999999998d-5*gamma
     1           aa*t60*t7*t73+3.1d-3*t1*t3*t7
              t78 = 6.0d-2*t1*t25*t26-3.6d-3*gammaaa*t26*t68*t73
              t79 = 6.0d-2*gammaaa*t1*t25*t78-3.6d-3*gammaaa*t27*t68*t73
     1           +6.0d-2*t1*t25*t27
              t80 = 6.0d-2*gammaaa*t1*t25*t79-3.6d-3*gammaaa*t28*t68*t73
     1           +6.0d-2*t1*t25*t28
              t81 = 6.0d-2*gammaaa*t1*t25*t80-3.6d-3*gammaaa*t29*t68*t73
     1           +6.0d-2*t1*t25*t29
              t82 = 1/taua**2
              t83 = 2.0d+0*t58*t66
              t84 = 2.0d+0*t42*t54*t56*t57
              t85 = 5.495546528376875d-3*t41*t46*t55
              t86 = t48**2
              t87 = 1/t10**5
              t88 = 1/rhoa**2.3333333333333334d+0
              t89 = 1/rhoa**2.1666666666666665d+0
              t90 = t51**2
              t91 = -2.0d+0*t17*t50*t90/t14**3+3.216395899738507d+1*t17*
     1           t90/(t14**4*t15**2)+1.0d+0*t17*t50*t52*(2.1622951122684
     2           114d+0*t89+1.7087761055320938d+0*t88+1.2335503316757068
     3           d+0*t87+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t21*t43*t49*(1.1632736958443765d+0*t89+9.8914196495586
     5           1d-1*t88+6.003214762495226d-1*t87+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t20*t88-1.7613865241785684d
     7           -3*t16*t88-2.220446049250313d-16*t21*t43*t86/t18**3+1.7
     8           854583920998188d-15*t21*t86/(t18**4*t19**2)-8.497974591
     9           333913d-2*t46*t50*t51*t52-9.812069668265515d-18*t43*t46
     :           *t48*t49
              t92 = t56**2
              t93 = 1.6081979498692536d+1*t42*t92/(t39**4*t40**2)
              t94 = -2.0d+0*t42*t54*t92/t39**3
              t95 = 1.9842513149602492d-1
              t96 = 1.0d+0*t42*t54*t57*(9.89141964955861d-1*t88*t95+2.59
     1           08976111853255d-1*t89+6.003214762495226d-1*t87/t35**5+3
     2           .319549557987472d-2*t1)
              t97 = -3.663697685584583d-3*t41*t88*t95
              t98 = log(2.9608813203268075d+1/(1.9115125951273373d-1*t34
     1           *t9+8.157414703487641d+0*t13*t38+2.247591863577616d+0*t
     2           12*t37+4.3009724712766434d-1*t11*t36)+1.0d+0)
              t99 = 6.901399211255825d-2*t12*t37+1.0d+0
              t100 = 1/rhoa**2
              t101 = -8.837926660346784d-2*t46*t54*t55*t56*t57
              t102 = gammaaa**3
              t103 = 1/t2**3
              t104 = 1/rhoa**10
              t105 = 8.473884444444441d-7*t102*t103*t104*t7
              t106 = 1/rhoa**7.333333333333333d+0
              t107 = 1.0250666666666663d-4*t59*t60*t61*t65
              t108 = 1/rhoa**4.666666666666667d+0
              t109 = -1.653333333333333d-2*gammaaa*t3*t62*t65
              t110 = 8.473884444444441d-7*t102*t103*t104*t6
              t111 = 1.0250666666666663d-4*t59*t60*t61*t64
              t112 = -1.653333333333333d-2*gammaaa*t3*t62*t64
              t113 = 8.473884444444441d-7*t102*t103*t104*t5
              t114 = 1.0250666666666663d-4*t59*t60*t61*t63
              t115 = -1.653333333333333d-2*gammaaa*t3*t62*t63
              t116 = 8.473884444444441d-7*t102*t103*t104*t4
              t117 = 1/t24**3
              t118 = 1.0d+0*t58*t77
              t119 = 1/rhoa**9
              t120 = -3.1777066666666653d-7*t103*t119*t59*t7
              t121 = 5.125333333333332d-5*t59*t60*t61*t76
              t122 = -1.9219999999999998d-5*gammaaa*t60*t65*t73
              t123 = -8.266666666666665d-3*gammaaa*t3*t62*t76
              t124 = -3.1777066666666653d-7*t103*t119*t59*t6
              t125 = 5.125333333333332d-5*t59*t60*t61*t75
              t126 = -1.9219999999999998d-5*gammaaa*t60*t64*t73
              t127 = -8.266666666666665d-3*gammaaa*t3*t62*t75
              t128 = -3.1777066666666653d-7*t103*t119*t5*t59
              t129 = 5.125333333333332d-5*t59*t60*t61*t74
              t130 = -1.9219999999999998d-5*gammaaa*t60*t63*t73
              t131 = -8.266666666666665d-3*gammaaa*t3*t62*t74
              t132 = -3.1777066666666653d-7*t103*t119*t4*t59
              t133 = 3.1d-3*t1*t3*t63
              t134 = 3.1d-3*t1*t3*t64
              t135 = 3.1d-3*t1*t3*t65
              t136 = 1.25d-1*t22*t30
              t137 = 1/rhoa**8
              t138 = -3.8439999999999996d-5*gammaaa*t60*t73*t76+6.2d-3*t
     1           1*t3*t76+6.2d-3*gammaaa*t1*t3*(-3.8439999999999996d-5*g
     2           ammaaa*t60*t73*t75+6.2d-3*t1*t3*t75+6.2d-3*gammaaa*t1*t
     3           3*(-3.8439999999999996d-5*gammaaa*t60*t73*t74+6.2d-3*t1
     4           *t3*t74+6.2d-3*gammaaa*t1*t3*(1.1916399999999999d-7*gam
     5           maaa*t103*t137*t4-1.9219999999999998d-5*t4*t60*t73)-1.9
     6           219999999999998d-5*t5*t60*t73+1.1916399999999999d-7*gam
     7           maaa*t103*t137*t5)-1.9219999999999998d-5*t6*t60*t73+1.1
     8           916399999999999d-7*gammaaa*t103*t137*t6)-1.921999999999
     9           9998d-5*t60*t7*t73+1.1916399999999999d-7*gammaaa*t103*t
     :           137*t7
              fnc(iq) = (1.0d+0*t8*(t23-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.195037
     2           84087549d-1*t9+5.329846514438383d+0*t13+1.7664356201814
     3           29d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rho
     4           a*t22*t30*t31*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t58*t8+t31*(5.0d-1*rhoa*t22*t33*t
     1           72+5.0d-1*rhoa*t30*t33*t53+5.0d-1*t22*t30*t33)+1.0d+0*t
     2           66*t67+1.25d-1*gammaaa*t22*t30*t31*t32)*wght+Amat(iq,D1
     3           _RA)
              Cmat(iq,D1_GAA) = (t31*(5.0d-1*rhoa*t22*t33*t81-1.25d-1*t2
     1           2*t30)+1.0d+0*t67*t77)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t22*t30*t31-5.0d-1*rhoa*t22*
     1           t30*t33*t82)*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t8*(2*rhoa*(8.443431970194815
     1           d-3*t100*t98*t99+t97+t96+t94+t93+t101)-rhoa*t91+t85+t84
     2           -2.0d+0*t17*t50*t51*t52-2.220446049250313d-16*t21*t43*t
     3           48*t49-6.101282288702853d-19*t20*t46-2.642079786267853d
     4           -3*t16*t46)+t31*(5.0d-1*rhoa*t30*t33*t91+1.0d+0*rhoa*t3
     5           3*t53*t72+1.0d+0*t22*t33*t72+1.25d-1*gammaaa*t22*t32*t7
     6           2+5.0d-1*rhoa*t22*t33*(1.9199999999999995d-2*t59*t61*t6
     7           8*t71-3.1999999999999995d-1*gammaaa*t25*t62*t71+6.0d-2*
     8           gammaaa*t1*t25*(1.9199999999999995d-2*t59*t61*t68*t70-3
     9           .1999999999999995d-1*gammaaa*t25*t62*t70+6.0d-2*gammaaa
     :           *t1*t25*(1.9199999999999995d-2*t59*t61*t68*t69-3.199999
     ;           9999999995d-1*gammaaa*t25*t62*t69+6.0d-2*gammaaa*t1*t25
     <           *(-8.639999999999998d-2*t106*t26*t59*t68+5.866666666666
     =           666d-1*gammaaa*t108*t25*t26+3.0719999999999986d-3*t102*
     >           t104*t117*t26)-8.639999999999998d-2*t106*t27*t59*t68+5.
     ?           866666666666666d-1*gammaaa*t108*t25*t27+3.0719999999999
     @           986d-3*t102*t104*t117*t27)-8.639999999999998d-2*t106*t2
     1           8*t59*t68+5.866666666666666d-1*gammaaa*t108*t25*t28+3.0
     2           719999999999986d-3*t102*t104*t117*t28)-8.63999999999999
     3           8d-2*t106*t29*t59*t68+5.866666666666666d-1*gammaaa*t108
     4           *t25*t29+3.0719999999999986d-3*t102*t104*t117*t29)+1.0d
     5           +0*t30*t33*t53+1.25d-1*gammaaa*t30*t32*t53+1.25d-1*gamm
     6           aaa*t100*t22*t30)+t83+t31*t32*(1.25d-1*gammaaa*t22*t72+
     7           1.25d-1*gammaaa*t30*t53)+1.0d+0*t67*(-3.246044444444443
     8           6d-4*t106*t59*t60*t7+3.0311111111111105d-2*gammaaa*t108
     9           *t3*t7+6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d
     :           -3*gammaaa*t1*t3*(-3.2460444444444436d-4*t106*t4*t59*t6
     ;           0+3.0311111111111105d-2*gammaaa*t108*t3*t4+t116)-3.2460
     <           444444444436d-4*t106*t5*t59*t60+3.0311111111111105d-2*g
     =           ammaaa*t108*t3*t5+t115+t114+t113)-3.2460444444444436d-4
     >           *t106*t59*t6*t60+3.0311111111111105d-2*gammaaa*t108*t3*
     ?           t6+t112+t111+t110)+t109+t107+t105)-1.25d-1*gammaaa*t100
     @           *t22*t30*t31)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t8*(2*rhoa*(-8.44343197019481
     1           5d-3*t100*t98*t99+t97+t96+t94+t93+t101)+t85+t84)+t83+1.
     2           0d+0*t67*(-1.366755555555555d-4*t106*t59*t60*t7+6.2d-3*
     3           gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*
     4           t3*(t116-1.366755555555555d-4*t106*t4*t59*t60)-1.366755
     5           555555555d-4*t106*t5*t59*t60+t115+t114+t113)-1.36675555
     6           5555555d-4*t106*t59*t6*t60+t112+t111+t110)+t109+t107+t1
     7           05))*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t31*(5.0d-1*rhoa*t33*t53*t81+5.0d-1
     1           *t22*t33*t81+5.0d-1*rhoa*t22*t33*(9.599999999999997d-3*
     2           t59*t61*t68*t80-1.5999999999999998d-1*gammaaa*t25*t62*t
     3           80+6.0d-2*gammaaa*t1*t25*(9.599999999999997d-3*t59*t61*
     4           t68*t79-1.5999999999999998d-1*gammaaa*t25*t62*t79+6.0d-
     5           2*gammaaa*t1*t25*(9.599999999999997d-3*t59*t61*t68*t78-
     6           1.5999999999999998d-1*gammaaa*t25*t62*t78-3.6d-3*gammaa
     7           a*t68*t69*t73+6.0d-2*t1*t25*t69+6.0d-2*gammaaa*t1*t25*(
     8           2.879999999999999d-2*gammaaa*t26*t61*t68-1.599999999999
     9           9998d-1*t25*t26*t62-1.1519999999999996d-3*t117*t119*t26
     :           *t59)+2.879999999999999d-2*gammaaa*t27*t61*t68-1.599999
     ;           9999999998d-1*t25*t27*t62-1.1519999999999996d-3*t117*t1
     <           19*t27*t59)-3.6d-3*gammaaa*t68*t70*t73+6.0d-2*t1*t25*t7
     =           0+2.879999999999999d-2*gammaaa*t28*t61*t68-1.5999999999
     >           999998d-1*t25*t28*t62-1.1519999999999996d-3*t117*t119*t
     ?           28*t59)-3.6d-3*gammaaa*t68*t71*t73+6.0d-2*t1*t25*t71+2.
     @           879999999999999d-2*gammaaa*t29*t61*t68-1.59999999999999
     1           98d-1*t25*t29*t62-1.1519999999999996d-3*t117*t119*t29*t
     2           59)-1.25d-1*t22*t72-1.25d-1*t30*t53-1.25d-1*t22*t30*t32
     3           )+t31*t32*(1.25d-1*gammaaa*t22*t81+t136)+1.0d+0*t67*(-8
     4           .266666666666665d-3*t3*t62*t7+1.0250666666666663d-4*gam
     5           maaa*t60*t61*t7+6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1
     6           *t3*(6.2d-3*gammaaa*t1*t3*(-8.266666666666665d-3*t3*t4*
     7           t62+1.0250666666666663d-4*gammaaa*t4*t60*t61+t132)-8.26
     8           6666666666665d-3*t3*t5*t62+1.0250666666666663d-4*gammaa
     9           a*t5*t60*t61+t133+t131+t130+t129+t128)-8.26666666666666
     :           5d-3*t3*t6*t62+1.0250666666666663d-4*gammaaa*t6*t60*t61
     ;           +t134+t127+t126+t125+t124)+t135+t123+t122+t121+t120)+t1
     <           18)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t67*(5.125333333333332d-5*ga
     1           mmaaa*t60*t61*t7+6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t
     2           1*t3*(6.2d-3*gammaaa*t1*t3*(5.125333333333332d-5*gammaa
     3           a*t4*t60*t61+t132)+5.125333333333332d-5*gammaaa*t5*t60*
     4           t61+t133+t131+t130+t129+t128)+5.125333333333332d-5*gamm
     5           aaa*t6*t60*t61+t134+t127+t126+t125+t124)+t135+t123+t122
     6           +t121+t120)+t118)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t31*(5.0d-1*rhoa*t22*t33*(-7.2d-3*
     1           gammaaa*t68*t73*t80+1.2d-1*t1*t25*t80+6.0d-2*gammaaa*t1
     2           *t25*(-7.2d-3*gammaaa*t68*t73*t79+1.2d-1*t1*t25*t79+6.0
     3           d-2*gammaaa*t1*t25*(-7.2d-3*gammaaa*t68*t73*t78+1.2d-1*
     4           t1*t25*t78+6.0d-2*gammaaa*t1*t25*(4.32d-4*gammaaa*t117*
     5           t137*t26-7.2d-3*t26*t68*t73)-7.2d-3*t27*t68*t73+4.32d-4
     6           *gammaaa*t117*t137*t27)-7.2d-3*t28*t68*t73+4.32d-4*gamm
     7           aaa*t117*t137*t28)-7.2d-3*t29*t68*t73+4.32d-4*gammaaa*t
     8           117*t137*t29)-2.5d-1*t22*t81)+1.0d+0*t138*t67)*wght+Cma
     9           t2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t138*t67*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = ((-5.0d-1*rhoa*t22*t33*t72-5.0d-1*rho
     1           a*t30*t33*t53-5.0d-1*t22*t30*t33)*t82-1.25d-1*gammaaa*t
     2           22*t30*t32*t82+t31*(1.0d+0*rhoa*t22*t72+1.0d+0*rhoa*t30
     3           *t53+1.0d+0*t22*t30))*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = ((t136-5.0d-1*rhoa*t22*t33*t81)*t82+
     1           1.0d+0*rhoa*t22*t31*t81)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t22*t30*t33/taua**3-2.0d
     1           +0*rhoa*t22*t30*t82)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 2.4799999999999997d-52*t1+1.0d+0
              t24 = 1/t23
              t25 = param(5)
              t26 = 2.4799999999999997d-52*t1*t24*t25+param(4)
              t27 = 2.4799999999999997d-52*t1*t24*t26+param(3)
              t28 = 2.4799999999999997d-52*t1*t24*t27+param(2)
              t29 = 2.4799999999999997d-52*t1*t24*t28+param(1)
              t30 = -2*rhoa*t22
              t31 = 1/t19
              t32 = 1/t10**3
              t33 = 1/rhoa**1.3333333333333333d+0
              t34 = 1/rhoa**1.1666666666666667d+0
              t35 = -9.970917392951799d-1*t34-7.418564737168958d-1*t33-4
     1           .002143174996817d-1*t32-1.264669550498372d-1*t1
              t36 = 1/t18**2
              t37 = 1/t15
              t38 = -1.8533958105157808d+0*t34-1.2815820791490704d+0*t33
     1           -8.223668877838045d-1*t32-1.6039141941921276d-1*t1
              t39 = 1/t14**2
              t40 = 1.0d+0*t17*t37*t38*t39+1.1102230246251565d-16*t21*t3
     1           1*t35*t36+3.0506411443514264d-19*t20*t33+1.321039893133
     2           9265d-3*t16*t33
              t41 = 1/t2**2
              t42 = 1/rhoa**4.333333333333333d+0
              t43 = 1/rhoa**2.6666666666666666d+0
              t44 = 9.6d-102*t4*t41*t42-4.0d-51*t3*t4*t43
              t45 = -4.0d-51*t3*t43*t5+9.6d-102*t41*t42*t5+2.4d-51*t1*t3
     1           *t44
              t46 = -4.0d-51*t3*t43*t6+9.6d-102*t41*t42*t6+2.4d-51*t1*t3
     1           *t45
              t47 = -4.0d-51*t3*t43*t7+9.6d-102*t41*t42*t7+2.4d-51*t1*t3
     1           *t46
              t48 = 6.299605249474366d-1
              t49 = 1.414213562373095d+0
              t50 = 1/t49
              t51 = 7.937005259840998d-1
              t52 = 8.908987181403393d-1
              t53 = 1.8970043257475583d-1*t48*t9+5.982550435771079d+0*t1
     1           3*t52+2.2255694211506874d+0*t12*t51+8.004286349993635d-
     2           1*t11*t50
              t54 = 1.6081979498692536d+1/t53+1.0d+0
              t55 = log(t54)
              t56 = 1.3256889990520176d-1*t12*t51+1.0d+0
              t57 = 1/t54
              t58 = 3.968502629920499d-1
              t59 = -7.418564737168958d-1*t33*t58-4.002143174996817d-1*t
     1           32/t49**3-4.4415387620319857d-1*t34-3.9834594695849657d
     2           -2*t1
              t60 = 1/t53**2
              t61 = 2*rhoa*(1.0d+0*t56*t57*t59*t60+2.747773264188437d-3*
     1           t33*t55*t58)-6.21814d-2*t55*t56-rhoa*t40+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t62 = 1/t23**2
              t63 = 5.125333333333333d-104*t25*t42*t62-2.066666666666666
     1           7d-52*t24*t25*t43
              t64 = 2.4799999999999997d-52*t1*t24*t63+5.125333333333333d
     1           -104*t26*t42*t62-2.0666666666666667d-52*t24*t26*t43
              t65 = 2.4799999999999997d-52*t1*t24*t64+5.125333333333333d
     1           -104*t27*t42*t62-2.0666666666666667d-52*t24*t27*t43
              t66 = 2.4799999999999997d-52*t1*t24*t65+5.125333333333333d
     1           -104*t28*t42*t62-2.0666666666666667d-52*t24*t28*t43
              t67 = t30-1.243628d-1*rhoa*t55*t56
              t68 = t35**2
              t69 = 1/t10**5
              t70 = 1/rhoa**2.3333333333333334d+0
              t71 = 1/rhoa**2.1666666666666665d+0
              t72 = t38**2
              t73 = -2.0d+0*t17*t37*t72/t14**3+3.216395899738507d+1*t17*
     1           t72/(t14**4*t15**2)+1.0d+0*t17*t37*t39*(2.1622951122684
     2           114d+0*t71+1.7087761055320938d+0*t70+1.2335503316757068
     3           d+0*t69+2.673190323653546d-1*t43)+1.1102230246251565d-1
     4           6*t21*t31*t36*(1.1632736958443765d+0*t71+9.891419649558
     5           61d-1*t70+6.003214762495226d-1*t69+2.1077825841639536d-
     6           1*t43)-4.0675215258019015d-19*t20*t70-1.761386524178568
     7           4d-3*t16*t70-2.220446049250313d-16*t21*t31*t68/t18**3+1
     8           .7854583920998188d-15*t21*t68/(t18**4*t19**2)-8.4979745
     9           91333913d-2*t33*t37*t38*t39-9.812069668265515d-18*t31*t
     :           33*t35*t36
              t74 = 1/t2**3
              t75 = 1/rhoa**7
              t76 = 1/rhoa**5.333333333333333d+0
              t77 = 1/rhoa**3.6666666666666664d+0
              t78 = 2.0d+0*t61*t66
              t79 = 2.0d+0*t56*t57*t59*t60
              t80 = 5.495546528376875d-3*t33*t55*t58
              t81 = t59**2
              t82 = 1.6081979498692536d+1*t56*t81/(t53**4*t54**2)
              t83 = -2.0d+0*t56*t57*t81/t53**3
              t84 = 1.9842513149602492d-1
              t85 = 1.0d+0*t56*t57*t60*(9.89141964955861d-1*t70*t84+2.59
     1           08976111853255d-1*t71+6.003214762495226d-1*t69/t49**5+3
     2           .319549557987472d-2*t43)
              t86 = -3.663697685584583d-3*t55*t70*t84
              t87 = log(2.9608813203268075d+1/(1.9115125951273373d-1*t48
     1           *t9+8.157414703487641d+0*t13*t52+2.247591863577616d+0*t
     2           12*t51+4.3009724712766434d-1*t11*t50)+1.0d+0)
              t88 = 6.901399211255825d-2*t12*t51+1.0d+0
              t89 = 1/rhoa**2
              t90 = -8.837926660346784d-2*t33*t57*t58*t59*t60
              t91 = 1/t23**3
              t92 = 2.118471111111111d-155*t28*t75*t91
              t93 = 1.0250666666666666d-103*t42*t62*t65
              t94 = -4.1333333333333333d-52*t24*t43*t65
              t95 = 2.118471111111111d-155*t27*t75*t91
              t96 = 1.0250666666666666d-103*t42*t62*t64
              t97 = -4.1333333333333333d-52*t24*t43*t64
              t98 = 2.118471111111111d-155*t26*t75*t91
              t99 = 1.0250666666666666d-103*t42*t62*t63
              t100 = -4.1333333333333333d-52*t24*t43*t63
              t101 = 2.118471111111111d-155*t25*t75*t91
              fnc(iq) = (1.0d+0*t29*(t30-1.243628d-1*rhoa*(1.05220005583
     1           89212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.19503
     2           784087549d-1*t9+5.329846514438383d+0*t13+1.766435620181
     3           429d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rh
     4           oa*t22*t8)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t40*t8+5.0d-1*t22*t8+1.0d+0*
     1           t66*t67+1.0d+0*t29*t61+5.0d-1*rhoa*t22*t47)*wght+Amat(i
     2           q,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t67*(2.4799999999999997d-52*t
     1           1*t24*(2.4799999999999997d-52*t1*t24*(t99+t98+2.4799999
     2           999999997d-52*t1*t24*(5.51111111111111d-52*t24*t25*t77-
     3           2.2209777777777773d-103*t25*t62*t76+t101)+5.51111111111
     4           111d-52*t24*t26*t77-2.2209777777777773d-103*t26*t62*t76
     5           +t100)+t97+t96+t95+5.51111111111111d-52*t24*t27*t77-2.2
     6           209777777777773d-103*t27*t62*t76)+t94+t93+t92+5.5111111
     7           1111111d-52*t24*t28*t77-2.2209777777777773d-103*t28*t62
     8           *t76)+1.0d+0*t29*(2*rhoa*(t90+8.443431970194815d-3*t87*
     9           t88*t89+t86+t85+t83+t82)+t80+t79-rhoa*t73-2.0d+0*t17*t3
     :           7*t38*t39-2.220446049250313d-16*t21*t31*t35*t36-6.10128
     ;           2288702853d-19*t20*t33-2.642079786267853d-3*t16*t33)+5.
     <           0d-1*rhoa*t73*t8+1.0d+0*t40*t8+t78+5.0d-1*rhoa*t22*(2.4
     =           d-51*t1*t3*(2.4d-51*t1*t3*(2.4d-51*t1*t3*(1.06666666666
     >           66666d-50*t3*t4*t77-5.76d-101*t4*t41*t76+7.68d-152*t4*t
     ?           74*t75)+1.0666666666666666d-50*t3*t5*t77-5.76d-101*t41*
     @           t5*t76+7.68d-152*t5*t74*t75-8.0d-51*t3*t43*t44+1.92d-10
     1           1*t41*t42*t44)+1.0666666666666666d-50*t3*t6*t77-5.76d-1
     2           01*t41*t6*t76+7.68d-152*t6*t74*t75-8.0d-51*t3*t43*t45+1
     3           .92d-101*t41*t42*t45)+1.0666666666666666d-50*t3*t7*t77-
     4           5.76d-101*t41*t7*t76+7.68d-152*t7*t74*t75-8.0d-51*t3*t4
     5           3*t46+1.92d-101*t41*t42*t46)+1.0d+0*rhoa*t40*t47+1.0d+0
     6           *t22*t47)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t67*(2.4799999999999997d-52*t
     1           1*t24*(2.4799999999999997d-52*t1*t24*(t99+t98+2.4799999
     2           999999997d-52*t1*t24*(t101-8.542222222222222d-104*t25*t
     3           62*t76)-8.542222222222222d-104*t26*t62*t76+t100)+t97+t9
     4           6+t95-8.542222222222222d-104*t27*t62*t76)+t94+t93+t92-8
     5           .542222222222222d-104*t28*t62*t76)+1.0d+0*t29*(2*rhoa*(
     6           t90-8.443431970194815d-3*t87*t88*t89+t86+t85+t83+t82)+t
     7           80+t79)+t78)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(5)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 1/rhob**2.6666666666666666d+0
              t4 = gammabb*t3+gammaaa*t2
              t5 = 3.1d-3*t4+1.0d+0
              t6 = 1/t5
              t7 = 3.1d-3*t1*t4*t6+param(4)
              t8 = 3.1d-3*t4*t6*t7+param(3)
              t9 = 3.1d-3*t4*t6*t8+param(2)
              t10 = 3.1d-3*t4*t6*t9+param(1)
              t11 = 1/rhoa**6.666666666666666d-1
              t12 = rhoa**5.0d-1
              t13 = 1/t12
              t14 = 1/rhoa**3.333333333333333d-1
              t15 = 1/rhoa**1.6666666666666666d-1
              t16 = 1.1120374863094686d+1*t15+3.8447462374472113d+0*t14+
     1           1.644733775567609d+0*t13+2.4058712912881916d-1*t11
              t17 = 3.216395899738507d+1/t16+1.0d+0
              t18 = log(t17)
              t19 = 1.274696188700087d-1*t14+1.0d+0
              t20 = 5.982550435771079d+0*t15+2.2255694211506874d+0*t14+8
     1           .004286349993635d-1*t13+1.8970043257475583d-1*t11
              t21 = 1.6081979498692536d+1/t20+1.0d+0
              t22 = log(t21)
              t23 = 1.3256889990520176d-1*t14+1.0d+0
              t24 = -6.903522198342671d-18*t22*t23-3.1090699999999993d-2
     1           *t18*t19
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = rhob+rhoa
              t40 = 1/t39**3.333333333333333d-1
              t41 = 1.3256889990520176d-1*t40+1.0d+0
              t42 = rhoa-rhob
              t43 = t42**4
              t44 = 1/t39**4
              t45 = 1/t39
              t46 = 1.0d+0-t42*t45
              t47 = t42*t45+1.0d+0
              t48 = t47**1.3333333333333333d+0+t46**1.3333333333333333d+
     1           0-2.0d+0
              t49 = -1.923661050931536d+0*t43*t44*t48
              t50 = t49+1.0d+0
              t51 = 1/t39**6.666666666666666d-1
              t52 = t39**5.0d-1
              t53 = 1/t52
              t54 = 1/t39**1.6666666666666666d-1
              t55 = 5.982550435771079d+0*t54+8.004286349993635d-1*t53+1.
     1           8970043257475583d-1*t51+2.2255694211506874d+0*t40
              t56 = 1.6081979498692536d+1/t55+1.0d+0
              t57 = log(t56)
              t58 = -6.21814d-2*t41*t50*t57
              t59 = 6.901399211255825d-2*t40+1.0d+0
              t60 = t49+1.923661050931536d+0*t48
              t61 = 8.157414703487641d+0*t54+4.3009724712766434d-1*t53+1
     1           .9115125951273373d-1*t51+2.247591863577616d+0*t40
              t62 = 2.9608813203268075d+1/t61+1.0d+0
              t63 = log(t62)
              t64 = 1.9751631321680768d-2*t59*t60*t63
              t65 = 1.274696188700087d-1*t40+1.0d+0
              t66 = 1.1120374863094686d+1*t54+1.644733775567609d+0*t53+2
     1           .4058712912881916d-1*t51+3.8447462374472113d+0*t40
              t67 = 3.216395899738507d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -5.980796863619711d-2*t43*t44*t48*t65*t68
              t70 = t39*(t69+t64+t58)-rhob*t38-rhoa*t24
              t71 = param(6)
              t72 = 6.0d-2*gammaaa*t2+1.0d+0
              t73 = 1/t72
              t74 = param(7)
              t75 = param(8)
              t76 = param(9)
              t77 = param(10)
              t78 = 6.0d-2*gammaaa*t2*t73*t77+t76
              t79 = 6.0d-2*gammaaa*t2*t73*t78+t75
              t80 = 6.0d-2*gammaaa*t2*t73*t79+t74
              t81 = 6.0d-2*gammaaa*t2*t73*t80+t71
              t82 = 1/taua
              t83 = 1/rhoa
              t84 = 2.0d+0*taua-2.5d-1*gammaaa*t83
              t85 = 6.0d-2*gammabb*t3+1.0d+0
              t86 = 1/t85
              t87 = 6.0d-2*gammabb*t3*t77*t86+t76
              t88 = 6.0d-2*gammabb*t3*t86*t87+t75
              t89 = 6.0d-2*gammabb*t3*t86*t88+t74
              t90 = 6.0d-2*gammabb*t3*t86*t89+t71
              t91 = 1/taub
              t92 = 1/rhob
              t93 = 2.0d+0*taub-2.5d-1*gammabb*t92
              t94 = 1/t21
              t95 = 1/rhoa**1.6666666666666669d+0
              t96 = 1/t12**3
              t97 = 1/rhoa**1.3333333333333333d+0
              t98 = 1/rhoa**1.1666666666666667d+0
              t99 = -9.970917392951799d-1*t98-7.418564737168958d-1*t97-4
     1           .002143174996817d-1*t96-1.264669550498372d-1*t95
              t100 = 1/t20**2
              t101 = 1/t17
              t102 = -1.8533958105157808d+0*t98-1.2815820791490704d+0*t9
     1           7-8.223668877838045d-1*t96-1.6039141941921276d-1*t95
              t103 = 1/t16**2
              t104 = 1.1102230246251565d-16*t100*t23*t94*t99+3.050641144
     1           3514264d-19*t22*t97+1.3210398931339265d-3*t18*t97+1.0d+
     2           0*t101*t102*t103*t19
              t105 = 1/t39**1.6666666666666669d+0
              t106 = 1/t52**3
              t107 = 1/t39**1.3333333333333333d+0
              t108 = 1/t39**1.1666666666666667d+0
              t109 = -9.970917392951799d-1*t108-7.418564737168958d-1*t10
     1           7-4.002143174996817d-1*t106-1.264669550498372d-1*t105
              t110 = 1/t55**2
              t111 = 1/t56
              t112 = 1.0d+0*t109*t110*t111*t41*t50
              t113 = -1.3595691172479402d+0*t108-7.491972878592053d-1*t1
     1           07-2.1504862356383217d-1*t106-1.2743417300848914d-1*t10
     2           5
              t114 = 1/t61**2
              t115 = 1/t62
              t116 = -5.848223622634647d-1*t113*t114*t115*t59*t60
              t117 = -1.8533958105157808d+0*t108-1.2815820791490704d+0*t
     1           107-8.223668877838045d-1*t106-1.6039141941921276d-1*t10
     2           5
              t118 = 1/t66**2
              t119 = 1/t67
              t120 = 1.923661050931536d+0*t117*t118*t119*t43*t44*t48*t65
              t121 = 1/t39**2
              t122 = t121*t42
              t123 = -t45
              t124 = t123+t122
              t125 = t46**3.333333333333333d-1
              t126 = -t121*t42
              t127 = t45+t126
              t128 = t47**3.333333333333333d-1
              t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d
     1           +0*t124*t125
              t130 = -1.923661050931536d+0*t129*t43*t44
              t131 = 1/t39**5
              t132 = 7.694644203726144d+0*t131*t43*t48
              t133 = t42**3
              t134 = -7.694644203726144d+0*t133*t44*t48
              t135 = t134+t132+t130
              t136 = -6.21814d-2*t135*t41*t57
              t137 = 2.747773264188437d-3*t107*t50*t57
              t138 = t134+t132+t130+1.923661050931536d+0*t129
              t139 = 1.9751631321680768d-2*t138*t59*t63
              t140 = -4.5437964274821163d-4*t107*t60*t63
              t141 = -5.980796863619711d-2*t129*t43*t44*t65*t68
              t142 = 1/t39**5.333333333333333d+0
              t143 = 2.541232989148493d-3*t142*t43*t48*t68
              t144 = 2.3923187454478842d-1*t131*t43*t48*t65*t68
              t145 = t69+t39*(-2.3923187454478842d-1*t133*t44*t48*t65*t6
     1           8+t144+t143+t141+t140+t139+t137+t136+t120+t116+t112)+t6
     2           4+t58+6.903522198342671d-18*t22*t23+3.1090699999999993d
     3           -2*t18*t19-rhoa*t104
              t146 = 1/rhoa**3.6666666666666664d+0
              t147 = 1/t5**2
              t148 = 2.562666666666666d-5*gammaaa*t1*t146*t147*t4-8.2666
     1           66666666665d-3*gammaaa*t1*t146*t6
              t149 = -8.266666666666665d-3*gammaaa*t146*t6*t7+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t7+3.1d-3*t148*t4*t6
              t150 = -8.266666666666665d-3*gammaaa*t146*t6*t8+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t8+3.1d-3*t149*t4*t6
              t151 = -8.266666666666665d-3*gammaaa*t146*t6*t9+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t9+3.1d-3*t150*t4*t6
              t152 = gammaaa**2
              t153 = 1/t72**2
              t154 = 1/rhoa**6.333333333333333d+0
              t155 = 9.599999999999997d-3*t152*t153*t154*t77-1.599999999
     1           9999998d-1*gammaaa*t146*t73*t77
              t156 = -1.5999999999999998d-1*gammaaa*t146*t73*t78+9.59999
     1           9999999997d-3*t152*t153*t154*t78+6.0d-2*gammaaa*t155*t2
     2           *t73
              t157 = -1.5999999999999998d-1*gammaaa*t146*t73*t79+9.59999
     1           9999999997d-3*t152*t153*t154*t79+6.0d-2*gammaaa*t156*t2
     2           *t73
              t158 = -1.5999999999999998d-1*gammaaa*t146*t73*t80+9.59999
     1           9999999997d-3*t152*t153*t154*t80+6.0d-2*gammaaa*t157*t2
     2           *t73
              t159 = 1/t35
              t160 = 1/rhob**1.6666666666666669d+0
              t161 = 1/t26**3
              t162 = 1/rhob**1.3333333333333333d+0
              t163 = 1/rhob**1.1666666666666667d+0
              t164 = -9.970917392951799d-1*t163-7.418564737168958d-1*t16
     1           2-4.002143174996817d-1*t161-1.264669550498372d-1*t160
              t165 = 1/t34**2
              t166 = 1/t31
              t167 = -1.8533958105157808d+0*t163-1.2815820791490704d+0*t
     1           162-8.223668877838045d-1*t161-1.6039141941921276d-1*t16
     2           0
              t168 = 1/t30**2
              t169 = 1.1102230246251565d-16*t159*t164*t165*t37+3.0506411
     1           443514264d-19*t162*t36+1.0d+0*t166*t167*t168*t33+1.3210
     2           398931339265d-3*t162*t32
              t170 = t45+t122
              t171 = t126+t123
              t172 = 1.3333333333333333d+0*t128*t171+1.3333333333333333d
     1           +0*t125*t170
              t173 = -1.923661050931536d+0*t172*t43*t44
              t174 = 7.694644203726144d+0*t133*t44*t48
              t175 = t174+t173+t132
              t176 = -6.21814d-2*t175*t41*t57
              t177 = t174+t173+1.923661050931536d+0*t172+t132
              t178 = 1.9751631321680768d-2*t177*t59*t63
              t179 = -5.980796863619711d-2*t172*t43*t44*t65*t68
              t180 = t69+t39*(2.3923187454478842d-1*t133*t44*t48*t65*t68
     1           +t179+t178+t176+t144+t143+t140+t137+t120+t116+t112)+t64
     2           +t58+6.903522198342671d-18*t36*t37+3.1090699999999993d-
     3           2*t32*t33-rhob*t169
              t181 = 1/rhob**3.6666666666666664d+0
              t182 = 2.562666666666666d-5*gammabb*t1*t147*t181*t4-8.2666
     1           66666666665d-3*gammabb*t1*t181*t6
              t183 = -8.266666666666665d-3*gammabb*t181*t6*t7+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t7+3.1d-3*t182*t4*t6
              t184 = -8.266666666666665d-3*gammabb*t181*t6*t8+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t8+3.1d-3*t183*t4*t6
              t185 = -8.266666666666665d-3*gammabb*t181*t6*t9+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t9+3.1d-3*t184*t4*t6
              t186 = gammabb**2
              t187 = 1/t85**2
              t188 = 1/rhob**6.333333333333333d+0
              t189 = 9.599999999999997d-3*t186*t187*t188*t77-1.599999999
     1           9999998d-1*gammabb*t181*t77*t86
              t190 = -1.5999999999999998d-1*gammabb*t181*t86*t87+9.59999
     1           9999999997d-3*t186*t187*t188*t87+6.0d-2*gammabb*t189*t3
     2           *t86
              t191 = -1.5999999999999998d-1*gammabb*t181*t86*t88+9.59999
     1           9999999997d-3*t186*t187*t188*t88+6.0d-2*gammabb*t190*t3
     2           *t86
              t192 = -1.5999999999999998d-1*gammabb*t181*t86*t89+9.59999
     1           9999999997d-3*t186*t187*t188*t89+6.0d-2*gammabb*t191*t3
     2           *t86
              t193 = 3.1d-3*t1*t2*t6-9.61d-6*t1*t147*t2*t4
              t194 = 3.1d-3*t2*t6*t7-9.61d-6*t147*t2*t4*t7+3.1d-3*t193*t
     1           4*t6
              t195 = 3.1d-3*t2*t6*t8-9.61d-6*t147*t2*t4*t8+3.1d-3*t194*t
     1           4*t6
              t196 = 3.1d-3*t2*t6*t9-9.61d-6*t147*t2*t4*t9+3.1d-3*t195*t
     1           4*t6
              t197 = 1/rhoa**5.333333333333333d+0
              t198 = 6.0d-2*t2*t73*t77-3.6d-3*gammaaa*t153*t197*t77
              t199 = 6.0d-2*t2*t73*t78-3.6d-3*gammaaa*t153*t197*t78+6.0d
     1           -2*gammaaa*t198*t2*t73
              t200 = 6.0d-2*t2*t73*t79-3.6d-3*gammaaa*t153*t197*t79+6.0d
     1           -2*gammaaa*t199*t2*t73
              t201 = 6.0d-2*t2*t73*t80-3.6d-3*gammaaa*t153*t197*t80+6.0d
     1           -2*gammaaa*t2*t200*t73
              t202 = 3.1d-3*t1*t3*t6-9.61d-6*t1*t147*t3*t4
              t203 = 3.1d-3*t3*t6*t7-9.61d-6*t147*t3*t4*t7+3.1d-3*t202*t
     1           4*t6
              t204 = 3.1d-3*t3*t6*t8-9.61d-6*t147*t3*t4*t8+3.1d-3*t203*t
     1           4*t6
              t205 = 3.1d-3*t3*t6*t9-9.61d-6*t147*t3*t4*t9+3.1d-3*t204*t
     1           4*t6
              t206 = 1/rhob**5.333333333333333d+0
              t207 = 6.0d-2*t3*t77*t86-3.6d-3*gammabb*t187*t206*t77
              t208 = 6.0d-2*t3*t86*t87-3.6d-3*gammabb*t187*t206*t87+6.0d
     1           -2*gammabb*t207*t3*t86
              t209 = 6.0d-2*t3*t86*t88-3.6d-3*gammabb*t187*t206*t88+6.0d
     1           -2*gammabb*t208*t3*t86
              t210 = 6.0d-2*t3*t86*t89-3.6d-3*gammabb*t187*t206*t89+6.0d
     1           -2*gammabb*t209*t3*t86
              t211 = 1/taua**2
              t212 = 1/taub**2
              t213 = t99**2
              t214 = 1/t12**5
              t215 = 1/rhoa**2.3333333333333334d+0
              t216 = 1/rhoa**2.1666666666666665d+0
              t217 = t102**2
              t218 = -9.812069668265515d-18*t100*t94*t97*t99-8.497974591
     1           333913d-2*t101*t102*t103*t97+1.1102230246251565d-16*t10
     2           0*(1.1632736958443765d+0*t216+9.89141964955861d-1*t215+
     3           6.003214762495226d-1*t214+2.1077825841639536d-1*t2)*t23
     4           *t94-2.220446049250313d-16*t213*t23*t94/t20**3+1.785458
     5           3920998188d-15*t213*t23/(t20**4*t21**2)-4.0675215258019
     6           015d-19*t215*t22+3.216395899738507d+1*t19*t217/(t16**4*
     7           t17**2)-2.0d+0*t101*t19*t217/t16**3+1.0d+0*t101*t103*t1
     8           9*(2.1622951122684114d+0*t216+1.7087761055320938d+0*t21
     9           5+1.2335503316757068d+0*t214+2.673190323653546d-1*t2)-1
     :           .7613865241785684d-3*t18*t215
              t219 = 2.0d+0*t109*t110*t111*t41*t50
              t220 = -1.1696447245269295d+0*t113*t114*t115*t59*t60
              t221 = 3.847322101863072d+0*t117*t118*t119*t43*t44*t48*t65
              t222 = 5.495546528376875d-3*t107*t50*t57
              t223 = -9.087592854964233d-4*t107*t60*t63
              t224 = 5.082465978296986d-3*t142*t43*t48*t68
              t225 = 4.7846374908957684d-1*t131*t43*t48*t65*t68
              t226 = t109**2
              t227 = 1.6081979498692536d+1*t226*t41*t50/(t55**4*t56**2)
              t228 = -2.0d+0*t111*t226*t41*t50/t55**3
              t229 = -8.837926660346784d-2*t107*t109*t110*t111*t50
              t230 = 1/t39**2.6666666666666666d+0
              t231 = 1/t52**5
              t232 = 1/t39**2.3333333333333334d+0
              t233 = 1/t39**2.1666666666666665d+0
              t234 = 1.0d+0*t110*t111*(1.1632736958443765d+0*t233+9.8914
     1           1964955861d-1*t232+6.003214762495226d-1*t231+2.10778258
     2           41639536d-1*t230)*t41*t50
              t235 = t113**2
              t236 = -1.73158960813529d+1*t235*t59*t60/(t61**4*t62**2)
              t237 = 1.1696447245269295d+0*t115*t235*t59*t60/t61**3
              t238 = 2.690728393099896d-2*t107*t113*t114*t115*t60
              t239 = -5.848223622634647d-1*t114*t115*(1.5861639701225969
     1           d+0*t233+9.98929717145607d-1*t232+3.2257293534574827d-1
     2           *t231+2.1239028834748191d-1*t230)*t59*t60
              t240 = t117**2
              t241 = 6.187255516702861d+1*t240*t43*t44*t48*t65/(t66**4*t
     1           67**2)
              t242 = -3.847322101863072d+0*t119*t240*t43*t44*t48*t65/t66
     1           **3
              t243 = -1.6347222733154887d-1*t117*t118*t119*t142*t43*t48
              t244 = 1.923661050931536d+0*t118*t119*(2.1622951122684114d
     1           +0*t233+1.7087761055320938d+0*t232+1.2335503316757068d+
     2           0*t231+2.673190323653546d-1*t230)*t43*t44*t48*t65
              t245 = -1.538928840745229d+1*t117*t118*t119*t131*t43*t48*t
     1           65
              t246 = 1/t46**6.666666666666666d-1
              t247 = 1/t39**3
              t248 = -2*t247*t42
              t249 = 2*t121
              t250 = 1/t47**6.666666666666666d-1
              t251 = 2*t247*t42
              t252 = -2*t121
              t253 = 1.3333333333333333d+0*t128*(t252+t251)+4.4444444444
     1           44444d-1*t127**2*t250+1.3333333333333333d+0*t125*(t249+
     2           t248)+4.444444444444444d-1*t124**2*t246
              t254 = -1.923661050931536d+0*t253*t43*t44
              t255 = 1.5389288407452287d+1*t129*t131*t43
              t256 = -1.5389288407452287d+1*t129*t133*t44
              t257 = 1/t39**6
              t258 = -3.8473221018630716d+1*t257*t43*t48
              t259 = 6.155715362980915d+1*t131*t133*t48
              t260 = t42**2
              t261 = -2.3083932611178434d+1*t260*t44*t48
              t262 = -3.663697685584583d-3*t232*t50*t57
              t263 = 6.058395236642822d-4*t232*t60*t63
              t264 = -2.3718174565385935d-2*t43*t48*t68/t39**6.333333333
     1           333333d+0
              t265 = -1.1961593727239421d+0*t257*t43*t48*t65*t68
              t266 = -7.176956236343652d-1*t260*t44*t48*t65*t68
              t267 = 1/rhoa**7.333333333333333d+0
              t268 = 1/t5**3
              t269 = 1/rhoa**4.666666666666667d+0
              t270 = 1/rhoa**2
              t271 = gammaaa**3
              t272 = 1/t72**3
              t273 = 1/rhoa**10
              t274 = 2.6666666666666666d+0*t128*t247*t42-2.6666666666666
     1           666d+0*t125*t247*t42+4.444444444444444d-1*t127*t171*t25
     2           0+4.444444444444444d-1*t124*t170*t246
              t275 = -1.923661050931536d+0*t274*t43*t44
              t276 = 7.694644203726144d+0*t131*t172*t43
              t277 = -7.694644203726144d+0*t133*t172*t44
              t278 = 7.694644203726144d+0*t129*t131*t43
              t279 = 7.694644203726144d+0*t129*t133*t44
              t280 = 2.3083932611178434d+1*t260*t44*t48
              t281 = t164**2
              t282 = 1/t26**5
              t283 = 1/rhob**2.3333333333333334d+0
              t284 = 1/rhob**2.1666666666666665d+0
              t285 = t167**2
              t286 = 1.7854583920998188d-15*t281*t37/(t34**4*t35**2)-2.2
     1           20446049250313d-16*t159*t281*t37/t34**3+1.1102230246251
     2           565d-16*t159*t165*(2.1077825841639536d-1*t3+1.163273695
     3           8443765d+0*t284+9.89141964955861d-1*t283+6.003214762495
     4           226d-1*t282)*t37-4.0675215258019015d-19*t283*t36+3.2163
     5           95899738507d+1*t285*t33/(t30**4*t31**2)-2.0d+0*t166*t28
     6           5*t33/t30**3+1.0d+0*t166*t168*(2.673190323653546d-1*t3+
     7           2.1622951122684114d+0*t284+1.7087761055320938d+0*t283+1
     8           .2335503316757068d+0*t282)*t33-1.7613865241785684d-3*t2
     9           83*t32-8.497974591333913d-2*t162*t166*t167*t168-9.81206
     :           9668265515d-18*t159*t162*t164*t165
              t287 = 1.3333333333333333d+0*t125*(t252+t248)+1.3333333333
     1           333333d+0*t128*(t251+t249)+4.444444444444444d-1*t171**2
     2           *t250+4.444444444444444d-1*t170**2*t246
              t288 = -1.923661050931536d+0*t287*t43*t44
              t289 = 1.5389288407452287d+1*t131*t172*t43
              t290 = 1.5389288407452287d+1*t133*t172*t44
              t291 = -6.155715362980915d+1*t131*t133*t48
              t292 = 1/rhob**7.333333333333333d+0
              t293 = 1/rhob**4.666666666666667d+0
              t294 = 1/rhob**2
              t295 = gammabb**3
              t296 = 1/t85**3
              t297 = 1/rhob**10
              t298 = 1.25d-1*t24*t81
              t299 = 1/rhoa**9
              t300 = 1.25d-1*t38*t90
              t301 = 1/rhob**9
              t302 = 1/rhoa**8
              t303 = 1/rhob**8
              fnc(iq) = (5.0d-1*rhob*t38*t90*t91*t93+5.0d-1*rhoa*t24*t81
     1           *t82*t84+1.0d+0*t10*t70)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t82*(5.0d-1*t24*t81*t84+5.0d-1*rhoa*t104
     1           *t81*t84+5.0d-1*rhoa*t158*t24*t84)+1.25d-1*gammaaa*t24*
     2           t81*t82*t83+1.0d+0*t151*t70+1.0d+0*t10*t145)*wght+Amat(
     3           iq,D1_RA)
              Amat(iq,D1_RB) = (t91*(5.0d-1*t38*t90*t93+5.0d-1*rhob*t169
     1           *t90*t93+5.0d-1*rhob*t192*t38*t93)+1.25d-1*gammabb*t38*
     2           t90*t91*t92+1.0d+0*t185*t70+1.0d+0*t10*t180)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = (t82*(5.0d-1*rhoa*t201*t24*t84-1.25d-1*t
     1           24*t81)+1.0d+0*t196*t70)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t91*(5.0d-1*rhob*t210*t38*t93-1.25d-1*t
     1           38*t90)+1.0d+0*t205*t70)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t24*t81*t82-5.0d-1*rhoa*t211
     1           *t24*t81*t84)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t38*t90*t91-5.0d-1*rhob*t212
     1           *t38*t90*t93)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t10*(-2.220446049250313d-16*t
     1           100*t23*t94*t99-6.101282288702853d-19*t22*t97-2.6420797
     2           86267853d-3*t18*t97+t39*(1.9138549963583074d+0*t131*t13
     3           3*t48*t65*t68-5.980796863619711d-2*t253*t43*t44*t65*t68
     4           -4.7846374908957684d-1*t129*t133*t44*t65*t68+4.78463749
     5           08957684d-1*t129*t131*t43*t65*t68+2.0329863913187946d-2
     6           *t133*t142*t48*t68+5.082465978296986d-3*t129*t142*t43*t
     7           68+1.538928840745229d+1*t117*t118*t119*t133*t44*t48*t65
     8           +3.847322101863072d+0*t117*t118*t119*t129*t43*t44*t65+1
     9           .9751631321680768d-2*(t261+t259+t258+t256+t255+t254+1.9
     :           23661050931536d+0*t253)*t59*t63-9.087592854964233d-4*t1
     ;           07*t138*t63-1.1696447245269295d+0*t113*t114*t115*t138*t
     <           59-6.21814d-2*(t261+t259+t258+t256+t255+t254)*t41*t57+5
     =           .495546528376875d-3*t107*t135*t57+2.0d+0*t109*t110*t111
     >           *t135*t41+t266+t265+t264+t263+t262+t245+t244+t243+t242+
     ?           t241+t239+t238+t237+t236+t234+t229+t228+t227)-4.7846374
     @           908957684d-1*t133*t44*t48*t65*t68-1.1961593727239421d-1
     1           *t129*t43*t44*t65*t68+3.9503262643361536d-2*t138*t59*t6
     2           3-1.243628d-1*t135*t41*t57+t225+t224+t223+t222+t221+t22
     3           0+t219-rhoa*t218-2.0d+0*t101*t102*t103*t19)+1.0d+0*t70*
     4           (3.0311111111111105d-2*gammaaa*t269*t6*t9-9.39644444444
     5           4442d-5*gammaaa*t147*t269*t4*t9+4.2369422222222203d-7*t
     6           152*t267*t268*t4*t9-1.366755555555555d-4*t147*t152*t267
     7           *t9+3.1d-3*t4*t6*(3.0311111111111105d-2*gammaaa*t269*t6
     8           *t8-9.396444444444442d-5*gammaaa*t147*t269*t4*t8+4.2369
     9           422222222203d-7*t152*t267*t268*t4*t8-1.366755555555555d
     :           -4*t147*t152*t267*t8+3.1d-3*t4*t6*(3.0311111111111105d-
     ;           2*gammaaa*t269*t6*t7-9.396444444444442d-5*gammaaa*t147*
     <           t269*t4*t7+4.2369422222222203d-7*t152*t267*t268*t4*t7-1
     =           .366755555555555d-4*t147*t152*t267*t7+3.1d-3*t4*t6*(3.0
     >           311111111111105d-2*gammaaa*t1*t269*t6-9.396444444444442
     ?           d-5*gammaaa*t1*t147*t269*t4+4.2369422222222203d-7*t1*t1
     @           52*t267*t268*t4-1.366755555555555d-4*t1*t147*t152*t267)
     1           -1.653333333333333d-2*gammaaa*t146*t148*t6+5.1253333333
     2           33332d-5*gammaaa*t146*t147*t148*t4)-1.653333333333333d-
     3           2*gammaaa*t146*t149*t6+5.125333333333332d-5*gammaaa*t14
     4           6*t147*t149*t4)-1.653333333333333d-2*gammaaa*t146*t150*
     5           t6+5.125333333333332d-5*gammaaa*t146*t147*t150*t4)+t82*
     6           (5.0d-1*rhoa*t218*t81*t84+1.0d+0*t104*t81*t84+5.0d-1*rh
     7           oa*t24*(5.866666666666666d-1*gammaaa*t269*t73*t80+3.071
     8           9999999999986d-3*t271*t272*t273*t80-8.639999999999998d-
     9           2*t152*t153*t267*t80+6.0d-2*gammaaa*t2*t73*(5.866666666
     :           666666d-1*gammaaa*t269*t73*t79+3.0719999999999986d-3*t2
     ;           71*t272*t273*t79-8.639999999999998d-2*t152*t153*t267*t7
     <           9+6.0d-2*gammaaa*t2*t73*(5.866666666666666d-1*gammaaa*t
     =           269*t73*t78+3.0719999999999986d-3*t271*t272*t273*t78-8.
     >           639999999999998d-2*t152*t153*t267*t78+6.0d-2*gammaaa*t2
     ?           *t73*(5.866666666666666d-1*gammaaa*t269*t73*t77+3.07199
     @           99999999986d-3*t271*t272*t273*t77-8.639999999999998d-2*
     1           t152*t153*t267*t77)-3.1999999999999995d-1*gammaaa*t146*
     2           t155*t73+1.9199999999999995d-2*t152*t153*t154*t155)-3.1
     3           999999999999995d-1*gammaaa*t146*t156*t73+1.919999999999
     4           9995d-2*t152*t153*t154*t156)-3.1999999999999995d-1*gamm
     5           aaa*t146*t157*t73+1.9199999999999995d-2*t152*t153*t154*
     6           t157)*t84+1.0d+0*t158*t24*t84+1.0d+0*rhoa*t104*t158*t84
     7           +1.25d-1*gammaaa*t104*t81*t83+1.25d-1*gammaaa*t158*t24*
     8           t83+1.25d-1*gammaaa*t24*t270*t81)+(1.25d-1*gammaaa*t104
     9           *t81+1.25d-1*gammaaa*t158*t24)*t82*t83-1.25d-1*gammaaa*
     :           t24*t270*t81*t82+2.0d+0*t145*t151)*wght+Amat2(iq,D2_RA_
     ;           RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t70*(4.2369422222222203d-7*ga
     1           mmaaa*gammabb*t146*t181*t268*t4*t9-1.366755555555555d-4
     2           *gammaaa*gammabb*t146*t147*t181*t9+3.1d-3*t4*t6*(4.2369
     3           422222222203d-7*gammaaa*gammabb*t146*t181*t268*t4*t8-1.
     4           366755555555555d-4*gammaaa*gammabb*t146*t147*t181*t8+3.
     5           1d-3*t4*t6*(4.2369422222222203d-7*gammaaa*gammabb*t146*
     6           t181*t268*t4*t7-1.366755555555555d-4*gammaaa*gammabb*t1
     7           46*t147*t181*t7+3.1d-3*t4*(4.2369422222222203d-7*gammaa
     8           a*gammabb*t1*t146*t181*t268*t4-1.366755555555555d-4*gam
     9           maaa*gammabb*t1*t146*t147*t181)*t6-8.266666666666665d-3
     :           *gammaaa*t146*t182*t6-8.266666666666665d-3*gammabb*t148
     ;           *t181*t6+2.562666666666666d-5*gammaaa*t146*t147*t182*t4
     <           +2.562666666666666d-5*gammabb*t147*t148*t181*t4)-8.2666
     =           66666666665d-3*gammaaa*t146*t183*t6-8.266666666666665d-
     >           3*gammabb*t149*t181*t6+2.562666666666666d-5*gammaaa*t14
     ?           6*t147*t183*t4+2.562666666666666d-5*gammabb*t147*t149*t
     @           181*t4)-8.266666666666665d-3*gammaaa*t146*t184*t6-8.266
     1           666666666665d-3*gammabb*t150*t181*t6+2.562666666666666d
     2           -5*gammaaa*t146*t147*t184*t4+2.562666666666666d-5*gamma
     3           bb*t147*t150*t181*t4)+1.0d+0*t10*(t39*(7.17695623634365
     4           2d-1*t260*t44*t48*t65*t68-5.980796863619711d-2*t274*t43
     5           *t44*t65*t68-2.3923187454478842d-1*t133*t172*t44*t65*t6
     6           8+2.3923187454478842d-1*t129*t133*t44*t65*t68+2.3923187
     7           454478842d-1*t131*t172*t43*t65*t68+2.3923187454478842d-
     8           1*t129*t131*t43*t65*t68+2.541232989148493d-3*t142*t172*
     9           t43*t68+2.541232989148493d-3*t129*t142*t43*t68+1.923661
     :           050931536d+0*t117*t118*t119*t172*t43*t44*t65+1.92366105
     ;           0931536d+0*t117*t118*t119*t129*t43*t44*t65+1.9751631321
     <           680768d-2*(t280+t279+t278+t277+t276+t275+1.923661050931
     =           536d+0*t274+t258)*t59*t63-4.5437964274821163d-4*t107*t1
     >           77*t63-4.5437964274821163d-4*t107*t138*t63-5.8482236226
     ?           34647d-1*t113*t114*t115*t177*t59-5.848223622634647d-1*t
     @           113*t114*t115*t138*t59-6.21814d-2*(t280+t279+t278+t277+
     1           t276+t275+t258)*t41*t57+2.747773264188437d-3*t107*t175*
     2           t57+2.747773264188437d-3*t107*t135*t57+1.0d+0*t109*t110
     3           *t111*t175*t41+1.0d+0*t109*t110*t111*t135*t41+t265+t264
     4           +t263+t262+t245+t244+t243+t242+t241+t239+t238+t237+t236
     5           +t234+t229+t228+t227)+t225+t224+t223+t222+t221+t220+t21
     6           9+t179+t178+t176+t141+t139+t136)+1.0d+0*t145*t185+1.0d+
     7           0*t151*t180)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t91*(5.0d-1*rhob*t286*t90*t93+1.0d+0
     1           *t169*t90*t93+5.0d-1*rhob*t38*(5.866666666666666d-1*gam
     2           mabb*t293*t86*t89+3.0719999999999986d-3*t295*t296*t297*
     3           t89-8.639999999999998d-2*t186*t187*t292*t89+6.0d-2*gamm
     4           abb*t3*t86*(5.866666666666666d-1*gammabb*t293*t86*t88+3
     5           .0719999999999986d-3*t295*t296*t297*t88-8.6399999999999
     6           98d-2*t186*t187*t292*t88+6.0d-2*gammabb*t3*t86*(5.86666
     7           6666666666d-1*gammabb*t293*t86*t87+3.0719999999999986d-
     8           3*t295*t296*t297*t87-8.639999999999998d-2*t186*t187*t29
     9           2*t87+6.0d-2*gammabb*t3*t86*(5.866666666666666d-1*gamma
     :           bb*t293*t77*t86+3.0719999999999986d-3*t295*t296*t297*t7
     ;           7-8.639999999999998d-2*t186*t187*t292*t77)-3.1999999999
     <           999995d-1*gammabb*t181*t189*t86+1.9199999999999995d-2*t
     =           186*t187*t188*t189)-3.1999999999999995d-1*gammabb*t181*
     >           t190*t86+1.9199999999999995d-2*t186*t187*t188*t190)-3.1
     ?           999999999999995d-1*gammabb*t181*t191*t86+1.919999999999
     @           9995d-2*t186*t187*t188*t191)*t93+1.0d+0*t192*t38*t93+1.
     1           0d+0*rhob*t169*t192*t93+1.25d-1*gammabb*t169*t90*t92+1.
     2           25d-1*gammabb*t192*t38*t92+1.25d-1*gammabb*t294*t38*t90
     3           )+(1.25d-1*gammabb*t169*t90+1.25d-1*gammabb*t192*t38)*t
     4           91*t92-1.25d-1*gammabb*t294*t38*t90*t91+1.0d+0*t70*(3.0
     5           311111111111105d-2*gammabb*t293*t6*t9-9.396444444444442
     6           d-5*gammabb*t147*t293*t4*t9+4.2369422222222203d-7*t186*
     7           t268*t292*t4*t9-1.366755555555555d-4*t147*t186*t292*t9+
     8           3.1d-3*t4*t6*(3.0311111111111105d-2*gammabb*t293*t6*t8-
     9           9.396444444444442d-5*gammabb*t147*t293*t4*t8+4.23694222
     :           22222203d-7*t186*t268*t292*t4*t8-1.366755555555555d-4*t
     ;           147*t186*t292*t8+3.1d-3*t4*t6*(3.0311111111111105d-2*ga
     <           mmabb*t293*t6*t7-9.396444444444442d-5*gammabb*t147*t293
     =           *t4*t7+4.2369422222222203d-7*t186*t268*t292*t4*t7-1.366
     >           755555555555d-4*t147*t186*t292*t7+3.1d-3*t4*t6*(3.03111
     ?           11111111105d-2*gammabb*t1*t293*t6-9.396444444444442d-5*
     @           gammabb*t1*t147*t293*t4+4.2369422222222203d-7*t1*t186*t
     1           268*t292*t4-1.366755555555555d-4*t1*t147*t186*t292)-1.6
     2           53333333333333d-2*gammabb*t181*t182*t6+5.12533333333333
     3           2d-5*gammabb*t147*t181*t182*t4)-1.653333333333333d-2*ga
     4           mmabb*t181*t183*t6+5.125333333333332d-5*gammabb*t147*t1
     5           81*t183*t4)-1.653333333333333d-2*gammabb*t181*t184*t6+5
     6           .125333333333332d-5*gammabb*t147*t181*t184*t4)+1.0d+0*t
     7           10*(t39*(-1.9138549963583074d+0*t131*t133*t48*t65*t68-5
     8           .980796863619711d-2*t287*t43*t44*t65*t68+4.784637490895
     9           7684d-1*t133*t172*t44*t65*t68+4.7846374908957684d-1*t13
     :           1*t172*t43*t65*t68-2.0329863913187946d-2*t133*t142*t48*
     ;           t68+5.082465978296986d-3*t142*t172*t43*t68-1.5389288407
     <           45229d+1*t117*t118*t119*t133*t44*t48*t65+3.847322101863
     =           072d+0*t117*t118*t119*t172*t43*t44*t65+1.97516313216807
     >           68d-2*(t291+t290+t289+t288+1.923661050931536d+0*t287+t2
     ?           61+t258)*t59*t63-9.087592854964233d-4*t107*t177*t63-1.1
     @           696447245269295d+0*t113*t114*t115*t177*t59-6.21814d-2*(
     1           t291+t290+t289+t288+t261+t258)*t41*t57+5.49554652837687
     2           5d-3*t107*t175*t57+2.0d+0*t109*t110*t111*t175*t41+t266+
     3           t265+t264+t263+t262+t245+t244+t243+t242+t241+t239+t238+
     4           t237+t236+t234+t229+t228+t227)+4.7846374908957684d-1*t1
     5           33*t44*t48*t65*t68-1.1961593727239421d-1*t172*t43*t44*t
     6           65*t68+3.9503262643361536d-2*t177*t59*t63-1.243628d-1*t
     7           175*t41*t57-2.220446049250313d-16*t159*t164*t165*t37-6.
     8           101282288702853d-19*t162*t36-2.0d+0*t166*t167*t168*t33-
     9           2.642079786267853d-3*t162*t32-rhob*t286+t225+t224+t223+
     :           t222+t221+t220+t219)+2.0d+0*t180*t185)*wght+Amat2(iq,D2
     ;           _RB_RB)
              Cmat2(iq,D2_RA_GAA) = (1.0d+0*t70*(-8.266666666666665d-3*t
     1           146*t6*t9-1.5888533333333327d-7*gammaaa*t154*t268*t4*t9
     2           +2.562666666666666d-5*t146*t147*t4*t9+5.125333333333332
     3           d-5*gammaaa*t147*t154*t9+3.1d-3*t4*t6*(-8.2666666666666
     4           65d-3*t146*t6*t8-1.5888533333333327d-7*gammaaa*t154*t26
     5           8*t4*t8+2.562666666666666d-5*t146*t147*t4*t8+5.12533333
     6           3333332d-5*gammaaa*t147*t154*t8+3.1d-3*t4*t6*(-8.266666
     7           666666665d-3*t146*t6*t7-1.5888533333333327d-7*gammaaa*t
     8           154*t268*t4*t7+2.562666666666666d-5*t146*t147*t4*t7+5.1
     9           25333333333332d-5*gammaaa*t147*t154*t7+3.1d-3*t4*t6*(-8
     :           .266666666666665d-3*t1*t146*t6-1.5888533333333327d-7*ga
     ;           mmaaa*t1*t154*t268*t4+2.562666666666666d-5*t1*t146*t147
     <           *t4+5.125333333333332d-5*gammaaa*t1*t147*t154)+3.1d-3*t
     =           148*t2*t6-8.266666666666665d-3*gammaaa*t146*t193*t6-9.6
     >           1d-6*t147*t148*t2*t4+2.562666666666666d-5*gammaaa*t146*
     ?           t147*t193*t4)+3.1d-3*t149*t2*t6-8.266666666666665d-3*ga
     @           mmaaa*t146*t194*t6-9.61d-6*t147*t149*t2*t4+2.5626666666
     1           66666d-5*gammaaa*t146*t147*t194*t4)+3.1d-3*t150*t2*t6-8
     2           .266666666666665d-3*gammaaa*t146*t195*t6-9.61d-6*t147*t
     3           150*t2*t4+2.562666666666666d-5*gammaaa*t146*t147*t195*t
     4           4)+t82*(5.0d-1*rhoa*t24*(-1.5999999999999998d-1*t146*t7
     5           3*t80-1.1519999999999996d-3*t152*t272*t299*t80+2.879999
     6           999999999d-2*gammaaa*t153*t154*t80+6.0d-2*gammaaa*t2*t7
     7           3*(-1.5999999999999998d-1*t146*t73*t79-1.15199999999999
     8           96d-3*t152*t272*t299*t79+2.879999999999999d-2*gammaaa*t
     9           153*t154*t79+6.0d-2*gammaaa*t2*t73*(-1.5999999999999998
     :           d-1*t146*t73*t78-1.1519999999999996d-3*t152*t272*t299*t
     ;           78+2.879999999999999d-2*gammaaa*t153*t154*t78+6.0d-2*ga
     <           mmaaa*t2*t73*(-1.5999999999999998d-1*t146*t73*t77-1.151
     =           9999999999996d-3*t152*t272*t299*t77+2.879999999999999d-
     >           2*gammaaa*t153*t154*t77)+6.0d-2*t155*t2*t73-1.599999999
     ?           9999998d-1*gammaaa*t146*t198*t73+9.599999999999997d-3*t
     @           152*t153*t154*t198-3.6d-3*gammaaa*t153*t155*t197)+6.0d-
     1           2*t156*t2*t73-1.5999999999999998d-1*gammaaa*t146*t199*t
     2           73+9.599999999999997d-3*t152*t153*t154*t199-3.6d-3*gamm
     3           aaa*t153*t156*t197)-1.5999999999999998d-1*gammaaa*t146*
     4           t200*t73+6.0d-2*t157*t2*t73+9.599999999999997d-3*t152*t
     5           153*t154*t200-3.6d-3*gammaaa*t153*t157*t197)*t84+5.0d-1
     6           *t201*t24*t84+5.0d-1*rhoa*t104*t201*t84-1.25d-1*t24*t81
     7           *t83-1.25d-1*t104*t81-1.25d-1*t158*t24)+(t298+1.25d-1*g
     8           ammaaa*t201*t24)*t82*t83+1.0d+0*t145*t196)*wght+Cmat2(i
     9           q,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t70*(-1.5888533333333327d-7*
     1           gammaaa*t146*t268*t3*t4*t9+5.125333333333332d-5*gammaaa
     2           *t146*t147*t3*t9+3.1d-3*t4*t6*(-1.5888533333333327d-7*g
     3           ammaaa*t146*t268*t3*t4*t8+5.125333333333332d-5*gammaaa*
     4           t146*t147*t3*t8+3.1d-3*t4*t6*(-1.5888533333333327d-7*ga
     5           mmaaa*t146*t268*t3*t4*t7+5.125333333333332d-5*gammaaa*t
     6           146*t147*t3*t7+3.1d-3*t4*(5.125333333333332d-5*gammaaa*
     7           t1*t146*t147*t3-1.5888533333333327d-7*gammaaa*t1*t146*t
     8           268*t3*t4)*t6+3.1d-3*t148*t3*t6-8.266666666666665d-3*ga
     9           mmaaa*t146*t202*t6-9.61d-6*t147*t148*t3*t4+2.5626666666
     :           66666d-5*gammaaa*t146*t147*t202*t4)+3.1d-3*t149*t3*t6-8
     ;           .266666666666665d-3*gammaaa*t146*t203*t6-9.61d-6*t147*t
     <           149*t3*t4+2.562666666666666d-5*gammaaa*t146*t147*t203*t
     =           4)+3.1d-3*t150*t3*t6-8.266666666666665d-3*gammaaa*t146*
     >           t204*t6-9.61d-6*t147*t150*t3*t4+2.562666666666666d-5*ga
     ?           mmaaa*t146*t147*t204*t4)+1.0d+0*t145*t205)*wght+Cmat2(i
     @           q,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t70*(-1.5888533333333327d-7*
     1           gammabb*t181*t2*t268*t4*t9+5.125333333333332d-5*gammabb
     2           *t147*t181*t2*t9+3.1d-3*t4*t6*(-1.5888533333333327d-7*g
     3           ammabb*t181*t2*t268*t4*t8+5.125333333333332d-5*gammabb*
     4           t147*t181*t2*t8+3.1d-3*t4*t6*(-1.5888533333333327d-7*ga
     5           mmabb*t181*t2*t268*t4*t7+5.125333333333332d-5*gammabb*t
     6           147*t181*t2*t7+3.1d-3*t4*(5.125333333333332d-5*gammabb*
     7           t1*t147*t181*t2-1.5888533333333327d-7*gammabb*t1*t181*t
     8           2*t268*t4)*t6+3.1d-3*t182*t2*t6-8.266666666666665d-3*ga
     9           mmabb*t181*t193*t6-9.61d-6*t147*t182*t2*t4+2.5626666666
     :           66666d-5*gammabb*t147*t181*t193*t4)+3.1d-3*t183*t2*t6-8
     ;           .266666666666665d-3*gammabb*t181*t194*t6-9.61d-6*t147*t
     <           183*t2*t4+2.562666666666666d-5*gammabb*t147*t181*t194*t
     =           4)+3.1d-3*t184*t2*t6-8.266666666666665d-3*gammabb*t181*
     >           t195*t6-9.61d-6*t147*t184*t2*t4+2.562666666666666d-5*ga
     ?           mmabb*t147*t181*t195*t4)+1.0d+0*t180*t196)*wght+Cmat2(i
     @           q,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t91*(5.0d-1*rhob*t38*(-1.5999999999
     1           999998d-1*t181*t86*t89-1.1519999999999996d-3*t186*t296*
     2           t301*t89+2.879999999999999d-2*gammabb*t187*t188*t89+6.0
     3           d-2*gammabb*t3*t86*(-1.5999999999999998d-1*t181*t86*t88
     4           -1.1519999999999996d-3*t186*t296*t301*t88+2.87999999999
     5           9999d-2*gammabb*t187*t188*t88+6.0d-2*gammabb*t3*t86*(-1
     6           .5999999999999998d-1*t181*t86*t87-1.1519999999999996d-3
     7           *t186*t296*t301*t87+2.879999999999999d-2*gammabb*t187*t
     8           188*t87+6.0d-2*gammabb*t3*t86*(-1.5999999999999998d-1*t
     9           181*t77*t86-1.1519999999999996d-3*t186*t296*t301*t77+2.
     :           879999999999999d-2*gammabb*t187*t188*t77)+6.0d-2*t189*t
     ;           3*t86-1.5999999999999998d-1*gammabb*t181*t207*t86+9.599
     <           999999999997d-3*t186*t187*t188*t207-3.6d-3*gammabb*t187
     =           *t189*t206)+6.0d-2*t190*t3*t86-1.5999999999999998d-1*ga
     >           mmabb*t181*t208*t86+9.599999999999997d-3*t186*t187*t188
     ?           *t208-3.6d-3*gammabb*t187*t190*t206)+6.0d-2*t191*t3*t86
     @           -1.5999999999999998d-1*gammabb*t181*t209*t86+9.59999999
     1           9999997d-3*t186*t187*t188*t209-3.6d-3*gammabb*t187*t191
     2           *t206)*t93+5.0d-1*t210*t38*t93+5.0d-1*rhob*t169*t210*t9
     3           3-1.25d-1*t38*t90*t92-1.25d-1*t169*t90-1.25d-1*t192*t38
     4           )+(1.25d-1*gammabb*t210*t38+t300)*t91*t92+1.0d+0*t70*(-
     5           8.266666666666665d-3*t181*t6*t9-1.5888533333333327d-7*g
     6           ammabb*t188*t268*t4*t9+2.562666666666666d-5*t147*t181*t
     7           4*t9+5.125333333333332d-5*gammabb*t147*t188*t9+3.1d-3*t
     8           4*t6*(-8.266666666666665d-3*t181*t6*t8-1.58885333333333
     9           27d-7*gammabb*t188*t268*t4*t8+2.562666666666666d-5*t147
     :           *t181*t4*t8+5.125333333333332d-5*gammabb*t147*t188*t8+3
     ;           .1d-3*t4*t6*(-8.266666666666665d-3*t181*t6*t7-1.5888533
     <           333333327d-7*gammabb*t188*t268*t4*t7+2.562666666666666d
     =           -5*t147*t181*t4*t7+5.125333333333332d-5*gammabb*t147*t1
     >           88*t7+3.1d-3*t4*t6*(-8.266666666666665d-3*t1*t181*t6-1.
     ?           5888533333333327d-7*gammabb*t1*t188*t268*t4+2.562666666
     @           666666d-5*t1*t147*t181*t4+5.125333333333332d-5*gammabb*
     1           t1*t147*t188)+3.1d-3*t182*t3*t6-8.266666666666665d-3*ga
     2           mmabb*t181*t202*t6-9.61d-6*t147*t182*t3*t4+2.5626666666
     3           66666d-5*gammabb*t147*t181*t202*t4)+3.1d-3*t183*t3*t6-8
     4           .266666666666665d-3*gammabb*t181*t203*t6-9.61d-6*t147*t
     5           183*t3*t4+2.562666666666666d-5*gammabb*t147*t181*t203*t
     6           4)+3.1d-3*t184*t3*t6-8.266666666666665d-3*gammabb*t181*
     7           t204*t6-9.61d-6*t147*t184*t3*t4+2.562666666666666d-5*ga
     8           mmabb*t147*t181*t204*t4)+1.0d+0*t180*t205)*wght+Cmat2(i
     9           q,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t70*(5.9582d-8*t197*t268*t4
     1           *t9-1.9219999999999998d-5*t147*t197*t9+3.1d-3*t4*t6*(5.
     2           9582d-8*t197*t268*t4*t8-1.9219999999999998d-5*t147*t197
     3           *t8+3.1d-3*t4*t6*(5.9582d-8*t197*t268*t4*t7-1.921999999
     4           9999998d-5*t147*t197*t7+3.1d-3*t4*(5.9582d-8*t1*t197*t2
     5           68*t4-1.9219999999999998d-5*t1*t147*t197)*t6+6.2d-3*t19
     6           3*t2*t6-1.9219999999999998d-5*t147*t193*t2*t4)+6.2d-3*t
     7           194*t2*t6-1.9219999999999998d-5*t147*t194*t2*t4)+6.2d-3
     8           *t195*t2*t6-1.9219999999999998d-5*t147*t195*t2*t4)+t82*
     9           (5.0d-1*rhoa*t24*(4.32d-4*gammaaa*t272*t302*t80-7.2d-3*
     :           t153*t197*t80+6.0d-2*gammaaa*t2*t73*(4.32d-4*gammaaa*t2
     ;           72*t302*t79-7.2d-3*t153*t197*t79+6.0d-2*gammaaa*t2*t73*
     <           (4.32d-4*gammaaa*t272*t302*t78-7.2d-3*t153*t197*t78+6.0
     =           d-2*gammaaa*t2*t73*(4.32d-4*gammaaa*t272*t302*t77-7.2d-
     >           3*t153*t197*t77)+1.2d-1*t198*t2*t73-7.2d-3*gammaaa*t153
     ?           *t197*t198)+1.2d-1*t199*t2*t73-7.2d-3*gammaaa*t153*t197
     @           *t199)+1.2d-1*t2*t200*t73-7.2d-3*gammaaa*t153*t197*t200
     1           )*t84-2.5d-1*t201*t24))*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t70*(5.9582d-8*t2*t268*t3*t4
     1           *t9-1.9219999999999998d-5*t147*t2*t3*t9+3.1d-3*t4*t6*(5
     2           .9582d-8*t2*t268*t3*t4*t8-1.9219999999999998d-5*t147*t2
     3           *t3*t8+3.1d-3*t4*t6*(5.9582d-8*t2*t268*t3*t4*t7-1.92199
     4           99999999998d-5*t147*t2*t3*t7+3.1d-3*t4*(5.9582d-8*t1*t2
     5           *t268*t3*t4-1.9219999999999998d-5*t1*t147*t2*t3)*t6+3.1
     6           d-3*t193*t3*t6+3.1d-3*t2*t202*t6-9.61d-6*t147*t193*t3*t
     7           4-9.61d-6*t147*t2*t202*t4)+3.1d-3*t194*t3*t6+3.1d-3*t2*
     8           t203*t6-9.61d-6*t147*t194*t3*t4-9.61d-6*t147*t2*t203*t4
     9           )+3.1d-3*t195*t3*t6+3.1d-3*t2*t204*t6-9.61d-6*t147*t195
     :           *t3*t4-9.61d-6*t147*t2*t204*t4)*wght+Cmat2(iq,D2_GAA_GB
     ;           B)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t91*(5.0d-1*rhob*t38*(4.32d-4*gamm
     1           abb*t296*t303*t89-7.2d-3*t187*t206*t89+6.0d-2*gammabb*t
     2           3*t86*(4.32d-4*gammabb*t296*t303*t88-7.2d-3*t187*t206*t
     3           88+6.0d-2*gammabb*t3*t86*(4.32d-4*gammabb*t296*t303*t87
     4           -7.2d-3*t187*t206*t87+6.0d-2*gammabb*t3*(4.32d-4*gammab
     5           b*t296*t303*t77-7.2d-3*t187*t206*t77)*t86+1.2d-1*t207*t
     6           3*t86-7.2d-3*gammabb*t187*t206*t207)+1.2d-1*t208*t3*t86
     7           -7.2d-3*gammabb*t187*t206*t208)+1.2d-1*t209*t3*t86-7.2d
     8           -3*gammabb*t187*t206*t209)*t93-2.5d-1*t210*t38)+1.0d+0*
     9           t70*(5.9582d-8*t206*t268*t4*t9-1.9219999999999998d-5*t1
     :           47*t206*t9+3.1d-3*t4*t6*(5.9582d-8*t206*t268*t4*t8-1.92
     ;           19999999999998d-5*t147*t206*t8+3.1d-3*t4*t6*(5.9582d-8*
     <           t206*t268*t4*t7-1.9219999999999998d-5*t147*t206*t7+3.1d
     =           -3*t4*(5.9582d-8*t1*t206*t268*t4-1.9219999999999998d-5*
     >           t1*t147*t206)*t6+6.2d-3*t202*t3*t6-1.9219999999999998d-
     ?           5*t147*t202*t3*t4)+6.2d-3*t203*t3*t6-1.9219999999999998
     @           d-5*t147*t203*t3*t4)+6.2d-3*t204*t3*t6-1.92199999999999
     1           98d-5*t147*t204*t3*t4))*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t211*(-5.0d-1*t24*t81*t84-5.0d-1*rho
     1           a*t104*t81*t84-5.0d-1*rhoa*t158*t24*t84)-1.25d-1*gammaa
     2           a*t211*t24*t81*t83+(1.0d+0*t24*t81+1.0d+0*rhoa*t104*t81
     3           +1.0d+0*rhoa*t158*t24)*t82)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t212*(-5.0d-1*t38*t90*t93-5.0d-1*rho
     1           b*t169*t90*t93-5.0d-1*rhob*t192*t38*t93)-1.25d-1*gammab
     2           b*t212*t38*t90*t92+(1.0d+0*t38*t90+1.0d+0*rhob*t169*t90
     3           +1.0d+0*rhob*t192*t38)*t91)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (t211*(t298-5.0d-1*rhoa*t201*t24*t84
     1           )+1.0d+0*rhoa*t201*t24*t82)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (t212*(t300-5.0d-1*rhob*t210*t38*t93
     1           )+1.0d+0*rhob*t210*t38*t91)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t24*t81*t84/taua**3-2.0d
     1           +0*rhoa*t211*t24*t81)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t38*t90*t93/taub**3-2.0d
     1           +0*rhob*t212*t38*t90)*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhoa**2.6666666666666666d+0
              t28 = gammaaa*t27+4.0d-50*t2
              t29 = 3.1d-3*t28+1.0d+0
              t30 = 1/t29
              t31 = param(5)
              t32 = 3.1d-3*t28*t30*t31+param(4)
              t33 = 3.1d-3*t28*t30*t32+param(3)
              t34 = 3.1d-3*t28*t30*t33+param(2)
              t35 = 3.1d-3*t28*t30*t34+param(1)
              t36 = 1/rhoa**6.666666666666666d-1
              t37 = rhoa**5.0d-1
              t38 = 1/t37
              t39 = 1/rhoa**3.333333333333333d-1
              t40 = 1/rhoa**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhoa*t49-rhob*t26
              t82 = 6.0d-2*gammaaa*t27+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammaaa*t27*t8*t83+t7
              t85 = 6.0d-2*gammaaa*t27*t83*t84+t6
              t86 = 6.0d-2*gammaaa*t27*t83*t85+t5
              t87 = 6.0d-2*gammaaa*t27*t83*t86+t1
              t88 = 1/taua
              t89 = 1/rhoa
              t90 = 2.0d+0*taua-2.5d-1*gammaaa*t89
              t91 = 1/t46
              t92 = 1/rhoa**1.6666666666666669d+0
              t93 = 1/t37**3
              t94 = 1/rhoa**1.3333333333333333d+0
              t95 = 1/rhoa**1.1666666666666667d+0
              t96 = -9.970917392951799d-1*t95-7.418564737168958d-1*t94-4
     1           .002143174996817d-1*t93-1.264669550498372d-1*t92
              t97 = 1/t45**2
              t98 = 1/t42
              t99 = -1.8533958105157808d+0*t95-1.2815820791490704d+0*t94
     1           -8.223668877838045d-1*t93-1.6039141941921276d-1*t92
              t100 = 1/t41**2
              t101 = 1.0d+0*t100*t44*t98*t99+1.1102230246251565d-16*t48*
     1           t91*t96*t97+3.0506411443514264d-19*t47*t94+1.3210398931
     2           339265d-3*t43*t94
              t102 = 1/t50**1.6666666666666669d+0
              t103 = 1/t63**3
              t104 = 1/t50**1.3333333333333333d+0
              t105 = 1/t50**1.1666666666666667d+0
              t106 = -9.970917392951799d-1*t105-7.418564737168958d-1*t10
     1           4-4.002143174996817d-1*t103-1.264669550498372d-1*t102
              t107 = 1/t66**2
              t108 = 1/t67
              t109 = 1.0d+0*t106*t107*t108*t52*t61
              t110 = -1.3595691172479402d+0*t105-7.491972878592053d-1*t1
     1           04-2.1504862356383217d-1*t103-1.2743417300848914d-1*t10
     2           2
              t111 = 1/t72**2
              t112 = 1/t73
              t113 = -5.848223622634647d-1*t110*t111*t112*t70*t71
              t114 = -1.8533958105157808d+0*t105-1.2815820791490704d+0*t
     1           104-8.223668877838045d-1*t103-1.6039141941921276d-1*t10
     2           2
              t115 = 1/t77**2
              t116 = 1/t78
              t117 = 1.923661050931536d+0*t114*t115*t116*t54*t55*t59*t76
              t118 = 1/t50**2
              t119 = t118*t53
              t120 = -t56
              t121 = t120+t119
              t122 = t57**3.333333333333333d-1
              t123 = -t118*t53
              t124 = t56+t123
              t125 = t58**3.333333333333333d-1
              t126 = 1.3333333333333333d+0*t124*t125+1.3333333333333333d
     1           +0*t121*t122
              t127 = -1.923661050931536d+0*t126*t54*t55
              t128 = 1/t50**5
              t129 = 7.694644203726144d+0*t128*t54*t59
              t130 = t53**3
              t131 = -7.694644203726144d+0*t130*t55*t59
              t132 = t131+t129+t127
              t133 = -6.21814d-2*t132*t52*t68
              t134 = 2.747773264188437d-3*t104*t61*t68
              t135 = t131+t129+t127+1.923661050931536d+0*t126
              t136 = 1.9751631321680768d-2*t135*t70*t74
              t137 = -4.5437964274821163d-4*t104*t71*t74
              t138 = -5.980796863619711d-2*t126*t54*t55*t76*t79
              t139 = 1/t50**5.333333333333333d+0
              t140 = 2.541232989148493d-3*t139*t54*t59*t79
              t141 = 2.3923187454478842d-1*t128*t54*t59*t76*t79
              t142 = t80+t50*(-2.3923187454478842d-1*t130*t55*t59*t76*t7
     1           9+t141+t140+t138+t137+t136+t134+t133+t117+t113+t109)+t7
     2           5+t69+6.903522198342671d-18*t47*t48+3.1090699999999993d
     3           -2*t43*t44-rhoa*t101
              t143 = 1/rhoa**3.6666666666666664d+0
              t144 = 1/t29**2
              t145 = 2.562666666666666d-5*gammaaa*t143*t144*t28*t31-8.26
     1           6666666666665d-3*gammaaa*t143*t30*t31
              t146 = -8.266666666666665d-3*gammaaa*t143*t30*t32+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t32+3.1d-3*t145*t28*
     2           t30
              t147 = -8.266666666666665d-3*gammaaa*t143*t30*t33+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t33+3.1d-3*t146*t28*
     2           t30
              t148 = -8.266666666666665d-3*gammaaa*t143*t30*t34+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t34+3.1d-3*t147*t28*
     2           t30
              t149 = gammaaa**2
              t150 = 1/t82**2
              t151 = 1/rhoa**6.333333333333333d+0
              t152 = 9.599999999999997d-3*t149*t150*t151*t8-1.5999999999
     1           999998d-1*gammaaa*t143*t8*t83
              t153 = -1.5999999999999998d-1*gammaaa*t143*t83*t84+9.59999
     1           9999999997d-3*t149*t150*t151*t84+6.0d-2*gammaaa*t152*t2
     2           7*t83
              t154 = -1.5999999999999998d-1*gammaaa*t143*t83*t85+9.59999
     1           9999999997d-3*t149*t150*t151*t85+6.0d-2*gammaaa*t153*t2
     2           7*t83
              t155 = -1.5999999999999998d-1*gammaaa*t143*t83*t86+9.59999
     1           9999999997d-3*t149*t150*t151*t86+6.0d-2*gammaaa*t154*t2
     2           7*t83
              t156 = 1/t23
              t157 = 1/t14**3
              t158 = 1/rhob**1.3333333333333333d+0
              t159 = 1/rhob**1.1666666666666667d+0
              t160 = -1.264669550498372d-1*t2-9.970917392951799d-1*t159-
     1           7.418564737168958d-1*t158-4.002143174996817d-1*t157
              t161 = 1/t22**2
              t162 = 1/t19
              t163 = -1.6039141941921276d-1*t2-1.8533958105157808d+0*t15
     1           9-1.2815820791490704d+0*t158-8.223668877838045d-1*t157
              t164 = 1/t18**2
              t165 = 1.1102230246251565d-16*t156*t160*t161*t25+3.0506411
     1           443514264d-19*t158*t24+1.0d+0*t162*t163*t164*t21+1.3210
     2           398931339265d-3*t158*t20
              t166 = 1/t3**2
              t167 = 1/rhob**4.333333333333333d+0
              t168 = 1/rhob**2.6666666666666666d+0
              t169 = 9.6d-102*t166*t167*t8-4.0d-51*t168*t4*t8
              t170 = -4.0d-51*t168*t4*t9+9.6d-102*t166*t167*t9+2.4d-51*t
     1           169*t2*t4
              t171 = 2.4d-51*t170*t2*t4-4.0d-51*t10*t168*t4+9.6d-102*t10
     1           *t166*t167
              t172 = 2.4d-51*t171*t2*t4-4.0d-51*t11*t168*t4+9.6d-102*t11
     1           *t166*t167
              t173 = t56+t119
              t174 = t123+t120
              t175 = 1.3333333333333333d+0*t125*t174+1.3333333333333333d
     1           +0*t122*t173
              t176 = -1.923661050931536d+0*t175*t54*t55
              t177 = 7.694644203726144d+0*t130*t55*t59
              t178 = t177+t176+t129
              t179 = -6.21814d-2*t178*t52*t68
              t180 = t177+t176+1.923661050931536d+0*t175+t129
              t181 = 1.9751631321680768d-2*t180*t70*t74
              t182 = -5.980796863619711d-2*t175*t54*t55*t76*t79
              t183 = t80+t50*(2.3923187454478842d-1*t130*t55*t59*t76*t79
     1           +t182+t181+t179+t141+t140+t137+t134+t117+t113+t109)+t75
     2           +t69+6.903522198342671d-18*t24*t25+3.1090699999999993d-
     3           2*t20*t21-rhob*t165
              t184 = 6.406666666666666d-55*t144*t168*t28*t31-2.066666666
     1           6666667d-52*t168*t30*t31
              t185 = -2.0666666666666667d-52*t168*t30*t32+6.406666666666
     1           666d-55*t144*t168*t28*t32+3.1d-3*t184*t28*t30
              t186 = -2.0666666666666667d-52*t168*t30*t33+6.406666666666
     1           666d-55*t144*t168*t28*t33+3.1d-3*t185*t28*t30
              t187 = -2.0666666666666667d-52*t168*t30*t34+6.406666666666
     1           666d-55*t144*t168*t28*t34+3.1d-3*t186*t28*t30
              t188 = 3.1d-3*t27*t30*t31-9.61d-6*t144*t27*t28*t31
              t189 = 3.1d-3*t27*t30*t32-9.61d-6*t144*t27*t28*t32+3.1d-3*
     1           t188*t28*t30
              t190 = 3.1d-3*t27*t30*t33-9.61d-6*t144*t27*t28*t33+3.1d-3*
     1           t189*t28*t30
              t191 = 3.1d-3*t27*t30*t34-9.61d-6*t144*t27*t28*t34+3.1d-3*
     1           t190*t28*t30
              t192 = 1/rhoa**5.333333333333333d+0
              t193 = 6.0d-2*t27*t8*t83-3.6d-3*gammaaa*t150*t192*t8
              t194 = 6.0d-2*t27*t83*t84-3.6d-3*gammaaa*t150*t192*t84+6.0
     1           d-2*gammaaa*t193*t27*t83
              t195 = 6.0d-2*t27*t83*t85-3.6d-3*gammaaa*t150*t192*t85+6.0
     1           d-2*gammaaa*t194*t27*t83
              t196 = 6.0d-2*t27*t83*t86-3.6d-3*gammaaa*t150*t192*t86+6.0
     1           d-2*gammaaa*t195*t27*t83
              t197 = 1/taua**2
              t198 = t96**2
              t199 = 1/t37**5
              t200 = 1/rhoa**2.3333333333333334d+0
              t201 = 1/rhoa**2.1666666666666665d+0
              t202 = t99**2
              t203 = -8.497974591333913d-2*t100*t94*t98*t99-2.0d+0*t202*
     1           t44*t98/t41**3+1.0d+0*t100*(2.673190323653546d-1*t27+2.
     2           1622951122684114d+0*t201+1.7087761055320938d+0*t200+1.2
     3           335503316757068d+0*t199)*t44*t98-9.812069668265515d-18*
     4           t91*t94*t96*t97+1.1102230246251565d-16*(2.1077825841639
     5           536d-1*t27+1.1632736958443765d+0*t201+9.89141964955861d
     6           -1*t200+6.003214762495226d-1*t199)*t48*t91*t97-2.220446
     7           049250313d-16*t198*t48*t91/t45**3+1.7854583920998188d-1
     8           5*t198*t48/(t45**4*t46**2)-4.0675215258019015d-19*t200*
     9           t47+3.216395899738507d+1*t202*t44/(t41**4*t42**2)-1.761
     :           3865241785684d-3*t200*t43
              t204 = 2.0d+0*t106*t107*t108*t52*t61
              t205 = -1.1696447245269295d+0*t110*t111*t112*t70*t71
              t206 = 3.847322101863072d+0*t114*t115*t116*t54*t55*t59*t76
              t207 = 5.495546528376875d-3*t104*t61*t68
              t208 = -9.087592854964233d-4*t104*t71*t74
              t209 = 5.082465978296986d-3*t139*t54*t59*t79
              t210 = 4.7846374908957684d-1*t128*t54*t59*t76*t79
              t211 = t106**2
              t212 = 1.6081979498692536d+1*t211*t52*t61/(t66**4*t67**2)
              t213 = -2.0d+0*t108*t211*t52*t61/t66**3
              t214 = -8.837926660346784d-2*t104*t106*t107*t108*t61
              t215 = 1/t50**2.6666666666666666d+0
              t216 = 1/t63**5
              t217 = 1/t50**2.3333333333333334d+0
              t218 = 1/t50**2.1666666666666665d+0
              t219 = 1.0d+0*t107*t108*(1.1632736958443765d+0*t218+9.8914
     1           1964955861d-1*t217+6.003214762495226d-1*t216+2.10778258
     2           41639536d-1*t215)*t52*t61
              t220 = t110**2
              t221 = -1.73158960813529d+1*t220*t70*t71/(t72**4*t73**2)
              t222 = 1.1696447245269295d+0*t112*t220*t70*t71/t72**3
              t223 = 2.690728393099896d-2*t104*t110*t111*t112*t71
              t224 = -5.848223622634647d-1*t111*t112*(1.5861639701225969
     1           d+0*t218+9.98929717145607d-1*t217+3.2257293534574827d-1
     2           *t216+2.1239028834748191d-1*t215)*t70*t71
              t225 = t114**2
              t226 = 6.187255516702861d+1*t225*t54*t55*t59*t76/(t77**4*t
     1           78**2)
              t227 = -3.847322101863072d+0*t116*t225*t54*t55*t59*t76/t77
     1           **3
              t228 = -1.6347222733154887d-1*t114*t115*t116*t139*t54*t59
              t229 = 1.923661050931536d+0*t115*t116*(2.1622951122684114d
     1           +0*t218+1.7087761055320938d+0*t217+1.2335503316757068d+
     2           0*t216+2.673190323653546d-1*t215)*t54*t55*t59*t76
              t230 = -1.538928840745229d+1*t114*t115*t116*t128*t54*t59*t
     1           76
              t231 = 1/t57**6.666666666666666d-1
              t232 = 1/t50**3
              t233 = -2*t232*t53
              t234 = 2*t118
              t235 = 1/t58**6.666666666666666d-1
              t236 = 2*t232*t53
              t237 = -2*t118
              t238 = 1.3333333333333333d+0*t125*(t237+t236)+4.4444444444
     1           44444d-1*t124**2*t235+1.3333333333333333d+0*t122*(t234+
     2           t233)+4.444444444444444d-1*t121**2*t231
              t239 = -1.923661050931536d+0*t238*t54*t55
              t240 = 1.5389288407452287d+1*t126*t128*t54
              t241 = -1.5389288407452287d+1*t126*t130*t55
              t242 = 1/t50**6
              t243 = -3.8473221018630716d+1*t242*t54*t59
              t244 = 6.155715362980915d+1*t128*t130*t59
              t245 = t53**2
              t246 = -2.3083932611178434d+1*t245*t55*t59
              t247 = -3.663697685584583d-3*t217*t61*t68
              t248 = 6.058395236642822d-4*t217*t71*t74
              t249 = -2.3718174565385935d-2*t54*t59*t79/t50**6.333333333
     1           333333d+0
              t250 = -1.1961593727239421d+0*t242*t54*t59*t76*t79
              t251 = -7.176956236343652d-1*t245*t55*t59*t76*t79
              t252 = 1/rhoa**7.333333333333333d+0
              t253 = 1/rhoa**4.666666666666667d+0
              t254 = 1/t29**3
              t255 = 1/rhoa**2
              t256 = gammaaa**3
              t257 = 1/t82**3
              t258 = 1/rhoa**10
              t259 = 2.6666666666666666d+0*t125*t232*t53-2.6666666666666
     1           666d+0*t122*t232*t53+4.444444444444444d-1*t124*t174*t23
     2           5+4.444444444444444d-1*t121*t173*t231
              t260 = -1.923661050931536d+0*t259*t54*t55
              t261 = 7.694644203726144d+0*t128*t175*t54
              t262 = -7.694644203726144d+0*t130*t175*t55
              t263 = 7.694644203726144d+0*t126*t128*t54
              t264 = 7.694644203726144d+0*t126*t130*t55
              t265 = 2.3083932611178434d+1*t245*t55*t59
              t266 = t160**2
              t267 = 1/t14**5
              t268 = 1/rhob**2.3333333333333334d+0
              t269 = 1/rhob**2.1666666666666665d+0
              t270 = t163**2
              t271 = 3.216395899738507d+1*t21*t270/(t18**4*t19**2)-2.0d+
     1           0*t162*t21*t270/t18**3+1.0d+0*t162*t164*t21*(2.16229511
     2           22684114d+0*t269+1.7087761055320938d+0*t268+1.233550331
     3           6757068d+0*t267+2.673190323653546d-1*t168)+1.1102230246
     4           251565d-16*t156*t161*t25*(1.1632736958443765d+0*t269+9.
     5           89141964955861d-1*t268+6.003214762495226d-1*t267+2.1077
     6           825841639536d-1*t168)-4.0675215258019015d-19*t24*t268-1
     7           .7613865241785684d-3*t20*t268+1.7854583920998188d-15*t2
     8           5*t266/(t22**4*t23**2)-2.220446049250313d-16*t156*t25*t
     9           266/t22**3-8.497974591333913d-2*t158*t162*t163*t164-9.8
     :           12069668265515d-18*t156*t158*t160*t161
              t272 = 1/t3**3
              t273 = 1/rhob**7
              t274 = 1/rhob**5.333333333333333d+0
              t275 = 1/rhob**3.6666666666666664d+0
              t276 = 1.3333333333333333d+0*t122*(t237+t233)+1.3333333333
     1           333333d+0*t125*(t236+t234)+4.444444444444444d-1*t174**2
     2           *t235+4.444444444444444d-1*t173**2*t231
              t277 = -1.923661050931536d+0*t276*t54*t55
              t278 = 1.5389288407452287d+1*t128*t175*t54
              t279 = 1.5389288407452287d+1*t130*t175*t55
              t280 = -6.155715362980915d+1*t128*t130*t59
              t281 = 1.25d-1*t49*t87
              t282 = 1/rhoa**9
              t283 = 1/rhoa**8
              fnc(iq) = (5.0d-1*rhoa*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhob*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t88*(5.0d-1*t49*t87*t90+5.0d-1*rhoa*t101
     1           *t87*t90+5.0d-1*rhoa*t155*t49*t90)+1.25d-1*gammaaa*t49*
     2           t87*t88*t89+1.0d+0*t148*t81+1.0d+0*t142*t35)*wght+Amat(
     3           iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t187*t81+1.0d+0*t183*t35+5.0d-1*r
     1           hob*t172*t26+5.0d-1*t12*t26+5.0d-1*rhob*t12*t165)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t88*(5.0d-1*rhoa*t196*t49*t90-1.25d-1*t
     1           49*t87)+1.0d+0*t191*t81)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t49*t87*t88-5.0d-1*rhoa*t197
     1           *t49*t87*t90)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t35*(-2.0d+0*t100*t44*t98*t99
     1           -2.220446049250313d-16*t48*t91*t96*t97-6.10128228870285
     2           3d-19*t47*t94-2.642079786267853d-3*t43*t94+t50*(1.91385
     3           49963583074d+0*t128*t130*t59*t76*t79-5.980796863619711d
     4           -2*t238*t54*t55*t76*t79-4.7846374908957684d-1*t126*t130
     5           *t55*t76*t79+4.7846374908957684d-1*t126*t128*t54*t76*t7
     6           9+2.0329863913187946d-2*t130*t139*t59*t79+5.08246597829
     7           6986d-3*t126*t139*t54*t79+1.538928840745229d+1*t114*t11
     8           5*t116*t130*t55*t59*t76+3.847322101863072d+0*t114*t115*
     9           t116*t126*t54*t55*t76+1.9751631321680768d-2*(t246+t244+
     :           t243+t241+t240+t239+1.923661050931536d+0*t238)*t70*t74-
     ;           9.087592854964233d-4*t104*t135*t74-1.1696447245269295d+
     <           0*t110*t111*t112*t135*t70-6.21814d-2*(t246+t244+t243+t2
     =           41+t240+t239)*t52*t68+5.495546528376875d-3*t104*t132*t6
     >           8+2.0d+0*t106*t107*t108*t132*t52+t251+t250+t249+t248+t2
     ?           47+t230+t229+t228+t227+t226+t224+t223+t222+t221+t219+t2
     @           14+t213+t212)-4.7846374908957684d-1*t130*t55*t59*t76*t7
     1           9-1.1961593727239421d-1*t126*t54*t55*t76*t79+3.95032626
     2           43361536d-2*t135*t70*t74-1.243628d-1*t132*t52*t68+t210+
     3           t209+t208+t207+t206+t205+t204-rhoa*t203)+t88*(5.0d-1*rh
     4           oa*t203*t87*t90+1.0d+0*t101*t87*t90+5.0d-1*rhoa*t49*(5.
     5           866666666666666d-1*gammaaa*t253*t83*t86+3.0719999999999
     6           986d-3*t256*t257*t258*t86-8.639999999999998d-2*t149*t15
     7           0*t252*t86+6.0d-2*gammaaa*t27*t83*(5.866666666666666d-1
     8           *gammaaa*t253*t83*t85+3.0719999999999986d-3*t256*t257*t
     9           258*t85-8.639999999999998d-2*t149*t150*t252*t85+6.0d-2*
     :           gammaaa*t27*t83*(5.866666666666666d-1*gammaaa*t253*t83*
     ;           t84+3.0719999999999986d-3*t256*t257*t258*t84-8.63999999
     <           9999998d-2*t149*t150*t252*t84+6.0d-2*gammaaa*t27*t83*(5
     =           .866666666666666d-1*gammaaa*t253*t8*t83+3.0719999999999
     >           986d-3*t256*t257*t258*t8-8.639999999999998d-2*t149*t150
     ?           *t252*t8)-3.1999999999999995d-1*gammaaa*t143*t152*t83+1
     @           .9199999999999995d-2*t149*t150*t151*t152)-3.19999999999
     1           99995d-1*gammaaa*t143*t153*t83+1.9199999999999995d-2*t1
     2           49*t150*t151*t153)-3.1999999999999995d-1*gammaaa*t143*t
     3           154*t83+1.9199999999999995d-2*t149*t150*t151*t154)*t90+
     4           1.0d+0*t155*t49*t90+1.0d+0*rhoa*t101*t155*t90+1.25d-1*g
     5           ammaaa*t101*t87*t89+1.25d-1*gammaaa*t155*t49*t89+1.25d-
     6           1*gammaaa*t255*t49*t87)+(1.25d-1*gammaaa*t101*t87+1.25d
     7           -1*gammaaa*t155*t49)*t88*t89-1.25d-1*gammaaa*t255*t49*t
     8           87*t88+1.0d+0*(3.0311111111111105d-2*gammaaa*t253*t30*t
     9           34+4.2369422222222203d-7*t149*t252*t254*t28*t34-9.39644
     :           4444444442d-5*gammaaa*t144*t253*t28*t34-1.3667555555555
     ;           55d-4*t144*t149*t252*t34+3.1d-3*t28*t30*(3.031111111111
     <           1105d-2*gammaaa*t253*t30*t33+4.2369422222222203d-7*t149
     =           *t252*t254*t28*t33-9.396444444444442d-5*gammaaa*t144*t2
     >           53*t28*t33-1.366755555555555d-4*t144*t149*t252*t33+3.1d
     ?           -3*t28*t30*(3.0311111111111105d-2*gammaaa*t253*t30*t32+
     @           4.2369422222222203d-7*t149*t252*t254*t28*t32-9.39644444
     1           4444442d-5*gammaaa*t144*t253*t28*t32-1.366755555555555d
     2           -4*t144*t149*t252*t32+3.1d-3*t28*t30*(3.031111111111110
     3           5d-2*gammaaa*t253*t30*t31+4.2369422222222203d-7*t149*t2
     4           52*t254*t28*t31-9.396444444444442d-5*gammaaa*t144*t253*
     5           t28*t31-1.366755555555555d-4*t144*t149*t252*t31)-1.6533
     6           33333333333d-2*gammaaa*t143*t145*t30+5.125333333333332d
     7           -5*gammaaa*t143*t144*t145*t28)-1.653333333333333d-2*gam
     8           maaa*t143*t146*t30+5.125333333333332d-5*gammaaa*t143*t1
     9           44*t146*t28)-1.653333333333333d-2*gammaaa*t143*t147*t30
     :           +5.125333333333332d-5*gammaaa*t143*t144*t147*t28)*t81+2
     ;           .0d+0*t142*t148)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*(1.0592355555555552d-56*gamma
     1           aa*t143*t168*t254*t28*t34-3.416888888888888d-54*gammaaa
     2           *t143*t144*t168*t34+3.1d-3*t28*t30*(1.0592355555555552d
     3           -56*gammaaa*t143*t168*t254*t28*t33-3.416888888888888d-5
     4           4*gammaaa*t143*t144*t168*t33+3.1d-3*t28*t30*(1.05923555
     5           55555552d-56*gammaaa*t143*t168*t254*t28*t32-3.416888888
     6           888888d-54*gammaaa*t143*t144*t168*t32+3.1d-3*t28*t30*(1
     7           .0592355555555552d-56*gammaaa*t143*t168*t254*t28*t31-3.
     8           416888888888888d-54*gammaaa*t143*t144*t168*t31)-8.26666
     9           6666666665d-3*gammaaa*t143*t184*t30-2.0666666666666667d
     :           -52*t145*t168*t30+2.562666666666666d-5*gammaaa*t143*t14
     ;           4*t184*t28+6.406666666666666d-55*t144*t145*t168*t28)-8.
     <           266666666666665d-3*gammaaa*t143*t185*t30-2.066666666666
     =           6667d-52*t146*t168*t30+2.562666666666666d-5*gammaaa*t14
     >           3*t144*t185*t28+6.406666666666666d-55*t144*t146*t168*t2
     ?           8)-8.266666666666665d-3*gammaaa*t143*t186*t30-2.0666666
     @           666666667d-52*t147*t168*t30+2.562666666666666d-5*gammaa
     1           a*t143*t144*t186*t28+6.406666666666666d-55*t144*t147*t1
     2           68*t28)*t81+1.0d+0*t35*(t50*(7.176956236343652d-1*t245*
     3           t55*t59*t76*t79-5.980796863619711d-2*t259*t54*t55*t76*t
     4           79-2.3923187454478842d-1*t130*t175*t55*t76*t79+2.392318
     5           7454478842d-1*t126*t130*t55*t76*t79+2.3923187454478842d
     6           -1*t128*t175*t54*t76*t79+2.3923187454478842d-1*t126*t12
     7           8*t54*t76*t79+2.541232989148493d-3*t139*t175*t54*t79+2.
     8           541232989148493d-3*t126*t139*t54*t79+1.923661050931536d
     9           +0*t114*t115*t116*t175*t54*t55*t76+1.923661050931536d+0
     :           *t114*t115*t116*t126*t54*t55*t76+1.9751631321680768d-2*
     ;           (t265+t264+t263+t262+t261+t260+1.923661050931536d+0*t25
     <           9+t243)*t70*t74-4.5437964274821163d-4*t104*t180*t74-4.5
     =           437964274821163d-4*t104*t135*t74-5.848223622634647d-1*t
     >           110*t111*t112*t180*t70-5.848223622634647d-1*t110*t111*t
     ?           112*t135*t70-6.21814d-2*(t265+t264+t263+t262+t261+t260+
     @           t243)*t52*t68+2.747773264188437d-3*t104*t178*t68+2.7477
     1           73264188437d-3*t104*t132*t68+1.0d+0*t106*t107*t108*t178
     2           *t52+1.0d+0*t106*t107*t108*t132*t52+t250+t249+t248+t247
     3           +t230+t229+t228+t227+t226+t224+t223+t222+t221+t219+t214
     4           +t213+t212)+t210+t209+t208+t207+t206+t205+t204+t182+t18
     5           1+t179+t138+t136+t133)+1.0d+0*t142*t187+1.0d+0*t148*t18
     6           3)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (5.0d-1*rhob*t26*(2.4d-51*t2*t4*(2.4d
     1           -51*t2*t4*(1.0666666666666666d-50*t275*t4*t9-5.76d-101*
     2           t166*t274*t9+7.68d-152*t272*t273*t9+2.4d-51*t2*t4*(1.06
     3           66666666666666d-50*t275*t4*t8-5.76d-101*t166*t274*t8+7.
     4           68d-152*t272*t273*t8)-8.0d-51*t168*t169*t4+1.92d-101*t1
     5           66*t167*t169)+1.0666666666666666d-50*t10*t275*t4-8.0d-5
     6           1*t168*t170*t4-5.76d-101*t10*t166*t274+7.68d-152*t10*t2
     7           72*t273+1.92d-101*t166*t167*t170)+1.0666666666666666d-5
     8           0*t11*t275*t4-8.0d-51*t168*t171*t4-5.76d-101*t11*t166*t
     9           274+7.68d-152*t11*t272*t273+1.92d-101*t166*t167*t171)+1
     :           .0d+0*(5.51111111111111d-52*t275*t30*t34-1.708444444444
     ;           444d-54*t144*t275*t28*t34+2.6480888888888887d-106*t254*
     <           t274*t28*t34-8.542222222222222d-104*t144*t274*t34+3.1d-
     =           3*t28*t30*(5.51111111111111d-52*t275*t30*t33-1.70844444
     >           4444444d-54*t144*t275*t28*t33+2.6480888888888887d-106*t
     ?           254*t274*t28*t33-8.542222222222222d-104*t144*t274*t33+3
     @           .1d-3*t28*t30*(5.51111111111111d-52*t275*t30*t32-1.7084
     1           44444444444d-54*t144*t275*t28*t32+2.6480888888888887d-1
     2           06*t254*t274*t28*t32-8.542222222222222d-104*t144*t274*t
     3           32+3.1d-3*t28*t30*(5.51111111111111d-52*t275*t30*t31-1.
     4           708444444444444d-54*t144*t275*t28*t31+2.648088888888888
     5           7d-106*t254*t274*t28*t31-8.542222222222222d-104*t144*t2
     6           74*t31)-4.1333333333333333d-52*t168*t184*t30+1.28133333
     7           33333332d-54*t144*t168*t184*t28)-4.1333333333333333d-52
     8           *t168*t185*t30+1.2813333333333332d-54*t144*t168*t185*t2
     9           8)-4.1333333333333333d-52*t168*t186*t30+1.2813333333333
     :           332d-54*t144*t168*t186*t28)*t81+1.0d+0*t35*(t50*(-1.913
     ;           8549963583074d+0*t128*t130*t59*t76*t79-5.98079686361971
     <           1d-2*t276*t54*t55*t76*t79+4.7846374908957684d-1*t130*t1
     =           75*t55*t76*t79+4.7846374908957684d-1*t128*t175*t54*t76*
     >           t79-2.0329863913187946d-2*t130*t139*t59*t79+5.082465978
     ?           296986d-3*t139*t175*t54*t79-1.538928840745229d+1*t114*t
     @           115*t116*t130*t55*t59*t76+3.847322101863072d+0*t114*t11
     1           5*t116*t175*t54*t55*t76+1.9751631321680768d-2*(t280+t27
     2           9+t278+t277+1.923661050931536d+0*t276+t246+t243)*t70*t7
     3           4-9.087592854964233d-4*t104*t180*t74-1.1696447245269295
     4           d+0*t110*t111*t112*t180*t70-6.21814d-2*(t280+t279+t278+
     5           t277+t246+t243)*t52*t68+5.495546528376875d-3*t104*t178*
     6           t68+2.0d+0*t106*t107*t108*t178*t52+t251+t250+t249+t248+
     7           t247+t230+t229+t228+t227+t226+t224+t223+t222+t221+t219+
     8           t214+t213+t212)+4.7846374908957684d-1*t130*t55*t59*t76*
     9           t79-1.1961593727239421d-1*t175*t54*t55*t76*t79+3.950326
     :           2643361536d-2*t180*t70*t74-1.243628d-1*t178*t52*t68-rho
     ;           b*t271-2.220446049250313d-16*t156*t160*t161*t25-6.10128
     <           2288702853d-19*t158*t24+t210-2.0d+0*t162*t163*t164*t21+
     =           t209+t208+t207+t206+t205+t204-2.642079786267853d-3*t158
     >           *t20)+5.0d-1*rhob*t12*t271+1.0d+0*t172*t26+2.0d+0*t183*
     ?           t187+1.0d+0*rhob*t165*t172+1.0d+0*t12*t165)*wght+Amat2(
     @           iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t88*(5.0d-1*rhoa*t49*(-1.5999999999
     1           999998d-1*t143*t83*t86-1.1519999999999996d-3*t149*t257*
     2           t282*t86+2.879999999999999d-2*gammaaa*t150*t151*t86+6.0
     3           d-2*gammaaa*t27*t83*(-1.5999999999999998d-1*t143*t83*t8
     4           5-1.1519999999999996d-3*t149*t257*t282*t85+2.8799999999
     5           99999d-2*gammaaa*t150*t151*t85+6.0d-2*gammaaa*t27*t83*(
     6           -1.5999999999999998d-1*t143*t83*t84-1.1519999999999996d
     7           -3*t149*t257*t282*t84+2.879999999999999d-2*gammaaa*t150
     8           *t151*t84+6.0d-2*gammaaa*t27*t83*(-1.5999999999999998d-
     9           1*t143*t8*t83-1.1519999999999996d-3*t149*t257*t282*t8+2
     :           .879999999999999d-2*gammaaa*t150*t151*t8)+6.0d-2*t152*t
     ;           27*t83-1.5999999999999998d-1*gammaaa*t143*t193*t83+9.59
     <           9999999999997d-3*t149*t150*t151*t193-3.6d-3*gammaaa*t15
     =           0*t152*t192)+6.0d-2*t153*t27*t83-1.5999999999999998d-1*
     >           gammaaa*t143*t194*t83+9.599999999999997d-3*t149*t150*t1
     ?           51*t194-3.6d-3*gammaaa*t150*t153*t192)+6.0d-2*t154*t27*
     @           t83-1.5999999999999998d-1*gammaaa*t143*t195*t83+9.59999
     1           9999999997d-3*t149*t150*t151*t195-3.6d-3*gammaaa*t150*t
     2           154*t192)*t90+5.0d-1*t196*t49*t90+5.0d-1*rhoa*t101*t196
     3           *t90-1.25d-1*t49*t87*t89-1.25d-1*t101*t87-1.25d-1*t155*
     4           t49)+(1.25d-1*gammaaa*t196*t49+t281)*t88*t89+1.0d+0*(-8
     5           .266666666666665d-3*t143*t30*t34-1.5888533333333327d-7*
     6           gammaaa*t151*t254*t28*t34+2.562666666666666d-5*t143*t14
     7           4*t28*t34+5.125333333333332d-5*gammaaa*t144*t151*t34+3.
     8           1d-3*t28*t30*(-8.266666666666665d-3*t143*t30*t33-1.5888
     9           533333333327d-7*gammaaa*t151*t254*t28*t33+2.56266666666
     :           6666d-5*t143*t144*t28*t33+5.125333333333332d-5*gammaaa*
     ;           t144*t151*t33+3.1d-3*t28*t30*(-8.266666666666665d-3*t14
     <           3*t30*t32-1.5888533333333327d-7*gammaaa*t151*t254*t28*t
     =           32+2.562666666666666d-5*t143*t144*t28*t32+5.12533333333
     >           3332d-5*gammaaa*t144*t151*t32+3.1d-3*t28*t30*(-8.266666
     ?           666666665d-3*t143*t30*t31-1.5888533333333327d-7*gammaaa
     @           *t151*t254*t28*t31+2.562666666666666d-5*t143*t144*t28*t
     1           31+5.125333333333332d-5*gammaaa*t144*t151*t31)+3.1d-3*t
     2           145*t27*t30-8.266666666666665d-3*gammaaa*t143*t188*t30-
     3           9.61d-6*t144*t145*t27*t28+2.562666666666666d-5*gammaaa*
     4           t143*t144*t188*t28)+3.1d-3*t146*t27*t30-8.2666666666666
     5           65d-3*gammaaa*t143*t189*t30-9.61d-6*t144*t146*t27*t28+2
     6           .562666666666666d-5*gammaaa*t143*t144*t189*t28)+3.1d-3*
     7           t147*t27*t30-8.266666666666665d-3*gammaaa*t143*t190*t30
     8           -9.61d-6*t144*t147*t27*t28+2.562666666666666d-5*gammaaa
     9           *t143*t144*t190*t28)*t81+1.0d+0*t142*t191)*wght+Cmat2(i
     :           q,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*(-3.972133333333333d-57*t168
     1           *t254*t27*t28*t34+1.2813333333333332d-54*t144*t168*t27*
     2           t34+3.1d-3*t28*t30*(-3.972133333333333d-57*t168*t254*t2
     3           7*t28*t33+1.2813333333333332d-54*t144*t168*t27*t33+3.1d
     4           -3*t28*t30*(-3.972133333333333d-57*t168*t254*t27*t28*t3
     5           2+1.2813333333333332d-54*t144*t168*t27*t32+3.1d-3*t28*t
     6           30*(1.2813333333333332d-54*t144*t168*t27*t31-3.97213333
     7           3333333d-57*t168*t254*t27*t28*t31)+3.1d-3*t184*t27*t30-
     8           2.0666666666666667d-52*t168*t188*t30-9.61d-6*t144*t184*
     9           t27*t28+6.406666666666666d-55*t144*t168*t188*t28)+3.1d-
     :           3*t185*t27*t30-2.0666666666666667d-52*t168*t189*t30-9.6
     ;           1d-6*t144*t185*t27*t28+6.406666666666666d-55*t144*t168*
     <           t189*t28)+3.1d-3*t186*t27*t30-2.0666666666666667d-52*t1
     =           68*t190*t30-9.61d-6*t144*t186*t27*t28+6.406666666666666
     >           d-55*t144*t168*t190*t28)*t81+1.0d+0*t183*t191)*wght+Cma
     ?           t2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t88*(5.0d-1*rhoa*t49*(4.32d-4*gamm
     1           aaa*t257*t283*t86-7.2d-3*t150*t192*t86+6.0d-2*gammaaa*t
     2           27*t83*(4.32d-4*gammaaa*t257*t283*t85-7.2d-3*t150*t192*
     3           t85+6.0d-2*gammaaa*t27*t83*(4.32d-4*gammaaa*t257*t283*t
     4           84-7.2d-3*t150*t192*t84+6.0d-2*gammaaa*t27*(4.32d-4*gam
     5           maaa*t257*t283*t8-7.2d-3*t150*t192*t8)*t83+1.2d-1*t193*
     6           t27*t83-7.2d-3*gammaaa*t150*t192*t193)+1.2d-1*t194*t27*
     7           t83-7.2d-3*gammaaa*t150*t192*t194)+1.2d-1*t195*t27*t83-
     8           7.2d-3*gammaaa*t150*t192*t195)*t90-2.5d-1*t196*t49)+1.0
     9           d+0*(5.9582d-8*t192*t254*t28*t34-1.9219999999999998d-5*
     :           t144*t192*t34+3.1d-3*t28*t30*(5.9582d-8*t192*t254*t28*t
     ;           33-1.9219999999999998d-5*t144*t192*t33+3.1d-3*t28*t30*(
     <           5.9582d-8*t192*t254*t28*t32-1.9219999999999998d-5*t144*
     =           t192*t32+3.1d-3*t28*t30*(5.9582d-8*t192*t254*t28*t31-1.
     >           9219999999999998d-5*t144*t192*t31)+6.2d-3*t188*t27*t30-
     ?           1.9219999999999998d-5*t144*t188*t27*t28)+6.2d-3*t189*t2
     @           7*t30-1.9219999999999998d-5*t144*t189*t27*t28)+6.2d-3*t
     1           190*t27*t30-1.9219999999999998d-5*t144*t190*t27*t28)*t8
     2           1)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t197*(-5.0d-1*t49*t87*t90-5.0d-1*rho
     1           a*t101*t87*t90-5.0d-1*rhoa*t155*t49*t90)-1.25d-1*gammaa
     2           a*t197*t49*t87*t89+(1.0d+0*t49*t87+1.0d+0*rhoa*t101*t87
     3           +1.0d+0*rhoa*t155*t49)*t88)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (t197*(t281-5.0d-1*rhoa*t196*t49*t90
     1           )+1.0d+0*rhoa*t196*t49*t88)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t49*t87*t90/taua**3-2.0d
     1           +0*rhoa*t197*t49*t87)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = param(5)
              t28 = 1/rhob**2.6666666666666666d+0
              t29 = gammabb*t28+4.0d-50*t2
              t30 = 3.1d-3*t29+1.0d+0
              t31 = 1/t30
              t32 = 3.1d-3*t27*t29*t31+param(4)
              t33 = 3.1d-3*t29*t31*t32+param(3)
              t34 = 3.1d-3*t29*t31*t33+param(2)
              t35 = 3.1d-3*t29*t31*t34+param(1)
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhob*t49-rhoa*t26
              t82 = 6.0d-2*gammabb*t28+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammabb*t28*t8*t83+t7
              t85 = 6.0d-2*gammabb*t28*t83*t84+t6
              t86 = 6.0d-2*gammabb*t28*t83*t85+t5
              t87 = 6.0d-2*gammabb*t28*t83*t86+t1
              t88 = 1/taub
              t89 = 1/rhob
              t90 = 2.0d+0*taub-2.5d-1*gammabb*t89
              t91 = 1/t23
              t92 = 1/t14**3
              t93 = 1/rhoa**1.3333333333333333d+0
              t94 = 1/rhoa**1.1666666666666667d+0
              t95 = -9.970917392951799d-1*t94-7.418564737168958d-1*t93-4
     1           .002143174996817d-1*t92-1.264669550498372d-1*t2
              t96 = 1/t22**2
              t97 = 1/t19
              t98 = -1.8533958105157808d+0*t94-1.2815820791490704d+0*t93
     1           -8.223668877838045d-1*t92-1.6039141941921276d-1*t2
              t99 = 1/t18**2
              t100 = 1.0d+0*t21*t97*t98*t99+1.1102230246251565d-16*t25*t
     1           91*t95*t96+3.0506411443514264d-19*t24*t93+1.32103989313
     2           39265d-3*t20*t93
              t101 = 1/t3**2
              t102 = 1/rhoa**4.333333333333333d+0
              t103 = 1/rhoa**2.6666666666666666d+0
              t104 = 9.6d-102*t101*t102*t8-4.0d-51*t103*t4*t8
              t105 = -4.0d-51*t103*t4*t9+9.6d-102*t101*t102*t9+2.4d-51*t
     1           104*t2*t4
              t106 = 2.4d-51*t105*t2*t4-4.0d-51*t10*t103*t4+9.6d-102*t10
     1           *t101*t102
              t107 = 2.4d-51*t106*t2*t4-4.0d-51*t103*t11*t4+9.6d-102*t10
     1           1*t102*t11
              t108 = 1/t50**1.6666666666666669d+0
              t109 = 1/t63**3
              t110 = 1/t50**1.3333333333333333d+0
              t111 = 1/t50**1.1666666666666667d+0
              t112 = -9.970917392951799d-1*t111-7.418564737168958d-1*t11
     1           0-4.002143174996817d-1*t109-1.264669550498372d-1*t108
              t113 = 1/t66**2
              t114 = 1/t67
              t115 = 1.0d+0*t112*t113*t114*t52*t61
              t116 = -1.3595691172479402d+0*t111-7.491972878592053d-1*t1
     1           10-2.1504862356383217d-1*t109-1.2743417300848914d-1*t10
     2           8
              t117 = 1/t72**2
              t118 = 1/t73
              t119 = -5.848223622634647d-1*t116*t117*t118*t70*t71
              t120 = -1.8533958105157808d+0*t111-1.2815820791490704d+0*t
     1           110-8.223668877838045d-1*t109-1.6039141941921276d-1*t10
     2           8
              t121 = 1/t77**2
              t122 = 1/t78
              t123 = 1.923661050931536d+0*t120*t121*t122*t54*t55*t59*t76
              t124 = 1/t50**2
              t125 = t124*t53
              t126 = -t56
              t127 = t126+t125
              t128 = t57**3.333333333333333d-1
              t129 = -t124*t53
              t130 = t56+t129
              t131 = t58**3.333333333333333d-1
              t132 = 1.3333333333333333d+0*t130*t131+1.3333333333333333d
     1           +0*t127*t128
              t133 = -1.923661050931536d+0*t132*t54*t55
              t134 = 1/t50**5
              t135 = 7.694644203726144d+0*t134*t54*t59
              t136 = t53**3
              t137 = -7.694644203726144d+0*t136*t55*t59
              t138 = t137+t135+t133
              t139 = -6.21814d-2*t138*t52*t68
              t140 = 2.747773264188437d-3*t110*t61*t68
              t141 = t137+t135+t133+1.923661050931536d+0*t132
              t142 = 1.9751631321680768d-2*t141*t70*t74
              t143 = -4.5437964274821163d-4*t110*t71*t74
              t144 = -5.980796863619711d-2*t132*t54*t55*t76*t79
              t145 = 1/t50**5.333333333333333d+0
              t146 = 2.541232989148493d-3*t145*t54*t59*t79
              t147 = 2.3923187454478842d-1*t134*t54*t59*t76*t79
              t148 = t80+t50*(-2.3923187454478842d-1*t136*t55*t59*t76*t7
     1           9+t147+t146+t144+t143+t142+t140+t139+t123+t119+t115)+t7
     2           5+t69+6.903522198342671d-18*t24*t25+3.1090699999999993d
     3           -2*t20*t21-rhoa*t100
              t149 = 1/t30**2
              t150 = 6.406666666666666d-55*t103*t149*t27*t29-2.066666666
     1           6666667d-52*t103*t27*t31
              t151 = -2.0666666666666667d-52*t103*t31*t32+6.406666666666
     1           666d-55*t103*t149*t29*t32+3.1d-3*t150*t29*t31
              t152 = -2.0666666666666667d-52*t103*t31*t33+6.406666666666
     1           666d-55*t103*t149*t29*t33+3.1d-3*t151*t29*t31
              t153 = -2.0666666666666667d-52*t103*t31*t34+6.406666666666
     1           666d-55*t103*t149*t29*t34+3.1d-3*t152*t29*t31
              t154 = 1/t46
              t155 = 1/rhob**1.6666666666666669d+0
              t156 = 1/t37**3
              t157 = 1/rhob**1.3333333333333333d+0
              t158 = 1/rhob**1.1666666666666667d+0
              t159 = -9.970917392951799d-1*t158-7.418564737168958d-1*t15
     1           7-4.002143174996817d-1*t156-1.264669550498372d-1*t155
              t160 = 1/t45**2
              t161 = 1/t42
              t162 = -1.8533958105157808d+0*t158-1.2815820791490704d+0*t
     1           157-8.223668877838045d-1*t156-1.6039141941921276d-1*t15
     2           5
              t163 = 1/t41**2
              t164 = 1.1102230246251565d-16*t154*t159*t160*t48+3.0506411
     1           443514264d-19*t157*t47+1.0d+0*t161*t162*t163*t44+1.3210
     2           398931339265d-3*t157*t43
              t165 = t56+t125
              t166 = t129+t126
              t167 = 1.3333333333333333d+0*t131*t166+1.3333333333333333d
     1           +0*t128*t165
              t168 = -1.923661050931536d+0*t167*t54*t55
              t169 = 7.694644203726144d+0*t136*t55*t59
              t170 = t169+t168+t135
              t171 = -6.21814d-2*t170*t52*t68
              t172 = t169+t168+1.923661050931536d+0*t167+t135
              t173 = 1.9751631321680768d-2*t172*t70*t74
              t174 = -5.980796863619711d-2*t167*t54*t55*t76*t79
              t175 = t80+t50*(2.3923187454478842d-1*t136*t55*t59*t76*t79
     1           +t174+t173+t171+t147+t146+t143+t140+t123+t119+t115)+t75
     2           +t69+6.903522198342671d-18*t47*t48+3.1090699999999993d-
     3           2*t43*t44-rhob*t164
              t176 = 1/rhob**3.6666666666666664d+0
              t177 = 2.562666666666666d-5*gammabb*t149*t176*t27*t29-8.26
     1           6666666666665d-3*gammabb*t176*t27*t31
              t178 = -8.266666666666665d-3*gammabb*t176*t31*t32+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t32+3.1d-3*t177*t29*
     2           t31
              t179 = -8.266666666666665d-3*gammabb*t176*t31*t33+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t33+3.1d-3*t178*t29*
     2           t31
              t180 = -8.266666666666665d-3*gammabb*t176*t31*t34+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t34+3.1d-3*t179*t29*
     2           t31
              t181 = gammabb**2
              t182 = 1/t82**2
              t183 = 1/rhob**6.333333333333333d+0
              t184 = 9.599999999999997d-3*t181*t182*t183*t8-1.5999999999
     1           999998d-1*gammabb*t176*t8*t83
              t185 = -1.5999999999999998d-1*gammabb*t176*t83*t84+9.59999
     1           9999999997d-3*t181*t182*t183*t84+6.0d-2*gammabb*t184*t2
     2           8*t83
              t186 = -1.5999999999999998d-1*gammabb*t176*t83*t85+9.59999
     1           9999999997d-3*t181*t182*t183*t85+6.0d-2*gammabb*t185*t2
     2           8*t83
              t187 = -1.5999999999999998d-1*gammabb*t176*t83*t86+9.59999
     1           9999999997d-3*t181*t182*t183*t86+6.0d-2*gammabb*t186*t2
     2           8*t83
              t188 = 3.1d-3*t27*t28*t31-9.61d-6*t149*t27*t28*t29
              t189 = 3.1d-3*t28*t31*t32-9.61d-6*t149*t28*t29*t32+3.1d-3*
     1           t188*t29*t31
              t190 = 3.1d-3*t28*t31*t33-9.61d-6*t149*t28*t29*t33+3.1d-3*
     1           t189*t29*t31
              t191 = 3.1d-3*t28*t31*t34-9.61d-6*t149*t28*t29*t34+3.1d-3*
     1           t190*t29*t31
              t192 = 1/rhob**5.333333333333333d+0
              t193 = 6.0d-2*t28*t8*t83-3.6d-3*gammabb*t182*t192*t8
              t194 = 6.0d-2*t28*t83*t84-3.6d-3*gammabb*t182*t192*t84+6.0
     1           d-2*gammabb*t193*t28*t83
              t195 = 6.0d-2*t28*t83*t85-3.6d-3*gammabb*t182*t192*t85+6.0
     1           d-2*gammabb*t194*t28*t83
              t196 = 6.0d-2*t28*t83*t86-3.6d-3*gammabb*t182*t192*t86+6.0
     1           d-2*gammabb*t195*t28*t83
              t197 = 1/taub**2
              t198 = t95**2
              t199 = 1/t14**5
              t200 = 1/rhoa**2.3333333333333334d+0
              t201 = 1/rhoa**2.1666666666666665d+0
              t202 = t98**2
              t203 = -8.497974591333913d-2*t93*t97*t98*t99+1.0d+0*(2.162
     1           2951122684114d+0*t201+1.7087761055320938d+0*t200+1.2335
     2           503316757068d+0*t199+2.673190323653546d-1*t103)*t21*t97
     3           *t99-2.0d+0*t202*t21*t97/t18**3-9.812069668265515d-18*t
     4           91*t93*t95*t96+1.1102230246251565d-16*(1.16327369584437
     5           65d+0*t201+9.89141964955861d-1*t200+6.003214762495226d-
     6           1*t199+2.1077825841639536d-1*t103)*t25*t91*t96-2.220446
     7           049250313d-16*t198*t25*t91/t22**3+1.7854583920998188d-1
     8           5*t198*t25/(t22**4*t23**2)-4.0675215258019015d-19*t200*
     9           t24+3.216395899738507d+1*t202*t21/(t18**4*t19**2)-1.761
     :           3865241785684d-3*t20*t200
              t204 = 1/t3**3
              t205 = 1/rhoa**7
              t206 = 1/rhoa**5.333333333333333d+0
              t207 = 1/rhoa**3.6666666666666664d+0
              t208 = 2.0d+0*t112*t113*t114*t52*t61
              t209 = -1.1696447245269295d+0*t116*t117*t118*t70*t71
              t210 = 3.847322101863072d+0*t120*t121*t122*t54*t55*t59*t76
              t211 = 5.495546528376875d-3*t110*t61*t68
              t212 = -9.087592854964233d-4*t110*t71*t74
              t213 = 5.082465978296986d-3*t145*t54*t59*t79
              t214 = 4.7846374908957684d-1*t134*t54*t59*t76*t79
              t215 = t112**2
              t216 = 1.6081979498692536d+1*t215*t52*t61/(t66**4*t67**2)
              t217 = -2.0d+0*t114*t215*t52*t61/t66**3
              t218 = -8.837926660346784d-2*t110*t112*t113*t114*t61
              t219 = 1/t50**2.6666666666666666d+0
              t220 = 1/t63**5
              t221 = 1/t50**2.3333333333333334d+0
              t222 = 1/t50**2.1666666666666665d+0
              t223 = 1.0d+0*t113*t114*(1.1632736958443765d+0*t222+9.8914
     1           1964955861d-1*t221+6.003214762495226d-1*t220+2.10778258
     2           41639536d-1*t219)*t52*t61
              t224 = t116**2
              t225 = -1.73158960813529d+1*t224*t70*t71/(t72**4*t73**2)
              t226 = 1.1696447245269295d+0*t118*t224*t70*t71/t72**3
              t227 = 2.690728393099896d-2*t110*t116*t117*t118*t71
              t228 = -5.848223622634647d-1*t117*t118*(1.5861639701225969
     1           d+0*t222+9.98929717145607d-1*t221+3.2257293534574827d-1
     2           *t220+2.1239028834748191d-1*t219)*t70*t71
              t229 = t120**2
              t230 = 6.187255516702861d+1*t229*t54*t55*t59*t76/(t77**4*t
     1           78**2)
              t231 = -3.847322101863072d+0*t122*t229*t54*t55*t59*t76/t77
     1           **3
              t232 = -1.6347222733154887d-1*t120*t121*t122*t145*t54*t59
              t233 = 1.923661050931536d+0*t121*t122*(2.1622951122684114d
     1           +0*t222+1.7087761055320938d+0*t221+1.2335503316757068d+
     2           0*t220+2.673190323653546d-1*t219)*t54*t55*t59*t76
              t234 = -1.538928840745229d+1*t120*t121*t122*t134*t54*t59*t
     1           76
              t235 = 1/t57**6.666666666666666d-1
              t236 = 1/t50**3
              t237 = -2*t236*t53
              t238 = 2*t124
              t239 = 1/t58**6.666666666666666d-1
              t240 = 2*t236*t53
              t241 = -2*t124
              t242 = 1.3333333333333333d+0*t131*(t241+t240)+4.4444444444
     1           44444d-1*t130**2*t239+1.3333333333333333d+0*t128*(t238+
     2           t237)+4.444444444444444d-1*t127**2*t235
              t243 = -1.923661050931536d+0*t242*t54*t55
              t244 = 1.5389288407452287d+1*t132*t134*t54
              t245 = -1.5389288407452287d+1*t132*t136*t55
              t246 = 1/t50**6
              t247 = -3.8473221018630716d+1*t246*t54*t59
              t248 = 6.155715362980915d+1*t134*t136*t59
              t249 = t53**2
              t250 = -2.3083932611178434d+1*t249*t55*t59
              t251 = -3.663697685584583d-3*t221*t61*t68
              t252 = 6.058395236642822d-4*t221*t71*t74
              t253 = -2.3718174565385935d-2*t54*t59*t79/t50**6.333333333
     1           333333d+0
              t254 = -1.1961593727239421d+0*t246*t54*t59*t76*t79
              t255 = -7.176956236343652d-1*t249*t55*t59*t76*t79
              t256 = 1/t30**3
              t257 = 2.6666666666666666d+0*t131*t236*t53-2.6666666666666
     1           666d+0*t128*t236*t53+4.444444444444444d-1*t130*t166*t23
     2           9+4.444444444444444d-1*t127*t165*t235
              t258 = -1.923661050931536d+0*t257*t54*t55
              t259 = 7.694644203726144d+0*t134*t167*t54
              t260 = -7.694644203726144d+0*t136*t167*t55
              t261 = 7.694644203726144d+0*t132*t134*t54
              t262 = 7.694644203726144d+0*t132*t136*t55
              t263 = 2.3083932611178434d+1*t249*t55*t59
              t264 = t159**2
              t265 = 1/t37**5
              t266 = 1/rhob**2.3333333333333334d+0
              t267 = 1/rhob**2.1666666666666665d+0
              t268 = t162**2
              t269 = 1.7854583920998188d-15*t264*t48/(t45**4*t46**2)-2.2
     1           20446049250313d-16*t154*t264*t48/t45**3+1.1102230246251
     2           565d-16*t154*t160*(2.1077825841639536d-1*t28+1.16327369
     3           58443765d+0*t267+9.89141964955861d-1*t266+6.00321476249
     4           5226d-1*t265)*t48-4.0675215258019015d-19*t266*t47+3.216
     5           395899738507d+1*t268*t44/(t41**4*t42**2)-2.0d+0*t161*t2
     6           68*t44/t41**3+1.0d+0*t161*t163*(2.673190323653546d-1*t2
     7           8+2.1622951122684114d+0*t267+1.7087761055320938d+0*t266
     8           +1.2335503316757068d+0*t265)*t44-1.7613865241785684d-3*
     9           t266*t43-8.497974591333913d-2*t157*t161*t162*t163-9.812
     :           069668265515d-18*t154*t157*t159*t160
              t270 = 1.3333333333333333d+0*t128*(t241+t237)+1.3333333333
     1           333333d+0*t131*(t240+t238)+4.444444444444444d-1*t166**2
     2           *t239+4.444444444444444d-1*t165**2*t235
              t271 = -1.923661050931536d+0*t270*t54*t55
              t272 = 1.5389288407452287d+1*t134*t167*t54
              t273 = 1.5389288407452287d+1*t136*t167*t55
              t274 = -6.155715362980915d+1*t134*t136*t59
              t275 = 1/rhob**7.333333333333333d+0
              t276 = 1/rhob**4.666666666666667d+0
              t277 = 1/rhob**2
              t278 = gammabb**3
              t279 = 1/t82**3
              t280 = 1/rhob**10
              t281 = 1.25d-1*t49*t87
              t282 = 1/rhob**9
              t283 = 1/rhob**8
              fnc(iq) = (5.0d-1*rhob*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhoa*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t153*t81+1.0d+0*t148*t35+5.0d-1*t
     1           12*t26+5.0d-1*rhoa*t107*t26+5.0d-1*rhoa*t100*t12)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t88*(5.0d-1*t49*t87*t90+5.0d-1*rhob*t164
     1           *t87*t90+5.0d-1*rhob*t187*t49*t90)+1.25d-1*gammabb*t49*
     2           t87*t88*t89+1.0d+0*t180*t81+1.0d+0*t175*t35)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t88*(5.0d-1*rhob*t196*t49*t90-1.25d-1*t
     1           49*t87)+1.0d+0*t191*t81)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t49*t87*t88-5.0d-1*rhob*t197
     1           *t49*t87*t90)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t35*(-2.0d+0*t21*t97*t98*t99-
     1           2.220446049250313d-16*t25*t91*t95*t96-6.101282288702853
     2           d-19*t24*t93-2.642079786267853d-3*t20*t93+t50*(1.913854
     3           9963583074d+0*t134*t136*t59*t76*t79-5.980796863619711d-
     4           2*t242*t54*t55*t76*t79-4.7846374908957684d-1*t132*t136*
     5           t55*t76*t79+4.7846374908957684d-1*t132*t134*t54*t76*t79
     6           +2.0329863913187946d-2*t136*t145*t59*t79+5.082465978296
     7           986d-3*t132*t145*t54*t79+1.538928840745229d+1*t120*t121
     8           *t122*t136*t55*t59*t76+3.847322101863072d+0*t120*t121*t
     9           122*t132*t54*t55*t76+1.9751631321680768d-2*(t250+t248+t
     :           247+t245+t244+t243+1.923661050931536d+0*t242)*t70*t74-9
     ;           .087592854964233d-4*t110*t141*t74-1.1696447245269295d+0
     <           *t116*t117*t118*t141*t70-6.21814d-2*(t250+t248+t247+t24
     =           5+t244+t243)*t52*t68+5.495546528376875d-3*t110*t138*t68
     >           +2.0d+0*t112*t113*t114*t138*t52+t255+t254+t253+t252+t25
     ?           1+t234+t233+t232+t231+t230+t228+t227+t226+t225+t223+t21
     @           8+t217+t216)-4.7846374908957684d-1*t136*t55*t59*t76*t79
     1           -1.1961593727239421d-1*t132*t54*t55*t76*t79+3.950326264
     2           3361536d-2*t141*t70*t74-1.243628d-1*t138*t52*t68+t214+t
     3           213+t212+t211+t210+t209+t208-rhoa*t203)+5.0d-1*rhoa*t26
     4           *(2.4d-51*t2*t4*(2.4d-51*t2*t4*(1.0666666666666666d-50*
     5           t207*t4*t9-5.76d-101*t101*t206*t9+7.68d-152*t204*t205*t
     6           9+2.4d-51*t2*t4*(1.0666666666666666d-50*t207*t4*t8-5.76
     7           d-101*t101*t206*t8+7.68d-152*t204*t205*t8)-8.0d-51*t103
     8           *t104*t4+1.92d-101*t101*t102*t104)+1.0666666666666666d-
     9           50*t10*t207*t4-8.0d-51*t103*t105*t4-5.76d-101*t10*t101*
     :           t206+7.68d-152*t10*t204*t205+1.92d-101*t101*t102*t105)+
     ;           1.0666666666666666d-50*t11*t207*t4-8.0d-51*t103*t106*t4
     <           -5.76d-101*t101*t11*t206+7.68d-152*t11*t204*t205+1.92d-
     =           101*t101*t102*t106)+1.0d+0*(5.51111111111111d-52*t207*t
     >           31*t34+2.6480888888888887d-106*t206*t256*t29*t34-1.7084
     ?           44444444444d-54*t149*t207*t29*t34-8.542222222222222d-10
     @           4*t149*t206*t34+3.1d-3*t29*t31*(5.51111111111111d-52*t2
     1           07*t31*t33+2.6480888888888887d-106*t206*t256*t29*t33-1.
     2           708444444444444d-54*t149*t207*t29*t33-8.542222222222222
     3           d-104*t149*t206*t33+3.1d-3*t29*t31*(5.51111111111111d-5
     4           2*t207*t31*t32+2.6480888888888887d-106*t206*t256*t29*t3
     5           2-1.708444444444444d-54*t149*t207*t29*t32-8.54222222222
     6           2222d-104*t149*t206*t32+3.1d-3*t29*t31*(5.5111111111111
     7           1d-52*t207*t27*t31+2.6480888888888887d-106*t206*t256*t2
     8           7*t29-1.708444444444444d-54*t149*t207*t27*t29-8.5422222
     9           22222222d-104*t149*t206*t27)-4.1333333333333333d-52*t10
     :           3*t150*t31+1.2813333333333332d-54*t103*t149*t150*t29)-4
     ;           .1333333333333333d-52*t103*t151*t31+1.2813333333333332d
     <           -54*t103*t149*t151*t29)-4.1333333333333333d-52*t103*t15
     =           2*t31+1.2813333333333332d-54*t103*t149*t152*t29)*t81+1.
     >           0d+0*t107*t26+5.0d-1*rhoa*t12*t203+2.0d+0*t148*t153+1.0
     ?           d+0*t100*t12+1.0d+0*rhoa*t100*t107)*wght+Amat2(iq,D2_RA
     @           _RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*(1.0592355555555552d-56*gamma
     1           bb*t103*t176*t256*t29*t34-3.416888888888888d-54*gammabb
     2           *t103*t149*t176*t34+3.1d-3*t29*t31*(1.0592355555555552d
     3           -56*gammabb*t103*t176*t256*t29*t33-3.416888888888888d-5
     4           4*gammabb*t103*t149*t176*t33+3.1d-3*t29*t31*(1.05923555
     5           55555552d-56*gammabb*t103*t176*t256*t29*t32-3.416888888
     6           888888d-54*gammabb*t103*t149*t176*t32+3.1d-3*t29*(1.059
     7           2355555555552d-56*gammabb*t103*t176*t256*t27*t29-3.4168
     8           88888888888d-54*gammabb*t103*t149*t176*t27)*t31-2.06666
     9           66666666667d-52*t103*t177*t31-8.266666666666665d-3*gamm
     :           abb*t150*t176*t31+6.406666666666666d-55*t103*t149*t177*
     ;           t29+2.562666666666666d-5*gammabb*t149*t150*t176*t29)-2.
     <           0666666666666667d-52*t103*t178*t31-8.266666666666665d-3
     =           *gammabb*t151*t176*t31+6.406666666666666d-55*t103*t149*
     >           t178*t29+2.562666666666666d-5*gammabb*t149*t151*t176*t2
     ?           9)-2.0666666666666667d-52*t103*t179*t31-8.2666666666666
     @           65d-3*gammabb*t152*t176*t31+6.406666666666666d-55*t103*
     1           t149*t179*t29+2.562666666666666d-5*gammabb*t149*t152*t1
     2           76*t29)*t81+1.0d+0*t35*(t50*(7.176956236343652d-1*t249*
     3           t55*t59*t76*t79-5.980796863619711d-2*t257*t54*t55*t76*t
     4           79-2.3923187454478842d-1*t136*t167*t55*t76*t79+2.392318
     5           7454478842d-1*t132*t136*t55*t76*t79+2.3923187454478842d
     6           -1*t134*t167*t54*t76*t79+2.3923187454478842d-1*t132*t13
     7           4*t54*t76*t79+2.541232989148493d-3*t145*t167*t54*t79+2.
     8           541232989148493d-3*t132*t145*t54*t79+1.923661050931536d
     9           +0*t120*t121*t122*t167*t54*t55*t76+1.923661050931536d+0
     :           *t120*t121*t122*t132*t54*t55*t76+1.9751631321680768d-2*
     ;           (t263+t262+t261+t260+t259+t258+1.923661050931536d+0*t25
     <           7+t247)*t70*t74-4.5437964274821163d-4*t110*t172*t74-4.5
     =           437964274821163d-4*t110*t141*t74-5.848223622634647d-1*t
     >           116*t117*t118*t172*t70-5.848223622634647d-1*t116*t117*t
     ?           118*t141*t70-6.21814d-2*(t263+t262+t261+t260+t259+t258+
     @           t247)*t52*t68+2.747773264188437d-3*t110*t170*t68+2.7477
     1           73264188437d-3*t110*t138*t68+1.0d+0*t112*t113*t114*t170
     2           *t52+1.0d+0*t112*t113*t114*t138*t52+t254+t253+t252+t251
     3           +t234+t233+t232+t231+t230+t228+t227+t226+t225+t223+t218
     4           +t217+t216)+t214+t213+t212+t211+t210+t209+t208+t174+t17
     5           3+t171+t144+t142+t139)+1.0d+0*t148*t180+1.0d+0*t153*t17
     6           5)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t88*(5.0d-1*rhob*t269*t87*t90+1.0d+0
     1           *t164*t87*t90+5.0d-1*rhob*t49*(5.866666666666666d-1*gam
     2           mabb*t276*t83*t86+3.0719999999999986d-3*t278*t279*t280*
     3           t86-8.639999999999998d-2*t181*t182*t275*t86+6.0d-2*gamm
     4           abb*t28*t83*(5.866666666666666d-1*gammabb*t276*t83*t85+
     5           3.0719999999999986d-3*t278*t279*t280*t85-8.639999999999
     6           998d-2*t181*t182*t275*t85+6.0d-2*gammabb*t28*t83*(5.866
     7           666666666666d-1*gammabb*t276*t83*t84+3.0719999999999986
     8           d-3*t278*t279*t280*t84-8.639999999999998d-2*t181*t182*t
     9           275*t84+6.0d-2*gammabb*t28*t83*(5.866666666666666d-1*ga
     :           mmabb*t276*t8*t83+3.0719999999999986d-3*t278*t279*t280*
     ;           t8-8.639999999999998d-2*t181*t182*t275*t8)-3.1999999999
     <           999995d-1*gammabb*t176*t184*t83+1.9199999999999995d-2*t
     =           181*t182*t183*t184)-3.1999999999999995d-1*gammabb*t176*
     >           t185*t83+1.9199999999999995d-2*t181*t182*t183*t185)-3.1
     ?           999999999999995d-1*gammabb*t176*t186*t83+1.919999999999
     @           9995d-2*t181*t182*t183*t186)*t90+1.0d+0*t187*t49*t90+1.
     1           0d+0*rhob*t164*t187*t90+1.25d-1*gammabb*t164*t87*t89+1.
     2           25d-1*gammabb*t187*t49*t89+1.25d-1*gammabb*t277*t49*t87
     3           )+(1.25d-1*gammabb*t164*t87+1.25d-1*gammabb*t187*t49)*t
     4           88*t89-1.25d-1*gammabb*t277*t49*t87*t88+1.0d+0*(3.03111
     5           11111111105d-2*gammabb*t276*t31*t34-9.396444444444442d-
     6           5*gammabb*t149*t276*t29*t34+4.2369422222222203d-7*t181*
     7           t256*t275*t29*t34-1.366755555555555d-4*t149*t181*t275*t
     8           34+3.1d-3*t29*t31*(3.0311111111111105d-2*gammabb*t276*t
     9           31*t33-9.396444444444442d-5*gammabb*t149*t276*t29*t33+4
     :           .2369422222222203d-7*t181*t256*t275*t29*t33-1.366755555
     ;           555555d-4*t149*t181*t275*t33+3.1d-3*t29*t31*(3.03111111
     <           11111105d-2*gammabb*t276*t31*t32-9.396444444444442d-5*g
     =           ammabb*t149*t276*t29*t32+4.2369422222222203d-7*t181*t25
     >           6*t275*t29*t32-1.366755555555555d-4*t149*t181*t275*t32+
     ?           3.1d-3*t29*t31*(3.0311111111111105d-2*gammabb*t27*t276*
     @           t31-9.396444444444442d-5*gammabb*t149*t27*t276*t29+4.23
     1           69422222222203d-7*t181*t256*t27*t275*t29-1.366755555555
     2           555d-4*t149*t181*t27*t275)-1.653333333333333d-2*gammabb
     3           *t176*t177*t31+5.125333333333332d-5*gammabb*t149*t176*t
     4           177*t29)-1.653333333333333d-2*gammabb*t176*t178*t31+5.1
     5           25333333333332d-5*gammabb*t149*t176*t178*t29)-1.6533333
     6           33333333d-2*gammabb*t176*t179*t31+5.125333333333332d-5*
     7           gammabb*t149*t176*t179*t29)*t81+1.0d+0*t35*(t50*(-1.913
     8           8549963583074d+0*t134*t136*t59*t76*t79-5.98079686361971
     9           1d-2*t270*t54*t55*t76*t79+4.7846374908957684d-1*t136*t1
     :           67*t55*t76*t79+4.7846374908957684d-1*t134*t167*t54*t76*
     ;           t79-2.0329863913187946d-2*t136*t145*t59*t79+5.082465978
     <           296986d-3*t145*t167*t54*t79-1.538928840745229d+1*t120*t
     =           121*t122*t136*t55*t59*t76+3.847322101863072d+0*t120*t12
     >           1*t122*t167*t54*t55*t76+1.9751631321680768d-2*(t274+t27
     ?           3+t272+t271+1.923661050931536d+0*t270+t250+t247)*t70*t7
     @           4-9.087592854964233d-4*t110*t172*t74-1.1696447245269295
     1           d+0*t116*t117*t118*t172*t70-6.21814d-2*(t274+t273+t272+
     2           t271+t250+t247)*t52*t68+5.495546528376875d-3*t110*t170*
     3           t68+2.0d+0*t112*t113*t114*t170*t52+t255+t254+t253+t252+
     4           t251+t234+t233+t232+t231+t230+t228+t227+t226+t225+t223+
     5           t218+t217+t216)+4.7846374908957684d-1*t136*t55*t59*t76*
     6           t79-1.1961593727239421d-1*t167*t54*t55*t76*t79+3.950326
     7           2643361536d-2*t172*t70*t74-1.243628d-1*t170*t52*t68-2.2
     8           20446049250313d-16*t154*t159*t160*t48-6.101282288702853
     9           d-19*t157*t47-2.0d+0*t161*t162*t163*t44-2.6420797862678
     :           53d-3*t157*t43-rhob*t269+t214+t213+t212+t211+t210+t209+
     ;           t208)+2.0d+0*t175*t180)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*(-3.972133333333333d-57*t103
     1           *t256*t28*t29*t34+1.2813333333333332d-54*t103*t149*t28*
     2           t34+3.1d-3*t29*t31*(-3.972133333333333d-57*t103*t256*t2
     3           8*t29*t33+1.2813333333333332d-54*t103*t149*t28*t33+3.1d
     4           -3*t29*t31*(-3.972133333333333d-57*t103*t256*t28*t29*t3
     5           2+1.2813333333333332d-54*t103*t149*t28*t32+3.1d-3*t29*(
     6           1.2813333333333332d-54*t103*t149*t27*t28-3.972133333333
     7           333d-57*t103*t256*t27*t28*t29)*t31+3.1d-3*t150*t28*t31-
     8           2.0666666666666667d-52*t103*t188*t31-9.61d-6*t149*t150*
     9           t28*t29+6.406666666666666d-55*t103*t149*t188*t29)+3.1d-
     :           3*t151*t28*t31-2.0666666666666667d-52*t103*t189*t31-9.6
     ;           1d-6*t149*t151*t28*t29+6.406666666666666d-55*t103*t149*
     <           t189*t29)+3.1d-3*t152*t28*t31-2.0666666666666667d-52*t1
     =           03*t190*t31-9.61d-6*t149*t152*t28*t29+6.406666666666666
     >           d-55*t103*t149*t190*t29)*t81+1.0d+0*t148*t191)*wght+Cma
     ?           t2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t88*(5.0d-1*rhob*t49*(-1.5999999999
     1           999998d-1*t176*t83*t86-1.1519999999999996d-3*t181*t279*
     2           t282*t86+2.879999999999999d-2*gammabb*t182*t183*t86+6.0
     3           d-2*gammabb*t28*t83*(-1.5999999999999998d-1*t176*t83*t8
     4           5-1.1519999999999996d-3*t181*t279*t282*t85+2.8799999999
     5           99999d-2*gammabb*t182*t183*t85+6.0d-2*gammabb*t28*t83*(
     6           -1.5999999999999998d-1*t176*t83*t84-1.1519999999999996d
     7           -3*t181*t279*t282*t84+2.879999999999999d-2*gammabb*t182
     8           *t183*t84+6.0d-2*gammabb*t28*t83*(-1.5999999999999998d-
     9           1*t176*t8*t83-1.1519999999999996d-3*t181*t279*t282*t8+2
     :           .879999999999999d-2*gammabb*t182*t183*t8)+6.0d-2*t184*t
     ;           28*t83-1.5999999999999998d-1*gammabb*t176*t193*t83+9.59
     <           9999999999997d-3*t181*t182*t183*t193-3.6d-3*gammabb*t18
     =           2*t184*t192)+6.0d-2*t185*t28*t83-1.5999999999999998d-1*
     >           gammabb*t176*t194*t83+9.599999999999997d-3*t181*t182*t1
     ?           83*t194-3.6d-3*gammabb*t182*t185*t192)+6.0d-2*t186*t28*
     @           t83-1.5999999999999998d-1*gammabb*t176*t195*t83+9.59999
     1           9999999997d-3*t181*t182*t183*t195-3.6d-3*gammabb*t182*t
     2           186*t192)*t90+5.0d-1*t196*t49*t90+5.0d-1*rhob*t164*t196
     3           *t90-1.25d-1*t49*t87*t89-1.25d-1*t164*t87-1.25d-1*t187*
     4           t49)+(1.25d-1*gammabb*t196*t49+t281)*t88*t89+1.0d+0*(-8
     5           .266666666666665d-3*t176*t31*t34-1.5888533333333327d-7*
     6           gammabb*t183*t256*t29*t34+2.562666666666666d-5*t149*t17
     7           6*t29*t34+5.125333333333332d-5*gammabb*t149*t183*t34+3.
     8           1d-3*t29*t31*(-8.266666666666665d-3*t176*t31*t33-1.5888
     9           533333333327d-7*gammabb*t183*t256*t29*t33+2.56266666666
     :           6666d-5*t149*t176*t29*t33+5.125333333333332d-5*gammabb*
     ;           t149*t183*t33+3.1d-3*t29*t31*(-8.266666666666665d-3*t17
     <           6*t31*t32-1.5888533333333327d-7*gammabb*t183*t256*t29*t
     =           32+2.562666666666666d-5*t149*t176*t29*t32+5.12533333333
     >           3332d-5*gammabb*t149*t183*t32+3.1d-3*t29*t31*(-8.266666
     ?           666666665d-3*t176*t27*t31-1.5888533333333327d-7*gammabb
     @           *t183*t256*t27*t29+2.562666666666666d-5*t149*t176*t27*t
     1           29+5.125333333333332d-5*gammabb*t149*t183*t27)+3.1d-3*t
     2           177*t28*t31-8.266666666666665d-3*gammabb*t176*t188*t31-
     3           9.61d-6*t149*t177*t28*t29+2.562666666666666d-5*gammabb*
     4           t149*t176*t188*t29)+3.1d-3*t178*t28*t31-8.2666666666666
     5           65d-3*gammabb*t176*t189*t31-9.61d-6*t149*t178*t28*t29+2
     6           .562666666666666d-5*gammabb*t149*t176*t189*t29)+3.1d-3*
     7           t179*t28*t31-8.266666666666665d-3*gammabb*t176*t190*t31
     8           -9.61d-6*t149*t179*t28*t29+2.562666666666666d-5*gammabb
     9           *t149*t176*t190*t29)*t81+1.0d+0*t175*t191)*wght+Cmat2(i
     :           q,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t88*(5.0d-1*rhob*t49*(4.32d-4*gamm
     1           abb*t279*t283*t86-7.2d-3*t182*t192*t86+6.0d-2*gammabb*t
     2           28*t83*(4.32d-4*gammabb*t279*t283*t85-7.2d-3*t182*t192*
     3           t85+6.0d-2*gammabb*t28*t83*(4.32d-4*gammabb*t279*t283*t
     4           84-7.2d-3*t182*t192*t84+6.0d-2*gammabb*t28*(4.32d-4*gam
     5           mabb*t279*t283*t8-7.2d-3*t182*t192*t8)*t83+1.2d-1*t193*
     6           t28*t83-7.2d-3*gammabb*t182*t192*t193)+1.2d-1*t194*t28*
     7           t83-7.2d-3*gammabb*t182*t192*t194)+1.2d-1*t195*t28*t83-
     8           7.2d-3*gammabb*t182*t192*t195)*t90-2.5d-1*t196*t49)+1.0
     9           d+0*(5.9582d-8*t192*t256*t29*t34-1.9219999999999998d-5*
     :           t149*t192*t34+3.1d-3*t29*t31*(5.9582d-8*t192*t256*t29*t
     ;           33-1.9219999999999998d-5*t149*t192*t33+3.1d-3*t29*t31*(
     <           5.9582d-8*t192*t256*t29*t32-1.9219999999999998d-5*t149*
     =           t192*t32+3.1d-3*t29*(5.9582d-8*t192*t256*t27*t29-1.9219
     >           999999999998d-5*t149*t192*t27)*t31+6.2d-3*t188*t28*t31-
     ?           1.9219999999999998d-5*t149*t188*t28*t29)+6.2d-3*t189*t2
     @           8*t31-1.9219999999999998d-5*t149*t189*t28*t29)+6.2d-3*t
     1           190*t28*t31-1.9219999999999998d-5*t149*t190*t28*t29)*t8
     2           1)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t197*(-5.0d-1*t49*t87*t90-5.0d-1*rho
     1           b*t164*t87*t90-5.0d-1*rhob*t187*t49*t90)-1.25d-1*gammab
     2           b*t197*t49*t87*t89+(1.0d+0*t49*t87+1.0d+0*rhob*t164*t87
     3           +1.0d+0*rhob*t187*t49)*t88)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (t197*(t281-5.0d-1*rhob*t196*t49*t90
     1           )+1.0d+0*rhob*t196*t49*t88)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t49*t87*t90/taub**3-2.0d
     1           +0*rhob*t197*t49*t87)*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.4d-51*t27+1.0d+0
              t29 = 1/t28
              t30 = 2.4d-51*t27*t29*t8+t7
              t31 = t6+2.4d-51*t27*t29*t30
              t32 = t5+2.4d-51*t27*t29*t31
              t33 = 2.4d-51*t27*t29*t32+t1
              t34 = 1/rhob**6.666666666666666d-1
              t35 = rhob**5.0d-1
              t36 = 1/t35
              t37 = 1/rhob**3.333333333333333d-1
              t38 = 1/rhob**1.6666666666666666d-1
              t39 = 1.1120374863094686d+1*t38+3.8447462374472113d+0*t37+
     1           1.644733775567609d+0*t36+2.4058712912881916d-1*t34
              t40 = 3.216395899738507d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.274696188700087d-1*t37+1.0d+0
              t43 = 5.982550435771079d+0*t38+2.2255694211506874d+0*t37+8
     1           .004286349993635d-1*t36+1.8970043257475583d-1*t34
              t44 = 1.6081979498692536d+1/t43+1.0d+0
              t45 = log(t44)
              t46 = 1.3256889990520176d-1*t37+1.0d+0
              t47 = -6.903522198342671d-18*t45*t46-3.1090699999999993d-2
     1           *t41*t42
              t48 = 4.0d-50*t27+4.0d-50*t2
              t49 = 3.1d-3*t48+1.0d+0
              t50 = 1/t49
              t51 = param(5)
              t52 = 3.1d-3*t48*t50*t51+param(4)
              t53 = 3.1d-3*t48*t50*t52+param(3)
              t54 = 3.1d-3*t48*t50*t53+param(2)
              t55 = 3.1d-3*t48*t50*t54+param(1)
              t56 = rhob+rhoa
              t57 = 1/t56**3.333333333333333d-1
              t58 = 1.3256889990520176d-1*t57+1.0d+0
              t59 = rhoa-rhob
              t60 = t59**4
              t61 = 1/t56**4
              t62 = 1/t56
              t63 = 1.0d+0-t59*t62
              t64 = t59*t62+1.0d+0
              t65 = t64**1.3333333333333333d+0+t63**1.3333333333333333d+
     1           0-2.0d+0
              t66 = -1.923661050931536d+0*t60*t61*t65
              t67 = t66+1.0d+0
              t68 = 1/t56**6.666666666666666d-1
              t69 = t56**5.0d-1
              t70 = 1/t69
              t71 = 1/t56**1.6666666666666666d-1
              t72 = 5.982550435771079d+0*t71+8.004286349993635d-1*t70+1.
     1           8970043257475583d-1*t68+2.2255694211506874d+0*t57
              t73 = 1.6081979498692536d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = -6.21814d-2*t58*t67*t74
              t76 = 6.901399211255825d-2*t57+1.0d+0
              t77 = t66+1.923661050931536d+0*t65
              t78 = 8.157414703487641d+0*t71+4.3009724712766434d-1*t70+1
     1           .9115125951273373d-1*t68+2.247591863577616d+0*t57
              t79 = 2.9608813203268075d+1/t78+1.0d+0
              t80 = log(t79)
              t81 = 1.9751631321680768d-2*t76*t77*t80
              t82 = 1.274696188700087d-1*t57+1.0d+0
              t83 = 1.1120374863094686d+1*t71+1.644733775567609d+0*t70+2
     1           .4058712912881916d-1*t68+3.8447462374472113d+0*t57
              t84 = 3.216395899738507d+1/t83+1.0d+0
              t85 = log(t84)
              t86 = -5.980796863619711d-2*t60*t61*t65*t82*t85
              t87 = t56*(t86+t81+t75)-rhob*t47-rhoa*t26
              t88 = 1/t23
              t89 = 1/t14**3
              t90 = 1/rhoa**1.3333333333333333d+0
              t91 = 1/rhoa**1.1666666666666667d+0
              t92 = -9.970917392951799d-1*t91-7.418564737168958d-1*t90-4
     1           .002143174996817d-1*t89-1.264669550498372d-1*t2
              t93 = 1/t22**2
              t94 = 1/t19
              t95 = -1.8533958105157808d+0*t91-1.2815820791490704d+0*t90
     1           -8.223668877838045d-1*t89-1.6039141941921276d-1*t2
              t96 = 1/t18**2
              t97 = 1.0d+0*t21*t94*t95*t96+1.1102230246251565d-16*t25*t8
     1           8*t92*t93+3.0506411443514264d-19*t24*t90+1.321039893133
     2           9265d-3*t20*t90
              t98 = 1/t3**2
              t99 = 1/rhoa**4.333333333333333d+0
              t100 = 1/rhoa**2.6666666666666666d+0
              t101 = 9.6d-102*t8*t98*t99-4.0d-51*t100*t4*t8
              t102 = 9.6d-102*t9*t98*t99-4.0d-51*t100*t4*t9+2.4d-51*t101
     1           *t2*t4
              t103 = 9.6d-102*t10*t98*t99+2.4d-51*t102*t2*t4-4.0d-51*t10
     1           *t100*t4
              t104 = 9.6d-102*t11*t98*t99+2.4d-51*t103*t2*t4-4.0d-51*t10
     1           0*t11*t4
              t105 = 1/t56**1.6666666666666669d+0
              t106 = 1/t69**3
              t107 = 1/t56**1.3333333333333333d+0
              t108 = 1/t56**1.1666666666666667d+0
              t109 = -9.970917392951799d-1*t108-7.418564737168958d-1*t10
     1           7-4.002143174996817d-1*t106-1.264669550498372d-1*t105
              t110 = 1/t72**2
              t111 = 1/t73
              t112 = 1.0d+0*t109*t110*t111*t58*t67
              t113 = -1.3595691172479402d+0*t108-7.491972878592053d-1*t1
     1           07-2.1504862356383217d-1*t106-1.2743417300848914d-1*t10
     2           5
              t114 = 1/t78**2
              t115 = 1/t79
              t116 = -5.848223622634647d-1*t113*t114*t115*t76*t77
              t117 = -1.8533958105157808d+0*t108-1.2815820791490704d+0*t
     1           107-8.223668877838045d-1*t106-1.6039141941921276d-1*t10
     2           5
              t118 = 1/t83**2
              t119 = 1/t84
              t120 = 1.923661050931536d+0*t117*t118*t119*t60*t61*t65*t82
              t121 = 1/t56**2
              t122 = t121*t59
              t123 = -t62
              t124 = t123+t122
              t125 = t63**3.333333333333333d-1
              t126 = -t121*t59
              t127 = t62+t126
              t128 = t64**3.333333333333333d-1
              t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d
     1           +0*t124*t125
              t130 = -1.923661050931536d+0*t129*t60*t61
              t131 = 1/t56**5
              t132 = 7.694644203726144d+0*t131*t60*t65
              t133 = t59**3
              t134 = -7.694644203726144d+0*t133*t61*t65
              t135 = t134+t132+t130
              t136 = -6.21814d-2*t135*t58*t74
              t137 = 2.747773264188437d-3*t107*t67*t74
              t138 = t134+t132+t130+1.923661050931536d+0*t129
              t139 = 1.9751631321680768d-2*t138*t76*t80
              t140 = -4.5437964274821163d-4*t107*t77*t80
              t141 = -5.980796863619711d-2*t129*t60*t61*t82*t85
              t142 = 1/t56**5.333333333333333d+0
              t143 = 2.541232989148493d-3*t142*t60*t65*t85
              t144 = 2.3923187454478842d-1*t131*t60*t65*t82*t85
              t145 = -rhoa*t97+t86+t56*(-2.3923187454478842d-1*t133*t61*
     1           t65*t82*t85+t144+t143+t141+t140+t139+t137+t136+t120+t11
     2           6+t112)+t81+t75+6.903522198342671d-18*t24*t25+3.1090699
     3           999999993d-2*t20*t21
              t146 = 1/t49**2
              t147 = 6.406666666666666d-55*t100*t146*t48*t51-2.066666666
     1           6666667d-52*t100*t50*t51
              t148 = -2.0666666666666667d-52*t100*t50*t52+6.406666666666
     1           666d-55*t100*t146*t48*t52+3.1d-3*t147*t48*t50
              t149 = -2.0666666666666667d-52*t100*t50*t53+6.406666666666
     1           666d-55*t100*t146*t48*t53+3.1d-3*t148*t48*t50
              t150 = -2.0666666666666667d-52*t100*t50*t54+6.406666666666
     1           666d-55*t100*t146*t48*t54+3.1d-3*t149*t48*t50
              t151 = 1/t44
              t152 = 1/t35**3
              t153 = 1/rhob**1.3333333333333333d+0
              t154 = 1/rhob**1.1666666666666667d+0
              t155 = -1.264669550498372d-1*t27-9.970917392951799d-1*t154
     1           -7.418564737168958d-1*t153-4.002143174996817d-1*t152
              t156 = 1/t43**2
              t157 = 1/t40
              t158 = -1.6039141941921276d-1*t27-1.8533958105157808d+0*t1
     1           54-1.2815820791490704d+0*t153-8.223668877838045d-1*t152
              t159 = 1/t39**2
              t160 = 1.1102230246251565d-16*t151*t155*t156*t46+3.0506411
     1           443514264d-19*t153*t45+1.0d+0*t157*t158*t159*t42+1.3210
     2           398931339265d-3*t153*t41
              t161 = 1/t28**2
              t162 = 1/rhob**4.333333333333333d+0
              t163 = 1/rhob**2.6666666666666666d+0
              t164 = 9.6d-102*t161*t162*t8-4.0d-51*t163*t29*t8
              t165 = -4.0d-51*t163*t29*t30+9.6d-102*t161*t162*t30+2.4d-5
     1           1*t164*t27*t29
              t166 = -4.0d-51*t163*t29*t31+9.6d-102*t161*t162*t31+2.4d-5
     1           1*t165*t27*t29
              t167 = -4.0d-51*t163*t29*t32+9.6d-102*t161*t162*t32+2.4d-5
     1           1*t166*t27*t29
              t168 = t62+t122
              t169 = t126+t123
              t170 = 1.3333333333333333d+0*t128*t169+1.3333333333333333d
     1           +0*t125*t168
              t171 = -1.923661050931536d+0*t170*t60*t61
              t172 = 7.694644203726144d+0*t133*t61*t65
              t173 = t172+t171+t132
              t174 = -6.21814d-2*t173*t58*t74
              t175 = t172+t171+1.923661050931536d+0*t170+t132
              t176 = 1.9751631321680768d-2*t175*t76*t80
              t177 = -5.980796863619711d-2*t170*t60*t61*t82*t85
              t178 = t86+t56*(2.3923187454478842d-1*t133*t61*t65*t82*t85
     1           +t177+t176+t174+t144+t143+t140+t137+t120+t116+t112)+t81
     2           +t75+6.903522198342671d-18*t45*t46+3.1090699999999993d-
     3           2*t41*t42-rhob*t160
              t179 = 6.406666666666666d-55*t146*t163*t48*t51-2.066666666
     1           6666667d-52*t163*t50*t51
              t180 = -2.0666666666666667d-52*t163*t50*t52+6.406666666666
     1           666d-55*t146*t163*t48*t52+3.1d-3*t179*t48*t50
              t181 = -2.0666666666666667d-52*t163*t50*t53+6.406666666666
     1           666d-55*t146*t163*t48*t53+3.1d-3*t180*t48*t50
              t182 = -2.0666666666666667d-52*t163*t50*t54+6.406666666666
     1           666d-55*t146*t163*t48*t54+3.1d-3*t181*t48*t50
              t183 = t92**2
              t184 = 1/t14**5
              t185 = 1/rhoa**2.3333333333333334d+0
              t186 = 1/rhoa**2.1666666666666665d+0
              t187 = t95**2
              t188 = -8.497974591333913d-2*t90*t94*t95*t96+1.0d+0*(2.162
     1           2951122684114d+0*t186+1.7087761055320938d+0*t185+1.2335
     2           503316757068d+0*t184+2.673190323653546d-1*t100)*t21*t94
     3           *t96-2.0d+0*t187*t21*t94/t18**3-9.812069668265515d-18*t
     4           88*t90*t92*t93+1.1102230246251565d-16*(1.16327369584437
     5           65d+0*t186+9.89141964955861d-1*t185+6.003214762495226d-
     6           1*t184+2.1077825841639536d-1*t100)*t25*t88*t93-2.220446
     7           049250313d-16*t183*t25*t88/t22**3+1.7854583920998188d-1
     8           5*t183*t25/(t22**4*t23**2)-4.0675215258019015d-19*t185*
     9           t24+3.216395899738507d+1*t187*t21/(t18**4*t19**2)-1.761
     :           3865241785684d-3*t185*t20
              t189 = 1/t3**3
              t190 = 1/rhoa**7
              t191 = 1/rhoa**5.333333333333333d+0
              t192 = 1/rhoa**3.6666666666666664d+0
              t193 = 2.0d+0*t109*t110*t111*t58*t67
              t194 = -1.1696447245269295d+0*t113*t114*t115*t76*t77
              t195 = 3.847322101863072d+0*t117*t118*t119*t60*t61*t65*t82
              t196 = 5.495546528376875d-3*t107*t67*t74
              t197 = -9.087592854964233d-4*t107*t77*t80
              t198 = 5.082465978296986d-3*t142*t60*t65*t85
              t199 = 4.7846374908957684d-1*t131*t60*t65*t82*t85
              t200 = t109**2
              t201 = 1.6081979498692536d+1*t200*t58*t67/(t72**4*t73**2)
              t202 = -2.0d+0*t111*t200*t58*t67/t72**3
              t203 = -8.837926660346784d-2*t107*t109*t110*t111*t67
              t204 = 1/t56**2.6666666666666666d+0
              t205 = 1/t69**5
              t206 = 1/t56**2.3333333333333334d+0
              t207 = 1/t56**2.1666666666666665d+0
              t208 = 1.0d+0*t110*t111*(1.1632736958443765d+0*t207+9.8914
     1           1964955861d-1*t206+6.003214762495226d-1*t205+2.10778258
     2           41639536d-1*t204)*t58*t67
              t209 = t113**2
              t210 = -1.73158960813529d+1*t209*t76*t77/(t78**4*t79**2)
              t211 = 1.1696447245269295d+0*t115*t209*t76*t77/t78**3
              t212 = 2.690728393099896d-2*t107*t113*t114*t115*t77
              t213 = -5.848223622634647d-1*t114*t115*(1.5861639701225969
     1           d+0*t207+9.98929717145607d-1*t206+3.2257293534574827d-1
     2           *t205+2.1239028834748191d-1*t204)*t76*t77
              t214 = t117**2
              t215 = 6.187255516702861d+1*t214*t60*t61*t65*t82/(t83**4*t
     1           84**2)
              t216 = -3.847322101863072d+0*t119*t214*t60*t61*t65*t82/t83
     1           **3
              t217 = -1.6347222733154887d-1*t117*t118*t119*t142*t60*t65
              t218 = 1.923661050931536d+0*t118*t119*(2.1622951122684114d
     1           +0*t207+1.7087761055320938d+0*t206+1.2335503316757068d+
     2           0*t205+2.673190323653546d-1*t204)*t60*t61*t65*t82
              t219 = -1.538928840745229d+1*t117*t118*t119*t131*t60*t65*t
     1           82
              t220 = 1/t63**6.666666666666666d-1
              t221 = 1/t56**3
              t222 = -2*t221*t59
              t223 = 2*t121
              t224 = 1/t64**6.666666666666666d-1
              t225 = 2*t221*t59
              t226 = -2*t121
              t227 = 1.3333333333333333d+0*t128*(t226+t225)+4.4444444444
     1           44444d-1*t127**2*t224+1.3333333333333333d+0*t125*(t223+
     2           t222)+4.444444444444444d-1*t124**2*t220
              t228 = -1.923661050931536d+0*t227*t60*t61
              t229 = 1.5389288407452287d+1*t129*t131*t60
              t230 = -1.5389288407452287d+1*t129*t133*t61
              t231 = 1/t56**6
              t232 = -3.8473221018630716d+1*t231*t60*t65
              t233 = 6.155715362980915d+1*t131*t133*t65
              t234 = t59**2
              t235 = -2.3083932611178434d+1*t234*t61*t65
              t236 = -3.663697685584583d-3*t206*t67*t74
              t237 = 6.058395236642822d-4*t206*t77*t80
              t238 = -2.3718174565385935d-2*t60*t65*t85/t56**6.333333333
     1           333333d+0
              t239 = -1.1961593727239421d+0*t231*t60*t65*t82*t85
              t240 = -7.176956236343652d-1*t234*t61*t65*t82*t85
              t241 = 1/t49**3
              t242 = 2.6666666666666666d+0*t128*t221*t59-2.6666666666666
     1           666d+0*t125*t221*t59+4.444444444444444d-1*t127*t169*t22
     2           4+4.444444444444444d-1*t124*t168*t220
              t243 = -1.923661050931536d+0*t242*t60*t61
              t244 = 7.694644203726144d+0*t131*t170*t60
              t245 = -7.694644203726144d+0*t133*t170*t61
              t246 = 7.694644203726144d+0*t129*t131*t60
              t247 = 7.694644203726144d+0*t129*t133*t61
              t248 = 2.3083932611178434d+1*t234*t61*t65
              t249 = t155**2
              t250 = 1/t35**5
              t251 = 1/rhob**2.3333333333333334d+0
              t252 = 1/rhob**2.1666666666666665d+0
              t253 = t158**2
              t254 = 1.7854583920998188d-15*t249*t46/(t43**4*t44**2)-2.2
     1           20446049250313d-16*t151*t249*t46/t43**3+1.1102230246251
     2           565d-16*t151*t156*(1.1632736958443765d+0*t252+9.8914196
     3           4955861d-1*t251+6.003214762495226d-1*t250+2.10778258416
     4           39536d-1*t163)*t46-4.0675215258019015d-19*t251*t45+3.21
     5           6395899738507d+1*t253*t42/(t39**4*t40**2)-2.0d+0*t157*t
     6           253*t42/t39**3+1.0d+0*t157*t159*(2.1622951122684114d+0*
     7           t252+1.7087761055320938d+0*t251+1.2335503316757068d+0*t
     8           250+2.673190323653546d-1*t163)*t42-1.7613865241785684d-
     9           3*t251*t41-8.497974591333913d-2*t153*t157*t158*t159-9.8
     :           12069668265515d-18*t151*t153*t155*t156
              t255 = 1/t28**3
              t256 = 1/rhob**7
              t257 = 1/rhob**5.333333333333333d+0
              t258 = 1/rhob**3.6666666666666664d+0
              t259 = 1.3333333333333333d+0*t125*(t226+t222)+1.3333333333
     1           333333d+0*t128*(t225+t223)+4.444444444444444d-1*t169**2
     2           *t224+4.444444444444444d-1*t168**2*t220
              t260 = -1.923661050931536d+0*t259*t60*t61
              t261 = 1.5389288407452287d+1*t131*t170*t60
              t262 = 1.5389288407452287d+1*t133*t170*t61
              t263 = -6.155715362980915d+1*t131*t133*t65
              fnc(iq) = (1.0d+0*t55*t87+5.0d-1*rhob*t33*t47+5.0d-1*rhoa*
     1           t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t12*t97+1.0d+0*t150*t87+1.0d
     1           +0*t145*t55+5.0d-1*t12*t26+5.0d-1*rhoa*t104*t26)*wght+A
     2           mat(iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t182*t87+1.0d+0*t178*t55+5.0d-1*t
     1           33*t47+5.0d-1*rhob*t167*t47+5.0d-1*rhob*t160*t33)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (5.0d-1*rhoa*t26*(2.4d-51*t2*t4*(2.4d
     1           -51*t2*t4*(1.92d-101*t101*t98*t99+2.4d-51*t2*t4*(-5.76d
     2           -101*t191*t8*t98+1.0666666666666666d-50*t192*t4*t8+7.68
     3           d-152*t189*t190*t8)-5.76d-101*t191*t9*t98+1.06666666666
     4           66666d-50*t192*t4*t9+7.68d-152*t189*t190*t9-8.0d-51*t10
     5           0*t101*t4)+1.92d-101*t102*t98*t99-5.76d-101*t10*t191*t9
     6           8+1.0666666666666666d-50*t10*t192*t4-8.0d-51*t100*t102*
     7           t4+7.68d-152*t10*t189*t190)+1.92d-101*t103*t98*t99-5.76
     8           d-101*t11*t191*t98+1.0666666666666666d-50*t11*t192*t4-8
     9           .0d-51*t100*t103*t4+7.68d-152*t11*t189*t190)+1.0d+0*t12
     :           *t97+1.0d+0*rhoa*t104*t97+1.0d+0*t55*(-2.0d+0*t21*t94*t
     ;           95*t96-2.220446049250313d-16*t25*t88*t92*t93-6.10128228
     <           8702853d-19*t24*t90-2.642079786267853d-3*t20*t90+t56*(1
     =           .9138549963583074d+0*t131*t133*t65*t82*t85-5.9807968636
     >           19711d-2*t227*t60*t61*t82*t85-4.7846374908957684d-1*t12
     ?           9*t133*t61*t82*t85+4.7846374908957684d-1*t129*t131*t60*
     @           t82*t85+2.0329863913187946d-2*t133*t142*t65*t85+5.08246
     1           5978296986d-3*t129*t142*t60*t85+1.538928840745229d+1*t1
     2           17*t118*t119*t133*t61*t65*t82+3.847322101863072d+0*t117
     3           *t118*t119*t129*t60*t61*t82+1.9751631321680768d-2*(t235
     4           +t233+t232+t230+t229+t228+1.923661050931536d+0*t227)*t7
     5           6*t80-9.087592854964233d-4*t107*t138*t80-1.169644724526
     6           9295d+0*t113*t114*t115*t138*t76-6.21814d-2*(t235+t233+t
     7           232+t230+t229+t228)*t58*t74+5.495546528376875d-3*t107*t
     8           135*t74+2.0d+0*t109*t110*t111*t135*t58+t240+t239+t238+t
     9           237+t236+t219+t218+t217+t216+t215+t213+t212+t211+t210+t
     :           208+t203+t202+t201)-4.7846374908957684d-1*t133*t61*t65*
     ;           t82*t85-1.1961593727239421d-1*t129*t60*t61*t82*t85+3.95
     <           03262643361536d-2*t138*t76*t80-1.243628d-1*t135*t58*t74
     =           +t199+t198+t197+t196+t195+t194+t193-rhoa*t188)+1.0d+0*(
     >           5.51111111111111d-52*t192*t50*t54+2.6480888888888887d-1
     ?           06*t191*t241*t48*t54-1.708444444444444d-54*t146*t192*t4
     @           8*t54-8.542222222222222d-104*t146*t191*t54+3.1d-3*t48*t
     1           50*(5.51111111111111d-52*t192*t50*t53+2.648088888888888
     2           7d-106*t191*t241*t48*t53-1.708444444444444d-54*t146*t19
     3           2*t48*t53-8.542222222222222d-104*t146*t191*t53+3.1d-3*t
     4           48*t50*(5.51111111111111d-52*t192*t50*t52+2.64808888888
     5           88887d-106*t191*t241*t48*t52-1.708444444444444d-54*t146
     6           *t192*t48*t52-8.542222222222222d-104*t146*t191*t52+3.1d
     7           -3*t48*t50*(5.51111111111111d-52*t192*t50*t51+2.6480888
     8           888888887d-106*t191*t241*t48*t51-1.708444444444444d-54*
     9           t146*t192*t48*t51-8.542222222222222d-104*t146*t191*t51)
     :           -4.1333333333333333d-52*t100*t147*t50+1.281333333333333
     ;           2d-54*t100*t146*t147*t48)-4.1333333333333333d-52*t100*t
     <           148*t50+1.2813333333333332d-54*t100*t146*t148*t48)-4.13
     =           33333333333333d-52*t100*t149*t50+1.2813333333333332d-54
     >           *t100*t146*t149*t48)*t87+1.0d+0*t104*t26+5.0d-1*rhoa*t1
     ?           2*t188+2.0d+0*t145*t150)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*(2.6480888888888887d-106*t100
     1           *t163*t241*t48*t54-8.542222222222222d-104*t100*t146*t16
     2           3*t54+3.1d-3*t48*t50*(2.6480888888888887d-106*t100*t163
     3           *t241*t48*t53-8.542222222222222d-104*t100*t146*t163*t53
     4           +3.1d-3*t48*t50*(2.6480888888888887d-106*t100*t163*t241
     5           *t48*t52-8.542222222222222d-104*t100*t146*t163*t52+3.1d
     6           -3*t48*t50*(2.6480888888888887d-106*t100*t163*t241*t48*
     7           t51-8.542222222222222d-104*t100*t146*t163*t51)-2.066666
     8           6666666667d-52*t100*t179*t50-2.0666666666666667d-52*t14
     9           7*t163*t50+6.406666666666666d-55*t100*t146*t179*t48+6.4
     :           06666666666666d-55*t146*t147*t163*t48)-2.06666666666666
     ;           67d-52*t100*t180*t50-2.0666666666666667d-52*t148*t163*t
     <           50+6.406666666666666d-55*t100*t146*t180*t48+6.406666666
     =           666666d-55*t146*t148*t163*t48)-2.0666666666666667d-52*t
     >           100*t181*t50-2.0666666666666667d-52*t149*t163*t50+6.406
     ?           666666666666d-55*t100*t146*t181*t48+6.406666666666666d-
     @           55*t146*t149*t163*t48)*t87+1.0d+0*t55*(t56*(7.176956236
     1           343652d-1*t234*t61*t65*t82*t85-5.980796863619711d-2*t24
     2           2*t60*t61*t82*t85-2.3923187454478842d-1*t133*t170*t61*t
     3           82*t85+2.3923187454478842d-1*t129*t133*t61*t82*t85+2.39
     4           23187454478842d-1*t131*t170*t60*t82*t85+2.3923187454478
     5           842d-1*t129*t131*t60*t82*t85+2.541232989148493d-3*t142*
     6           t170*t60*t85+2.541232989148493d-3*t129*t142*t60*t85+1.9
     7           23661050931536d+0*t117*t118*t119*t170*t60*t61*t82+1.923
     8           661050931536d+0*t117*t118*t119*t129*t60*t61*t82+1.97516
     9           31321680768d-2*(t248+t247+t246+t245+t244+t243+1.9236610
     :           50931536d+0*t242+t232)*t76*t80-4.5437964274821163d-4*t1
     ;           07*t175*t80-4.5437964274821163d-4*t107*t138*t80-5.84822
     <           3622634647d-1*t113*t114*t115*t175*t76-5.848223622634647
     =           d-1*t113*t114*t115*t138*t76-6.21814d-2*(t248+t247+t246+
     >           t245+t244+t243+t232)*t58*t74+2.747773264188437d-3*t107*
     ?           t173*t74+2.747773264188437d-3*t107*t135*t74+1.0d+0*t109
     @           *t110*t111*t173*t58+1.0d+0*t109*t110*t111*t135*t58+t239
     1           +t238+t237+t236+t219+t218+t217+t216+t215+t213+t212+t211
     2           +t210+t208+t203+t202+t201)+t199+t198+t197+t196+t195+t19
     3           4+t193+t177+t176+t174+t141+t139+t136)+1.0d+0*t145*t182+
     4           1.0d+0*t150*t178)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*(5.51111111111111d-52*t258*t5
     1           0*t54-1.708444444444444d-54*t146*t258*t48*t54+2.6480888
     2           888888887d-106*t241*t257*t48*t54-8.542222222222222d-104
     3           *t146*t257*t54+3.1d-3*t48*t50*(5.51111111111111d-52*t25
     4           8*t50*t53-1.708444444444444d-54*t146*t258*t48*t53+2.648
     5           0888888888887d-106*t241*t257*t48*t53-8.542222222222222d
     6           -104*t146*t257*t53+3.1d-3*t48*t50*(5.51111111111111d-52
     7           *t258*t50*t52-1.708444444444444d-54*t146*t258*t48*t52+2
     8           .6480888888888887d-106*t241*t257*t48*t52-8.542222222222
     9           222d-104*t146*t257*t52+3.1d-3*t48*t50*(5.51111111111111
     :           d-52*t258*t50*t51-1.708444444444444d-54*t146*t258*t48*t
     ;           51+2.6480888888888887d-106*t241*t257*t48*t51-8.54222222
     <           2222222d-104*t146*t257*t51)-4.1333333333333333d-52*t163
     =           *t179*t50+1.2813333333333332d-54*t146*t163*t179*t48)-4.
     >           1333333333333333d-52*t163*t180*t50+1.2813333333333332d-
     ?           54*t146*t163*t180*t48)-4.1333333333333333d-52*t163*t181
     @           *t50+1.2813333333333332d-54*t146*t163*t181*t48)*t87+1.0
     1           d+0*t55*(t56*(-1.9138549963583074d+0*t131*t133*t65*t82*
     2           t85-5.980796863619711d-2*t259*t60*t61*t82*t85+4.7846374
     3           908957684d-1*t133*t170*t61*t82*t85+4.7846374908957684d-
     4           1*t131*t170*t60*t82*t85-2.0329863913187946d-2*t133*t142
     5           *t65*t85+5.082465978296986d-3*t142*t170*t60*t85-1.53892
     6           8840745229d+1*t117*t118*t119*t133*t61*t65*t82+3.8473221
     7           01863072d+0*t117*t118*t119*t170*t60*t61*t82+1.975163132
     8           1680768d-2*(t263+t262+t261+t260+1.923661050931536d+0*t2
     9           59+t235+t232)*t76*t80-9.087592854964233d-4*t107*t175*t8
     :           0-1.1696447245269295d+0*t113*t114*t115*t175*t76-6.21814
     ;           d-2*(t263+t262+t261+t260+t235+t232)*t58*t74+5.495546528
     <           376875d-3*t107*t173*t74+2.0d+0*t109*t110*t111*t173*t58+
     =           t240+t239+t238+t237+t236+t219+t218+t217+t216+t215+t213+
     >           t212+t211+t210+t208+t203+t202+t201)+4.7846374908957684d
     ?           -1*t133*t61*t65*t82*t85-1.1961593727239421d-1*t170*t60*
     @           t61*t82*t85+3.9503262643361536d-2*t175*t76*t80-1.243628
     1           d-1*t173*t58*t74-2.220446049250313d-16*t151*t155*t156*t
     2           46-6.101282288702853d-19*t153*t45-2.0d+0*t157*t158*t159
     3           *t42-2.642079786267853d-3*t153*t41-rhob*t254+t199+t198+
     4           t197+t196+t195+t194+t193)+5.0d-1*rhob*t47*(2.4d-51*t27*
     5           t29*(2.4d-51*t27*t29*(2.4d-51*t27*t29*(1.06666666666666
     6           66d-50*t258*t29*t8-5.76d-101*t161*t257*t8+7.68d-152*t25
     7           5*t256*t8)+1.0666666666666666d-50*t258*t29*t30-5.76d-10
     8           1*t161*t257*t30+7.68d-152*t255*t256*t30-8.0d-51*t163*t1
     9           64*t29+1.92d-101*t161*t162*t164)+1.0666666666666666d-50
     :           *t258*t29*t31-5.76d-101*t161*t257*t31+7.68d-152*t255*t2
     ;           56*t31-8.0d-51*t163*t165*t29+1.92d-101*t161*t162*t165)+
     <           1.0666666666666666d-50*t258*t29*t32-5.76d-101*t161*t257
     =           *t32+7.68d-152*t255*t256*t32-8.0d-51*t163*t166*t29+1.92
     >           d-101*t161*t162*t166)+1.0d+0*t167*t47+5.0d-1*rhob*t254*
     ?           t33+1.0d+0*t160*t33+2.0d+0*t178*t182+1.0d+0*rhob*t160*t
     @           167)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/t19
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammaaa**2
              t38 = 1/t2**2
              t39 = 1/rhoa**6.333333333333333d+0
              t40 = 1/rhoa**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammaaa*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammaaa*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammaaa*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammaaa*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammaaa*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammaaa*t1*t3*t43
              t45 = 1/rhoa**5.333333333333333d+0
              t46 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t38*t4*t45
              t47 = -3.6d-3*gammaaa*t38*t45*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmaaa*t1*t3*t46
              t48 = -3.6d-3*gammaaa*t38*t45*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmaaa*t1*t3*t47
              t49 = -3.6d-3*gammaaa*t38*t45*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t48
              t50 = 1/taua**2
              t51 = 1/rhoa**2
              t52 = t31**2
              t53 = 1/t10**5
              t54 = 1/rhoa**2.3333333333333334d+0
              t55 = 1/rhoa**2.1666666666666665d+0
              t56 = t34**2
              t57 = gammaaa**3
              t58 = 1/t2**3
              t59 = 1/rhoa**10
              t60 = 1/rhoa**7.333333333333333d+0
              t61 = 1/rhoa**4.666666666666667d+0
              t62 = 1.25d-1*t22*t8*wght
              t63 = 1/rhoa**9
              t64 = 1/rhoa**8
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhoa*t22*t25*t44*wght)+1.25d-1*ga
     2           mmaaa*t22*t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*t49*wght-1.25d-
     1           1*t22*t8*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t50*t8*wght+1.0d+0*r
     1           hoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t23*(5.0d-1*rhoa*t25*(-2.0d+0*t17*t33
     1           *t56/t14**3+3.216395899738507d+1*t17*t56/(t14**4*t15**2
     2           )+1.0d+0*t17*t33*t35*(2.1622951122684114d+0*t55+1.70877
     3           61055320938d+0*t54+1.2335503316757068d+0*t53+2.67319032
     4           3653546d-1*t1)+1.1102230246251565d-16*t21*t26*t32*(1.16
     5           32736958443765d+0*t55+9.89141964955861d-1*t54+6.0032147
     6           62495226d-1*t53+2.1077825841639536d-1*t1)-4.06752152580
     7           19015d-19*t20*t54-1.7613865241785684d-3*t16*t54-2.22044
     8           6049250313d-16*t21*t26*t52/t18**3+1.7854583920998188d-1
     9           5*t21*t52/(t18**4*t19**2)-8.497974591333913d-2*t29*t33*
     :           t34*t35-9.812069668265515d-18*t26*t29*t31*t32)*t8*wght+
     ;           1.25d-1*gammaaa*t22*t51*t8*wght+1.0d+0*t25*t36*t8*wght+
     <           1.25d-1*gammaaa*t24*t36*t8*wght+5.0d-1*rhoa*t22*t25*(5.
     =           866666666666666d-1*gammaaa*t3*t61*t7-8.639999999999998d
     >           -2*t37*t38*t60*t7+3.0719999999999986d-3*t57*t58*t59*t7+
     ?           6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gamm
     @           aaa*t1*t3*(5.866666666666666d-1*gammaaa*t3*t4*t61-8.639
     1           999999999998d-2*t37*t38*t4*t60+3.0719999999999986d-3*t4
     2           *t57*t58*t59)+5.866666666666666d-1*gammaaa*t3*t5*t61-8.
     3           639999999999998d-2*t37*t38*t5*t60+3.0719999999999986d-3
     4           *t5*t57*t58*t59-3.1999999999999995d-1*gammaaa*t3*t40*t4
     5           1+1.9199999999999995d-2*t37*t38*t39*t41)+5.866666666666
     6           666d-1*gammaaa*t3*t6*t61-8.639999999999998d-2*t37*t38*t
     7           6*t60+3.0719999999999986d-3*t57*t58*t59*t6-3.1999999999
     8           999995d-1*gammaaa*t3*t40*t42+1.9199999999999995d-2*t37*
     9           t38*t39*t42)-3.1999999999999995d-1*gammaaa*t3*t40*t43+1
     :           .9199999999999995d-2*t37*t38*t39*t43)*wght+1.0d+0*rhoa*
     ;           t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+1.25d-1*gammaa
     <           a*t22*t24*t44*wght)+t23*t24*(1.25d-1*gammaaa*t36*t8*wgh
     =           t+1.25d-1*gammaaa*t22*t44*wght)-1.25d-1*gammaaa*t22*t23
     >           *t51*t8*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t23*(-1.25d-1*t36*t8*wght-1.25d-1*t2
     1           2*t24*t8*wght+5.0d-1*rhoa*t22*t25*(-1.1519999999999996d
     2           -3*t37*t58*t63*t7-1.5999999999999998d-1*t3*t40*t7+2.879
     3           999999999999d-2*gammaaa*t38*t39*t7+6.0d-2*gammaaa*t1*t3
     4           *(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(-1.151999
     5           9999999996d-3*t37*t4*t58*t63-1.5999999999999998d-1*t3*t
     6           4*t40+2.879999999999999d-2*gammaaa*t38*t39*t4)-1.151999
     7           9999999996d-3*t37*t5*t58*t63-1.5999999999999998d-1*t3*t
     8           40*t5+2.879999999999999d-2*gammaaa*t38*t39*t5-1.5999999
     9           999999998d-1*gammaaa*t3*t40*t46+9.599999999999997d-3*t3
     :           7*t38*t39*t46-3.6d-3*gammaaa*t38*t41*t45+6.0d-2*t1*t3*t
     ;           41)-1.1519999999999996d-3*t37*t58*t6*t63-1.599999999999
     <           9998d-1*t3*t40*t6+2.879999999999999d-2*gammaaa*t38*t39*
     =           t6-1.5999999999999998d-1*gammaaa*t3*t40*t47+9.599999999
     >           999997d-3*t37*t38*t39*t47-3.6d-3*gammaaa*t38*t42*t45+6.
     ?           0d-2*t1*t3*t42)-1.5999999999999998d-1*gammaaa*t3*t40*t4
     @           8+9.599999999999997d-3*t37*t38*t39*t48-3.6d-3*gammaaa*t
     1           38*t43*t45+6.0d-2*t1*t3*t43)*wght+5.0d-1*rhoa*t25*t36*t
     2           49*wght+5.0d-1*t22*t25*t49*wght-1.25d-1*t22*t44*wght)+t
     3           23*t24*(1.25d-1*gammaaa*t22*t49*wght+t62)+Cmat2(iq,D2_R
     4           A_GAA)
              Cmat2(iq,D2_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(4.32d-4*g
     1           ammaaa*t58*t64*t7-7.2d-3*t38*t45*t7+6.0d-2*gammaaa*t1*t
     2           3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(4.32d-4*
     3           gammaaa*t4*t58*t64-7.2d-3*t38*t4*t45)+4.32d-4*gammaaa*t
     4           5*t58*t64-7.2d-3*t38*t45*t5-7.2d-3*gammaaa*t38*t45*t46+
     5           1.2d-1*t1*t3*t46)+4.32d-4*gammaaa*t58*t6*t64-7.2d-3*t38
     6           *t45*t6-7.2d-3*gammaaa*t38*t45*t47+1.2d-1*t1*t3*t47)-7.
     7           2d-3*gammaaa*t38*t45*t48+1.2d-1*t1*t3*t48)*wght-2.5d-1*
     8           t22*t49*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t50*(-5.0d-1*rhoa*t25*t36*t8*wght-5.0
     1           d-1*t22*t25*t8*wght-5.0d-1*rhoa*t22*t25*t44*wght)+t23*(
     2           1.0d+0*rhoa*t36*t8*wght+1.0d+0*t22*t8*wght+1.0d+0*rhoa*
     3           t22*t44*wght)-1.25d-1*gammaaa*t22*t24*t50*t8*wght+Mmat2
     4           (iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t50*(t62-5.0d-1*rhoa*t22*t25*t49*wgh
     1           t)+1.0d+0*rhoa*t22*t23*t49*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t22*t25*t8*wght/taua**3-2
     1           .0d+0*rhoa*t22*t50*t8*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/t19
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammaaa**2
              t38 = 1/t2**2
              t39 = 1/rhoa**6.333333333333333d+0
              t40 = 1/rhoa**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammaaa*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammaaa*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammaaa*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammaaa*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammaaa*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammaaa*t1*t3*t43
              t45 = 1/rhoa**5.333333333333333d+0
              t46 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t38*t4*t45
              t47 = -3.6d-3*gammaaa*t38*t45*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmaaa*t1*t3*t46
              t48 = -3.6d-3*gammaaa*t38*t45*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmaaa*t1*t3*t47
              t49 = -3.6d-3*gammaaa*t38*t45*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t48
              t50 = 1/taua**2
              t51 = 1/rhoa**2
              t52 = t31**2
              t53 = 1/t10**5
              t54 = 1/rhoa**2.3333333333333334d+0
              t55 = 1/rhoa**2.1666666666666665d+0
              t56 = t34**2
              t57 = gammaaa**3
              t58 = 1/t2**3
              t59 = 1/rhoa**10
              t60 = 1/rhoa**7.333333333333333d+0
              t61 = 1/rhoa**4.666666666666667d+0
              t62 = 1.25d-1*t22*t8*wght
              t63 = 1/rhoa**9
              t64 = 1/rhoa**8
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhoa*t22*t25*t44*wght)+1.25d-1*ga
     2           mmaaa*t22*t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*t49*wght-1.25d-
     1           1*t22*t8*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t50*t8*wght+1.0d+0*r
     1           hoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t23*(5.0d-1*rhoa*t25*(-2.0d+0*t17*t33
     1           *t56/t14**3+3.216395899738507d+1*t17*t56/(t14**4*t15**2
     2           )+1.0d+0*t17*t33*t35*(2.1622951122684114d+0*t55+1.70877
     3           61055320938d+0*t54+1.2335503316757068d+0*t53+2.67319032
     4           3653546d-1*t1)+1.1102230246251565d-16*t21*t26*t32*(1.16
     5           32736958443765d+0*t55+9.89141964955861d-1*t54+6.0032147
     6           62495226d-1*t53+2.1077825841639536d-1*t1)-4.06752152580
     7           19015d-19*t20*t54-1.7613865241785684d-3*t16*t54-2.22044
     8           6049250313d-16*t21*t26*t52/t18**3+1.7854583920998188d-1
     9           5*t21*t52/(t18**4*t19**2)-8.497974591333913d-2*t29*t33*
     :           t34*t35-9.812069668265515d-18*t26*t29*t31*t32)*t8*wght+
     ;           1.25d-1*gammaaa*t22*t51*t8*wght+1.0d+0*t25*t36*t8*wght+
     <           1.25d-1*gammaaa*t24*t36*t8*wght+5.0d-1*rhoa*t22*t25*(5.
     =           866666666666666d-1*gammaaa*t3*t61*t7-8.639999999999998d
     >           -2*t37*t38*t60*t7+3.0719999999999986d-3*t57*t58*t59*t7+
     ?           6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gamm
     @           aaa*t1*t3*(5.866666666666666d-1*gammaaa*t3*t4*t61-8.639
     1           999999999998d-2*t37*t38*t4*t60+3.0719999999999986d-3*t4
     2           *t57*t58*t59)+5.866666666666666d-1*gammaaa*t3*t5*t61-8.
     3           639999999999998d-2*t37*t38*t5*t60+3.0719999999999986d-3
     4           *t5*t57*t58*t59-3.1999999999999995d-1*gammaaa*t3*t40*t4
     5           1+1.9199999999999995d-2*t37*t38*t39*t41)+5.866666666666
     6           666d-1*gammaaa*t3*t6*t61-8.639999999999998d-2*t37*t38*t
     7           6*t60+3.0719999999999986d-3*t57*t58*t59*t6-3.1999999999
     8           999995d-1*gammaaa*t3*t40*t42+1.9199999999999995d-2*t37*
     9           t38*t39*t42)-3.1999999999999995d-1*gammaaa*t3*t40*t43+1
     :           .9199999999999995d-2*t37*t38*t39*t43)*wght+1.0d+0*rhoa*
     ;           t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+1.25d-1*gammaa
     <           a*t22*t24*t44*wght)+t23*t24*(1.25d-1*gammaaa*t36*t8*wgh
     =           t+1.25d-1*gammaaa*t22*t44*wght)-1.25d-1*gammaaa*t22*t23
     >           *t51*t8*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t23*(-1.25d-1*t36*t8*wght-1.25d-1*t2
     1           2*t24*t8*wght+5.0d-1*rhoa*t22*t25*(-1.1519999999999996d
     2           -3*t37*t58*t63*t7-1.5999999999999998d-1*t3*t40*t7+2.879
     3           999999999999d-2*gammaaa*t38*t39*t7+6.0d-2*gammaaa*t1*t3
     4           *(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(-1.151999
     5           9999999996d-3*t37*t4*t58*t63-1.5999999999999998d-1*t3*t
     6           4*t40+2.879999999999999d-2*gammaaa*t38*t39*t4)-1.151999
     7           9999999996d-3*t37*t5*t58*t63-1.5999999999999998d-1*t3*t
     8           40*t5+2.879999999999999d-2*gammaaa*t38*t39*t5-1.5999999
     9           999999998d-1*gammaaa*t3*t40*t46+9.599999999999997d-3*t3
     :           7*t38*t39*t46-3.6d-3*gammaaa*t38*t41*t45+6.0d-2*t1*t3*t
     ;           41)-1.1519999999999996d-3*t37*t58*t6*t63-1.599999999999
     <           9998d-1*t3*t40*t6+2.879999999999999d-2*gammaaa*t38*t39*
     =           t6-1.5999999999999998d-1*gammaaa*t3*t40*t47+9.599999999
     >           999997d-3*t37*t38*t39*t47-3.6d-3*gammaaa*t38*t42*t45+6.
     ?           0d-2*t1*t3*t42)-1.5999999999999998d-1*gammaaa*t3*t40*t4
     @           8+9.599999999999997d-3*t37*t38*t39*t48-3.6d-3*gammaaa*t
     1           38*t43*t45+6.0d-2*t1*t3*t43)*wght+5.0d-1*rhoa*t25*t36*t
     2           49*wght+5.0d-1*t22*t25*t49*wght-1.25d-1*t22*t44*wght)+t
     3           23*t24*(1.25d-1*gammaaa*t22*t49*wght+t62)+Cmat2(iq,D2_R
     4           A_GAA)
              Cmat2(iq,D2_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(4.32d-4*g
     1           ammaaa*t58*t64*t7-7.2d-3*t38*t45*t7+6.0d-2*gammaaa*t1*t
     2           3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(4.32d-4*
     3           gammaaa*t4*t58*t64-7.2d-3*t38*t4*t45)+4.32d-4*gammaaa*t
     4           5*t58*t64-7.2d-3*t38*t45*t5-7.2d-3*gammaaa*t38*t45*t46+
     5           1.2d-1*t1*t3*t46)+4.32d-4*gammaaa*t58*t6*t64-7.2d-3*t38
     6           *t45*t6-7.2d-3*gammaaa*t38*t45*t47+1.2d-1*t1*t3*t47)-7.
     7           2d-3*gammaaa*t38*t45*t48+1.2d-1*t1*t3*t48)*wght-2.5d-1*
     8           t22*t49*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t50*(-5.0d-1*rhoa*t25*t36*t8*wght-5.0
     1           d-1*t22*t25*t8*wght-5.0d-1*rhoa*t22*t25*t44*wght)+t23*(
     2           1.0d+0*rhoa*t36*t8*wght+1.0d+0*t22*t8*wght+1.0d+0*rhoa*
     3           t22*t44*wght)-1.25d-1*gammaaa*t22*t24*t50*t8*wght+Mmat2
     4           (iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t50*(t62-5.0d-1*rhoa*t22*t25*t49*wgh
     1           t)+1.0d+0*rhoa*t22*t23*t49*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t22*t25*t8*wght/taua**3-2
     1           .0d+0*rhoa*t22*t50*t8*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = t27**2
              t41 = 1/t10**5
              t42 = 1/rhoa**2.3333333333333334d+0
              t43 = 1/rhoa**2.1666666666666665d+0
              t44 = t30**2
              t45 = 1/t2**3
              t46 = 1/rhoa**7
              t47 = 1/rhoa**5.333333333333333d+0
              t48 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhoa*t22*t39*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*(-2.0d+0*t17*t29*t44/t14*
     1           *3+3.216395899738507d+1*t17*t44/(t14**4*t15**2)+1.0d+0*
     2           t17*t29*t31*(2.1622951122684114d+0*t43+1.70877610553209
     3           38d+0*t42+1.2335503316757068d+0*t41+2.673190323653546d-
     4           1*t35)+1.1102230246251565d-16*t21*t23*t28*(1.1632736958
     5           443765d+0*t43+9.89141964955861d-1*t42+6.003214762495226
     6           d-1*t41+2.1077825841639536d-1*t35)-4.0675215258019015d-
     7           19*t20*t42-1.7613865241785684d-3*t16*t42-2.220446049250
     8           313d-16*t21*t23*t40/t18**3+1.7854583920998188d-15*t21*t
     9           40/(t18**4*t19**2)-8.497974591333913d-2*t25*t29*t30*t31
     :           -9.812069668265515d-18*t23*t25*t27*t28)*t8*wght+1.0d+0*
     ;           t32*t8*wght+5.0d-1*rhoa*t22*(1.0666666666666666d-50*t3*
     <           t48*t7-5.76d-101*t33*t47*t7+7.68d-152*t45*t46*t7+2.4d-5
     =           1*t1*t3*(1.0666666666666666d-50*t3*t48*t6-5.76d-101*t33
     >           *t47*t6+7.68d-152*t45*t46*t6+2.4d-51*t1*t3*(1.066666666
     ?           6666666d-50*t3*t48*t5-5.76d-101*t33*t47*t5+7.68d-152*t4
     @           5*t46*t5+2.4d-51*t1*t3*(1.0666666666666666d-50*t3*t4*t4
     1           8-5.76d-101*t33*t4*t47+7.68d-152*t4*t45*t46)-8.0d-51*t3
     2           *t35*t36+1.92d-101*t33*t34*t36)-8.0d-51*t3*t35*t37+1.92
     3           d-101*t33*t34*t37)-8.0d-51*t3*t35*t38+1.92d-101*t33*t34
     4           *t38)*wght+1.0d+0*rhoa*t32*t39*wght+1.0d+0*t22*t39*wght
     5           +Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = t27**2
              t41 = 1/t10**5
              t42 = 1/rhoa**2.3333333333333334d+0
              t43 = 1/rhoa**2.1666666666666665d+0
              t44 = t30**2
              t45 = 1/t2**3
              t46 = 1/rhoa**7
              t47 = 1/rhoa**5.333333333333333d+0
              t48 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhoa*t22*t39*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*(-2.0d+0*t17*t29*t44/t14*
     1           *3+3.216395899738507d+1*t17*t44/(t14**4*t15**2)+1.0d+0*
     2           t17*t29*t31*(2.1622951122684114d+0*t43+1.70877610553209
     3           38d+0*t42+1.2335503316757068d+0*t41+2.673190323653546d-
     4           1*t35)+1.1102230246251565d-16*t21*t23*t28*(1.1632736958
     5           443765d+0*t43+9.89141964955861d-1*t42+6.003214762495226
     6           d-1*t41+2.1077825841639536d-1*t35)-4.0675215258019015d-
     7           19*t20*t42-1.7613865241785684d-3*t16*t42-2.220446049250
     8           313d-16*t21*t23*t40/t18**3+1.7854583920998188d-15*t21*t
     9           40/(t18**4*t19**2)-8.497974591333913d-2*t25*t29*t30*t31
     :           -9.812069668265515d-18*t23*t25*t27*t28)*t8*wght+1.0d+0*
     ;           t32*t8*wght+5.0d-1*rhoa*t22*(1.0666666666666666d-50*t3*
     <           t48*t7-5.76d-101*t33*t47*t7+7.68d-152*t45*t46*t7+2.4d-5
     =           1*t1*t3*(1.0666666666666666d-50*t3*t48*t6-5.76d-101*t33
     >           *t47*t6+7.68d-152*t45*t46*t6+2.4d-51*t1*t3*(1.066666666
     ?           6666666d-50*t3*t48*t5-5.76d-101*t33*t47*t5+7.68d-152*t4
     @           5*t46*t5+2.4d-51*t1*t3*(1.0666666666666666d-50*t3*t4*t4
     1           8-5.76d-101*t33*t4*t47+7.68d-152*t4*t45*t46)-8.0d-51*t3
     2           *t35*t36+1.92d-101*t33*t34*t36)-8.0d-51*t3*t35*t37+1.92
     3           d-101*t33*t34*t37)-8.0d-51*t3*t35*t38+1.92d-101*t33*t34
     4           *t38)*wght+1.0d+0*rhoa*t32*t39*wght+1.0d+0*t22*t39*wght
     5           +Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/t19
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammabb**2
              t38 = 1/t2**2
              t39 = 1/rhob**6.333333333333333d+0
              t40 = 1/rhob**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammabb*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammabb*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammabb*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammabb*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammabb*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammabb*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammabb*t1*t3*t43
              t45 = 1/rhob**5.333333333333333d+0
              t46 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t38*t4*t45
              t47 = -3.6d-3*gammabb*t38*t45*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmabb*t1*t3*t46
              t48 = -3.6d-3*gammabb*t38*t45*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmabb*t1*t3*t47
              t49 = -3.6d-3*gammabb*t38*t45*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t48
              t50 = 1/taub**2
              t51 = 1/rhob**2
              t52 = t31**2
              t53 = 1/t10**5
              t54 = 1/rhob**2.3333333333333334d+0
              t55 = 1/rhob**2.1666666666666665d+0
              t56 = t34**2
              t57 = gammabb**3
              t58 = 1/t2**3
              t59 = 1/rhob**10
              t60 = 1/rhob**7.333333333333333d+0
              t61 = 1/rhob**4.666666666666667d+0
              t62 = 1.25d-1*t22*t8*wght
              t63 = 1/rhob**9
              t64 = 1/rhob**8
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhob*t22*t25*t44*wght)+1.25d-1*ga
     2           mmabb*t22*t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*t49*wght-1.25d-
     1           1*t22*t8*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t50*t8*wght+1.0d+0*r
     1           hob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t23*(5.0d-1*rhob*t25*(-2.0d+0*t17*t33
     1           *t56/t14**3+3.216395899738507d+1*t17*t56/(t14**4*t15**2
     2           )+1.0d+0*t17*t33*t35*(2.1622951122684114d+0*t55+1.70877
     3           61055320938d+0*t54+1.2335503316757068d+0*t53+2.67319032
     4           3653546d-1*t1)+1.1102230246251565d-16*t21*t26*t32*(1.16
     5           32736958443765d+0*t55+9.89141964955861d-1*t54+6.0032147
     6           62495226d-1*t53+2.1077825841639536d-1*t1)-4.06752152580
     7           19015d-19*t20*t54-1.7613865241785684d-3*t16*t54-2.22044
     8           6049250313d-16*t21*t26*t52/t18**3+1.7854583920998188d-1
     9           5*t21*t52/(t18**4*t19**2)-8.497974591333913d-2*t29*t33*
     :           t34*t35-9.812069668265515d-18*t26*t29*t31*t32)*t8*wght+
     ;           1.25d-1*gammabb*t22*t51*t8*wght+1.0d+0*t25*t36*t8*wght+
     <           1.25d-1*gammabb*t24*t36*t8*wght+5.0d-1*rhob*t22*t25*(5.
     =           866666666666666d-1*gammabb*t3*t61*t7-8.639999999999998d
     >           -2*t37*t38*t60*t7+3.0719999999999986d-3*t57*t58*t59*t7+
     ?           6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gamm
     @           abb*t1*t3*(5.866666666666666d-1*gammabb*t3*t4*t61-8.639
     1           999999999998d-2*t37*t38*t4*t60+3.0719999999999986d-3*t4
     2           *t57*t58*t59)+5.866666666666666d-1*gammabb*t3*t5*t61-8.
     3           639999999999998d-2*t37*t38*t5*t60+3.0719999999999986d-3
     4           *t5*t57*t58*t59-3.1999999999999995d-1*gammabb*t3*t40*t4
     5           1+1.9199999999999995d-2*t37*t38*t39*t41)+5.866666666666
     6           666d-1*gammabb*t3*t6*t61-8.639999999999998d-2*t37*t38*t
     7           6*t60+3.0719999999999986d-3*t57*t58*t59*t6-3.1999999999
     8           999995d-1*gammabb*t3*t40*t42+1.9199999999999995d-2*t37*
     9           t38*t39*t42)-3.1999999999999995d-1*gammabb*t3*t40*t43+1
     :           .9199999999999995d-2*t37*t38*t39*t43)*wght+1.0d+0*rhob*
     ;           t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+1.25d-1*gammab
     <           b*t22*t24*t44*wght)+t23*t24*(1.25d-1*gammabb*t36*t8*wgh
     =           t+1.25d-1*gammabb*t22*t44*wght)-1.25d-1*gammabb*t22*t23
     >           *t51*t8*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t23*(-1.25d-1*t36*t8*wght-1.25d-1*t2
     1           2*t24*t8*wght+5.0d-1*rhob*t22*t25*(-1.1519999999999996d
     2           -3*t37*t58*t63*t7-1.5999999999999998d-1*t3*t40*t7+2.879
     3           999999999999d-2*gammabb*t38*t39*t7+6.0d-2*gammabb*t1*t3
     4           *(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(-1.151999
     5           9999999996d-3*t37*t4*t58*t63-1.5999999999999998d-1*t3*t
     6           4*t40+2.879999999999999d-2*gammabb*t38*t39*t4)-1.151999
     7           9999999996d-3*t37*t5*t58*t63-1.5999999999999998d-1*t3*t
     8           40*t5+2.879999999999999d-2*gammabb*t38*t39*t5-1.5999999
     9           999999998d-1*gammabb*t3*t40*t46+9.599999999999997d-3*t3
     :           7*t38*t39*t46-3.6d-3*gammabb*t38*t41*t45+6.0d-2*t1*t3*t
     ;           41)-1.1519999999999996d-3*t37*t58*t6*t63-1.599999999999
     <           9998d-1*t3*t40*t6+2.879999999999999d-2*gammabb*t38*t39*
     =           t6-1.5999999999999998d-1*gammabb*t3*t40*t47+9.599999999
     >           999997d-3*t37*t38*t39*t47-3.6d-3*gammabb*t38*t42*t45+6.
     ?           0d-2*t1*t3*t42)-1.5999999999999998d-1*gammabb*t3*t40*t4
     @           8+9.599999999999997d-3*t37*t38*t39*t48-3.6d-3*gammabb*t
     1           38*t43*t45+6.0d-2*t1*t3*t43)*wght+5.0d-1*rhob*t25*t36*t
     2           49*wght+5.0d-1*t22*t25*t49*wght-1.25d-1*t22*t44*wght)+t
     3           23*t24*(1.25d-1*gammabb*t22*t49*wght+t62)+Cmat2(iq,D2_R
     4           B_GBB)
              Cmat2(iq,D2_GBB_GBB) = t23*(5.0d-1*rhob*t22*t25*(4.32d-4*g
     1           ammabb*t58*t64*t7-7.2d-3*t38*t45*t7+6.0d-2*gammabb*t1*t
     2           3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(4.32d-4*
     3           gammabb*t4*t58*t64-7.2d-3*t38*t4*t45)+4.32d-4*gammabb*t
     4           5*t58*t64-7.2d-3*t38*t45*t5-7.2d-3*gammabb*t38*t45*t46+
     5           1.2d-1*t1*t3*t46)+4.32d-4*gammabb*t58*t6*t64-7.2d-3*t38
     6           *t45*t6-7.2d-3*gammabb*t38*t45*t47+1.2d-1*t1*t3*t47)-7.
     7           2d-3*gammabb*t38*t45*t48+1.2d-1*t1*t3*t48)*wght-2.5d-1*
     8           t22*t49*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t50*(-5.0d-1*rhob*t25*t36*t8*wght-5.0
     1           d-1*t22*t25*t8*wght-5.0d-1*rhob*t22*t25*t44*wght)+t23*(
     2           1.0d+0*rhob*t36*t8*wght+1.0d+0*t22*t8*wght+1.0d+0*rhob*
     3           t22*t44*wght)-1.25d-1*gammabb*t22*t24*t50*t8*wght+Mmat2
     4           (iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = t50*(t62-5.0d-1*rhob*t22*t25*t49*wgh
     1           t)+1.0d+0*rhob*t22*t23*t49*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t22*t25*t8*wght/taub**3-2
     1           .0d+0*rhob*t22*t50*t8*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhob**1.3333333333333333d+0
              t26 = 1/rhob**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhob**4.333333333333333d+0
              t35 = 1/rhob**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = t27**2
              t41 = 1/t10**5
              t42 = 1/rhob**2.3333333333333334d+0
              t43 = 1/rhob**2.1666666666666665d+0
              t44 = t30**2
              t45 = 1/t2**3
              t46 = 1/rhob**7
              t47 = 1/rhob**5.333333333333333d+0
              t48 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhob*t22*t39*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*(-2.0d+0*t17*t29*t44/t14*
     1           *3+3.216395899738507d+1*t17*t44/(t14**4*t15**2)+1.0d+0*
     2           t17*t29*t31*(2.1622951122684114d+0*t43+1.70877610553209
     3           38d+0*t42+1.2335503316757068d+0*t41+2.673190323653546d-
     4           1*t35)+1.1102230246251565d-16*t21*t23*t28*(1.1632736958
     5           443765d+0*t43+9.89141964955861d-1*t42+6.003214762495226
     6           d-1*t41+2.1077825841639536d-1*t35)-4.0675215258019015d-
     7           19*t20*t42-1.7613865241785684d-3*t16*t42-2.220446049250
     8           313d-16*t21*t23*t40/t18**3+1.7854583920998188d-15*t21*t
     9           40/(t18**4*t19**2)-8.497974591333913d-2*t25*t29*t30*t31
     :           -9.812069668265515d-18*t23*t25*t27*t28)*t8*wght+1.0d+0*
     ;           t32*t8*wght+5.0d-1*rhob*t22*(1.0666666666666666d-50*t3*
     <           t48*t7-5.76d-101*t33*t47*t7+7.68d-152*t45*t46*t7+2.4d-5
     =           1*t1*t3*(1.0666666666666666d-50*t3*t48*t6-5.76d-101*t33
     >           *t47*t6+7.68d-152*t45*t46*t6+2.4d-51*t1*t3*(1.066666666
     ?           6666666d-50*t3*t48*t5-5.76d-101*t33*t47*t5+7.68d-152*t4
     @           5*t46*t5+2.4d-51*t1*t3*(1.0666666666666666d-50*t3*t4*t4
     1           8-5.76d-101*t33*t4*t47+7.68d-152*t4*t45*t46)-8.0d-51*t3
     2           *t35*t36+1.92d-101*t33*t34*t36)-8.0d-51*t3*t35*t37+1.92
     3           d-101*t33*t34*t37)-8.0d-51*t3*t35*t38+1.92d-101*t33*t34
     4           *t38)*wght+1.0d+0*rhob*t32*t39*wght+1.0d+0*t22*t39*wght
     5           +Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/t19
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammabb**2
              t38 = 1/t2**2
              t39 = 1/rhob**6.333333333333333d+0
              t40 = 1/rhob**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammabb*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammabb*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammabb*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammabb*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammabb*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammabb*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammabb*t1*t3*t43
              t45 = 1/rhob**5.333333333333333d+0
              t46 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t38*t4*t45
              t47 = -3.6d-3*gammabb*t38*t45*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmabb*t1*t3*t46
              t48 = -3.6d-3*gammabb*t38*t45*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmabb*t1*t3*t47
              t49 = -3.6d-3*gammabb*t38*t45*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t48
              t50 = 1/taub**2
              t51 = 1/rhob**2
              t52 = t31**2
              t53 = 1/t10**5
              t54 = 1/rhob**2.3333333333333334d+0
              t55 = 1/rhob**2.1666666666666665d+0
              t56 = t34**2
              t57 = gammabb**3
              t58 = 1/t2**3
              t59 = 1/rhob**10
              t60 = 1/rhob**7.333333333333333d+0
              t61 = 1/rhob**4.666666666666667d+0
              t62 = 1.25d-1*t22*t8*wght
              t63 = 1/rhob**9
              t64 = 1/rhob**8
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhob*t22*t25*t44*wght)+1.25d-1*ga
     2           mmabb*t22*t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*t49*wght-1.25d-
     1           1*t22*t8*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t50*t8*wght+1.0d+0*r
     1           hob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t23*(5.0d-1*rhob*t25*(-2.0d+0*t17*t33
     1           *t56/t14**3+3.216395899738507d+1*t17*t56/(t14**4*t15**2
     2           )+1.0d+0*t17*t33*t35*(2.1622951122684114d+0*t55+1.70877
     3           61055320938d+0*t54+1.2335503316757068d+0*t53+2.67319032
     4           3653546d-1*t1)+1.1102230246251565d-16*t21*t26*t32*(1.16
     5           32736958443765d+0*t55+9.89141964955861d-1*t54+6.0032147
     6           62495226d-1*t53+2.1077825841639536d-1*t1)-4.06752152580
     7           19015d-19*t20*t54-1.7613865241785684d-3*t16*t54-2.22044
     8           6049250313d-16*t21*t26*t52/t18**3+1.7854583920998188d-1
     9           5*t21*t52/(t18**4*t19**2)-8.497974591333913d-2*t29*t33*
     :           t34*t35-9.812069668265515d-18*t26*t29*t31*t32)*t8*wght+
     ;           1.25d-1*gammabb*t22*t51*t8*wght+1.0d+0*t25*t36*t8*wght+
     <           1.25d-1*gammabb*t24*t36*t8*wght+5.0d-1*rhob*t22*t25*(5.
     =           866666666666666d-1*gammabb*t3*t61*t7-8.639999999999998d
     >           -2*t37*t38*t60*t7+3.0719999999999986d-3*t57*t58*t59*t7+
     ?           6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gamm
     @           abb*t1*t3*(5.866666666666666d-1*gammabb*t3*t4*t61-8.639
     1           999999999998d-2*t37*t38*t4*t60+3.0719999999999986d-3*t4
     2           *t57*t58*t59)+5.866666666666666d-1*gammabb*t3*t5*t61-8.
     3           639999999999998d-2*t37*t38*t5*t60+3.0719999999999986d-3
     4           *t5*t57*t58*t59-3.1999999999999995d-1*gammabb*t3*t40*t4
     5           1+1.9199999999999995d-2*t37*t38*t39*t41)+5.866666666666
     6           666d-1*gammabb*t3*t6*t61-8.639999999999998d-2*t37*t38*t
     7           6*t60+3.0719999999999986d-3*t57*t58*t59*t6-3.1999999999
     8           999995d-1*gammabb*t3*t40*t42+1.9199999999999995d-2*t37*
     9           t38*t39*t42)-3.1999999999999995d-1*gammabb*t3*t40*t43+1
     :           .9199999999999995d-2*t37*t38*t39*t43)*wght+1.0d+0*rhob*
     ;           t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+1.25d-1*gammab
     <           b*t22*t24*t44*wght)+t23*t24*(1.25d-1*gammabb*t36*t8*wgh
     =           t+1.25d-1*gammabb*t22*t44*wght)-1.25d-1*gammabb*t22*t23
     >           *t51*t8*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t23*(-1.25d-1*t36*t8*wght-1.25d-1*t2
     1           2*t24*t8*wght+5.0d-1*rhob*t22*t25*(-1.1519999999999996d
     2           -3*t37*t58*t63*t7-1.5999999999999998d-1*t3*t40*t7+2.879
     3           999999999999d-2*gammabb*t38*t39*t7+6.0d-2*gammabb*t1*t3
     4           *(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(-1.151999
     5           9999999996d-3*t37*t4*t58*t63-1.5999999999999998d-1*t3*t
     6           4*t40+2.879999999999999d-2*gammabb*t38*t39*t4)-1.151999
     7           9999999996d-3*t37*t5*t58*t63-1.5999999999999998d-1*t3*t
     8           40*t5+2.879999999999999d-2*gammabb*t38*t39*t5-1.5999999
     9           999999998d-1*gammabb*t3*t40*t46+9.599999999999997d-3*t3
     :           7*t38*t39*t46-3.6d-3*gammabb*t38*t41*t45+6.0d-2*t1*t3*t
     ;           41)-1.1519999999999996d-3*t37*t58*t6*t63-1.599999999999
     <           9998d-1*t3*t40*t6+2.879999999999999d-2*gammabb*t38*t39*
     =           t6-1.5999999999999998d-1*gammabb*t3*t40*t47+9.599999999
     >           999997d-3*t37*t38*t39*t47-3.6d-3*gammabb*t38*t42*t45+6.
     ?           0d-2*t1*t3*t42)-1.5999999999999998d-1*gammabb*t3*t40*t4
     @           8+9.599999999999997d-3*t37*t38*t39*t48-3.6d-3*gammabb*t
     1           38*t43*t45+6.0d-2*t1*t3*t43)*wght+5.0d-1*rhob*t25*t36*t
     2           49*wght+5.0d-1*t22*t25*t49*wght-1.25d-1*t22*t44*wght)+t
     3           23*t24*(1.25d-1*gammabb*t22*t49*wght+t62)+Cmat2(iq,D2_R
     4           B_GBB)
              Cmat2(iq,D2_GBB_GBB) = t23*(5.0d-1*rhob*t22*t25*(4.32d-4*g
     1           ammabb*t58*t64*t7-7.2d-3*t38*t45*t7+6.0d-2*gammabb*t1*t
     2           3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(4.32d-4*
     3           gammabb*t4*t58*t64-7.2d-3*t38*t4*t45)+4.32d-4*gammabb*t
     4           5*t58*t64-7.2d-3*t38*t45*t5-7.2d-3*gammabb*t38*t45*t46+
     5           1.2d-1*t1*t3*t46)+4.32d-4*gammabb*t58*t6*t64-7.2d-3*t38
     6           *t45*t6-7.2d-3*gammabb*t38*t45*t47+1.2d-1*t1*t3*t47)-7.
     7           2d-3*gammabb*t38*t45*t48+1.2d-1*t1*t3*t48)*wght-2.5d-1*
     8           t22*t49*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t50*(-5.0d-1*rhob*t25*t36*t8*wght-5.0
     1           d-1*t22*t25*t8*wght-5.0d-1*rhob*t22*t25*t44*wght)+t23*(
     2           1.0d+0*rhob*t36*t8*wght+1.0d+0*t22*t8*wght+1.0d+0*rhob*
     3           t22*t44*wght)-1.25d-1*gammabb*t22*t24*t50*t8*wght+Mmat2
     4           (iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = t50*(t62-5.0d-1*rhob*t22*t25*t49*wgh
     1           t)+1.0d+0*rhob*t22*t23*t49*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t22*t25*t8*wght/taub**3-2
     1           .0d+0*rhob*t22*t50*t8*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhob**1.3333333333333333d+0
              t26 = 1/rhob**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhob**4.333333333333333d+0
              t35 = 1/rhob**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = t27**2
              t41 = 1/t10**5
              t42 = 1/rhob**2.3333333333333334d+0
              t43 = 1/rhob**2.1666666666666665d+0
              t44 = t30**2
              t45 = 1/t2**3
              t46 = 1/rhob**7
              t47 = 1/rhob**5.333333333333333d+0
              t48 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhob*t22*t39*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*(-2.0d+0*t17*t29*t44/t14*
     1           *3+3.216395899738507d+1*t17*t44/(t14**4*t15**2)+1.0d+0*
     2           t17*t29*t31*(2.1622951122684114d+0*t43+1.70877610553209
     3           38d+0*t42+1.2335503316757068d+0*t41+2.673190323653546d-
     4           1*t35)+1.1102230246251565d-16*t21*t23*t28*(1.1632736958
     5           443765d+0*t43+9.89141964955861d-1*t42+6.003214762495226
     6           d-1*t41+2.1077825841639536d-1*t35)-4.0675215258019015d-
     7           19*t20*t42-1.7613865241785684d-3*t16*t42-2.220446049250
     8           313d-16*t21*t23*t40/t18**3+1.7854583920998188d-15*t21*t
     9           40/(t18**4*t19**2)-8.497974591333913d-2*t25*t29*t30*t31
     :           -9.812069668265515d-18*t23*t25*t27*t28)*t8*wght+1.0d+0*
     ;           t32*t8*wght+5.0d-1*rhob*t22*(1.0666666666666666d-50*t3*
     <           t48*t7-5.76d-101*t33*t47*t7+7.68d-152*t45*t46*t7+2.4d-5
     =           1*t1*t3*(1.0666666666666666d-50*t3*t48*t6-5.76d-101*t33
     >           *t47*t6+7.68d-152*t45*t46*t6+2.4d-51*t1*t3*(1.066666666
     ?           6666666d-50*t3*t48*t5-5.76d-101*t33*t47*t5+7.68d-152*t4
     @           5*t46*t5+2.4d-51*t1*t3*(1.0666666666666666d-50*t3*t4*t4
     1           8-5.76d-101*t33*t4*t47+7.68d-152*t4*t45*t46)-8.0d-51*t3
     2           *t35*t36+1.92d-101*t33*t34*t36)-8.0d-51*t3*t35*t37+1.92
     3           d-101*t33*t34*t37)-8.0d-51*t3*t35*t38+1.92d-101*t33*t34
     4           *t38)*wght+1.0d+0*rhob*t32*t39*wght+1.0d+0*t22*t39*wght
     5           +Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m05 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{32}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{0.06\,{\it t_{37}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{32}}\,\left(0.06\,{\it t_{31}}
C>    \,{\it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{32}}+{
C>    \it t_{30}}\right)+{\it t_{29}}\right)+{\it t_{28}}\right)+{
C>    \it t_{26}}\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,\left(0.06
C>    \,{\it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{27}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{22}}\,\sigma_{\alpha\alpha}
C>    \,{\it t_{27}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_\alpha
C>    -{{0.25\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha}}\right)}\over{\tau_\alpha}}+1.0\,\left({
C>    \it t_{11}}\,\left(-0.0598079686361971\,{\it t_{14}}\,{
C>    \it t_{15}}\,\left(0.1274696188700087\,{\it t_{12}}+1.0\right)
C>    \,{\it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{
C>    \it t_{24}}\,{\it t_{25}}\,\left(0.0031\,{\it t_{24}}\,{
C>    \it t_{25}}\,\left(0.0031\,{\it param}\left(5\right)\,{
C>    \it t_{24}}\,{\it t_{25}}+{\it param}\left(4\right)\right)+{
C>    \it param}\left(3\right)\right)+{\it param}\left(2\right)\right)
C>    +{\it param}\left(1\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{36}}+2.225569421150687\,{\it t_{35}}+0.8004286349993635
C>    \,{\it t_{34}}+0.1897004325747558\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{35}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{36}}+3.844746237447211\,{\it t_{35}}+1.644733775567609
C>    \,{\it t_{34}}+0.2405871291288192\,{\it t_{33}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{35}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}
C>    \,\left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{37}}\,\sigma_{ss}\,{\it t_{38}}\,
C>    \left(0.06\,{\it t_{31}}\,{\it t_{37}}\,\sigma_{ss}\,{
C>    \it t_{38}}+{\it t_{30}}\right)+{\it t_{29}}\right)+{
C>    \it t_{28}}\right)+{\it t_{26}}\right)\,\left(2.0\,\tau_s
C>    -{{0.25\,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, NE Schultz, DG Truhlar, J.Chem.Phys. 123
C>    , 161103 (2005)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2126975 "> 
C> 10.1063/1.2126975 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m05_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(5)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(4)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(3)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(2)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(1)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = 6.0d-2*gammaaa*t1+1.0d+0
              t25 = 1/t24
              t26 = param(10)
              t27 = 6.0d-2*gammaaa*t1*t25*t26+param(9)
              t28 = 6.0d-2*gammaaa*t1*t25*t27+param(8)
              t29 = 6.0d-2*gammaaa*t1*t25*t28+param(7)
              t30 = 6.0d-2*gammaaa*t1*t25*t29+param(6)
              t31 = 1/taua
              t32 = 1/rhoa
              t33 = 2.0d+0*taua-2.5d-1*gammaaa*t32
              t34 = 6.299605249474366d-1
              t35 = 1.414213562373095d+0
              t36 = 1/t35
              t37 = 7.937005259840998d-1
              t38 = 8.908987181403393d-1
              t39 = 1.8970043257475583d-1*t34*t9+5.982550435771079d+0*t1
     1           3*t38+2.2255694211506874d+0*t12*t37+8.004286349993635d-
     2           1*t11*t36
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t12*t37+1.0d+0
              t43 = 1/t19
              t44 = 1/rhoa**1.6666666666666669d+0
              t45 = 1/t10**3
              t46 = 1/rhoa**1.3333333333333333d+0
              t47 = 1/rhoa**1.1666666666666667d+0
              t48 = -9.970917392951799d-1*t47-7.418564737168958d-1*t46-4
     1           .002143174996817d-1*t45-1.264669550498372d-1*t44
              t49 = 1/t18**2
              t50 = 1/t15
              t51 = -1.8533958105157808d+0*t47-1.2815820791490704d+0*t46
     1           -8.223668877838045d-1*t45-1.6039141941921276d-1*t44
              t52 = 1/t14**2
              t53 = 1.0d+0*t17*t50*t51*t52+1.1102230246251565d-16*t21*t4
     1           3*t48*t49+3.0506411443514264d-19*t20*t46+1.321039893133
     2           9265d-3*t16*t46
              t54 = 1/t40
              t55 = 3.149802624737183d-1
              t56 = 1/t35**3
              t57 = 3.968502629920499d-1
              t58 = 4.4544935907016964d-1
              t59 = -9.970917392951799d-1*t47*t58-7.418564737168958d-1*t
     1           46*t57-4.002143174996817d-1*t45*t56-1.264669550498372d-
     2           1*t44*t55
              t60 = 1/t39**2
              t61 = 2*rhoa*(1.0d+0*t42*t54*t59*t60+2.747773264188437d-3*
     1           t41*t46*t57)-rhoa*t53-6.21814d-2*t41*t42+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t62 = gammaaa**2
              t63 = 1/t2**2
              t64 = 1/rhoa**6.333333333333333d+0
              t65 = 1/rhoa**3.6666666666666664d+0
              t66 = 5.125333333333332d-5*t4*t62*t63*t64-8.26666666666666
     1           5d-3*gammaaa*t3*t4*t65
              t67 = 6.2d-3*gammaaa*t1*t3*t66-8.266666666666665d-3*gammaa
     1           a*t3*t5*t65+5.125333333333332d-5*t5*t62*t63*t64
              t68 = 6.2d-3*gammaaa*t1*t3*t67-8.266666666666665d-3*gammaa
     1           a*t3*t6*t65+5.125333333333332d-5*t6*t62*t63*t64
              t69 = -8.266666666666665d-3*gammaaa*t3*t65*t7+5.1253333333
     1           33332d-5*t62*t63*t64*t7+6.2d-3*gammaaa*t1*t3*t68
              t70 = t23-1.243628d-1*rhoa*t41*t42
              t71 = 1/t24**2
              t72 = 9.599999999999997d-3*t26*t62*t64*t71-1.5999999999999
     1           998d-1*gammaaa*t25*t26*t65
              t73 = 6.0d-2*gammaaa*t1*t25*t72+9.599999999999997d-3*t27*t
     1           62*t64*t71-1.5999999999999998d-1*gammaaa*t25*t27*t65
              t74 = 6.0d-2*gammaaa*t1*t25*t73+9.599999999999997d-3*t28*t
     1           62*t64*t71-1.5999999999999998d-1*gammaaa*t25*t28*t65
              t75 = 6.0d-2*gammaaa*t1*t25*t74+9.599999999999997d-3*t29*t
     1           62*t64*t71-1.5999999999999998d-1*gammaaa*t25*t29*t65
              t76 = 1/rhoa**5.333333333333333d+0
              t77 = 3.1d-3*t1*t3*t4-1.9219999999999998d-5*gammaaa*t4*t63
     1           *t76
              t78 = 6.2d-3*gammaaa*t1*t3*t77-1.9219999999999998d-5*gamma
     1           aa*t5*t63*t76+3.1d-3*t1*t3*t5
              t79 = 6.2d-3*gammaaa*t1*t3*t78-1.9219999999999998d-5*gamma
     1           aa*t6*t63*t76+3.1d-3*t1*t3*t6
              t80 = 6.2d-3*gammaaa*t1*t3*t79-1.9219999999999998d-5*gamma
     1           aa*t63*t7*t76+3.1d-3*t1*t3*t7
              t81 = -1.25d-1*t22*t30
              t82 = 6.0d-2*t1*t25*t26-3.6d-3*gammaaa*t26*t71*t76
              t83 = 6.0d-2*gammaaa*t1*t25*t82-3.6d-3*gammaaa*t27*t71*t76
     1           +6.0d-2*t1*t25*t27
              t84 = 6.0d-2*gammaaa*t1*t25*t83-3.6d-3*gammaaa*t28*t71*t76
     1           +6.0d-2*t1*t25*t28
              t85 = 6.0d-2*gammaaa*t1*t25*t84-3.6d-3*gammaaa*t29*t71*t76
     1           +6.0d-2*t1*t25*t29
              t86 = 1/taua**2
              t87 = 2.0d+0*t61*t69
              t88 = 2.0d+0*t42*t54*t59*t60
              t89 = 5.495546528376875d-3*t41*t46*t57
              t90 = 1/t19**2
              t91 = t48**2
              t92 = 1/t18**4
              t93 = 1/t18**3
              t94 = 1/t10**5
              t95 = 1/rhoa**2.3333333333333334d+0
              t96 = 1/rhoa**2.1666666666666665d+0
              t97 = 1.1632736958443765d+0*t96+9.89141964955861d-1*t95+6.
     1           003214762495226d-1*t94+2.1077825841639536d-1*t1
              t98 = 1/t15**2
              t99 = t51**2
              t100 = 1/t14**4
              t101 = 1/t14**3
              t102 = 2.1622951122684114d+0*t96+1.7087761055320938d+0*t95
     1           +1.2335503316757068d+0*t94+2.673190323653546d-1*t1
              t103 = 3.216395899738507d+1*t100*t17*t98*t99-2.0d+0*t101*t
     1           17*t50*t99+1.1102230246251565d-16*t21*t43*t49*t97-4.067
     2           5215258019015d-19*t20*t95-1.7613865241785684d-3*t16*t95
     3           -2.220446049250313d-16*t21*t43*t91*t93+1.78545839209981
     4           88d-15*t21*t90*t91*t92-8.497974591333913d-2*t46*t50*t51
     5           *t52+1.0d+0*t102*t17*t50*t52-9.812069668265515d-18*t43*
     6           t46*t48*t49
              t104 = 1/t40**2
              t105 = t59**2
              t106 = 1/t39**4
              t107 = 1.6081979498692536d+1*t104*t105*t106*t42
              t108 = 1/t39**3
              t109 = -2.0d+0*t105*t108*t42*t54
              t110 = 1.9842513149602492d-1
              t111 = 2.5908976111853255d-1*t96+9.89141964955861d-1*t110*
     1           t95+6.003214762495226d-1*t94/t35**5+3.319549557987472d-
     2           2*t1
              t112 = 1.0d+0*t111*t42*t54*t60
              t113 = -3.663697685584583d-3*t110*t41*t95
              t114 = 1.9115125951273373d-1*t34*t9+8.157414703487641d+0*t
     1           13*t38+2.247591863577616d+0*t12*t37+4.3009724712766434d
     2           -1*t11*t36
              t115 = 2.9608813203268075d+1/t114+1.0d+0
              t116 = log(t115)
              t117 = 6.901399211255825d-2*t12*t37+1.0d+0
              t118 = 1/rhoa**2
              t119 = -8.837926660346784d-2*t46*t54*t57*t59*t60
              t120 = t89+t88-2.0d+0*t17*t50*t51*t52-2.220446049250313d-1
     1           6*t21*t43*t48*t49-6.101282288702853d-19*t20*t46-2.64207
     2           9786267853d-3*t16*t46+2*rhoa*(t119+8.443431970194815d-3
     3           *t116*t117*t118+t113+t112+t109+t107)-rhoa*t103
              t121 = gammaaa**3
              t122 = 1/t2**3
              t123 = 1/rhoa**10
              t124 = 8.473884444444441d-7*t121*t122*t123*t7
              t125 = 1/rhoa**7.333333333333333d+0
              t126 = 1.0250666666666663d-4*t62*t63*t64*t68
              t127 = 1/rhoa**4.666666666666667d+0
              t128 = -1.653333333333333d-2*gammaaa*t3*t65*t68
              t129 = 8.473884444444441d-7*t121*t122*t123*t6
              t130 = 1.0250666666666663d-4*t62*t63*t64*t67
              t131 = -1.653333333333333d-2*gammaaa*t3*t65*t67
              t132 = 8.473884444444441d-7*t121*t122*t123*t5
              t133 = 1.0250666666666663d-4*t62*t63*t64*t66
              t134 = -1.653333333333333d-2*gammaaa*t3*t65*t66
              t135 = 8.473884444444441d-7*t121*t122*t123*t4
              t136 = -3.2460444444444436d-4*t125*t4*t62*t63+3.0311111111
     1           111105d-2*gammaaa*t127*t3*t4+t135
              t137 = -3.2460444444444436d-4*t125*t5*t62*t63+3.0311111111
     1           111105d-2*gammaaa*t127*t3*t5+6.2d-3*gammaaa*t1*t136*t3+
     2           t134+t133+t132
              t138 = -3.2460444444444436d-4*t125*t6*t62*t63+3.0311111111
     1           111105d-2*gammaaa*t127*t3*t6+6.2d-3*gammaaa*t1*t137*t3+
     2           t131+t130+t129
              t139 = -3.2460444444444436d-4*t125*t62*t63*t7+3.0311111111
     1           111105d-2*gammaaa*t127*t3*t7+6.2d-3*gammaaa*t1*t138*t3+
     2           t128+t126+t124
              t140 = 1/t24**3
              t141 = -8.639999999999998d-2*t125*t26*t62*t71+5.8666666666
     1           66666d-1*gammaaa*t127*t25*t26+3.0719999999999986d-3*t12
     2           1*t123*t140*t26
              t142 = 1.9199999999999995d-2*t62*t64*t71*t72-3.19999999999
     1           99995d-1*gammaaa*t25*t65*t72-8.639999999999998d-2*t125*
     2           t27*t62*t71+5.866666666666666d-1*gammaaa*t127*t25*t27+3
     3           .0719999999999986d-3*t121*t123*t140*t27+6.0d-2*gammaaa*
     4           t1*t141*t25
              t143 = 1.9199999999999995d-2*t62*t64*t71*t73-3.19999999999
     1           99995d-1*gammaaa*t25*t65*t73-8.639999999999998d-2*t125*
     2           t28*t62*t71+5.866666666666666d-1*gammaaa*t127*t25*t28+3
     3           .0719999999999986d-3*t121*t123*t140*t28+6.0d-2*gammaaa*
     4           t1*t142*t25
              t144 = 1.9199999999999995d-2*t62*t64*t71*t74-3.19999999999
     1           99995d-1*gammaaa*t25*t65*t74-8.639999999999998d-2*t125*
     2           t29*t62*t71+5.866666666666666d-1*gammaaa*t127*t25*t29+3
     3           .0719999999999986d-3*t121*t123*t140*t29+6.0d-2*gammaaa*
     4           t1*t143*t25
              t145 = -8.443431970194815d-3*t116*t117*t118
              t146 = t89+t88+2*rhoa*(t145+t119+t113+t112+t109+t107)
              t147 = t135-1.366755555555555d-4*t125*t4*t62*t63
              t148 = -1.366755555555555d-4*t125*t5*t62*t63+6.2d-3*gammaa
     1           a*t1*t147*t3+t134+t133+t132
              t149 = -1.366755555555555d-4*t125*t6*t62*t63+6.2d-3*gammaa
     1           a*t1*t148*t3+t131+t130+t129
              t150 = -1.366755555555555d-4*t125*t62*t63*t7+6.2d-3*gammaa
     1           a*t1*t149*t3+t128+t126+t124
              t151 = 1.0d+0*t61*t80
              t152 = 1/rhoa**9
              t153 = -3.1777066666666653d-7*t122*t152*t62*t7
              t154 = 5.125333333333332d-5*t62*t63*t64*t79
              t155 = -1.9219999999999998d-5*gammaaa*t63*t68*t76
              t156 = -8.266666666666665d-3*gammaaa*t3*t65*t79
              t157 = -3.1777066666666653d-7*t122*t152*t6*t62
              t158 = 5.125333333333332d-5*t62*t63*t64*t78
              t159 = -1.9219999999999998d-5*gammaaa*t63*t67*t76
              t160 = -8.266666666666665d-3*gammaaa*t3*t65*t78
              t161 = -3.1777066666666653d-7*t122*t152*t5*t62
              t162 = 5.125333333333332d-5*t62*t63*t64*t77
              t163 = -1.9219999999999998d-5*gammaaa*t63*t66*t76
              t164 = -8.266666666666665d-3*gammaaa*t3*t65*t77
              t165 = -3.1777066666666653d-7*t122*t152*t4*t62
              t166 = -8.266666666666665d-3*t3*t4*t65+1.0250666666666663d
     1           -4*gammaaa*t4*t63*t64+t165
              t167 = 3.1d-3*t1*t3*t66
              t168 = -8.266666666666665d-3*t3*t5*t65+1.0250666666666663d
     1           -4*gammaaa*t5*t63*t64+6.2d-3*gammaaa*t1*t166*t3+t167+t1
     2           64+t163+t162+t161
              t169 = 3.1d-3*t1*t3*t67
              t170 = -8.266666666666665d-3*t3*t6*t65+1.0250666666666663d
     1           -4*gammaaa*t6*t63*t64+6.2d-3*gammaaa*t1*t168*t3+t169+t1
     2           60+t159+t158+t157
              t171 = 3.1d-3*t1*t3*t68
              t172 = -8.266666666666665d-3*t3*t65*t7+1.0250666666666663d
     1           -4*gammaaa*t63*t64*t7+6.2d-3*gammaaa*t1*t170*t3+t171+t1
     2           56+t155+t154+t153
              t173 = 1.25d-1*t22*t30
              t174 = 2.879999999999999d-2*gammaaa*t26*t64*t71-1.59999999
     1           99999998d-1*t25*t26*t65-1.1519999999999996d-3*t140*t152
     2           *t26*t62
              t175 = 9.599999999999997d-3*t62*t64*t71*t82-1.599999999999
     1           9998d-1*gammaaa*t25*t65*t82-3.6d-3*gammaaa*t71*t72*t76+
     2           6.0d-2*t1*t25*t72+2.879999999999999d-2*gammaaa*t27*t64*
     3           t71-1.5999999999999998d-1*t25*t27*t65-1.151999999999999
     4           6d-3*t140*t152*t27*t62+6.0d-2*gammaaa*t1*t174*t25
              t176 = 9.599999999999997d-3*t62*t64*t71*t83-1.599999999999
     1           9998d-1*gammaaa*t25*t65*t83-3.6d-3*gammaaa*t71*t73*t76+
     2           6.0d-2*t1*t25*t73+2.879999999999999d-2*gammaaa*t28*t64*
     3           t71-1.5999999999999998d-1*t25*t28*t65-1.151999999999999
     4           6d-3*t140*t152*t28*t62+6.0d-2*gammaaa*t1*t175*t25
              t177 = 9.599999999999997d-3*t62*t64*t71*t84-1.599999999999
     1           9998d-1*gammaaa*t25*t65*t84-3.6d-3*gammaaa*t71*t74*t76+
     2           6.0d-2*t1*t25*t74+2.879999999999999d-2*gammaaa*t29*t64*
     3           t71-1.5999999999999998d-1*t25*t29*t65-1.151999999999999
     4           6d-3*t140*t152*t29*t62+6.0d-2*gammaaa*t1*t176*t25
              t178 = 5.125333333333332d-5*gammaaa*t4*t63*t64+t165
              t179 = 5.125333333333332d-5*gammaaa*t5*t63*t64+6.2d-3*gamm
     1           aaa*t1*t178*t3+t167+t164+t163+t162+t161
              t180 = 5.125333333333332d-5*gammaaa*t6*t63*t64+6.2d-3*gamm
     1           aaa*t1*t179*t3+t169+t160+t159+t158+t157
              t181 = 5.125333333333332d-5*gammaaa*t63*t64*t7+6.2d-3*gamm
     1           aaa*t1*t180*t3+t171+t156+t155+t154+t153
              t182 = 1/rhoa**8
              t183 = 1.1916399999999999d-7*gammaaa*t122*t182*t4-1.921999
     1           9999999998d-5*t4*t63*t76
              t184 = -3.8439999999999996d-5*gammaaa*t63*t76*t77+6.2d-3*t
     1           1*t3*t77-1.9219999999999998d-5*t5*t63*t76+1.19163999999
     2           99999d-7*gammaaa*t122*t182*t5+6.2d-3*gammaaa*t1*t183*t3
              t185 = -3.8439999999999996d-5*gammaaa*t63*t76*t78+6.2d-3*t
     1           1*t3*t78-1.9219999999999998d-5*t6*t63*t76+1.19163999999
     2           99999d-7*gammaaa*t122*t182*t6+6.2d-3*gammaaa*t1*t184*t3
              t186 = -3.8439999999999996d-5*gammaaa*t63*t76*t79+6.2d-3*t
     1           1*t3*t79-1.9219999999999998d-5*t63*t7*t76+1.19163999999
     2           99999d-7*gammaaa*t122*t182*t7+6.2d-3*gammaaa*t1*t185*t3
              t187 = 4.32d-4*gammaaa*t140*t182*t26-7.2d-3*t26*t71*t76
              t188 = -7.2d-3*gammaaa*t71*t76*t82+1.2d-1*t1*t25*t82-7.2d-
     1           3*t27*t71*t76+4.32d-4*gammaaa*t140*t182*t27+6.0d-2*gamm
     2           aaa*t1*t187*t25
              t189 = -7.2d-3*gammaaa*t71*t76*t83+1.2d-1*t1*t25*t83-7.2d-
     1           3*t28*t71*t76+4.32d-4*gammaaa*t140*t182*t28+6.0d-2*gamm
     2           aaa*t1*t188*t25
              t190 = -7.2d-3*gammaaa*t71*t76*t84+1.2d-1*t1*t25*t84-7.2d-
     1           3*t29*t71*t76+4.32d-4*gammaaa*t140*t182*t29+6.0d-2*gamm
     2           aaa*t1*t189*t25
              t191 = 1/taua**3
              t192 = 4.824593849607761d+1*t104*t105*t106*t42
              t193 = -6.0d+0*t105*t108*t42*t54
              t194 = 3.0d+0*t111*t42*t54*t60
              t195 = -1.099109305675375d-2*t110*t41*t95
              t196 = -2.6513779981040353d-1*t46*t54*t57*t59*t60
              t197 = t48**3
              t198 = 1/t10**7
              t199 = 1/rhoa**3.3333333333333337d+0
              t200 = 1/rhoa**3.1666666666666665d+0
              t201 = t51**3
              t202 = -4.0999275947472624d+0*t100*t46*t98*t99+2.549392377
     1           400174d-1*t101*t46*t50*t99+9.649187699215522d+1*t100*t1
     2           02*t17*t51*t98-1.9298375398431045d+2*t17*t201*t98/t14**
     3           5-6.661338147750939d-16*t21*t43*t48*t93*t97+5.356375176
     4           299456d-15*t21*t48*t90*t92*t97-1.4718104502398274d-17*t
     5           43*t46*t49*t97+1.6995949182667827d-1*t50*t51*t52*t95+1.
     6           962413933653103d-17*t43*t48*t49*t95+2.943620900479655d-
     7           17*t43*t46*t91*t93-2.3669625486718335d-16*t46*t90*t91*t
     8           92+6.661338147750939d-16*t197*t21*t43*t92-1.07127503525
     9           98913d-14*t197*t21*t90/t18**5+1.1102230246251565d-16*t2
     :           1*t43*t49*(-5.620753557770543d-1*t65-2.520426340996149d
     ;           +0*t200-2.3079979182303428d+0*t199-1.5008036906238065d+
     <           0*t198)+1.0d+0*t17*t50*t52*(-7.128507529742789d-1*t65-4
     =           .684972743248224d+0*t200-3.9871442462415524d+0*t199-3.0
     >           83875829189267d+0*t198)-1.274696188700087d-1*t102*t46*t
     ?           50*t52-6.0d+0*t101*t102*t17*t50*t51+6.0d+0*t100*t17*t20
     @           1*t50+5.742741051503565d-14*t197*t21/(t18**6*t19**3)+2.
     1           0690405167709364d+3*t17*t201/(t14**6*t15**3)+9.49088356
     2           0204437d-19*t199*t20+4.1099018897499934d-3*t16*t199
              t203 = t59**3
              t204 = 5.172601291927341d+2*t203*t42/(t39**6*t40**3)
              t205 = -9.649187699215522d+1*t104*t203*t42/t39**5
              t206 = 6.0d+0*t106*t203*t42*t54
              t207 = 4.824593849607761d+1*t104*t106*t111*t42*t59
              t208 = -6.0d+0*t108*t111*t42*t54*t59
              t209 = 9.921256574801247d-2
              t210 = 1.0d+0*t42*t54*t60*(-4.4260660773166294d-2*t65-1.50
     1           08036906238065d+0*t198/t35**7-2.3079979182303428d+0*t19
     2           9*t209-2.8068057454507694d-1*t200)
              t211 = 8.548627933030694d-3*t199*t209*t41
              t212 = 1/rhoa**3
              t213 = 1.767585332069357d-1*t110*t54*t59*t60*t95
              t214 = 1/t115
              t215 = -1.3595691172479402d+0*t47*t58-7.491972878592053d-1
     1           *t46*t57-2.1504862356383217d-1*t45*t56-1.27434173008489
     2           14d-1*t44*t55
              t216 = 1/t114**2
              t217 = -2.1319703304396778d+0*t104*t105*t106*t46*t57
              t218 = 2.6513779981040353d-1*t105*t108*t46*t54*t57
              t219 = -1.3256889990520176d-1*t111*t46*t54*t57*t60
              t220 = gammaaa**4
              t221 = 1/t2**4
              t222 = 1/rhoa**1.3666666666666666d+1
              t223 = 2.101523342222221d-8*t220*t221*t222*t7
              t224 = 1/rhoa**11
              t225 = 2.542165333333332d-6*t121*t122*t123*t68
              t226 = 1/rhoa**8.333333333333334d+0
              t227 = 1/rhoa**5.666666666666667d+0
              t228 = 2.101523342222221d-8*t220*t221*t222*t6
              t229 = 2.542165333333332d-6*t121*t122*t123*t67
              t230 = 2.101523342222221d-8*t220*t221*t222*t5
              t231 = 2.542165333333332d-6*t121*t122*t123*t66
              t232 = 2.101523342222221d-8*t220*t221*t222*t4
              t233 = 1/t24**4
              t234 = 1.0d+0*t120*t80
              t235 = 1/rhoa**1.2666666666666665d+1
              t236 = -7.880712533333329d-9*t121*t221*t235*t7
              t237 = 8.473884444444441d-7*t121*t122*t123*t79
              t238 = -6.355413333333331d-7*t122*t152*t62*t68
              t239 = -3.2460444444444436d-4*t125*t62*t63*t79
              t240 = -1.9219999999999998d-5*gammaaa*t138*t63*t76
              t241 = 3.0311111111111105d-2*gammaaa*t127*t3*t79
              t242 = -7.880712533333329d-9*t121*t221*t235*t6
              t243 = 8.473884444444441d-7*t121*t122*t123*t78
              t244 = -6.355413333333331d-7*t122*t152*t62*t67
              t245 = -3.2460444444444436d-4*t125*t62*t63*t78
              t246 = -1.9219999999999998d-5*gammaaa*t137*t63*t76
              t247 = 3.0311111111111105d-2*gammaaa*t127*t3*t78
              t248 = -7.880712533333329d-9*t121*t221*t235*t5
              t249 = 8.473884444444441d-7*t121*t122*t123*t77
              t250 = -6.355413333333331d-7*t122*t152*t62*t66
              t251 = -3.2460444444444436d-4*t125*t62*t63*t77
              t252 = -1.9219999999999998d-5*gammaaa*t136*t63*t76
              t253 = 3.0311111111111105d-2*gammaaa*t127*t3*t77
              t254 = -7.880712533333329d-9*t121*t221*t235*t4
              t255 = 3.1d-3*t1*t136*t3
              t256 = 3.1d-3*t1*t137*t3
              t257 = 3.1d-3*t1*t138*t3
              t258 = t81-1.25d-1*gammaaa*t22*t85
              t259 = 1.25d-1*t30*t53
              t260 = 1.25d-1*t22*t75
              t261 = 1.0d+0*t186*t61
              t262 = 1/rhoa**1.1666666666666665d+1
              t263 = 2.9552671999999985d-9*t221*t262*t62*t7
              t264 = -6.355413333333331d-7*t122*t152*t62*t79
              t265 = 1.1916399999999999d-7*gammaaa*t122*t182*t68
              t266 = 5.125333333333332d-5*t185*t62*t63*t64
              t267 = -1.9219999999999998d-5*t63*t68*t76
              t268 = -8.266666666666665d-3*gammaaa*t185*t3*t65
              t269 = 2.9552671999999985d-9*t221*t262*t6*t62
              t270 = -6.355413333333331d-7*t122*t152*t62*t78
              t271 = 1.1916399999999999d-7*gammaaa*t122*t182*t67
              t272 = 5.125333333333332d-5*t184*t62*t63*t64
              t273 = -1.9219999999999998d-5*t63*t67*t76
              t274 = -8.266666666666665d-3*gammaaa*t184*t3*t65
              t275 = 2.9552671999999985d-9*t221*t262*t5*t62
              t276 = -6.355413333333331d-7*t122*t152*t62*t77
              t277 = 1.1916399999999999d-7*gammaaa*t122*t182*t66
              t278 = 5.125333333333332d-5*t183*t62*t63*t64
              t279 = -1.9219999999999998d-5*t63*t66*t76
              t280 = -8.266666666666665d-3*gammaaa*t183*t3*t65
              t281 = 2.9552671999999985d-9*t221*t262*t4*t62
              t282 = 2.5d-1*t22*t85
              t283 = 1/rhoa**1.0666666666666666d+1
              t284 = -5.766d-5*t63*t76*t79+3.57492d-7*gammaaa*t122*t182*
     1           t79+6.2d-3*gammaaa*t1*t3*(-5.766d-5*t63*t76*t78+3.57492
     2           d-7*gammaaa*t122*t182*t78+6.2d-3*gammaaa*t1*t3*(-5.766d
     3           -5*t63*t76*t77+3.57492d-7*gammaaa*t122*t182*t77-5.766d-
     4           5*gammaaa*t183*t63*t76-1.1082252d-9*gammaaa*t221*t283*t
     5           5+1.78746d-7*t122*t182*t5+6.2d-3*gammaaa*t1*t3*(1.78746
     6           d-7*t122*t182*t4-1.1082252d-9*gammaaa*t221*t283*t4)+9.2
     7           99999999999999d-3*t1*t183*t3)-5.766d-5*gammaaa*t184*t63
     8           *t76-1.1082252d-9*gammaaa*t221*t283*t6+1.78746d-7*t122*
     9           t182*t6+9.299999999999999d-3*t1*t184*t3)-5.766d-5*gamma
     :           aa*t185*t63*t76-1.1082252d-9*gammaaa*t221*t283*t7+1.787
     ;           46d-7*t122*t182*t7+9.299999999999999d-3*t1*t185*t3
              fnc(iq) = (1.0d+0*t8*(t23-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.195037
     2           84087549d-1*t9+5.329846514438383d+0*t13+1.7664356201814
     3           29d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rho
     4           a*t22*t30*t31*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t61*t8+t31*(5.0d-1*rhoa*t22*t33*t
     1           75+5.0d-1*rhoa*t30*t33*t53+5.0d-1*t22*t30*t33)+1.0d+0*t
     2           69*t70+1.25d-1*gammaaa*t22*t30*t31*t32)*wght+Amat(iq,D1
     3           _RA)
              Cmat(iq,D1_GAA) = (t31*(5.0d-1*rhoa*t22*t33*t85+t81)+1.0d+
     1           0*t70*t80)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t22*t30*t31-5.0d-1*rhoa*t22*
     1           t30*t33*t86)*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t87+1.0d+0*t120*t8+t31*(1.0d+0*rhoa*
     1           t33*t53*t75+1.0d+0*t22*t33*t75+1.25d-1*gammaaa*t22*t32*
     2           t75+1.0d+0*t30*t33*t53+1.25d-1*gammaaa*t30*t32*t53+5.0d
     3           -1*rhoa*t103*t30*t33+5.0d-1*rhoa*t144*t22*t33+1.25d-1*g
     4           ammaaa*t118*t22*t30)+t31*t32*(1.25d-1*gammaaa*t22*t75+1
     5           .25d-1*gammaaa*t30*t53)+1.0d+0*t139*t70-1.25d-1*gammaaa
     6           *t118*t22*t30*t31)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t87+1.0d+0*t146*t8+1.0d+0*t150*t70)*
     1           wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t31*(5.0d-1*rhoa*t33*t53*t85+5.0d-1
     1           *t22*t33*t85-1.25d-1*t22*t75-1.25d-1*t30*t53+5.0d-1*rho
     2           a*t177*t22*t33-1.25d-1*t22*t30*t32)+t31*t32*(1.25d-1*ga
     3           mmaaa*t22*t85+t173)+1.0d+0*t172*t70+t151)*wght+Cmat2(iq
     4           ,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t181*t70+t151)*wght+Cmat2(iq
     1           ,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t31*(5.0d-1*rhoa*t190*t22*t33-2.5d
     1           -1*t22*t85)+1.0d+0*t186*t70)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t186*t70*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = ((-5.0d-1*rhoa*t22*t33*t75-5.0d-1*rho
     1           a*t30*t33*t53-5.0d-1*t22*t30*t33)*t86-1.25d-1*gammaaa*t
     2           22*t30*t32*t86+t31*(1.0d+0*rhoa*t22*t75+1.0d+0*rhoa*t30
     3           *t53+1.0d+0*t22*t30))*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = ((t173-5.0d-1*rhoa*t22*t33*t85)*t86+
     1           1.0d+0*rhoa*t22*t31*t85)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t191*t22*t30*t33-2.0d+0*
     1           rhoa*t22*t30*t86)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t8*(-9.649187699215522d+1*
     1           t100*t17*t98*t99+6.0d+0*t101*t17*t50*t99-3.330669073875
     2           4696d-16*t21*t43*t49*t97+1.2202564577405706d-18*t20*t95
     3           +5.284159572535705d-3*t16*t95+6.661338147750939d-16*t21
     4           *t43*t91*t93-5.356375176299456d-15*t21*t90*t91*t92+2*rh
     5           oa*(-5.82714947393947d-4*t116*t199*t57+t219+t218+t217-7
     6           .5d-1*t117*t118*t214*t215*t216+t213-2.533029591058444d-
     7           2*t116*t117*t212+t211+t210+t208+t207+t206+t205+t204)+2.
     8           549392377400174d-1*t46*t50*t51*t52-3.0d+0*t102*t17*t50*
     9           t52+2.943620900479655d-17*t43*t46*t48*t49-rhoa*t202+t19
     :           6+t195+t194+t193+t192+2.5330295910584444d-2*t116*t117*t
     ;           118)+t31*(3.0d+0*t33*t53*t75+5.0d-1*gammaaa*t32*t53*t75
     <           +1.5d+0*rhoa*t103*t33*t75+2.5d-1*gammaaa*t118*t22*t75+5
     =           .0d-1*rhoa*t22*t33*(-2.5919999999999993d-1*t125*t62*t71
     >           *t74+1.76d+0*gammaaa*t127*t25*t74+9.215999999999996d-3*
     ?           t121*t123*t140*t74+6.0d-2*gammaaa*t1*t25*(-2.5919999999
     @           999993d-1*t125*t62*t71*t73+1.76d+0*gammaaa*t127*t25*t73
     1           +9.215999999999996d-3*t121*t123*t140*t73+6.0d-2*gammaaa
     2           *t1*t25*(-2.5919999999999993d-1*t125*t62*t71*t72+1.76d+
     3           0*gammaaa*t127*t25*t72+9.215999999999996d-3*t121*t123*t
     4           140*t72+6.0d-2*gammaaa*t1*t25*(7.274666666666665d-1*t22
     5           6*t26*t62*t71-2.737777777777778d+0*gammaaa*t227*t25*t26
     6           +1.4745599999999992d-3*t220*t222*t233*t26-5.83679999999
     7           9998d-2*t121*t140*t224*t26)+2.879999999999999d-2*t141*t
     8           62*t64*t71+7.274666666666665d-1*t226*t27*t62*t71-4.7999
     9           99999999999d-1*gammaaa*t141*t25*t65-2.737777777777778d+
     :           0*gammaaa*t227*t25*t27+1.4745599999999992d-3*t220*t222*
     ;           t233*t27-5.836799999999998d-2*t121*t140*t224*t27)+2.879
     <           999999999999d-2*t142*t62*t64*t71+7.274666666666665d-1*t
     =           226*t28*t62*t71-4.799999999999999d-1*gammaaa*t142*t25*t
     >           65-2.737777777777778d+0*gammaaa*t227*t25*t28+1.47455999
     ?           99999992d-3*t220*t222*t233*t28-5.836799999999998d-2*t12
     @           1*t140*t224*t28)+2.879999999999999d-2*t143*t62*t64*t71+
     1           7.274666666666665d-1*t226*t29*t62*t71-4.799999999999999
     2           d-1*gammaaa*t143*t25*t65-2.737777777777778d+0*gammaaa*t
     3           227*t25*t29+1.4745599999999992d-3*t220*t222*t233*t29-5.
     4           836799999999998d-2*t121*t140*t224*t29)+1.5d+0*rhoa*t144
     5           *t33*t53+2.5d-1*gammaaa*t118*t30*t53+5.0d-1*rhoa*t202*t
     6           30*t33+1.5d+0*t103*t30*t33+1.5d+0*t144*t22*t33+2.5d-1*g
     7           ammaaa*t103*t30*t32+2.5d-1*gammaaa*t144*t22*t32-2.5d-1*
     8           gammaaa*t212*t22*t30)+t31*t32*(2.5d-1*gammaaa*t53*t75+1
     9           .25d-1*gammaaa*t103*t30+1.25d-1*gammaaa*t144*t22)+t118*
     :           t31*(-2.5d-1*gammaaa*t22*t75-2.5d-1*gammaaa*t30*t53)+1.
     ;           0d+0*(2.3804325925925923d-3*t226*t62*t63*t7-1.414518518
     <           5185183d-1*gammaaa*t227*t3*t7-1.271082666666666d-5*t121
     =           *t122*t224*t7-9.73813333333333d-4*t125*t62*t63*t68+9.09
     >           3333333333331d-2*gammaaa*t127*t3*t68+6.2d-3*gammaaa*t1*
     ?           t3*(-9.73813333333333d-4*t125*t62*t63*t67+9.09333333333
     @           3331d-2*gammaaa*t127*t3*t67+6.2d-3*gammaaa*t1*t3*(-9.73
     1           813333333333d-4*t125*t62*t63*t66+9.093333333333331d-2*g
     2           ammaaa*t127*t3*t66-2.4799999999999994d-2*gammaaa*t136*t
     3           3*t65+1.5375999999999995d-4*t136*t62*t63*t64+6.2d-3*gam
     4           maaa*t1*t3*(2.3804325925925923d-3*t226*t4*t62*t63-1.414
     5           5185185185183d-1*gammaaa*t227*t3*t4-1.271082666666666d-
     6           5*t121*t122*t224*t4+t232)+2.3804325925925923d-3*t226*t5
     7           *t62*t63-1.4145185185185183d-1*gammaaa*t227*t3*t5-1.271
     8           082666666666d-5*t121*t122*t224*t5+t231+t230)-2.47999999
     9           99999994d-2*gammaaa*t137*t3*t65+1.5375999999999995d-4*t
     :           137*t62*t63*t64+2.3804325925925923d-3*t226*t6*t62*t63-1
     ;           .4145185185185183d-1*gammaaa*t227*t3*t6-1.2710826666666
     <           66d-5*t121*t122*t224*t6+t229+t228)-2.4799999999999994d-
     =           2*gammaaa*t138*t3*t65+1.5375999999999995d-4*t138*t62*t6
     >           3*t64+t225+t223)*t70+3.0d+0*t120*t69+3.0d+0*t139*t61+2.
     ?           5d-1*gammaaa*t212*t22*t30*t31)*wght+Amat3(iq,D3_RA_RA_R
     @           A)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*(2*rhoa*(1.942383157979823
     1           7d-4*t116*t199*t57+t219+t218+t217+2.5d-1*t117*t118*t214
     2           *t215*t216+t213+8.443431970194815d-3*t116*t117*t212+t21
     3           1+t210+t208+t207+t206+t205+t204)+t196+t195+t194+t193+t1
     4           92+t145)*t8+1.0d+0*(5.011437037037035d-4*t226*t62*t63*t
     5           7-6.496644740740738d-6*t121*t122*t224*t7-5.979555555555
     6           554d-4*t125*t62*t63*t68+3.0311111111111105d-2*gammaaa*t
     7           127*t3*t68+6.2d-3*gammaaa*t1*t3*(-5.979555555555554d-4*
     8           t125*t62*t63*t67+3.0311111111111105d-2*gammaaa*t127*t3*
     9           t67+6.2d-3*gammaaa*t1*t3*(-5.979555555555554d-4*t125*t6
     :           2*t63*t66+3.0311111111111105d-2*gammaaa*t127*t3*t66-1.6
     ;           53333333333333d-2*gammaaa*t147*t3*t65-8.266666666666665
     <           d-3*gammaaa*t136*t3*t65+1.0250666666666663d-4*t147*t62*
     =           t63*t64+5.125333333333332d-5*t136*t62*t63*t64+6.2d-3*ga
     >           mmaaa*t1*t3*(5.011437037037035d-4*t226*t4*t62*t63-6.496
     ?           644740740738d-6*t121*t122*t224*t4+t232)+5.0114370370370
     @           35d-4*t226*t5*t62*t63-6.496644740740738d-6*t121*t122*t2
     1           24*t5+t231+t230)-1.653333333333333d-2*gammaaa*t148*t3*t
     2           65-8.266666666666665d-3*gammaaa*t137*t3*t65+1.025066666
     3           6666663d-4*t148*t62*t63*t64+5.125333333333332d-5*t137*t
     4           62*t63*t64+5.011437037037035d-4*t226*t6*t62*t63-6.49664
     5           4740740738d-6*t121*t122*t224*t6+t229+t228)-1.6533333333
     6           33333d-2*gammaaa*t149*t3*t65-8.266666666666665d-3*gamma
     7           aa*t138*t3*t65+1.0250666666666663d-4*t149*t62*t63*t64+5
     8           .125333333333332d-5*t138*t62*t63*t64+t225+t223)*t70+2.0
     9           d+0*t146*t69+1.0d+0*t120*t69+2.0d+0*t150*t61+1.0d+0*t13
     :           9*t61)*wght+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t31*(1.0d+0*t33*t53*t85+1.25d-1*
     1           gammaaa*t32*t53*t85+5.0d-1*rhoa*t103*t33*t85+1.25d-1*ga
     2           mmaaa*t118*t22*t85+5.0d-1*rhoa*t22*t33*(-8.639999999999
     3           998d-2*t125*t62*t71*t84+5.866666666666666d-1*gammaaa*t1
     4           27*t25*t84+3.0719999999999986d-3*t121*t123*t140*t84+6.0
     5           d-2*gammaaa*t1*t25*(-8.639999999999998d-2*t125*t62*t71*
     6           t83+5.866666666666666d-1*gammaaa*t127*t25*t83+3.0719999
     7           999999986d-3*t121*t123*t140*t83+6.0d-2*gammaaa*t1*t25*(
     8           -8.639999999999998d-2*t125*t62*t71*t82+5.86666666666666
     9           6d-1*gammaaa*t127*t25*t82+3.0719999999999986d-3*t121*t1
     :           23*t140*t82-3.6d-3*gammaaa*t141*t71*t76+5.7599999999999
     ;           98d-2*gammaaa*t64*t71*t72-3.1999999999999995d-1*t25*t65
     <           *t72-2.303999999999999d-3*t140*t152*t62*t72+6.0d-2*gamm
     =           aaa*t1*t25*(-2.0799999999999996d-1*gammaaa*t125*t26*t71
     >           +1.9583999999999993d-2*t123*t140*t26*t62+5.866666666666
     ?           666d-1*t127*t25*t26-5.529599999999998d-4*t121*t233*t235
     @           *t26)+1.9199999999999995d-2*t174*t62*t64*t71-2.07999999
     1           99999996d-1*gammaaa*t125*t27*t71-3.1999999999999995d-1*
     2           gammaaa*t174*t25*t65+1.9583999999999993d-2*t123*t140*t2
     3           7*t62+5.866666666666666d-1*t127*t25*t27-5.5295999999999
     4           98d-4*t121*t233*t235*t27+6.0d-2*t1*t141*t25)-3.6d-3*gam
     5           maaa*t142*t71*t76+5.759999999999998d-2*gammaaa*t64*t71*
     6           t73-3.1999999999999995d-1*t25*t65*t73-2.303999999999999
     7           d-3*t140*t152*t62*t73+1.9199999999999995d-2*t175*t62*t6
     8           4*t71-2.0799999999999996d-1*gammaaa*t125*t28*t71-3.1999
     9           999999999995d-1*gammaaa*t175*t25*t65+1.9583999999999993
     :           d-2*t123*t140*t28*t62+5.866666666666666d-1*t127*t25*t28
     ;           -5.529599999999998d-4*t121*t233*t235*t28+6.0d-2*t1*t142
     <           *t25)-3.6d-3*gammaaa*t143*t71*t76+5.759999999999998d-2*
     =           gammaaa*t64*t71*t74-3.1999999999999995d-1*t25*t65*t74-2
     >           .303999999999999d-3*t140*t152*t62*t74+1.919999999999999
     ?           5d-2*t176*t62*t64*t71-2.0799999999999996d-1*gammaaa*t12
     @           5*t29*t71-3.1999999999999995d-1*gammaaa*t176*t25*t65+1.
     1           9583999999999993d-2*t123*t140*t29*t62+5.866666666666666
     2           d-1*t127*t25*t29-5.529599999999998d-4*t121*t233*t235*t2
     3           9+6.0d-2*t1*t143*t25)-2.5d-1*t53*t75-1.25d-1*t22*t32*t7
     4           5+1.0d+0*rhoa*t177*t33*t53-1.25d-1*t30*t32*t53+1.0d+0*t
     5           177*t22*t33+1.25d-1*gammaaa*t177*t22*t32+1.25d-1*t118*t
     6           22*t30-1.25d-1*t103*t30-1.25d-1*t144*t22)+t31*t32*(1.25
     7           d-1*gammaaa*t53*t85+t260+t259+1.25d-1*gammaaa*t177*t22)
     8           +1.0d+0*(-6.492088888888888d-4*gammaaa*t125*t63*t7+4.13
     9           10186666666654d-6*t122*t123*t62*t7+3.0311111111111105d-
     :           2*t127*t3*t7-1.653333333333333d-2*t3*t65*t68+2.05013333
     ;           33333327d-4*gammaaa*t63*t64*t68+6.2d-3*gammaaa*t1*t3*(-
     <           1.653333333333333d-2*t3*t65*t67+2.0501333333333327d-4*g
     =           ammaaa*t63*t64*t67+6.2d-3*gammaaa*t1*t3*(-1.65333333333
     >           3333d-2*t3*t65*t66+2.0501333333333327d-4*gammaaa*t63*t6
     ?           4*t66-1.653333333333333d-2*gammaaa*t166*t3*t65+1.025066
     @           6666666663d-4*t166*t62*t63*t64+6.2d-3*gammaaa*t1*t3*(-6
     1           .492088888888888d-4*gammaaa*t125*t4*t63+4.1310186666666
     2           654d-6*t122*t123*t4*t62+3.0311111111111105d-2*t127*t3*t
     3           4+t254)-6.492088888888888d-4*gammaaa*t125*t5*t63+4.1310
     4           186666666654d-6*t122*t123*t5*t62+3.0311111111111105d-2*
     5           t127*t3*t5+t255+t253+t252+t251+t250+t249+t248)-1.653333
     6           333333333d-2*gammaaa*t168*t3*t65+1.0250666666666663d-4*
     7           t168*t62*t63*t64-6.492088888888888d-4*gammaaa*t125*t6*t
     8           63+4.1310186666666654d-6*t122*t123*t6*t62+3.03111111111
     9           11105d-2*t127*t3*t6+t256+t247+t246+t245+t244+t243+t242)
     :           -1.653333333333333d-2*gammaaa*t170*t3*t65+1.02506666666
     ;           66663d-4*t170*t62*t63*t64+t257+t241+t240+t239+t238+t237
     <           +t236)*t70+2.0d+0*t172*t61+t118*t258*t31+t234)*wght+Cma
     =           t3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*(-1.8792888888888884d-4*g
     1           ammaaa*t125*t63*t7+2.436241777777777d-6*t122*t123*t62*t
     2           7+1.0250666666666663d-4*gammaaa*t63*t64*t68+6.2d-3*gamm
     3           aaa*t1*t3*(1.0250666666666663d-4*gammaaa*t63*t64*t67+6.
     4           2d-3*gammaaa*t1*t3*(1.0250666666666663d-4*gammaaa*t63*t
     5           64*t66-1.653333333333333d-2*gammaaa*t178*t3*t65+1.02506
     6           66666666663d-4*t178*t62*t63*t64+6.2d-3*gammaaa*t1*t3*(-
     7           1.8792888888888884d-4*gammaaa*t125*t4*t63+2.43624177777
     8           7777d-6*t122*t123*t4*t62+t254)-1.8792888888888884d-4*ga
     9           mmaaa*t125*t5*t63+2.436241777777777d-6*t122*t123*t5*t62
     :           +t255+t253+t252+t251+t250+t249+t248)-1.653333333333333d
     ;           -2*gammaaa*t179*t3*t65+1.0250666666666663d-4*t179*t62*t
     <           63*t64-1.8792888888888884d-4*gammaaa*t125*t6*t63+2.4362
     =           41777777777d-6*t122*t123*t6*t62+t256+t247+t246+t245+t24
     >           4+t243+t242)-1.653333333333333d-2*gammaaa*t180*t3*t65+1
     ?           .0250666666666663d-4*t180*t62*t63*t64+t257+t241+t240+t2
     @           39+t238+t237+t236)*t70+2.0d+0*t181*t61+t234)*wght+Cmat3
     1           (iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*t146*t80+1.0d+0*t70*(-1.3
     1           66755555555555d-4*t125*t62*t63*t79+6.2d-3*gammaaa*t1*t3
     2           *(-1.366755555555555d-4*t125*t62*t63*t78+6.2d-3*gammaaa
     3           *t1*t3*(-1.366755555555555d-4*t125*t62*t63*t77-1.921999
     4           9999999998d-5*gammaaa*t147*t63*t76-8.266666666666665d-3
     5           *t3*t65*t66+1.5375999999999995d-4*gammaaa*t63*t64*t66-8
     6           .266666666666665d-3*gammaaa*t178*t3*t65-8.2666666666666
     7           65d-3*gammaaa*t166*t3*t65+5.125333333333332d-5*t178*t62
     8           *t63*t64+5.125333333333332d-5*t166*t62*t63*t64+6.2d-3*g
     9           ammaaa*t1*t3*(-1.366755555555555d-4*gammaaa*t125*t4*t63
     :           +2.1184711111111104d-6*t122*t123*t4*t62+t254)-1.3667555
     ;           55555555d-4*gammaaa*t125*t5*t63+2.1184711111111104d-6*t
     <           122*t123*t5*t62+3.1d-3*t1*t147*t3+t250+t249+t248)-1.921
     =           9999999999998d-5*gammaaa*t148*t63*t76-8.266666666666665
     >           d-3*t3*t65*t67+1.5375999999999995d-4*gammaaa*t63*t64*t6
     ?           7-8.266666666666665d-3*gammaaa*t179*t3*t65-8.2666666666
     @           66665d-3*gammaaa*t168*t3*t65+5.125333333333332d-5*t179*
     1           t62*t63*t64+5.125333333333332d-5*t168*t62*t63*t64-1.366
     2           755555555555d-4*gammaaa*t125*t6*t63+2.1184711111111104d
     3           -6*t122*t123*t6*t62+3.1d-3*t1*t148*t3+t244+t243+t242)-1
     4           .9219999999999998d-5*gammaaa*t149*t63*t76-1.36675555555
     5           5555d-4*gammaaa*t125*t63*t7+2.1184711111111104d-6*t122*
     6           t123*t62*t7-8.266666666666665d-3*t3*t65*t68+1.537599999
     7           9999995d-4*gammaaa*t63*t64*t68-8.266666666666665d-3*gam
     8           maaa*t180*t3*t65-8.266666666666665d-3*gammaaa*t170*t3*t
     9           65+5.125333333333332d-5*t180*t62*t63*t64+5.125333333333
     :           332d-5*t170*t62*t63*t64+3.1d-3*t1*t149*t3+t238+t237+t23
     ;           6)+1.0d+0*t181*t61+1.0d+0*t172*t61)*wght+Cmat3(iq,D3_RA
     <           _RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t31*(-2.5d-1*t53*t85-2.5d-1*t22
     1           *t32*t85+5.0d-1*rhoa*t22*t33*(5.759999999999998d-2*gamm
     2           aaa*t64*t71*t84-3.1999999999999995d-1*t25*t65*t84-2.303
     3           999999999999d-3*t140*t152*t62*t84+6.0d-2*gammaaa*t1*t25
     4           *(5.759999999999998d-2*gammaaa*t64*t71*t83-3.1999999999
     5           999995d-1*t25*t65*t83-2.303999999999999d-3*t140*t152*t6
     6           2*t83+6.0d-2*gammaaa*t1*t25*(5.759999999999998d-2*gamma
     7           aa*t64*t71*t82-3.1999999999999995d-1*t25*t65*t82-2.3039
     8           99999999999d-3*t140*t152*t62*t82-7.2d-3*t71*t72*t76-7.2
     9           d-3*gammaaa*t174*t71*t76+4.32d-4*gammaaa*t140*t182*t72+
     :           6.0d-2*gammaaa*t1*t25*(3.839999999999999d-2*t26*t64*t71
     ;           +2.073599999999999d-4*t233*t26*t262*t62-5.7599999999999
     <           97d-3*gammaaa*t140*t152*t26)+9.599999999999997d-3*t187*
     =           t62*t64*t71+3.839999999999999d-2*t27*t64*t71-1.59999999
     >           99999998d-1*gammaaa*t187*t25*t65+2.073599999999999d-4*t
     ?           233*t262*t27*t62-5.759999999999997d-3*gammaaa*t140*t152
     @           *t27+1.2d-1*t1*t174*t25)-7.2d-3*t71*t73*t76-7.2d-3*gamm
     1           aaa*t175*t71*t76+4.32d-4*gammaaa*t140*t182*t73+9.599999
     2           999999997d-3*t188*t62*t64*t71+3.839999999999999d-2*t28*
     3           t64*t71-1.5999999999999998d-1*gammaaa*t188*t25*t65+2.07
     4           3599999999999d-4*t233*t262*t28*t62-5.759999999999997d-3
     5           *gammaaa*t140*t152*t28+1.2d-1*t1*t175*t25)-7.2d-3*t71*t
     6           74*t76-7.2d-3*gammaaa*t176*t71*t76+4.32d-4*gammaaa*t140
     7           *t182*t74+9.599999999999997d-3*t189*t62*t64*t71+3.83999
     8           9999999999d-2*t29*t64*t71-1.5999999999999998d-1*gammaaa
     9           *t189*t25*t65+2.073599999999999d-4*t233*t262*t29*t62-5.
     :           759999999999997d-3*gammaaa*t140*t152*t29+1.2d-1*t1*t176
     ;           *t25)+5.0d-1*rhoa*t190*t33*t53+5.0d-1*t190*t22*t33-2.5d
     <           -1*t177*t22)+1.0d+0*t70*(-1.653333333333333d-2*t3*t65*t
     =           79+2.0501333333333327d-4*gammaaa*t63*t64*t79+6.2d-3*gam
     >           maaa*t1*t3*(-1.653333333333333d-2*t3*t65*t78+2.05013333
     ?           33333327d-4*gammaaa*t63*t64*t78+6.2d-3*gammaaa*t1*t3*(-
     @           1.653333333333333d-2*t3*t65*t77+2.0501333333333327d-4*g
     1           ammaaa*t63*t64*t77-3.8439999999999996d-5*gammaaa*t166*t
     2           63*t76+6.2d-3*gammaaa*t1*t3*(1.0250666666666663d-4*t4*t
     3           63*t64-1.1121973333333329d-6*gammaaa*t122*t152*t4+t281)
     4           +1.0250666666666663d-4*t5*t63*t64-1.1121973333333329d-6
     5           *gammaaa*t122*t152*t5+6.2d-3*t1*t166*t3+t280+t279+t278+
     6           t277+t276+t275)-3.8439999999999996d-5*gammaaa*t168*t63*
     7           t76+1.0250666666666663d-4*t6*t63*t64-1.1121973333333329
     8           d-6*gammaaa*t122*t152*t6+6.2d-3*t1*t168*t3+t274+t273+t2
     9           72+t271+t270+t269)-3.8439999999999996d-5*gammaaa*t170*t
     :           63*t76+1.0250666666666663d-4*t63*t64*t7-1.1121973333333
     ;           329d-6*gammaaa*t122*t152*t7+6.2d-3*t1*t170*t3+t268+t267
     <           +t266+t265+t264+t263)+(t282+1.25d-1*gammaaa*t190*t22)*t
     =           31*t32+t261)*wght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (1.0d+0*t70*(-8.266666666666665d
     1           -3*t3*t65*t79+1.5375999999999995d-4*gammaaa*t63*t64*t79
     2           +6.2d-3*gammaaa*t1*t3*(-8.266666666666665d-3*t3*t65*t78
     3           +1.5375999999999995d-4*gammaaa*t63*t64*t78+6.2d-3*gamma
     4           aa*t1*t3*(-8.266666666666665d-3*t3*t65*t77+1.5375999999
     5           999995d-4*gammaaa*t63*t64*t77-1.9219999999999998d-5*gam
     6           maaa*t178*t63*t76-1.9219999999999998d-5*gammaaa*t166*t6
     7           3*t76+6.2d-3*gammaaa*t1*t3*(5.125333333333332d-5*t4*t63
     8           *t64-7.944266666666663d-7*gammaaa*t122*t152*t4+t281)+5.
     9           125333333333332d-5*t5*t63*t64-7.944266666666663d-7*gamm
     :           aaa*t122*t152*t5+3.1d-3*t1*t178*t3+3.1d-3*t1*t166*t3+t2
     ;           80+t279+t278+t277+t276+t275)-1.9219999999999998d-5*gamm
     <           aaa*t179*t63*t76-1.9219999999999998d-5*gammaaa*t168*t63
     =           *t76+5.125333333333332d-5*t6*t63*t64-7.944266666666663d
     >           -7*gammaaa*t122*t152*t6+3.1d-3*t1*t179*t3+3.1d-3*t1*t16
     ?           8*t3+t274+t273+t272+t271+t270+t269)-1.9219999999999998d
     @           -5*gammaaa*t180*t63*t76-1.9219999999999998d-5*gammaaa*t
     1           170*t63*t76+5.125333333333332d-5*t63*t64*t7-7.944266666
     2           666663d-7*gammaaa*t122*t152*t7+3.1d-3*t1*t180*t3+3.1d-3
     3           *t1*t170*t3+t268+t267+t266+t265+t264+t263)+t261)*wght+C
     4           mat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*t70*(1.0250666666666663d
     1           -4*gammaaa*t63*t64*t79+6.2d-3*gammaaa*t1*t3*(1.02506666
     2           66666663d-4*gammaaa*t63*t64*t78+6.2d-3*gammaaa*t1*t3*(1
     3           .0250666666666663d-4*gammaaa*t63*t64*t77-3.843999999999
     4           9996d-5*gammaaa*t178*t63*t76-4.766559999999998d-7*gamma
     5           aa*t122*t152*t5+6.2d-3*gammaaa*t1*t3*(t281-4.7665599999
     6           99998d-7*gammaaa*t122*t152*t4)+6.2d-3*t1*t178*t3+t280+t
     7           279+t278+t277+t276+t275)-3.8439999999999996d-5*gammaaa*
     8           t179*t63*t76-4.766559999999998d-7*gammaaa*t122*t152*t6+
     9           6.2d-3*t1*t179*t3+t274+t273+t272+t271+t270+t269)-3.8439
     :           999999999996d-5*gammaaa*t180*t63*t76-4.766559999999998d
     ;           -7*gammaaa*t122*t152*t7+6.2d-3*t1*t180*t3+t268+t267+t26
     <           6+t265+t264+t263)+t261)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t31*(5.0d-1*rhoa*t22*t33*(-2.1
     1           600000000000003d-2*t71*t76*t84+1.296d-3*gammaaa*t140*t1
     2           82*t84+6.0d-2*gammaaa*t1*t25*(-2.1600000000000003d-2*t7
     3           1*t76*t83+1.296d-3*gammaaa*t140*t182*t83+6.0d-2*gammaaa
     4           *t1*t25*(-2.1600000000000003d-2*t71*t76*t82+1.296d-3*ga
     5           mmaaa*t140*t182*t82-1.0800000000000001d-2*gammaaa*t187*
     6           t71*t76+6.0d-2*gammaaa*t1*t25*(1.296d-3*t140*t182*t26-7
     7           .776d-5*gammaaa*t233*t26*t283)-7.776d-5*gammaaa*t233*t2
     8           7*t283+1.296d-3*t140*t182*t27+1.8d-1*t1*t187*t25)-1.080
     9           0000000000001d-2*gammaaa*t188*t71*t76-7.776d-5*gammaaa*
     :           t233*t28*t283+1.296d-3*t140*t182*t28+1.8d-1*t1*t188*t25
     ;           )-1.0800000000000001d-2*gammaaa*t189*t71*t76-7.776d-5*g
     <           ammaaa*t233*t283*t29+1.296d-3*t140*t182*t29+1.8d-1*t1*t
     =           189*t25)-3.75d-1*t190*t22)+1.0d+0*t284*t70)*wght+Cmat3(
     >           iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t284*t70*wght+Cmat3(iq,D
     1           3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = ((-1.0d+0*rhoa*t33*t53*t75-1.0d+0*
     1           t22*t33*t75-1.25d-1*gammaaa*t22*t32*t75-1.0d+0*t30*t33*
     2           t53-1.25d-1*gammaaa*t30*t32*t53-5.0d-1*rhoa*t103*t30*t3
     3           3-5.0d-1*rhoa*t144*t22*t33-1.25d-1*gammaaa*t118*t22*t30
     4           )*t86+t32*(-1.25d-1*gammaaa*t22*t75-1.25d-1*gammaaa*t30
     5           *t53)*t86+1.25d-1*gammaaa*t118*t22*t30*t86+t31*(2.0d+0*
     6           rhoa*t53*t75+2.0d+0*t22*t75+2.0d+0*t30*t53+1.0d+0*rhoa*
     7           t103*t30+1.0d+0*rhoa*t144*t22))*wght+Mmat3(iq,D3_RA_RA_
     8           TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = ((-5.0d-1*rhoa*t33*t53*t85-5.0d-1
     1           *t22*t33*t85-5.0d-1*rhoa*t177*t22*t33+1.25d-1*t22*t30*t
     2           32+t260+t259)*t86+t258*t32*t86+t31*(1.0d+0*rhoa*t53*t85
     3           +1.0d+0*t22*t85+1.0d+0*rhoa*t177*t22))*wght+Mmat3(iq,D3
     4           _RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = ((t282-5.0d-1*rhoa*t190*t22*t33)
     1           *t86+1.0d+0*rhoa*t190*t22*t31)*wght+Mmat3(iq,D3_GAA_GAA
     2           _TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = (6.0d+0*rhoa*t191*t22*t30-3.0d+0*r
     1           hoa*t22*t30*t33/taua**4)*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 2.4799999999999997d-52*t1+1.0d+0
              t24 = 1/t23
              t25 = param(5)
              t26 = 2.4799999999999997d-52*t1*t24*t25+param(4)
              t27 = 2.4799999999999997d-52*t1*t24*t26+param(3)
              t28 = 2.4799999999999997d-52*t1*t24*t27+param(2)
              t29 = 2.4799999999999997d-52*t1*t24*t28+param(1)
              t30 = -2*rhoa*t22
              t31 = 1/t19
              t32 = 1/t10**3
              t33 = 1/rhoa**1.3333333333333333d+0
              t34 = 1/rhoa**1.1666666666666667d+0
              t35 = -9.970917392951799d-1*t34-7.418564737168958d-1*t33-4
     1           .002143174996817d-1*t32-1.264669550498372d-1*t1
              t36 = 1/t18**2
              t37 = 1/t15
              t38 = -1.8533958105157808d+0*t34-1.2815820791490704d+0*t33
     1           -8.223668877838045d-1*t32-1.6039141941921276d-1*t1
              t39 = 1/t14**2
              t40 = 1.0d+0*t17*t37*t38*t39+1.1102230246251565d-16*t21*t3
     1           1*t35*t36+3.0506411443514264d-19*t20*t33+1.321039893133
     2           9265d-3*t16*t33
              t41 = 1/t2**2
              t42 = 1/rhoa**4.333333333333333d+0
              t43 = 1/rhoa**2.6666666666666666d+0
              t44 = 9.6d-102*t4*t41*t42-4.0d-51*t3*t4*t43
              t45 = -4.0d-51*t3*t43*t5+9.6d-102*t41*t42*t5+2.4d-51*t1*t3
     1           *t44
              t46 = -4.0d-51*t3*t43*t6+9.6d-102*t41*t42*t6+2.4d-51*t1*t3
     1           *t45
              t47 = -4.0d-51*t3*t43*t7+9.6d-102*t41*t42*t7+2.4d-51*t1*t3
     1           *t46
              t48 = 6.299605249474366d-1
              t49 = 1.414213562373095d+0
              t50 = 1/t49
              t51 = 7.937005259840998d-1
              t52 = 8.908987181403393d-1
              t53 = 1.8970043257475583d-1*t48*t9+5.982550435771079d+0*t1
     1           3*t52+2.2255694211506874d+0*t12*t51+8.004286349993635d-
     2           1*t11*t50
              t54 = 1.6081979498692536d+1/t53+1.0d+0
              t55 = log(t54)
              t56 = 1.3256889990520176d-1*t12*t51+1.0d+0
              t57 = 1/t54
              t58 = 3.149802624737183d-1
              t59 = 1/t49**3
              t60 = 3.968502629920499d-1
              t61 = 4.4544935907016964d-1
              t62 = -9.970917392951799d-1*t34*t61-7.418564737168958d-1*t
     1           33*t60-4.002143174996817d-1*t32*t59-1.264669550498372d-
     2           1*t1*t58
              t63 = 1/t53**2
              t64 = 2*rhoa*(1.0d+0*t56*t57*t62*t63+2.747773264188437d-3*
     1           t33*t55*t60)-6.21814d-2*t55*t56-rhoa*t40+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t65 = 1/t23**2
              t66 = 5.125333333333333d-104*t25*t42*t65-2.066666666666666
     1           7d-52*t24*t25*t43
              t67 = 2.4799999999999997d-52*t1*t24*t66+5.125333333333333d
     1           -104*t26*t42*t65-2.0666666666666667d-52*t24*t26*t43
              t68 = 2.4799999999999997d-52*t1*t24*t67+5.125333333333333d
     1           -104*t27*t42*t65-2.0666666666666667d-52*t24*t27*t43
              t69 = 2.4799999999999997d-52*t1*t24*t68+5.125333333333333d
     1           -104*t28*t42*t65-2.0666666666666667d-52*t24*t28*t43
              t70 = t30-1.243628d-1*rhoa*t55*t56
              t71 = 1/t19**2
              t72 = t35**2
              t73 = 1/t18**4
              t74 = 1/t18**3
              t75 = 1/t10**5
              t76 = 1/rhoa**2.3333333333333334d+0
              t77 = 1/rhoa**2.1666666666666665d+0
              t78 = 1.1632736958443765d+0*t77+9.89141964955861d-1*t76+6.
     1           003214762495226d-1*t75+2.1077825841639536d-1*t43
              t79 = 1/t15**2
              t80 = t38**2
              t81 = 1/t14**4
              t82 = 1/t14**3
              t83 = 2.1622951122684114d+0*t77+1.7087761055320938d+0*t76+
     1           1.2335503316757068d+0*t75+2.673190323653546d-1*t43
              t84 = 1.0d+0*t17*t37*t39*t83-2.0d+0*t17*t37*t80*t82+3.2163
     1           95899738507d+1*t17*t79*t80*t81+1.1102230246251565d-16*t
     2           21*t31*t36*t78-4.0675215258019015d-19*t20*t76-1.7613865
     3           241785684d-3*t16*t76-2.220446049250313d-16*t21*t31*t72*
     4           t74+1.7854583920998188d-15*t21*t71*t72*t73-8.4979745913
     5           33913d-2*t33*t37*t38*t39-9.812069668265515d-18*t31*t33*
     6           t35*t36
              t85 = 1/t2**3
              t86 = 1/rhoa**7
              t87 = 1/rhoa**5.333333333333333d+0
              t88 = 1/rhoa**3.6666666666666664d+0
              t89 = 1.0666666666666666d-50*t3*t4*t88-5.76d-101*t4*t41*t8
     1           7+7.68d-152*t4*t85*t86
              t90 = 2.4d-51*t1*t3*t89+1.0666666666666666d-50*t3*t5*t88-5
     1           .76d-101*t41*t5*t87+7.68d-152*t5*t85*t86-8.0d-51*t3*t43
     2           *t44+1.92d-101*t41*t42*t44
              t91 = 2.4d-51*t1*t3*t90+1.0666666666666666d-50*t3*t6*t88-5
     1           .76d-101*t41*t6*t87+7.68d-152*t6*t85*t86-8.0d-51*t3*t43
     2           *t45+1.92d-101*t41*t42*t45
              t92 = 2.4d-51*t1*t3*t91+1.0666666666666666d-50*t3*t7*t88-5
     1           .76d-101*t41*t7*t87+7.68d-152*t7*t85*t86-8.0d-51*t3*t43
     2           *t46+1.92d-101*t41*t42*t46
              t93 = 2.0d+0*t64*t69
              t94 = 2.0d+0*t56*t57*t62*t63
              t95 = 5.495546528376875d-3*t33*t55*t60
              t96 = 1/t54**2
              t97 = t62**2
              t98 = 1/t53**4
              t99 = 1.6081979498692536d+1*t56*t96*t97*t98
              t100 = 1/t53**3
              t101 = -2.0d+0*t100*t56*t57*t97
              t102 = 1.9842513149602492d-1
              t103 = 2.5908976111853255d-1*t77+9.89141964955861d-1*t102*
     1           t76+6.003214762495226d-1*t75/t49**5+3.319549557987472d-
     2           2*t43
              t104 = 1.0d+0*t103*t56*t57*t63
              t105 = -3.663697685584583d-3*t102*t55*t76
              t106 = 1.9115125951273373d-1*t48*t9+8.157414703487641d+0*t
     1           13*t52+2.247591863577616d+0*t12*t51+4.3009724712766434d
     2           -1*t11*t50
              t107 = 2.9608813203268075d+1/t106+1.0d+0
              t108 = log(t107)
              t109 = 6.901399211255825d-2*t12*t51+1.0d+0
              t110 = 1/rhoa**2
              t111 = -8.837926660346784d-2*t33*t57*t60*t62*t63
              t112 = 2*rhoa*(t99+t111+8.443431970194815d-3*t108*t109*t11
     1           0+t105+t104+t101)+t95+t94-rhoa*t84-2.0d+0*t17*t37*t38*t
     2           39-2.220446049250313d-16*t21*t31*t35*t36-6.101282288702
     3           853d-19*t20*t33-2.642079786267853d-3*t16*t33
              t113 = 1/t23**3
              t114 = 2.118471111111111d-155*t113*t28*t86
              t115 = 1.0250666666666666d-103*t42*t65*t68
              t116 = -4.1333333333333333d-52*t24*t43*t68
              t117 = 2.118471111111111d-155*t113*t27*t86
              t118 = 1.0250666666666666d-103*t42*t65*t67
              t119 = -4.1333333333333333d-52*t24*t43*t67
              t120 = 2.118471111111111d-155*t113*t26*t86
              t121 = 1.0250666666666666d-103*t42*t65*t66
              t122 = -4.1333333333333333d-52*t24*t43*t66
              t123 = 2.118471111111111d-155*t113*t25*t86
              t124 = 5.51111111111111d-52*t24*t25*t88-2.2209777777777773
     1           d-103*t25*t65*t87+t123
              t125 = 5.51111111111111d-52*t24*t26*t88-2.2209777777777773
     1           d-103*t26*t65*t87+2.4799999999999997d-52*t1*t124*t24+t1
     2           22+t121+t120
              t126 = 5.51111111111111d-52*t24*t27*t88-2.2209777777777773
     1           d-103*t27*t65*t87+2.4799999999999997d-52*t1*t125*t24+t1
     2           19+t118+t117
              t127 = 5.51111111111111d-52*t24*t28*t88-2.2209777777777773
     1           d-103*t28*t65*t87+2.4799999999999997d-52*t1*t126*t24+t1
     2           16+t115+t114
              t128 = -8.443431970194815d-3*t108*t109*t110
              t129 = 2*rhoa*(t99+t128+t111+t105+t104+t101)+t95+t94
              t130 = t123-8.542222222222222d-104*t25*t65*t87
              t131 = -8.542222222222222d-104*t26*t65*t87+2.4799999999999
     1           997d-52*t1*t130*t24+t122+t121+t120
              t132 = -8.542222222222222d-104*t27*t65*t87+2.4799999999999
     1           997d-52*t1*t131*t24+t119+t118+t117
              t133 = -8.542222222222222d-104*t28*t65*t87+2.4799999999999
     1           997d-52*t1*t132*t24+t116+t115+t114
              t134 = t35**3
              t135 = 1/t10**7
              t136 = 1/rhoa**3.3333333333333337d+0
              t137 = 1/rhoa**3.1666666666666665d+0
              t138 = t38**3
              t139 = 1.1102230246251565d-16*t21*t31*t36*(-5.620753557770
     1           543d-1*t88-2.520426340996149d+0*t137-2.3079979182303428
     2           d+0*t136-1.5008036906238065d+0*t135)+1.0d+0*t17*t37*t39
     3           *(-7.128507529742789d-1*t88-4.684972743248224d+0*t137-3
     4           .9871442462415524d+0*t136-3.083875829189267d+0*t135)-6.
     5           0d+0*t17*t37*t38*t82*t83+9.649187699215522d+1*t17*t38*t
     6           79*t81*t83-1.274696188700087d-1*t33*t37*t39*t83+2.54939
     7           2377400174d-1*t33*t37*t80*t82-4.0999275947472624d+0*t33
     8           *t79*t80*t81+6.0d+0*t138*t17*t37*t81-1.9298375398431045
     9           d+2*t138*t17*t79/t14**5-6.661338147750939d-16*t21*t31*t
     :           35*t74*t78+5.356375176299456d-15*t21*t35*t71*t73*t78-1.
     ;           4718104502398274d-17*t31*t33*t36*t78+1.6995949182667827
     <           d-1*t37*t38*t39*t76+1.962413933653103d-17*t31*t35*t36*t
     =           76+2.943620900479655d-17*t31*t33*t72*t74-2.366962548671
     >           8335d-16*t33*t71*t72*t73+6.661338147750939d-16*t134*t21
     ?           *t31*t73-1.0712750352598913d-14*t134*t21*t71/t18**5+5.7
     @           42741051503565d-14*t134*t21/(t18**6*t19**3)+9.490883560
     1           204437d-19*t136*t20+2.0690405167709364d+3*t138*t17/(t14
     2           **6*t15**3)+4.1099018897499934d-3*t136*t16
              t140 = 1/t2**4
              t141 = 1/rhoa**9.666666666666666d+0
              t142 = 1/rhoa**8
              t143 = 1/rhoa**6.333333333333333d+0
              t144 = 1/rhoa**4.666666666666667d+0
              t145 = 4.824593849607761d+1*t56*t96*t97*t98
              t146 = -6.0d+0*t100*t56*t57*t97
              t147 = 3.0d+0*t103*t56*t57*t63
              t148 = -1.099109305675375d-2*t102*t55*t76
              t149 = -2.6513779981040353d-1*t33*t57*t60*t62*t63
              t150 = t62**3
              t151 = 5.172601291927341d+2*t150*t56/(t53**6*t54**3)
              t152 = -9.649187699215522d+1*t150*t56*t96/t53**5
              t153 = 6.0d+0*t150*t56*t57*t98
              t154 = 4.824593849607761d+1*t103*t56*t62*t96*t98
              t155 = -6.0d+0*t100*t103*t56*t57*t62
              t156 = 9.921256574801247d-2
              t157 = 1.0d+0*t56*t57*t63*(-4.4260660773166294d-2*t88-1.50
     1           08036906238065d+0*t135/t49**7-2.3079979182303428d+0*t13
     2           6*t156-2.8068057454507694d-1*t137)
              t158 = 8.548627933030694d-3*t136*t156*t55
              t159 = 1/rhoa**3
              t160 = 1.767585332069357d-1*t102*t57*t62*t63*t76
              t161 = 1/t107
              t162 = -1.3595691172479402d+0*t34*t61-7.491972878592053d-1
     1           *t33*t60-2.1504862356383217d-1*t32*t59-1.27434173008489
     2           14d-1*t1*t58
              t163 = 1/t106**2
              t164 = -2.1319703304396778d+0*t33*t60*t96*t97*t98
              t165 = 2.6513779981040353d-1*t100*t33*t57*t60*t97
              t166 = -1.3256889990520176d-1*t103*t33*t57*t60*t63
              t167 = 1/t23**4
              t168 = 1.3134520888888887d-206*t141*t167*t28
              t169 = 6.355413333333333d-155*t113*t68*t86
              t170 = 1.3134520888888887d-206*t141*t167*t27
              t171 = 6.355413333333333d-155*t113*t67*t86
              t172 = 1.3134520888888887d-206*t141*t167*t26
              t173 = 6.355413333333333d-155*t113*t66*t86
              t174 = 1.3134520888888887d-206*t141*t167*t25
              fnc(iq) = (1.0d+0*t29*(t30-1.243628d-1*rhoa*(1.05220005583
     1           89212d-1*t12+1.0d+0)*log(1.6081979498692536d+1/(1.19503
     2           784087549d-1*t9+5.329846514438383d+0*t13+1.766435620181
     3           429d+0*t12+5.659885156639418d-1*t11)+1.0d+0))+1.0d+0*rh
     4           oa*t22*t8)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t40*t8+5.0d-1*t22*t8+1.0d+0*
     1           t69*t70+1.0d+0*t29*t64+5.0d-1*rhoa*t22*t47)*wght+Amat(i
     2           q,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t93+5.0d-1*rhoa*t22*t92+5.0d-1*rhoa*
     1           t8*t84+1.0d+0*t40*t8+1.0d+0*t127*t70+1.0d+0*rhoa*t40*t4
     2           7+1.0d+0*t22*t47+1.0d+0*t112*t29)*wght+Amat2(iq,D2_RA_R
     3           A)
              Amat2(iq,D2_RA_RB) = (t93+1.0d+0*t133*t70+1.0d+0*t129*t29)
     1           *wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.5d+0*rhoa*t40*t92+1.5d+0*t22*t9
     1           2+5.0d-1*rhoa*t22*(-1.2d-50*t3*t43*t91+2.88d-101*t41*t4
     2           2*t91+2.4d-51*t1*t3*(-1.2d-50*t3*t43*t90+2.88d-101*t41*
     3           t42*t90+2.4d-51*t1*t3*(-1.2d-50*t3*t43*t89+2.88d-101*t4
     4           1*t42*t89+3.2d-50*t3*t44*t88-1.7279999999999998d-100*t4
     5           1*t44*t87+2.3040000000000002d-151*t44*t85*t86+2.4d-51*t
     6           1*t3*(-9.984000000000001d-151*t142*t4*t85+3.49866666666
     7           66666d-100*t143*t4*t41-3.911111111111111d-50*t144*t3*t4
     8           +9.216000000000001d-202*t140*t141*t4)-9.984000000000001
     9           d-151*t142*t5*t85+3.4986666666666666d-100*t143*t41*t5-3
     :           .911111111111111d-50*t144*t3*t5+9.216000000000001d-202*
     ;           t140*t141*t5)+3.2d-50*t3*t45*t88-1.7279999999999998d-10
     <           0*t41*t45*t87+2.3040000000000002d-151*t45*t85*t86-9.984
     =           000000000001d-151*t142*t6*t85+3.4986666666666666d-100*t
     >           143*t41*t6-3.911111111111111d-50*t144*t3*t6+9.216000000
     ?           000001d-202*t140*t141*t6)+3.2d-50*t3*t46*t88-1.72799999
     @           99999998d-100*t41*t46*t87+2.3040000000000002d-151*t46*t
     1           85*t86-9.984000000000001d-151*t142*t7*t85+3.49866666666
     2           66666d-100*t143*t41*t7-3.911111111111111d-50*t144*t3*t7
     3           +9.216000000000001d-202*t140*t141*t7)+1.0d+0*t70*(2.479
     4           9999999999997d-52*t1*t24*(2.4799999999999997d-52*t1*t24
     5           *(1.6533333333333333d-51*t24*t66*t88-6.662933333333332d
     6           -103*t65*t66*t87+2.4799999999999997d-52*t1*t24*(1.18452
     7           14814814811d-102*t143*t25*t65-2.0207407407407404d-51*t1
     8           44*t24*t25-2.2243946666666667d-154*t113*t142*t25+t174)+
     9           1.5375999999999998d-103*t124*t42*t65+1.1845214814814811
     :           d-102*t143*t26*t65-6.2d-52*t124*t24*t43-2.0207407407407
     ;           404d-51*t144*t24*t26-2.2243946666666667d-154*t113*t142*
     <           t26+t173+t172)+1.6533333333333333d-51*t24*t67*t88-6.662
     =           933333333332d-103*t65*t67*t87+1.5375999999999998d-103*t
     >           125*t42*t65+1.1845214814814811d-102*t143*t27*t65-6.2d-5
     ?           2*t125*t24*t43-2.0207407407407404d-51*t144*t24*t27-2.22
     @           43946666666667d-154*t113*t142*t27+t171+t170)+1.65333333
     1           33333333d-51*t24*t68*t88-6.662933333333332d-103*t65*t68
     2           *t87+1.5375999999999998d-103*t126*t42*t65+1.18452148148
     3           14811d-102*t143*t28*t65-6.2d-52*t126*t24*t43-2.02074074
     4           07407404d-51*t144*t24*t28-2.2243946666666667d-154*t113*
     5           t142*t28+t169+t168)+1.5d+0*t8*t84+1.5d+0*rhoa*t47*t84+1
     6           .0d+0*t29*(-3.0d+0*t17*t37*t39*t83+6.0d+0*t17*t37*t80*t
     7           82-9.649187699215522d+1*t17*t79*t80*t81-3.3306690738754
     8           696d-16*t21*t31*t36*t78+1.2202564577405706d-18*t20*t76+
     9           5.284159572535705d-3*t16*t76+6.661338147750939d-16*t21*
     :           t31*t72*t74-5.356375176299456d-15*t21*t71*t72*t73+2*rho
     ;           a*(-5.82714947393947d-4*t108*t136*t60+t166+t165+t164-7.
     <           5d-1*t109*t110*t161*t162*t163+t160-2.533029591058444d-2
     =           *t108*t109*t159+t158+t157+t155+t154+t153+t152+t151)+2.5
     >           49392377400174d-1*t33*t37*t38*t39+2.943620900479655d-17
     ?           *t31*t33*t35*t36+t149+t148+t147+t146+t145-rhoa*t139+2.5
     @           330295910584444d-2*t108*t109*t110)+5.0d-1*rhoa*t139*t8+
     1           3.0d+0*t112*t69+3.0d+0*t127*t64+3.0d+0*t40*t47)*wght+Am
     2           at3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t70*(2.4799999999999997d-5
     1           2*t1*t24*(2.4799999999999997d-52*t1*t24*(5.511111111111
     2           11d-52*t24*t66*t88-3.929422222222222d-103*t65*t66*t87+2
     3           .4799999999999997d-52*t1*t24*(2.2779259259259252d-103*t
     4           143*t25*t65-1.0945434074074073d-154*t113*t142*t25+t174)
     5           +1.0250666666666666d-103*t130*t42*t65+5.125333333333333
     6           d-104*t124*t42*t65+2.2779259259259252d-103*t143*t26*t65
     7           -4.1333333333333333d-52*t130*t24*t43-2.0666666666666667
     8           d-52*t124*t24*t43-1.0945434074074073d-154*t113*t142*t26
     9           +t173+t172)+5.51111111111111d-52*t24*t67*t88-3.92942222
     :           2222222d-103*t65*t67*t87+1.0250666666666666d-103*t131*t
     ;           42*t65+5.125333333333333d-104*t125*t42*t65+2.2779259259
     <           259252d-103*t143*t27*t65-4.1333333333333333d-52*t131*t2
     =           4*t43-2.0666666666666667d-52*t125*t24*t43-1.09454340740
     >           74073d-154*t113*t142*t27+t171+t170)+5.51111111111111d-5
     ?           2*t24*t68*t88-3.929422222222222d-103*t65*t68*t87+1.0250
     @           666666666666d-103*t132*t42*t65+5.125333333333333d-104*t
     1           126*t42*t65+2.2779259259259252d-103*t143*t28*t65-4.1333
     2           333333333333d-52*t132*t24*t43-2.0666666666666667d-52*t1
     3           26*t24*t43-1.0945434074074073d-154*t113*t142*t28+t169+t
     4           168)+2.0d+0*t129*t69+1.0d+0*t112*t69+2.0d+0*t133*t64+1.
     5           0d+0*t127*t64+1.0d+0*t29*(2*rhoa*(1.9423831579798237d-4
     6           *t108*t136*t60+t166+t165+t164+2.5d-1*t109*t110*t161*t16
     7           2*t163+t160+8.443431970194815d-3*t108*t109*t159+t158+t1
     8           57+t155+t154+t153+t152+t151)+t149+t148+t147+t146+t145+t
     9           128))*wght+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(5)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 1/rhob**2.6666666666666666d+0
              t4 = gammabb*t3+gammaaa*t2
              t5 = 3.1d-3*t4+1.0d+0
              t6 = 1/t5
              t7 = 3.1d-3*t1*t4*t6+param(4)
              t8 = 3.1d-3*t4*t6*t7+param(3)
              t9 = 3.1d-3*t4*t6*t8+param(2)
              t10 = 3.1d-3*t4*t6*t9+param(1)
              t11 = 1/rhoa**6.666666666666666d-1
              t12 = rhoa**5.0d-1
              t13 = 1/t12
              t14 = 1/rhoa**3.333333333333333d-1
              t15 = 1/rhoa**1.6666666666666666d-1
              t16 = 1.1120374863094686d+1*t15+3.8447462374472113d+0*t14+
     1           1.644733775567609d+0*t13+2.4058712912881916d-1*t11
              t17 = 3.216395899738507d+1/t16+1.0d+0
              t18 = log(t17)
              t19 = 1.274696188700087d-1*t14+1.0d+0
              t20 = 5.982550435771079d+0*t15+2.2255694211506874d+0*t14+8
     1           .004286349993635d-1*t13+1.8970043257475583d-1*t11
              t21 = 1.6081979498692536d+1/t20+1.0d+0
              t22 = log(t21)
              t23 = 1.3256889990520176d-1*t14+1.0d+0
              t24 = -6.903522198342671d-18*t22*t23-3.1090699999999993d-2
     1           *t18*t19
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = rhob+rhoa
              t40 = 1/t39**3.333333333333333d-1
              t41 = 1.3256889990520176d-1*t40+1.0d+0
              t42 = rhoa-rhob
              t43 = t42**4
              t44 = 1/t39**4
              t45 = 1/t39
              t46 = 1.0d+0-t42*t45
              t47 = t42*t45+1.0d+0
              t48 = t47**1.3333333333333333d+0+t46**1.3333333333333333d+
     1           0-2.0d+0
              t49 = -1.923661050931536d+0*t43*t44*t48
              t50 = t49+1.0d+0
              t51 = 1/t39**6.666666666666666d-1
              t52 = t39**5.0d-1
              t53 = 1/t52
              t54 = 1/t39**1.6666666666666666d-1
              t55 = 5.982550435771079d+0*t54+8.004286349993635d-1*t53+1.
     1           8970043257475583d-1*t51+2.2255694211506874d+0*t40
              t56 = 1.6081979498692536d+1/t55+1.0d+0
              t57 = log(t56)
              t58 = -6.21814d-2*t41*t50*t57
              t59 = 6.901399211255825d-2*t40+1.0d+0
              t60 = t49+1.923661050931536d+0*t48
              t61 = 8.157414703487641d+0*t54+4.3009724712766434d-1*t53+1
     1           .9115125951273373d-1*t51+2.247591863577616d+0*t40
              t62 = 2.9608813203268075d+1/t61+1.0d+0
              t63 = log(t62)
              t64 = 1.9751631321680768d-2*t59*t60*t63
              t65 = 1.274696188700087d-1*t40+1.0d+0
              t66 = 1.1120374863094686d+1*t54+1.644733775567609d+0*t53+2
     1           .4058712912881916d-1*t51+3.8447462374472113d+0*t40
              t67 = 3.216395899738507d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -5.980796863619711d-2*t43*t44*t48*t65*t68
              t70 = t39*(t69+t64+t58)-rhob*t38-rhoa*t24
              t71 = param(6)
              t72 = 6.0d-2*gammaaa*t2+1.0d+0
              t73 = 1/t72
              t74 = param(7)
              t75 = param(8)
              t76 = param(9)
              t77 = param(10)
              t78 = 6.0d-2*gammaaa*t2*t73*t77+t76
              t79 = 6.0d-2*gammaaa*t2*t73*t78+t75
              t80 = 6.0d-2*gammaaa*t2*t73*t79+t74
              t81 = 6.0d-2*gammaaa*t2*t73*t80+t71
              t82 = 1/taua
              t83 = 1/rhoa
              t84 = 2.0d+0*taua-2.5d-1*gammaaa*t83
              t85 = 6.0d-2*gammabb*t3+1.0d+0
              t86 = 1/t85
              t87 = 6.0d-2*gammabb*t3*t77*t86+t76
              t88 = 6.0d-2*gammabb*t3*t86*t87+t75
              t89 = 6.0d-2*gammabb*t3*t86*t88+t74
              t90 = 6.0d-2*gammabb*t3*t86*t89+t71
              t91 = 1/taub
              t92 = 1/rhob
              t93 = 2.0d+0*taub-2.5d-1*gammabb*t92
              t94 = 1/t21
              t95 = 1/rhoa**1.6666666666666669d+0
              t96 = 1/t12**3
              t97 = 1/rhoa**1.3333333333333333d+0
              t98 = 1/rhoa**1.1666666666666667d+0
              t99 = -9.970917392951799d-1*t98-7.418564737168958d-1*t97-4
     1           .002143174996817d-1*t96-1.264669550498372d-1*t95
              t100 = 1/t20**2
              t101 = 1/t17
              t102 = -1.8533958105157808d+0*t98-1.2815820791490704d+0*t9
     1           7-8.223668877838045d-1*t96-1.6039141941921276d-1*t95
              t103 = 1/t16**2
              t104 = 1.1102230246251565d-16*t100*t23*t94*t99+3.050641144
     1           3514264d-19*t22*t97+1.3210398931339265d-3*t18*t97+1.0d+
     2           0*t101*t102*t103*t19
              t105 = 1/t39**1.6666666666666669d+0
              t106 = 1/t52**3
              t107 = 1/t39**1.3333333333333333d+0
              t108 = 1/t39**1.1666666666666667d+0
              t109 = -9.970917392951799d-1*t108-7.418564737168958d-1*t10
     1           7-4.002143174996817d-1*t106-1.264669550498372d-1*t105
              t110 = 1/t55**2
              t111 = 1/t56
              t112 = 1.0d+0*t109*t110*t111*t41*t50
              t113 = -1.3595691172479402d+0*t108-7.491972878592053d-1*t1
     1           07-2.1504862356383217d-1*t106-1.2743417300848914d-1*t10
     2           5
              t114 = 1/t61**2
              t115 = 1/t62
              t116 = -5.848223622634647d-1*t113*t114*t115*t59*t60
              t117 = -1.8533958105157808d+0*t108-1.2815820791490704d+0*t
     1           107-8.223668877838045d-1*t106-1.6039141941921276d-1*t10
     2           5
              t118 = 1/t66**2
              t119 = 1/t67
              t120 = 1.923661050931536d+0*t117*t118*t119*t43*t44*t48*t65
              t121 = 1/t39**2
              t122 = t121*t42
              t123 = -t45
              t124 = t123+t122
              t125 = t46**3.333333333333333d-1
              t126 = -t121*t42
              t127 = t45+t126
              t128 = t47**3.333333333333333d-1
              t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d
     1           +0*t124*t125
              t130 = -1.923661050931536d+0*t129*t43*t44
              t131 = 1/t39**5
              t132 = 7.694644203726144d+0*t131*t43*t48
              t133 = t42**3
              t134 = -7.694644203726144d+0*t133*t44*t48
              t135 = t134+t132+t130
              t136 = -6.21814d-2*t135*t41*t57
              t137 = 2.747773264188437d-3*t107*t50*t57
              t138 = t134+t132+t130+1.923661050931536d+0*t129
              t139 = 1.9751631321680768d-2*t138*t59*t63
              t140 = -4.5437964274821163d-4*t107*t60*t63
              t141 = -5.980796863619711d-2*t129*t43*t44*t65*t68
              t142 = 1/t39**5.333333333333333d+0
              t143 = 2.541232989148493d-3*t142*t43*t48*t68
              t144 = 2.3923187454478842d-1*t131*t43*t48*t65*t68
              t145 = t69+t39*(-2.3923187454478842d-1*t133*t44*t48*t65*t6
     1           8+t144+t143+t141+t140+t139+t137+t136+t120+t116+t112)+t6
     2           4+t58+6.903522198342671d-18*t22*t23+3.1090699999999993d
     3           -2*t18*t19-rhoa*t104
              t146 = 1/rhoa**3.6666666666666664d+0
              t147 = 1/t5**2
              t148 = 2.562666666666666d-5*gammaaa*t1*t146*t147*t4-8.2666
     1           66666666665d-3*gammaaa*t1*t146*t6
              t149 = -8.266666666666665d-3*gammaaa*t146*t6*t7+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t7+3.1d-3*t148*t4*t6
              t150 = -8.266666666666665d-3*gammaaa*t146*t6*t8+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t8+3.1d-3*t149*t4*t6
              t151 = -8.266666666666665d-3*gammaaa*t146*t6*t9+2.56266666
     1           6666666d-5*gammaaa*t146*t147*t4*t9+3.1d-3*t150*t4*t6
              t152 = gammaaa**2
              t153 = 1/t72**2
              t154 = 1/rhoa**6.333333333333333d+0
              t155 = 9.599999999999997d-3*t152*t153*t154*t77-1.599999999
     1           9999998d-1*gammaaa*t146*t73*t77
              t156 = -1.5999999999999998d-1*gammaaa*t146*t73*t78+9.59999
     1           9999999997d-3*t152*t153*t154*t78+6.0d-2*gammaaa*t155*t2
     2           *t73
              t157 = -1.5999999999999998d-1*gammaaa*t146*t73*t79+9.59999
     1           9999999997d-3*t152*t153*t154*t79+6.0d-2*gammaaa*t156*t2
     2           *t73
              t158 = -1.5999999999999998d-1*gammaaa*t146*t73*t80+9.59999
     1           9999999997d-3*t152*t153*t154*t80+6.0d-2*gammaaa*t157*t2
     2           *t73
              t159 = 1/t35
              t160 = 1/rhob**1.6666666666666669d+0
              t161 = 1/t26**3
              t162 = 1/rhob**1.3333333333333333d+0
              t163 = 1/rhob**1.1666666666666667d+0
              t164 = -9.970917392951799d-1*t163-7.418564737168958d-1*t16
     1           2-4.002143174996817d-1*t161-1.264669550498372d-1*t160
              t165 = 1/t34**2
              t166 = 1/t31
              t167 = -1.8533958105157808d+0*t163-1.2815820791490704d+0*t
     1           162-8.223668877838045d-1*t161-1.6039141941921276d-1*t16
     2           0
              t168 = 1/t30**2
              t169 = 1.1102230246251565d-16*t159*t164*t165*t37+3.0506411
     1           443514264d-19*t162*t36+1.0d+0*t166*t167*t168*t33+1.3210
     2           398931339265d-3*t162*t32
              t170 = t45+t122
              t171 = t126+t123
              t172 = 1.3333333333333333d+0*t128*t171+1.3333333333333333d
     1           +0*t125*t170
              t173 = -1.923661050931536d+0*t172*t43*t44
              t174 = 7.694644203726144d+0*t133*t44*t48
              t175 = t174+t173+t132
              t176 = -6.21814d-2*t175*t41*t57
              t177 = t174+t173+1.923661050931536d+0*t172+t132
              t178 = 1.9751631321680768d-2*t177*t59*t63
              t179 = -5.980796863619711d-2*t172*t43*t44*t65*t68
              t180 = t69+t39*(2.3923187454478842d-1*t133*t44*t48*t65*t68
     1           +t179+t178+t176+t144+t143+t140+t137+t120+t116+t112)+t64
     2           +t58+6.903522198342671d-18*t36*t37+3.1090699999999993d-
     3           2*t32*t33-rhob*t169
              t181 = 1/rhob**3.6666666666666664d+0
              t182 = 2.562666666666666d-5*gammabb*t1*t147*t181*t4-8.2666
     1           66666666665d-3*gammabb*t1*t181*t6
              t183 = -8.266666666666665d-3*gammabb*t181*t6*t7+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t7+3.1d-3*t182*t4*t6
              t184 = -8.266666666666665d-3*gammabb*t181*t6*t8+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t8+3.1d-3*t183*t4*t6
              t185 = -8.266666666666665d-3*gammabb*t181*t6*t9+2.56266666
     1           6666666d-5*gammabb*t147*t181*t4*t9+3.1d-3*t184*t4*t6
              t186 = gammabb**2
              t187 = 1/t85**2
              t188 = 1/rhob**6.333333333333333d+0
              t189 = 9.599999999999997d-3*t186*t187*t188*t77-1.599999999
     1           9999998d-1*gammabb*t181*t77*t86
              t190 = -1.5999999999999998d-1*gammabb*t181*t86*t87+9.59999
     1           9999999997d-3*t186*t187*t188*t87+6.0d-2*gammabb*t189*t3
     2           *t86
              t191 = -1.5999999999999998d-1*gammabb*t181*t86*t88+9.59999
     1           9999999997d-3*t186*t187*t188*t88+6.0d-2*gammabb*t190*t3
     2           *t86
              t192 = -1.5999999999999998d-1*gammabb*t181*t86*t89+9.59999
     1           9999999997d-3*t186*t187*t188*t89+6.0d-2*gammabb*t191*t3
     2           *t86
              t193 = 3.1d-3*t1*t2*t6-9.61d-6*t1*t147*t2*t4
              t194 = 3.1d-3*t2*t6*t7-9.61d-6*t147*t2*t4*t7+3.1d-3*t193*t
     1           4*t6
              t195 = 3.1d-3*t2*t6*t8-9.61d-6*t147*t2*t4*t8+3.1d-3*t194*t
     1           4*t6
              t196 = 3.1d-3*t2*t6*t9-9.61d-6*t147*t2*t4*t9+3.1d-3*t195*t
     1           4*t6
              t197 = -1.25d-1*t24*t81
              t198 = 1/rhoa**5.333333333333333d+0
              t199 = 6.0d-2*t2*t73*t77-3.6d-3*gammaaa*t153*t198*t77
              t200 = 6.0d-2*t2*t73*t78-3.6d-3*gammaaa*t153*t198*t78+6.0d
     1           -2*gammaaa*t199*t2*t73
              t201 = 6.0d-2*t2*t73*t79-3.6d-3*gammaaa*t153*t198*t79+6.0d
     1           -2*gammaaa*t2*t200*t73
              t202 = 6.0d-2*t2*t73*t80-3.6d-3*gammaaa*t153*t198*t80+6.0d
     1           -2*gammaaa*t2*t201*t73
              t203 = 3.1d-3*t1*t3*t6-9.61d-6*t1*t147*t3*t4
              t204 = 3.1d-3*t3*t6*t7-9.61d-6*t147*t3*t4*t7+3.1d-3*t203*t
     1           4*t6
              t205 = 3.1d-3*t3*t6*t8-9.61d-6*t147*t3*t4*t8+3.1d-3*t204*t
     1           4*t6
              t206 = 3.1d-3*t3*t6*t9-9.61d-6*t147*t3*t4*t9+3.1d-3*t205*t
     1           4*t6
              t207 = -1.25d-1*t38*t90
              t208 = 1/rhob**5.333333333333333d+0
              t209 = 6.0d-2*t3*t77*t86-3.6d-3*gammabb*t187*t208*t77
              t210 = 6.0d-2*t3*t86*t87-3.6d-3*gammabb*t187*t208*t87+6.0d
     1           -2*gammabb*t209*t3*t86
              t211 = 6.0d-2*t3*t86*t88-3.6d-3*gammabb*t187*t208*t88+6.0d
     1           -2*gammabb*t210*t3*t86
              t212 = 6.0d-2*t3*t86*t89-3.6d-3*gammabb*t187*t208*t89+6.0d
     1           -2*gammabb*t211*t3*t86
              t213 = 1/taua**2
              t214 = 1/taub**2
              t215 = 1/t21**2
              t216 = t99**2
              t217 = 1/t20**4
              t218 = 1/t20**3
              t219 = 1/t12**5
              t220 = 1/rhoa**2.3333333333333334d+0
              t221 = 1/rhoa**2.1666666666666665d+0
              t222 = 1.1632736958443765d+0*t221+9.89141964955861d-1*t220
     1           +6.003214762495226d-1*t219+2.1077825841639536d-1*t2
              t223 = 1/t17**2
              t224 = t102**2
              t225 = 1/t16**4
              t226 = 1/t16**3
              t227 = 2.1622951122684114d+0*t221+1.7087761055320938d+0*t2
     1           20+1.2335503316757068d+0*t219+2.673190323653546d-1*t2
              t228 = -9.812069668265515d-18*t100*t94*t97*t99-8.497974591
     1           333913d-2*t101*t102*t103*t97+1.1102230246251565d-16*t10
     2           0*t222*t23*t94-2.220446049250313d-16*t216*t218*t23*t94+
     3           1.7854583920998188d-15*t215*t216*t217*t23+1.0d+0*t101*t
     4           103*t19*t227-2.0d+0*t101*t19*t224*t226+3.21639589973850
     5           7d+1*t19*t223*t224*t225-4.0675215258019015d-19*t22*t220
     6           -1.7613865241785684d-3*t18*t220
              t229 = 2.0d+0*t109*t110*t111*t41*t50
              t230 = -1.1696447245269295d+0*t113*t114*t115*t59*t60
              t231 = 3.847322101863072d+0*t117*t118*t119*t43*t44*t48*t65
              t232 = 5.495546528376875d-3*t107*t50*t57
              t233 = -9.087592854964233d-4*t107*t60*t63
              t234 = 5.082465978296986d-3*t142*t43*t48*t68
              t235 = 4.7846374908957684d-1*t131*t43*t48*t65*t68
              t236 = t109**2
              t237 = 1/t55**4
              t238 = 1/t56**2
              t239 = 1.6081979498692536d+1*t236*t237*t238*t41*t50
              t240 = 2.0d+0*t109*t110*t111*t135*t41
              t241 = 1/t55**3
              t242 = -2.0d+0*t111*t236*t241*t41*t50
              t243 = -8.837926660346784d-2*t107*t109*t110*t111*t50
              t244 = 1/t39**2.6666666666666666d+0
              t245 = 1/t52**5
              t246 = 1/t39**2.3333333333333334d+0
              t247 = 1/t39**2.1666666666666665d+0
              t248 = 1.1632736958443765d+0*t247+9.89141964955861d-1*t246
     1           +6.003214762495226d-1*t245+2.1077825841639536d-1*t244
              t249 = 1.0d+0*t110*t111*t248*t41*t50
              t250 = t113**2
              t251 = 1/t61**4
              t252 = 1/t62**2
              t253 = -1.73158960813529d+1*t250*t251*t252*t59*t60
              t254 = -1.1696447245269295d+0*t113*t114*t115*t138*t59
              t255 = 1/t61**3
              t256 = 1.1696447245269295d+0*t115*t250*t255*t59*t60
              t257 = 2.690728393099896d-2*t107*t113*t114*t115*t60
              t258 = 1.5861639701225969d+0*t247+9.98929717145607d-1*t246
     1           +3.2257293534574827d-1*t245+2.1239028834748191d-1*t244
              t259 = -5.848223622634647d-1*t114*t115*t258*t59*t60
              t260 = t117**2
              t261 = 1/t66**4
              t262 = 1/t67**2
              t263 = 6.187255516702861d+1*t260*t261*t262*t43*t44*t48*t65
              t264 = 3.847322101863072d+0*t117*t118*t119*t129*t43*t44*t6
     1           5
              t265 = 1/t66**3
              t266 = -3.847322101863072d+0*t119*t260*t265*t43*t44*t48*t6
     1           5
              t267 = -1.6347222733154887d-1*t117*t118*t119*t142*t43*t48
              t268 = 2.1622951122684114d+0*t247+1.7087761055320938d+0*t2
     1           46+1.2335503316757068d+0*t245+2.673190323653546d-1*t244
              t269 = 1.923661050931536d+0*t118*t119*t268*t43*t44*t48*t65
              t270 = -1.538928840745229d+1*t117*t118*t119*t131*t43*t48*t
     1           65
              t271 = 1.538928840745229d+1*t117*t118*t119*t133*t44*t48*t6
     1           5
              t272 = t124**2
              t273 = 1/t46**6.666666666666666d-1
              t274 = 1/t39**3
              t275 = -2*t274*t42
              t276 = 2*t121
              t277 = t276+t275
              t278 = t127**2
              t279 = 1/t47**6.666666666666666d-1
              t280 = 2*t274*t42
              t281 = -2*t121
              t282 = t281+t280
              t283 = 1.3333333333333333d+0*t128*t282+4.444444444444444d-
     1           1*t278*t279+1.3333333333333333d+0*t125*t277+4.444444444
     2           444444d-1*t272*t273
              t284 = -1.923661050931536d+0*t283*t43*t44
              t285 = 1.5389288407452287d+1*t129*t131*t43
              t286 = -1.5389288407452287d+1*t129*t133*t44
              t287 = 1/t39**6
              t288 = -3.8473221018630716d+1*t287*t43*t48
              t289 = 6.155715362980915d+1*t131*t133*t48
              t290 = t42**2
              t291 = -2.3083932611178434d+1*t290*t44*t48
              t292 = t291+t289+t288+t286+t285+t284
              t293 = -6.21814d-2*t292*t41*t57
              t294 = 5.495546528376875d-3*t107*t135*t57
              t295 = -3.663697685584583d-3*t246*t50*t57
              t296 = t291+t289+t288+t286+t285+t284+1.923661050931536d+0*
     1           t283
              t297 = 1.9751631321680768d-2*t296*t59*t63
              t298 = -9.087592854964233d-4*t107*t138*t63
              t299 = 6.058395236642822d-4*t246*t60*t63
              t300 = -5.980796863619711d-2*t283*t43*t44*t65*t68
              t301 = 5.082465978296986d-3*t129*t142*t43*t68
              t302 = 4.7846374908957684d-1*t129*t131*t43*t65*t68
              t303 = 1/t39**6.333333333333333d+0
              t304 = -2.3718174565385935d-2*t303*t43*t48*t68
              t305 = 2.0329863913187946d-2*t133*t142*t48*t68
              t306 = -1.1961593727239421d+0*t287*t43*t48*t65*t68
              t307 = 1.9138549963583074d+0*t131*t133*t48*t65*t68
              t308 = -7.176956236343652d-1*t290*t44*t48*t65*t68
              t309 = -2.220446049250313d-16*t100*t23*t94*t99-6.101282288
     1           702853d-19*t22*t97-2.642079786267853d-3*t18*t97+t39*(-4
     2           .7846374908957684d-1*t129*t133*t44*t65*t68+t308+t307+t3
     3           06+t305+t304+t302+t301+t300+t299+t298+t297+t295+t294+t2
     4           93+t271+t270+t269+t267+t266+t264+t263+t259+t257+t256+t2
     5           54+t253+t249+t243+t242+t240+t239)-4.7846374908957684d-1
     6           *t133*t44*t48*t65*t68-1.1961593727239421d-1*t129*t43*t4
     7           4*t65*t68+3.9503262643361536d-2*t138*t59*t63-1.243628d-
     8           1*t135*t41*t57+t235+t234+t233+t232+t231+t230+t229-rhoa*
     9           t228-2.0d+0*t101*t102*t103*t19
              t310 = 1/rhoa**7.333333333333333d+0
              t311 = 1/t5**3
              t312 = 1/rhoa**4.666666666666667d+0
              t313 = 3.0311111111111105d-2*gammaaa*t1*t312*t6-9.39644444
     1           4444442d-5*gammaaa*t1*t147*t312*t4+4.2369422222222203d-
     2           7*t1*t152*t310*t311*t4-1.366755555555555d-4*t1*t147*t15
     3           2*t310
              t314 = 3.0311111111111105d-2*gammaaa*t312*t6*t7-9.39644444
     1           4444442d-5*gammaaa*t147*t312*t4*t7+4.2369422222222203d-
     2           7*t152*t310*t311*t4*t7-1.366755555555555d-4*t147*t152*t
     3           310*t7+3.1d-3*t313*t4*t6-1.653333333333333d-2*gammaaa*t
     4           146*t148*t6+5.125333333333332d-5*gammaaa*t146*t147*t148
     5           *t4
              t315 = 3.0311111111111105d-2*gammaaa*t312*t6*t8-9.39644444
     1           4444442d-5*gammaaa*t147*t312*t4*t8+4.2369422222222203d-
     2           7*t152*t310*t311*t4*t8-1.366755555555555d-4*t147*t152*t
     3           310*t8+3.1d-3*t314*t4*t6-1.653333333333333d-2*gammaaa*t
     4           146*t149*t6+5.125333333333332d-5*gammaaa*t146*t147*t149
     5           *t4
              t316 = 3.0311111111111105d-2*gammaaa*t312*t6*t9-9.39644444
     1           4444442d-5*gammaaa*t147*t312*t4*t9+4.2369422222222203d-
     2           7*t152*t310*t311*t4*t9-1.366755555555555d-4*t147*t152*t
     3           310*t9+3.1d-3*t315*t4*t6-1.653333333333333d-2*gammaaa*t
     4           146*t150*t6+5.125333333333332d-5*gammaaa*t146*t147*t150
     5           *t4
              t317 = 1/rhoa**2
              t318 = gammaaa**3
              t319 = 1/t72**3
              t320 = 1/rhoa**10
              t321 = 5.866666666666666d-1*gammaaa*t312*t73*t77+3.0719999
     1           999999986d-3*t318*t319*t320*t77-8.639999999999998d-2*t1
     2           52*t153*t310*t77
              t322 = 5.866666666666666d-1*gammaaa*t312*t73*t78+3.0719999
     1           999999986d-3*t318*t319*t320*t78-8.639999999999998d-2*t1
     2           52*t153*t310*t78+6.0d-2*gammaaa*t2*t321*t73-3.199999999
     3           9999995d-1*gammaaa*t146*t155*t73+1.9199999999999995d-2*
     4           t152*t153*t154*t155
              t323 = 5.866666666666666d-1*gammaaa*t312*t73*t79+3.0719999
     1           999999986d-3*t318*t319*t320*t79-8.639999999999998d-2*t1
     2           52*t153*t310*t79+6.0d-2*gammaaa*t2*t322*t73-3.199999999
     3           9999995d-1*gammaaa*t146*t156*t73+1.9199999999999995d-2*
     4           t152*t153*t154*t156
              t324 = 5.866666666666666d-1*gammaaa*t312*t73*t80+3.0719999
     1           999999986d-3*t318*t319*t320*t80-8.639999999999998d-2*t1
     2           52*t153*t310*t80+6.0d-2*gammaaa*t2*t323*t73-3.199999999
     3           9999995d-1*gammaaa*t146*t157*t73+1.9199999999999995d-2*
     4           t152*t153*t154*t157
              t325 = 2.6666666666666666d+0*t128*t274*t42-2.6666666666666
     1           666d+0*t125*t274*t42+4.444444444444444d-1*t127*t171*t27
     2           9+4.444444444444444d-1*t124*t170*t273
              t326 = -1.923661050931536d+0*t325*t43*t44
              t327 = 7.694644203726144d+0*t131*t172*t43
              t328 = -7.694644203726144d+0*t133*t172*t44
              t329 = 7.694644203726144d+0*t129*t131*t43
              t330 = 7.694644203726144d+0*t129*t133*t44
              t331 = 2.3083932611178434d+1*t290*t44*t48
              t332 = t331+t330+t329+t328+t327+t326+t288
              t333 = t331+t330+t329+t328+t327+t326+1.923661050931536d+0*
     1           t325+t288
              t334 = 7.176956236343652d-1*t290*t44*t48*t65*t68
              t335 = t39*(-5.980796863619711d-2*t325*t43*t44*t65*t68-2.3
     1           923187454478842d-1*t133*t172*t44*t65*t68+2.392318745447
     2           8842d-1*t129*t133*t44*t65*t68+2.3923187454478842d-1*t13
     3           1*t172*t43*t65*t68+2.3923187454478842d-1*t129*t131*t43*
     4           t65*t68+2.541232989148493d-3*t142*t172*t43*t68+2.541232
     5           989148493d-3*t129*t142*t43*t68+1.923661050931536d+0*t11
     6           7*t118*t119*t172*t43*t44*t65+1.923661050931536d+0*t117*
     7           t118*t119*t129*t43*t44*t65+1.9751631321680768d-2*t333*t
     8           59*t63-4.5437964274821163d-4*t107*t177*t63-4.5437964274
     9           821163d-4*t107*t138*t63-5.848223622634647d-1*t113*t114*
     :           t115*t177*t59-5.848223622634647d-1*t113*t114*t115*t138*
     ;           t59-6.21814d-2*t332*t41*t57+2.747773264188437d-3*t107*t
     <           175*t57+2.747773264188437d-3*t107*t135*t57+1.0d+0*t109*
     =           t110*t111*t175*t41+1.0d+0*t109*t110*t111*t135*t41+t334+
     >           t306+t304+t299+t295+t270+t269+t267+t266+t263+t259+t257+
     ?           t256+t253+t249+t243+t242+t239)+t235+t234+t233+t232+t231
     @           +t230+t229+t179+t178+t176+t141+t139+t136
              t336 = 4.2369422222222203d-7*gammaaa*gammabb*t1*t146*t181*
     1           t311*t4-1.366755555555555d-4*gammaaa*gammabb*t1*t146*t1
     2           47*t181
              t337 = 4.2369422222222203d-7*gammaaa*gammabb*t146*t181*t31
     1           1*t4*t7-1.366755555555555d-4*gammaaa*gammabb*t146*t147*
     2           t181*t7+3.1d-3*t336*t4*t6-8.266666666666665d-3*gammaaa*
     3           t146*t182*t6-8.266666666666665d-3*gammabb*t148*t181*t6+
     4           2.562666666666666d-5*gammaaa*t146*t147*t182*t4+2.562666
     5           666666666d-5*gammabb*t147*t148*t181*t4
              t338 = 4.2369422222222203d-7*gammaaa*gammabb*t146*t181*t31
     1           1*t4*t8-1.366755555555555d-4*gammaaa*gammabb*t146*t147*
     2           t181*t8+3.1d-3*t337*t4*t6-8.266666666666665d-3*gammaaa*
     3           t146*t183*t6-8.266666666666665d-3*gammabb*t149*t181*t6+
     4           2.562666666666666d-5*gammaaa*t146*t147*t183*t4+2.562666
     5           666666666d-5*gammabb*t147*t149*t181*t4
              t339 = 4.2369422222222203d-7*gammaaa*gammabb*t146*t181*t31
     1           1*t4*t9-1.366755555555555d-4*gammaaa*gammabb*t146*t147*
     2           t181*t9+3.1d-3*t338*t4*t6-8.266666666666665d-3*gammaaa*
     3           t146*t184*t6-8.266666666666665d-3*gammabb*t150*t181*t6+
     4           2.562666666666666d-5*gammaaa*t146*t147*t184*t4+2.562666
     5           666666666d-5*gammabb*t147*t150*t181*t4
              t340 = 1/t35**2
              t341 = t164**2
              t342 = 1/t34**4
              t343 = 1/t34**3
              t344 = 1/t26**5
              t345 = 1/rhob**2.3333333333333334d+0
              t346 = 1/rhob**2.1666666666666665d+0
              t347 = 1.1632736958443765d+0*t346+9.89141964955861d-1*t345
     1           +6.003214762495226d-1*t344+2.1077825841639536d-1*t3
              t348 = 1/t31**2
              t349 = t167**2
              t350 = 1/t30**4
              t351 = 1/t30**3
              t352 = 2.1622951122684114d+0*t346+1.7087761055320938d+0*t3
     1           45+1.2335503316757068d+0*t344+2.673190323653546d-1*t3
              t353 = 1.1102230246251565d-16*t159*t165*t347*t37-2.2204460
     1           49250313d-16*t159*t341*t343*t37+1.7854583920998188d-15*
     2           t340*t341*t342*t37-4.0675215258019015d-19*t345*t36+1.0d
     3           +0*t166*t168*t33*t352-2.0d+0*t166*t33*t349*t351+3.21639
     4           5899738507d+1*t33*t348*t349*t350-1.7613865241785684d-3*
     5           t32*t345-8.497974591333913d-2*t162*t166*t167*t168-9.812
     6           069668265515d-18*t159*t162*t164*t165
              t354 = 2.0d+0*t109*t110*t111*t175*t41
              t355 = -1.1696447245269295d+0*t113*t114*t115*t177*t59
              t356 = 3.847322101863072d+0*t117*t118*t119*t172*t43*t44*t6
     1           5
              t357 = -1.538928840745229d+1*t117*t118*t119*t133*t44*t48*t
     1           65
              t358 = t170**2
              t359 = t281+t275
              t360 = t171**2
              t361 = t280+t276
              t362 = 1.3333333333333333d+0*t128*t361+4.444444444444444d-
     1           1*t279*t360+1.3333333333333333d+0*t125*t359+4.444444444
     2           444444d-1*t273*t358
              t363 = -1.923661050931536d+0*t362*t43*t44
              t364 = 1.5389288407452287d+1*t131*t172*t43
              t365 = 1.5389288407452287d+1*t133*t172*t44
              t366 = -6.155715362980915d+1*t131*t133*t48
              t367 = t366+t365+t364+t363+t291+t288
              t368 = -6.21814d-2*t367*t41*t57
              t369 = 5.495546528376875d-3*t107*t175*t57
              t370 = t366+t365+t364+t363+1.923661050931536d+0*t362+t291+
     1           t288
              t371 = 1.9751631321680768d-2*t370*t59*t63
              t372 = -9.087592854964233d-4*t107*t177*t63
              t373 = -5.980796863619711d-2*t362*t43*t44*t65*t68
              t374 = 5.082465978296986d-3*t142*t172*t43*t68
              t375 = 4.7846374908957684d-1*t131*t172*t43*t65*t68
              t376 = -2.0329863913187946d-2*t133*t142*t48*t68
              t377 = -1.9138549963583074d+0*t131*t133*t48*t65*t68
              t378 = t39*(4.7846374908957684d-1*t133*t172*t44*t65*t68+t3
     1           77+t376+t375+t374+t373+t372+t371+t369+t368+t357+t356+t3
     2           55+t354+t308+t306+t304+t299+t295+t270+t269+t267+t266+t2
     3           63+t259+t257+t256+t253+t249+t243+t242+t239)+4.784637490
     4           8957684d-1*t133*t44*t48*t65*t68-1.1961593727239421d-1*t
     5           172*t43*t44*t65*t68+3.9503262643361536d-2*t177*t59*t63-
     6           1.243628d-1*t175*t41*t57-2.220446049250313d-16*t159*t16
     7           4*t165*t37-6.101282288702853d-19*t162*t36-rhob*t353-2.0
     8           d+0*t166*t167*t168*t33-2.642079786267853d-3*t162*t32+t2
     9           35+t234+t233+t232+t231+t230+t229
              t379 = 1/rhob**7.333333333333333d+0
              t380 = 1/rhob**4.666666666666667d+0
              t381 = 3.0311111111111105d-2*gammabb*t1*t380*t6-9.39644444
     1           4444442d-5*gammabb*t1*t147*t380*t4+4.2369422222222203d-
     2           7*t1*t186*t311*t379*t4-1.366755555555555d-4*t1*t147*t18
     3           6*t379
              t382 = 3.0311111111111105d-2*gammabb*t380*t6*t7-9.39644444
     1           4444442d-5*gammabb*t147*t380*t4*t7+4.2369422222222203d-
     2           7*t186*t311*t379*t4*t7-1.366755555555555d-4*t147*t186*t
     3           379*t7+3.1d-3*t381*t4*t6-1.653333333333333d-2*gammabb*t
     4           181*t182*t6+5.125333333333332d-5*gammabb*t147*t181*t182
     5           *t4
              t383 = 3.0311111111111105d-2*gammabb*t380*t6*t8-9.39644444
     1           4444442d-5*gammabb*t147*t380*t4*t8+4.2369422222222203d-
     2           7*t186*t311*t379*t4*t8-1.366755555555555d-4*t147*t186*t
     3           379*t8+3.1d-3*t382*t4*t6-1.653333333333333d-2*gammabb*t
     4           181*t183*t6+5.125333333333332d-5*gammabb*t147*t181*t183
     5           *t4
              t384 = 3.0311111111111105d-2*gammabb*t380*t6*t9-9.39644444
     1           4444442d-5*gammabb*t147*t380*t4*t9+4.2369422222222203d-
     2           7*t186*t311*t379*t4*t9-1.366755555555555d-4*t147*t186*t
     3           379*t9+3.1d-3*t383*t4*t6-1.653333333333333d-2*gammabb*t
     4           181*t184*t6+5.125333333333332d-5*gammabb*t147*t181*t184
     5           *t4
              t385 = 1/rhob**2
              t386 = gammabb**3
              t387 = 1/t85**3
              t388 = 1/rhob**10
              t389 = 5.866666666666666d-1*gammabb*t380*t77*t86+3.0719999
     1           999999986d-3*t386*t387*t388*t77-8.639999999999998d-2*t1
     2           86*t187*t379*t77
              t390 = 5.866666666666666d-1*gammabb*t380*t86*t87+3.0719999
     1           999999986d-3*t386*t387*t388*t87-8.639999999999998d-2*t1
     2           86*t187*t379*t87+6.0d-2*gammabb*t3*t389*t86-3.199999999
     3           9999995d-1*gammabb*t181*t189*t86+1.9199999999999995d-2*
     4           t186*t187*t188*t189
              t391 = 5.866666666666666d-1*gammabb*t380*t86*t88+3.0719999
     1           999999986d-3*t386*t387*t388*t88-8.639999999999998d-2*t1
     2           86*t187*t379*t88+6.0d-2*gammabb*t3*t390*t86-3.199999999
     3           9999995d-1*gammabb*t181*t190*t86+1.9199999999999995d-2*
     4           t186*t187*t188*t190
              t392 = 5.866666666666666d-1*gammabb*t380*t86*t89+3.0719999
     1           999999986d-3*t386*t387*t388*t89-8.639999999999998d-2*t1
     2           86*t187*t379*t89+6.0d-2*gammabb*t3*t391*t86-3.199999999
     3           9999995d-1*gammabb*t181*t191*t86+1.9199999999999995d-2*
     4           t186*t187*t188*t191
              t393 = -8.266666666666665d-3*t1*t146*t6-1.5888533333333327
     1           d-7*gammaaa*t1*t154*t311*t4+2.562666666666666d-5*t1*t14
     2           6*t147*t4+5.125333333333332d-5*gammaaa*t1*t147*t154
              t394 = -8.266666666666665d-3*t146*t6*t7-1.5888533333333327
     1           d-7*gammaaa*t154*t311*t4*t7+2.562666666666666d-5*t146*t
     2           147*t4*t7+5.125333333333332d-5*gammaaa*t147*t154*t7+3.1
     3           d-3*t393*t4*t6+3.1d-3*t148*t2*t6-8.266666666666665d-3*g
     4           ammaaa*t146*t193*t6-9.61d-6*t147*t148*t2*t4+2.562666666
     5           666666d-5*gammaaa*t146*t147*t193*t4
              t395 = -8.266666666666665d-3*t146*t6*t8-1.5888533333333327
     1           d-7*gammaaa*t154*t311*t4*t8+2.562666666666666d-5*t146*t
     2           147*t4*t8+5.125333333333332d-5*gammaaa*t147*t154*t8+3.1
     3           d-3*t394*t4*t6+3.1d-3*t149*t2*t6-8.266666666666665d-3*g
     4           ammaaa*t146*t194*t6-9.61d-6*t147*t149*t2*t4+2.562666666
     5           666666d-5*gammaaa*t146*t147*t194*t4
              t396 = -8.266666666666665d-3*t146*t6*t9-1.5888533333333327
     1           d-7*gammaaa*t154*t311*t4*t9+2.562666666666666d-5*t146*t
     2           147*t4*t9+5.125333333333332d-5*gammaaa*t147*t154*t9+3.1
     3           d-3*t395*t4*t6+3.1d-3*t150*t2*t6-8.266666666666665d-3*g
     4           ammaaa*t146*t195*t6-9.61d-6*t147*t150*t2*t4+2.562666666
     5           666666d-5*gammaaa*t146*t147*t195*t4
              t397 = 1.25d-1*t24*t81
              t398 = 1/rhoa**9
              t399 = -1.5999999999999998d-1*t146*t73*t77-1.1519999999999
     1           996d-3*t152*t319*t398*t77+2.879999999999999d-2*gammaaa*
     2           t153*t154*t77
              t400 = -1.5999999999999998d-1*t146*t73*t78-1.1519999999999
     1           996d-3*t152*t319*t398*t78+2.879999999999999d-2*gammaaa*
     2           t153*t154*t78+6.0d-2*gammaaa*t2*t399*t73+6.0d-2*t155*t2
     3           *t73-1.5999999999999998d-1*gammaaa*t146*t199*t73+9.5999
     4           99999999997d-3*t152*t153*t154*t199-3.6d-3*gammaaa*t153*
     5           t155*t198
              t401 = -1.5999999999999998d-1*t146*t73*t79-1.1519999999999
     1           996d-3*t152*t319*t398*t79+2.879999999999999d-2*gammaaa*
     2           t153*t154*t79+6.0d-2*gammaaa*t2*t400*t73-1.599999999999
     3           9998d-1*gammaaa*t146*t200*t73+6.0d-2*t156*t2*t73+9.5999
     4           99999999997d-3*t152*t153*t154*t200-3.6d-3*gammaaa*t153*
     5           t156*t198
              t402 = -1.5999999999999998d-1*t146*t73*t80-1.1519999999999
     1           996d-3*t152*t319*t398*t80+2.879999999999999d-2*gammaaa*
     2           t153*t154*t80+6.0d-2*gammaaa*t2*t401*t73-1.599999999999
     3           9998d-1*gammaaa*t146*t201*t73+6.0d-2*t157*t2*t73+9.5999
     4           99999999997d-3*t152*t153*t154*t201-3.6d-3*gammaaa*t153*
     5           t157*t198
              t403 = 5.125333333333332d-5*gammaaa*t1*t146*t147*t3-1.5888
     1           533333333327d-7*gammaaa*t1*t146*t3*t311*t4
              t404 = -1.5888533333333327d-7*gammaaa*t146*t3*t311*t4*t7+5
     1           .125333333333332d-5*gammaaa*t146*t147*t3*t7+3.1d-3*t4*t
     2           403*t6+3.1d-3*t148*t3*t6-8.266666666666665d-3*gammaaa*t
     3           146*t203*t6-9.61d-6*t147*t148*t3*t4+2.562666666666666d-
     4           5*gammaaa*t146*t147*t203*t4
              t405 = -1.5888533333333327d-7*gammaaa*t146*t3*t311*t4*t8+5
     1           .125333333333332d-5*gammaaa*t146*t147*t3*t8+3.1d-3*t4*t
     2           404*t6+3.1d-3*t149*t3*t6-8.266666666666665d-3*gammaaa*t
     3           146*t204*t6-9.61d-6*t147*t149*t3*t4+2.562666666666666d-
     4           5*gammaaa*t146*t147*t204*t4
              t406 = -1.5888533333333327d-7*gammaaa*t146*t3*t311*t4*t9+5
     1           .125333333333332d-5*gammaaa*t146*t147*t3*t9+3.1d-3*t4*t
     2           405*t6+3.1d-3*t150*t3*t6-8.266666666666665d-3*gammaaa*t
     3           146*t205*t6-9.61d-6*t147*t150*t3*t4+2.562666666666666d-
     4           5*gammaaa*t146*t147*t205*t4
              t407 = 5.125333333333332d-5*gammabb*t1*t147*t181*t2-1.5888
     1           533333333327d-7*gammabb*t1*t181*t2*t311*t4
              t408 = -1.5888533333333327d-7*gammabb*t181*t2*t311*t4*t7+5
     1           .125333333333332d-5*gammabb*t147*t181*t2*t7+3.1d-3*t4*t
     2           407*t6+3.1d-3*t182*t2*t6-8.266666666666665d-3*gammabb*t
     3           181*t193*t6-9.61d-6*t147*t182*t2*t4+2.562666666666666d-
     4           5*gammabb*t147*t181*t193*t4
              t409 = -1.5888533333333327d-7*gammabb*t181*t2*t311*t4*t8+5
     1           .125333333333332d-5*gammabb*t147*t181*t2*t8+3.1d-3*t4*t
     2           408*t6+3.1d-3*t183*t2*t6-8.266666666666665d-3*gammabb*t
     3           181*t194*t6-9.61d-6*t147*t183*t2*t4+2.562666666666666d-
     4           5*gammabb*t147*t181*t194*t4
              t410 = -1.5888533333333327d-7*gammabb*t181*t2*t311*t4*t9+5
     1           .125333333333332d-5*gammabb*t147*t181*t2*t9+3.1d-3*t4*t
     2           409*t6+3.1d-3*t184*t2*t6-8.266666666666665d-3*gammabb*t
     3           181*t195*t6-9.61d-6*t147*t184*t2*t4+2.562666666666666d-
     4           5*gammabb*t147*t181*t195*t4
              t411 = -8.266666666666665d-3*t1*t181*t6-1.5888533333333327
     1           d-7*gammabb*t1*t188*t311*t4+2.562666666666666d-5*t1*t14
     2           7*t181*t4+5.125333333333332d-5*gammabb*t1*t147*t188
              t412 = -8.266666666666665d-3*t181*t6*t7-1.5888533333333327
     1           d-7*gammabb*t188*t311*t4*t7+2.562666666666666d-5*t147*t
     2           181*t4*t7+5.125333333333332d-5*gammabb*t147*t188*t7+3.1
     3           d-3*t4*t411*t6+3.1d-3*t182*t3*t6-8.266666666666665d-3*g
     4           ammabb*t181*t203*t6-9.61d-6*t147*t182*t3*t4+2.562666666
     5           666666d-5*gammabb*t147*t181*t203*t4
              t413 = -8.266666666666665d-3*t181*t6*t8-1.5888533333333327
     1           d-7*gammabb*t188*t311*t4*t8+2.562666666666666d-5*t147*t
     2           181*t4*t8+5.125333333333332d-5*gammabb*t147*t188*t8+3.1
     3           d-3*t4*t412*t6+3.1d-3*t183*t3*t6-8.266666666666665d-3*g
     4           ammabb*t181*t204*t6-9.61d-6*t147*t183*t3*t4+2.562666666
     5           666666d-5*gammabb*t147*t181*t204*t4
              t414 = -8.266666666666665d-3*t181*t6*t9-1.5888533333333327
     1           d-7*gammabb*t188*t311*t4*t9+2.562666666666666d-5*t147*t
     2           181*t4*t9+5.125333333333332d-5*gammabb*t147*t188*t9+3.1
     3           d-3*t4*t413*t6+3.1d-3*t184*t3*t6-8.266666666666665d-3*g
     4           ammabb*t181*t205*t6-9.61d-6*t147*t184*t3*t4+2.562666666
     5           666666d-5*gammabb*t147*t181*t205*t4
              t415 = 1.25d-1*t38*t90
              t416 = 1/rhob**9
              t417 = -1.5999999999999998d-1*t181*t77*t86-1.1519999999999
     1           996d-3*t186*t387*t416*t77+2.879999999999999d-2*gammabb*
     2           t187*t188*t77
              t418 = -1.5999999999999998d-1*t181*t86*t87-1.1519999999999
     1           996d-3*t186*t387*t416*t87+2.879999999999999d-2*gammabb*
     2           t187*t188*t87+6.0d-2*gammabb*t3*t417*t86+6.0d-2*t189*t3
     3           *t86-1.5999999999999998d-1*gammabb*t181*t209*t86+9.5999
     4           99999999997d-3*t186*t187*t188*t209-3.6d-3*gammabb*t187*
     5           t189*t208
              t419 = -1.5999999999999998d-1*t181*t86*t88-1.1519999999999
     1           996d-3*t186*t387*t416*t88+2.879999999999999d-2*gammabb*
     2           t187*t188*t88+6.0d-2*gammabb*t3*t418*t86+6.0d-2*t190*t3
     3           *t86-1.5999999999999998d-1*gammabb*t181*t210*t86+9.5999
     4           99999999997d-3*t186*t187*t188*t210-3.6d-3*gammabb*t187*
     5           t190*t208
              t420 = -1.5999999999999998d-1*t181*t86*t89-1.1519999999999
     1           996d-3*t186*t387*t416*t89+2.879999999999999d-2*gammabb*
     2           t187*t188*t89+6.0d-2*gammabb*t3*t419*t86+6.0d-2*t191*t3
     3           *t86-1.5999999999999998d-1*gammabb*t181*t211*t86+9.5999
     4           99999999997d-3*t186*t187*t188*t211-3.6d-3*gammabb*t187*
     5           t191*t208
              t421 = 5.9582d-8*t1*t198*t311*t4-1.9219999999999998d-5*t1*
     1           t147*t198
              t422 = 5.9582d-8*t198*t311*t4*t7-1.9219999999999998d-5*t14
     1           7*t198*t7+3.1d-3*t4*t421*t6+6.2d-3*t193*t2*t6-1.9219999
     2           999999998d-5*t147*t193*t2*t4
              t423 = 5.9582d-8*t198*t311*t4*t8-1.9219999999999998d-5*t14
     1           7*t198*t8+3.1d-3*t4*t422*t6+6.2d-3*t194*t2*t6-1.9219999
     2           999999998d-5*t147*t194*t2*t4
              t424 = 5.9582d-8*t198*t311*t4*t9-1.9219999999999998d-5*t14
     1           7*t198*t9+3.1d-3*t4*t423*t6+6.2d-3*t195*t2*t6-1.9219999
     2           999999998d-5*t147*t195*t2*t4
              t425 = 1/rhoa**8
              t426 = 4.32d-4*gammaaa*t319*t425*t77-7.2d-3*t153*t198*t77
              t427 = 4.32d-4*gammaaa*t319*t425*t78-7.2d-3*t153*t198*t78+
     1           6.0d-2*gammaaa*t2*t426*t73+1.2d-1*t199*t2*t73-7.2d-3*ga
     2           mmaaa*t153*t198*t199
              t428 = 4.32d-4*gammaaa*t319*t425*t79-7.2d-3*t153*t198*t79+
     1           6.0d-2*gammaaa*t2*t427*t73+1.2d-1*t2*t200*t73-7.2d-3*ga
     2           mmaaa*t153*t198*t200
              t429 = 4.32d-4*gammaaa*t319*t425*t80-7.2d-3*t153*t198*t80+
     1           6.0d-2*gammaaa*t2*t428*t73+1.2d-1*t2*t201*t73-7.2d-3*ga
     2           mmaaa*t153*t198*t201
              t430 = 5.9582d-8*t1*t2*t3*t311*t4-1.9219999999999998d-5*t1
     1           *t147*t2*t3
              t431 = 5.9582d-8*t2*t3*t311*t4*t7-1.9219999999999998d-5*t1
     1           47*t2*t3*t7+3.1d-3*t4*t430*t6+3.1d-3*t193*t3*t6+3.1d-3*
     2           t2*t203*t6-9.61d-6*t147*t193*t3*t4-9.61d-6*t147*t2*t203
     3           *t4
              t432 = 5.9582d-8*t2*t3*t311*t4*t8-1.9219999999999998d-5*t1
     1           47*t2*t3*t8+3.1d-3*t4*t431*t6+3.1d-3*t194*t3*t6+3.1d-3*
     2           t2*t204*t6-9.61d-6*t147*t194*t3*t4-9.61d-6*t147*t2*t204
     3           *t4
              t433 = 5.9582d-8*t2*t3*t311*t4*t9-1.9219999999999998d-5*t1
     1           47*t2*t3*t9+3.1d-3*t4*t432*t6+3.1d-3*t195*t3*t6+3.1d-3*
     2           t2*t205*t6-9.61d-6*t147*t195*t3*t4-9.61d-6*t147*t2*t205
     3           *t4
              t434 = 5.9582d-8*t1*t208*t311*t4-1.9219999999999998d-5*t1*
     1           t147*t208
              t435 = 5.9582d-8*t208*t311*t4*t7-1.9219999999999998d-5*t14
     1           7*t208*t7+3.1d-3*t4*t434*t6+6.2d-3*t203*t3*t6-1.9219999
     2           999999998d-5*t147*t203*t3*t4
              t436 = 5.9582d-8*t208*t311*t4*t8-1.9219999999999998d-5*t14
     1           7*t208*t8+3.1d-3*t4*t435*t6+6.2d-3*t204*t3*t6-1.9219999
     2           999999998d-5*t147*t204*t3*t4
              t437 = 5.9582d-8*t208*t311*t4*t9-1.9219999999999998d-5*t14
     1           7*t208*t9+3.1d-3*t4*t436*t6+6.2d-3*t205*t3*t6-1.9219999
     2           999999998d-5*t147*t205*t3*t4
              t438 = 1/rhob**8
              t439 = 4.32d-4*gammabb*t387*t438*t77-7.2d-3*t187*t208*t77
              t440 = 4.32d-4*gammabb*t387*t438*t87-7.2d-3*t187*t208*t87+
     1           6.0d-2*gammabb*t3*t439*t86+1.2d-1*t209*t3*t86-7.2d-3*ga
     2           mmabb*t187*t208*t209
              t441 = 4.32d-4*gammabb*t387*t438*t88-7.2d-3*t187*t208*t88+
     1           6.0d-2*gammabb*t3*t440*t86+1.2d-1*t210*t3*t86-7.2d-3*ga
     2           mmabb*t187*t208*t210
              t442 = 4.32d-4*gammabb*t387*t438*t89-7.2d-3*t187*t208*t89+
     1           6.0d-2*gammabb*t3*t441*t86+1.2d-1*t211*t3*t86-7.2d-3*ga
     2           mmabb*t187*t208*t211
              t443 = t397-5.0d-1*rhoa*t202*t24*t84
              t444 = t415-5.0d-1*rhob*t212*t38*t93
              t445 = 1/taua**3
              t446 = 1/taub**3
              t447 = 1/rhoa**11
              t448 = 1/t5**4
              t449 = 1/rhoa**8.333333333333334d+0
              t450 = 1/rhoa**5.666666666666667d+0
              t451 = t99**3
              t452 = 1/t12**7
              t453 = 1/rhoa**3.3333333333333337d+0
              t454 = 1/rhoa**3.1666666666666665d+0
              t455 = t102**3
              t456 = -6.661338147750939d-16*t218*t222*t23*t94*t99+1.9624
     1           13933653103d-17*t100*t220*t94*t99+5.356375176299456d-15
     2           *t215*t217*t222*t23*t99-1.4718104502398274d-17*t100*t22
     3           2*t94*t97+2.943620900479655d-17*t216*t218*t94*t97-1.274
     4           696188700087d-1*t101*t103*t227*t97+2.549392377400174d-1
     5           *t101*t224*t226*t97-4.0999275947472624d+0*t223*t224*t22
     6           5*t97-2.3669625486718335d-16*t215*t216*t217*t97+1.11022
     7           30246251565d-16*t100*t23*(-2.520426340996149d+0*t454-2.
     8           3079979182303428d+0*t453-1.5008036906238065d+0*t452-5.6
     9           20753557770543d-1*t146)*t94+6.661338147750939d-16*t217*
     :           t23*t451*t94+6.0d+0*t101*t19*t225*t455-1.92983753984310
     ;           45d+2*t19*t223*t455/t16**5+2.0690405167709364d+3*t19*t4
     <           55/(t16**6*t17**3)+1.0d+0*t101*t103*t19*(-4.68497274324
     =           8224d+0*t454-3.9871442462415524d+0*t453-3.0838758291892
     >           67d+0*t452-7.128507529742789d-1*t146)+9.490883560204437
     ?           d-19*t22*t453+4.1099018897499934d-3*t18*t453-1.07127503
     @           52598913d-14*t215*t23*t451/t20**5+5.742741051503565d-14
     1           *t23*t451/(t20**6*t21**3)-6.0d+0*t101*t102*t19*t226*t22
     2           7+9.649187699215522d+1*t102*t19*t223*t225*t227+1.699594
     3           9182667827d-1*t101*t102*t103*t220
              t457 = 4.824593849607761d+1*t236*t237*t238*t41*t50
              t458 = -6.0d+0*t111*t236*t241*t41*t50
              t459 = -2.6513779981040353d-1*t107*t109*t110*t111*t50
              t460 = 3.0d+0*t110*t111*t248*t41*t50
              t461 = -5.19476882440587d+1*t250*t251*t252*t59*t60
              t462 = 3.5089341735807883d+0*t115*t250*t255*t59*t60
              t463 = 8.072185179299687d-2*t107*t113*t114*t115*t60
              t464 = -1.7544670867903941d+0*t114*t115*t258*t59*t60
              t465 = 1.856176655010858d+2*t260*t261*t262*t43*t44*t48*t65
              t466 = -1.1541966305589217d+1*t119*t260*t265*t43*t44*t48*t
     1           65
              t467 = -4.904166819946466d-1*t117*t118*t119*t142*t43*t48
              t468 = 5.770983152794609d+0*t118*t119*t268*t43*t44*t48*t65
              t469 = -4.616786522235687d+1*t117*t118*t119*t131*t43*t48*t
     1           65
              t470 = -1.099109305675375d-2*t246*t50*t57
              t471 = 1.8175185709928465d-3*t246*t60*t63
              t472 = -7.11545236961578d-2*t303*t43*t48*t68
              t473 = -3.588478118171826d+0*t287*t43*t48*t65*t68
              t474 = -2.1530868709030954d+0*t290*t44*t48*t65*t68
              t475 = t109**3
              t476 = 5.172601291927341d+2*t41*t475*t50/(t55**6*t56**3)
              t477 = -9.649187699215522d+1*t238*t41*t475*t50/t55**5
              t478 = 4.824593849607761d+1*t109*t237*t238*t248*t41*t50
              t479 = -2.1319703304396778d+0*t107*t236*t237*t238*t50
              t480 = 6.0d+0*t111*t237*t41*t475*t50
              t481 = -6.0d+0*t109*t111*t241*t248*t41*t50
              t482 = 2.6513779981040353d-1*t107*t111*t236*t241*t50
              t483 = -1.3256889990520176d-1*t107*t110*t111*t248*t50
              t484 = 1.767585332069357d-1*t109*t110*t111*t246*t50
              t485 = 1/t39**3.6666666666666664d+0
              t486 = 1/t52**7
              t487 = 1/t39**3.3333333333333337d+0
              t488 = 1/t39**3.1666666666666665d+0
              t489 = 1.0d+0*t110*t111*t41*(-2.520426340996149d+0*t488-2.
     1           3079979182303428d+0*t487-1.5008036906238065d+0*t486-5.6
     2           20753557770543d-1*t485)*t50
              t490 = t113**3
              t491 = -1.0254062650399592d+3*t490*t59*t60/(t61**6*t62**3)
              t492 = 1.0389537648811739d+2*t252*t490*t59*t60/t61**5
              t493 = -5.19476882440587d+1*t113*t251*t252*t258*t59*t60
              t494 = 1.1950391155803675d+0*t107*t250*t251*t252*t60
              t495 = -3.5089341735807883d+0*t115*t251*t490*t59*t60
              t496 = 3.5089341735807883d+0*t113*t115*t255*t258*t59*t60
              t497 = -8.072185179299687d-2*t107*t115*t250*t255*t60
              t498 = 4.0360925896498434d-2*t107*t114*t115*t258*t60
              t499 = -5.381456786199791d-2*t113*t114*t115*t246*t60
              t500 = -5.848223622634647d-1*t114*t115*(-3.436688601932293
     1           d+0*t488-2.3308360066730832d+0*t487-8.064323383643707d-
     2           1*t486-5.663741022599518d-1*t485)*t59*t60
              t501 = t117**3
              t502 = 3.9801326549115085d+3*t43*t44*t48*t501*t65/(t66**6*
     1           t67**3)
              t503 = -3.712353310021716d+2*t262*t43*t44*t48*t501*t65/t66
     1           **5
              t504 = 1.856176655010858d+2*t117*t261*t262*t268*t43*t44*t4
     1           8*t65
              t505 = -7.424706620043432d+2*t131*t260*t261*t262*t43*t48*t
     1           65
              t506 = -7.886871025654724d+0*t142*t260*t261*t262*t43*t48
              t507 = 1.1541966305589217d+1*t119*t261*t43*t44*t48*t501*t6
     1           5
              t508 = -1.1541966305589217d+1*t117*t119*t265*t268*t43*t44*
     1           t48*t65
              t509 = 4.616786522235687d+1*t119*t131*t260*t265*t43*t48*t6
     1           5
              t510 = 4.904166819946466d-1*t119*t142*t260*t265*t43*t48
              t511 = -2.452083409973233d-1*t118*t119*t142*t268*t43*t48
              t512 = 2.2886111826416838d+0*t117*t118*t119*t303*t43*t48
              t513 = 1.923661050931536d+0*t118*t119*t43*t44*t48*(-4.6849
     1           72743248224d+0*t488-3.9871442462415524d+0*t487-3.083875
     2           829189267d+0*t486-7.128507529742789d-1*t485)*t65
              t514 = -2.3083932611178434d+1*t118*t119*t131*t268*t43*t48*
     1           t65
              t515 = 1.1541966305589217d+2*t117*t118*t119*t287*t43*t48*t
     1           65
              t516 = 6.925179783353531d+1*t117*t118*t119*t290*t44*t48*t6
     1           5
              t517 = 8.548627933030694d-3*t487*t50*t57
              t518 = 1/t46**1.6666666666666669d+0
              t519 = 6*t42*t44
              t520 = -6*t274
              t521 = 1/t47**1.6666666666666669d+0
              t522 = -6*t42*t44
              t523 = 6*t274
              t524 = 1.3333333333333333d+0*t128*(t523+t522)-2.9629629629
     1           62963d-1*t127**3*t521+1.3333333333333333d+0*t125*(t520+
     2           t519)-2.962962962962963d-1*t124**3*t518+1.3333333333333
     3           333d+0*t127*t279*t282+1.3333333333333333d+0*t124*t273*t
     4           277
              t525 = -1.923661050931536d+0*t43*t44*t524
              t526 = 2.3083932611178434d+1*t131*t283*t43
              t527 = -2.3083932611178434d+1*t133*t283*t44
              t528 = -1.1541966305589216d+2*t129*t287*t43
              t529 = 1.8467146088942746d+2*t129*t131*t133
              t530 = -6.925179783353531d+1*t129*t290*t44
              t531 = 1/t39**7
              t532 = 2.3083932611178432d+2*t43*t48*t531
              t533 = -4.6167865222356863d+2*t133*t287*t48
              t534 = 2.770071913341412d+2*t131*t290*t48
              t535 = -4.616786522235687d+1*t42*t44*t48
              t536 = -1.4136255552166585d-3*t487*t60*t63
              t537 = 2.0103976536374746d-1*t43*t48*t68/t39**7.3333333333
     1           33333d+0
              t538 = 9.148438760934575d-2*t142*t290*t48*t68
              t539 = 7.176956236343652d+0*t43*t48*t531*t65*t68
              t540 = 8.612347483612381d+0*t131*t290*t48*t65*t68
              t541 = -1.4353912472687305d+0*t42*t44*t48*t65*t68
              t542 = 1/rhoa**3
              t543 = gammaaa**4
              t544 = 1/t72**4
              t545 = 1/rhoa**1.3666666666666666d+1
              t546 = -1.243628d-1*t332*t41*t57
              t547 = 3.9503262643361536d-2*t333*t59*t63
              t548 = -1.1961593727239421d-1*t325*t43*t44*t65*t68
              t549 = 2.0d+0*t109*t110*t111*t332*t41
              t550 = -1.1696447245269295d+0*t113*t114*t115*t333*t59
              t551 = 3.847322101863072d+0*t117*t118*t119*t325*t43*t44*t6
     1           5
              t552 = -2.3083932611178434d+1*t117*t118*t119*t290*t44*t48*
     1           t65
              t553 = 5.495546528376875d-3*t107*t332*t57
              t554 = 1.5389288407452287d+1*t131*t325*t43
              t555 = -1.5389288407452287d+1*t133*t325*t44
              t556 = 1.3333333333333333d+0*t128*(t522+2*t274)-2.96296296
     1           2962963d-1*t171*t278*t521+1.3333333333333333d+0*t125*(t
     2           519-2*t274)-2.962962962962963d-1*t170*t272*t518+1.77777
     3           77777777776d+0*t127*t274*t279*t42-1.7777777777777776d+0
     4           *t124*t273*t274*t42+4.444444444444444d-1*t171*t279*t282
     5           +4.444444444444444d-1*t170*t273*t277
              t557 = -1.923661050931536d+0*t43*t44*t556
              t558 = 7.694644203726144d+0*t131*t283*t43
              t559 = 7.694644203726144d+0*t133*t283*t44
              t560 = -3.8473221018630716d+1*t172*t287*t43
              t561 = 6.155715362980915d+1*t131*t133*t172
              t562 = -2.3083932611178434d+1*t172*t290*t44
              t563 = -7.694644203726143d+1*t129*t287*t43
              t564 = 4.616786522235687d+1*t129*t290*t44
              t565 = -1.5389288407452287d+2*t133*t287*t48
              t566 = -9.233573044471374d+1*t131*t290*t48
              t567 = 4.616786522235687d+1*t42*t44*t48
              t568 = -9.087592854964233d-4*t107*t333*t63
              t569 = 5.082465978296986d-3*t142*t325*t43*t68
              t570 = 4.7846374908957684d-1*t131*t325*t43*t65*t68
              t571 = -2.870782494537461d+0*t131*t290*t48*t65*t68
              t572 = 1.4353912472687305d+0*t42*t44*t48*t65*t68
              t573 = -2.962962962962963d-1*t127*t360*t521-2.962962962962
     1           963d-1*t124*t358*t518-8*t128*t42*t44+8*t125*t42*t44+1.7
     2           777777777777776d+0*t171*t274*t279*t42-1.777777777777777
     3           6d+0*t170*t273*t274*t42+4.444444444444444d-1*t127*t279*
     4           t361+4.444444444444444d-1*t124*t273*t359-2.666666666666
     5           6666d+0*t128*t274+2.6666666666666666d+0*t125*t274
              t574 = -1.923661050931536d+0*t43*t44*t573
              t575 = 1.5389288407452287d+1*t133*t325*t44
              t576 = 7.694644203726144d+0*t131*t362*t43
              t577 = -7.694644203726144d+0*t133*t362*t44
              t578 = -7.694644203726143d+1*t172*t287*t43
              t579 = 4.616786522235687d+1*t172*t290*t44
              t580 = -3.8473221018630716d+1*t129*t287*t43
              t581 = -6.155715362980915d+1*t129*t131*t133
              t582 = -2.3083932611178434d+1*t129*t290*t44
              t583 = 1.5389288407452287d+2*t133*t287*t48
              t584 = 1/rhob**11
              t585 = 1/rhob**8.333333333333334d+0
              t586 = 1/rhob**5.666666666666667d+0
              t587 = t164**3
              t588 = 1/t26**7
              t589 = 1/rhob**3.3333333333333337d+0
              t590 = 1/rhob**3.1666666666666665d+0
              t591 = t167**3
              t592 = 6.0d+0*t166*t33*t350*t591-1.9298375398431045d+2*t33
     1           *t348*t591/t30**5+2.0690405167709364d+3*t33*t591/(t30**
     2           6*t31**3)+1.1102230246251565d-16*t159*t165*t37*(-2.5204
     3           26340996149d+0*t590-2.3079979182303428d+0*t589-1.500803
     4           6906238065d+0*t588-5.620753557770543d-1*t181)+1.0d+0*t1
     5           66*t168*t33*(-4.684972743248224d+0*t590-3.9871442462415
     6           524d+0*t589-3.083875829189267d+0*t588-7.128507529742789
     7           d-1*t181)+9.490883560204437d-19*t36*t589+4.109901889749
     8           9934d-3*t32*t589+5.742741051503565d-14*t37*t587/(t34**6
     9           *t35**3)+6.661338147750939d-16*t159*t342*t37*t587-1.071
     :           2750352598913d-14*t340*t37*t587/t34**5-6.66133814775093
     ;           9d-16*t159*t164*t343*t347*t37+5.356375176299456d-15*t16
     <           4*t340*t342*t347*t37-6.0d+0*t166*t167*t33*t351*t352+9.6
     =           49187699215522d+1*t167*t33*t348*t350*t352-1.27469618870
     >           0087d-1*t162*t166*t168*t352+2.549392377400174d-1*t162*t
     ?           166*t349*t351-4.0999275947472624d+0*t162*t348*t349*t350
     @           -1.4718104502398274d-17*t159*t162*t165*t347+1.699594918
     1           2667827d-1*t166*t167*t168*t345+1.962413933653103d-17*t1
     2           59*t164*t165*t345+2.943620900479655d-17*t159*t162*t341*
     3           t343-2.3669625486718335d-16*t162*t340*t341*t342
              t593 = 1.3333333333333333d+0*t125*(t523+t519)+1.3333333333
     1           333333d+0*t128*(t522+t520)-2.962962962962963d-1*t171**3
     2           *t521-2.962962962962963d-1*t170**3*t518+1.3333333333333
     3           333d+0*t171*t279*t361+1.3333333333333333d+0*t170*t273*t
     4           359
              t594 = -1.923661050931536d+0*t43*t44*t593
              t595 = 2.3083932611178434d+1*t131*t362*t43
              t596 = 2.3083932611178434d+1*t133*t362*t44
              t597 = -1.1541966305589216d+2*t172*t287*t43
              t598 = -1.8467146088942746d+2*t131*t133*t172
              t599 = -6.925179783353531d+1*t172*t290*t44
              t600 = 4.6167865222356863d+2*t133*t287*t48
              t601 = 1/rhob**3
              t602 = gammabb**4
              t603 = 1/t85**4
              t604 = 1/rhob**1.3666666666666666d+1
              t605 = t197-1.25d-1*gammaaa*t202*t24
              t606 = 1.25d-1*t104*t81
              t607 = 1.25d-1*t158*t24
              t608 = 1/rhoa**1.2666666666666665d+1
              t609 = t207-1.25d-1*gammabb*t212*t38
              t610 = 1.25d-1*t169*t90
              t611 = 1.25d-1*t192*t38
              t612 = 1/rhob**1.2666666666666665d+1
              t613 = 2.5d-1*t202*t24
              t614 = 1/rhoa**1.1666666666666665d+1
              t615 = 2.5d-1*t212*t38
              t616 = 1/rhob**1.1666666666666665d+1
              t617 = 1/rhoa**1.0666666666666666d+1
              t618 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhob*t38*t90*t91*t93+5.0d-1*rhoa*t24*t81
     1           *t82*t84+1.0d+0*t10*t70)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t82*(5.0d-1*t24*t81*t84+5.0d-1*rhoa*t104
     1           *t81*t84+5.0d-1*rhoa*t158*t24*t84)+1.25d-1*gammaaa*t24*
     2           t81*t82*t83+1.0d+0*t151*t70+1.0d+0*t10*t145)*wght+Amat(
     3           iq,D1_RA)
              Amat(iq,D1_RB) = (t91*(5.0d-1*t38*t90*t93+5.0d-1*rhob*t169
     1           *t90*t93+5.0d-1*rhob*t192*t38*t93)+1.25d-1*gammabb*t38*
     2           t90*t91*t92+1.0d+0*t185*t70+1.0d+0*t10*t180)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = (t82*(5.0d-1*rhoa*t202*t24*t84+t197)+1.0
     1           d+0*t196*t70)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t91*(5.0d-1*rhob*t212*t38*t93+t207)+1.0
     1           d+0*t206*t70)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t24*t81*t82-5.0d-1*rhoa*t213
     1           *t24*t81*t84)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t38*t90*t91-5.0d-1*rhob*t214
     1           *t38*t90*t93)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t82*(5.0d-1*rhoa*t228*t81*t84+1.0d+0
     1           *t104*t81*t84+5.0d-1*rhoa*t24*t324*t84+1.0d+0*t158*t24*
     2           t84+1.0d+0*rhoa*t104*t158*t84+1.25d-1*gammaaa*t104*t81*
     3           t83+1.25d-1*gammaaa*t158*t24*t83+1.25d-1*gammaaa*t24*t3
     4           17*t81)+(1.25d-1*gammaaa*t104*t81+1.25d-1*gammaaa*t158*
     5           t24)*t82*t83-1.25d-1*gammaaa*t24*t317*t81*t82+1.0d+0*t3
     6           16*t70+1.0d+0*t10*t309+2.0d+0*t145*t151)*wght+Amat2(iq,
     7           D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t339*t70+1.0d+0*t10*t335+1.0d
     1           +0*t145*t185+1.0d+0*t151*t180)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t91*(5.0d-1*rhob*t353*t90*t93+1.0d+0
     1           *t169*t90*t93+5.0d-1*rhob*t38*t392*t93+1.0d+0*t192*t38*
     2           t93+1.0d+0*rhob*t169*t192*t93+1.25d-1*gammabb*t169*t90*
     3           t92+1.25d-1*gammabb*t192*t38*t92+1.25d-1*gammabb*t38*t3
     4           85*t90)+(1.25d-1*gammabb*t169*t90+1.25d-1*gammabb*t192*
     5           t38)*t91*t92-1.25d-1*gammabb*t38*t385*t90*t91+1.0d+0*t3
     6           84*t70+1.0d+0*t10*t378+2.0d+0*t180*t185)*wght+Amat2(iq,
     7           D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t82*(5.0d-1*rhoa*t24*t402*t84+5.0d-
     1           1*t202*t24*t84+5.0d-1*rhoa*t104*t202*t84-1.25d-1*t24*t8
     2           1*t83-1.25d-1*t104*t81-1.25d-1*t158*t24)+(t397+1.25d-1*
     3           gammaaa*t202*t24)*t82*t83+1.0d+0*t396*t70+1.0d+0*t145*t
     4           196)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t406*t70+1.0d+0*t145*t206)*w
     1           ght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t410*t70+1.0d+0*t180*t196)*w
     1           ght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t91*(5.0d-1*rhob*t38*t420*t93+5.0d-
     1           1*t212*t38*t93+5.0d-1*rhob*t169*t212*t93-1.25d-1*t38*t9
     2           0*t92-1.25d-1*t169*t90-1.25d-1*t192*t38)+(t415+1.25d-1*
     3           gammabb*t212*t38)*t91*t92+1.0d+0*t414*t70+1.0d+0*t180*t
     4           206)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t82*(5.0d-1*rhoa*t24*t429*t84-2.5d
     1           -1*t202*t24)+1.0d+0*t424*t70)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t433*t70*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t91*(5.0d-1*rhob*t38*t442*t93-2.5d
     1           -1*t212*t38)+1.0d+0*t437*t70)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t213*(-5.0d-1*t24*t81*t84-5.0d-1*rho
     1           a*t104*t81*t84-5.0d-1*rhoa*t158*t24*t84)-1.25d-1*gammaa
     2           a*t213*t24*t81*t83+(1.0d+0*t24*t81+1.0d+0*rhoa*t104*t81
     3           +1.0d+0*rhoa*t158*t24)*t82)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t214*(-5.0d-1*t38*t90*t93-5.0d-1*rho
     1           b*t169*t90*t93-5.0d-1*rhob*t192*t38*t93)-1.25d-1*gammab
     2           b*t214*t38*t90*t92+(1.0d+0*t38*t90+1.0d+0*rhob*t169*t90
     3           +1.0d+0*rhob*t192*t38)*t91)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t202*t24*t82+t213*t443)
     1           *wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*rhob*t212*t38*t91+t214*t444)
     1           *wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t24*t445*t81*t84-2.0d+0*
     1           rhoa*t213*t24*t81)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t38*t446*t90*t93-2.0d+0*
     1           rhob*t214*t38*t90)*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t10*(2.943620900479655d-17
     1           *t100*t94*t97*t99+2.549392377400174d-1*t101*t102*t103*t
     2           97-3.3306690738754696d-16*t100*t222*t23*t94+6.661338147
     3           750939d-16*t216*t218*t23*t94+t39*(-5.980796863619711d-2
     4           *t43*t44*t524*t65*t68-1.4353912472687305d+1*t133*t287*t
     5           48*t65*t68-2.1530868709030954d+0*t129*t290*t44*t65*t68-
     6           7.176956236343652d-1*t133*t283*t44*t65*t68-3.5884781181
     7           71826d+0*t129*t287*t43*t65*t68+7.176956236343652d-1*t13
     8           1*t283*t43*t65*t68+5.741564989074922d+0*t129*t131*t133*
     9           t65*t68-2.8461809478463124d-1*t133*t303*t48*t68-7.11545
     :           236961578d-2*t129*t303*t43*t68+7.623698967445479d-3*t14
     ;           2*t283*t43*t68+6.098959173956384d-2*t129*t133*t142*t68+
     <           2.3083932611178434d+1*t118*t119*t133*t268*t44*t48*t65-4
     =           .616786522235687d+1*t119*t133*t260*t265*t44*t48*t65+7.4
     >           24706620043432d+2*t133*t260*t261*t262*t44*t48*t65-1.846
     ?           7146088942746d+2*t117*t118*t119*t131*t133*t48*t65+5.770
     @           983152794609d+0*t117*t118*t119*t283*t43*t44*t65+5.77098
     1           3152794609d+0*t118*t119*t129*t268*t43*t44*t65-1.1541966
     2           305589217d+1*t119*t129*t260*t265*t43*t44*t65+1.85617665
     3           5010858d+2*t129*t260*t261*t262*t43*t44*t65+4.6167865222
     4           35687d+1*t117*t118*t119*t129*t133*t44*t65-4.61678652223
     5           5687d+1*t117*t118*t119*t129*t131*t43*t65+1.975163132168
     6           0768d-2*(t535+t534+t533+t532+t530+t529+t528+t527+t526+t
     7           525+1.923661050931536d+0*t524)*t59*t63-1.36313892824463
     8           5d-3*t107*t296*t63+1.8175185709928465d-3*t138*t246*t63-
     9           1.7544670867903941d+0*t113*t114*t115*t296*t59-1.7544670
     :           867903941d+0*t114*t115*t138*t258*t59+3.5089341735807883
     ;           d+0*t115*t138*t250*t255*t59-5.19476882440587d+1*t138*t2
     <           50*t251*t252*t59-6.21814d-2*t41*(t535+t534+t533+t532+t5
     =           30+t529+t528+t527+t526+t525)*t57+8.243319792565312d-3*t
     >           107*t292*t57-1.099109305675375d-2*t135*t246*t57+t541+t5
     ?           40+t539+t538+t537+t536+t517+t516+t515+t514+t513+t512+t5
     @           11+t510+t509+t508+t507+t506+t505+t504+t503+t502+t500+t4
     1           99+t498+t497+t496+t495+t494+t493+t492+t491+t489+t484+t4
     2           83+t482+t481+t480-1.9616667279785865d+0*t117*t118*t119*
     3           t133*t142*t48+t479+t478+t477+t476-4.904166819946466d-1*
     4           t117*t118*t119*t129*t142*t43+3.0d+0*t109*t110*t111*t292
     5           *t41+3.0d+0*t110*t111*t135*t248*t41-6.0d+0*t111*t135*t2
     6           36*t241*t41+4.824593849607761d+1*t135*t236*t237*t238*t4
     7           1+8.072185179299687d-2*t107*t113*t114*t115*t138-2.65137
     8           79981040353d-1*t107*t109*t110*t111*t135)+5.741564989074
     9           922d+0*t131*t133*t48*t65*t68-1.794239059085913d-1*t283*
     :           t43*t44*t65*t68-1.4353912472687305d+0*t129*t133*t44*t65
     ;           *t68+1.4353912472687305d+0*t129*t131*t43*t65*t68+6.0989
     <           59173956384d-2*t133*t142*t48*t68+1.524739793489096d-2*t
     =           129*t142*t43*t68+4.616786522235687d+1*t117*t118*t119*t1
     >           33*t44*t48*t65+1.1541966305589217d+1*t117*t118*t119*t12
     ?           9*t43*t44*t65+5.92548939650423d-2*t296*t59*t63-2.726277
     @           85648927d-3*t107*t138*t63-3.5089341735807883d+0*t113*t1
     1           14*t115*t138*t59-1.865442d-1*t292*t41*t57+1.64866395851
     2           30625d-2*t107*t135*t57+t474+t473+t472+t471+t470+t469+t4
     3           68+t467+t466+t465+t464+t463+t462+t461+t460+t459+t458+t4
     4           57-rhoa*t456+6.0d+0*t109*t110*t111*t135*t41-5.356375176
     5           299456d-15*t215*t216*t217*t23-3.0d+0*t101*t103*t19*t227
     6           +6.0d+0*t101*t19*t224*t226-9.649187699215522d+1*t19*t22
     7           3*t224*t225+1.2202564577405706d-18*t22*t220+5.284159572
     8           535705d-3*t18*t220)+1.0d+0*t70*(-1.4145185185185183d-1*
     9           gammaaa*t450*t6*t9+4.3850074074074064d-4*gammaaa*t147*t
     :           4*t450*t9-4.6606364444444426d-6*t152*t311*t4*t449*t9+1.
     ;           5034311111111107d-3*t147*t152*t449*t9+1.050761671111110
     <           5d-8*t318*t4*t447*t448*t9-3.389553777777776d-6*t311*t31
     =           8*t447*t9+3.1d-3*t4*t6*(-1.4145185185185183d-1*gammaaa*
     >           t450*t6*t8+4.3850074074074064d-4*gammaaa*t147*t4*t450*t
     ?           8-4.6606364444444426d-6*t152*t311*t4*t449*t8+1.50343111
     @           11111107d-3*t147*t152*t449*t8+1.0507616711111105d-8*t31
     1           8*t4*t447*t448*t8-3.389553777777776d-6*t311*t318*t447*t
     2           8+3.1d-3*t4*t6*(-1.4145185185185183d-1*gammaaa*t450*t6*
     3           t7+4.3850074074074064d-4*gammaaa*t147*t4*t450*t7-4.6606
     4           364444444426d-6*t152*t311*t4*t449*t7+1.5034311111111107
     5           d-3*t147*t152*t449*t7+1.0507616711111105d-8*t318*t4*t44
     6           7*t448*t7-3.389553777777776d-6*t311*t318*t447*t7+3.1d-3
     7           *t4*t6*(-1.4145185185185183d-1*gammaaa*t1*t450*t6+4.385
     8           0074074074064d-4*gammaaa*t1*t147*t4*t450-4.660636444444
     9           4426d-6*t1*t152*t311*t4*t449+1.5034311111111107d-3*t1*t
     :           147*t152*t449+1.0507616711111105d-8*t1*t318*t4*t447*t44
     ;           8-3.389553777777776d-6*t1*t311*t318*t447)-2.47999999999
     <           99994d-2*gammaaa*t146*t313*t6+9.093333333333331d-2*gamm
     =           aaa*t148*t312*t6+7.687999999999998d-5*gammaaa*t146*t147
     >           *t313*t4-2.818933333333332d-4*gammaaa*t147*t148*t312*t4
     ?           +1.271082666666666d-6*t148*t152*t310*t311*t4-4.10026666
     @           6666665d-4*t147*t148*t152*t310)-2.4799999999999994d-2*g
     1           ammaaa*t146*t314*t6+9.093333333333331d-2*gammaaa*t149*t
     2           312*t6+7.687999999999998d-5*gammaaa*t146*t147*t314*t4-2
     3           .818933333333332d-4*gammaaa*t147*t149*t312*t4+1.2710826
     4           66666666d-6*t149*t152*t310*t311*t4-4.100266666666665d-4
     5           *t147*t149*t152*t310)-2.4799999999999994d-2*gammaaa*t14
     6           6*t315*t6+9.093333333333331d-2*gammaaa*t150*t312*t6+7.6
     7           87999999999998d-5*gammaaa*t146*t147*t315*t4-2.818933333
     8           333332d-4*gammaaa*t147*t150*t312*t4+1.271082666666666d-
     9           6*t150*t152*t310*t311*t4-4.100266666666665d-4*t147*t150
     :           *t152*t310)+t82*(5.0d-1*rhoa*t456*t81*t84+1.5d+0*t228*t
     ;           81*t84+5.0d-1*rhoa*t24*(-2.737777777777778d+0*gammaaa*t
     <           450*t73*t80+1.4745599999999992d-3*t543*t544*t545*t80+7.
     =           274666666666665d-1*t152*t153*t449*t80-5.836799999999998
     >           d-2*t318*t319*t447*t80+6.0d-2*gammaaa*t2*t73*(-2.737777
     ?           777777778d+0*gammaaa*t450*t73*t79+1.4745599999999992d-3
     @           *t543*t544*t545*t79+7.274666666666665d-1*t152*t153*t449
     1           *t79-5.836799999999998d-2*t318*t319*t447*t79+6.0d-2*gam
     2           maaa*t2*t73*(-2.737777777777778d+0*gammaaa*t450*t73*t78
     3           +1.4745599999999992d-3*t543*t544*t545*t78+7.27466666666
     4           6665d-1*t152*t153*t449*t78-5.836799999999998d-2*t318*t3
     5           19*t447*t78+6.0d-2*gammaaa*t2*t73*(-2.737777777777778d+
     6           0*gammaaa*t450*t73*t77+1.4745599999999992d-3*t543*t544*
     7           t545*t77+7.274666666666665d-1*t152*t153*t449*t77-5.8367
     8           99999999998d-2*t318*t319*t447*t77)-4.799999999999999d-1
     9           *gammaaa*t146*t321*t73+1.76d+0*gammaaa*t155*t312*t73+2.
     :           879999999999999d-2*t152*t153*t154*t321+9.21599999999999
     ;           6d-3*t155*t318*t319*t320-2.5919999999999993d-1*t152*t15
     <           3*t155*t310)-4.799999999999999d-1*gammaaa*t146*t322*t73
     =           +1.76d+0*gammaaa*t156*t312*t73+2.879999999999999d-2*t15
     >           2*t153*t154*t322+9.215999999999996d-3*t156*t318*t319*t3
     ?           20-2.5919999999999993d-1*t152*t153*t156*t310)-4.7999999
     @           99999999d-1*gammaaa*t146*t323*t73+1.76d+0*gammaaa*t157*
     1           t312*t73+2.879999999999999d-2*t152*t153*t154*t323+9.215
     2           999999999996d-3*t157*t318*t319*t320-2.5919999999999993d
     3           -1*t152*t153*t157*t310)*t84+1.5d+0*t24*t324*t84+1.5d+0*
     4           rhoa*t104*t324*t84+1.5d+0*rhoa*t158*t228*t84+3.0d+0*t10
     5           4*t158*t84+2.5d-1*gammaaa*t228*t81*t83+2.5d-1*gammaaa*t
     6           24*t324*t83+5.0d-1*gammaaa*t104*t158*t83-2.5d-1*gammaaa
     7           *t24*t542*t81+2.5d-1*gammaaa*t104*t317*t81+2.5d-1*gamma
     8           aa*t158*t24*t317)+(1.25d-1*gammaaa*t228*t81+1.25d-1*gam
     9           maaa*t24*t324+2.5d-1*gammaaa*t104*t158)*t82*t83+t317*(-
     :           2.5d-1*gammaaa*t104*t81-2.5d-1*gammaaa*t158*t24)*t82+2.
     ;           5d-1*gammaaa*t24*t542*t81*t82+3.0d+0*t145*t316+3.0d+0*t
     <           151*t309)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t70*(1.0507616711111105d-8
     1           *gammabb*t152*t181*t310*t4*t448*t9-1.5535454814814809d-
     2           6*gammaaa*gammabb*t181*t311*t312*t4*t9+5.01143703703703
     3           5d-4*gammaaa*gammabb*t147*t181*t312*t9-3.38955377777777
     4           6d-6*gammabb*t152*t181*t310*t311*t9+3.1d-3*t4*t6*(1.050
     5           7616711111105d-8*gammabb*t152*t181*t310*t4*t448*t8-1.55
     6           35454814814809d-6*gammaaa*gammabb*t181*t311*t312*t4*t8+
     7           5.011437037037035d-4*gammaaa*gammabb*t147*t181*t312*t8-
     8           3.389553777777776d-6*gammabb*t152*t181*t310*t311*t8+3.1
     9           d-3*t4*t6*(1.0507616711111105d-8*gammabb*t152*t181*t310
     :           *t4*t448*t7-1.5535454814814809d-6*gammaaa*gammabb*t181*
     ;           t311*t312*t4*t7+5.011437037037035d-4*gammaaa*gammabb*t1
     <           47*t181*t312*t7-3.389553777777776d-6*gammabb*t152*t181*
     =           t310*t311*t7+3.1d-3*t4*(1.0507616711111105d-8*gammabb*t
     >           1*t152*t181*t310*t4*t448-1.5535454814814809d-6*gammaaa*
     ?           gammabb*t1*t181*t311*t312*t4+5.011437037037035d-4*gamma
     @           aa*gammabb*t1*t147*t181*t312-3.389553777777776d-6*gamma
     1           bb*t1*t152*t181*t310*t311)*t6-1.653333333333333d-2*gamm
     2           aaa*t146*t336*t6-8.266666666666665d-3*gammabb*t181*t313
     3           *t6+3.0311111111111105d-2*gammaaa*t182*t312*t6+5.125333
     4           333333332d-5*gammaaa*t146*t147*t336*t4+2.56266666666666
     5           6d-5*gammabb*t147*t181*t313*t4-9.396444444444442d-5*gam
     6           maaa*t147*t182*t312*t4+4.2369422222222203d-7*t152*t182*
     7           t310*t311*t4+8.473884444444441d-7*gammaaa*gammabb*t146*
     8           t148*t181*t311*t4-1.366755555555555d-4*t147*t152*t182*t
     9           310-2.73351111111111d-4*gammaaa*gammabb*t146*t147*t148*
     :           t181)-1.653333333333333d-2*gammaaa*t146*t337*t6-8.26666
     ;           6666666665d-3*gammabb*t181*t314*t6+3.0311111111111105d-
     <           2*gammaaa*t183*t312*t6+5.125333333333332d-5*gammaaa*t14
     =           6*t147*t337*t4+2.562666666666666d-5*gammabb*t147*t181*t
     >           314*t4-9.396444444444442d-5*gammaaa*t147*t183*t312*t4+4
     ?           .2369422222222203d-7*t152*t183*t310*t311*t4+8.473884444
     @           444441d-7*gammaaa*gammabb*t146*t149*t181*t311*t4-1.3667
     1           55555555555d-4*t147*t152*t183*t310-2.73351111111111d-4*
     2           gammaaa*gammabb*t146*t147*t149*t181)-1.653333333333333d
     3           -2*gammaaa*t146*t338*t6-8.266666666666665d-3*gammabb*t1
     4           81*t315*t6+3.0311111111111105d-2*gammaaa*t184*t312*t6+5
     5           .125333333333332d-5*gammaaa*t146*t147*t338*t4+2.5626666
     6           66666666d-5*gammabb*t147*t181*t315*t4-9.396444444444442
     7           d-5*gammaaa*t147*t184*t312*t4+4.2369422222222203d-7*t15
     8           2*t184*t310*t311*t4+8.473884444444441d-7*gammaaa*gammab
     9           b*t146*t150*t181*t311*t4-1.366755555555555d-4*t147*t152
     :           *t184*t310-2.73351111111111d-4*gammaaa*gammabb*t146*t14
     ;           7*t150*t181)+1.0d+0*t10*(t39*(-5.980796863619711d-2*t43
     <           *t44*t556*t65*t68-4.7846374908957684d+0*t133*t287*t48*t
     =           65*t68-4.7846374908957684d-1*t133*t325*t44*t65*t68-7.17
     >           6956236343652d-1*t172*t290*t44*t65*t68+1.43539124726873
     ?           05d+0*t129*t290*t44*t65*t68+2.3923187454478842d-1*t133*
     @           t283*t44*t65*t68-1.1961593727239421d+0*t172*t287*t43*t6
     1           5*t68-2.3923187454478842d+0*t129*t287*t43*t65*t68+2.392
     2           3187454478842d-1*t131*t283*t43*t65*t68+1.91385499635830
     3           74d+0*t131*t133*t172*t65*t68-9.487269826154375d-2*t133*
     4           t303*t48*t68-3.049479586978192d-2*t142*t290*t48*t68-2.3
     5           718174565385935d-2*t172*t303*t43*t68-4.743634913077187d
     6           -2*t129*t303*t43*t68+2.541232989148493d-3*t142*t283*t43
     7           *t68+2.0329863913187946d-2*t133*t142*t172*t68+7.6946442
     8           03726144d+0*t118*t119*t133*t268*t44*t48*t65-1.538928840
     9           745229d+1*t119*t133*t260*t265*t44*t48*t65+2.47490220668
     :           11444d+2*t133*t260*t261*t262*t44*t48*t65-6.155715362980
     ;           916d+1*t117*t118*t119*t131*t133*t48*t65+1.9236610509315
     <           36d+0*t117*t118*t119*t283*t43*t44*t65+1.923661050931536
     =           d+0*t118*t119*t172*t268*t43*t44*t65+3.847322101863072d+
     >           0*t118*t119*t129*t268*t43*t44*t65-3.847322101863072d+0*
     ?           t119*t172*t260*t265*t43*t44*t65-7.694644203726144d+0*t1
     @           19*t129*t260*t265*t43*t44*t65+6.187255516702861d+1*t172
     1           *t260*t261*t262*t43*t44*t65+1.2374511033405722d+2*t129*
     2           t260*t261*t262*t43*t44*t65+1.538928840745229d+1*t117*t1
     3           18*t119*t133*t172*t44*t65-1.538928840745229d+1*t117*t11
     4           8*t119*t131*t172*t43*t65-3.077857681490458d+1*t117*t118
     5           *t119*t129*t131*t43*t65+1.9751631321680768d-2*(t567+t56
     6           6+t565+t564+t563+t562+t561+t560+t559+t558+t557+1.923661
     7           050931536d+0*t556+t555+t554+t532)*t59*t63-4.54379642748
     8           21163d-4*t107*t296*t63+6.058395236642822d-4*t177*t246*t
     9           63+1.2116790473285642d-3*t138*t246*t63-5.84822362263464
     :           7d-1*t113*t114*t115*t296*t59-5.848223622634647d-1*t114*
     ;           t115*t177*t258*t59-1.1696447245269295d+0*t114*t115*t138
     <           *t258*t59+1.1696447245269295d+0*t115*t177*t250*t255*t59
     =           +2.339289449053859d+0*t115*t138*t250*t255*t59-1.7315896
     >           0813529d+1*t177*t250*t251*t252*t59-3.46317921627058d+1*
     ?           t138*t250*t251*t252*t59+t572+t571+t570-6.21814d-2*t41*(
     @           t567+t566+t565+t564+t563+t562+t561+t560+t559+t558+t557+
     1           t555+t554+t532)*t57+2.747773264188437d-3*t107*t292*t57-
     2           3.663697685584583d-3*t175*t246*t57-7.327395371169166d-3
     3           *t135*t246*t57+t569+t568+t553+t552+t551+t550+t549+t539+
     4           t537+t536+t517+t515+t514+t513+t512+t511+t510+t509+t508+
     5           t507+t506+t505+t504+t503+t502+t500+t499+t498+t497+t496+
     6           t495+t494+t493+t492+t491+t489+t484+t483+t482+t481+t480-
     7           6.538889093261956d-1*t117*t118*t119*t133*t142*t48+t479+
     8           t478+t477+t476-1.6347222733154887d-1*t117*t118*t119*t14
     9           2*t172*t43-3.2694445466309774d-1*t117*t118*t119*t129*t1
     :           42*t43+1.0d+0*t109*t110*t111*t292*t41+1.0d+0*t110*t111*
     ;           t175*t248*t41+2.0d+0*t110*t111*t135*t248*t41-2.0d+0*t11
     <           1*t175*t236*t241*t41-4.0d+0*t111*t135*t236*t241*t41+1.6
     =           081979498692536d+1*t175*t236*t237*t238*t41+3.2163958997
     >           38507d+1*t135*t236*t237*t238*t41+2.690728393099896d-2*t
     ?           107*t113*t114*t115*t177-8.837926660346784d-2*t107*t109*
     @           t110*t111*t175+5.381456786199792d-2*t107*t113*t114*t115
     1           *t138-1.767585332069357d-1*t107*t109*t110*t111*t135)-4.
     2           7846374908957684d-1*t133*t172*t44*t65*t68+9.56927498179
     3           1537d-1*t129*t131*t43*t65*t68+1.0164931956593973d-2*t12
     4           9*t142*t43*t68+7.694644203726144d+0*t117*t118*t119*t129
     5           *t43*t44*t65-1.8175185709928465d-3*t107*t138*t63-2.3392
     6           89449053859d+0*t113*t114*t115*t138*t59+1.09910930567537
     7           5d-2*t107*t135*t57+t548+t547+t546+t473+t472+t471+t470+t
     8           469+t468+t467+t466+t465+t464+t463+t462+t461+t460+t459+t
     9           458+t457+4.0d+0*t109*t110*t111*t135*t41+t375+t374+t372+
     :           t369+t356+t355+t354+t334+t307+t305+t300+t297+t293+t271)
     ;           +2.0d+0*t145*t339+2.0d+0*t151*t335+1.0d+0*t180*t316+1.0
     <           d+0*t185*t309)*wght+Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t70*(1.0507616711111105d-8
     1           *gammaaa*t146*t186*t379*t4*t448*t9-1.5535454814814809d-
     2           6*gammaaa*gammabb*t146*t311*t380*t4*t9+5.01143703703703
     3           5d-4*gammaaa*gammabb*t146*t147*t380*t9-3.38955377777777
     4           6d-6*gammaaa*t146*t186*t311*t379*t9+3.1d-3*t4*t6*(1.050
     5           7616711111105d-8*gammaaa*t146*t186*t379*t4*t448*t8-1.55
     6           35454814814809d-6*gammaaa*gammabb*t146*t311*t380*t4*t8+
     7           5.011437037037035d-4*gammaaa*gammabb*t146*t147*t380*t8-
     8           3.389553777777776d-6*gammaaa*t146*t186*t311*t379*t8+3.1
     9           d-3*t4*t6*(1.0507616711111105d-8*gammaaa*t146*t186*t379
     :           *t4*t448*t7-1.5535454814814809d-6*gammaaa*gammabb*t146*
     ;           t311*t380*t4*t7+5.011437037037035d-4*gammaaa*gammabb*t1
     <           46*t147*t380*t7-3.389553777777776d-6*gammaaa*t146*t186*
     =           t311*t379*t7+3.1d-3*t4*(1.0507616711111105d-8*gammaaa*t
     >           1*t146*t186*t379*t4*t448-1.5535454814814809d-6*gammaaa*
     ?           gammabb*t1*t146*t311*t380*t4+5.011437037037035d-4*gamma
     @           aa*gammabb*t1*t146*t147*t380-3.389553777777776d-6*gamma
     1           aa*t1*t146*t186*t311*t379)*t6-8.266666666666665d-3*gamm
     2           aaa*t146*t381*t6+3.0311111111111105d-2*gammabb*t148*t38
     3           0*t6-1.653333333333333d-2*gammabb*t181*t336*t6+2.562666
     4           666666666d-5*gammaaa*t146*t147*t381*t4-9.39644444444444
     5           2d-5*gammabb*t147*t148*t380*t4+4.2369422222222203d-7*t1
     6           48*t186*t311*t379*t4+5.125333333333332d-5*gammabb*t147*
     7           t181*t336*t4+8.473884444444441d-7*gammaaa*gammabb*t146*
     8           t181*t182*t311*t4-1.366755555555555d-4*t147*t148*t186*t
     9           379-2.73351111111111d-4*gammaaa*gammabb*t146*t147*t181*
     :           t182)-8.266666666666665d-3*gammaaa*t146*t382*t6+3.03111
     ;           11111111105d-2*gammabb*t149*t380*t6-1.653333333333333d-
     <           2*gammabb*t181*t337*t6+2.562666666666666d-5*gammaaa*t14
     =           6*t147*t382*t4-9.396444444444442d-5*gammabb*t147*t149*t
     >           380*t4+4.2369422222222203d-7*t149*t186*t311*t379*t4+5.1
     ?           25333333333332d-5*gammabb*t147*t181*t337*t4+8.473884444
     @           444441d-7*gammaaa*gammabb*t146*t181*t183*t311*t4-1.3667
     1           55555555555d-4*t147*t149*t186*t379-2.73351111111111d-4*
     2           gammaaa*gammabb*t146*t147*t181*t183)-8.266666666666665d
     3           -3*gammaaa*t146*t383*t6+3.0311111111111105d-2*gammabb*t
     4           150*t380*t6-1.653333333333333d-2*gammabb*t181*t338*t6+2
     5           .562666666666666d-5*gammaaa*t146*t147*t383*t4-9.3964444
     6           44444442d-5*gammabb*t147*t150*t380*t4+4.236942222222220
     7           3d-7*t150*t186*t311*t379*t4+5.125333333333332d-5*gammab
     8           b*t147*t181*t338*t4+8.473884444444441d-7*gammaaa*gammab
     9           b*t146*t181*t184*t311*t4-1.366755555555555d-4*t147*t150
     :           *t186*t379-2.73351111111111d-4*gammaaa*gammabb*t146*t14
     ;           7*t181*t184)+1.0d+0*t10*(t39*(-5.980796863619711d-2*t43
     <           *t44*t573*t65*t68+4.7846374908957684d+0*t133*t287*t48*t
     =           65*t68-2.3923187454478842d-1*t133*t362*t44*t65*t68+4.78
     >           46374908957684d-1*t133*t325*t44*t65*t68+1.4353912472687
     ?           305d+0*t172*t290*t44*t65*t68-7.176956236343652d-1*t129*
     @           t290*t44*t65*t68+2.3923187454478842d-1*t131*t362*t43*t6
     1           5*t68-2.3923187454478842d+0*t172*t287*t43*t65*t68-1.196
     2           1593727239421d+0*t129*t287*t43*t65*t68-1.91385499635830
     3           74d+0*t129*t131*t133*t65*t68+9.487269826154374d-2*t133*
     4           t303*t48*t68-3.0494795869781915d-2*t142*t290*t48*t68+2.
     5           541232989148493d-3*t142*t362*t43*t68-4.743634913077187d
     6           -2*t172*t303*t43*t68-2.3718174565385935d-2*t129*t303*t4
     7           3*t68-2.0329863913187946d-2*t129*t133*t142*t68-7.694644
     8           203726144d+0*t118*t119*t133*t268*t44*t48*t65+1.53892884
     9           0745229d+1*t119*t133*t260*t265*t44*t48*t65-2.4749022066
     :           811444d+2*t133*t260*t261*t262*t44*t48*t65+6.15571536298
     ;           0916d+1*t117*t118*t119*t131*t133*t48*t65+1.923661050931
     <           536d+0*t117*t118*t119*t362*t43*t44*t65+3.84732210186307
     =           2d+0*t118*t119*t172*t268*t43*t44*t65+1.923661050931536d
     >           +0*t118*t119*t129*t268*t43*t44*t65-7.694644203726144d+0
     ?           *t119*t172*t260*t265*t43*t44*t65-3.847322101863072d+0*t
     @           119*t129*t260*t265*t43*t44*t65+1.2374511033405722d+2*t1
     1           72*t260*t261*t262*t43*t44*t65+6.187255516702861d+1*t129
     2           *t260*t261*t262*t43*t44*t65-1.538928840745229d+1*t117*t
     3           118*t119*t129*t133*t44*t65-3.077857681490458d+1*t117*t1
     4           18*t119*t131*t172*t43*t65-1.538928840745229d+1*t117*t11
     5           8*t119*t129*t131*t43*t65+1.9751631321680768d-2*(t583+t5
     6           82+t581+t580+t579+t578+t577+t576+t575+t574+1.9236610509
     7           31536d+0*t573+t566+t554+t535+t532)*t59*t63-4.5437964274
     8           821163d-4*t107*t370*t63+1.2116790473285642d-3*t177*t246
     9           *t63+6.058395236642822d-4*t138*t246*t63-5.8482236226346
     :           47d-1*t113*t114*t115*t370*t59-1.1696447245269295d+0*t11
     ;           4*t115*t177*t258*t59-5.848223622634647d-1*t114*t115*t13
     <           8*t258*t59+2.339289449053859d+0*t115*t177*t250*t255*t59
     =           +1.1696447245269295d+0*t115*t138*t250*t255*t59-3.463179
     >           21627058d+1*t177*t250*t251*t252*t59-1.73158960813529d+1
     ?           *t138*t250*t251*t252*t59-6.21814d-2*t41*t57*(t583+t582+
     @           t581+t580+t579+t578+t577+t576+t575+t574+t566+t554+t535+
     1           t532)+t571+t570+2.747773264188437d-3*t107*t367*t57-7.32
     2           7395371169166d-3*t175*t246*t57-3.663697685584583d-3*t13
     3           5*t246*t57+t569+t568+t553+t552+t551+t550+t549+t541+t539
     4           +t537+t536+t517+t515+t514+t513+t512+t511+t510+t509+t508
     5           +t507+t506+t505+t504+t503+t502+t500+t499+t498+t497+t496
     6           +t495+t494+t493+t492+t491+t489+t484+t483+t482+t481+t480
     7           +6.538889093261955d-1*t117*t118*t119*t133*t142*t48+t479
     8           +t478+t477+t476-3.2694445466309774d-1*t117*t118*t119*t1
     9           42*t172*t43-1.6347222733154887d-1*t117*t118*t119*t129*t
     :           142*t43+1.0d+0*t109*t110*t111*t367*t41+2.0d+0*t110*t111
     ;           *t175*t248*t41+1.0d+0*t110*t111*t135*t248*t41-4.0d+0*t1
     <           11*t175*t236*t241*t41-2.0d+0*t111*t135*t236*t241*t41+3.
     =           216395899738507d+1*t175*t236*t237*t238*t41+1.6081979498
     >           692536d+1*t135*t236*t237*t238*t41+5.381456786199792d-2*
     ?           t107*t113*t114*t115*t177-1.767585332069357d-1*t107*t109
     @           *t110*t111*t175+2.690728393099896d-2*t107*t113*t114*t11
     1           5*t138-8.837926660346784d-2*t107*t109*t110*t111*t135)+4
     2           .7846374908957684d-1*t129*t133*t44*t65*t68+9.5692749817
     3           91537d-1*t131*t172*t43*t65*t68+1.0164931956593973d-2*t1
     4           42*t172*t43*t68+7.694644203726144d+0*t117*t118*t119*t17
     5           2*t43*t44*t65-1.8175185709928465d-3*t107*t177*t63-2.339
     6           289449053859d+0*t113*t114*t115*t177*t59+1.0991093056753
     7           75d-2*t107*t175*t57+t548+t547+t546+t473+t472+t471+t470+
     8           t469+t468+t467+t466+t465+t464+t463+t462+t461+t460+t459+
     9           t458+t457+4.0d+0*t109*t110*t111*t175*t41+t377+t376+t373
     :           +t371+t368+t357+t334+t302+t301+t298+t294+t264+t254+t240
     ;           )+1.0d+0*t145*t384+1.0d+0*t151*t378+2.0d+0*t180*t339+2.
     <           0d+0*t185*t335)*wght+Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t91*(5.0d-1*rhob*t592*t90*t93+1.5
     1           d+0*t353*t90*t93+5.0d-1*rhob*t38*(-2.737777777777778d+0
     2           *gammabb*t586*t86*t89+1.4745599999999992d-3*t602*t603*t
     3           604*t89+7.274666666666665d-1*t186*t187*t585*t89-5.83679
     4           9999999998d-2*t386*t387*t584*t89+6.0d-2*gammabb*t3*t86*
     5           (-2.737777777777778d+0*gammabb*t586*t86*t88+1.474559999
     6           9999992d-3*t602*t603*t604*t88+7.274666666666665d-1*t186
     7           *t187*t585*t88-5.836799999999998d-2*t386*t387*t584*t88+
     8           6.0d-2*gammabb*t3*t86*(-2.737777777777778d+0*gammabb*t5
     9           86*t86*t87+1.4745599999999992d-3*t602*t603*t604*t87+7.2
     :           74666666666665d-1*t186*t187*t585*t87-5.836799999999998d
     ;           -2*t386*t387*t584*t87+6.0d-2*gammabb*t3*t86*(-2.7377777
     <           77777778d+0*gammabb*t586*t77*t86+1.4745599999999992d-3*
     =           t602*t603*t604*t77+7.274666666666665d-1*t186*t187*t585*
     >           t77-5.836799999999998d-2*t386*t387*t584*t77)-4.79999999
     ?           9999999d-1*gammabb*t181*t389*t86+1.76d+0*gammabb*t189*t
     @           380*t86+2.879999999999999d-2*t186*t187*t188*t389+9.2159
     1           99999999996d-3*t189*t386*t387*t388-2.5919999999999993d-
     2           1*t186*t187*t189*t379)-4.799999999999999d-1*gammabb*t18
     3           1*t390*t86+1.76d+0*gammabb*t190*t380*t86+2.879999999999
     4           999d-2*t186*t187*t188*t390+9.215999999999996d-3*t190*t3
     5           86*t387*t388-2.5919999999999993d-1*t186*t187*t190*t379)
     6           -4.799999999999999d-1*gammabb*t181*t391*t86+1.76d+0*gam
     7           mabb*t191*t380*t86+2.879999999999999d-2*t186*t187*t188*
     8           t391+9.215999999999996d-3*t191*t386*t387*t388-2.5919999
     9           999999993d-1*t186*t187*t191*t379)*t93+1.5d+0*t38*t392*t
     :           93+1.5d+0*rhob*t169*t392*t93+1.5d+0*rhob*t192*t353*t93+
     ;           3.0d+0*t169*t192*t93+2.5d-1*gammabb*t353*t90*t92+2.5d-1
     <           *gammabb*t38*t392*t92+5.0d-1*gammabb*t169*t192*t92-2.5d
     =           -1*gammabb*t38*t601*t90+2.5d-1*gammabb*t169*t385*t90+2.
     >           5d-1*gammabb*t192*t38*t385)+(1.25d-1*gammabb*t353*t90+1
     ?           .25d-1*gammabb*t38*t392+2.5d-1*gammabb*t169*t192)*t91*t
     @           92+t385*(-2.5d-1*gammabb*t169*t90-2.5d-1*gammabb*t192*t
     1           38)*t91+2.5d-1*gammabb*t38*t601*t90*t91+1.0d+0*t70*(-1.
     2           4145185185185183d-1*gammabb*t586*t6*t9+4.38500740740740
     3           64d-4*gammabb*t147*t4*t586*t9-4.6606364444444426d-6*t18
     4           6*t311*t4*t585*t9+1.5034311111111107d-3*t147*t186*t585*
     5           t9+1.0507616711111105d-8*t386*t4*t448*t584*t9-3.3895537
     6           77777776d-6*t311*t386*t584*t9+3.1d-3*t4*t6*(-1.41451851
     7           85185183d-1*gammabb*t586*t6*t8+4.3850074074074064d-4*ga
     8           mmabb*t147*t4*t586*t8-4.6606364444444426d-6*t186*t311*t
     9           4*t585*t8+1.5034311111111107d-3*t147*t186*t585*t8+1.050
     :           7616711111105d-8*t386*t4*t448*t584*t8-3.389553777777776
     ;           d-6*t311*t386*t584*t8+3.1d-3*t4*t6*(-1.4145185185185183
     <           d-1*gammabb*t586*t6*t7+4.3850074074074064d-4*gammabb*t1
     =           47*t4*t586*t7-4.6606364444444426d-6*t186*t311*t4*t585*t
     >           7+1.5034311111111107d-3*t147*t186*t585*t7+1.05076167111
     ?           11105d-8*t386*t4*t448*t584*t7-3.389553777777776d-6*t311
     @           *t386*t584*t7+3.1d-3*t4*t6*(-1.4145185185185183d-1*gamm
     1           abb*t1*t586*t6+4.3850074074074064d-4*gammabb*t1*t147*t4
     2           *t586-4.6606364444444426d-6*t1*t186*t311*t4*t585+1.5034
     3           311111111107d-3*t1*t147*t186*t585+1.0507616711111105d-8
     4           *t1*t386*t4*t448*t584-3.389553777777776d-6*t1*t311*t386
     5           *t584)-2.4799999999999994d-2*gammabb*t181*t381*t6+9.093
     6           333333333331d-2*gammabb*t182*t380*t6+7.687999999999998d
     7           -5*gammabb*t147*t181*t381*t4-2.818933333333332d-4*gamma
     8           bb*t147*t182*t380*t4+1.271082666666666d-6*t182*t186*t31
     9           1*t379*t4-4.100266666666665d-4*t147*t182*t186*t379)-2.4
     :           799999999999994d-2*gammabb*t181*t382*t6+9.0933333333333
     ;           31d-2*gammabb*t183*t380*t6+7.687999999999998d-5*gammabb
     <           *t147*t181*t382*t4-2.818933333333332d-4*gammabb*t147*t1
     =           83*t380*t4+1.271082666666666d-6*t183*t186*t311*t379*t4-
     >           4.100266666666665d-4*t147*t183*t186*t379)-2.47999999999
     ?           99994d-2*gammabb*t181*t383*t6+9.093333333333331d-2*gamm
     @           abb*t184*t380*t6+7.687999999999998d-5*gammabb*t147*t181
     1           *t383*t4-2.818933333333332d-4*gammabb*t147*t184*t380*t4
     2           +1.271082666666666d-6*t184*t186*t311*t379*t4-4.10026666
     3           6666665d-4*t147*t184*t186*t379)+1.0d+0*t10*(t39*(-5.980
     4           796863619711d-2*t43*t44*t593*t65*t68+1.4353912472687305
     5           d+1*t133*t287*t48*t65*t68+7.176956236343652d-1*t133*t36
     6           2*t44*t65*t68-2.1530868709030954d+0*t172*t290*t44*t65*t
     7           68+7.176956236343652d-1*t131*t362*t43*t65*t68-3.5884781
     8           18171826d+0*t172*t287*t43*t65*t68-5.741564989074922d+0*
     9           t131*t133*t172*t65*t68+2.8461809478463124d-1*t133*t303*
     :           t48*t68+7.623698967445479d-3*t142*t362*t43*t68-7.115452
     ;           36961578d-2*t172*t303*t43*t68-6.098959173956384d-2*t133
     <           *t142*t172*t68-2.3083932611178434d+1*t118*t119*t133*t26
     =           8*t44*t48*t65+4.616786522235687d+1*t119*t133*t260*t265*
     >           t44*t48*t65-7.424706620043432d+2*t133*t260*t261*t262*t4
     ?           4*t48*t65+1.8467146088942746d+2*t117*t118*t119*t131*t13
     @           3*t48*t65+5.770983152794609d+0*t117*t118*t119*t362*t43*
     1           t44*t65+5.770983152794609d+0*t118*t119*t172*t268*t43*t4
     2           4*t65-1.1541966305589217d+1*t119*t172*t260*t265*t43*t44
     3           *t65+1.856176655010858d+2*t172*t260*t261*t262*t43*t44*t
     4           65-4.616786522235687d+1*t117*t118*t119*t133*t172*t44*t6
     5           5-4.616786522235687d+1*t117*t118*t119*t131*t172*t43*t65
     6           +1.9751631321680768d-2*t59*(t600+t599+t598+t597+t596+t5
     7           95+t594+1.923661050931536d+0*t593+t567+t534+t532)*t63-1
     8           .363138928244635d-3*t107*t370*t63+1.8175185709928465d-3
     9           *t177*t246*t63-6.21814d-2*t41*t57*(t600+t599+t598+t597+
     :           t596+t595+t594+t567+t534+t532)-1.7544670867903941d+0*t1
     ;           13*t114*t115*t370*t59-1.7544670867903941d+0*t114*t115*t
     <           177*t258*t59+3.5089341735807883d+0*t115*t177*t250*t255*
     =           t59-5.19476882440587d+1*t177*t250*t251*t252*t59+t572+8.
     >           243319792565312d-3*t107*t367*t57-1.099109305675375d-2*t
     ?           175*t246*t57+t540+t539+t538+t537+t536+t517+t516+t515+t5
     @           14+t513+t512+t511+t510+t509+t508+t507+t506+t505+t504+t5
     1           03+t502+t500+t499+t498+t497+t496+t495+t494+t493+t492+t4
     2           91+t489+t484+t483+t482+t481+t480+1.9616667279785865d+0*
     3           t117*t118*t119*t133*t142*t48+t479+t478+t477+t476-4.9041
     4           66819946466d-1*t117*t118*t119*t142*t172*t43+3.0d+0*t109
     5           *t110*t111*t367*t41+3.0d+0*t110*t111*t175*t248*t41-6.0d
     6           +0*t111*t175*t236*t241*t41+4.824593849607761d+1*t175*t2
     7           36*t237*t238*t41+8.072185179299687d-2*t107*t113*t114*t1
     8           15*t177-2.6513779981040353d-1*t107*t109*t110*t111*t175)
     9           -5.741564989074922d+0*t131*t133*t48*t65*t68-1.794239059
     :           085913d-1*t362*t43*t44*t65*t68+1.4353912472687305d+0*t1
     ;           33*t172*t44*t65*t68+1.4353912472687305d+0*t131*t172*t43
     <           *t65*t68-6.098959173956384d-2*t133*t142*t48*t68+1.52473
     =           9793489096d-2*t142*t172*t43*t68-4.616786522235687d+1*t1
     >           17*t118*t119*t133*t44*t48*t65+1.1541966305589217d+1*t11
     ?           7*t118*t119*t172*t43*t44*t65+5.92548939650423d-2*t370*t
     @           59*t63-2.72627785648927d-3*t107*t177*t63-rhob*t592-3.50
     1           89341735807883d+0*t113*t114*t115*t177*t59-1.865442d-1*t
     2           367*t41*t57+1.6486639585130625d-2*t107*t175*t57+t474+t4
     3           73+t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t4
     4           62+t461+t460+t459+t458+t457+6.0d+0*t109*t110*t111*t175*
     5           t41-3.3306690738754696d-16*t159*t165*t347*t37+6.6613381
     6           47750939d-16*t159*t341*t343*t37-5.356375176299456d-15*t
     7           340*t341*t342*t37+1.2202564577405706d-18*t345*t36-3.0d+
     8           0*t166*t168*t33*t352+6.0d+0*t166*t33*t349*t351-9.649187
     9           699215522d+1*t33*t348*t349*t350+5.284159572535705d-3*t3
     :           2*t345+2.549392377400174d-1*t162*t166*t167*t168+2.94362
     ;           0900479655d-17*t159*t162*t164*t165)+3.0d+0*t180*t384+3.
     <           0d+0*t185*t378)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (1.0d+0*t70*(3.0311111111111105d-
     1           2*t312*t6*t9-3.9403562666666647d-9*t152*t320*t4*t448*t9
     2           -9.396444444444442d-5*t147*t312*t4*t9+1.429967999999999
     3           5d-6*gammaaa*t310*t311*t4*t9+1.271082666666666d-6*t152*
     4           t311*t320*t9-4.612799999999999d-4*gammaaa*t147*t310*t9+
     5           3.1d-3*t4*t6*(3.0311111111111105d-2*t312*t6*t8-3.940356
     6           2666666647d-9*t152*t320*t4*t448*t8-9.396444444444442d-5
     7           *t147*t312*t4*t8+1.4299679999999995d-6*gammaaa*t310*t31
     8           1*t4*t8+1.271082666666666d-6*t152*t311*t320*t8-4.612799
     9           999999999d-4*gammaaa*t147*t310*t8+3.1d-3*t4*t6*(3.03111
     :           11111111105d-2*t312*t6*t7-3.9403562666666647d-9*t152*t3
     ;           20*t4*t448*t7-9.396444444444442d-5*t147*t312*t4*t7+1.42
     <           99679999999995d-6*gammaaa*t310*t311*t4*t7+1.27108266666
     =           6666d-6*t152*t311*t320*t7-4.612799999999999d-4*gammaaa*
     >           t147*t310*t7+3.1d-3*t4*t6*(3.0311111111111105d-2*t1*t31
     ?           2*t6-3.9403562666666647d-9*t1*t152*t320*t4*t448-9.39644
     @           4444444442d-5*t1*t147*t312*t4+1.4299679999999995d-6*gam
     1           maaa*t1*t310*t311*t4+1.271082666666666d-6*t1*t152*t311*
     2           t320-4.612799999999999d-4*gammaaa*t1*t147*t310)-1.65333
     3           3333333333d-2*gammaaa*t146*t393*t6+3.1d-3*t2*t313*t6+3.
     4           0311111111111105d-2*gammaaa*t193*t312*t6-1.653333333333
     5           333d-2*t146*t148*t6+5.125333333333332d-5*gammaaa*t146*t
     6           147*t393*t4-9.61d-6*t147*t2*t313*t4-9.396444444444442d-
     7           5*gammaaa*t147*t193*t312*t4+4.2369422222222203d-7*t152*
     8           t193*t310*t311*t4-3.1777066666666653d-7*gammaaa*t148*t1
     9           54*t311*t4+5.125333333333332d-5*t146*t147*t148*t4-1.366
     :           755555555555d-4*t147*t152*t193*t310+1.0250666666666663d
     ;           -4*gammaaa*t147*t148*t154)-1.653333333333333d-2*gammaaa
     <           *t146*t394*t6+3.1d-3*t2*t314*t6+3.0311111111111105d-2*g
     =           ammaaa*t194*t312*t6-1.653333333333333d-2*t146*t149*t6+5
     >           .125333333333332d-5*gammaaa*t146*t147*t394*t4-9.61d-6*t
     ?           147*t2*t314*t4-9.396444444444442d-5*gammaaa*t147*t194*t
     @           312*t4+4.2369422222222203d-7*t152*t194*t310*t311*t4-3.1
     1           777066666666653d-7*gammaaa*t149*t154*t311*t4+5.12533333
     2           3333332d-5*t146*t147*t149*t4-1.366755555555555d-4*t147*
     3           t152*t194*t310+1.0250666666666663d-4*gammaaa*t147*t149*
     4           t154)-1.653333333333333d-2*gammaaa*t146*t395*t6+3.1d-3*
     5           t2*t315*t6+3.0311111111111105d-2*gammaaa*t195*t312*t6-1
     6           .653333333333333d-2*t146*t150*t6+5.125333333333332d-5*g
     7           ammaaa*t146*t147*t395*t4-9.61d-6*t147*t2*t315*t4-9.3964
     8           44444444442d-5*gammaaa*t147*t195*t312*t4+4.236942222222
     9           2203d-7*t152*t195*t310*t311*t4-3.1777066666666653d-7*ga
     :           mmaaa*t150*t154*t311*t4+5.125333333333332d-5*t146*t147*
     ;           t150*t4-1.366755555555555d-4*t147*t152*t195*t310+1.0250
     <           666666666663d-4*gammaaa*t147*t150*t154)+t82*(5.0d-1*rho
     =           a*t24*(5.866666666666666d-1*t312*t73*t80-5.529599999999
     >           998d-4*t318*t544*t608*t80+1.9583999999999993d-2*t152*t3
     ?           19*t320*t80-2.0799999999999996d-1*gammaaa*t153*t310*t80
     @           +6.0d-2*gammaaa*t2*t73*(5.866666666666666d-1*t312*t73*t
     1           79-5.529599999999998d-4*t318*t544*t608*t79+1.9583999999
     2           999993d-2*t152*t319*t320*t79-2.0799999999999996d-1*gamm
     3           aaa*t153*t310*t79+6.0d-2*gammaaa*t2*t73*(5.866666666666
     4           666d-1*t312*t73*t78-5.529599999999998d-4*t318*t544*t608
     5           *t78+1.9583999999999993d-2*t152*t319*t320*t78-2.0799999
     6           999999996d-1*gammaaa*t153*t310*t78+6.0d-2*gammaaa*t2*t7
     7           3*(5.866666666666666d-1*t312*t73*t77-5.529599999999998d
     8           -4*t318*t544*t608*t77+1.9583999999999993d-2*t152*t319*t
     9           320*t77-2.0799999999999996d-1*gammaaa*t153*t310*t77)-3.
     :           1999999999999995d-1*gammaaa*t146*t399*t73+6.0d-2*t2*t32
     ;           1*t73+5.866666666666666d-1*gammaaa*t199*t312*t73-3.1999
     <           999999999995d-1*t146*t155*t73+1.9199999999999995d-2*t15
     =           2*t153*t154*t399-2.303999999999999d-3*t152*t155*t319*t3
     >           98-3.6d-3*gammaaa*t153*t198*t321+3.0719999999999986d-3*
     ?           t199*t318*t319*t320-8.639999999999998d-2*t152*t153*t199
     @           *t310+5.759999999999998d-2*gammaaa*t153*t154*t155)-3.19
     1           99999999999995d-1*gammaaa*t146*t400*t73+6.0d-2*t2*t322*
     2           t73+5.866666666666666d-1*gammaaa*t200*t312*t73-3.199999
     3           9999999995d-1*t146*t156*t73+1.9199999999999995d-2*t152*
     4           t153*t154*t400-2.303999999999999d-3*t152*t156*t319*t398
     5           -3.6d-3*gammaaa*t153*t198*t322+3.0719999999999986d-3*t2
     6           00*t318*t319*t320-8.639999999999998d-2*t152*t153*t200*t
     7           310+5.759999999999998d-2*gammaaa*t153*t154*t156)-3.1999
     8           999999999995d-1*gammaaa*t146*t401*t73+6.0d-2*t2*t323*t7
     9           3+5.866666666666666d-1*gammaaa*t201*t312*t73-3.19999999
     :           99999995d-1*t146*t157*t73+1.9199999999999995d-2*t152*t1
     ;           53*t154*t401-2.303999999999999d-3*t152*t157*t319*t398-3
     <           .6d-3*gammaaa*t153*t198*t323+3.0719999999999986d-3*t201
     =           *t318*t319*t320-8.639999999999998d-2*t152*t153*t201*t31
     >           0+5.759999999999998d-2*gammaaa*t153*t154*t157)*t84+1.0d
     ?           +0*t24*t402*t84+1.0d+0*rhoa*t104*t402*t84+5.0d-1*rhoa*t
     @           202*t228*t84+1.0d+0*t104*t202*t84-1.25d-1*t104*t81*t83+
     1           1.25d-1*gammaaa*t24*t402*t83-1.25d-1*t158*t24*t83+1.25d
     2           -1*gammaaa*t104*t202*t83+1.25d-1*t24*t317*t81-1.25d-1*t
     3           228*t81-1.25d-1*t24*t324+1.25d-1*gammaaa*t202*t24*t317-
     4           2.5d-1*t104*t158)+(t607+t606+1.25d-1*gammaaa*t24*t402+1
     5           .25d-1*gammaaa*t104*t202)*t82*t83+t317*t605*t82+2.0d+0*
     6           t145*t396+1.0d+0*t196*t309)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*t70*(-3.9403562666666647d
     1           -9*t152*t3*t310*t4*t448*t9+5.825795555555554d-7*gammaaa
     2           *t3*t311*t312*t4*t9-1.8792888888888884d-4*gammaaa*t147*
     3           t3*t312*t9+1.271082666666666d-6*t152*t3*t310*t311*t9+3.
     4           1d-3*t4*t6*(-3.9403562666666647d-9*t152*t3*t310*t4*t448
     5           *t8+5.825795555555554d-7*gammaaa*t3*t311*t312*t4*t8-1.8
     6           792888888888884d-4*gammaaa*t147*t3*t312*t8+1.2710826666
     7           66666d-6*t152*t3*t310*t311*t8+3.1d-3*t4*t6*(-3.94035626
     8           66666647d-9*t152*t3*t310*t4*t448*t7+5.825795555555554d-
     9           7*gammaaa*t3*t311*t312*t4*t7-1.8792888888888884d-4*gamm
     :           aaa*t147*t3*t312*t7+1.271082666666666d-6*t152*t3*t310*t
     ;           311*t7+3.1d-3*t4*(-3.9403562666666647d-9*t1*t152*t3*t31
     <           0*t4*t448+5.825795555555554d-7*gammaaa*t1*t3*t311*t312*
     =           t4-1.8792888888888884d-4*gammaaa*t1*t147*t3*t312+1.2710
     >           82666666666d-6*t1*t152*t3*t310*t311)*t6-1.6533333333333
     ?           33d-2*gammaaa*t146*t403*t6+3.1d-3*t3*t313*t6+3.03111111
     @           11111105d-2*gammaaa*t203*t312*t6+5.125333333333332d-5*g
     1           ammaaa*t146*t147*t4*t403-9.61d-6*t147*t3*t313*t4-9.3964
     2           44444444442d-5*gammaaa*t147*t203*t312*t4+4.236942222222
     3           2203d-7*t152*t203*t310*t311*t4-3.1777066666666653d-7*ga
     4           mmaaa*t146*t148*t3*t311*t4-1.366755555555555d-4*t147*t1
     5           52*t203*t310+1.0250666666666663d-4*gammaaa*t146*t147*t1
     6           48*t3)-1.653333333333333d-2*gammaaa*t146*t404*t6+3.1d-3
     7           *t3*t314*t6+3.0311111111111105d-2*gammaaa*t204*t312*t6+
     8           5.125333333333332d-5*gammaaa*t146*t147*t4*t404-9.61d-6*
     9           t147*t3*t314*t4-9.396444444444442d-5*gammaaa*t147*t204*
     :           t312*t4+4.2369422222222203d-7*t152*t204*t310*t311*t4-3.
     ;           1777066666666653d-7*gammaaa*t146*t149*t3*t311*t4-1.3667
     <           55555555555d-4*t147*t152*t204*t310+1.0250666666666663d-
     =           4*gammaaa*t146*t147*t149*t3)-1.653333333333333d-2*gamma
     >           aa*t146*t405*t6+3.1d-3*t3*t315*t6+3.0311111111111105d-2
     ?           *gammaaa*t205*t312*t6+5.125333333333332d-5*gammaaa*t146
     @           *t147*t4*t405-9.61d-6*t147*t3*t315*t4-9.396444444444442
     1           d-5*gammaaa*t147*t205*t312*t4+4.2369422222222203d-7*t15
     2           2*t205*t310*t311*t4-3.1777066666666653d-7*gammaaa*t146*
     3           t150*t3*t311*t4-1.366755555555555d-4*t147*t152*t205*t31
     4           0+1.0250666666666663d-4*gammaaa*t146*t147*t150*t3)+2.0d
     5           +0*t145*t406+1.0d+0*t206*t309)*wght+Cmat3(iq,D3_RA_RA_G
     6           BB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*t70*(-3.9403562666666647d
     1           -9*gammaaa*gammabb*t154*t181*t4*t448*t9+4.2369422222222
     2           203d-7*gammabb*t146*t181*t311*t4*t9+1.271082666666666d-
     3           6*gammaaa*gammabb*t154*t181*t311*t9-1.366755555555555d-
     4           4*gammabb*t146*t147*t181*t9+3.1d-3*t4*t6*(-3.9403562666
     5           666647d-9*gammaaa*gammabb*t154*t181*t4*t448*t8+4.236942
     6           2222222203d-7*gammabb*t146*t181*t311*t4*t8+1.2710826666
     7           66666d-6*gammaaa*gammabb*t154*t181*t311*t8-1.3667555555
     8           55555d-4*gammabb*t146*t147*t181*t8+3.1d-3*t4*t6*(-3.940
     9           3562666666647d-9*gammaaa*gammabb*t154*t181*t4*t448*t7+4
     :           .2369422222222203d-7*gammabb*t146*t181*t311*t4*t7+1.271
     ;           082666666666d-6*gammaaa*gammabb*t154*t181*t311*t7-1.366
     <           755555555555d-4*gammabb*t146*t147*t181*t7+3.1d-3*t4*(-3
     =           .9403562666666647d-9*gammaaa*gammabb*t1*t154*t181*t4*t4
     >           48+4.2369422222222203d-7*gammabb*t1*t146*t181*t311*t4+1
     ?           .271082666666666d-6*gammaaa*gammabb*t1*t154*t181*t311-1
     @           .366755555555555d-4*gammabb*t1*t146*t147*t181)*t6-8.266
     1           666666666665d-3*gammaaa*t146*t407*t6-8.266666666666665d
     2           -3*gammabb*t181*t393*t6+3.1d-3*t2*t336*t6-8.26666666666
     3           6665d-3*t146*t182*t6+2.562666666666666d-5*gammaaa*t146*
     4           t147*t4*t407+2.562666666666666d-5*gammabb*t147*t181*t39
     5           3*t4-9.61d-6*t147*t2*t336*t4-1.5888533333333327d-7*gamm
     6           abb*t148*t181*t2*t311*t4+4.2369422222222203d-7*gammaaa*
     7           gammabb*t146*t181*t193*t311*t4-1.5888533333333327d-7*ga
     8           mmaaa*t154*t182*t311*t4+2.562666666666666d-5*t146*t147*
     9           t182*t4+5.125333333333332d-5*gammabb*t147*t148*t181*t2-
     :           1.366755555555555d-4*gammaaa*gammabb*t146*t147*t181*t19
     ;           3+5.125333333333332d-5*gammaaa*t147*t154*t182)-8.266666
     <           666666665d-3*gammaaa*t146*t408*t6-8.266666666666665d-3*
     =           gammabb*t181*t394*t6+3.1d-3*t2*t337*t6-8.26666666666666
     >           5d-3*t146*t183*t6+2.562666666666666d-5*gammaaa*t146*t14
     ?           7*t4*t408+2.562666666666666d-5*gammabb*t147*t181*t394*t
     @           4-9.61d-6*t147*t2*t337*t4-1.5888533333333327d-7*gammabb
     1           *t149*t181*t2*t311*t4+4.2369422222222203d-7*gammaaa*gam
     2           mabb*t146*t181*t194*t311*t4-1.5888533333333327d-7*gamma
     3           aa*t154*t183*t311*t4+2.562666666666666d-5*t146*t147*t18
     4           3*t4+5.125333333333332d-5*gammabb*t147*t149*t181*t2-1.3
     5           66755555555555d-4*gammaaa*gammabb*t146*t147*t181*t194+5
     6           .125333333333332d-5*gammaaa*t147*t154*t183)-8.266666666
     7           666665d-3*gammaaa*t146*t409*t6-8.266666666666665d-3*gam
     8           mabb*t181*t395*t6+3.1d-3*t2*t338*t6-8.266666666666665d-
     9           3*t146*t184*t6+2.562666666666666d-5*gammaaa*t146*t147*t
     :           4*t409+2.562666666666666d-5*gammabb*t147*t181*t395*t4-9
     ;           .61d-6*t147*t2*t338*t4-1.5888533333333327d-7*gammabb*t1
     <           50*t181*t2*t311*t4+4.2369422222222203d-7*gammaaa*gammab
     =           b*t146*t181*t195*t311*t4-1.5888533333333327d-7*gammaaa*
     >           t154*t184*t311*t4+2.562666666666666d-5*t146*t147*t184*t
     ?           4+5.125333333333332d-5*gammabb*t147*t150*t181*t2-1.3667
     @           55555555555d-4*gammaaa*gammabb*t146*t147*t181*t195+5.12
     1           5333333333332d-5*gammaaa*t147*t154*t184)+1.0d+0*t145*t4
     2           10+1.0d+0*t180*t396+1.0d+0*t196*t335)*wght+Cmat3(iq,D3_
     3           RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (1.0d+0*t70*(-3.9403562666666647d
     1           -9*gammaaa*gammabb*t146*t188*t4*t448*t9+4.2369422222222
     2           203d-7*gammaaa*t146*t181*t311*t4*t9+1.271082666666666d-
     3           6*gammaaa*gammabb*t146*t188*t311*t9-1.366755555555555d-
     4           4*gammaaa*t146*t147*t181*t9+3.1d-3*t4*t6*(-3.9403562666
     5           666647d-9*gammaaa*gammabb*t146*t188*t4*t448*t8+4.236942
     6           2222222203d-7*gammaaa*t146*t181*t311*t4*t8+1.2710826666
     7           66666d-6*gammaaa*gammabb*t146*t188*t311*t8-1.3667555555
     8           55555d-4*gammaaa*t146*t147*t181*t8+3.1d-3*t4*t6*(-3.940
     9           3562666666647d-9*gammaaa*gammabb*t146*t188*t4*t448*t7+4
     :           .2369422222222203d-7*gammaaa*t146*t181*t311*t4*t7+1.271
     ;           082666666666d-6*gammaaa*gammabb*t146*t188*t311*t7-1.366
     <           755555555555d-4*gammaaa*t146*t147*t181*t7+3.1d-3*t4*(-3
     =           .9403562666666647d-9*gammaaa*gammabb*t1*t146*t188*t4*t4
     >           48+4.2369422222222203d-7*gammaaa*t1*t146*t181*t311*t4+1
     ?           .271082666666666d-6*gammaaa*gammabb*t1*t146*t188*t311-1
     @           .366755555555555d-4*gammaaa*t1*t146*t147*t181)*t6-8.266
     1           666666666665d-3*gammaaa*t146*t411*t6-8.266666666666665d
     2           -3*gammabb*t181*t403*t6+3.1d-3*t3*t336*t6-8.26666666666
     3           6665d-3*t148*t181*t6+2.562666666666666d-5*gammaaa*t146*
     4           t147*t4*t411+2.562666666666666d-5*gammabb*t147*t181*t4*
     5           t403-9.61d-6*t147*t3*t336*t4-1.5888533333333327d-7*gamm
     6           aaa*t146*t182*t3*t311*t4+4.2369422222222203d-7*gammaaa*
     7           gammabb*t146*t181*t203*t311*t4-1.5888533333333327d-7*ga
     8           mmabb*t148*t188*t311*t4+2.562666666666666d-5*t147*t148*
     9           t181*t4+5.125333333333332d-5*gammaaa*t146*t147*t182*t3-
     :           1.366755555555555d-4*gammaaa*gammabb*t146*t147*t181*t20
     ;           3+5.125333333333332d-5*gammabb*t147*t148*t188)-8.266666
     <           666666665d-3*gammaaa*t146*t412*t6-8.266666666666665d-3*
     =           gammabb*t181*t404*t6+3.1d-3*t3*t337*t6-8.26666666666666
     >           5d-3*t149*t181*t6+2.562666666666666d-5*gammaaa*t146*t14
     ?           7*t4*t412+2.562666666666666d-5*gammabb*t147*t181*t4*t40
     @           4-9.61d-6*t147*t3*t337*t4-1.5888533333333327d-7*gammaaa
     1           *t146*t183*t3*t311*t4+4.2369422222222203d-7*gammaaa*gam
     2           mabb*t146*t181*t204*t311*t4-1.5888533333333327d-7*gamma
     3           bb*t149*t188*t311*t4+2.562666666666666d-5*t147*t149*t18
     4           1*t4+5.125333333333332d-5*gammaaa*t146*t147*t183*t3-1.3
     5           66755555555555d-4*gammaaa*gammabb*t146*t147*t181*t204+5
     6           .125333333333332d-5*gammabb*t147*t149*t188)-8.266666666
     7           666665d-3*gammaaa*t146*t413*t6-8.266666666666665d-3*gam
     8           mabb*t181*t405*t6+3.1d-3*t3*t338*t6-8.266666666666665d-
     9           3*t150*t181*t6+2.562666666666666d-5*gammaaa*t146*t147*t
     :           4*t413+2.562666666666666d-5*gammabb*t147*t181*t4*t405-9
     ;           .61d-6*t147*t3*t338*t4-1.5888533333333327d-7*gammaaa*t1
     <           46*t184*t3*t311*t4+4.2369422222222203d-7*gammaaa*gammab
     =           b*t146*t181*t205*t311*t4-1.5888533333333327d-7*gammabb*
     >           t150*t188*t311*t4+2.562666666666666d-5*t147*t150*t181*t
     ?           4+5.125333333333332d-5*gammaaa*t146*t147*t184*t3-1.3667
     @           55555555555d-4*gammaaa*gammabb*t146*t147*t181*t205+5.12
     1           5333333333332d-5*gammabb*t147*t150*t188)+1.0d+0*t145*t4
     2           14+1.0d+0*t180*t406+1.0d+0*t206*t335)*wght+Cmat3(iq,D3_
     3           RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (1.0d+0*t70*(-3.9403562666666647d
     1           -9*t186*t2*t379*t4*t448*t9+5.825795555555554d-7*gammabb
     2           *t2*t311*t380*t4*t9-1.8792888888888884d-4*gammabb*t147*
     3           t2*t380*t9+1.271082666666666d-6*t186*t2*t311*t379*t9+3.
     4           1d-3*t4*t6*(-3.9403562666666647d-9*t186*t2*t379*t4*t448
     5           *t8+5.825795555555554d-7*gammabb*t2*t311*t380*t4*t8-1.8
     6           792888888888884d-4*gammabb*t147*t2*t380*t8+1.2710826666
     7           66666d-6*t186*t2*t311*t379*t8+3.1d-3*t4*t6*(-3.94035626
     8           66666647d-9*t186*t2*t379*t4*t448*t7+5.825795555555554d-
     9           7*gammabb*t2*t311*t380*t4*t7-1.8792888888888884d-4*gamm
     :           abb*t147*t2*t380*t7+1.271082666666666d-6*t186*t2*t311*t
     ;           379*t7+3.1d-3*t4*(-3.9403562666666647d-9*t1*t186*t2*t37
     <           9*t4*t448+5.825795555555554d-7*gammabb*t1*t2*t311*t380*
     =           t4-1.8792888888888884d-4*gammabb*t1*t147*t2*t380+1.2710
     >           82666666666d-6*t1*t186*t2*t311*t379)*t6-1.6533333333333
     ?           33d-2*gammabb*t181*t407*t6+3.1d-3*t2*t381*t6+3.03111111
     @           11111105d-2*gammabb*t193*t380*t6+5.125333333333332d-5*g
     1           ammabb*t147*t181*t4*t407-9.61d-6*t147*t2*t381*t4-9.3964
     2           44444444442d-5*gammabb*t147*t193*t380*t4+4.236942222222
     3           2203d-7*t186*t193*t311*t379*t4-3.1777066666666653d-7*ga
     4           mmabb*t181*t182*t2*t311*t4-1.366755555555555d-4*t147*t1
     5           86*t193*t379+1.0250666666666663d-4*gammabb*t147*t181*t1
     6           82*t2)-1.653333333333333d-2*gammabb*t181*t408*t6+3.1d-3
     7           *t2*t382*t6+3.0311111111111105d-2*gammabb*t194*t380*t6+
     8           5.125333333333332d-5*gammabb*t147*t181*t4*t408-9.61d-6*
     9           t147*t2*t382*t4-9.396444444444442d-5*gammabb*t147*t194*
     :           t380*t4+4.2369422222222203d-7*t186*t194*t311*t379*t4-3.
     ;           1777066666666653d-7*gammabb*t181*t183*t2*t311*t4-1.3667
     <           55555555555d-4*t147*t186*t194*t379+1.0250666666666663d-
     =           4*gammabb*t147*t181*t183*t2)-1.653333333333333d-2*gamma
     >           bb*t181*t409*t6+3.1d-3*t2*t383*t6+3.0311111111111105d-2
     ?           *gammabb*t195*t380*t6+5.125333333333332d-5*gammabb*t147
     @           *t181*t4*t409-9.61d-6*t147*t2*t383*t4-9.396444444444442
     1           d-5*gammabb*t147*t195*t380*t4+4.2369422222222203d-7*t18
     2           6*t195*t311*t379*t4-3.1777066666666653d-7*gammabb*t181*
     3           t184*t2*t311*t4-1.366755555555555d-4*t147*t186*t195*t37
     4           9+1.0250666666666663d-4*gammabb*t147*t181*t184*t2)+2.0d
     5           +0*t180*t410+1.0d+0*t196*t378)*wght+Cmat3(iq,D3_RB_RB_G
     6           AA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t91*(5.0d-1*rhob*t38*(5.86666666
     1           6666666d-1*t380*t86*t89-5.529599999999998d-4*t386*t603*
     2           t612*t89+1.9583999999999993d-2*t186*t387*t388*t89-2.079
     3           9999999999996d-1*gammabb*t187*t379*t89+6.0d-2*gammabb*t
     4           3*t86*(5.866666666666666d-1*t380*t86*t88-5.529599999999
     5           998d-4*t386*t603*t612*t88+1.9583999999999993d-2*t186*t3
     6           87*t388*t88-2.0799999999999996d-1*gammabb*t187*t379*t88
     7           +6.0d-2*gammabb*t3*t86*(5.866666666666666d-1*t380*t86*t
     8           87-5.529599999999998d-4*t386*t603*t612*t87+1.9583999999
     9           999993d-2*t186*t387*t388*t87-2.0799999999999996d-1*gamm
     :           abb*t187*t379*t87+6.0d-2*gammabb*t3*t86*(5.866666666666
     ;           666d-1*t380*t77*t86-5.529599999999998d-4*t386*t603*t612
     <           *t77+1.9583999999999993d-2*t186*t387*t388*t77-2.0799999
     =           999999996d-1*gammabb*t187*t379*t77)-3.1999999999999995d
     >           -1*gammabb*t181*t417*t86+6.0d-2*t3*t389*t86+5.866666666
     ?           666666d-1*gammabb*t209*t380*t86-3.1999999999999995d-1*t
     @           181*t189*t86+1.9199999999999995d-2*t186*t187*t188*t417-
     1           2.303999999999999d-3*t186*t189*t387*t416-3.6d-3*gammabb
     2           *t187*t208*t389+3.0719999999999986d-3*t209*t386*t387*t3
     3           88-8.639999999999998d-2*t186*t187*t209*t379+5.759999999
     4           999998d-2*gammabb*t187*t188*t189)-3.1999999999999995d-1
     5           *gammabb*t181*t418*t86+6.0d-2*t3*t390*t86+5.86666666666
     6           6666d-1*gammabb*t210*t380*t86-3.1999999999999995d-1*t18
     7           1*t190*t86+1.9199999999999995d-2*t186*t187*t188*t418-2.
     8           303999999999999d-3*t186*t190*t387*t416-3.6d-3*gammabb*t
     9           187*t208*t390+3.0719999999999986d-3*t210*t386*t387*t388
     :           -8.639999999999998d-2*t186*t187*t210*t379+5.75999999999
     ;           9998d-2*gammabb*t187*t188*t190)-3.1999999999999995d-1*g
     <           ammabb*t181*t419*t86+6.0d-2*t3*t391*t86+5.8666666666666
     =           66d-1*gammabb*t211*t380*t86-3.1999999999999995d-1*t181*
     >           t191*t86+1.9199999999999995d-2*t186*t187*t188*t419-2.30
     ?           3999999999999d-3*t186*t191*t387*t416-3.6d-3*gammabb*t18
     @           7*t208*t391+3.0719999999999986d-3*t211*t386*t387*t388-8
     1           .639999999999998d-2*t186*t187*t211*t379+5.7599999999999
     2           98d-2*gammabb*t187*t188*t191)*t93+1.0d+0*t38*t420*t93+1
     3           .0d+0*rhob*t169*t420*t93+5.0d-1*rhob*t212*t353*t93+1.0d
     4           +0*t169*t212*t93-1.25d-1*t169*t90*t92+1.25d-1*gammabb*t
     5           38*t420*t92-1.25d-1*t192*t38*t92+1.25d-1*gammabb*t169*t
     6           212*t92+1.25d-1*t38*t385*t90-1.25d-1*t353*t90-1.25d-1*t
     7           38*t392+1.25d-1*gammabb*t212*t38*t385-2.5d-1*t169*t192)
     8           +(t611+t610+1.25d-1*gammabb*t38*t420+1.25d-1*gammabb*t1
     9           69*t212)*t91*t92+t385*t609*t91+1.0d+0*t70*(3.0311111111
     :           111105d-2*t380*t6*t9-3.9403562666666647d-9*t186*t388*t4
     ;           *t448*t9-9.396444444444442d-5*t147*t380*t4*t9+1.4299679
     <           999999995d-6*gammabb*t311*t379*t4*t9+1.271082666666666d
     =           -6*t186*t311*t388*t9-4.612799999999999d-4*gammabb*t147*
     >           t379*t9+3.1d-3*t4*t6*(3.0311111111111105d-2*t380*t6*t8-
     ?           3.9403562666666647d-9*t186*t388*t4*t448*t8-9.3964444444
     @           44442d-5*t147*t380*t4*t8+1.4299679999999995d-6*gammabb*
     1           t311*t379*t4*t8+1.271082666666666d-6*t186*t311*t388*t8-
     2           4.612799999999999d-4*gammabb*t147*t379*t8+3.1d-3*t4*t6*
     3           (3.0311111111111105d-2*t380*t6*t7-3.9403562666666647d-9
     4           *t186*t388*t4*t448*t7-9.396444444444442d-5*t147*t380*t4
     5           *t7+1.4299679999999995d-6*gammabb*t311*t379*t4*t7+1.271
     6           082666666666d-6*t186*t311*t388*t7-4.612799999999999d-4*
     7           gammabb*t147*t379*t7+3.1d-3*t4*t6*(3.0311111111111105d-
     8           2*t1*t380*t6-3.9403562666666647d-9*t1*t186*t388*t4*t448
     9           -9.396444444444442d-5*t1*t147*t380*t4+1.429967999999999
     :           5d-6*gammabb*t1*t311*t379*t4+1.271082666666666d-6*t1*t1
     ;           86*t311*t388-4.612799999999999d-4*gammabb*t1*t147*t379)
     <           -1.653333333333333d-2*gammabb*t181*t411*t6+3.1d-3*t3*t3
     =           81*t6+3.0311111111111105d-2*gammabb*t203*t380*t6-1.6533
     >           33333333333d-2*t181*t182*t6+5.125333333333332d-5*gammab
     ?           b*t147*t181*t4*t411-9.61d-6*t147*t3*t381*t4-9.396444444
     @           444442d-5*gammabb*t147*t203*t380*t4+4.2369422222222203d
     1           -7*t186*t203*t311*t379*t4-3.1777066666666653d-7*gammabb
     2           *t182*t188*t311*t4+5.125333333333332d-5*t147*t181*t182*
     3           t4-1.366755555555555d-4*t147*t186*t203*t379+1.025066666
     4           6666663d-4*gammabb*t147*t182*t188)-1.653333333333333d-2
     5           *gammabb*t181*t412*t6+3.1d-3*t3*t382*t6+3.0311111111111
     6           105d-2*gammabb*t204*t380*t6-1.653333333333333d-2*t181*t
     7           183*t6+5.125333333333332d-5*gammabb*t147*t181*t4*t412-9
     8           .61d-6*t147*t3*t382*t4-9.396444444444442d-5*gammabb*t14
     9           7*t204*t380*t4+4.2369422222222203d-7*t186*t204*t311*t37
     :           9*t4-3.1777066666666653d-7*gammabb*t183*t188*t311*t4+5.
     ;           125333333333332d-5*t147*t181*t183*t4-1.366755555555555d
     <           -4*t147*t186*t204*t379+1.0250666666666663d-4*gammabb*t1
     =           47*t183*t188)-1.653333333333333d-2*gammabb*t181*t413*t6
     >           +3.1d-3*t3*t383*t6+3.0311111111111105d-2*gammabb*t205*t
     ?           380*t6-1.653333333333333d-2*t181*t184*t6+5.125333333333
     @           332d-5*gammabb*t147*t181*t4*t413-9.61d-6*t147*t3*t383*t
     1           4-9.396444444444442d-5*gammabb*t147*t205*t380*t4+4.2369
     2           422222222203d-7*t186*t205*t311*t379*t4-3.17770666666666
     3           53d-7*gammabb*t184*t188*t311*t4+5.125333333333332d-5*t1
     4           47*t181*t184*t4-1.366755555555555d-4*t147*t186*t205*t37
     5           9+1.0250666666666663d-4*gammabb*t147*t184*t188)+2.0d+0*
     6           t180*t414+1.0d+0*t206*t378)*wght+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (1.0d+0*t70*(1.4776335999999993d
     1           -9*gammaaa*t398*t4*t448*t9-3.1777066666666653d-7*t154*t
     2           311*t4*t9-4.766559999999998d-7*gammaaa*t311*t398*t9+1.0
     3           250666666666663d-4*t147*t154*t9+3.1d-3*t4*t6*(1.4776335
     4           999999993d-9*gammaaa*t398*t4*t448*t8-3.1777066666666653
     5           d-7*t154*t311*t4*t8-4.766559999999998d-7*gammaaa*t311*t
     6           398*t8+1.0250666666666663d-4*t147*t154*t8+3.1d-3*t4*t6*
     7           (1.4776335999999993d-9*gammaaa*t398*t4*t448*t7-3.177706
     8           6666666653d-7*t154*t311*t4*t7-4.766559999999998d-7*gamm
     9           aaa*t311*t398*t7+1.0250666666666663d-4*t147*t154*t7+3.1
     :           d-3*t4*(1.4776335999999993d-9*gammaaa*t1*t398*t4*t448-3
     ;           .1777066666666653d-7*t1*t154*t311*t4-4.766559999999998d
     <           -7*gammaaa*t1*t311*t398+1.0250666666666663d-4*t1*t147*t
     =           154)*t6-8.266666666666665d-3*gammaaa*t146*t421*t6+6.2d-
     >           3*t2*t393*t6-1.653333333333333d-2*t146*t193*t6+2.562666
     ?           666666666d-5*gammaaa*t146*t147*t4*t421-1.92199999999999
     @           98d-5*t147*t2*t393*t4+5.9582d-8*t148*t198*t311*t4-3.177
     1           7066666666653d-7*gammaaa*t154*t193*t311*t4+5.1253333333
     2           33332d-5*t146*t147*t193*t4-1.9219999999999998d-5*t147*t
     3           148*t198+1.0250666666666663d-4*gammaaa*t147*t154*t193)-
     4           8.266666666666665d-3*gammaaa*t146*t422*t6+6.2d-3*t2*t39
     5           4*t6-1.653333333333333d-2*t146*t194*t6+2.56266666666666
     6           6d-5*gammaaa*t146*t147*t4*t422-1.9219999999999998d-5*t1
     7           47*t2*t394*t4+5.9582d-8*t149*t198*t311*t4-3.17770666666
     8           66653d-7*gammaaa*t154*t194*t311*t4+5.125333333333332d-5
     9           *t146*t147*t194*t4-1.9219999999999998d-5*t147*t149*t198
     :           +1.0250666666666663d-4*gammaaa*t147*t154*t194)-8.266666
     ;           666666665d-3*gammaaa*t146*t423*t6+6.2d-3*t2*t395*t6-1.6
     <           53333333333333d-2*t146*t195*t6+2.562666666666666d-5*gam
     =           maaa*t146*t147*t4*t423-1.9219999999999998d-5*t147*t2*t3
     >           95*t4+5.9582d-8*t150*t198*t311*t4-3.1777066666666653d-7
     ?           *gammaaa*t154*t195*t311*t4+5.125333333333332d-5*t146*t1
     @           47*t195*t4-1.9219999999999998d-5*t147*t150*t198+1.02506
     1           66666666663d-4*gammaaa*t147*t154*t195)+t82*(5.0d-1*rhoa
     2           *t24*(2.073599999999999d-4*t152*t544*t614*t80-5.7599999
     3           99999997d-3*gammaaa*t319*t398*t80+3.839999999999999d-2*
     4           t153*t154*t80+6.0d-2*gammaaa*t2*t73*(2.073599999999999d
     5           -4*t152*t544*t614*t79-5.759999999999997d-3*gammaaa*t319
     6           *t398*t79+3.839999999999999d-2*t153*t154*t79+6.0d-2*gam
     7           maaa*t2*t73*(2.073599999999999d-4*t152*t544*t614*t78-5.
     8           759999999999997d-3*gammaaa*t319*t398*t78+3.839999999999
     9           999d-2*t153*t154*t78+6.0d-2*gammaaa*t2*t73*(2.073599999
     :           999999d-4*t152*t544*t614*t77-5.759999999999997d-3*gamma
     ;           aa*t319*t398*t77+3.839999999999999d-2*t153*t154*t77)-1.
     <           5999999999999998d-1*gammaaa*t146*t426*t73+1.2d-1*t2*t39
     =           9*t73-3.1999999999999995d-1*t146*t199*t73+9.59999999999
     >           9997d-3*t152*t153*t154*t426+4.32d-4*gammaaa*t155*t319*t
     ?           425-7.2d-3*gammaaa*t153*t198*t399-2.303999999999999d-3*
     @           t152*t199*t319*t398+5.759999999999998d-2*gammaaa*t153*t
     1           154*t199-7.2d-3*t153*t155*t198)-1.5999999999999998d-1*g
     2           ammaaa*t146*t427*t73+1.2d-1*t2*t400*t73-3.1999999999999
     3           995d-1*t146*t200*t73+9.599999999999997d-3*t152*t153*t15
     4           4*t427+4.32d-4*gammaaa*t156*t319*t425-7.2d-3*gammaaa*t1
     5           53*t198*t400-2.303999999999999d-3*t152*t200*t319*t398+5
     6           .759999999999998d-2*gammaaa*t153*t154*t200-7.2d-3*t153*
     7           t156*t198)-1.5999999999999998d-1*gammaaa*t146*t428*t73+
     8           1.2d-1*t2*t401*t73-3.1999999999999995d-1*t146*t201*t73+
     9           9.599999999999997d-3*t152*t153*t154*t428+4.32d-4*gammaa
     :           a*t157*t319*t425-7.2d-3*gammaaa*t153*t198*t401-2.303999
     ;           999999999d-3*t152*t201*t319*t398+5.759999999999998d-2*g
     <           ammaaa*t153*t154*t201-7.2d-3*t153*t157*t198)*t84+5.0d-1
     =           *t24*t429*t84+5.0d-1*rhoa*t104*t429*t84-2.5d-1*t202*t24
     >           *t83-2.5d-1*t24*t402-2.5d-1*t104*t202)+(t613+1.25d-1*ga
     ?           mmaaa*t24*t429)*t82*t83+1.0d+0*t145*t424)*wght+Cmat3(iq
     @           ,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (1.0d+0*t70*(1.4776335999999993d
     1           -9*gammaaa*t154*t3*t4*t448*t9-1.5888533333333327d-7*t14
     2           6*t3*t311*t4*t9-4.766559999999998d-7*gammaaa*t154*t3*t3
     3           11*t9+5.125333333333332d-5*t146*t147*t3*t9+3.1d-3*t4*t6
     4           *(1.4776335999999993d-9*gammaaa*t154*t3*t4*t448*t8-1.58
     5           88533333333327d-7*t146*t3*t311*t4*t8-4.766559999999998d
     6           -7*gammaaa*t154*t3*t311*t8+5.125333333333332d-5*t146*t1
     7           47*t3*t8+3.1d-3*t4*t6*(1.4776335999999993d-9*gammaaa*t1
     8           54*t3*t4*t448*t7-1.5888533333333327d-7*t146*t3*t311*t4*
     9           t7-4.766559999999998d-7*gammaaa*t154*t3*t311*t7+5.12533
     :           3333333332d-5*t146*t147*t3*t7+3.1d-3*t4*(1.477633599999
     ;           9993d-9*gammaaa*t1*t154*t3*t4*t448-1.5888533333333327d-
     <           7*t1*t146*t3*t311*t4-4.766559999999998d-7*gammaaa*t1*t1
     =           54*t3*t311+5.125333333333332d-5*t1*t146*t147*t3)*t6-8.2
     >           66666666666665d-3*gammaaa*t146*t430*t6+3.1d-3*t2*t403*t
     ?           6+3.1d-3*t3*t393*t6-8.266666666666665d-3*t146*t203*t6+2
     @           .562666666666666d-5*gammaaa*t146*t147*t4*t430-9.61d-6*t
     1           147*t2*t4*t403-9.61d-6*t147*t3*t393*t4+5.9582d-8*t148*t
     2           2*t3*t311*t4-1.5888533333333327d-7*gammaaa*t146*t193*t3
     3           *t311*t4-1.5888533333333327d-7*gammaaa*t154*t203*t311*t
     4           4+2.562666666666666d-5*t146*t147*t203*t4-1.921999999999
     5           9998d-5*t147*t148*t2*t3+5.125333333333332d-5*gammaaa*t1
     6           46*t147*t193*t3+5.125333333333332d-5*gammaaa*t147*t154*
     7           t203)-8.266666666666665d-3*gammaaa*t146*t431*t6+3.1d-3*
     8           t2*t404*t6+3.1d-3*t3*t394*t6-8.266666666666665d-3*t146*
     9           t204*t6+2.562666666666666d-5*gammaaa*t146*t147*t4*t431-
     :           9.61d-6*t147*t2*t4*t404-9.61d-6*t147*t3*t394*t4+5.9582d
     ;           -8*t149*t2*t3*t311*t4-1.5888533333333327d-7*gammaaa*t14
     <           6*t194*t3*t311*t4-1.5888533333333327d-7*gammaaa*t154*t2
     =           04*t311*t4+2.562666666666666d-5*t146*t147*t204*t4-1.921
     >           9999999999998d-5*t147*t149*t2*t3+5.125333333333332d-5*g
     ?           ammaaa*t146*t147*t194*t3+5.125333333333332d-5*gammaaa*t
     @           147*t154*t204)-8.266666666666665d-3*gammaaa*t146*t432*t
     1           6+3.1d-3*t2*t405*t6+3.1d-3*t3*t395*t6-8.266666666666665
     2           d-3*t146*t205*t6+2.562666666666666d-5*gammaaa*t146*t147
     3           *t4*t432-9.61d-6*t147*t2*t4*t405-9.61d-6*t147*t3*t395*t
     4           4+5.9582d-8*t150*t2*t3*t311*t4-1.5888533333333327d-7*ga
     5           mmaaa*t146*t195*t3*t311*t4-1.5888533333333327d-7*gammaa
     6           a*t154*t205*t311*t4+2.562666666666666d-5*t146*t147*t205
     7           *t4-1.9219999999999998d-5*t147*t150*t2*t3+5.12533333333
     8           3332d-5*gammaaa*t146*t147*t195*t3+5.125333333333332d-5*
     9           gammaaa*t147*t154*t205)+1.0d+0*t145*t433)*wght+Cmat3(iq
     :           ,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*t70*(1.4776335999999993d
     1           -9*gammaaa*t146*t208*t4*t448*t9-4.766559999999998d-7*ga
     2           mmaaa*t146*t208*t311*t9+3.1d-3*t4*t6*(1.477633599999999
     3           3d-9*gammaaa*t146*t208*t4*t448*t8-4.766559999999998d-7*
     4           gammaaa*t146*t208*t311*t8+3.1d-3*t4*t6*(1.4776335999999
     5           993d-9*gammaaa*t146*t208*t4*t448*t7-4.766559999999998d-
     6           7*gammaaa*t146*t208*t311*t7+3.1d-3*t4*(1.47763359999999
     7           93d-9*gammaaa*t1*t146*t208*t4*t448-4.766559999999998d-7
     8           *gammaaa*t1*t146*t208*t311)*t6-8.266666666666665d-3*gam
     9           maaa*t146*t434*t6+6.2d-3*t3*t403*t6+2.562666666666666d-
     :           5*gammaaa*t146*t147*t4*t434-1.9219999999999998d-5*t147*
     ;           t3*t4*t403-3.1777066666666653d-7*gammaaa*t146*t203*t3*t
     <           311*t4+5.9582d-8*t148*t208*t311*t4+1.0250666666666663d-
     =           4*gammaaa*t146*t147*t203*t3-1.9219999999999998d-5*t147*
     >           t148*t208)-8.266666666666665d-3*gammaaa*t146*t435*t6+6.
     ?           2d-3*t3*t404*t6+2.562666666666666d-5*gammaaa*t146*t147*
     @           t4*t435-1.9219999999999998d-5*t147*t3*t4*t404-3.1777066
     1           666666653d-7*gammaaa*t146*t204*t3*t311*t4+5.9582d-8*t14
     2           9*t208*t311*t4+1.0250666666666663d-4*gammaaa*t146*t147*
     3           t204*t3-1.9219999999999998d-5*t147*t149*t208)-8.2666666
     4           66666665d-3*gammaaa*t146*t436*t6+6.2d-3*t3*t405*t6+2.56
     5           2666666666666d-5*gammaaa*t146*t147*t4*t436-1.9219999999
     6           999998d-5*t147*t3*t4*t405-3.1777066666666653d-7*gammaaa
     7           *t146*t205*t3*t311*t4+5.9582d-8*t150*t208*t311*t4+1.025
     8           0666666666663d-4*gammaaa*t146*t147*t205*t3-1.9219999999
     9           999998d-5*t147*t150*t208)+1.0d+0*t145*t437)*wght+Cmat3(
     :           iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (1.0d+0*t70*(1.4776335999999993d
     1           -9*gammabb*t181*t198*t4*t448*t9-4.766559999999998d-7*ga
     2           mmabb*t181*t198*t311*t9+3.1d-3*t4*t6*(1.477633599999999
     3           3d-9*gammabb*t181*t198*t4*t448*t8-4.766559999999998d-7*
     4           gammabb*t181*t198*t311*t8+3.1d-3*t4*t6*(1.4776335999999
     5           993d-9*gammabb*t181*t198*t4*t448*t7-4.766559999999998d-
     6           7*gammabb*t181*t198*t311*t7+3.1d-3*t4*(1.47763359999999
     7           93d-9*gammabb*t1*t181*t198*t4*t448-4.766559999999998d-7
     8           *gammabb*t1*t181*t198*t311)*t6-8.266666666666665d-3*gam
     9           mabb*t181*t421*t6+6.2d-3*t2*t407*t6+2.562666666666666d-
     :           5*gammabb*t147*t181*t4*t421-1.9219999999999998d-5*t147*
     ;           t2*t4*t407-3.1777066666666653d-7*gammabb*t181*t193*t2*t
     <           311*t4+5.9582d-8*t182*t198*t311*t4+1.0250666666666663d-
     =           4*gammabb*t147*t181*t193*t2-1.9219999999999998d-5*t147*
     >           t182*t198)-8.266666666666665d-3*gammabb*t181*t422*t6+6.
     ?           2d-3*t2*t408*t6+2.562666666666666d-5*gammabb*t147*t181*
     @           t4*t422-1.9219999999999998d-5*t147*t2*t4*t408-3.1777066
     1           666666653d-7*gammabb*t181*t194*t2*t311*t4+5.9582d-8*t18
     2           3*t198*t311*t4+1.0250666666666663d-4*gammabb*t147*t181*
     3           t194*t2-1.9219999999999998d-5*t147*t183*t198)-8.2666666
     4           66666665d-3*gammabb*t181*t423*t6+6.2d-3*t2*t409*t6+2.56
     5           2666666666666d-5*gammabb*t147*t181*t4*t423-1.9219999999
     6           999998d-5*t147*t2*t4*t409-3.1777066666666653d-7*gammabb
     7           *t181*t195*t2*t311*t4+5.9582d-8*t184*t198*t311*t4+1.025
     8           0666666666663d-4*gammabb*t147*t181*t195*t2-1.9219999999
     9           999998d-5*t147*t184*t198)+1.0d+0*t180*t424)*wght+Cmat3(
     :           iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = (1.0d+0*t70*(1.4776335999999993d
     1           -9*gammabb*t188*t2*t4*t448*t9-1.5888533333333327d-7*t18
     2           1*t2*t311*t4*t9-4.766559999999998d-7*gammabb*t188*t2*t3
     3           11*t9+5.125333333333332d-5*t147*t181*t2*t9+3.1d-3*t4*t6
     4           *(1.4776335999999993d-9*gammabb*t188*t2*t4*t448*t8-1.58
     5           88533333333327d-7*t181*t2*t311*t4*t8-4.766559999999998d
     6           -7*gammabb*t188*t2*t311*t8+5.125333333333332d-5*t147*t1
     7           81*t2*t8+3.1d-3*t4*t6*(1.4776335999999993d-9*gammabb*t1
     8           88*t2*t4*t448*t7-1.5888533333333327d-7*t181*t2*t311*t4*
     9           t7-4.766559999999998d-7*gammabb*t188*t2*t311*t7+5.12533
     :           3333333332d-5*t147*t181*t2*t7+3.1d-3*t4*(1.477633599999
     ;           9993d-9*gammabb*t1*t188*t2*t4*t448-1.5888533333333327d-
     <           7*t1*t181*t2*t311*t4-4.766559999999998d-7*gammabb*t1*t1
     =           88*t2*t311+5.125333333333332d-5*t1*t147*t181*t2)*t6-8.2
     >           66666666666665d-3*gammabb*t181*t430*t6+3.1d-3*t2*t411*t
     ?           6+3.1d-3*t3*t407*t6-8.266666666666665d-3*t181*t193*t6+2
     @           .562666666666666d-5*gammabb*t147*t181*t4*t430-9.61d-6*t
     1           147*t2*t4*t411-9.61d-6*t147*t3*t4*t407+5.9582d-8*t182*t
     2           2*t3*t311*t4-1.5888533333333327d-7*gammabb*t181*t2*t203
     3           *t311*t4-1.5888533333333327d-7*gammabb*t188*t193*t311*t
     4           4+2.562666666666666d-5*t147*t181*t193*t4-1.921999999999
     5           9998d-5*t147*t182*t2*t3+5.125333333333332d-5*gammabb*t1
     6           47*t181*t2*t203+5.125333333333332d-5*gammabb*t147*t188*
     7           t193)-8.266666666666665d-3*gammabb*t181*t431*t6+3.1d-3*
     8           t2*t412*t6+3.1d-3*t3*t408*t6-8.266666666666665d-3*t181*
     9           t194*t6+2.562666666666666d-5*gammabb*t147*t181*t4*t431-
     :           9.61d-6*t147*t2*t4*t412-9.61d-6*t147*t3*t4*t408+5.9582d
     ;           -8*t183*t2*t3*t311*t4-1.5888533333333327d-7*gammabb*t18
     <           1*t2*t204*t311*t4-1.5888533333333327d-7*gammabb*t188*t1
     =           94*t311*t4+2.562666666666666d-5*t147*t181*t194*t4-1.921
     >           9999999999998d-5*t147*t183*t2*t3+5.125333333333332d-5*g
     ?           ammabb*t147*t181*t2*t204+5.125333333333332d-5*gammabb*t
     @           147*t188*t194)-8.266666666666665d-3*gammabb*t181*t432*t
     1           6+3.1d-3*t2*t413*t6+3.1d-3*t3*t409*t6-8.266666666666665
     2           d-3*t181*t195*t6+2.562666666666666d-5*gammabb*t147*t181
     3           *t4*t432-9.61d-6*t147*t2*t4*t413-9.61d-6*t147*t3*t4*t40
     4           9+5.9582d-8*t184*t2*t3*t311*t4-1.5888533333333327d-7*ga
     5           mmabb*t181*t2*t205*t311*t4-1.5888533333333327d-7*gammab
     6           b*t188*t195*t311*t4+2.562666666666666d-5*t147*t181*t195
     7           *t4-1.9219999999999998d-5*t147*t184*t2*t3+5.12533333333
     8           3332d-5*gammabb*t147*t181*t2*t205+5.125333333333332d-5*
     9           gammabb*t147*t188*t195)+1.0d+0*t180*t433)*wght+Cmat3(iq
     :           ,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t91*(5.0d-1*rhob*t38*(2.0735999
     1           99999999d-4*t186*t603*t616*t89-5.759999999999997d-3*gam
     2           mabb*t387*t416*t89+3.839999999999999d-2*t187*t188*t89+6
     3           .0d-2*gammabb*t3*t86*(2.073599999999999d-4*t186*t603*t6
     4           16*t88-5.759999999999997d-3*gammabb*t387*t416*t88+3.839
     5           999999999999d-2*t187*t188*t88+6.0d-2*gammabb*t3*t86*(2.
     6           073599999999999d-4*t186*t603*t616*t87-5.759999999999997
     7           d-3*gammabb*t387*t416*t87+3.839999999999999d-2*t187*t18
     8           8*t87+6.0d-2*gammabb*t3*(2.073599999999999d-4*t186*t603
     9           *t616*t77-5.759999999999997d-3*gammabb*t387*t416*t77+3.
     :           839999999999999d-2*t187*t188*t77)*t86-1.599999999999999
     ;           8d-1*gammabb*t181*t439*t86+1.2d-1*t3*t417*t86-3.1999999
     <           999999995d-1*t181*t209*t86+9.599999999999997d-3*t186*t1
     =           87*t188*t439+4.32d-4*gammabb*t189*t387*t438-7.2d-3*gamm
     >           abb*t187*t208*t417-2.303999999999999d-3*t186*t209*t387*
     ?           t416+5.759999999999998d-2*gammabb*t187*t188*t209-7.2d-3
     @           *t187*t189*t208)-1.5999999999999998d-1*gammabb*t181*t44
     1           0*t86+1.2d-1*t3*t418*t86-3.1999999999999995d-1*t181*t21
     2           0*t86+9.599999999999997d-3*t186*t187*t188*t440+4.32d-4*
     3           gammabb*t190*t387*t438-7.2d-3*gammabb*t187*t208*t418-2.
     4           303999999999999d-3*t186*t210*t387*t416+5.75999999999999
     5           8d-2*gammabb*t187*t188*t210-7.2d-3*t187*t190*t208)-1.59
     6           99999999999998d-1*gammabb*t181*t441*t86+1.2d-1*t3*t419*
     7           t86-3.1999999999999995d-1*t181*t211*t86+9.5999999999999
     8           97d-3*t186*t187*t188*t441+4.32d-4*gammabb*t191*t387*t43
     9           8-7.2d-3*gammabb*t187*t208*t419-2.303999999999999d-3*t1
     :           86*t211*t387*t416+5.759999999999998d-2*gammabb*t187*t18
     ;           8*t211-7.2d-3*t187*t191*t208)*t93+5.0d-1*t38*t442*t93+5
     <           .0d-1*rhob*t169*t442*t93-2.5d-1*t212*t38*t92-2.5d-1*t38
     =           *t420-2.5d-1*t169*t212)+(t615+1.25d-1*gammabb*t38*t442)
     >           *t91*t92+1.0d+0*t70*(1.4776335999999993d-9*gammabb*t4*t
     ?           416*t448*t9-4.766559999999998d-7*gammabb*t311*t416*t9-3
     @           .1777066666666653d-7*t188*t311*t4*t9+1.0250666666666663
     1           d-4*t147*t188*t9+3.1d-3*t4*t6*(1.4776335999999993d-9*ga
     2           mmabb*t4*t416*t448*t8-4.766559999999998d-7*gammabb*t311
     3           *t416*t8-3.1777066666666653d-7*t188*t311*t4*t8+1.025066
     4           6666666663d-4*t147*t188*t8+3.1d-3*t4*t6*(1.477633599999
     5           9993d-9*gammabb*t4*t416*t448*t7-4.766559999999998d-7*ga
     6           mmabb*t311*t416*t7-3.1777066666666653d-7*t188*t311*t4*t
     7           7+1.0250666666666663d-4*t147*t188*t7+3.1d-3*t4*(1.47763
     8           35999999993d-9*gammabb*t1*t4*t416*t448-4.76655999999999
     9           8d-7*gammabb*t1*t311*t416-3.1777066666666653d-7*t1*t188
     :           *t311*t4+1.0250666666666663d-4*t1*t147*t188)*t6-8.26666
     ;           6666666665d-3*gammabb*t181*t434*t6+6.2d-3*t3*t411*t6-1.
     <           653333333333333d-2*t181*t203*t6+2.562666666666666d-5*ga
     =           mmabb*t147*t181*t4*t434-1.9219999999999998d-5*t147*t3*t
     >           4*t411+5.9582d-8*t182*t208*t311*t4-3.1777066666666653d-
     ?           7*gammabb*t188*t203*t311*t4+5.125333333333332d-5*t147*t
     @           181*t203*t4-1.9219999999999998d-5*t147*t182*t208+1.0250
     1           666666666663d-4*gammabb*t147*t188*t203)-8.2666666666666
     2           65d-3*gammabb*t181*t435*t6+6.2d-3*t3*t412*t6-1.65333333
     3           3333333d-2*t181*t204*t6+2.562666666666666d-5*gammabb*t1
     4           47*t181*t4*t435-1.9219999999999998d-5*t147*t3*t4*t412+5
     5           .9582d-8*t183*t208*t311*t4-3.1777066666666653d-7*gammab
     6           b*t188*t204*t311*t4+5.125333333333332d-5*t147*t181*t204
     7           *t4-1.9219999999999998d-5*t147*t183*t208+1.025066666666
     8           6663d-4*gammabb*t147*t188*t204)-8.266666666666665d-3*ga
     9           mmabb*t181*t436*t6+6.2d-3*t3*t413*t6-1.653333333333333d
     :           -2*t181*t205*t6+2.562666666666666d-5*gammabb*t147*t181*
     ;           t4*t436-1.9219999999999998d-5*t147*t3*t4*t413+5.9582d-8
     <           *t184*t208*t311*t4-3.1777066666666653d-7*gammabb*t188*t
     =           205*t311*t4+5.125333333333332d-5*t147*t181*t205*t4-1.92
     >           19999999999998d-5*t147*t184*t208+1.0250666666666663d-4*
     ?           gammabb*t147*t188*t205)+1.0d+0*t180*t437)*wght+Cmat3(iq
     @           ,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t70*(-5.541126d-10*t4*t
     1           425*t448*t9+1.78746d-7*t311*t425*t9+3.1d-3*t4*t6*(-5.54
     2           1126d-10*t4*t425*t448*t8+1.78746d-7*t311*t425*t8+3.1d-3
     3           *t4*t6*(-5.541126d-10*t4*t425*t448*t7+1.78746d-7*t311*t
     4           425*t7+3.1d-3*t4*(1.78746d-7*t1*t311*t425-5.541126d-10*
     5           t1*t4*t425*t448)*t6+9.299999999999999d-3*t2*t421*t6-2.8
     6           83d-5*t147*t2*t4*t421+1.78746d-7*t193*t198*t311*t4-5.76
     7           6d-5*t147*t193*t198)+9.299999999999999d-3*t2*t422*t6-2.
     8           883d-5*t147*t2*t4*t422+1.78746d-7*t194*t198*t311*t4-5.7
     9           66d-5*t147*t194*t198)+9.299999999999999d-3*t2*t423*t6-2
     :           .883d-5*t147*t2*t4*t423+1.78746d-7*t195*t198*t311*t4-5.
     ;           766d-5*t147*t195*t198)+t82*(5.0d-1*rhoa*t24*(-7.776d-5*
     <           gammaaa*t544*t617*t80+1.296d-3*t319*t425*t80+6.0d-2*gam
     =           maaa*t2*t73*(-7.776d-5*gammaaa*t544*t617*t79+1.296d-3*t
     >           319*t425*t79+6.0d-2*gammaaa*t2*t73*(-7.776d-5*gammaaa*t
     ?           544*t617*t78+1.296d-3*t319*t425*t78+6.0d-2*gammaaa*t2*t
     @           73*(1.296d-3*t319*t425*t77-7.776d-5*gammaaa*t544*t617*t
     1           77)+1.8d-1*t2*t426*t73-1.0800000000000001d-2*gammaaa*t1
     2           53*t198*t426+1.296d-3*gammaaa*t199*t319*t425-2.16000000
     3           00000003d-2*t153*t198*t199)+1.8d-1*t2*t427*t73-1.080000
     4           0000000001d-2*gammaaa*t153*t198*t427+1.296d-3*gammaaa*t
     5           200*t319*t425-2.1600000000000003d-2*t153*t198*t200)+1.8
     6           d-1*t2*t428*t73-1.0800000000000001d-2*gammaaa*t153*t198
     7           *t428+1.296d-3*gammaaa*t201*t319*t425-2.160000000000000
     8           3d-2*t153*t198*t201)*t84-3.75d-1*t24*t429))*wght+Cmat3(
     9           iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t70*(-5.541126d-10*t198*
     1           t3*t4*t448*t9+1.78746d-7*t198*t3*t311*t9+3.1d-3*t4*t6*(
     2           -5.541126d-10*t198*t3*t4*t448*t8+1.78746d-7*t198*t3*t31
     3           1*t8+3.1d-3*t4*t6*(-5.541126d-10*t198*t3*t4*t448*t7+1.7
     4           8746d-7*t198*t3*t311*t7+3.1d-3*t4*(1.78746d-7*t1*t198*t
     5           3*t311-5.541126d-10*t1*t198*t3*t4*t448)*t6+6.2d-3*t2*t4
     6           30*t6+3.1d-3*t3*t421*t6-1.9219999999999998d-5*t147*t2*t
     7           4*t430-9.61d-6*t147*t3*t4*t421+1.1916399999999999d-7*t1
     8           93*t2*t3*t311*t4+5.9582d-8*t198*t203*t311*t4-3.84399999
     9           99999996d-5*t147*t193*t2*t3-1.9219999999999998d-5*t147*
     :           t198*t203)+6.2d-3*t2*t431*t6+3.1d-3*t3*t422*t6-1.921999
     ;           9999999998d-5*t147*t2*t4*t431-9.61d-6*t147*t3*t4*t422+1
     <           .1916399999999999d-7*t194*t2*t3*t311*t4+5.9582d-8*t198*
     =           t204*t311*t4-3.8439999999999996d-5*t147*t194*t2*t3-1.92
     >           19999999999998d-5*t147*t198*t204)+6.2d-3*t2*t432*t6+3.1
     ?           d-3*t3*t423*t6-1.9219999999999998d-5*t147*t2*t4*t432-9.
     @           61d-6*t147*t3*t4*t423+1.1916399999999999d-7*t195*t2*t3*
     1           t311*t4+5.9582d-8*t198*t205*t311*t4-3.8439999999999996d
     2           -5*t147*t195*t2*t3-1.9219999999999998d-5*t147*t198*t205
     3           )*wght+Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = 1.0d+0*t70*(-5.541126d-10*t2*t2
     1           08*t4*t448*t9+1.78746d-7*t2*t208*t311*t9+3.1d-3*t4*t6*(
     2           -5.541126d-10*t2*t208*t4*t448*t8+1.78746d-7*t2*t208*t31
     3           1*t8+3.1d-3*t4*t6*(-5.541126d-10*t2*t208*t4*t448*t7+1.7
     4           8746d-7*t2*t208*t311*t7+3.1d-3*t4*(1.78746d-7*t1*t2*t20
     5           8*t311-5.541126d-10*t1*t2*t208*t4*t448)*t6+3.1d-3*t2*t4
     6           34*t6+6.2d-3*t3*t430*t6-9.61d-6*t147*t2*t4*t434-1.92199
     7           99999999998d-5*t147*t3*t4*t430+1.1916399999999999d-7*t2
     8           *t203*t3*t311*t4+5.9582d-8*t193*t208*t311*t4-3.84399999
     9           99999996d-5*t147*t2*t203*t3-1.9219999999999998d-5*t147*
     :           t193*t208)+3.1d-3*t2*t435*t6+6.2d-3*t3*t431*t6-9.61d-6*
     ;           t147*t2*t4*t435-1.9219999999999998d-5*t147*t3*t4*t431+1
     <           .1916399999999999d-7*t2*t204*t3*t311*t4+5.9582d-8*t194*
     =           t208*t311*t4-3.8439999999999996d-5*t147*t2*t204*t3-1.92
     >           19999999999998d-5*t147*t194*t208)+3.1d-3*t2*t436*t6+6.2
     ?           d-3*t3*t432*t6-9.61d-6*t147*t2*t4*t436-1.92199999999999
     @           98d-5*t147*t3*t4*t432+1.1916399999999999d-7*t2*t205*t3*
     1           t311*t4+5.9582d-8*t195*t208*t311*t4-3.8439999999999996d
     2           -5*t147*t2*t205*t3-1.9219999999999998d-5*t147*t195*t208
     3           )*wght+Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = (t91*(5.0d-1*rhob*t38*(-7.776d-
     1           5*gammabb*t603*t618*t89+1.296d-3*t387*t438*t89+6.0d-2*g
     2           ammabb*t3*t86*(-7.776d-5*gammabb*t603*t618*t88+1.296d-3
     3           *t387*t438*t88+6.0d-2*gammabb*t3*t86*(-7.776d-5*gammabb
     4           *t603*t618*t87+1.296d-3*t387*t438*t87+6.0d-2*gammabb*t3
     5           *(1.296d-3*t387*t438*t77-7.776d-5*gammabb*t603*t618*t77
     6           )*t86+1.8d-1*t3*t439*t86-1.0800000000000001d-2*gammabb*
     7           t187*t208*t439+1.296d-3*gammabb*t209*t387*t438-2.160000
     8           0000000003d-2*t187*t208*t209)+1.8d-1*t3*t440*t86-1.0800
     9           000000000001d-2*gammabb*t187*t208*t440+1.296d-3*gammabb
     :           *t210*t387*t438-2.1600000000000003d-2*t187*t208*t210)+1
     ;           .8d-1*t3*t441*t86-1.0800000000000001d-2*gammabb*t187*t2
     <           08*t441+1.296d-3*gammabb*t211*t387*t438-2.1600000000000
     =           003d-2*t187*t208*t211)*t93-3.75d-1*t38*t442)+1.0d+0*t70
     >           *(-5.541126d-10*t4*t438*t448*t9+1.78746d-7*t311*t438*t9
     ?           +3.1d-3*t4*t6*(-5.541126d-10*t4*t438*t448*t8+1.78746d-7
     @           *t311*t438*t8+3.1d-3*t4*t6*(-5.541126d-10*t4*t438*t448*
     1           t7+1.78746d-7*t311*t438*t7+3.1d-3*t4*(1.78746d-7*t1*t31
     2           1*t438-5.541126d-10*t1*t4*t438*t448)*t6+9.2999999999999
     3           99d-3*t3*t434*t6-2.883d-5*t147*t3*t4*t434+1.78746d-7*t2
     4           03*t208*t311*t4-5.766d-5*t147*t203*t208)+9.299999999999
     5           999d-3*t3*t435*t6-2.883d-5*t147*t3*t4*t435+1.78746d-7*t
     6           204*t208*t311*t4-5.766d-5*t147*t204*t208)+9.29999999999
     7           9999d-3*t3*t436*t6-2.883d-5*t147*t3*t4*t436+1.78746d-7*
     8           t205*t208*t311*t4-5.766d-5*t147*t205*t208))*wght+Cmat3(
     9           iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t213*(-5.0d-1*rhoa*t228*t81*t84-1
     1           .0d+0*t104*t81*t84-5.0d-1*rhoa*t24*t324*t84-1.0d+0*t158
     2           *t24*t84-1.0d+0*rhoa*t104*t158*t84-1.25d-1*gammaaa*t104
     3           *t81*t83-1.25d-1*gammaaa*t158*t24*t83-1.25d-1*gammaaa*t
     4           24*t317*t81)+t213*(-1.25d-1*gammaaa*t104*t81-1.25d-1*ga
     5           mmaaa*t158*t24)*t83+(1.0d+0*rhoa*t228*t81+2.0d+0*t104*t
     6           81+1.0d+0*rhoa*t24*t324+2.0d+0*t158*t24+2.0d+0*rhoa*t10
     7           4*t158)*t82+1.25d-1*gammaaa*t213*t24*t317*t81)*wght+Mma
     8           t3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t214*(-5.0d-1*rhob*t353*t90*t93-1
     1           .0d+0*t169*t90*t93-5.0d-1*rhob*t38*t392*t93-1.0d+0*t192
     2           *t38*t93-1.0d+0*rhob*t169*t192*t93-1.25d-1*gammabb*t169
     3           *t90*t92-1.25d-1*gammabb*t192*t38*t92-1.25d-1*gammabb*t
     4           38*t385*t90)+t214*(-1.25d-1*gammabb*t169*t90-1.25d-1*ga
     5           mmabb*t192*t38)*t92+(1.0d+0*rhob*t353*t90+2.0d+0*t169*t
     6           90+1.0d+0*rhob*t38*t392+2.0d+0*t192*t38+2.0d+0*rhob*t16
     7           9*t192)*t91+1.25d-1*gammabb*t214*t38*t385*t90)*wght+Mma
     8           t3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t213*(-5.0d-1*rhoa*t24*t402*t84-
     1           5.0d-1*t202*t24*t84-5.0d-1*rhoa*t104*t202*t84+1.25d-1*t
     2           24*t81*t83+t607+t606)+t213*t605*t83+(1.0d+0*rhoa*t24*t4
     3           02+1.0d+0*t202*t24+1.0d+0*rhoa*t104*t202)*t82)*wght+Mma
     4           t3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t214*(-5.0d-1*rhob*t38*t420*t93-
     1           5.0d-1*t212*t38*t93-5.0d-1*rhob*t169*t212*t93+1.25d-1*t
     2           38*t90*t92+t611+t610)+t214*t609*t92+(1.0d+0*rhob*t38*t4
     3           20+1.0d+0*t212*t38+1.0d+0*rhob*t169*t212)*t91)*wght+Mma
     4           t3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (t213*(t613-5.0d-1*rhoa*t24*t429*t
     1           84)+1.0d+0*rhoa*t24*t429*t82)*wght+Mmat3(iq,D3_RA_TA_TA
     2           )
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = (t214*(t615-5.0d-1*rhob*t38*t442
     1           *t93)+1.0d+0*rhob*t38*t442*t91)*wght+Mmat3(iq,D3_GAA_GB
     2           B_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (-2*t443*t445-2.0d+0*rhoa*t202*t
     1           213*t24)*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = (-2*t444*t446-2.0d+0*rhob*t212*t2
     1           14*t38)*wght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (6.0d+0*rhoa*t24*t445*t81-3.0d+0*
     1           rhoa*t24*t81*t84/taua**4)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = (6.0d+0*rhob*t38*t446*t90-3.0d+0*
     1           rhob*t38*t90*t93/taub**4)*wght+Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhoa**2.6666666666666666d+0
              t28 = gammaaa*t27+4.0d-50*t2
              t29 = 3.1d-3*t28+1.0d+0
              t30 = 1/t29
              t31 = param(5)
              t32 = 3.1d-3*t28*t30*t31+param(4)
              t33 = 3.1d-3*t28*t30*t32+param(3)
              t34 = 3.1d-3*t28*t30*t33+param(2)
              t35 = 3.1d-3*t28*t30*t34+param(1)
              t36 = 1/rhoa**6.666666666666666d-1
              t37 = rhoa**5.0d-1
              t38 = 1/t37
              t39 = 1/rhoa**3.333333333333333d-1
              t40 = 1/rhoa**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhoa*t49-rhob*t26
              t82 = 6.0d-2*gammaaa*t27+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammaaa*t27*t8*t83+t7
              t85 = 6.0d-2*gammaaa*t27*t83*t84+t6
              t86 = 6.0d-2*gammaaa*t27*t83*t85+t5
              t87 = 6.0d-2*gammaaa*t27*t83*t86+t1
              t88 = 1/taua
              t89 = 1/rhoa
              t90 = 2.0d+0*taua-2.5d-1*gammaaa*t89
              t91 = 1/t46
              t92 = 1/rhoa**1.6666666666666669d+0
              t93 = 1/t37**3
              t94 = 1/rhoa**1.3333333333333333d+0
              t95 = 1/rhoa**1.1666666666666667d+0
              t96 = -9.970917392951799d-1*t95-7.418564737168958d-1*t94-4
     1           .002143174996817d-1*t93-1.264669550498372d-1*t92
              t97 = 1/t45**2
              t98 = 1/t42
              t99 = -1.8533958105157808d+0*t95-1.2815820791490704d+0*t94
     1           -8.223668877838045d-1*t93-1.6039141941921276d-1*t92
              t100 = 1/t41**2
              t101 = 1.0d+0*t100*t44*t98*t99+1.1102230246251565d-16*t48*
     1           t91*t96*t97+3.0506411443514264d-19*t47*t94+1.3210398931
     2           339265d-3*t43*t94
              t102 = 1/t50**1.6666666666666669d+0
              t103 = 1/t63**3
              t104 = 1/t50**1.3333333333333333d+0
              t105 = 1/t50**1.1666666666666667d+0
              t106 = -9.970917392951799d-1*t105-7.418564737168958d-1*t10
     1           4-4.002143174996817d-1*t103-1.264669550498372d-1*t102
              t107 = 1/t66**2
              t108 = 1/t67
              t109 = 1.0d+0*t106*t107*t108*t52*t61
              t110 = -1.3595691172479402d+0*t105-7.491972878592053d-1*t1
     1           04-2.1504862356383217d-1*t103-1.2743417300848914d-1*t10
     2           2
              t111 = 1/t72**2
              t112 = 1/t73
              t113 = -5.848223622634647d-1*t110*t111*t112*t70*t71
              t114 = -1.8533958105157808d+0*t105-1.2815820791490704d+0*t
     1           104-8.223668877838045d-1*t103-1.6039141941921276d-1*t10
     2           2
              t115 = 1/t77**2
              t116 = 1/t78
              t117 = 1.923661050931536d+0*t114*t115*t116*t54*t55*t59*t76
              t118 = 1/t50**2
              t119 = t118*t53
              t120 = -t56
              t121 = t120+t119
              t122 = t57**3.333333333333333d-1
              t123 = -t118*t53
              t124 = t56+t123
              t125 = t58**3.333333333333333d-1
              t126 = 1.3333333333333333d+0*t124*t125+1.3333333333333333d
     1           +0*t121*t122
              t127 = -1.923661050931536d+0*t126*t54*t55
              t128 = 1/t50**5
              t129 = 7.694644203726144d+0*t128*t54*t59
              t130 = t53**3
              t131 = -7.694644203726144d+0*t130*t55*t59
              t132 = t131+t129+t127
              t133 = -6.21814d-2*t132*t52*t68
              t134 = 2.747773264188437d-3*t104*t61*t68
              t135 = t131+t129+t127+1.923661050931536d+0*t126
              t136 = 1.9751631321680768d-2*t135*t70*t74
              t137 = -4.5437964274821163d-4*t104*t71*t74
              t138 = -5.980796863619711d-2*t126*t54*t55*t76*t79
              t139 = 1/t50**5.333333333333333d+0
              t140 = 2.541232989148493d-3*t139*t54*t59*t79
              t141 = 2.3923187454478842d-1*t128*t54*t59*t76*t79
              t142 = t80+t50*(-2.3923187454478842d-1*t130*t55*t59*t76*t7
     1           9+t141+t140+t138+t137+t136+t134+t133+t117+t113+t109)+t7
     2           5+t69+6.903522198342671d-18*t47*t48+3.1090699999999993d
     3           -2*t43*t44-rhoa*t101
              t143 = 1/rhoa**3.6666666666666664d+0
              t144 = 1/t29**2
              t145 = 2.562666666666666d-5*gammaaa*t143*t144*t28*t31-8.26
     1           6666666666665d-3*gammaaa*t143*t30*t31
              t146 = -8.266666666666665d-3*gammaaa*t143*t30*t32+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t32+3.1d-3*t145*t28*
     2           t30
              t147 = -8.266666666666665d-3*gammaaa*t143*t30*t33+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t33+3.1d-3*t146*t28*
     2           t30
              t148 = -8.266666666666665d-3*gammaaa*t143*t30*t34+2.562666
     1           666666666d-5*gammaaa*t143*t144*t28*t34+3.1d-3*t147*t28*
     2           t30
              t149 = gammaaa**2
              t150 = 1/t82**2
              t151 = 1/rhoa**6.333333333333333d+0
              t152 = 9.599999999999997d-3*t149*t150*t151*t8-1.5999999999
     1           999998d-1*gammaaa*t143*t8*t83
              t153 = -1.5999999999999998d-1*gammaaa*t143*t83*t84+9.59999
     1           9999999997d-3*t149*t150*t151*t84+6.0d-2*gammaaa*t152*t2
     2           7*t83
              t154 = -1.5999999999999998d-1*gammaaa*t143*t83*t85+9.59999
     1           9999999997d-3*t149*t150*t151*t85+6.0d-2*gammaaa*t153*t2
     2           7*t83
              t155 = -1.5999999999999998d-1*gammaaa*t143*t83*t86+9.59999
     1           9999999997d-3*t149*t150*t151*t86+6.0d-2*gammaaa*t154*t2
     2           7*t83
              t156 = 1/t23
              t157 = 1/t14**3
              t158 = 1/rhob**1.3333333333333333d+0
              t159 = 1/rhob**1.1666666666666667d+0
              t160 = -1.264669550498372d-1*t2-9.970917392951799d-1*t159-
     1           7.418564737168958d-1*t158-4.002143174996817d-1*t157
              t161 = 1/t22**2
              t162 = 1/t19
              t163 = -1.6039141941921276d-1*t2-1.8533958105157808d+0*t15
     1           9-1.2815820791490704d+0*t158-8.223668877838045d-1*t157
              t164 = 1/t18**2
              t165 = 1.1102230246251565d-16*t156*t160*t161*t25+3.0506411
     1           443514264d-19*t158*t24+1.0d+0*t162*t163*t164*t21+1.3210
     2           398931339265d-3*t158*t20
              t166 = 1/t3**2
              t167 = 1/rhob**4.333333333333333d+0
              t168 = 1/rhob**2.6666666666666666d+0
              t169 = 9.6d-102*t166*t167*t8-4.0d-51*t168*t4*t8
              t170 = -4.0d-51*t168*t4*t9+9.6d-102*t166*t167*t9+2.4d-51*t
     1           169*t2*t4
              t171 = 2.4d-51*t170*t2*t4-4.0d-51*t10*t168*t4+9.6d-102*t10
     1           *t166*t167
              t172 = 2.4d-51*t171*t2*t4-4.0d-51*t11*t168*t4+9.6d-102*t11
     1           *t166*t167
              t173 = t56+t119
              t174 = t123+t120
              t175 = 1.3333333333333333d+0*t125*t174+1.3333333333333333d
     1           +0*t122*t173
              t176 = -1.923661050931536d+0*t175*t54*t55
              t177 = 7.694644203726144d+0*t130*t55*t59
              t178 = t177+t176+t129
              t179 = -6.21814d-2*t178*t52*t68
              t180 = t177+t176+1.923661050931536d+0*t175+t129
              t181 = 1.9751631321680768d-2*t180*t70*t74
              t182 = -5.980796863619711d-2*t175*t54*t55*t76*t79
              t183 = t80+t50*(2.3923187454478842d-1*t130*t55*t59*t76*t79
     1           +t182+t181+t179+t141+t140+t137+t134+t117+t113+t109)+t75
     2           +t69+6.903522198342671d-18*t24*t25+3.1090699999999993d-
     3           2*t20*t21-rhob*t165
              t184 = 6.406666666666666d-55*t144*t168*t28*t31-2.066666666
     1           6666667d-52*t168*t30*t31
              t185 = -2.0666666666666667d-52*t168*t30*t32+6.406666666666
     1           666d-55*t144*t168*t28*t32+3.1d-3*t184*t28*t30
              t186 = -2.0666666666666667d-52*t168*t30*t33+6.406666666666
     1           666d-55*t144*t168*t28*t33+3.1d-3*t185*t28*t30
              t187 = -2.0666666666666667d-52*t168*t30*t34+6.406666666666
     1           666d-55*t144*t168*t28*t34+3.1d-3*t186*t28*t30
              t188 = 3.1d-3*t27*t30*t31-9.61d-6*t144*t27*t28*t31
              t189 = 3.1d-3*t27*t30*t32-9.61d-6*t144*t27*t28*t32+3.1d-3*
     1           t188*t28*t30
              t190 = 3.1d-3*t27*t30*t33-9.61d-6*t144*t27*t28*t33+3.1d-3*
     1           t189*t28*t30
              t191 = 3.1d-3*t27*t30*t34-9.61d-6*t144*t27*t28*t34+3.1d-3*
     1           t190*t28*t30
              t192 = -1.25d-1*t49*t87
              t193 = 1/rhoa**5.333333333333333d+0
              t194 = 6.0d-2*t27*t8*t83-3.6d-3*gammaaa*t150*t193*t8
              t195 = 6.0d-2*t27*t83*t84-3.6d-3*gammaaa*t150*t193*t84+6.0
     1           d-2*gammaaa*t194*t27*t83
              t196 = 6.0d-2*t27*t83*t85-3.6d-3*gammaaa*t150*t193*t85+6.0
     1           d-2*gammaaa*t195*t27*t83
              t197 = 6.0d-2*t27*t83*t86-3.6d-3*gammaaa*t150*t193*t86+6.0
     1           d-2*gammaaa*t196*t27*t83
              t198 = 1/taua**2
              t199 = 1/t46**2
              t200 = t96**2
              t201 = 1/t45**4
              t202 = 1/t45**3
              t203 = 1/t37**5
              t204 = 1/rhoa**2.3333333333333334d+0
              t205 = 1/rhoa**2.1666666666666665d+0
              t206 = 2.1077825841639536d-1*t27+1.1632736958443765d+0*t20
     1           5+9.89141964955861d-1*t204+6.003214762495226d-1*t203
              t207 = 1/t42**2
              t208 = t99**2
              t209 = 1/t41**4
              t210 = 1/t41**3
              t211 = 2.673190323653546d-1*t27+2.1622951122684114d+0*t205
     1           +1.7087761055320938d+0*t204+1.2335503316757068d+0*t203
              t212 = -8.497974591333913d-2*t100*t94*t98*t99+1.0d+0*t100*
     1           t211*t44*t98-2.0d+0*t208*t210*t44*t98-9.812069668265515
     2           d-18*t91*t94*t96*t97+1.1102230246251565d-16*t206*t48*t9
     3           1*t97-2.220446049250313d-16*t200*t202*t48*t91+1.7854583
     4           920998188d-15*t199*t200*t201*t48-4.0675215258019015d-19
     5           *t204*t47+3.216395899738507d+1*t207*t208*t209*t44-1.761
     6           3865241785684d-3*t204*t43
              t213 = 2.0d+0*t106*t107*t108*t52*t61
              t214 = -1.1696447245269295d+0*t110*t111*t112*t70*t71
              t215 = 3.847322101863072d+0*t114*t115*t116*t54*t55*t59*t76
              t216 = 5.495546528376875d-3*t104*t61*t68
              t217 = -9.087592854964233d-4*t104*t71*t74
              t218 = 5.082465978296986d-3*t139*t54*t59*t79
              t219 = 4.7846374908957684d-1*t128*t54*t59*t76*t79
              t220 = t106**2
              t221 = 1/t66**4
              t222 = 1/t67**2
              t223 = 1.6081979498692536d+1*t220*t221*t222*t52*t61
              t224 = 2.0d+0*t106*t107*t108*t132*t52
              t225 = 1/t66**3
              t226 = -2.0d+0*t108*t220*t225*t52*t61
              t227 = -8.837926660346784d-2*t104*t106*t107*t108*t61
              t228 = 1/t50**2.6666666666666666d+0
              t229 = 1/t63**5
              t230 = 1/t50**2.3333333333333334d+0
              t231 = 1/t50**2.1666666666666665d+0
              t232 = 1.1632736958443765d+0*t231+9.89141964955861d-1*t230
     1           +6.003214762495226d-1*t229+2.1077825841639536d-1*t228
              t233 = 1.0d+0*t107*t108*t232*t52*t61
              t234 = t110**2
              t235 = 1/t72**4
              t236 = 1/t73**2
              t237 = -1.73158960813529d+1*t234*t235*t236*t70*t71
              t238 = -1.1696447245269295d+0*t110*t111*t112*t135*t70
              t239 = 1/t72**3
              t240 = 1.1696447245269295d+0*t112*t234*t239*t70*t71
              t241 = 2.690728393099896d-2*t104*t110*t111*t112*t71
              t242 = 1.5861639701225969d+0*t231+9.98929717145607d-1*t230
     1           +3.2257293534574827d-1*t229+2.1239028834748191d-1*t228
              t243 = -5.848223622634647d-1*t111*t112*t242*t70*t71
              t244 = t114**2
              t245 = 1/t77**4
              t246 = 1/t78**2
              t247 = 6.187255516702861d+1*t244*t245*t246*t54*t55*t59*t76
              t248 = 3.847322101863072d+0*t114*t115*t116*t126*t54*t55*t7
     1           6
              t249 = 1/t77**3
              t250 = -3.847322101863072d+0*t116*t244*t249*t54*t55*t59*t7
     1           6
              t251 = -1.6347222733154887d-1*t114*t115*t116*t139*t54*t59
              t252 = 2.1622951122684114d+0*t231+1.7087761055320938d+0*t2
     1           30+1.2335503316757068d+0*t229+2.673190323653546d-1*t228
              t253 = 1.923661050931536d+0*t115*t116*t252*t54*t55*t59*t76
              t254 = -1.538928840745229d+1*t114*t115*t116*t128*t54*t59*t
     1           76
              t255 = 1.538928840745229d+1*t114*t115*t116*t130*t55*t59*t7
     1           6
              t256 = t121**2
              t257 = 1/t57**6.666666666666666d-1
              t258 = 1/t50**3
              t259 = -2*t258*t53
              t260 = 2*t118
              t261 = t260+t259
              t262 = t124**2
              t263 = 1/t58**6.666666666666666d-1
              t264 = 2*t258*t53
              t265 = -2*t118
              t266 = t265+t264
              t267 = 1.3333333333333333d+0*t125*t266+4.444444444444444d-
     1           1*t262*t263+1.3333333333333333d+0*t122*t261+4.444444444
     2           444444d-1*t256*t257
              t268 = -1.923661050931536d+0*t267*t54*t55
              t269 = 1.5389288407452287d+1*t126*t128*t54
              t270 = -1.5389288407452287d+1*t126*t130*t55
              t271 = 1/t50**6
              t272 = -3.8473221018630716d+1*t271*t54*t59
              t273 = 6.155715362980915d+1*t128*t130*t59
              t274 = t53**2
              t275 = -2.3083932611178434d+1*t274*t55*t59
              t276 = t275+t273+t272+t270+t269+t268
              t277 = -6.21814d-2*t276*t52*t68
              t278 = 5.495546528376875d-3*t104*t132*t68
              t279 = -3.663697685584583d-3*t230*t61*t68
              t280 = t275+t273+t272+t270+t269+t268+1.923661050931536d+0*
     1           t267
              t281 = 1.9751631321680768d-2*t280*t70*t74
              t282 = -9.087592854964233d-4*t104*t135*t74
              t283 = 6.058395236642822d-4*t230*t71*t74
              t284 = -5.980796863619711d-2*t267*t54*t55*t76*t79
              t285 = 5.082465978296986d-3*t126*t139*t54*t79
              t286 = 4.7846374908957684d-1*t126*t128*t54*t76*t79
              t287 = 1/t50**6.333333333333333d+0
              t288 = -2.3718174565385935d-2*t287*t54*t59*t79
              t289 = 2.0329863913187946d-2*t130*t139*t59*t79
              t290 = -1.1961593727239421d+0*t271*t54*t59*t76*t79
              t291 = 1.9138549963583074d+0*t128*t130*t59*t76*t79
              t292 = -7.176956236343652d-1*t274*t55*t59*t76*t79
              t293 = -2.0d+0*t100*t44*t98*t99-2.220446049250313d-16*t48*
     1           t91*t96*t97-6.101282288702853d-19*t47*t94-2.64207978626
     2           7853d-3*t43*t94+t50*(-4.7846374908957684d-1*t126*t130*t
     3           55*t76*t79+t292+t291+t290+t289+t288+t286+t285+t284+t283
     4           +t282+t281+t279+t278+t277+t255+t254+t253+t251+t250+t248
     5           +t247+t243+t241+t240+t238+t237+t233+t227+t226+t224+t223
     6           )-4.7846374908957684d-1*t130*t55*t59*t76*t79-1.19615937
     7           27239421d-1*t126*t54*t55*t76*t79+3.9503262643361536d-2*
     8           t135*t70*t74-1.243628d-1*t132*t52*t68+t219+t218+t217+t2
     9           16+t215+t214+t213-rhoa*t212
              t294 = 1/rhoa**7.333333333333333d+0
              t295 = 1/rhoa**4.666666666666667d+0
              t296 = 1/t29**3
              t297 = 3.0311111111111105d-2*gammaaa*t295*t30*t31+4.236942
     1           2222222203d-7*t149*t28*t294*t296*t31-9.396444444444442d
     2           -5*gammaaa*t144*t28*t295*t31-1.366755555555555d-4*t144*
     3           t149*t294*t31
              t298 = 3.0311111111111105d-2*gammaaa*t295*t30*t32+4.236942
     1           2222222203d-7*t149*t28*t294*t296*t32-9.396444444444442d
     2           -5*gammaaa*t144*t28*t295*t32-1.366755555555555d-4*t144*
     3           t149*t294*t32+3.1d-3*t28*t297*t30-1.653333333333333d-2*
     4           gammaaa*t143*t145*t30+5.125333333333332d-5*gammaaa*t143
     5           *t144*t145*t28
              t299 = 3.0311111111111105d-2*gammaaa*t295*t30*t33+4.236942
     1           2222222203d-7*t149*t28*t294*t296*t33-9.396444444444442d
     2           -5*gammaaa*t144*t28*t295*t33-1.366755555555555d-4*t144*
     3           t149*t294*t33+3.1d-3*t28*t298*t30-1.653333333333333d-2*
     4           gammaaa*t143*t146*t30+5.125333333333332d-5*gammaaa*t143
     5           *t144*t146*t28
              t300 = 3.0311111111111105d-2*gammaaa*t295*t30*t34+4.236942
     1           2222222203d-7*t149*t28*t294*t296*t34-9.396444444444442d
     2           -5*gammaaa*t144*t28*t295*t34-1.366755555555555d-4*t144*
     3           t149*t294*t34+3.1d-3*t28*t299*t30-1.653333333333333d-2*
     4           gammaaa*t143*t147*t30+5.125333333333332d-5*gammaaa*t143
     5           *t144*t147*t28
              t301 = 1/rhoa**2
              t302 = gammaaa**3
              t303 = 1/t82**3
              t304 = 1/rhoa**10
              t305 = 5.866666666666666d-1*gammaaa*t295*t8*t83+3.07199999
     1           99999986d-3*t302*t303*t304*t8-8.639999999999998d-2*t149
     2           *t150*t294*t8
              t306 = 5.866666666666666d-1*gammaaa*t295*t83*t84+3.0719999
     1           999999986d-3*t302*t303*t304*t84-8.639999999999998d-2*t1
     2           49*t150*t294*t84+6.0d-2*gammaaa*t27*t305*t83-3.19999999
     3           99999995d-1*gammaaa*t143*t152*t83+1.9199999999999995d-2
     4           *t149*t150*t151*t152
              t307 = 5.866666666666666d-1*gammaaa*t295*t83*t85+3.0719999
     1           999999986d-3*t302*t303*t304*t85-8.639999999999998d-2*t1
     2           49*t150*t294*t85+6.0d-2*gammaaa*t27*t306*t83-3.19999999
     3           99999995d-1*gammaaa*t143*t153*t83+1.9199999999999995d-2
     4           *t149*t150*t151*t153
              t308 = 5.866666666666666d-1*gammaaa*t295*t83*t86+3.0719999
     1           999999986d-3*t302*t303*t304*t86-8.639999999999998d-2*t1
     2           49*t150*t294*t86+6.0d-2*gammaaa*t27*t307*t83-3.19999999
     3           99999995d-1*gammaaa*t143*t154*t83+1.9199999999999995d-2
     4           *t149*t150*t151*t154
              t309 = 2.6666666666666666d+0*t125*t258*t53-2.6666666666666
     1           666d+0*t122*t258*t53+4.444444444444444d-1*t124*t174*t26
     2           3+4.444444444444444d-1*t121*t173*t257
              t310 = -1.923661050931536d+0*t309*t54*t55
              t311 = 7.694644203726144d+0*t128*t175*t54
              t312 = -7.694644203726144d+0*t130*t175*t55
              t313 = 7.694644203726144d+0*t126*t128*t54
              t314 = 7.694644203726144d+0*t126*t130*t55
              t315 = 2.3083932611178434d+1*t274*t55*t59
              t316 = t315+t314+t313+t312+t311+t310+t272
              t317 = t315+t314+t313+t312+t311+t310+1.923661050931536d+0*
     1           t309+t272
              t318 = 7.176956236343652d-1*t274*t55*t59*t76*t79
              t319 = t50*(-5.980796863619711d-2*t309*t54*t55*t76*t79-2.3
     1           923187454478842d-1*t130*t175*t55*t76*t79+2.392318745447
     2           8842d-1*t126*t130*t55*t76*t79+2.3923187454478842d-1*t12
     3           8*t175*t54*t76*t79+2.3923187454478842d-1*t126*t128*t54*
     4           t76*t79+2.541232989148493d-3*t139*t175*t54*t79+2.541232
     5           989148493d-3*t126*t139*t54*t79+1.923661050931536d+0*t11
     6           4*t115*t116*t175*t54*t55*t76+1.923661050931536d+0*t114*
     7           t115*t116*t126*t54*t55*t76+1.9751631321680768d-2*t317*t
     8           70*t74-4.5437964274821163d-4*t104*t180*t74-4.5437964274
     9           821163d-4*t104*t135*t74-5.848223622634647d-1*t110*t111*
     :           t112*t180*t70-5.848223622634647d-1*t110*t111*t112*t135*
     ;           t70-6.21814d-2*t316*t52*t68+2.747773264188437d-3*t104*t
     <           178*t68+2.747773264188437d-3*t104*t132*t68+1.0d+0*t106*
     =           t107*t108*t178*t52+1.0d+0*t106*t107*t108*t132*t52+t318+
     >           t290+t288+t283+t279+t254+t253+t251+t250+t247+t243+t241+
     ?           t240+t237+t233+t227+t226+t223)+t219+t218+t217+t216+t215
     @           +t214+t213+t182+t181+t179+t138+t136+t133
              t320 = 1.0592355555555552d-56*gammaaa*t143*t168*t28*t296*t
     1           31-3.416888888888888d-54*gammaaa*t143*t144*t168*t31
              t321 = 3.1d-3*t28*t30*t320+1.0592355555555552d-56*gammaaa*
     1           t143*t168*t28*t296*t32-3.416888888888888d-54*gammaaa*t1
     2           43*t144*t168*t32-8.266666666666665d-3*gammaaa*t143*t184
     3           *t30-2.0666666666666667d-52*t145*t168*t30+2.56266666666
     4           6666d-5*gammaaa*t143*t144*t184*t28+6.406666666666666d-5
     5           5*t144*t145*t168*t28
              t322 = 1.0592355555555552d-56*gammaaa*t143*t168*t28*t296*t
     1           33-3.416888888888888d-54*gammaaa*t143*t144*t168*t33+3.1
     2           d-3*t28*t30*t321-8.266666666666665d-3*gammaaa*t143*t185
     3           *t30-2.0666666666666667d-52*t146*t168*t30+2.56266666666
     4           6666d-5*gammaaa*t143*t144*t185*t28+6.406666666666666d-5
     5           5*t144*t146*t168*t28
              t323 = 1.0592355555555552d-56*gammaaa*t143*t168*t28*t296*t
     1           34-3.416888888888888d-54*gammaaa*t143*t144*t168*t34+3.1
     2           d-3*t28*t30*t322-8.266666666666665d-3*gammaaa*t143*t186
     3           *t30-2.0666666666666667d-52*t147*t168*t30+2.56266666666
     4           6666d-5*gammaaa*t143*t144*t186*t28+6.406666666666666d-5
     5           5*t144*t147*t168*t28
              t324 = 1/t23**2
              t325 = t160**2
              t326 = 1/t22**4
              t327 = 1/t22**3
              t328 = 1/t14**5
              t329 = 1/rhob**2.3333333333333334d+0
              t330 = 1/rhob**2.1666666666666665d+0
              t331 = 1.1632736958443765d+0*t330+9.89141964955861d-1*t329
     1           +6.003214762495226d-1*t328+2.1077825841639536d-1*t168
              t332 = 1/t19**2
              t333 = t163**2
              t334 = 1/t18**4
              t335 = 1/t18**3
              t336 = 2.1622951122684114d+0*t330+1.7087761055320938d+0*t3
     1           29+1.2335503316757068d+0*t328+2.673190323653546d-1*t168
              t337 = 1.0d+0*t162*t164*t21*t336-2.0d+0*t162*t21*t333*t335
     1           +3.216395899738507d+1*t21*t332*t333*t334+1.110223024625
     2           1565d-16*t156*t161*t25*t331-4.0675215258019015d-19*t24*
     3           t329-1.7613865241785684d-3*t20*t329-2.220446049250313d-
     4           16*t156*t25*t325*t327+1.7854583920998188d-15*t25*t324*t
     5           325*t326-8.497974591333913d-2*t158*t162*t163*t164-9.812
     6           069668265515d-18*t156*t158*t160*t161
              t338 = 1/t3**3
              t339 = 1/rhob**7
              t340 = 1/rhob**5.333333333333333d+0
              t341 = 1/rhob**3.6666666666666664d+0
              t342 = 1.0666666666666666d-50*t341*t4*t8-5.76d-101*t166*t3
     1           40*t8+7.68d-152*t338*t339*t8
              t343 = 1.0666666666666666d-50*t341*t4*t9-5.76d-101*t166*t3
     1           40*t9+7.68d-152*t338*t339*t9+2.4d-51*t2*t342*t4-8.0d-51
     2           *t168*t169*t4+1.92d-101*t166*t167*t169
              t344 = 2.4d-51*t2*t343*t4+1.0666666666666666d-50*t10*t341*
     1           t4-8.0d-51*t168*t170*t4-5.76d-101*t10*t166*t340+7.68d-1
     2           52*t10*t338*t339+1.92d-101*t166*t167*t170
              t345 = 2.4d-51*t2*t344*t4+1.0666666666666666d-50*t11*t341*
     1           t4-8.0d-51*t168*t171*t4-5.76d-101*t11*t166*t340+7.68d-1
     2           52*t11*t338*t339+1.92d-101*t166*t167*t171
              t346 = 2.0d+0*t106*t107*t108*t178*t52
              t347 = -1.1696447245269295d+0*t110*t111*t112*t180*t70
              t348 = 3.847322101863072d+0*t114*t115*t116*t175*t54*t55*t7
     1           6
              t349 = -1.538928840745229d+1*t114*t115*t116*t130*t55*t59*t
     1           76
              t350 = t173**2
              t351 = t265+t259
              t352 = t174**2
              t353 = t264+t260
              t354 = 1.3333333333333333d+0*t125*t353+4.444444444444444d-
     1           1*t263*t352+1.3333333333333333d+0*t122*t351+4.444444444
     2           444444d-1*t257*t350
              t355 = -1.923661050931536d+0*t354*t54*t55
              t356 = 1.5389288407452287d+1*t128*t175*t54
              t357 = 1.5389288407452287d+1*t130*t175*t55
              t358 = -6.155715362980915d+1*t128*t130*t59
              t359 = t358+t357+t356+t355+t275+t272
              t360 = -6.21814d-2*t359*t52*t68
              t361 = 5.495546528376875d-3*t104*t178*t68
              t362 = t358+t357+t356+t355+1.923661050931536d+0*t354+t275+
     1           t272
              t363 = 1.9751631321680768d-2*t362*t70*t74
              t364 = -9.087592854964233d-4*t104*t180*t74
              t365 = -5.980796863619711d-2*t354*t54*t55*t76*t79
              t366 = 5.082465978296986d-3*t139*t175*t54*t79
              t367 = 4.7846374908957684d-1*t128*t175*t54*t76*t79
              t368 = -2.0329863913187946d-2*t130*t139*t59*t79
              t369 = -1.9138549963583074d+0*t128*t130*t59*t76*t79
              t370 = t50*(4.7846374908957684d-1*t130*t175*t55*t76*t79+t3
     1           69+t368+t367+t366+t365+t364+t363+t361+t360+t349+t348+t3
     2           47+t346+t292+t290+t288+t283+t279+t254+t253+t251+t250+t2
     3           47+t243+t241+t240+t237+t233+t227+t226+t223)+4.784637490
     4           8957684d-1*t130*t55*t59*t76*t79-1.1961593727239421d-1*t
     5           175*t54*t55*t76*t79+3.9503262643361536d-2*t180*t70*t74-
     6           1.243628d-1*t178*t52*t68-rhob*t337-2.220446049250313d-1
     7           6*t156*t160*t161*t25-6.101282288702853d-19*t158*t24+t21
     8           9+t218+t217+t216+t215+t214+t213-2.0d+0*t162*t163*t164*t
     9           21-2.642079786267853d-3*t158*t20
              t371 = 5.51111111111111d-52*t30*t31*t341-1.708444444444444
     1           d-54*t144*t28*t31*t341+2.6480888888888887d-106*t28*t296
     2           *t31*t340-8.542222222222222d-104*t144*t31*t340
              t372 = 3.1d-3*t28*t30*t371+5.51111111111111d-52*t30*t32*t3
     1           41-1.708444444444444d-54*t144*t28*t32*t341+2.6480888888
     2           888887d-106*t28*t296*t32*t340-8.542222222222222d-104*t1
     3           44*t32*t340-4.1333333333333333d-52*t168*t184*t30+1.2813
     4           333333333332d-54*t144*t168*t184*t28
              t373 = 3.1d-3*t28*t30*t372+5.51111111111111d-52*t30*t33*t3
     1           41-1.708444444444444d-54*t144*t28*t33*t341+2.6480888888
     2           888887d-106*t28*t296*t33*t340-8.542222222222222d-104*t1
     3           44*t33*t340-4.1333333333333333d-52*t168*t185*t30+1.2813
     4           333333333332d-54*t144*t168*t185*t28
              t374 = 3.1d-3*t28*t30*t373+5.51111111111111d-52*t30*t34*t3
     1           41-1.708444444444444d-54*t144*t28*t34*t341+2.6480888888
     2           888887d-106*t28*t296*t34*t340-8.542222222222222d-104*t1
     3           44*t34*t340-4.1333333333333333d-52*t168*t186*t30+1.2813
     4           333333333332d-54*t144*t168*t186*t28
              t375 = -8.266666666666665d-3*t143*t30*t31-1.58885333333333
     1           27d-7*gammaaa*t151*t28*t296*t31+2.562666666666666d-5*t1
     2           43*t144*t28*t31+5.125333333333332d-5*gammaaa*t144*t151*
     3           t31
              t376 = 3.1d-3*t28*t30*t375-8.266666666666665d-3*t143*t30*t
     1           32-1.5888533333333327d-7*gammaaa*t151*t28*t296*t32+2.56
     2           2666666666666d-5*t143*t144*t28*t32+5.125333333333332d-5
     3           *gammaaa*t144*t151*t32+3.1d-3*t145*t27*t30-8.2666666666
     4           66665d-3*gammaaa*t143*t188*t30-9.61d-6*t144*t145*t27*t2
     5           8+2.562666666666666d-5*gammaaa*t143*t144*t188*t28
              t377 = 3.1d-3*t28*t30*t376-8.266666666666665d-3*t143*t30*t
     1           33-1.5888533333333327d-7*gammaaa*t151*t28*t296*t33+2.56
     2           2666666666666d-5*t143*t144*t28*t33+5.125333333333332d-5
     3           *gammaaa*t144*t151*t33+3.1d-3*t146*t27*t30-8.2666666666
     4           66665d-3*gammaaa*t143*t189*t30-9.61d-6*t144*t146*t27*t2
     5           8+2.562666666666666d-5*gammaaa*t143*t144*t189*t28
              t378 = 3.1d-3*t28*t30*t377-8.266666666666665d-3*t143*t30*t
     1           34-1.5888533333333327d-7*gammaaa*t151*t28*t296*t34+2.56
     2           2666666666666d-5*t143*t144*t28*t34+5.125333333333332d-5
     3           *gammaaa*t144*t151*t34+3.1d-3*t147*t27*t30-8.2666666666
     4           66665d-3*gammaaa*t143*t190*t30-9.61d-6*t144*t147*t27*t2
     5           8+2.562666666666666d-5*gammaaa*t143*t144*t190*t28
              t379 = 1.25d-1*t49*t87
              t380 = 1/rhoa**9
              t381 = -1.5999999999999998d-1*t143*t8*t83-1.15199999999999
     1           96d-3*t149*t303*t380*t8+2.879999999999999d-2*gammaaa*t1
     2           50*t151*t8
              t382 = -1.5999999999999998d-1*t143*t83*t84-1.1519999999999
     1           996d-3*t149*t303*t380*t84+2.879999999999999d-2*gammaaa*
     2           t150*t151*t84+6.0d-2*gammaaa*t27*t381*t83+6.0d-2*t152*t
     3           27*t83-1.5999999999999998d-1*gammaaa*t143*t194*t83+9.59
     4           9999999999997d-3*t149*t150*t151*t194-3.6d-3*gammaaa*t15
     5           0*t152*t193
              t383 = -1.5999999999999998d-1*t143*t83*t85-1.1519999999999
     1           996d-3*t149*t303*t380*t85+2.879999999999999d-2*gammaaa*
     2           t150*t151*t85+6.0d-2*gammaaa*t27*t382*t83+6.0d-2*t153*t
     3           27*t83-1.5999999999999998d-1*gammaaa*t143*t195*t83+9.59
     4           9999999999997d-3*t149*t150*t151*t195-3.6d-3*gammaaa*t15
     5           0*t153*t193
              t384 = -1.5999999999999998d-1*t143*t83*t86-1.1519999999999
     1           996d-3*t149*t303*t380*t86+2.879999999999999d-2*gammaaa*
     2           t150*t151*t86+6.0d-2*gammaaa*t27*t383*t83+6.0d-2*t154*t
     3           27*t83-1.5999999999999998d-1*gammaaa*t143*t196*t83+9.59
     4           9999999999997d-3*t149*t150*t151*t196-3.6d-3*gammaaa*t15
     5           0*t154*t193
              t385 = 1.2813333333333332d-54*t144*t168*t27*t31-3.97213333
     1           3333333d-57*t168*t27*t28*t296*t31
              t386 = 3.1d-3*t28*t30*t385-3.972133333333333d-57*t168*t27*
     1           t28*t296*t32+1.2813333333333332d-54*t144*t168*t27*t32+3
     2           .1d-3*t184*t27*t30-2.0666666666666667d-52*t168*t188*t30
     3           -9.61d-6*t144*t184*t27*t28+6.406666666666666d-55*t144*t
     4           168*t188*t28
              t387 = 3.1d-3*t28*t30*t386-3.972133333333333d-57*t168*t27*
     1           t28*t296*t33+1.2813333333333332d-54*t144*t168*t27*t33+3
     2           .1d-3*t185*t27*t30-2.0666666666666667d-52*t168*t189*t30
     3           -9.61d-6*t144*t185*t27*t28+6.406666666666666d-55*t144*t
     4           168*t189*t28
              t388 = 3.1d-3*t28*t30*t387-3.972133333333333d-57*t168*t27*
     1           t28*t296*t34+1.2813333333333332d-54*t144*t168*t27*t34+3
     2           .1d-3*t186*t27*t30-2.0666666666666667d-52*t168*t190*t30
     3           -9.61d-6*t144*t186*t27*t28+6.406666666666666d-55*t144*t
     4           168*t190*t28
              t389 = 5.9582d-8*t193*t28*t296*t31-1.9219999999999998d-5*t
     1           144*t193*t31
              t390 = 3.1d-3*t28*t30*t389+5.9582d-8*t193*t28*t296*t32-1.9
     1           219999999999998d-5*t144*t193*t32+6.2d-3*t188*t27*t30-1.
     2           9219999999999998d-5*t144*t188*t27*t28
              t391 = 3.1d-3*t28*t30*t390+5.9582d-8*t193*t28*t296*t33-1.9
     1           219999999999998d-5*t144*t193*t33+6.2d-3*t189*t27*t30-1.
     2           9219999999999998d-5*t144*t189*t27*t28
              t392 = 3.1d-3*t28*t30*t391+5.9582d-8*t193*t28*t296*t34-1.9
     1           219999999999998d-5*t144*t193*t34+6.2d-3*t190*t27*t30-1.
     2           9219999999999998d-5*t144*t190*t27*t28
              t393 = 1/rhoa**8
              t394 = 4.32d-4*gammaaa*t303*t393*t8-7.2d-3*t150*t193*t8
              t395 = 4.32d-4*gammaaa*t303*t393*t84-7.2d-3*t150*t193*t84+
     1           6.0d-2*gammaaa*t27*t394*t83+1.2d-1*t194*t27*t83-7.2d-3*
     2           gammaaa*t150*t193*t194
              t396 = 4.32d-4*gammaaa*t303*t393*t85-7.2d-3*t150*t193*t85+
     1           6.0d-2*gammaaa*t27*t395*t83+1.2d-1*t195*t27*t83-7.2d-3*
     2           gammaaa*t150*t193*t195
              t397 = 4.32d-4*gammaaa*t303*t393*t86-7.2d-3*t150*t193*t86+
     1           6.0d-2*gammaaa*t27*t396*t83+1.2d-1*t196*t27*t83-7.2d-3*
     2           gammaaa*t150*t193*t196
              t398 = t379-5.0d-1*rhoa*t197*t49*t90
              t399 = 1/taua**3
              t400 = 1/rhoa**11
              t401 = 1/rhoa**8.333333333333334d+0
              t402 = 1/rhoa**5.666666666666667d+0
              t403 = 1/t29**4
              t404 = t96**3
              t405 = 1/t37**7
              t406 = 1/rhoa**3.3333333333333337d+0
              t407 = 1/rhoa**3.1666666666666665d+0
              t408 = t99**3
              t409 = -6.0d+0*t210*t211*t44*t98*t99+1.6995949182667827d-1
     1           *t100*t204*t98*t99+9.649187699215522d+1*t207*t209*t211*
     2           t44*t99-1.274696188700087d-1*t100*t211*t94*t98+2.549392
     3           377400174d-1*t208*t210*t94*t98+6.0d+0*t209*t408*t44*t98
     4           +1.0d+0*t100*(-4.684972743248224d+0*t407-3.987144246241
     5           5524d+0*t406-3.083875829189267d+0*t405-7.12850752974278
     6           9d-1*t143)*t44*t98+1.962413933653103d-17*t204*t91*t96*t
     7           97-1.4718104502398274d-17*t206*t91*t94*t97+1.1102230246
     8           251565d-16*(-2.520426340996149d+0*t407-2.30799791823034
     9           28d+0*t406-1.5008036906238065d+0*t405-5.620753557770543
     :           d-1*t143)*t48*t91*t97-6.661338147750939d-16*t202*t206*t
     ;           48*t91*t96+5.356375176299456d-15*t199*t201*t206*t48*t96
     <           +2.943620900479655d-17*t200*t202*t91*t94-4.099927594747
     =           2624d+0*t207*t208*t209*t94-2.3669625486718335d-16*t199*
     >           t200*t201*t94+6.661338147750939d-16*t201*t404*t48*t91+5
     ?           .742741051503565d-14*t404*t48/(t45**6*t46**3)-1.0712750
     @           352598913d-14*t199*t404*t48/t45**5+9.490883560204437d-1
     1           9*t406*t47+2.0690405167709364d+3*t408*t44/(t41**6*t42**
     2           3)-1.9298375398431045d+2*t207*t408*t44/t41**5+4.1099018
     3           897499934d-3*t406*t43
              t410 = 4.824593849607761d+1*t220*t221*t222*t52*t61
              t411 = -6.0d+0*t108*t220*t225*t52*t61
              t412 = -2.6513779981040353d-1*t104*t106*t107*t108*t61
              t413 = 3.0d+0*t107*t108*t232*t52*t61
              t414 = -5.19476882440587d+1*t234*t235*t236*t70*t71
              t415 = 3.5089341735807883d+0*t112*t234*t239*t70*t71
              t416 = 8.072185179299687d-2*t104*t110*t111*t112*t71
              t417 = -1.7544670867903941d+0*t111*t112*t242*t70*t71
              t418 = 1.856176655010858d+2*t244*t245*t246*t54*t55*t59*t76
              t419 = -1.1541966305589217d+1*t116*t244*t249*t54*t55*t59*t
     1           76
              t420 = -4.904166819946466d-1*t114*t115*t116*t139*t54*t59
              t421 = 5.770983152794609d+0*t115*t116*t252*t54*t55*t59*t76
              t422 = -4.616786522235687d+1*t114*t115*t116*t128*t54*t59*t
     1           76
              t423 = -1.099109305675375d-2*t230*t61*t68
              t424 = 1.8175185709928465d-3*t230*t71*t74
              t425 = -7.11545236961578d-2*t287*t54*t59*t79
              t426 = -3.588478118171826d+0*t271*t54*t59*t76*t79
              t427 = -2.1530868709030954d+0*t274*t55*t59*t76*t79
              t428 = t106**3
              t429 = 5.172601291927341d+2*t428*t52*t61/(t66**6*t67**3)
              t430 = -9.649187699215522d+1*t222*t428*t52*t61/t66**5
              t431 = 4.824593849607761d+1*t106*t221*t222*t232*t52*t61
              t432 = -2.1319703304396778d+0*t104*t220*t221*t222*t61
              t433 = 6.0d+0*t108*t221*t428*t52*t61
              t434 = -6.0d+0*t106*t108*t225*t232*t52*t61
              t435 = 2.6513779981040353d-1*t104*t108*t220*t225*t61
              t436 = -1.3256889990520176d-1*t104*t107*t108*t232*t61
              t437 = 1.767585332069357d-1*t106*t107*t108*t230*t61
              t438 = 1/t50**3.6666666666666664d+0
              t439 = 1/t63**7
              t440 = 1/t50**3.3333333333333337d+0
              t441 = 1/t50**3.1666666666666665d+0
              t442 = 1.0d+0*t107*t108*(-2.520426340996149d+0*t441-2.3079
     1           979182303428d+0*t440-1.5008036906238065d+0*t439-5.62075
     2           3557770543d-1*t438)*t52*t61
              t443 = t110**3
              t444 = -1.0254062650399592d+3*t443*t70*t71/(t72**6*t73**3)
              t445 = 1.0389537648811739d+2*t236*t443*t70*t71/t72**5
              t446 = -5.19476882440587d+1*t110*t235*t236*t242*t70*t71
              t447 = 1.1950391155803675d+0*t104*t234*t235*t236*t71
              t448 = -3.5089341735807883d+0*t112*t235*t443*t70*t71
              t449 = 3.5089341735807883d+0*t110*t112*t239*t242*t70*t71
              t450 = -8.072185179299687d-2*t104*t112*t234*t239*t71
              t451 = 4.0360925896498434d-2*t104*t111*t112*t242*t71
              t452 = -5.381456786199791d-2*t110*t111*t112*t230*t71
              t453 = -5.848223622634647d-1*t111*t112*(-3.436688601932293
     1           d+0*t441-2.3308360066730832d+0*t440-8.064323383643707d-
     2           1*t439-5.663741022599518d-1*t438)*t70*t71
              t454 = t114**3
              t455 = 3.9801326549115085d+3*t454*t54*t55*t59*t76/(t77**6*
     1           t78**3)
              t456 = -3.712353310021716d+2*t246*t454*t54*t55*t59*t76/t77
     1           **5
              t457 = 1.856176655010858d+2*t114*t245*t246*t252*t54*t55*t5
     1           9*t76
              t458 = -7.424706620043432d+2*t128*t244*t245*t246*t54*t59*t
     1           76
              t459 = -7.886871025654724d+0*t139*t244*t245*t246*t54*t59
              t460 = 1.1541966305589217d+1*t116*t245*t454*t54*t55*t59*t7
     1           6
              t461 = -1.1541966305589217d+1*t114*t116*t249*t252*t54*t55*
     1           t59*t76
              t462 = 4.616786522235687d+1*t116*t128*t244*t249*t54*t59*t7
     1           6
              t463 = 4.904166819946466d-1*t116*t139*t244*t249*t54*t59
              t464 = -2.452083409973233d-1*t115*t116*t139*t252*t54*t59
              t465 = 2.2886111826416838d+0*t114*t115*t116*t287*t54*t59
              t466 = 1.923661050931536d+0*t115*t116*(-4.684972743248224d
     1           +0*t441-3.9871442462415524d+0*t440-3.083875829189267d+0
     2           *t439-7.128507529742789d-1*t438)*t54*t55*t59*t76
              t467 = -2.3083932611178434d+1*t115*t116*t128*t252*t54*t59*
     1           t76
              t468 = 1.1541966305589217d+2*t114*t115*t116*t271*t54*t59*t
     1           76
              t469 = 6.925179783353531d+1*t114*t115*t116*t274*t55*t59*t7
     1           6
              t470 = 8.548627933030694d-3*t440*t61*t68
              t471 = 1/t57**1.6666666666666669d+0
              t472 = 6*t53*t55
              t473 = -6*t258
              t474 = 1/t58**1.6666666666666669d+0
              t475 = -6*t53*t55
              t476 = 6*t258
              t477 = 1.3333333333333333d+0*t125*(t476+t475)-2.9629629629
     1           62963d-1*t124**3*t474+1.3333333333333333d+0*t122*(t473+
     2           t472)-2.962962962962963d-1*t121**3*t471+1.3333333333333
     3           333d+0*t124*t263*t266+1.3333333333333333d+0*t121*t257*t
     4           261
              t478 = -1.923661050931536d+0*t477*t54*t55
              t479 = 2.3083932611178434d+1*t128*t267*t54
              t480 = -2.3083932611178434d+1*t130*t267*t55
              t481 = -1.1541966305589216d+2*t126*t271*t54
              t482 = 1.8467146088942746d+2*t126*t128*t130
              t483 = -6.925179783353531d+1*t126*t274*t55
              t484 = 1/t50**7
              t485 = 2.3083932611178432d+2*t484*t54*t59
              t486 = -4.6167865222356863d+2*t130*t271*t59
              t487 = 2.770071913341412d+2*t128*t274*t59
              t488 = -4.616786522235687d+1*t53*t55*t59
              t489 = -1.4136255552166585d-3*t440*t71*t74
              t490 = 2.0103976536374746d-1*t54*t59*t79/t50**7.3333333333
     1           33333d+0
              t491 = 9.148438760934575d-2*t139*t274*t59*t79
              t492 = 7.176956236343652d+0*t484*t54*t59*t76*t79
              t493 = 8.612347483612381d+0*t128*t274*t59*t76*t79
              t494 = -1.4353912472687305d+0*t53*t55*t59*t76*t79
              t495 = 1/rhoa**3
              t496 = gammaaa**4
              t497 = 1/t82**4
              t498 = 1/rhoa**1.3666666666666666d+1
              t499 = -1.243628d-1*t316*t52*t68
              t500 = 3.9503262643361536d-2*t317*t70*t74
              t501 = -1.1961593727239421d-1*t309*t54*t55*t76*t79
              t502 = 2.0d+0*t106*t107*t108*t316*t52
              t503 = -1.1696447245269295d+0*t110*t111*t112*t317*t70
              t504 = 3.847322101863072d+0*t114*t115*t116*t309*t54*t55*t7
     1           6
              t505 = -2.3083932611178434d+1*t114*t115*t116*t274*t55*t59*
     1           t76
              t506 = 5.495546528376875d-3*t104*t316*t68
              t507 = 1.5389288407452287d+1*t128*t309*t54
              t508 = -1.5389288407452287d+1*t130*t309*t55
              t509 = 1.7777777777777776d+0*t124*t258*t263*t53-1.77777777
     1           77777776d+0*t121*t257*t258*t53+1.3333333333333333d+0*t1
     2           25*(t475+2*t258)-2.962962962962963d-1*t174*t262*t474+1.
     3           3333333333333333d+0*t122*(t472-2*t258)-2.96296296296296
     4           3d-1*t173*t256*t471+4.444444444444444d-1*t174*t263*t266
     5           +4.444444444444444d-1*t173*t257*t261
              t510 = -1.923661050931536d+0*t509*t54*t55
              t511 = 7.694644203726144d+0*t128*t267*t54
              t512 = 7.694644203726144d+0*t130*t267*t55
              t513 = -3.8473221018630716d+1*t175*t271*t54
              t514 = 6.155715362980915d+1*t128*t130*t175
              t515 = -2.3083932611178434d+1*t175*t274*t55
              t516 = -7.694644203726143d+1*t126*t271*t54
              t517 = 4.616786522235687d+1*t126*t274*t55
              t518 = -1.5389288407452287d+2*t130*t271*t59
              t519 = -9.233573044471374d+1*t128*t274*t59
              t520 = 4.616786522235687d+1*t53*t55*t59
              t521 = -9.087592854964233d-4*t104*t317*t74
              t522 = 5.082465978296986d-3*t139*t309*t54*t79
              t523 = 4.7846374908957684d-1*t128*t309*t54*t76*t79
              t524 = -2.870782494537461d+0*t128*t274*t59*t76*t79
              t525 = 1.4353912472687305d+0*t53*t55*t59*t76*t79
              t526 = -8*t125*t53*t55+8*t122*t53*t55+1.7777777777777776d+
     1           0*t174*t258*t263*t53-1.7777777777777776d+0*t173*t257*t2
     2           58*t53-2.962962962962963d-1*t124*t352*t474-2.9629629629
     3           62963d-1*t121*t350*t471+4.444444444444444d-1*t124*t263*
     4           t353+4.444444444444444d-1*t121*t257*t351-2.666666666666
     5           6666d+0*t125*t258+2.6666666666666666d+0*t122*t258
              t527 = -1.923661050931536d+0*t526*t54*t55
              t528 = 1.5389288407452287d+1*t130*t309*t55
              t529 = 7.694644203726144d+0*t128*t354*t54
              t530 = -7.694644203726144d+0*t130*t354*t55
              t531 = -7.694644203726143d+1*t175*t271*t54
              t532 = 4.616786522235687d+1*t175*t274*t55
              t533 = -3.8473221018630716d+1*t126*t271*t54
              t534 = -6.155715362980915d+1*t126*t128*t130
              t535 = -2.3083932611178434d+1*t126*t274*t55
              t536 = 1.5389288407452287d+2*t130*t271*t59
              t537 = t160**3
              t538 = 1/t14**7
              t539 = 1/rhob**3.3333333333333337d+0
              t540 = 1/rhob**3.1666666666666665d+0
              t541 = t163**3
              t542 = 6.0d+0*t162*t21*t334*t541-1.9298375398431045d+2*t21
     1           *t332*t541/t18**5+2.0690405167709364d+3*t21*t541/(t18**
     2           6*t19**3)+1.1102230246251565d-16*t156*t161*t25*(-2.5204
     3           26340996149d+0*t540-2.3079979182303428d+0*t539-1.500803
     4           6906238065d+0*t538-5.620753557770543d-1*t341)+1.0d+0*t1
     5           62*t164*t21*(-4.684972743248224d+0*t540-3.9871442462415
     6           524d+0*t539-3.083875829189267d+0*t538-7.128507529742789
     7           d-1*t341)+9.490883560204437d-19*t24*t539+4.109901889749
     8           9934d-3*t20*t539+6.661338147750939d-16*t156*t25*t326*t5
     9           37-1.0712750352598913d-14*t25*t324*t537/t22**5+5.742741
     :           051503565d-14*t25*t537/(t22**6*t23**3)-6.0d+0*t162*t163
     ;           *t21*t335*t336+9.649187699215522d+1*t163*t21*t332*t334*
     <           t336-1.274696188700087d-1*t158*t162*t164*t336+2.5493923
     =           77400174d-1*t158*t162*t333*t335-4.0999275947472624d+0*t
     >           158*t332*t333*t334-6.661338147750939d-16*t156*t160*t25*
     ?           t327*t331+5.356375176299456d-15*t160*t25*t324*t326*t331
     @           -1.4718104502398274d-17*t156*t158*t161*t331+1.699594918
     1           2667827d-1*t162*t163*t164*t329+1.962413933653103d-17*t1
     2           56*t160*t161*t329+2.943620900479655d-17*t156*t158*t325*
     3           t327-2.3669625486718335d-16*t158*t324*t325*t326
              t543 = 1/t3**4
              t544 = 1/rhob**9.666666666666666d+0
              t545 = 1/rhob**8
              t546 = 1/rhob**6.333333333333333d+0
              t547 = 1/rhob**4.666666666666667d+0
              t548 = 1.3333333333333333d+0*t122*(t476+t472)+1.3333333333
     1           333333d+0*t125*(t475+t473)-2.962962962962963d-1*t174**3
     2           *t474-2.962962962962963d-1*t173**3*t471+1.3333333333333
     3           333d+0*t174*t263*t353+1.3333333333333333d+0*t173*t257*t
     4           351
              t549 = -1.923661050931536d+0*t54*t548*t55
              t550 = 2.3083932611178434d+1*t128*t354*t54
              t551 = 2.3083932611178434d+1*t130*t354*t55
              t552 = -1.1541966305589216d+2*t175*t271*t54
              t553 = -1.8467146088942746d+2*t128*t130*t175
              t554 = -6.925179783353531d+1*t175*t274*t55
              t555 = 4.6167865222356863d+2*t130*t271*t59
              t556 = t192-1.25d-1*gammaaa*t197*t49
              t557 = 1.25d-1*t101*t87
              t558 = 1.25d-1*t155*t49
              t559 = 1/rhoa**1.2666666666666665d+1
              t560 = 2.5d-1*t197*t49
              t561 = 1/rhoa**1.1666666666666665d+1
              t562 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhoa*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhob*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t88*(5.0d-1*t49*t87*t90+5.0d-1*rhoa*t101
     1           *t87*t90+5.0d-1*rhoa*t155*t49*t90)+1.25d-1*gammaaa*t49*
     2           t87*t88*t89+1.0d+0*t148*t81+1.0d+0*t142*t35)*wght+Amat(
     3           iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t187*t81+1.0d+0*t183*t35+5.0d-1*r
     1           hob*t172*t26+5.0d-1*t12*t26+5.0d-1*rhob*t12*t165)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t88*(5.0d-1*rhoa*t197*t49*t90+t192)+1.0
     1           d+0*t191*t81)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t49*t87*t88-5.0d-1*rhoa*t198
     1           *t49*t87*t90)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t88*(5.0d-1*rhoa*t212*t87*t90+1.0d+0
     1           *t101*t87*t90+5.0d-1*rhoa*t308*t49*t90+1.0d+0*t155*t49*
     2           t90+1.0d+0*rhoa*t101*t155*t90+1.25d-1*gammaaa*t101*t87*
     3           t89+1.25d-1*gammaaa*t155*t49*t89+1.25d-1*gammaaa*t301*t
     4           49*t87)+(1.25d-1*gammaaa*t101*t87+1.25d-1*gammaaa*t155*
     5           t49)*t88*t89-1.25d-1*gammaaa*t301*t49*t87*t88+1.0d+0*t3
     6           00*t81+1.0d+0*t293*t35+2.0d+0*t142*t148)*wght+Amat2(iq,
     7           D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t323*t81+1.0d+0*t319*t35+1.0d
     1           +0*t142*t187+1.0d+0*t148*t183)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t374*t81+1.0d+0*t35*t370+5.0d
     1           -1*rhob*t26*t345+5.0d-1*rhob*t12*t337+1.0d+0*t172*t26+2
     2           .0d+0*t183*t187+1.0d+0*rhob*t165*t172+1.0d+0*t12*t165)*
     3           wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t88*(5.0d-1*rhoa*t384*t49*t90+5.0d-
     1           1*t197*t49*t90+5.0d-1*rhoa*t101*t197*t90-1.25d-1*t49*t8
     2           7*t89-1.25d-1*t101*t87-1.25d-1*t155*t49)+(1.25d-1*gamma
     3           aa*t197*t49+t379)*t88*t89+1.0d+0*t378*t81+1.0d+0*t142*t
     4           191)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t388*t81+1.0d+0*t183*t191)*w
     1           ght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t88*(5.0d-1*rhoa*t397*t49*t90-2.5d
     1           -1*t197*t49)+1.0d+0*t392*t81)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t198*(-5.0d-1*t49*t87*t90-5.0d-1*rho
     1           a*t101*t87*t90-5.0d-1*rhoa*t155*t49*t90)-1.25d-1*gammaa
     2           a*t198*t49*t87*t89+(1.0d+0*t49*t87+1.0d+0*rhoa*t101*t87
     3           +1.0d+0*rhoa*t155*t49)*t88)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t197*t49*t88+t198*t398)
     1           *wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t399*t49*t87*t90-2.0d+0*
     1           rhoa*t198*t49*t87)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t35*(2.549392377400174d-1*
     1           t100*t94*t98*t99-3.0d+0*t100*t211*t44*t98+6.0d+0*t208*t
     2           210*t44*t98+2.943620900479655d-17*t91*t94*t96*t97-3.330
     3           6690738754696d-16*t206*t48*t91*t97+6.661338147750939d-1
     4           6*t200*t202*t48*t91+t50*(-1.4353912472687305d+1*t130*t2
     5           71*t59*t76*t79-5.980796863619711d-2*t477*t54*t55*t76*t7
     6           9-2.1530868709030954d+0*t126*t274*t55*t76*t79-7.1769562
     7           36343652d-1*t130*t267*t55*t76*t79-3.588478118171826d+0*
     8           t126*t271*t54*t76*t79+7.176956236343652d-1*t128*t267*t5
     9           4*t76*t79+5.741564989074922d+0*t126*t128*t130*t76*t79-2
     :           .8461809478463124d-1*t130*t287*t59*t79-7.11545236961578
     ;           d-2*t126*t287*t54*t79+7.623698967445479d-3*t139*t267*t5
     <           4*t79+6.098959173956384d-2*t126*t130*t139*t79+2.3083932
     =           611178434d+1*t115*t116*t130*t252*t55*t59*t76-4.61678652
     >           2235687d+1*t116*t130*t244*t249*t55*t59*t76+7.4247066200
     ?           43432d+2*t130*t244*t245*t246*t55*t59*t76-1.846714608894
     @           2746d+2*t114*t115*t116*t128*t130*t59*t76+5.770983152794
     1           609d+0*t114*t115*t116*t267*t54*t55*t76+5.77098315279460
     2           9d+0*t115*t116*t126*t252*t54*t55*t76-1.1541966305589217
     3           d+1*t116*t126*t244*t249*t54*t55*t76+1.856176655010858d+
     4           2*t126*t244*t245*t246*t54*t55*t76+4.616786522235687d+1*
     5           t114*t115*t116*t126*t130*t55*t76-4.616786522235687d+1*t
     6           114*t115*t116*t126*t128*t54*t76+1.9751631321680768d-2*(
     7           t488+t487+t486+t485+t483+t482+t481+t480+t479+t478+1.923
     8           661050931536d+0*t477)*t70*t74-1.363138928244635d-3*t104
     9           *t280*t74+1.8175185709928465d-3*t135*t230*t74-1.7544670
     :           867903941d+0*t110*t111*t112*t280*t70-1.7544670867903941
     ;           d+0*t111*t112*t135*t242*t70+3.5089341735807883d+0*t112*
     <           t135*t234*t239*t70-5.19476882440587d+1*t135*t234*t235*t
     =           236*t70-6.21814d-2*(t488+t487+t486+t485+t483+t482+t481+
     >           t480+t479+t478)*t52*t68+8.243319792565312d-3*t104*t276*
     ?           t68-1.099109305675375d-2*t132*t230*t68-1.96166672797858
     @           65d+0*t114*t115*t116*t130*t139*t59-4.904166819946466d-1
     1           *t114*t115*t116*t126*t139*t54+3.0d+0*t106*t107*t108*t27
     2           6*t52+3.0d+0*t107*t108*t132*t232*t52-6.0d+0*t108*t132*t
     3           220*t225*t52+4.824593849607761d+1*t132*t220*t221*t222*t
     4           52+t494+t493+t492+t491+t490+t489+t470+t469+t468+t467+t4
     5           66+t465+t464+t463+t462+t461+t460+t459+t458+t457+t456+t4
     6           55+t453+t452+t451+t450+t449+t448+t447+t446+t445+t444+t4
     7           42+t437+t436+t435+t434+t433+t432+t431+t430+t429+8.07218
     8           5179299687d-2*t104*t110*t111*t112*t135-2.65137799810403
     9           53d-1*t104*t106*t107*t108*t132)+5.741564989074922d+0*t1
     :           28*t130*t59*t76*t79-1.794239059085913d-1*t267*t54*t55*t
     ;           76*t79-1.4353912472687305d+0*t126*t130*t55*t76*t79+1.43
     <           53912472687305d+0*t126*t128*t54*t76*t79+6.0989591739563
     =           84d-2*t130*t139*t59*t79+1.524739793489096d-2*t126*t139*
     >           t54*t79+4.616786522235687d+1*t114*t115*t116*t130*t55*t5
     ?           9*t76+1.1541966305589217d+1*t114*t115*t116*t126*t54*t55
     @           *t76+5.92548939650423d-2*t280*t70*t74-2.72627785648927d
     1           -3*t104*t135*t74-3.5089341735807883d+0*t110*t111*t112*t
     2           135*t70-1.865442d-1*t276*t52*t68+1.6486639585130625d-2*
     3           t104*t132*t68+6.0d+0*t106*t107*t108*t132*t52-5.35637517
     4           6299456d-15*t199*t200*t201*t48+1.2202564577405706d-18*t
     5           204*t47-9.649187699215522d+1*t207*t208*t209*t44+5.28415
     6           9572535705d-3*t204*t43+t427+t426+t425+t424+t423+t422+t4
     7           21+t420+t419+t418+t417+t416+t415+t414+t413+t412+t411+t4
     8           10-rhoa*t409)+t88*(5.0d-1*rhoa*t409*t87*t90+1.5d+0*t212
     9           *t87*t90+5.0d-1*rhoa*t49*(-2.737777777777778d+0*gammaaa
     :           *t402*t83*t86+1.4745599999999992d-3*t496*t497*t498*t86+
     ;           7.274666666666665d-1*t149*t150*t401*t86-5.8367999999999
     <           98d-2*t302*t303*t400*t86+6.0d-2*gammaaa*t27*t83*(-2.737
     =           777777777778d+0*gammaaa*t402*t83*t85+1.4745599999999992
     >           d-3*t496*t497*t498*t85+7.274666666666665d-1*t149*t150*t
     ?           401*t85-5.836799999999998d-2*t302*t303*t400*t85+6.0d-2*
     @           gammaaa*t27*t83*(-2.737777777777778d+0*gammaaa*t402*t83
     1           *t84+1.4745599999999992d-3*t496*t497*t498*t84+7.2746666
     2           66666665d-1*t149*t150*t401*t84-5.836799999999998d-2*t30
     3           2*t303*t400*t84+6.0d-2*gammaaa*t27*t83*(-2.737777777777
     4           778d+0*gammaaa*t402*t8*t83+1.4745599999999992d-3*t496*t
     5           497*t498*t8+7.274666666666665d-1*t149*t150*t401*t8-5.83
     6           6799999999998d-2*t302*t303*t400*t8)-4.799999999999999d-
     7           1*gammaaa*t143*t305*t83+1.76d+0*gammaaa*t152*t295*t83+2
     8           .879999999999999d-2*t149*t150*t151*t305+9.2159999999999
     9           96d-3*t152*t302*t303*t304-2.5919999999999993d-1*t149*t1
     :           50*t152*t294)-4.799999999999999d-1*gammaaa*t143*t306*t8
     ;           3+1.76d+0*gammaaa*t153*t295*t83+2.879999999999999d-2*t1
     <           49*t150*t151*t306+9.215999999999996d-3*t153*t302*t303*t
     =           304-2.5919999999999993d-1*t149*t150*t153*t294)-4.799999
     >           999999999d-1*gammaaa*t143*t307*t83+1.76d+0*gammaaa*t154
     ?           *t295*t83+2.879999999999999d-2*t149*t150*t151*t307+9.21
     @           5999999999996d-3*t154*t302*t303*t304-2.5919999999999993
     1           d-1*t149*t150*t154*t294)*t90+1.5d+0*t308*t49*t90+1.5d+0
     2           *rhoa*t101*t308*t90+1.5d+0*rhoa*t155*t212*t90+3.0d+0*t1
     3           01*t155*t90+2.5d-1*gammaaa*t212*t87*t89+2.5d-1*gammaaa*
     4           t308*t49*t89+5.0d-1*gammaaa*t101*t155*t89-2.5d-1*gammaa
     5           a*t49*t495*t87+2.5d-1*gammaaa*t101*t301*t87+2.5d-1*gamm
     6           aaa*t155*t301*t49)+(1.25d-1*gammaaa*t212*t87+1.25d-1*ga
     7           mmaaa*t308*t49+2.5d-1*gammaaa*t101*t155)*t88*t89+t301*(
     8           -2.5d-1*gammaaa*t101*t87-2.5d-1*gammaaa*t155*t49)*t88+2
     9           .5d-1*gammaaa*t49*t495*t87*t88+1.0d+0*(3.1d-3*t28*t30*(
     :           3.1d-3*t28*t30*(3.1d-3*t28*t30*(1.0507616711111105d-8*t
     ;           28*t302*t31*t400*t403-1.4145185185185183d-1*gammaaa*t30
     <           *t31*t402+4.3850074074074064d-4*gammaaa*t144*t28*t31*t4
     =           02-4.6606364444444426d-6*t149*t28*t296*t31*t401+1.50343
     >           11111111107d-3*t144*t149*t31*t401-3.389553777777776d-6*
     ?           t296*t302*t31*t400)+1.0507616711111105d-8*t28*t302*t32*
     @           t400*t403-1.4145185185185183d-1*gammaaa*t30*t32*t402+4.
     1           3850074074074064d-4*gammaaa*t144*t28*t32*t402-4.6606364
     2           444444426d-6*t149*t28*t296*t32*t401+1.5034311111111107d
     3           -3*t144*t149*t32*t401-3.389553777777776d-6*t296*t302*t3
     4           2*t400-2.4799999999999994d-2*gammaaa*t143*t297*t30+9.09
     5           3333333333331d-2*gammaaa*t145*t295*t30+7.68799999999999
     6           8d-5*gammaaa*t143*t144*t28*t297+1.271082666666666d-6*t1
     7           45*t149*t28*t294*t296-2.818933333333332d-4*gammaaa*t144
     8           *t145*t28*t295-4.100266666666665d-4*t144*t145*t149*t294
     9           )+1.0507616711111105d-8*t28*t302*t33*t400*t403-1.414518
     :           5185185183d-1*gammaaa*t30*t33*t402+4.3850074074074064d-
     ;           4*gammaaa*t144*t28*t33*t402-4.6606364444444426d-6*t149*
     <           t28*t296*t33*t401+1.5034311111111107d-3*t144*t149*t33*t
     =           401-3.389553777777776d-6*t296*t302*t33*t400-2.479999999
     >           9999994d-2*gammaaa*t143*t298*t30+9.093333333333331d-2*g
     ?           ammaaa*t146*t295*t30+7.687999999999998d-5*gammaaa*t143*
     @           t144*t28*t298+1.271082666666666d-6*t146*t149*t28*t294*t
     1           296-2.818933333333332d-4*gammaaa*t144*t146*t28*t295-4.1
     2           00266666666665d-4*t144*t146*t149*t294)+1.05076167111111
     3           05d-8*t28*t302*t34*t400*t403-1.4145185185185183d-1*gamm
     4           aaa*t30*t34*t402+4.3850074074074064d-4*gammaaa*t144*t28
     5           *t34*t402-4.6606364444444426d-6*t149*t28*t296*t34*t401+
     6           1.5034311111111107d-3*t144*t149*t34*t401-3.389553777777
     7           776d-6*t296*t302*t34*t400-2.4799999999999994d-2*gammaaa
     8           *t143*t299*t30+9.093333333333331d-2*gammaaa*t147*t295*t
     9           30+7.687999999999998d-5*gammaaa*t143*t144*t28*t299+1.27
     :           1082666666666d-6*t147*t149*t28*t294*t296-2.818933333333
     ;           332d-4*gammaaa*t144*t147*t28*t295-4.100266666666665d-4*
     <           t144*t147*t149*t294)*t81+3.0d+0*t142*t300+3.0d+0*t148*t
     =           293)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t2
     1           8*t30*(3.1d-3*t28*t30*(2.6269041777777763d-58*t149*t168
     2           *t28*t294*t31*t403-3.883863703703702d-56*gammaaa*t168*t
     3           28*t295*t296*t31-8.473884444444441d-56*t149*t168*t294*t
     4           296*t31+1.2528592592592588d-53*gammaaa*t144*t168*t295*t
     5           31)+2.6269041777777763d-58*t149*t168*t28*t294*t32*t403-
     6           1.653333333333333d-2*gammaaa*t143*t30*t320+5.1253333333
     7           33332d-5*gammaaa*t143*t144*t28*t320-3.883863703703702d-
     8           56*gammaaa*t168*t28*t295*t296*t32-8.473884444444441d-56
     9           *t149*t168*t294*t296*t32+1.2528592592592588d-53*gammaaa
     :           *t144*t168*t295*t32-2.0666666666666667d-52*t168*t297*t3
     ;           0+3.0311111111111105d-2*gammaaa*t184*t295*t30+6.4066666
     <           66666666d-55*t144*t168*t28*t297+4.2369422222222203d-7*t
     =           149*t184*t28*t294*t296+2.1184711111111104d-56*gammaaa*t
     >           143*t145*t168*t28*t296-9.396444444444442d-5*gammaaa*t14
     ?           4*t184*t28*t295-1.366755555555555d-4*t144*t149*t184*t29
     @           4-6.833777777777776d-54*gammaaa*t143*t144*t145*t168)+2.
     1           6269041777777763d-58*t149*t168*t28*t294*t33*t403-3.8838
     2           63703703702d-56*gammaaa*t168*t28*t295*t296*t33-8.473884
     3           444444441d-56*t149*t168*t294*t296*t33+1.252859259259258
     4           8d-53*gammaaa*t144*t168*t295*t33-1.653333333333333d-2*g
     5           ammaaa*t143*t30*t321+5.125333333333332d-5*gammaaa*t143*
     6           t144*t28*t321-2.0666666666666667d-52*t168*t298*t30+3.03
     7           11111111111105d-2*gammaaa*t185*t295*t30+6.4066666666666
     8           66d-55*t144*t168*t28*t298+4.2369422222222203d-7*t149*t1
     9           85*t28*t294*t296+2.1184711111111104d-56*gammaaa*t143*t1
     :           46*t168*t28*t296-9.396444444444442d-5*gammaaa*t144*t185
     ;           *t28*t295-1.366755555555555d-4*t144*t149*t185*t294-6.83
     <           3777777777776d-54*gammaaa*t143*t144*t146*t168)+2.626904
     =           1777777763d-58*t149*t168*t28*t294*t34*t403-3.8838637037
     >           03702d-56*gammaaa*t168*t28*t295*t296*t34-8.473884444444
     ?           441d-56*t149*t168*t294*t296*t34+1.2528592592592588d-53*
     @           gammaaa*t144*t168*t295*t34-1.653333333333333d-2*gammaaa
     1           *t143*t30*t322+5.125333333333332d-5*gammaaa*t143*t144*t
     2           28*t322-2.0666666666666667d-52*t168*t299*t30+3.03111111
     3           11111105d-2*gammaaa*t186*t295*t30+6.406666666666666d-55
     4           *t144*t168*t28*t299+4.2369422222222203d-7*t149*t186*t28
     5           *t294*t296+2.1184711111111104d-56*gammaaa*t143*t147*t16
     6           8*t28*t296-9.396444444444442d-5*gammaaa*t144*t186*t28*t
     7           295-1.366755555555555d-4*t144*t149*t186*t294-6.83377777
     8           7777776d-54*gammaaa*t143*t144*t147*t168)*t81+1.0d+0*t35
     9           *(t50*(-4.7846374908957684d+0*t130*t271*t59*t76*t79-5.9
     :           80796863619711d-2*t509*t54*t55*t76*t79-4.78463749089576
     ;           84d-1*t130*t309*t55*t76*t79-7.176956236343652d-1*t175*t
     <           274*t55*t76*t79+1.4353912472687305d+0*t126*t274*t55*t76
     =           *t79+2.3923187454478842d-1*t130*t267*t55*t76*t79-1.1961
     >           593727239421d+0*t175*t271*t54*t76*t79-2.392318745447884
     ?           2d+0*t126*t271*t54*t76*t79+2.3923187454478842d-1*t128*t
     @           267*t54*t76*t79+1.9138549963583074d+0*t128*t130*t175*t7
     1           6*t79-9.487269826154375d-2*t130*t287*t59*t79-3.04947958
     2           6978192d-2*t139*t274*t59*t79-2.3718174565385935d-2*t175
     3           *t287*t54*t79-4.743634913077187d-2*t126*t287*t54*t79+2.
     4           541232989148493d-3*t139*t267*t54*t79+2.0329863913187946
     5           d-2*t130*t139*t175*t79+7.694644203726144d+0*t115*t116*t
     6           130*t252*t55*t59*t76-1.538928840745229d+1*t116*t130*t24
     7           4*t249*t55*t59*t76+2.4749022066811444d+2*t130*t244*t245
     8           *t246*t55*t59*t76-6.155715362980916d+1*t114*t115*t116*t
     9           128*t130*t59*t76+1.923661050931536d+0*t114*t115*t116*t2
     :           67*t54*t55*t76+1.923661050931536d+0*t115*t116*t175*t252
     ;           *t54*t55*t76+3.847322101863072d+0*t115*t116*t126*t252*t
     <           54*t55*t76-3.847322101863072d+0*t116*t175*t244*t249*t54
     =           *t55*t76-7.694644203726144d+0*t116*t126*t244*t249*t54*t
     >           55*t76+6.187255516702861d+1*t175*t244*t245*t246*t54*t55
     ?           *t76+1.2374511033405722d+2*t126*t244*t245*t246*t54*t55*
     @           t76+1.538928840745229d+1*t114*t115*t116*t130*t175*t55*t
     1           76-1.538928840745229d+1*t114*t115*t116*t128*t175*t54*t7
     2           6-3.077857681490458d+1*t114*t115*t116*t126*t128*t54*t76
     3           +1.9751631321680768d-2*(t520+t519+t518+t517+t516+t515+t
     4           514+t513+t512+t511+t510+1.923661050931536d+0*t509+t508+
     5           t507+t485)*t70*t74-4.5437964274821163d-4*t104*t280*t74+
     6           6.058395236642822d-4*t180*t230*t74+1.2116790473285642d-
     7           3*t135*t230*t74-5.848223622634647d-1*t110*t111*t112*t28
     8           0*t70-5.848223622634647d-1*t111*t112*t180*t242*t70-1.16
     9           96447245269295d+0*t111*t112*t135*t242*t70+1.16964472452
     :           69295d+0*t112*t180*t234*t239*t70+2.339289449053859d+0*t
     ;           112*t135*t234*t239*t70-1.73158960813529d+1*t180*t234*t2
     <           35*t236*t70-3.46317921627058d+1*t135*t234*t235*t236*t70
     =           -6.21814d-2*t52*(t520+t519+t518+t517+t516+t515+t514+t51
     >           3+t512+t511+t510+t508+t507+t485)*t68+2.747773264188437d
     ?           -3*t104*t276*t68-3.663697685584583d-3*t178*t230*t68-7.3
     @           27395371169166d-3*t132*t230*t68-6.538889093261956d-1*t1
     1           14*t115*t116*t130*t139*t59-1.6347222733154887d-1*t114*t
     2           115*t116*t139*t175*t54-3.2694445466309774d-1*t114*t115*
     3           t116*t126*t139*t54+t525+t524+t523+t522+t521+1.0d+0*t106
     4           *t107*t108*t276*t52+1.0d+0*t107*t108*t178*t232*t52+2.0d
     5           +0*t107*t108*t132*t232*t52-2.0d+0*t108*t178*t220*t225*t
     6           52-4.0d+0*t108*t132*t220*t225*t52+1.6081979498692536d+1
     7           *t178*t220*t221*t222*t52+3.216395899738507d+1*t132*t220
     8           *t221*t222*t52+t506+t505+t504+t503+t502+t492+t490+t489+
     9           t470+t468+t467+t466+t465+t464+t463+t462+t461+t460+t459+
     :           t458+t457+t456+t455+t453+t452+t451+t450+t449+t448+t447+
     ;           t446+t445+t444+t442+t437+t436+t435+t434+t433+t432+t431+
     <           t430+t429+2.690728393099896d-2*t104*t110*t111*t112*t180
     =           -8.837926660346784d-2*t104*t106*t107*t108*t178+5.381456
     >           786199792d-2*t104*t110*t111*t112*t135-1.767585332069357
     ?           d-1*t104*t106*t107*t108*t132)-4.7846374908957684d-1*t13
     @           0*t175*t55*t76*t79+9.569274981791537d-1*t126*t128*t54*t
     1           76*t79+1.0164931956593973d-2*t126*t139*t54*t79+7.694644
     2           203726144d+0*t114*t115*t116*t126*t54*t55*t76-1.81751857
     3           09928465d-3*t104*t135*t74-2.339289449053859d+0*t110*t11
     4           1*t112*t135*t70+1.099109305675375d-2*t104*t132*t68+4.0d
     5           +0*t106*t107*t108*t132*t52+t501+t500+t499+t426+t425+t42
     6           4+t423+t422+t421+t420+t419+t418+t417+t416+t415+t414+t41
     7           3+t412+t411+t410+t367+t366+t364+t361+t348+t347+t346+t31
     8           8+t291+t289+t284+t281+t277+t255)+2.0d+0*t142*t323+2.0d+
     9           0*t148*t319+1.0d+0*t183*t300+1.0d+0*t187*t293)*wght+Ama
     :           t3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t2
     1           8*t30*(3.1d-3*t28*t30*(6.567260444444443d-108*gammaaa*t
     2           143*t28*t31*t340*t403-2.824628148148147d-56*gammaaa*t14
     3           3*t28*t296*t31*t341+9.111703703703702d-54*gammaaa*t143*
     4           t144*t31*t341-2.1184711111111104d-105*gammaaa*t143*t296
     5           *t31*t340)+6.567260444444443d-108*gammaaa*t143*t28*t32*
     6           t340*t403-8.266666666666665d-3*gammaaa*t143*t30*t371+2.
     7           562666666666666d-5*gammaaa*t143*t144*t28*t371-2.8246281
     8           48148147d-56*gammaaa*t143*t28*t296*t32*t341+9.111703703
     9           703702d-54*gammaaa*t143*t144*t32*t341+5.51111111111111d
     :           -52*t145*t30*t341-1.708444444444444d-54*t144*t145*t28*t
     ;           341-2.1184711111111104d-105*gammaaa*t143*t296*t32*t340+
     <           2.6480888888888887d-106*t145*t28*t296*t340-8.5422222222
     =           22222d-104*t144*t145*t340-4.1333333333333333d-52*t168*t
     >           30*t320+1.2813333333333332d-54*t144*t168*t28*t320+2.118
     ?           4711111111104d-56*gammaaa*t143*t168*t184*t28*t296-6.833
     @           777777777776d-54*gammaaa*t143*t144*t168*t184)+6.5672604
     1           44444443d-108*gammaaa*t143*t28*t33*t340*t403-8.26666666
     2           6666665d-3*gammaaa*t143*t30*t372+2.562666666666666d-5*g
     3           ammaaa*t143*t144*t28*t372-2.824628148148147d-56*gammaaa
     4           *t143*t28*t296*t33*t341+9.111703703703702d-54*gammaaa*t
     5           143*t144*t33*t341+5.51111111111111d-52*t146*t30*t341-1.
     6           708444444444444d-54*t144*t146*t28*t341-2.11847111111111
     7           04d-105*gammaaa*t143*t296*t33*t340+2.6480888888888887d-
     8           106*t146*t28*t296*t340-8.542222222222222d-104*t144*t146
     9           *t340-4.1333333333333333d-52*t168*t30*t321+1.2813333333
     :           333332d-54*t144*t168*t28*t321+2.1184711111111104d-56*ga
     ;           mmaaa*t143*t168*t185*t28*t296-6.833777777777776d-54*gam
     <           maaa*t143*t144*t168*t185)+6.567260444444443d-108*gammaa
     =           a*t143*t28*t34*t340*t403-8.266666666666665d-3*gammaaa*t
     >           143*t30*t373+2.562666666666666d-5*gammaaa*t143*t144*t28
     ?           *t373-2.824628148148147d-56*gammaaa*t143*t28*t296*t34*t
     @           341+9.111703703703702d-54*gammaaa*t143*t144*t34*t341+5.
     1           51111111111111d-52*t147*t30*t341-1.708444444444444d-54*
     2           t144*t147*t28*t341-2.1184711111111104d-105*gammaaa*t143
     3           *t296*t34*t340+2.6480888888888887d-106*t147*t28*t296*t3
     4           40-8.542222222222222d-104*t144*t147*t340-4.133333333333
     5           3333d-52*t168*t30*t322+1.2813333333333332d-54*t144*t168
     6           *t28*t322+2.1184711111111104d-56*gammaaa*t143*t168*t186
     7           *t28*t296-6.833777777777776d-54*gammaaa*t143*t144*t168*
     8           t186)*t81+1.0d+0*t35*(t50*(4.7846374908957684d+0*t130*t
     9           271*t59*t76*t79-5.980796863619711d-2*t526*t54*t55*t76*t
     :           79-2.3923187454478842d-1*t130*t354*t55*t76*t79+4.784637
     ;           4908957684d-1*t130*t309*t55*t76*t79+1.4353912472687305d
     <           +0*t175*t274*t55*t76*t79-7.176956236343652d-1*t126*t274
     =           *t55*t76*t79+2.3923187454478842d-1*t128*t354*t54*t76*t7
     >           9-2.3923187454478842d+0*t175*t271*t54*t76*t79-1.1961593
     ?           727239421d+0*t126*t271*t54*t76*t79-1.9138549963583074d+
     @           0*t126*t128*t130*t76*t79+9.487269826154374d-2*t130*t287
     1           *t59*t79-3.0494795869781915d-2*t139*t274*t59*t79+2.5412
     2           32989148493d-3*t139*t354*t54*t79-4.743634913077187d-2*t
     3           175*t287*t54*t79-2.3718174565385935d-2*t126*t287*t54*t7
     4           9-2.0329863913187946d-2*t126*t130*t139*t79-7.6946442037
     5           26144d+0*t115*t116*t130*t252*t55*t59*t76+1.538928840745
     6           229d+1*t116*t130*t244*t249*t55*t59*t76-2.47490220668114
     7           44d+2*t130*t244*t245*t246*t55*t59*t76+6.155715362980916
     8           d+1*t114*t115*t116*t128*t130*t59*t76+1.923661050931536d
     9           +0*t114*t115*t116*t354*t54*t55*t76+3.847322101863072d+0
     :           *t115*t116*t175*t252*t54*t55*t76+1.923661050931536d+0*t
     ;           115*t116*t126*t252*t54*t55*t76-7.694644203726144d+0*t11
     <           6*t175*t244*t249*t54*t55*t76-3.847322101863072d+0*t116*
     =           t126*t244*t249*t54*t55*t76+1.2374511033405722d+2*t175*t
     >           244*t245*t246*t54*t55*t76+6.187255516702861d+1*t126*t24
     ?           4*t245*t246*t54*t55*t76-1.538928840745229d+1*t114*t115*
     @           t116*t126*t130*t55*t76-3.077857681490458d+1*t114*t115*t
     1           116*t128*t175*t54*t76-1.538928840745229d+1*t114*t115*t1
     2           16*t126*t128*t54*t76+1.9751631321680768d-2*(t536+t535+t
     3           534+t533+t532+t531+t530+t529+t528+t527+1.92366105093153
     4           6d+0*t526+t519+t507+t488+t485)*t70*t74-4.54379642748211
     5           63d-4*t104*t362*t74+1.2116790473285642d-3*t180*t230*t74
     6           +6.058395236642822d-4*t135*t230*t74-5.848223622634647d-
     7           1*t110*t111*t112*t362*t70-1.1696447245269295d+0*t111*t1
     8           12*t180*t242*t70-5.848223622634647d-1*t111*t112*t135*t2
     9           42*t70+2.339289449053859d+0*t112*t180*t234*t239*t70+1.1
     :           696447245269295d+0*t112*t135*t234*t239*t70-3.4631792162
     ;           7058d+1*t180*t234*t235*t236*t70-1.73158960813529d+1*t13
     <           5*t234*t235*t236*t70-6.21814d-2*t52*(t536+t535+t534+t53
     =           3+t532+t531+t530+t529+t528+t527+t519+t507+t488+t485)*t6
     >           8+2.747773264188437d-3*t104*t359*t68-7.327395371169166d
     ?           -3*t178*t230*t68-3.663697685584583d-3*t132*t230*t68+6.5
     @           38889093261955d-1*t114*t115*t116*t130*t139*t59-3.269444
     1           5466309774d-1*t114*t115*t116*t139*t175*t54-1.6347222733
     2           154887d-1*t114*t115*t116*t126*t139*t54+t524+t523+t522+t
     3           521+1.0d+0*t106*t107*t108*t359*t52+2.0d+0*t107*t108*t17
     4           8*t232*t52+1.0d+0*t107*t108*t132*t232*t52-4.0d+0*t108*t
     5           178*t220*t225*t52-2.0d+0*t108*t132*t220*t225*t52+3.2163
     6           95899738507d+1*t178*t220*t221*t222*t52+1.60819794986925
     7           36d+1*t132*t220*t221*t222*t52+t506+t505+t504+t503+t502+
     8           t494+t492+t490+t489+t470+t468+t467+t466+t465+t464+t463+
     9           t462+t461+t460+t459+t458+t457+t456+t455+t453+t452+t451+
     :           t450+t449+t448+t447+t446+t445+t444+t442+t437+t436+t435+
     ;           t434+t433+t432+t431+t430+t429+5.381456786199792d-2*t104
     <           *t110*t111*t112*t180-1.767585332069357d-1*t104*t106*t10
     =           7*t108*t178+2.690728393099896d-2*t104*t110*t111*t112*t1
     >           35-8.837926660346784d-2*t104*t106*t107*t108*t132)+4.784
     ?           6374908957684d-1*t126*t130*t55*t76*t79+9.56927498179153
     @           7d-1*t128*t175*t54*t76*t79+1.0164931956593973d-2*t139*t
     1           175*t54*t79+7.694644203726144d+0*t114*t115*t116*t175*t5
     2           4*t55*t76-1.8175185709928465d-3*t104*t180*t74-2.3392894
     3           49053859d+0*t110*t111*t112*t180*t70+1.099109305675375d-
     4           2*t104*t178*t68+4.0d+0*t106*t107*t108*t178*t52+t501+t50
     5           0+t499+t426+t425+t424+t423+t422+t421+t420+t419+t418+t41
     6           7+t416+t415+t414+t413+t412+t411+t410+t369+t368+t365+t36
     7           3+t360+t349+t318+t286+t285+t282+t278+t248+t238+t224)+1.
     8           0d+0*t142*t374+1.0d+0*t148*t370+2.0d+0*t183*t323+2.0d+0
     9           *t187*t319)*wght+Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (5.0d-1*rhob*t26*(2.4d-51*t2*t4*(2
     1           .4d-51*t2*t4*(-3.911111111111111d-50*t4*t547*t9+3.49866
     2           66666666666d-100*t166*t546*t9-9.984000000000001d-151*t3
     3           38*t545*t9+9.216000000000001d-202*t543*t544*t9+2.4d-51*
     4           t2*t4*(-3.911111111111111d-50*t4*t547*t8+3.498666666666
     5           6666d-100*t166*t546*t8-9.984000000000001d-151*t338*t545
     6           *t8+9.216000000000001d-202*t543*t544*t8)-1.2d-50*t168*t
     7           342*t4+3.2d-50*t169*t341*t4+2.88d-101*t166*t167*t342-1.
     8           7279999999999998d-100*t166*t169*t340+2.3040000000000002
     9           d-151*t169*t338*t339)-3.911111111111111d-50*t10*t4*t547
     :           +3.4986666666666666d-100*t10*t166*t546-9.98400000000000
     ;           1d-151*t10*t338*t545+9.216000000000001d-202*t10*t543*t5
     <           44-1.2d-50*t168*t343*t4+3.2d-50*t170*t341*t4+2.88d-101*
     =           t166*t167*t343-1.7279999999999998d-100*t166*t170*t340+2
     >           .3040000000000002d-151*t170*t338*t339)-3.91111111111111
     ?           1d-50*t11*t4*t547+3.4986666666666666d-100*t11*t166*t546
     @           -9.984000000000001d-151*t11*t338*t545+9.216000000000001
     1           d-202*t11*t543*t544-1.2d-50*t168*t344*t4+3.2d-50*t171*t
     2           341*t4+2.88d-101*t166*t167*t344-1.7279999999999998d-100
     3           *t166*t171*t340+2.3040000000000002d-151*t171*t338*t339)
     4           +1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t28*t30*(3.1d-3*t28*t30
     5           *(-2.0207407407407404d-51*t30*t31*t547+6.26429629629629
     6           4d-54*t144*t28*t31*t547-2.118471111111111d-105*t28*t296
     7           *t31*t546+6.833777777777776d-103*t144*t31*t546+1.641815
     8           111111111d-157*t28*t31*t403*t545-5.296177777777777d-155
     9           *t296*t31*t545)-2.0207407407407404d-51*t30*t32*t547+6.2
     :           64296296296294d-54*t144*t28*t32*t547-2.118471111111111d
     ;           -105*t28*t296*t32*t546+6.833777777777776d-103*t144*t32*
     <           t546+1.641815111111111d-157*t28*t32*t403*t545-5.2961777
     =           77777777d-155*t296*t32*t545-6.2d-52*t168*t30*t371+1.921
     >           9999999999998d-54*t144*t168*t28*t371+1.6533333333333333
     ?           d-51*t184*t30*t341-5.125333333333332d-54*t144*t184*t28*
     @           t341+7.944266666666666d-106*t184*t28*t296*t340-2.562666
     1           6666666664d-103*t144*t184*t340)-2.0207407407407404d-51*
     2           t30*t33*t547+6.264296296296294d-54*t144*t28*t33*t547-2.
     3           118471111111111d-105*t28*t296*t33*t546+6.83377777777777
     4           6d-103*t144*t33*t546+1.641815111111111d-157*t28*t33*t40
     5           3*t545-5.296177777777777d-155*t296*t33*t545-6.2d-52*t16
     6           8*t30*t372+1.9219999999999998d-54*t144*t168*t28*t372+1.
     7           6533333333333333d-51*t185*t30*t341-5.125333333333332d-5
     8           4*t144*t185*t28*t341+7.944266666666666d-106*t185*t28*t2
     9           96*t340-2.5626666666666664d-103*t144*t185*t340)-2.02074
     :           07407407404d-51*t30*t34*t547+6.264296296296294d-54*t144
     ;           *t28*t34*t547-2.118471111111111d-105*t28*t296*t34*t546+
     <           6.833777777777776d-103*t144*t34*t546+1.641815111111111d
     =           -157*t28*t34*t403*t545-5.296177777777777d-155*t296*t34*
     >           t545-6.2d-52*t168*t30*t373+1.9219999999999998d-54*t144*
     ?           t168*t28*t373+1.6533333333333333d-51*t186*t30*t341-5.12
     @           5333333333332d-54*t144*t186*t28*t341+7.944266666666666d
     1           -106*t186*t28*t296*t340-2.5626666666666664d-103*t144*t1
     2           86*t340)*t81+1.0d+0*t35*(t50*(1.4353912472687305d+1*t13
     3           0*t271*t59*t76*t79-5.980796863619711d-2*t54*t548*t55*t7
     4           6*t79+7.176956236343652d-1*t130*t354*t55*t76*t79-2.1530
     5           868709030954d+0*t175*t274*t55*t76*t79+7.176956236343652
     6           d-1*t128*t354*t54*t76*t79-3.588478118171826d+0*t175*t27
     7           1*t54*t76*t79-5.741564989074922d+0*t128*t130*t175*t76*t
     8           79+2.8461809478463124d-1*t130*t287*t59*t79+7.6236989674
     9           45479d-3*t139*t354*t54*t79-7.11545236961578d-2*t175*t28
     :           7*t54*t79-6.098959173956384d-2*t130*t139*t175*t79-2.308
     ;           3932611178434d+1*t115*t116*t130*t252*t55*t59*t76+4.6167
     <           86522235687d+1*t116*t130*t244*t249*t55*t59*t76-7.424706
     =           620043432d+2*t130*t244*t245*t246*t55*t59*t76+1.84671460
     >           88942746d+2*t114*t115*t116*t128*t130*t59*t76+5.77098315
     ?           2794609d+0*t114*t115*t116*t354*t54*t55*t76+5.7709831527
     @           94609d+0*t115*t116*t175*t252*t54*t55*t76-1.154196630558
     1           9217d+1*t116*t175*t244*t249*t54*t55*t76+1.8561766550108
     2           58d+2*t175*t244*t245*t246*t54*t55*t76-4.616786522235687
     3           d+1*t114*t115*t116*t130*t175*t55*t76-4.616786522235687d
     4           +1*t114*t115*t116*t128*t175*t54*t76+1.9751631321680768d
     5           -2*(t555+t554+t553+t552+t551+t550+t549+1.92366105093153
     6           6d+0*t548+t520+t487+t485)*t70*t74-1.363138928244635d-3*
     7           t104*t362*t74+1.8175185709928465d-3*t180*t230*t74-1.754
     8           4670867903941d+0*t110*t111*t112*t362*t70-1.754467086790
     9           3941d+0*t111*t112*t180*t242*t70+3.5089341735807883d+0*t
     :           112*t180*t234*t239*t70-5.19476882440587d+1*t180*t234*t2
     ;           35*t236*t70-6.21814d-2*t52*(t555+t554+t553+t552+t551+t5
     <           50+t549+t520+t487+t485)*t68+8.243319792565312d-3*t104*t
     =           359*t68-1.099109305675375d-2*t178*t230*t68+1.9616667279
     >           785865d+0*t114*t115*t116*t130*t139*t59-4.90416681994646
     ?           6d-1*t114*t115*t116*t139*t175*t54+t525+3.0d+0*t106*t107
     @           *t108*t359*t52+3.0d+0*t107*t108*t178*t232*t52-6.0d+0*t1
     1           08*t178*t220*t225*t52+4.824593849607761d+1*t178*t220*t2
     2           21*t222*t52+t493+t492+t491+t490+t489+t470+t469+t468+t46
     3           7+t466+t465+t464+t463+t462+t461+t460+t459+t458+t457+t45
     4           6+t455+t453+t452+t451+t450+t449+t448+t447+t446+t445+t44
     5           4+t442+t437+t436+t435+t434+t433+t432+t431+t430+t429+8.0
     6           72185179299687d-2*t104*t110*t111*t112*t180-2.6513779981
     7           040353d-1*t104*t106*t107*t108*t178)-5.741564989074922d+
     8           0*t128*t130*t59*t76*t79-1.794239059085913d-1*t354*t54*t
     9           55*t76*t79+1.4353912472687305d+0*t130*t175*t55*t76*t79+
     :           1.4353912472687305d+0*t128*t175*t54*t76*t79-6.098959173
     ;           956384d-2*t130*t139*t59*t79+1.524739793489096d-2*t139*t
     <           175*t54*t79-4.616786522235687d+1*t114*t115*t116*t130*t5
     =           5*t59*t76+1.1541966305589217d+1*t114*t115*t116*t175*t54
     >           *t55*t76+5.92548939650423d-2*t362*t70*t74-2.72627785648
     ?           927d-3*t104*t180*t74-3.5089341735807883d+0*t110*t111*t1
     @           12*t180*t70-1.865442d-1*t359*t52*t68+1.6486639585130625
     1           d-2*t104*t178*t68-rhob*t542+6.0d+0*t106*t107*t108*t178*
     2           t52+t427+t426+t425+t424+t423+t422+t421+t420+t419+t418+t
     3           417+t416+t415+t414+t413+t412+t411+t410-3.0d+0*t162*t164
     4           *t21*t336+6.0d+0*t162*t21*t333*t335-9.649187699215522d+
     5           1*t21*t332*t333*t334-3.3306690738754696d-16*t156*t161*t
     6           25*t331+1.2202564577405706d-18*t24*t329+5.2841595725357
     7           05d-3*t20*t329+6.661338147750939d-16*t156*t25*t325*t327
     8           -5.356375176299456d-15*t25*t324*t325*t326+2.54939237740
     9           0174d-1*t158*t162*t163*t164+2.943620900479655d-17*t156*
     :           t158*t160*t161)+5.0d-1*rhob*t12*t542+3.0d+0*t183*t374+3
     ;           .0d+0*t187*t370+1.5d+0*t26*t345+1.5d+0*rhob*t165*t345+1
     <           .5d+0*rhob*t172*t337+1.5d+0*t12*t337+3.0d+0*t165*t172)*
     =           wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t88*(5.0d-1*rhoa*t49*(5.86666666
     1           6666666d-1*t295*t83*t86-5.529599999999998d-4*t302*t497*
     2           t559*t86+1.9583999999999993d-2*t149*t303*t304*t86-2.079
     3           9999999999996d-1*gammaaa*t150*t294*t86+6.0d-2*gammaaa*t
     4           27*t83*(5.866666666666666d-1*t295*t83*t85-5.52959999999
     5           9998d-4*t302*t497*t559*t85+1.9583999999999993d-2*t149*t
     6           303*t304*t85-2.0799999999999996d-1*gammaaa*t150*t294*t8
     7           5+6.0d-2*gammaaa*t27*t83*(5.866666666666666d-1*t295*t83
     8           *t84-5.529599999999998d-4*t302*t497*t559*t84+1.95839999
     9           99999993d-2*t149*t303*t304*t84-2.0799999999999996d-1*ga
     :           mmaaa*t150*t294*t84+6.0d-2*gammaaa*t27*t83*(5.866666666
     ;           666666d-1*t295*t8*t83-5.529599999999998d-4*t302*t497*t5
     <           59*t8+1.9583999999999993d-2*t149*t303*t304*t8-2.0799999
     =           999999996d-1*gammaaa*t150*t294*t8)-3.1999999999999995d-
     >           1*gammaaa*t143*t381*t83+6.0d-2*t27*t305*t83+5.866666666
     ?           666666d-1*gammaaa*t194*t295*t83-3.1999999999999995d-1*t
     @           143*t152*t83+1.9199999999999995d-2*t149*t150*t151*t381-
     1           2.303999999999999d-3*t149*t152*t303*t380-3.6d-3*gammaaa
     2           *t150*t193*t305+3.0719999999999986d-3*t194*t302*t303*t3
     3           04-8.639999999999998d-2*t149*t150*t194*t294+5.759999999
     4           999998d-2*gammaaa*t150*t151*t152)-3.1999999999999995d-1
     5           *gammaaa*t143*t382*t83+6.0d-2*t27*t306*t83+5.8666666666
     6           66666d-1*gammaaa*t195*t295*t83-3.1999999999999995d-1*t1
     7           43*t153*t83+1.9199999999999995d-2*t149*t150*t151*t382-2
     8           .303999999999999d-3*t149*t153*t303*t380-3.6d-3*gammaaa*
     9           t150*t193*t306+3.0719999999999986d-3*t195*t302*t303*t30
     :           4-8.639999999999998d-2*t149*t150*t195*t294+5.7599999999
     ;           99998d-2*gammaaa*t150*t151*t153)-3.1999999999999995d-1*
     <           gammaaa*t143*t383*t83+6.0d-2*t27*t307*t83+5.86666666666
     =           6666d-1*gammaaa*t196*t295*t83-3.1999999999999995d-1*t14
     >           3*t154*t83+1.9199999999999995d-2*t149*t150*t151*t383-2.
     ?           303999999999999d-3*t149*t154*t303*t380-3.6d-3*gammaaa*t
     @           150*t193*t307+3.0719999999999986d-3*t196*t302*t303*t304
     1           -8.639999999999998d-2*t149*t150*t196*t294+5.75999999999
     2           9998d-2*gammaaa*t150*t151*t154)*t90+1.0d+0*t384*t49*t90
     3           +1.0d+0*rhoa*t101*t384*t90+5.0d-1*rhoa*t197*t212*t90+1.
     4           0d+0*t101*t197*t90-1.25d-1*t101*t87*t89+1.25d-1*gammaaa
     5           *t384*t49*t89-1.25d-1*t155*t49*t89+1.25d-1*gammaaa*t101
     6           *t197*t89+1.25d-1*t301*t49*t87-1.25d-1*t212*t87-1.25d-1
     7           *t308*t49+1.25d-1*gammaaa*t197*t301*t49-2.5d-1*t101*t15
     8           5)+(t558+t557+1.25d-1*gammaaa*t384*t49+1.25d-1*gammaaa*
     9           t101*t197)*t88*t89+t301*t556*t88+1.0d+0*(3.1d-3*t28*t30
     :           *(3.1d-3*t28*t30*(3.1d-3*t28*t30*(-3.9403562666666647d-
     ;           9*t149*t28*t304*t31*t403+1.271082666666666d-6*t149*t296
     <           *t304*t31+3.0311111111111105d-2*t295*t30*t31+1.42996799
     =           99999995d-6*gammaaa*t28*t294*t296*t31-9.396444444444442
     >           d-5*t144*t28*t295*t31-4.612799999999999d-4*gammaaa*t144
     ?           *t294*t31)-3.9403562666666647d-9*t149*t28*t304*t32*t403
     @           -1.653333333333333d-2*gammaaa*t143*t30*t375+5.125333333
     1           333332d-5*gammaaa*t143*t144*t28*t375+1.271082666666666d
     2           -6*t149*t296*t304*t32+3.0311111111111105d-2*t295*t30*t3
     3           2+1.4299679999999995d-6*gammaaa*t28*t294*t296*t32-9.396
     4           444444444442d-5*t144*t28*t295*t32-4.612799999999999d-4*
     5           gammaaa*t144*t294*t32+3.1d-3*t27*t297*t30+3.03111111111
     6           11105d-2*gammaaa*t188*t295*t30-1.653333333333333d-2*t14
     7           3*t145*t30-9.61d-6*t144*t27*t28*t297+4.2369422222222203
     8           d-7*t149*t188*t28*t294*t296-3.1777066666666653d-7*gamma
     9           aa*t145*t151*t28*t296-9.396444444444442d-5*gammaaa*t144
     :           *t188*t28*t295-1.366755555555555d-4*t144*t149*t188*t294
     ;           +5.125333333333332d-5*t143*t144*t145*t28+1.025066666666
     <           6663d-4*gammaaa*t144*t145*t151)-3.9403562666666647d-9*t
     =           149*t28*t304*t33*t403-1.653333333333333d-2*gammaaa*t143
     >           *t30*t376+5.125333333333332d-5*gammaaa*t143*t144*t28*t3
     ?           76+1.271082666666666d-6*t149*t296*t304*t33+3.0311111111
     @           111105d-2*t295*t30*t33+1.4299679999999995d-6*gammaaa*t2
     1           8*t294*t296*t33-9.396444444444442d-5*t144*t28*t295*t33-
     2           4.612799999999999d-4*gammaaa*t144*t294*t33+3.1d-3*t27*t
     3           298*t30+3.0311111111111105d-2*gammaaa*t189*t295*t30-1.6
     4           53333333333333d-2*t143*t146*t30-9.61d-6*t144*t27*t28*t2
     5           98+4.2369422222222203d-7*t149*t189*t28*t294*t296-3.1777
     6           066666666653d-7*gammaaa*t146*t151*t28*t296-9.3964444444
     7           44442d-5*gammaaa*t144*t189*t28*t295-1.366755555555555d-
     8           4*t144*t149*t189*t294+5.125333333333332d-5*t143*t144*t1
     9           46*t28+1.0250666666666663d-4*gammaaa*t144*t146*t151)-3.
     :           9403562666666647d-9*t149*t28*t304*t34*t403-1.6533333333
     ;           33333d-2*gammaaa*t143*t30*t377+5.125333333333332d-5*gam
     <           maaa*t143*t144*t28*t377+1.271082666666666d-6*t149*t296*
     =           t304*t34+3.0311111111111105d-2*t295*t30*t34+1.429967999
     >           9999995d-6*gammaaa*t28*t294*t296*t34-9.396444444444442d
     ?           -5*t144*t28*t295*t34-4.612799999999999d-4*gammaaa*t144*
     @           t294*t34+3.1d-3*t27*t299*t30+3.0311111111111105d-2*gamm
     1           aaa*t190*t295*t30-1.653333333333333d-2*t143*t147*t30-9.
     2           61d-6*t144*t27*t28*t299+4.2369422222222203d-7*t149*t190
     3           *t28*t294*t296-3.1777066666666653d-7*gammaaa*t147*t151*
     4           t28*t296-9.396444444444442d-5*gammaaa*t144*t190*t28*t29
     5           5-1.366755555555555d-4*t144*t149*t190*t294+5.1253333333
     6           33332d-5*t143*t144*t147*t28+1.0250666666666663d-4*gamma
     7           aa*t144*t147*t151)*t81+2.0d+0*t142*t378+1.0d+0*t191*t29
     8           3)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t
     1           28*t30*(3.1d-3*t28*t30*(-9.850890666666663d-59*gammaaa*
     2           t151*t168*t28*t31*t403+1.0592355555555552d-56*t143*t168
     3           *t28*t296*t31+3.177706666666666d-56*gammaaa*t151*t168*t
     4           296*t31-3.416888888888888d-54*t143*t144*t168*t31)-9.850
     5           890666666663d-59*gammaaa*t151*t168*t28*t32*t403-8.26666
     6           6666666665d-3*gammaaa*t143*t30*t385+2.562666666666666d-
     7           5*gammaaa*t143*t144*t28*t385-2.0666666666666667d-52*t16
     8           8*t30*t375+6.406666666666666d-55*t144*t168*t28*t375+3.1
     9           d-3*t27*t30*t320-9.61d-6*t144*t27*t28*t320+1.0592355555
     :           555552d-56*t143*t168*t28*t296*t32+3.177706666666666d-56
     ;           *gammaaa*t151*t168*t296*t32-3.416888888888888d-54*t143*
     <           t144*t168*t32-8.266666666666665d-3*t143*t184*t30-3.9721
     =           33333333333d-57*t145*t168*t27*t28*t296+1.05923555555555
     >           52d-56*gammaaa*t143*t168*t188*t28*t296-1.58885333333333
     ?           27d-7*gammaaa*t151*t184*t28*t296+2.562666666666666d-5*t
     @           143*t144*t184*t28+1.2813333333333332d-54*t144*t145*t168
     1           *t27-3.416888888888888d-54*gammaaa*t143*t144*t168*t188+
     2           5.125333333333332d-5*gammaaa*t144*t151*t184)-9.85089066
     3           6666663d-59*gammaaa*t151*t168*t28*t33*t403-8.2666666666
     4           66665d-3*gammaaa*t143*t30*t386+2.562666666666666d-5*gam
     5           maaa*t143*t144*t28*t386-2.0666666666666667d-52*t168*t30
     6           *t376+6.406666666666666d-55*t144*t168*t28*t376+1.059235
     7           5555555552d-56*t143*t168*t28*t296*t33+3.177706666666666
     8           d-56*gammaaa*t151*t168*t296*t33-3.416888888888888d-54*t
     9           143*t144*t168*t33+3.1d-3*t27*t30*t321-9.61d-6*t144*t27*
     :           t28*t321-8.266666666666665d-3*t143*t185*t30-3.972133333
     ;           333333d-57*t146*t168*t27*t28*t296+1.0592355555555552d-5
     <           6*gammaaa*t143*t168*t189*t28*t296-1.5888533333333327d-7
     =           *gammaaa*t151*t185*t28*t296+2.562666666666666d-5*t143*t
     >           144*t185*t28+1.2813333333333332d-54*t144*t146*t168*t27-
     ?           3.416888888888888d-54*gammaaa*t143*t144*t168*t189+5.125
     @           333333333332d-5*gammaaa*t144*t151*t185)-9.8508906666666
     1           63d-59*gammaaa*t151*t168*t28*t34*t403-8.266666666666665
     2           d-3*gammaaa*t143*t30*t387+2.562666666666666d-5*gammaaa*
     3           t143*t144*t28*t387-2.0666666666666667d-52*t168*t30*t377
     4           +6.406666666666666d-55*t144*t168*t28*t377+1.05923555555
     5           55552d-56*t143*t168*t28*t296*t34+3.177706666666666d-56*
     6           gammaaa*t151*t168*t296*t34-3.416888888888888d-54*t143*t
     7           144*t168*t34+3.1d-3*t27*t30*t322-9.61d-6*t144*t27*t28*t
     8           322-8.266666666666665d-3*t143*t186*t30-3.97213333333333
     9           3d-57*t147*t168*t27*t28*t296+1.0592355555555552d-56*gam
     :           maaa*t143*t168*t190*t28*t296-1.5888533333333327d-7*gamm
     ;           aaa*t151*t186*t28*t296+2.562666666666666d-5*t143*t144*t
     <           186*t28+1.2813333333333332d-54*t144*t147*t168*t27-3.416
     =           888888888888d-54*gammaaa*t143*t144*t168*t190+5.12533333
     >           3333332d-5*gammaaa*t144*t151*t186)*t81+1.0d+0*t142*t388
     ?           +1.0d+0*t183*t378+1.0d+0*t191*t319)*wght+Cmat3(iq,D3_RA
     @           _RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t
     1           28*t30*(3.1d-3*t28*t30*(-2.4627226666666663d-108*t27*t2
     2           8*t31*t340*t403+1.0592355555555552d-56*t27*t28*t296*t31
     3           *t341-3.416888888888888d-54*t144*t27*t31*t341+7.9442666
     4           66666666d-106*t27*t296*t31*t340)-2.4627226666666663d-10
     5           8*t27*t28*t32*t340*t403-4.1333333333333333d-52*t168*t30
     6           *t385+1.2813333333333332d-54*t144*t168*t28*t385+3.1d-3*
     7           t27*t30*t371-9.61d-6*t144*t27*t28*t371+1.05923555555555
     8           52d-56*t27*t28*t296*t32*t341-3.416888888888888d-54*t144
     9           *t27*t32*t341+5.51111111111111d-52*t188*t30*t341-1.7084
     :           44444444444d-54*t144*t188*t28*t341+7.944266666666666d-1
     ;           06*t27*t296*t32*t340+2.6480888888888887d-106*t188*t28*t
     <           296*t340-8.542222222222222d-104*t144*t188*t340-7.944266
     =           666666666d-57*t168*t184*t27*t28*t296+2.5626666666666664
     >           d-54*t144*t168*t184*t27)-2.4627226666666663d-108*t27*t2
     ?           8*t33*t340*t403-4.1333333333333333d-52*t168*t30*t386+1.
     @           2813333333333332d-54*t144*t168*t28*t386+3.1d-3*t27*t30*
     1           t372-9.61d-6*t144*t27*t28*t372+1.0592355555555552d-56*t
     2           27*t28*t296*t33*t341-3.416888888888888d-54*t144*t27*t33
     3           *t341+5.51111111111111d-52*t189*t30*t341-1.708444444444
     4           444d-54*t144*t189*t28*t341+7.944266666666666d-106*t27*t
     5           296*t33*t340+2.6480888888888887d-106*t189*t28*t296*t340
     6           -8.542222222222222d-104*t144*t189*t340-7.94426666666666
     7           6d-57*t168*t185*t27*t28*t296+2.5626666666666664d-54*t14
     8           4*t168*t185*t27)-2.4627226666666663d-108*t27*t28*t34*t3
     9           40*t403-4.1333333333333333d-52*t168*t30*t387+1.28133333
     :           33333332d-54*t144*t168*t28*t387+3.1d-3*t27*t30*t373-9.6
     ;           1d-6*t144*t27*t28*t373+1.0592355555555552d-56*t27*t28*t
     <           296*t34*t341-3.416888888888888d-54*t144*t27*t34*t341+5.
     =           51111111111111d-52*t190*t30*t341-1.708444444444444d-54*
     >           t144*t190*t28*t341+7.944266666666666d-106*t27*t296*t34*
     ?           t340+2.6480888888888887d-106*t190*t28*t296*t340-8.54222
     @           2222222222d-104*t144*t190*t340-7.944266666666666d-57*t1
     1           68*t186*t27*t28*t296+2.5626666666666664d-54*t144*t168*t
     2           186*t27)*t81+2.0d+0*t183*t388+1.0d+0*t191*t370)*wght+Cm
     3           at3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t88*(5.0d-1*rhoa*t49*(2.0735999
     1           99999999d-4*t149*t497*t561*t86-5.759999999999997d-3*gam
     2           maaa*t303*t380*t86+3.839999999999999d-2*t150*t151*t86+6
     3           .0d-2*gammaaa*t27*t83*(2.073599999999999d-4*t149*t497*t
     4           561*t85-5.759999999999997d-3*gammaaa*t303*t380*t85+3.83
     5           9999999999999d-2*t150*t151*t85+6.0d-2*gammaaa*t27*t83*(
     6           2.073599999999999d-4*t149*t497*t561*t84-5.7599999999999
     7           97d-3*gammaaa*t303*t380*t84+3.839999999999999d-2*t150*t
     8           151*t84+6.0d-2*gammaaa*t27*(2.073599999999999d-4*t149*t
     9           497*t561*t8-5.759999999999997d-3*gammaaa*t303*t380*t8+3
     :           .839999999999999d-2*t150*t151*t8)*t83-1.599999999999999
     ;           8d-1*gammaaa*t143*t394*t83+1.2d-1*t27*t381*t83-3.199999
     <           9999999995d-1*t143*t194*t83+9.599999999999997d-3*t149*t
     =           150*t151*t394+4.32d-4*gammaaa*t152*t303*t393-7.2d-3*gam
     >           maaa*t150*t193*t381-2.303999999999999d-3*t149*t194*t303
     ?           *t380+5.759999999999998d-2*gammaaa*t150*t151*t194-7.2d-
     @           3*t150*t152*t193)-1.5999999999999998d-1*gammaaa*t143*t3
     1           95*t83+1.2d-1*t27*t382*t83-3.1999999999999995d-1*t143*t
     2           195*t83+9.599999999999997d-3*t149*t150*t151*t395+4.32d-
     3           4*gammaaa*t153*t303*t393-7.2d-3*gammaaa*t150*t193*t382-
     4           2.303999999999999d-3*t149*t195*t303*t380+5.759999999999
     5           998d-2*gammaaa*t150*t151*t195-7.2d-3*t150*t153*t193)-1.
     6           5999999999999998d-1*gammaaa*t143*t396*t83+1.2d-1*t27*t3
     7           83*t83-3.1999999999999995d-1*t143*t196*t83+9.5999999999
     8           99997d-3*t149*t150*t151*t396+4.32d-4*gammaaa*t154*t303*
     9           t393-7.2d-3*gammaaa*t150*t193*t383-2.303999999999999d-3
     :           *t149*t196*t303*t380+5.759999999999998d-2*gammaaa*t150*
     ;           t151*t196-7.2d-3*t150*t154*t193)*t90+5.0d-1*t397*t49*t9
     <           0+5.0d-1*rhoa*t101*t397*t90-2.5d-1*t197*t49*t89-2.5d-1*
     =           t384*t49-2.5d-1*t101*t197)+(t560+1.25d-1*gammaaa*t397*t
     >           49)*t88*t89+1.0d+0*(3.1d-3*t28*t30*(3.1d-3*t28*t30*(3.1
     ?           d-3*t28*t30*(1.4776335999999993d-9*gammaaa*t28*t31*t380
     @           *t403-4.766559999999998d-7*gammaaa*t296*t31*t380-3.1777
     1           066666666653d-7*t151*t28*t296*t31+1.0250666666666663d-4
     2           *t144*t151*t31)+1.4776335999999993d-9*gammaaa*t28*t32*t
     3           380*t403-8.266666666666665d-3*gammaaa*t143*t30*t389+2.5
     4           62666666666666d-5*gammaaa*t143*t144*t28*t389-4.76655999
     5           9999998d-7*gammaaa*t296*t32*t380+6.2d-3*t27*t30*t375-1.
     6           9219999999999998d-5*t144*t27*t28*t375-3.177706666666665
     7           3d-7*t151*t28*t296*t32+1.0250666666666663d-4*t144*t151*
     8           t32-1.653333333333333d-2*t143*t188*t30+5.9582d-8*t145*t
     9           193*t28*t296-3.1777066666666653d-7*gammaaa*t151*t188*t2
     :           8*t296+5.125333333333332d-5*t143*t144*t188*t28-1.921999
     ;           9999999998d-5*t144*t145*t193+1.0250666666666663d-4*gamm
     <           aaa*t144*t151*t188)+1.4776335999999993d-9*gammaaa*t28*t
     =           33*t380*t403-8.266666666666665d-3*gammaaa*t143*t30*t390
     >           +2.562666666666666d-5*gammaaa*t143*t144*t28*t390-4.7665
     ?           59999999998d-7*gammaaa*t296*t33*t380+6.2d-3*t27*t30*t37
     @           6-1.9219999999999998d-5*t144*t27*t28*t376-3.17770666666
     1           66653d-7*t151*t28*t296*t33+1.0250666666666663d-4*t144*t
     2           151*t33-1.653333333333333d-2*t143*t189*t30+5.9582d-8*t1
     3           46*t193*t28*t296-3.1777066666666653d-7*gammaaa*t151*t18
     4           9*t28*t296+5.125333333333332d-5*t143*t144*t189*t28-1.92
     5           19999999999998d-5*t144*t146*t193+1.0250666666666663d-4*
     6           gammaaa*t144*t151*t189)+1.4776335999999993d-9*gammaaa*t
     7           28*t34*t380*t403-8.266666666666665d-3*gammaaa*t143*t30*
     8           t391+2.562666666666666d-5*gammaaa*t143*t144*t28*t391-4.
     9           766559999999998d-7*gammaaa*t296*t34*t380+6.2d-3*t27*t30
     :           *t377-1.9219999999999998d-5*t144*t27*t28*t377-3.1777066
     ;           666666653d-7*t151*t28*t296*t34+1.0250666666666663d-4*t1
     <           44*t151*t34-1.653333333333333d-2*t143*t190*t30+5.9582d-
     =           8*t147*t193*t28*t296-3.1777066666666653d-7*gammaaa*t151
     >           *t190*t28*t296+5.125333333333332d-5*t143*t144*t190*t28-
     ?           1.9219999999999998d-5*t144*t147*t193+1.0250666666666663
     @           d-4*gammaaa*t144*t151*t190)*t81+1.0d+0*t142*t392)*wght+
     1           Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (1.0d+0*(3.1d-3*t28*t30*(3.1d-3*
     1           t28*t30*(3.1d-3*t28*t30*(3.6940839999999997d-59*t168*t1
     2           93*t28*t31*t403-1.1916399999999998d-56*t168*t193*t296*t
     3           31)+3.6940839999999997d-59*t168*t193*t28*t32*t403-2.066
     4           6666666666667d-52*t168*t30*t389+6.406666666666666d-55*t
     5           144*t168*t28*t389+6.2d-3*t27*t30*t385-1.921999999999999
     6           8d-5*t144*t27*t28*t385-1.1916399999999998d-56*t168*t193
     7           *t296*t32-7.944266666666666d-57*t168*t188*t27*t28*t296+
     8           5.9582d-8*t184*t193*t28*t296+2.5626666666666664d-54*t14
     9           4*t168*t188*t27-1.9219999999999998d-5*t144*t184*t193)+3
     :           .6940839999999997d-59*t168*t193*t28*t33*t403-2.06666666
     ;           66666667d-52*t168*t30*t390+6.406666666666666d-55*t144*t
     <           168*t28*t390+6.2d-3*t27*t30*t386-1.9219999999999998d-5*
     =           t144*t27*t28*t386-1.1916399999999998d-56*t168*t193*t296
     >           *t33-7.944266666666666d-57*t168*t189*t27*t28*t296+5.958
     ?           2d-8*t185*t193*t28*t296+2.5626666666666664d-54*t144*t16
     @           8*t189*t27-1.9219999999999998d-5*t144*t185*t193)+3.6940
     1           839999999997d-59*t168*t193*t28*t34*t403-2.0666666666666
     2           667d-52*t168*t30*t391+6.406666666666666d-55*t144*t168*t
     3           28*t391+6.2d-3*t27*t30*t387-1.9219999999999998d-5*t144*
     4           t27*t28*t387-1.1916399999999998d-56*t168*t193*t296*t34-
     5           7.944266666666666d-57*t168*t190*t27*t28*t296+5.9582d-8*
     6           t186*t193*t28*t296+2.5626666666666664d-54*t144*t168*t19
     7           0*t27-1.9219999999999998d-5*t144*t186*t193)*t81+1.0d+0*
     8           t183*t392)*wght+Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t88*(5.0d-1*rhoa*t49*(-7.776d-
     1           5*gammaaa*t497*t562*t86+1.296d-3*t303*t393*t86+6.0d-2*g
     2           ammaaa*t27*t83*(-7.776d-5*gammaaa*t497*t562*t85+1.296d-
     3           3*t303*t393*t85+6.0d-2*gammaaa*t27*t83*(-7.776d-5*gamma
     4           aa*t497*t562*t84+1.296d-3*t303*t393*t84+6.0d-2*gammaaa*
     5           t27*(1.296d-3*t303*t393*t8-7.776d-5*gammaaa*t497*t562*t
     6           8)*t83+1.8d-1*t27*t394*t83-1.0800000000000001d-2*gammaa
     7           a*t150*t193*t394+1.296d-3*gammaaa*t194*t303*t393-2.1600
     8           000000000003d-2*t150*t193*t194)+1.8d-1*t27*t395*t83-1.0
     9           800000000000001d-2*gammaaa*t150*t193*t395+1.296d-3*gamm
     :           aaa*t195*t303*t393-2.1600000000000003d-2*t150*t193*t195
     ;           )+1.8d-1*t27*t396*t83-1.0800000000000001d-2*gammaaa*t15
     <           0*t193*t396+1.296d-3*gammaaa*t196*t303*t393-2.160000000
     =           0000003d-2*t150*t193*t196)*t90-3.75d-1*t397*t49)+1.0d+0
     >           *(3.1d-3*t28*t30*(3.1d-3*t28*t30*(3.1d-3*t28*t30*(1.787
     ?           46d-7*t296*t31*t393-5.541126d-10*t28*t31*t393*t403)-5.5
     @           41126d-10*t28*t32*t393*t403+1.78746d-7*t296*t32*t393+9.
     1           299999999999999d-3*t27*t30*t389-2.883d-5*t144*t27*t28*t
     2           389+1.78746d-7*t188*t193*t28*t296-5.766d-5*t144*t188*t1
     3           93)-5.541126d-10*t28*t33*t393*t403+1.78746d-7*t296*t33*
     4           t393+9.299999999999999d-3*t27*t30*t390-2.883d-5*t144*t2
     5           7*t28*t390+1.78746d-7*t189*t193*t28*t296-5.766d-5*t144*
     6           t189*t193)-5.541126d-10*t28*t34*t393*t403+1.78746d-7*t2
     7           96*t34*t393+9.299999999999999d-3*t27*t30*t391-2.883d-5*
     8           t144*t27*t28*t391+1.78746d-7*t190*t193*t28*t296-5.766d-
     9           5*t144*t190*t193)*t81)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t198*(-5.0d-1*rhoa*t212*t87*t90-1
     1           .0d+0*t101*t87*t90-5.0d-1*rhoa*t308*t49*t90-1.0d+0*t155
     2           *t49*t90-1.0d+0*rhoa*t101*t155*t90-1.25d-1*gammaaa*t101
     3           *t87*t89-1.25d-1*gammaaa*t155*t49*t89-1.25d-1*gammaaa*t
     4           301*t49*t87)+t198*(-1.25d-1*gammaaa*t101*t87-1.25d-1*ga
     5           mmaaa*t155*t49)*t89+(1.0d+0*rhoa*t212*t87+2.0d+0*t101*t
     6           87+1.0d+0*rhoa*t308*t49+2.0d+0*t155*t49+2.0d+0*rhoa*t10
     7           1*t155)*t88+1.25d-1*gammaaa*t198*t301*t49*t87)*wght+Mma
     8           t3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t198*(-5.0d-1*rhoa*t384*t49*t90-
     1           5.0d-1*t197*t49*t90-5.0d-1*rhoa*t101*t197*t90+1.25d-1*t
     2           49*t87*t89+t558+t557)+t198*t556*t89+(1.0d+0*rhoa*t384*t
     3           49+1.0d+0*t197*t49+1.0d+0*rhoa*t101*t197)*t88)*wght+Mma
     4           t3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (t198*(t560-5.0d-1*rhoa*t397*t49*t
     1           90)+1.0d+0*rhoa*t397*t49*t88)*wght+Mmat3(iq,D3_RA_TA_TA
     2           )
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (-2.0d+0*rhoa*t197*t198*t49-2*t3
     1           98*t399)*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (6.0d+0*rhoa*t399*t49*t87-3.0d+0*
     1           rhoa*t49*t87*t90/taua**4)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = param(5)
              t28 = 1/rhob**2.6666666666666666d+0
              t29 = gammabb*t28+4.0d-50*t2
              t30 = 3.1d-3*t29+1.0d+0
              t31 = 1/t30
              t32 = 3.1d-3*t27*t29*t31+param(4)
              t33 = 3.1d-3*t29*t31*t32+param(3)
              t34 = 3.1d-3*t29*t31*t33+param(2)
              t35 = 3.1d-3*t29*t31*t34+param(1)
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = rhob+rhoa
              t51 = 1/t50**3.333333333333333d-1
              t52 = 1.3256889990520176d-1*t51+1.0d+0
              t53 = rhoa-rhob
              t54 = t53**4
              t55 = 1/t50**4
              t56 = 1/t50
              t57 = 1.0d+0-t53*t56
              t58 = t53*t56+1.0d+0
              t59 = t58**1.3333333333333333d+0+t57**1.3333333333333333d+
     1           0-2.0d+0
              t60 = -1.923661050931536d+0*t54*t55*t59
              t61 = t60+1.0d+0
              t62 = 1/t50**6.666666666666666d-1
              t63 = t50**5.0d-1
              t64 = 1/t63
              t65 = 1/t50**1.6666666666666666d-1
              t66 = 5.982550435771079d+0*t65+8.004286349993635d-1*t64+1.
     1           8970043257475583d-1*t62+2.2255694211506874d+0*t51
              t67 = 1.6081979498692536d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = -6.21814d-2*t52*t61*t68
              t70 = 6.901399211255825d-2*t51+1.0d+0
              t71 = t60+1.923661050931536d+0*t59
              t72 = 8.157414703487641d+0*t65+4.3009724712766434d-1*t64+1
     1           .9115125951273373d-1*t62+2.247591863577616d+0*t51
              t73 = 2.9608813203268075d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = 1.9751631321680768d-2*t70*t71*t74
              t76 = 1.274696188700087d-1*t51+1.0d+0
              t77 = 1.1120374863094686d+1*t65+1.644733775567609d+0*t64+2
     1           .4058712912881916d-1*t62+3.8447462374472113d+0*t51
              t78 = 3.216395899738507d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = -5.980796863619711d-2*t54*t55*t59*t76*t79
              t81 = t50*(t80+t75+t69)-rhob*t49-rhoa*t26
              t82 = 6.0d-2*gammabb*t28+1.0d+0
              t83 = 1/t82
              t84 = 6.0d-2*gammabb*t28*t8*t83+t7
              t85 = 6.0d-2*gammabb*t28*t83*t84+t6
              t86 = 6.0d-2*gammabb*t28*t83*t85+t5
              t87 = 6.0d-2*gammabb*t28*t83*t86+t1
              t88 = 1/taub
              t89 = 1/rhob
              t90 = 2.0d+0*taub-2.5d-1*gammabb*t89
              t91 = 1/t23
              t92 = 1/t14**3
              t93 = 1/rhoa**1.3333333333333333d+0
              t94 = 1/rhoa**1.1666666666666667d+0
              t95 = -9.970917392951799d-1*t94-7.418564737168958d-1*t93-4
     1           .002143174996817d-1*t92-1.264669550498372d-1*t2
              t96 = 1/t22**2
              t97 = 1/t19
              t98 = -1.8533958105157808d+0*t94-1.2815820791490704d+0*t93
     1           -8.223668877838045d-1*t92-1.6039141941921276d-1*t2
              t99 = 1/t18**2
              t100 = 1.0d+0*t21*t97*t98*t99+1.1102230246251565d-16*t25*t
     1           91*t95*t96+3.0506411443514264d-19*t24*t93+1.32103989313
     2           39265d-3*t20*t93
              t101 = 1/t3**2
              t102 = 1/rhoa**4.333333333333333d+0
              t103 = 1/rhoa**2.6666666666666666d+0
              t104 = 9.6d-102*t101*t102*t8-4.0d-51*t103*t4*t8
              t105 = -4.0d-51*t103*t4*t9+9.6d-102*t101*t102*t9+2.4d-51*t
     1           104*t2*t4
              t106 = 2.4d-51*t105*t2*t4-4.0d-51*t10*t103*t4+9.6d-102*t10
     1           *t101*t102
              t107 = 2.4d-51*t106*t2*t4-4.0d-51*t103*t11*t4+9.6d-102*t10
     1           1*t102*t11
              t108 = 1/t50**1.6666666666666669d+0
              t109 = 1/t63**3
              t110 = 1/t50**1.3333333333333333d+0
              t111 = 1/t50**1.1666666666666667d+0
              t112 = -9.970917392951799d-1*t111-7.418564737168958d-1*t11
     1           0-4.002143174996817d-1*t109-1.264669550498372d-1*t108
              t113 = 1/t66**2
              t114 = 1/t67
              t115 = 1.0d+0*t112*t113*t114*t52*t61
              t116 = -1.3595691172479402d+0*t111-7.491972878592053d-1*t1
     1           10-2.1504862356383217d-1*t109-1.2743417300848914d-1*t10
     2           8
              t117 = 1/t72**2
              t118 = 1/t73
              t119 = -5.848223622634647d-1*t116*t117*t118*t70*t71
              t120 = -1.8533958105157808d+0*t111-1.2815820791490704d+0*t
     1           110-8.223668877838045d-1*t109-1.6039141941921276d-1*t10
     2           8
              t121 = 1/t77**2
              t122 = 1/t78
              t123 = 1.923661050931536d+0*t120*t121*t122*t54*t55*t59*t76
              t124 = 1/t50**2
              t125 = t124*t53
              t126 = -t56
              t127 = t126+t125
              t128 = t57**3.333333333333333d-1
              t129 = -t124*t53
              t130 = t56+t129
              t131 = t58**3.333333333333333d-1
              t132 = 1.3333333333333333d+0*t130*t131+1.3333333333333333d
     1           +0*t127*t128
              t133 = -1.923661050931536d+0*t132*t54*t55
              t134 = 1/t50**5
              t135 = 7.694644203726144d+0*t134*t54*t59
              t136 = t53**3
              t137 = -7.694644203726144d+0*t136*t55*t59
              t138 = t137+t135+t133
              t139 = -6.21814d-2*t138*t52*t68
              t140 = 2.747773264188437d-3*t110*t61*t68
              t141 = t137+t135+t133+1.923661050931536d+0*t132
              t142 = 1.9751631321680768d-2*t141*t70*t74
              t143 = -4.5437964274821163d-4*t110*t71*t74
              t144 = -5.980796863619711d-2*t132*t54*t55*t76*t79
              t145 = 1/t50**5.333333333333333d+0
              t146 = 2.541232989148493d-3*t145*t54*t59*t79
              t147 = 2.3923187454478842d-1*t134*t54*t59*t76*t79
              t148 = t80+t50*(-2.3923187454478842d-1*t136*t55*t59*t76*t7
     1           9+t147+t146+t144+t143+t142+t140+t139+t123+t119+t115)+t7
     2           5+t69+6.903522198342671d-18*t24*t25+3.1090699999999993d
     3           -2*t20*t21-rhoa*t100
              t149 = 1/t30**2
              t150 = 6.406666666666666d-55*t103*t149*t27*t29-2.066666666
     1           6666667d-52*t103*t27*t31
              t151 = -2.0666666666666667d-52*t103*t31*t32+6.406666666666
     1           666d-55*t103*t149*t29*t32+3.1d-3*t150*t29*t31
              t152 = -2.0666666666666667d-52*t103*t31*t33+6.406666666666
     1           666d-55*t103*t149*t29*t33+3.1d-3*t151*t29*t31
              t153 = -2.0666666666666667d-52*t103*t31*t34+6.406666666666
     1           666d-55*t103*t149*t29*t34+3.1d-3*t152*t29*t31
              t154 = 1/t46
              t155 = 1/rhob**1.6666666666666669d+0
              t156 = 1/t37**3
              t157 = 1/rhob**1.3333333333333333d+0
              t158 = 1/rhob**1.1666666666666667d+0
              t159 = -9.970917392951799d-1*t158-7.418564737168958d-1*t15
     1           7-4.002143174996817d-1*t156-1.264669550498372d-1*t155
              t160 = 1/t45**2
              t161 = 1/t42
              t162 = -1.8533958105157808d+0*t158-1.2815820791490704d+0*t
     1           157-8.223668877838045d-1*t156-1.6039141941921276d-1*t15
     2           5
              t163 = 1/t41**2
              t164 = 1.1102230246251565d-16*t154*t159*t160*t48+3.0506411
     1           443514264d-19*t157*t47+1.0d+0*t161*t162*t163*t44+1.3210
     2           398931339265d-3*t157*t43
              t165 = t56+t125
              t166 = t129+t126
              t167 = 1.3333333333333333d+0*t131*t166+1.3333333333333333d
     1           +0*t128*t165
              t168 = -1.923661050931536d+0*t167*t54*t55
              t169 = 7.694644203726144d+0*t136*t55*t59
              t170 = t169+t168+t135
              t171 = -6.21814d-2*t170*t52*t68
              t172 = t169+t168+1.923661050931536d+0*t167+t135
              t173 = 1.9751631321680768d-2*t172*t70*t74
              t174 = -5.980796863619711d-2*t167*t54*t55*t76*t79
              t175 = t80+t50*(2.3923187454478842d-1*t136*t55*t59*t76*t79
     1           +t174+t173+t171+t147+t146+t143+t140+t123+t119+t115)+t75
     2           +t69+6.903522198342671d-18*t47*t48+3.1090699999999993d-
     3           2*t43*t44-rhob*t164
              t176 = 1/rhob**3.6666666666666664d+0
              t177 = 2.562666666666666d-5*gammabb*t149*t176*t27*t29-8.26
     1           6666666666665d-3*gammabb*t176*t27*t31
              t178 = -8.266666666666665d-3*gammabb*t176*t31*t32+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t32+3.1d-3*t177*t29*
     2           t31
              t179 = -8.266666666666665d-3*gammabb*t176*t31*t33+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t33+3.1d-3*t178*t29*
     2           t31
              t180 = -8.266666666666665d-3*gammabb*t176*t31*t34+2.562666
     1           666666666d-5*gammabb*t149*t176*t29*t34+3.1d-3*t179*t29*
     2           t31
              t181 = gammabb**2
              t182 = 1/t82**2
              t183 = 1/rhob**6.333333333333333d+0
              t184 = 9.599999999999997d-3*t181*t182*t183*t8-1.5999999999
     1           999998d-1*gammabb*t176*t8*t83
              t185 = -1.5999999999999998d-1*gammabb*t176*t83*t84+9.59999
     1           9999999997d-3*t181*t182*t183*t84+6.0d-2*gammabb*t184*t2
     2           8*t83
              t186 = -1.5999999999999998d-1*gammabb*t176*t83*t85+9.59999
     1           9999999997d-3*t181*t182*t183*t85+6.0d-2*gammabb*t185*t2
     2           8*t83
              t187 = -1.5999999999999998d-1*gammabb*t176*t83*t86+9.59999
     1           9999999997d-3*t181*t182*t183*t86+6.0d-2*gammabb*t186*t2
     2           8*t83
              t188 = 3.1d-3*t27*t28*t31-9.61d-6*t149*t27*t28*t29
              t189 = 3.1d-3*t28*t31*t32-9.61d-6*t149*t28*t29*t32+3.1d-3*
     1           t188*t29*t31
              t190 = 3.1d-3*t28*t31*t33-9.61d-6*t149*t28*t29*t33+3.1d-3*
     1           t189*t29*t31
              t191 = 3.1d-3*t28*t31*t34-9.61d-6*t149*t28*t29*t34+3.1d-3*
     1           t190*t29*t31
              t192 = -1.25d-1*t49*t87
              t193 = 1/rhob**5.333333333333333d+0
              t194 = 6.0d-2*t28*t8*t83-3.6d-3*gammabb*t182*t193*t8
              t195 = 6.0d-2*t28*t83*t84-3.6d-3*gammabb*t182*t193*t84+6.0
     1           d-2*gammabb*t194*t28*t83
              t196 = 6.0d-2*t28*t83*t85-3.6d-3*gammabb*t182*t193*t85+6.0
     1           d-2*gammabb*t195*t28*t83
              t197 = 6.0d-2*t28*t83*t86-3.6d-3*gammabb*t182*t193*t86+6.0
     1           d-2*gammabb*t196*t28*t83
              t198 = 1/taub**2
              t199 = 1/t23**2
              t200 = t95**2
              t201 = 1/t22**4
              t202 = 1/t22**3
              t203 = 1/t14**5
              t204 = 1/rhoa**2.3333333333333334d+0
              t205 = 1/rhoa**2.1666666666666665d+0
              t206 = 1.1632736958443765d+0*t205+9.89141964955861d-1*t204
     1           +6.003214762495226d-1*t203+2.1077825841639536d-1*t103
              t207 = 1/t19**2
              t208 = t98**2
              t209 = 1/t18**4
              t210 = 1/t18**3
              t211 = 2.1622951122684114d+0*t205+1.7087761055320938d+0*t2
     1           04+1.2335503316757068d+0*t203+2.673190323653546d-1*t103
              t212 = -8.497974591333913d-2*t93*t97*t98*t99+1.0d+0*t21*t2
     1           11*t97*t99-2.0d+0*t208*t21*t210*t97-9.812069668265515d-
     2           18*t91*t93*t95*t96+1.1102230246251565d-16*t206*t25*t91*
     3           t96-2.220446049250313d-16*t200*t202*t25*t91+1.785458392
     4           0998188d-15*t199*t200*t201*t25-4.0675215258019015d-19*t
     5           204*t24+3.216395899738507d+1*t207*t208*t209*t21-1.76138
     6           65241785684d-3*t20*t204
              t213 = 1/t3**3
              t214 = 1/rhoa**7
              t215 = 1/rhoa**5.333333333333333d+0
              t216 = 1/rhoa**3.6666666666666664d+0
              t217 = 1.0666666666666666d-50*t216*t4*t8-5.76d-101*t101*t2
     1           15*t8+7.68d-152*t213*t214*t8
              t218 = 1.0666666666666666d-50*t216*t4*t9-5.76d-101*t101*t2
     1           15*t9+7.68d-152*t213*t214*t9+2.4d-51*t2*t217*t4-8.0d-51
     2           *t103*t104*t4+1.92d-101*t101*t102*t104
              t219 = 2.4d-51*t2*t218*t4+1.0666666666666666d-50*t10*t216*
     1           t4-8.0d-51*t103*t105*t4-5.76d-101*t10*t101*t215+7.68d-1
     2           52*t10*t213*t214+1.92d-101*t101*t102*t105
              t220 = 2.4d-51*t2*t219*t4+1.0666666666666666d-50*t11*t216*
     1           t4-8.0d-51*t103*t106*t4-5.76d-101*t101*t11*t215+7.68d-1
     2           52*t11*t213*t214+1.92d-101*t101*t102*t106
              t221 = 2.0d+0*t112*t113*t114*t52*t61
              t222 = -1.1696447245269295d+0*t116*t117*t118*t70*t71
              t223 = 3.847322101863072d+0*t120*t121*t122*t54*t55*t59*t76
              t224 = 5.495546528376875d-3*t110*t61*t68
              t225 = -9.087592854964233d-4*t110*t71*t74
              t226 = 5.082465978296986d-3*t145*t54*t59*t79
              t227 = 4.7846374908957684d-1*t134*t54*t59*t76*t79
              t228 = t112**2
              t229 = 1/t66**4
              t230 = 1/t67**2
              t231 = 1.6081979498692536d+1*t228*t229*t230*t52*t61
              t232 = 2.0d+0*t112*t113*t114*t138*t52
              t233 = 1/t66**3
              t234 = -2.0d+0*t114*t228*t233*t52*t61
              t235 = -8.837926660346784d-2*t110*t112*t113*t114*t61
              t236 = 1/t50**2.6666666666666666d+0
              t237 = 1/t63**5
              t238 = 1/t50**2.3333333333333334d+0
              t239 = 1/t50**2.1666666666666665d+0
              t240 = 1.1632736958443765d+0*t239+9.89141964955861d-1*t238
     1           +6.003214762495226d-1*t237+2.1077825841639536d-1*t236
              t241 = 1.0d+0*t113*t114*t240*t52*t61
              t242 = t116**2
              t243 = 1/t72**4
              t244 = 1/t73**2
              t245 = -1.73158960813529d+1*t242*t243*t244*t70*t71
              t246 = -1.1696447245269295d+0*t116*t117*t118*t141*t70
              t247 = 1/t72**3
              t248 = 1.1696447245269295d+0*t118*t242*t247*t70*t71
              t249 = 2.690728393099896d-2*t110*t116*t117*t118*t71
              t250 = 1.5861639701225969d+0*t239+9.98929717145607d-1*t238
     1           +3.2257293534574827d-1*t237+2.1239028834748191d-1*t236
              t251 = -5.848223622634647d-1*t117*t118*t250*t70*t71
              t252 = t120**2
              t253 = 1/t77**4
              t254 = 1/t78**2
              t255 = 6.187255516702861d+1*t252*t253*t254*t54*t55*t59*t76
              t256 = 3.847322101863072d+0*t120*t121*t122*t132*t54*t55*t7
     1           6
              t257 = 1/t77**3
              t258 = -3.847322101863072d+0*t122*t252*t257*t54*t55*t59*t7
     1           6
              t259 = -1.6347222733154887d-1*t120*t121*t122*t145*t54*t59
              t260 = 2.1622951122684114d+0*t239+1.7087761055320938d+0*t2
     1           38+1.2335503316757068d+0*t237+2.673190323653546d-1*t236
              t261 = 1.923661050931536d+0*t121*t122*t260*t54*t55*t59*t76
              t262 = -1.538928840745229d+1*t120*t121*t122*t134*t54*t59*t
     1           76
              t263 = 1.538928840745229d+1*t120*t121*t122*t136*t55*t59*t7
     1           6
              t264 = t127**2
              t265 = 1/t57**6.666666666666666d-1
              t266 = 1/t50**3
              t267 = -2*t266*t53
              t268 = 2*t124
              t269 = t268+t267
              t270 = t130**2
              t271 = 1/t58**6.666666666666666d-1
              t272 = 2*t266*t53
              t273 = -2*t124
              t274 = t273+t272
              t275 = 1.3333333333333333d+0*t131*t274+4.444444444444444d-
     1           1*t270*t271+1.3333333333333333d+0*t128*t269+4.444444444
     2           444444d-1*t264*t265
              t276 = -1.923661050931536d+0*t275*t54*t55
              t277 = 1.5389288407452287d+1*t132*t134*t54
              t278 = -1.5389288407452287d+1*t132*t136*t55
              t279 = 1/t50**6
              t280 = -3.8473221018630716d+1*t279*t54*t59
              t281 = 6.155715362980915d+1*t134*t136*t59
              t282 = t53**2
              t283 = -2.3083932611178434d+1*t282*t55*t59
              t284 = t283+t281+t280+t278+t277+t276
              t285 = -6.21814d-2*t284*t52*t68
              t286 = 5.495546528376875d-3*t110*t138*t68
              t287 = -3.663697685584583d-3*t238*t61*t68
              t288 = t283+t281+t280+t278+t277+t276+1.923661050931536d+0*
     1           t275
              t289 = 1.9751631321680768d-2*t288*t70*t74
              t290 = -9.087592854964233d-4*t110*t141*t74
              t291 = 6.058395236642822d-4*t238*t71*t74
              t292 = -5.980796863619711d-2*t275*t54*t55*t76*t79
              t293 = 5.082465978296986d-3*t132*t145*t54*t79
              t294 = 4.7846374908957684d-1*t132*t134*t54*t76*t79
              t295 = 1/t50**6.333333333333333d+0
              t296 = -2.3718174565385935d-2*t295*t54*t59*t79
              t297 = 2.0329863913187946d-2*t136*t145*t59*t79
              t298 = -1.1961593727239421d+0*t279*t54*t59*t76*t79
              t299 = 1.9138549963583074d+0*t134*t136*t59*t76*t79
              t300 = -7.176956236343652d-1*t282*t55*t59*t76*t79
              t301 = -2.0d+0*t21*t97*t98*t99-2.220446049250313d-16*t25*t
     1           91*t95*t96-6.101282288702853d-19*t24*t93-2.642079786267
     2           853d-3*t20*t93+t50*(-4.7846374908957684d-1*t132*t136*t5
     3           5*t76*t79+t300+t299+t298+t297+t296+t294+t293+t292+t291+
     4           t290+t289+t287+t286+t285+t263+t262+t261+t259+t258+t256+
     5           t255+t251+t249+t248+t246+t245+t241+t235+t234+t232+t231)
     6           -4.7846374908957684d-1*t136*t55*t59*t76*t79-1.196159372
     7           7239421d-1*t132*t54*t55*t76*t79+3.9503262643361536d-2*t
     8           141*t70*t74-1.243628d-1*t138*t52*t68+t227+t226+t225+t22
     9           4+t223+t222+t221-rhoa*t212
              t302 = 1/t30**3
              t303 = 5.51111111111111d-52*t216*t27*t31+2.648088888888888
     1           7d-106*t215*t27*t29*t302-1.708444444444444d-54*t149*t21
     2           6*t27*t29-8.542222222222222d-104*t149*t215*t27
              t304 = 5.51111111111111d-52*t216*t31*t32+2.648088888888888
     1           7d-106*t215*t29*t302*t32-1.708444444444444d-54*t149*t21
     2           6*t29*t32-8.542222222222222d-104*t149*t215*t32+3.1d-3*t
     3           29*t303*t31-4.1333333333333333d-52*t103*t150*t31+1.2813
     4           333333333332d-54*t103*t149*t150*t29
              t305 = 5.51111111111111d-52*t216*t31*t33+2.648088888888888
     1           7d-106*t215*t29*t302*t33-1.708444444444444d-54*t149*t21
     2           6*t29*t33-8.542222222222222d-104*t149*t215*t33+3.1d-3*t
     3           29*t304*t31-4.1333333333333333d-52*t103*t151*t31+1.2813
     4           333333333332d-54*t103*t149*t151*t29
              t306 = 5.51111111111111d-52*t216*t31*t34+2.648088888888888
     1           7d-106*t215*t29*t302*t34-1.708444444444444d-54*t149*t21
     2           6*t29*t34-8.542222222222222d-104*t149*t215*t34+3.1d-3*t
     3           29*t305*t31-4.1333333333333333d-52*t103*t152*t31+1.2813
     4           333333333332d-54*t103*t149*t152*t29
              t307 = 2.6666666666666666d+0*t131*t266*t53-2.6666666666666
     1           666d+0*t128*t266*t53+4.444444444444444d-1*t130*t166*t27
     2           1+4.444444444444444d-1*t127*t165*t265
              t308 = -1.923661050931536d+0*t307*t54*t55
              t309 = 7.694644203726144d+0*t134*t167*t54
              t310 = -7.694644203726144d+0*t136*t167*t55
              t311 = 7.694644203726144d+0*t132*t134*t54
              t312 = 7.694644203726144d+0*t132*t136*t55
              t313 = 2.3083932611178434d+1*t282*t55*t59
              t314 = t313+t312+t311+t310+t309+t308+t280
              t315 = t313+t312+t311+t310+t309+t308+1.923661050931536d+0*
     1           t307+t280
              t316 = 7.176956236343652d-1*t282*t55*t59*t76*t79
              t317 = t50*(-5.980796863619711d-2*t307*t54*t55*t76*t79-2.3
     1           923187454478842d-1*t136*t167*t55*t76*t79+2.392318745447
     2           8842d-1*t132*t136*t55*t76*t79+2.3923187454478842d-1*t13
     3           4*t167*t54*t76*t79+2.3923187454478842d-1*t132*t134*t54*
     4           t76*t79+2.541232989148493d-3*t145*t167*t54*t79+2.541232
     5           989148493d-3*t132*t145*t54*t79+1.923661050931536d+0*t12
     6           0*t121*t122*t167*t54*t55*t76+1.923661050931536d+0*t120*
     7           t121*t122*t132*t54*t55*t76+1.9751631321680768d-2*t315*t
     8           70*t74-4.5437964274821163d-4*t110*t172*t74-4.5437964274
     9           821163d-4*t110*t141*t74-5.848223622634647d-1*t116*t117*
     :           t118*t172*t70-5.848223622634647d-1*t116*t117*t118*t141*
     ;           t70-6.21814d-2*t314*t52*t68+2.747773264188437d-3*t110*t
     <           170*t68+2.747773264188437d-3*t110*t138*t68+1.0d+0*t112*
     =           t113*t114*t170*t52+1.0d+0*t112*t113*t114*t138*t52+t316+
     >           t298+t296+t291+t287+t262+t261+t259+t258+t255+t251+t249+
     ?           t248+t245+t241+t235+t234+t231)+t227+t226+t225+t224+t223
     @           +t222+t221+t174+t173+t171+t144+t142+t139
              t318 = 1.0592355555555552d-56*gammabb*t103*t176*t27*t29*t3
     1           02-3.416888888888888d-54*gammabb*t103*t149*t176*t27
              t319 = 1.0592355555555552d-56*gammabb*t103*t176*t29*t302*t
     1           32-3.416888888888888d-54*gammabb*t103*t149*t176*t32+3.1
     2           d-3*t29*t31*t318-2.0666666666666667d-52*t103*t177*t31-8
     3           .266666666666665d-3*gammabb*t150*t176*t31+6.40666666666
     4           6666d-55*t103*t149*t177*t29+2.562666666666666d-5*gammab
     5           b*t149*t150*t176*t29
              t320 = 1.0592355555555552d-56*gammabb*t103*t176*t29*t302*t
     1           33-3.416888888888888d-54*gammabb*t103*t149*t176*t33+3.1
     2           d-3*t29*t31*t319-2.0666666666666667d-52*t103*t178*t31-8
     3           .266666666666665d-3*gammabb*t151*t176*t31+6.40666666666
     4           6666d-55*t103*t149*t178*t29+2.562666666666666d-5*gammab
     5           b*t149*t151*t176*t29
              t321 = 1.0592355555555552d-56*gammabb*t103*t176*t29*t302*t
     1           34-3.416888888888888d-54*gammabb*t103*t149*t176*t34+3.1
     2           d-3*t29*t31*t320-2.0666666666666667d-52*t103*t179*t31-8
     3           .266666666666665d-3*gammabb*t152*t176*t31+6.40666666666
     4           6666d-55*t103*t149*t179*t29+2.562666666666666d-5*gammab
     5           b*t149*t152*t176*t29
              t322 = 1/t46**2
              t323 = t159**2
              t324 = 1/t45**4
              t325 = 1/t45**3
              t326 = 1/t37**5
              t327 = 1/rhob**2.3333333333333334d+0
              t328 = 1/rhob**2.1666666666666665d+0
              t329 = 1.1632736958443765d+0*t328+9.89141964955861d-1*t327
     1           +6.003214762495226d-1*t326+2.1077825841639536d-1*t28
              t330 = 1/t42**2
              t331 = t162**2
              t332 = 1/t41**4
              t333 = 1/t41**3
              t334 = 2.1622951122684114d+0*t328+1.7087761055320938d+0*t3
     1           27+1.2335503316757068d+0*t326+2.673190323653546d-1*t28
              t335 = 1.1102230246251565d-16*t154*t160*t329*t48-2.2204460
     1           49250313d-16*t154*t323*t325*t48+1.7854583920998188d-15*
     2           t322*t323*t324*t48-4.0675215258019015d-19*t327*t47+1.0d
     3           +0*t161*t163*t334*t44-2.0d+0*t161*t331*t333*t44+3.21639
     4           5899738507d+1*t330*t331*t332*t44-1.7613865241785684d-3*
     5           t327*t43-8.497974591333913d-2*t157*t161*t162*t163-9.812
     6           069668265515d-18*t154*t157*t159*t160
              t336 = 2.0d+0*t112*t113*t114*t170*t52
              t337 = -1.1696447245269295d+0*t116*t117*t118*t172*t70
              t338 = 3.847322101863072d+0*t120*t121*t122*t167*t54*t55*t7
     1           6
              t339 = -1.538928840745229d+1*t120*t121*t122*t136*t55*t59*t
     1           76
              t340 = t165**2
              t341 = t273+t267
              t342 = t166**2
              t343 = t272+t268
              t344 = 1.3333333333333333d+0*t131*t343+4.444444444444444d-
     1           1*t271*t342+1.3333333333333333d+0*t128*t341+4.444444444
     2           444444d-1*t265*t340
              t345 = -1.923661050931536d+0*t344*t54*t55
              t346 = 1.5389288407452287d+1*t134*t167*t54
              t347 = 1.5389288407452287d+1*t136*t167*t55
              t348 = -6.155715362980915d+1*t134*t136*t59
              t349 = t348+t347+t346+t345+t283+t280
              t350 = -6.21814d-2*t349*t52*t68
              t351 = 5.495546528376875d-3*t110*t170*t68
              t352 = t348+t347+t346+t345+1.923661050931536d+0*t344+t283+
     1           t280
              t353 = 1.9751631321680768d-2*t352*t70*t74
              t354 = -9.087592854964233d-4*t110*t172*t74
              t355 = -5.980796863619711d-2*t344*t54*t55*t76*t79
              t356 = 5.082465978296986d-3*t145*t167*t54*t79
              t357 = 4.7846374908957684d-1*t134*t167*t54*t76*t79
              t358 = -2.0329863913187946d-2*t136*t145*t59*t79
              t359 = -1.9138549963583074d+0*t134*t136*t59*t76*t79
              t360 = t50*(4.7846374908957684d-1*t136*t167*t55*t76*t79+t3
     1           59+t358+t357+t356+t355+t354+t353+t351+t350+t339+t338+t3
     2           37+t336+t300+t298+t296+t291+t287+t262+t261+t259+t258+t2
     3           55+t251+t249+t248+t245+t241+t235+t234+t231)+4.784637490
     4           8957684d-1*t136*t55*t59*t76*t79-1.1961593727239421d-1*t
     5           167*t54*t55*t76*t79+3.9503262643361536d-2*t172*t70*t74-
     6           1.243628d-1*t170*t52*t68-2.220446049250313d-16*t154*t15
     7           9*t160*t48-6.101282288702853d-19*t157*t47-2.0d+0*t161*t
     8           162*t163*t44-2.642079786267853d-3*t157*t43-rhob*t335+t2
     9           27+t226+t225+t224+t223+t222+t221
              t361 = 1/rhob**7.333333333333333d+0
              t362 = 1/rhob**4.666666666666667d+0
              t363 = 3.0311111111111105d-2*gammabb*t27*t31*t362-9.396444
     1           444444442d-5*gammabb*t149*t27*t29*t362+4.23694222222222
     2           03d-7*t181*t27*t29*t302*t361-1.366755555555555d-4*t149*
     3           t181*t27*t361
              t364 = 3.1d-3*t29*t31*t363+3.0311111111111105d-2*gammabb*t
     1           31*t32*t362-9.396444444444442d-5*gammabb*t149*t29*t32*t
     2           362+4.2369422222222203d-7*t181*t29*t302*t32*t361-1.3667
     3           55555555555d-4*t149*t181*t32*t361-1.653333333333333d-2*
     4           gammabb*t176*t177*t31+5.125333333333332d-5*gammabb*t149
     5           *t176*t177*t29
              t365 = 3.1d-3*t29*t31*t364+3.0311111111111105d-2*gammabb*t
     1           31*t33*t362-9.396444444444442d-5*gammabb*t149*t29*t33*t
     2           362+4.2369422222222203d-7*t181*t29*t302*t33*t361-1.3667
     3           55555555555d-4*t149*t181*t33*t361-1.653333333333333d-2*
     4           gammabb*t176*t178*t31+5.125333333333332d-5*gammabb*t149
     5           *t176*t178*t29
              t366 = 3.1d-3*t29*t31*t365+3.0311111111111105d-2*gammabb*t
     1           31*t34*t362-9.396444444444442d-5*gammabb*t149*t29*t34*t
     2           362+4.2369422222222203d-7*t181*t29*t302*t34*t361-1.3667
     3           55555555555d-4*t149*t181*t34*t361-1.653333333333333d-2*
     4           gammabb*t176*t179*t31+5.125333333333332d-5*gammabb*t149
     5           *t176*t179*t29
              t367 = 1/rhob**2
              t368 = gammabb**3
              t369 = 1/t82**3
              t370 = 1/rhob**10
              t371 = 5.866666666666666d-1*gammabb*t362*t8*t83+3.07199999
     1           99999986d-3*t368*t369*t370*t8-8.639999999999998d-2*t181
     2           *t182*t361*t8
              t372 = 5.866666666666666d-1*gammabb*t362*t83*t84+3.0719999
     1           999999986d-3*t368*t369*t370*t84-8.639999999999998d-2*t1
     2           81*t182*t361*t84+6.0d-2*gammabb*t28*t371*t83-3.19999999
     3           99999995d-1*gammabb*t176*t184*t83+1.9199999999999995d-2
     4           *t181*t182*t183*t184
              t373 = 5.866666666666666d-1*gammabb*t362*t83*t85+3.0719999
     1           999999986d-3*t368*t369*t370*t85-8.639999999999998d-2*t1
     2           81*t182*t361*t85+6.0d-2*gammabb*t28*t372*t83-3.19999999
     3           99999995d-1*gammabb*t176*t185*t83+1.9199999999999995d-2
     4           *t181*t182*t183*t185
              t374 = 5.866666666666666d-1*gammabb*t362*t83*t86+3.0719999
     1           999999986d-3*t368*t369*t370*t86-8.639999999999998d-2*t1
     2           81*t182*t361*t86+6.0d-2*gammabb*t28*t373*t83-3.19999999
     3           99999995d-1*gammabb*t176*t186*t83+1.9199999999999995d-2
     4           *t181*t182*t183*t186
              t375 = 1.2813333333333332d-54*t103*t149*t27*t28-3.97213333
     1           3333333d-57*t103*t27*t28*t29*t302
              t376 = 3.1d-3*t29*t31*t375-3.972133333333333d-57*t103*t28*
     1           t29*t302*t32+1.2813333333333332d-54*t103*t149*t28*t32+3
     2           .1d-3*t150*t28*t31-2.0666666666666667d-52*t103*t188*t31
     3           -9.61d-6*t149*t150*t28*t29+6.406666666666666d-55*t103*t
     4           149*t188*t29
              t377 = 3.1d-3*t29*t31*t376-3.972133333333333d-57*t103*t28*
     1           t29*t302*t33+1.2813333333333332d-54*t103*t149*t28*t33+3
     2           .1d-3*t151*t28*t31-2.0666666666666667d-52*t103*t189*t31
     3           -9.61d-6*t149*t151*t28*t29+6.406666666666666d-55*t103*t
     4           149*t189*t29
              t378 = 3.1d-3*t29*t31*t377-3.972133333333333d-57*t103*t28*
     1           t29*t302*t34+1.2813333333333332d-54*t103*t149*t28*t34+3
     2           .1d-3*t152*t28*t31-2.0666666666666667d-52*t103*t190*t31
     3           -9.61d-6*t149*t152*t28*t29+6.406666666666666d-55*t103*t
     4           149*t190*t29
              t379 = -8.266666666666665d-3*t176*t27*t31-1.58885333333333
     1           27d-7*gammabb*t183*t27*t29*t302+2.562666666666666d-5*t1
     2           49*t176*t27*t29+5.125333333333332d-5*gammabb*t149*t183*
     3           t27
              t380 = 3.1d-3*t29*t31*t379-8.266666666666665d-3*t176*t31*t
     1           32-1.5888533333333327d-7*gammabb*t183*t29*t302*t32+2.56
     2           2666666666666d-5*t149*t176*t29*t32+5.125333333333332d-5
     3           *gammabb*t149*t183*t32+3.1d-3*t177*t28*t31-8.2666666666
     4           66665d-3*gammabb*t176*t188*t31-9.61d-6*t149*t177*t28*t2
     5           9+2.562666666666666d-5*gammabb*t149*t176*t188*t29
              t381 = 3.1d-3*t29*t31*t380-8.266666666666665d-3*t176*t31*t
     1           33-1.5888533333333327d-7*gammabb*t183*t29*t302*t33+2.56
     2           2666666666666d-5*t149*t176*t29*t33+5.125333333333332d-5
     3           *gammabb*t149*t183*t33+3.1d-3*t178*t28*t31-8.2666666666
     4           66665d-3*gammabb*t176*t189*t31-9.61d-6*t149*t178*t28*t2
     5           9+2.562666666666666d-5*gammabb*t149*t176*t189*t29
              t382 = 3.1d-3*t29*t31*t381-8.266666666666665d-3*t176*t31*t
     1           34-1.5888533333333327d-7*gammabb*t183*t29*t302*t34+2.56
     2           2666666666666d-5*t149*t176*t29*t34+5.125333333333332d-5
     3           *gammabb*t149*t183*t34+3.1d-3*t179*t28*t31-8.2666666666
     4           66665d-3*gammabb*t176*t190*t31-9.61d-6*t149*t179*t28*t2
     5           9+2.562666666666666d-5*gammabb*t149*t176*t190*t29
              t383 = 1.25d-1*t49*t87
              t384 = 1/rhob**9
              t385 = -1.5999999999999998d-1*t176*t8*t83-1.15199999999999
     1           96d-3*t181*t369*t384*t8+2.879999999999999d-2*gammabb*t1
     2           82*t183*t8
              t386 = -1.5999999999999998d-1*t176*t83*t84-1.1519999999999
     1           996d-3*t181*t369*t384*t84+2.879999999999999d-2*gammabb*
     2           t182*t183*t84+6.0d-2*gammabb*t28*t385*t83+6.0d-2*t184*t
     3           28*t83-1.5999999999999998d-1*gammabb*t176*t194*t83+9.59
     4           9999999999997d-3*t181*t182*t183*t194-3.6d-3*gammabb*t18
     5           2*t184*t193
              t387 = -1.5999999999999998d-1*t176*t83*t85-1.1519999999999
     1           996d-3*t181*t369*t384*t85+2.879999999999999d-2*gammabb*
     2           t182*t183*t85+6.0d-2*gammabb*t28*t386*t83+6.0d-2*t185*t
     3           28*t83-1.5999999999999998d-1*gammabb*t176*t195*t83+9.59
     4           9999999999997d-3*t181*t182*t183*t195-3.6d-3*gammabb*t18
     5           2*t185*t193
              t388 = -1.5999999999999998d-1*t176*t83*t86-1.1519999999999
     1           996d-3*t181*t369*t384*t86+2.879999999999999d-2*gammabb*
     2           t182*t183*t86+6.0d-2*gammabb*t28*t387*t83+6.0d-2*t186*t
     3           28*t83-1.5999999999999998d-1*gammabb*t176*t196*t83+9.59
     4           9999999999997d-3*t181*t182*t183*t196-3.6d-3*gammabb*t18
     5           2*t186*t193
              t389 = 5.9582d-8*t193*t27*t29*t302-1.9219999999999998d-5*t
     1           149*t193*t27
              t390 = 3.1d-3*t29*t31*t389+5.9582d-8*t193*t29*t302*t32-1.9
     1           219999999999998d-5*t149*t193*t32+6.2d-3*t188*t28*t31-1.
     2           9219999999999998d-5*t149*t188*t28*t29
              t391 = 3.1d-3*t29*t31*t390+5.9582d-8*t193*t29*t302*t33-1.9
     1           219999999999998d-5*t149*t193*t33+6.2d-3*t189*t28*t31-1.
     2           9219999999999998d-5*t149*t189*t28*t29
              t392 = 3.1d-3*t29*t31*t391+5.9582d-8*t193*t29*t302*t34-1.9
     1           219999999999998d-5*t149*t193*t34+6.2d-3*t190*t28*t31-1.
     2           9219999999999998d-5*t149*t190*t28*t29
              t393 = 1/rhob**8
              t394 = 4.32d-4*gammabb*t369*t393*t8-7.2d-3*t182*t193*t8
              t395 = 4.32d-4*gammabb*t369*t393*t84-7.2d-3*t182*t193*t84+
     1           6.0d-2*gammabb*t28*t394*t83+1.2d-1*t194*t28*t83-7.2d-3*
     2           gammabb*t182*t193*t194
              t396 = 4.32d-4*gammabb*t369*t393*t85-7.2d-3*t182*t193*t85+
     1           6.0d-2*gammabb*t28*t395*t83+1.2d-1*t195*t28*t83-7.2d-3*
     2           gammabb*t182*t193*t195
              t397 = 4.32d-4*gammabb*t369*t393*t86-7.2d-3*t182*t193*t86+
     1           6.0d-2*gammabb*t28*t396*t83+1.2d-1*t196*t28*t83-7.2d-3*
     2           gammabb*t182*t193*t196
              t398 = t383-5.0d-1*rhob*t197*t49*t90
              t399 = 1/taub**3
              t400 = t95**3
              t401 = 1/t14**7
              t402 = 1/rhoa**3.3333333333333337d+0
              t403 = 1/rhoa**3.1666666666666665d+0
              t404 = t98**3
              t405 = 1.6995949182667827d-1*t204*t97*t98*t99-1.2746961887
     1           00087d-1*t211*t93*t97*t99+1.0d+0*t21*(-4.68497274324822
     2           4d+0*t403-3.9871442462415524d+0*t402-3.083875829189267d
     3           +0*t401-7.128507529742789d-1*t216)*t97*t99-6.0d+0*t21*t
     4           210*t211*t97*t98+9.649187699215522d+1*t207*t209*t21*t21
     5           1*t98+2.549392377400174d-1*t208*t210*t93*t97+6.0d+0*t20
     6           9*t21*t404*t97+1.962413933653103d-17*t204*t91*t95*t96-1
     7           .4718104502398274d-17*t206*t91*t93*t96+1.11022302462515
     8           65d-16*t25*(-2.520426340996149d+0*t403-2.30799791823034
     9           28d+0*t402-1.5008036906238065d+0*t401-5.620753557770543
     :           d-1*t216)*t91*t96-6.661338147750939d-16*t202*t206*t25*t
     ;           91*t95+5.356375176299456d-15*t199*t201*t206*t25*t95+2.9
     <           43620900479655d-17*t200*t202*t91*t93-4.0999275947472624
     =           d+0*t207*t208*t209*t93-2.3669625486718335d-16*t199*t200
     >           *t201*t93+6.661338147750939d-16*t201*t25*t400*t91-1.929
     ?           8375398431045d+2*t207*t21*t404/t18**5+2.069040516770936
     @           4d+3*t21*t404/(t18**6*t19**3)+9.490883560204437d-19*t24
     1           *t402+4.1099018897499934d-3*t20*t402+5.742741051503565d
     2           -14*t25*t400/(t22**6*t23**3)-1.0712750352598913d-14*t19
     3           9*t25*t400/t22**5
              t406 = 1/t3**4
              t407 = 1/rhoa**9.666666666666666d+0
              t408 = 1/rhoa**8
              t409 = 1/rhoa**6.333333333333333d+0
              t410 = 1/rhoa**4.666666666666667d+0
              t411 = 1/t30**4
              t412 = 4.824593849607761d+1*t228*t229*t230*t52*t61
              t413 = -6.0d+0*t114*t228*t233*t52*t61
              t414 = -2.6513779981040353d-1*t110*t112*t113*t114*t61
              t415 = 3.0d+0*t113*t114*t240*t52*t61
              t416 = -5.19476882440587d+1*t242*t243*t244*t70*t71
              t417 = 3.5089341735807883d+0*t118*t242*t247*t70*t71
              t418 = 8.072185179299687d-2*t110*t116*t117*t118*t71
              t419 = -1.7544670867903941d+0*t117*t118*t250*t70*t71
              t420 = 1.856176655010858d+2*t252*t253*t254*t54*t55*t59*t76
              t421 = -1.1541966305589217d+1*t122*t252*t257*t54*t55*t59*t
     1           76
              t422 = -4.904166819946466d-1*t120*t121*t122*t145*t54*t59
              t423 = 5.770983152794609d+0*t121*t122*t260*t54*t55*t59*t76
              t424 = -4.616786522235687d+1*t120*t121*t122*t134*t54*t59*t
     1           76
              t425 = -1.099109305675375d-2*t238*t61*t68
              t426 = 1.8175185709928465d-3*t238*t71*t74
              t427 = -7.11545236961578d-2*t295*t54*t59*t79
              t428 = -3.588478118171826d+0*t279*t54*t59*t76*t79
              t429 = -2.1530868709030954d+0*t282*t55*t59*t76*t79
              t430 = t112**3
              t431 = 5.172601291927341d+2*t430*t52*t61/(t66**6*t67**3)
              t432 = -9.649187699215522d+1*t230*t430*t52*t61/t66**5
              t433 = 4.824593849607761d+1*t112*t229*t230*t240*t52*t61
              t434 = -2.1319703304396778d+0*t110*t228*t229*t230*t61
              t435 = 6.0d+0*t114*t229*t430*t52*t61
              t436 = -6.0d+0*t112*t114*t233*t240*t52*t61
              t437 = 2.6513779981040353d-1*t110*t114*t228*t233*t61
              t438 = -1.3256889990520176d-1*t110*t113*t114*t240*t61
              t439 = 1.767585332069357d-1*t112*t113*t114*t238*t61
              t440 = 1/t50**3.6666666666666664d+0
              t441 = 1/t63**7
              t442 = 1/t50**3.3333333333333337d+0
              t443 = 1/t50**3.1666666666666665d+0
              t444 = 1.0d+0*t113*t114*(-2.520426340996149d+0*t443-2.3079
     1           979182303428d+0*t442-1.5008036906238065d+0*t441-5.62075
     2           3557770543d-1*t440)*t52*t61
              t445 = t116**3
              t446 = -1.0254062650399592d+3*t445*t70*t71/(t72**6*t73**3)
              t447 = 1.0389537648811739d+2*t244*t445*t70*t71/t72**5
              t448 = -5.19476882440587d+1*t116*t243*t244*t250*t70*t71
              t449 = 1.1950391155803675d+0*t110*t242*t243*t244*t71
              t450 = -3.5089341735807883d+0*t118*t243*t445*t70*t71
              t451 = 3.5089341735807883d+0*t116*t118*t247*t250*t70*t71
              t452 = -8.072185179299687d-2*t110*t118*t242*t247*t71
              t453 = 4.0360925896498434d-2*t110*t117*t118*t250*t71
              t454 = -5.381456786199791d-2*t116*t117*t118*t238*t71
              t455 = -5.848223622634647d-1*t117*t118*(-3.436688601932293
     1           d+0*t443-2.3308360066730832d+0*t442-8.064323383643707d-
     2           1*t441-5.663741022599518d-1*t440)*t70*t71
              t456 = t120**3
              t457 = 3.9801326549115085d+3*t456*t54*t55*t59*t76/(t77**6*
     1           t78**3)
              t458 = -3.712353310021716d+2*t254*t456*t54*t55*t59*t76/t77
     1           **5
              t459 = 1.856176655010858d+2*t120*t253*t254*t260*t54*t55*t5
     1           9*t76
              t460 = -7.424706620043432d+2*t134*t252*t253*t254*t54*t59*t
     1           76
              t461 = -7.886871025654724d+0*t145*t252*t253*t254*t54*t59
              t462 = 1.1541966305589217d+1*t122*t253*t456*t54*t55*t59*t7
     1           6
              t463 = -1.1541966305589217d+1*t120*t122*t257*t260*t54*t55*
     1           t59*t76
              t464 = 4.616786522235687d+1*t122*t134*t252*t257*t54*t59*t7
     1           6
              t465 = 4.904166819946466d-1*t122*t145*t252*t257*t54*t59
              t466 = -2.452083409973233d-1*t121*t122*t145*t260*t54*t59
              t467 = 2.2886111826416838d+0*t120*t121*t122*t295*t54*t59
              t468 = 1.923661050931536d+0*t121*t122*(-4.684972743248224d
     1           +0*t443-3.9871442462415524d+0*t442-3.083875829189267d+0
     2           *t441-7.128507529742789d-1*t440)*t54*t55*t59*t76
              t469 = -2.3083932611178434d+1*t121*t122*t134*t260*t54*t59*
     1           t76
              t470 = 1.1541966305589217d+2*t120*t121*t122*t279*t54*t59*t
     1           76
              t471 = 6.925179783353531d+1*t120*t121*t122*t282*t55*t59*t7
     1           6
              t472 = 8.548627933030694d-3*t442*t61*t68
              t473 = 1/t57**1.6666666666666669d+0
              t474 = 6*t53*t55
              t475 = -6*t266
              t476 = 1/t58**1.6666666666666669d+0
              t477 = -6*t53*t55
              t478 = 6*t266
              t479 = 1.3333333333333333d+0*t131*(t478+t477)-2.9629629629
     1           62963d-1*t130**3*t476+1.3333333333333333d+0*t128*(t475+
     2           t474)-2.962962962962963d-1*t127**3*t473+1.3333333333333
     3           333d+0*t130*t271*t274+1.3333333333333333d+0*t127*t265*t
     4           269
              t480 = -1.923661050931536d+0*t479*t54*t55
              t481 = 2.3083932611178434d+1*t134*t275*t54
              t482 = -2.3083932611178434d+1*t136*t275*t55
              t483 = -1.1541966305589216d+2*t132*t279*t54
              t484 = 1.8467146088942746d+2*t132*t134*t136
              t485 = -6.925179783353531d+1*t132*t282*t55
              t486 = 1/t50**7
              t487 = 2.3083932611178432d+2*t486*t54*t59
              t488 = -4.6167865222356863d+2*t136*t279*t59
              t489 = 2.770071913341412d+2*t134*t282*t59
              t490 = -4.616786522235687d+1*t53*t55*t59
              t491 = -1.4136255552166585d-3*t442*t71*t74
              t492 = 2.0103976536374746d-1*t54*t59*t79/t50**7.3333333333
     1           33333d+0
              t493 = 9.148438760934575d-2*t145*t282*t59*t79
              t494 = 7.176956236343652d+0*t486*t54*t59*t76*t79
              t495 = 8.612347483612381d+0*t134*t282*t59*t76*t79
              t496 = -1.4353912472687305d+0*t53*t55*t59*t76*t79
              t497 = -1.243628d-1*t314*t52*t68
              t498 = 3.9503262643361536d-2*t315*t70*t74
              t499 = -1.1961593727239421d-1*t307*t54*t55*t76*t79
              t500 = 2.0d+0*t112*t113*t114*t314*t52
              t501 = -1.1696447245269295d+0*t116*t117*t118*t315*t70
              t502 = 3.847322101863072d+0*t120*t121*t122*t307*t54*t55*t7
     1           6
              t503 = -2.3083932611178434d+1*t120*t121*t122*t282*t55*t59*
     1           t76
              t504 = 5.495546528376875d-3*t110*t314*t68
              t505 = 1.5389288407452287d+1*t134*t307*t54
              t506 = -1.5389288407452287d+1*t136*t307*t55
              t507 = 1.7777777777777776d+0*t130*t266*t271*t53-1.77777777
     1           77777776d+0*t127*t265*t266*t53+1.3333333333333333d+0*t1
     2           31*(t477+2*t266)-2.962962962962963d-1*t166*t270*t476+1.
     3           3333333333333333d+0*t128*(t474-2*t266)-2.96296296296296
     4           3d-1*t165*t264*t473+4.444444444444444d-1*t166*t271*t274
     5           +4.444444444444444d-1*t165*t265*t269
              t508 = -1.923661050931536d+0*t507*t54*t55
              t509 = 7.694644203726144d+0*t134*t275*t54
              t510 = 7.694644203726144d+0*t136*t275*t55
              t511 = -3.8473221018630716d+1*t167*t279*t54
              t512 = 6.155715362980915d+1*t134*t136*t167
              t513 = -2.3083932611178434d+1*t167*t282*t55
              t514 = -7.694644203726143d+1*t132*t279*t54
              t515 = 4.616786522235687d+1*t132*t282*t55
              t516 = -1.5389288407452287d+2*t136*t279*t59
              t517 = -9.233573044471374d+1*t134*t282*t59
              t518 = 4.616786522235687d+1*t53*t55*t59
              t519 = -9.087592854964233d-4*t110*t315*t74
              t520 = 5.082465978296986d-3*t145*t307*t54*t79
              t521 = 4.7846374908957684d-1*t134*t307*t54*t76*t79
              t522 = -2.870782494537461d+0*t134*t282*t59*t76*t79
              t523 = 1.4353912472687305d+0*t53*t55*t59*t76*t79
              t524 = -8*t131*t53*t55+8*t128*t53*t55+1.7777777777777776d+
     1           0*t166*t266*t271*t53-1.7777777777777776d+0*t165*t265*t2
     2           66*t53-2.962962962962963d-1*t130*t342*t476-2.9629629629
     3           62963d-1*t127*t340*t473+4.444444444444444d-1*t130*t271*
     4           t343+4.444444444444444d-1*t127*t265*t341-2.666666666666
     5           6666d+0*t131*t266+2.6666666666666666d+0*t128*t266
              t525 = -1.923661050931536d+0*t524*t54*t55
              t526 = 1.5389288407452287d+1*t136*t307*t55
              t527 = 7.694644203726144d+0*t134*t344*t54
              t528 = -7.694644203726144d+0*t136*t344*t55
              t529 = -7.694644203726143d+1*t167*t279*t54
              t530 = 4.616786522235687d+1*t167*t282*t55
              t531 = -3.8473221018630716d+1*t132*t279*t54
              t532 = -6.155715362980915d+1*t132*t134*t136
              t533 = -2.3083932611178434d+1*t132*t282*t55
              t534 = 1.5389288407452287d+2*t136*t279*t59
              t535 = 1/rhob**11
              t536 = 1/rhob**8.333333333333334d+0
              t537 = 1/rhob**5.666666666666667d+0
              t538 = t159**3
              t539 = 1/t37**7
              t540 = 1/rhob**3.3333333333333337d+0
              t541 = 1/rhob**3.1666666666666665d+0
              t542 = t162**3
              t543 = 2.0690405167709364d+3*t44*t542/(t41**6*t42**3)-1.92
     1           98375398431045d+2*t330*t44*t542/t41**5+6.0d+0*t161*t332
     2           *t44*t542+1.1102230246251565d-16*t154*t160*t48*(-2.5204
     3           26340996149d+0*t541-2.3079979182303428d+0*t540-1.500803
     4           6906238065d+0*t539-5.620753557770543d-1*t176)+1.0d+0*t1
     5           61*t163*t44*(-4.684972743248224d+0*t541-3.9871442462415
     6           524d+0*t540-3.083875829189267d+0*t539-7.128507529742789
     7           d-1*t176)+9.490883560204437d-19*t47*t540+4.109901889749
     8           9934d-3*t43*t540+5.742741051503565d-14*t48*t538/(t45**6
     9           *t46**3)-1.0712750352598913d-14*t322*t48*t538/t45**5+6.
     :           661338147750939d-16*t154*t324*t48*t538-6.66133814775093
     ;           9d-16*t154*t159*t325*t329*t48+5.356375176299456d-15*t15
     <           9*t322*t324*t329*t48-6.0d+0*t161*t162*t333*t334*t44+9.6
     =           49187699215522d+1*t162*t330*t332*t334*t44-1.27469618870
     >           0087d-1*t157*t161*t163*t334+2.549392377400174d-1*t157*t
     ?           161*t331*t333-4.0999275947472624d+0*t157*t330*t331*t332
     @           -1.4718104502398274d-17*t154*t157*t160*t329+1.699594918
     1           2667827d-1*t161*t162*t163*t327+1.962413933653103d-17*t1
     2           54*t159*t160*t327+2.943620900479655d-17*t154*t157*t323*
     3           t325-2.3669625486718335d-16*t157*t322*t323*t324
              t544 = 1.3333333333333333d+0*t128*(t478+t474)+1.3333333333
     1           333333d+0*t131*(t477+t475)-2.962962962962963d-1*t166**3
     2           *t476-2.962962962962963d-1*t165**3*t473+1.3333333333333
     3           333d+0*t166*t271*t343+1.3333333333333333d+0*t165*t265*t
     4           341
              t545 = -1.923661050931536d+0*t54*t544*t55
              t546 = 2.3083932611178434d+1*t134*t344*t54
              t547 = 2.3083932611178434d+1*t136*t344*t55
              t548 = -1.1541966305589216d+2*t167*t279*t54
              t549 = -1.8467146088942746d+2*t134*t136*t167
              t550 = -6.925179783353531d+1*t167*t282*t55
              t551 = 4.6167865222356863d+2*t136*t279*t59
              t552 = 1/rhob**3
              t553 = gammabb**4
              t554 = 1/t82**4
              t555 = 1/rhob**1.3666666666666666d+1
              t556 = t192-1.25d-1*gammabb*t197*t49
              t557 = 1.25d-1*t164*t87
              t558 = 1.25d-1*t187*t49
              t559 = 1/rhob**1.2666666666666665d+1
              t560 = 2.5d-1*t197*t49
              t561 = 1/rhob**1.1666666666666665d+1
              t562 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhob*t49*t87*t88*t90+1.0d+0*t35*t81+5.0d
     1           -1*rhoa*t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t153*t81+1.0d+0*t148*t35+5.0d-1*t
     1           12*t26+5.0d-1*rhoa*t107*t26+5.0d-1*rhoa*t100*t12)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t88*(5.0d-1*t49*t87*t90+5.0d-1*rhob*t164
     1           *t87*t90+5.0d-1*rhob*t187*t49*t90)+1.25d-1*gammabb*t49*
     2           t87*t88*t89+1.0d+0*t180*t81+1.0d+0*t175*t35)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t88*(5.0d-1*rhob*t197*t49*t90+t192)+1.0
     1           d+0*t191*t81)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t49*t87*t88-5.0d-1*rhob*t198
     1           *t49*t87*t90)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t306*t81+1.0d+0*t301*t35+5.0d
     1           -1*rhoa*t220*t26+1.0d+0*t107*t26+5.0d-1*rhoa*t12*t212+2
     2           .0d+0*t148*t153+1.0d+0*t100*t12+1.0d+0*rhoa*t100*t107)*
     3           wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t321*t81+1.0d+0*t317*t35+1.0d
     1           +0*t148*t180+1.0d+0*t153*t175)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t88*(5.0d-1*rhob*t335*t87*t90+1.0d+0
     1           *t164*t87*t90+5.0d-1*rhob*t374*t49*t90+1.0d+0*t187*t49*
     2           t90+1.0d+0*rhob*t164*t187*t90+1.25d-1*gammabb*t164*t87*
     3           t89+1.25d-1*gammabb*t187*t49*t89+1.25d-1*gammabb*t367*t
     4           49*t87)+(1.25d-1*gammabb*t164*t87+1.25d-1*gammabb*t187*
     5           t49)*t88*t89-1.25d-1*gammabb*t367*t49*t87*t88+1.0d+0*t3
     6           66*t81+1.0d+0*t35*t360+2.0d+0*t175*t180)*wght+Amat2(iq,
     7           D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t378*t81+1.0d+0*t148*t191)*w
     1           ght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t88*(5.0d-1*rhob*t388*t49*t90+5.0d-
     1           1*t197*t49*t90+5.0d-1*rhob*t164*t197*t90-1.25d-1*t49*t8
     2           7*t89-1.25d-1*t164*t87-1.25d-1*t187*t49)+(1.25d-1*gamma
     3           bb*t197*t49+t383)*t88*t89+1.0d+0*t382*t81+1.0d+0*t175*t
     4           191)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t88*(5.0d-1*rhob*t397*t49*t90-2.5d
     1           -1*t197*t49)+1.0d+0*t392*t81)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t198*(-5.0d-1*t49*t87*t90-5.0d-1*rho
     1           b*t164*t87*t90-5.0d-1*rhob*t187*t49*t90)-1.25d-1*gammab
     2           b*t198*t49*t87*t89+(1.0d+0*t49*t87+1.0d+0*rhob*t164*t87
     3           +1.0d+0*rhob*t187*t49)*t88)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*rhob*t197*t49*t88+t198*t398)
     1           *wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t399*t49*t87*t90-2.0d+0*
     1           rhob*t198*t49*t87)*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t35*(2.549392377400174d-1*
     1           t93*t97*t98*t99-3.0d+0*t21*t211*t97*t99+6.0d+0*t208*t21
     2           *t210*t97+2.943620900479655d-17*t91*t93*t95*t96-3.33066
     3           90738754696d-16*t206*t25*t91*t96+6.661338147750939d-16*
     4           t200*t202*t25*t91+t50*(-1.4353912472687305d+1*t136*t279
     5           *t59*t76*t79-5.980796863619711d-2*t479*t54*t55*t76*t79-
     6           2.1530868709030954d+0*t132*t282*t55*t76*t79-7.176956236
     7           343652d-1*t136*t275*t55*t76*t79-3.588478118171826d+0*t1
     8           32*t279*t54*t76*t79+7.176956236343652d-1*t134*t275*t54*
     9           t76*t79+5.741564989074922d+0*t132*t134*t136*t76*t79-2.8
     :           461809478463124d-1*t136*t295*t59*t79-7.11545236961578d-
     ;           2*t132*t295*t54*t79+7.623698967445479d-3*t145*t275*t54*
     <           t79+6.098959173956384d-2*t132*t136*t145*t79+2.308393261
     =           1178434d+1*t121*t122*t136*t260*t55*t59*t76-4.6167865222
     >           35687d+1*t122*t136*t252*t257*t55*t59*t76+7.424706620043
     ?           432d+2*t136*t252*t253*t254*t55*t59*t76-1.84671460889427
     @           46d+2*t120*t121*t122*t134*t136*t59*t76+5.77098315279460
     1           9d+0*t120*t121*t122*t275*t54*t55*t76+5.770983152794609d
     2           +0*t121*t122*t132*t260*t54*t55*t76-1.1541966305589217d+
     3           1*t122*t132*t252*t257*t54*t55*t76+1.856176655010858d+2*
     4           t132*t252*t253*t254*t54*t55*t76+4.616786522235687d+1*t1
     5           20*t121*t122*t132*t136*t55*t76-4.616786522235687d+1*t12
     6           0*t121*t122*t132*t134*t54*t76+1.9751631321680768d-2*(t4
     7           90+t489+t488+t487+t485+t484+t483+t482+t481+t480+1.92366
     8           1050931536d+0*t479)*t70*t74-1.363138928244635d-3*t110*t
     9           288*t74+1.8175185709928465d-3*t141*t238*t74-1.754467086
     :           7903941d+0*t116*t117*t118*t288*t70-1.7544670867903941d+
     ;           0*t117*t118*t141*t250*t70+3.5089341735807883d+0*t118*t1
     <           41*t242*t247*t70-5.19476882440587d+1*t141*t242*t243*t24
     =           4*t70-6.21814d-2*(t490+t489+t488+t487+t485+t484+t483+t4
     >           82+t481+t480)*t52*t68+8.243319792565312d-3*t110*t284*t6
     ?           8-1.099109305675375d-2*t138*t238*t68-1.9616667279785865
     @           d+0*t120*t121*t122*t136*t145*t59-4.904166819946466d-1*t
     1           120*t121*t122*t132*t145*t54+3.0d+0*t112*t113*t114*t284*
     2           t52+3.0d+0*t113*t114*t138*t240*t52-6.0d+0*t114*t138*t22
     3           8*t233*t52+4.824593849607761d+1*t138*t228*t229*t230*t52
     4           +t496+t495+t494+t493+t492+t491+t472+t471+t470+t469+t468
     5           +t467+t466+t465+t464+t463+t462+t461+t460+t459+t458+t457
     6           +t455+t454+t453+t452+t451+t450+t449+t448+t447+t446+t444
     7           +t439+t438+t437+t436+t435+t434+t433+t432+t431+8.0721851
     8           79299687d-2*t110*t116*t117*t118*t141-2.6513779981040353
     9           d-1*t110*t112*t113*t114*t138)+5.741564989074922d+0*t134
     :           *t136*t59*t76*t79-1.794239059085913d-1*t275*t54*t55*t76
     ;           *t79-1.4353912472687305d+0*t132*t136*t55*t76*t79+1.4353
     <           912472687305d+0*t132*t134*t54*t76*t79+6.098959173956384
     =           d-2*t136*t145*t59*t79+1.524739793489096d-2*t132*t145*t5
     >           4*t79+4.616786522235687d+1*t120*t121*t122*t136*t55*t59*
     ?           t76+1.1541966305589217d+1*t120*t121*t122*t132*t54*t55*t
     @           76+5.92548939650423d-2*t288*t70*t74-2.72627785648927d-3
     1           *t110*t141*t74-3.5089341735807883d+0*t116*t117*t118*t14
     2           1*t70-1.865442d-1*t284*t52*t68+1.6486639585130625d-2*t1
     3           10*t138*t68+6.0d+0*t112*t113*t114*t138*t52+t429+t428+t4
     4           27+t426+t425+t424+t423+t422+t421+t420+t419+t418+t417+t4
     5           16+t415+t414+t413+t412-rhoa*t405-5.356375176299456d-15*
     6           t199*t200*t201*t25+1.2202564577405706d-18*t204*t24-9.64
     7           9187699215522d+1*t207*t208*t209*t21+5.284159572535705d-
     8           3*t20*t204)+5.0d-1*rhoa*t26*(2.4d-51*t2*t4*(2.4d-51*t2*
     9           t4*(-3.911111111111111d-50*t4*t410*t9+3.498666666666666
     :           6d-100*t101*t409*t9-9.984000000000001d-151*t213*t408*t9
     ;           +9.216000000000001d-202*t406*t407*t9+2.4d-51*t2*t4*(-3.
     <           911111111111111d-50*t4*t410*t8+3.4986666666666666d-100*
     =           t101*t409*t8-9.984000000000001d-151*t213*t408*t8+9.2160
     >           00000000001d-202*t406*t407*t8)-1.2d-50*t103*t217*t4+3.2
     ?           d-50*t104*t216*t4+2.88d-101*t101*t102*t217-1.7279999999
     @           999998d-100*t101*t104*t215+2.3040000000000002d-151*t104
     1           *t213*t214)-3.911111111111111d-50*t10*t4*t410+3.4986666
     2           666666666d-100*t10*t101*t409-9.984000000000001d-151*t10
     3           *t213*t408+9.216000000000001d-202*t10*t406*t407-1.2d-50
     4           *t103*t218*t4+3.2d-50*t105*t216*t4+2.88d-101*t101*t102*
     5           t218-1.7279999999999998d-100*t101*t105*t215+2.304000000
     6           0000002d-151*t105*t213*t214)-3.911111111111111d-50*t11*
     7           t4*t410+3.4986666666666666d-100*t101*t11*t409-9.9840000
     8           00000001d-151*t11*t213*t408+9.216000000000001d-202*t11*
     9           t406*t407-1.2d-50*t103*t219*t4+3.2d-50*t106*t216*t4+2.8
     :           8d-101*t101*t102*t219-1.7279999999999998d-100*t101*t106
     ;           *t215+2.3040000000000002d-151*t106*t213*t214)+1.0d+0*(3
     <           .1d-3*t29*t31*(3.1d-3*t29*t31*(3.1d-3*t29*t31*(1.641815
     =           111111111d-157*t27*t29*t408*t411-2.0207407407407404d-51
     >           *t27*t31*t410+6.264296296296294d-54*t149*t27*t29*t410-2
     ?           .118471111111111d-105*t27*t29*t302*t409+6.8337777777777
     @           76d-103*t149*t27*t409-5.296177777777777d-155*t27*t302*t
     1           408)+1.641815111111111d-157*t29*t32*t408*t411-2.0207407
     2           407407404d-51*t31*t32*t410+6.264296296296294d-54*t149*t
     3           29*t32*t410-2.118471111111111d-105*t29*t302*t32*t409+6.
     4           833777777777776d-103*t149*t32*t409-5.296177777777777d-1
     5           55*t302*t32*t408-6.2d-52*t103*t303*t31+1.65333333333333
     6           33d-51*t150*t216*t31+1.9219999999999998d-54*t103*t149*t
     7           29*t303+7.944266666666666d-106*t150*t215*t29*t302-5.125
     8           333333333332d-54*t149*t150*t216*t29-2.562666666666667d-
     9           103*t149*t150*t215)+1.641815111111111d-157*t29*t33*t408
     :           *t411-2.0207407407407404d-51*t31*t33*t410+6.26429629629
     ;           6294d-54*t149*t29*t33*t410-2.118471111111111d-105*t29*t
     <           302*t33*t409+6.833777777777776d-103*t149*t33*t409-5.296
     =           177777777777d-155*t302*t33*t408-6.2d-52*t103*t304*t31+1
     >           .6533333333333333d-51*t151*t216*t31+1.9219999999999998d
     ?           -54*t103*t149*t29*t304+7.944266666666666d-106*t151*t215
     @           *t29*t302-5.125333333333332d-54*t149*t151*t216*t29-2.56
     1           2666666666667d-103*t149*t151*t215)+1.641815111111111d-1
     2           57*t29*t34*t408*t411-2.0207407407407404d-51*t31*t34*t41
     3           0+6.264296296296294d-54*t149*t29*t34*t410-2.11847111111
     4           1111d-105*t29*t302*t34*t409+6.833777777777776d-103*t149
     5           *t34*t409-5.296177777777777d-155*t302*t34*t408-6.2d-52*
     6           t103*t305*t31+1.6533333333333333d-51*t152*t216*t31+1.92
     7           19999999999998d-54*t103*t149*t29*t305+7.944266666666666
     8           d-106*t152*t215*t29*t302-5.125333333333332d-54*t149*t15
     9           2*t216*t29-2.562666666666667d-103*t149*t152*t215)*t81+5
     :           .0d-1*rhoa*t12*t405+3.0d+0*t148*t306+3.0d+0*t153*t301+1
     ;           .5d+0*t220*t26+1.5d+0*rhoa*t100*t220+1.5d+0*t12*t212+1.
     <           5d+0*rhoa*t107*t212+3.0d+0*t100*t107)*wght+Amat3(iq,D3_
     =           RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*(3.1d-3*t29*t31*(3.1d-3*t2
     1           9*t31*(3.1d-3*t29*t31*(6.567260444444443d-108*gammabb*t
     2           176*t215*t27*t29*t411-2.824628148148147d-56*gammabb*t17
     3           6*t216*t27*t29*t302-2.118471111111111d-105*gammabb*t176
     4           *t215*t27*t302+9.111703703703702d-54*gammabb*t149*t176*
     5           t216*t27)+6.567260444444443d-108*gammabb*t176*t215*t29*
     6           t32*t411-2.824628148148147d-56*gammabb*t176*t216*t29*t3
     7           02*t32-2.118471111111111d-105*gammabb*t176*t215*t302*t3
     8           2+9.111703703703702d-54*gammabb*t149*t176*t216*t32-4.13
     9           33333333333333d-52*t103*t31*t318+1.2813333333333332d-54
     :           *t103*t149*t29*t318-8.266666666666665d-3*gammabb*t176*t
     ;           303*t31+5.51111111111111d-52*t177*t216*t31+2.5626666666
     <           66666d-5*gammabb*t149*t176*t29*t303+2.6480888888888887d
     =           -106*t177*t215*t29*t302+2.1184711111111104d-56*gammabb*
     >           t103*t150*t176*t29*t302-1.708444444444444d-54*t149*t177
     ?           *t216*t29-8.542222222222222d-104*t149*t177*t215-6.83377
     @           7777777776d-54*gammabb*t103*t149*t150*t176)+6.567260444
     1           444443d-108*gammabb*t176*t215*t29*t33*t411-2.8246281481
     2           48147d-56*gammabb*t176*t216*t29*t302*t33-2.118471111111
     3           111d-105*gammabb*t176*t215*t302*t33+9.111703703703702d-
     4           54*gammabb*t149*t176*t216*t33-4.1333333333333333d-52*t1
     5           03*t31*t319+1.2813333333333332d-54*t103*t149*t29*t319-8
     6           .266666666666665d-3*gammabb*t176*t304*t31+5.51111111111
     7           111d-52*t178*t216*t31+2.562666666666666d-5*gammabb*t149
     8           *t176*t29*t304+2.6480888888888887d-106*t178*t215*t29*t3
     9           02+2.1184711111111104d-56*gammabb*t103*t151*t176*t29*t3
     :           02-1.708444444444444d-54*t149*t178*t216*t29-8.542222222
     ;           222222d-104*t149*t178*t215-6.833777777777776d-54*gammab
     <           b*t103*t149*t151*t176)+6.567260444444443d-108*gammabb*t
     =           176*t215*t29*t34*t411-2.824628148148147d-56*gammabb*t17
     >           6*t216*t29*t302*t34-2.118471111111111d-105*gammabb*t176
     ?           *t215*t302*t34+9.111703703703702d-54*gammabb*t149*t176*
     @           t216*t34-4.1333333333333333d-52*t103*t31*t320+1.2813333
     1           333333332d-54*t103*t149*t29*t320-8.266666666666665d-3*g
     2           ammabb*t176*t305*t31+5.51111111111111d-52*t179*t216*t31
     3           +2.562666666666666d-5*gammabb*t149*t176*t29*t305+2.6480
     4           888888888887d-106*t179*t215*t29*t302+2.1184711111111104
     5           d-56*gammabb*t103*t152*t176*t29*t302-1.708444444444444d
     6           -54*t149*t179*t216*t29-8.542222222222222d-104*t149*t179
     7           *t215-6.833777777777776d-54*gammabb*t103*t149*t152*t176
     8           )*t81+1.0d+0*t35*(t50*(-4.7846374908957684d+0*t136*t279
     9           *t59*t76*t79-5.980796863619711d-2*t507*t54*t55*t76*t79-
     :           4.7846374908957684d-1*t136*t307*t55*t76*t79-7.176956236
     ;           343652d-1*t167*t282*t55*t76*t79+1.4353912472687305d+0*t
     <           132*t282*t55*t76*t79+2.3923187454478842d-1*t136*t275*t5
     =           5*t76*t79-1.1961593727239421d+0*t167*t279*t54*t76*t79-2
     >           .3923187454478842d+0*t132*t279*t54*t76*t79+2.3923187454
     ?           478842d-1*t134*t275*t54*t76*t79+1.9138549963583074d+0*t
     @           134*t136*t167*t76*t79-9.487269826154375d-2*t136*t295*t5
     1           9*t79-3.049479586978192d-2*t145*t282*t59*t79-2.37181745
     2           65385935d-2*t167*t295*t54*t79-4.743634913077187d-2*t132
     3           *t295*t54*t79+2.541232989148493d-3*t145*t275*t54*t79+2.
     4           0329863913187946d-2*t136*t145*t167*t79+7.69464420372614
     5           4d+0*t121*t122*t136*t260*t55*t59*t76-1.538928840745229d
     6           +1*t122*t136*t252*t257*t55*t59*t76+2.4749022066811444d+
     7           2*t136*t252*t253*t254*t55*t59*t76-6.155715362980916d+1*
     8           t120*t121*t122*t134*t136*t59*t76+1.923661050931536d+0*t
     9           120*t121*t122*t275*t54*t55*t76+1.923661050931536d+0*t12
     :           1*t122*t167*t260*t54*t55*t76+3.847322101863072d+0*t121*
     ;           t122*t132*t260*t54*t55*t76-3.847322101863072d+0*t122*t1
     <           67*t252*t257*t54*t55*t76-7.694644203726144d+0*t122*t132
     =           *t252*t257*t54*t55*t76+6.187255516702861d+1*t167*t252*t
     >           253*t254*t54*t55*t76+1.2374511033405722d+2*t132*t252*t2
     ?           53*t254*t54*t55*t76+1.538928840745229d+1*t120*t121*t122
     @           *t136*t167*t55*t76-1.538928840745229d+1*t120*t121*t122*
     1           t134*t167*t54*t76-3.077857681490458d+1*t120*t121*t122*t
     2           132*t134*t54*t76+1.9751631321680768d-2*(t518+t517+t516+
     3           t515+t514+t513+t512+t511+t510+t509+t508+1.9236610509315
     4           36d+0*t507+t506+t505+t487)*t70*t74-4.5437964274821163d-
     5           4*t110*t288*t74+6.058395236642822d-4*t172*t238*t74+1.21
     6           16790473285642d-3*t141*t238*t74-5.848223622634647d-1*t1
     7           16*t117*t118*t288*t70-5.848223622634647d-1*t117*t118*t1
     8           72*t250*t70-1.1696447245269295d+0*t117*t118*t141*t250*t
     9           70+1.1696447245269295d+0*t118*t172*t242*t247*t70+2.3392
     :           89449053859d+0*t118*t141*t242*t247*t70-1.73158960813529
     ;           d+1*t172*t242*t243*t244*t70-3.46317921627058d+1*t141*t2
     <           42*t243*t244*t70-6.21814d-2*(t518+t517+t516+t515+t514+t
     =           513+t512+t511+t510+t509+t508+t506+t505+t487)*t52*t68+2.
     >           747773264188437d-3*t110*t284*t68-3.663697685584583d-3*t
     ?           170*t238*t68-7.327395371169166d-3*t138*t238*t68-6.53888
     @           9093261956d-1*t120*t121*t122*t136*t145*t59-1.6347222733
     1           154887d-1*t120*t121*t122*t145*t167*t54-3.26944454663097
     2           74d-1*t120*t121*t122*t132*t145*t54+t523+t522+t521+t520+
     3           1.0d+0*t112*t113*t114*t284*t52+1.0d+0*t113*t114*t170*t2
     4           40*t52+2.0d+0*t113*t114*t138*t240*t52-2.0d+0*t114*t170*
     5           t228*t233*t52-4.0d+0*t114*t138*t228*t233*t52+1.60819794
     6           98692536d+1*t170*t228*t229*t230*t52+3.216395899738507d+
     7           1*t138*t228*t229*t230*t52+t519+t504+t503+t502+t501+t500
     8           +t494+t492+t491+t472+t470+t469+t468+t467+t466+t465+t464
     9           +t463+t462+t461+t460+t459+t458+t457+t455+t454+t453+t452
     :           +t451+t450+t449+t448+t447+t446+t444+t439+t438+t437+t436
     ;           +t435+t434+t433+t432+t431+2.690728393099896d-2*t110*t11
     <           6*t117*t118*t172-8.837926660346784d-2*t110*t112*t113*t1
     =           14*t170+5.381456786199792d-2*t110*t116*t117*t118*t141-1
     >           .767585332069357d-1*t110*t112*t113*t114*t138)-4.7846374
     ?           908957684d-1*t136*t167*t55*t76*t79+9.569274981791537d-1
     @           *t132*t134*t54*t76*t79+1.0164931956593973d-2*t132*t145*
     1           t54*t79+7.694644203726144d+0*t120*t121*t122*t132*t54*t5
     2           5*t76-1.8175185709928465d-3*t110*t141*t74-2.33928944905
     3           3859d+0*t116*t117*t118*t141*t70+1.099109305675375d-2*t1
     4           10*t138*t68+4.0d+0*t112*t113*t114*t138*t52+t499+t498+t4
     5           97+t428+t427+t426+t425+t424+t423+t422+t421+t420+t419+t4
     6           18+t417+t416+t415+t414+t413+t412+t357+t356+t354+t351+t3
     7           38+t337+t336+t316+t299+t297+t292+t289+t285+t263)+2.0d+0
     8           *t148*t321+2.0d+0*t153*t317+1.0d+0*t175*t306+1.0d+0*t18
     9           0*t301)*wght+Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*(3.1d-3*t29*t31*(3.1d-3*t2
     1           9*t31*(3.1d-3*t29*t31*(2.6269041777777763d-58*t103*t181
     2           *t27*t29*t361*t411-3.883863703703702d-56*gammabb*t103*t
     3           27*t29*t302*t362+1.2528592592592588d-53*gammabb*t103*t1
     4           49*t27*t362-8.473884444444441d-56*t103*t181*t27*t302*t3
     5           61)+2.6269041777777763d-58*t103*t181*t29*t32*t361*t411-
     6           2.0666666666666667d-52*t103*t31*t363+6.406666666666666d
     7           -55*t103*t149*t29*t363-3.883863703703702d-56*gammabb*t1
     8           03*t29*t302*t32*t362+1.2528592592592588d-53*gammabb*t10
     9           3*t149*t32*t362+3.0311111111111105d-2*gammabb*t150*t31*
     :           t362-9.396444444444442d-5*gammabb*t149*t150*t29*t362-8.
     ;           473884444444441d-56*t103*t181*t302*t32*t361+4.236942222
     <           2222203d-7*t150*t181*t29*t302*t361-1.366755555555555d-4
     =           *t149*t150*t181*t361-1.653333333333333d-2*gammabb*t176*
     >           t31*t318+5.125333333333332d-5*gammabb*t149*t176*t29*t31
     ?           8+2.1184711111111104d-56*gammabb*t103*t176*t177*t29*t30
     @           2-6.833777777777776d-54*gammabb*t103*t149*t176*t177)+2.
     1           6269041777777763d-58*t103*t181*t29*t33*t361*t411-2.0666
     2           666666666667d-52*t103*t31*t364+6.406666666666666d-55*t1
     3           03*t149*t29*t364-3.883863703703702d-56*gammabb*t103*t29
     4           *t302*t33*t362+1.2528592592592588d-53*gammabb*t103*t149
     5           *t33*t362+3.0311111111111105d-2*gammabb*t151*t31*t362-9
     6           .396444444444442d-5*gammabb*t149*t151*t29*t362-8.473884
     7           444444441d-56*t103*t181*t302*t33*t361+4.236942222222220
     8           3d-7*t151*t181*t29*t302*t361-1.366755555555555d-4*t149*
     9           t151*t181*t361-1.653333333333333d-2*gammabb*t176*t31*t3
     :           19+5.125333333333332d-5*gammabb*t149*t176*t29*t319+2.11
     ;           84711111111104d-56*gammabb*t103*t176*t178*t29*t302-6.83
     <           3777777777776d-54*gammabb*t103*t149*t176*t178)+2.626904
     =           1777777763d-58*t103*t181*t29*t34*t361*t411-2.0666666666
     >           666667d-52*t103*t31*t365+6.406666666666666d-55*t103*t14
     ?           9*t29*t365-3.883863703703702d-56*gammabb*t103*t29*t302*
     @           t34*t362+1.2528592592592588d-53*gammabb*t103*t149*t34*t
     1           362+3.0311111111111105d-2*gammabb*t152*t31*t362-9.39644
     2           4444444442d-5*gammabb*t149*t152*t29*t362-8.473884444444
     3           441d-56*t103*t181*t302*t34*t361+4.2369422222222203d-7*t
     4           152*t181*t29*t302*t361-1.366755555555555d-4*t149*t152*t
     5           181*t361-1.653333333333333d-2*gammabb*t176*t31*t320+5.1
     6           25333333333332d-5*gammabb*t149*t176*t29*t320+2.11847111
     7           11111104d-56*gammabb*t103*t176*t179*t29*t302-6.83377777
     8           7777776d-54*gammabb*t103*t149*t176*t179)*t81+1.0d+0*t35
     9           *(t50*(4.7846374908957684d+0*t136*t279*t59*t76*t79-5.98
     :           0796863619711d-2*t524*t54*t55*t76*t79-2.392318745447884
     ;           2d-1*t136*t344*t55*t76*t79+4.7846374908957684d-1*t136*t
     <           307*t55*t76*t79+1.4353912472687305d+0*t167*t282*t55*t76
     =           *t79-7.176956236343652d-1*t132*t282*t55*t76*t79+2.39231
     >           87454478842d-1*t134*t344*t54*t76*t79-2.3923187454478842
     ?           d+0*t167*t279*t54*t76*t79-1.1961593727239421d+0*t132*t2
     @           79*t54*t76*t79-1.9138549963583074d+0*t132*t134*t136*t76
     1           *t79+9.487269826154374d-2*t136*t295*t59*t79-3.049479586
     2           9781915d-2*t145*t282*t59*t79+2.541232989148493d-3*t145*
     3           t344*t54*t79-4.743634913077187d-2*t167*t295*t54*t79-2.3
     4           718174565385935d-2*t132*t295*t54*t79-2.0329863913187946
     5           d-2*t132*t136*t145*t79-7.694644203726144d+0*t121*t122*t
     6           136*t260*t55*t59*t76+1.538928840745229d+1*t122*t136*t25
     7           2*t257*t55*t59*t76-2.4749022066811444d+2*t136*t252*t253
     8           *t254*t55*t59*t76+6.155715362980916d+1*t120*t121*t122*t
     9           134*t136*t59*t76+1.923661050931536d+0*t120*t121*t122*t3
     :           44*t54*t55*t76+3.847322101863072d+0*t121*t122*t167*t260
     ;           *t54*t55*t76+1.923661050931536d+0*t121*t122*t132*t260*t
     <           54*t55*t76-7.694644203726144d+0*t122*t167*t252*t257*t54
     =           *t55*t76-3.847322101863072d+0*t122*t132*t252*t257*t54*t
     >           55*t76+1.2374511033405722d+2*t167*t252*t253*t254*t54*t5
     ?           5*t76+6.187255516702861d+1*t132*t252*t253*t254*t54*t55*
     @           t76-1.538928840745229d+1*t120*t121*t122*t132*t136*t55*t
     1           76-3.077857681490458d+1*t120*t121*t122*t134*t167*t54*t7
     2           6-1.538928840745229d+1*t120*t121*t122*t132*t134*t54*t76
     3           +1.9751631321680768d-2*(t534+t533+t532+t531+t530+t529+t
     4           528+t527+t526+t525+1.923661050931536d+0*t524+t517+t505+
     5           t490+t487)*t70*t74-4.5437964274821163d-4*t110*t352*t74+
     6           1.2116790473285642d-3*t172*t238*t74+6.058395236642822d-
     7           4*t141*t238*t74-5.848223622634647d-1*t116*t117*t118*t35
     8           2*t70-1.1696447245269295d+0*t117*t118*t172*t250*t70-5.8
     9           48223622634647d-1*t117*t118*t141*t250*t70+2.33928944905
     :           3859d+0*t118*t172*t242*t247*t70+1.1696447245269295d+0*t
     ;           118*t141*t242*t247*t70-3.46317921627058d+1*t172*t242*t2
     <           43*t244*t70-1.73158960813529d+1*t141*t242*t243*t244*t70
     =           -6.21814d-2*t52*(t534+t533+t532+t531+t530+t529+t528+t52
     >           7+t526+t525+t517+t505+t490+t487)*t68+2.747773264188437d
     ?           -3*t110*t349*t68-7.327395371169166d-3*t170*t238*t68-3.6
     @           63697685584583d-3*t138*t238*t68+6.538889093261955d-1*t1
     1           20*t121*t122*t136*t145*t59-3.2694445466309774d-1*t120*t
     2           121*t122*t145*t167*t54-1.6347222733154887d-1*t120*t121*
     3           t122*t132*t145*t54+t522+t521+t520+1.0d+0*t112*t113*t114
     4           *t349*t52+2.0d+0*t113*t114*t170*t240*t52+1.0d+0*t113*t1
     5           14*t138*t240*t52-4.0d+0*t114*t170*t228*t233*t52-2.0d+0*
     6           t114*t138*t228*t233*t52+3.216395899738507d+1*t170*t228*
     7           t229*t230*t52+1.6081979498692536d+1*t138*t228*t229*t230
     8           *t52+t519+t504+t503+t502+t501+t500+t496+t494+t492+t491+
     9           t472+t470+t469+t468+t467+t466+t465+t464+t463+t462+t461+
     :           t460+t459+t458+t457+t455+t454+t453+t452+t451+t450+t449+
     ;           t448+t447+t446+t444+t439+t438+t437+t436+t435+t434+t433+
     <           t432+t431+5.381456786199792d-2*t110*t116*t117*t118*t172
     =           -1.767585332069357d-1*t110*t112*t113*t114*t170+2.690728
     >           393099896d-2*t110*t116*t117*t118*t141-8.837926660346784
     ?           d-2*t110*t112*t113*t114*t138)+4.7846374908957684d-1*t13
     @           2*t136*t55*t76*t79+9.569274981791537d-1*t134*t167*t54*t
     1           76*t79+1.0164931956593973d-2*t145*t167*t54*t79+7.694644
     2           203726144d+0*t120*t121*t122*t167*t54*t55*t76-1.81751857
     3           09928465d-3*t110*t172*t74-2.339289449053859d+0*t116*t11
     4           7*t118*t172*t70+1.099109305675375d-2*t110*t170*t68+4.0d
     5           +0*t112*t113*t114*t170*t52+t499+t498+t497+t428+t427+t42
     6           6+t425+t424+t423+t422+t421+t420+t419+t418+t417+t416+t41
     7           5+t414+t413+t412+t359+t358+t355+t353+t350+t339+t316+t29
     8           4+t293+t290+t286+t256+t246+t232)+1.0d+0*t148*t366+1.0d+
     9           0*t153*t360+2.0d+0*t175*t321+2.0d+0*t180*t317)*wght+Ama
     :           t3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t88*(5.0d-1*rhob*t543*t87*t90+1.5
     1           d+0*t335*t87*t90+5.0d-1*rhob*t49*(-2.737777777777778d+0
     2           *gammabb*t537*t83*t86+1.4745599999999992d-3*t553*t554*t
     3           555*t86+7.274666666666665d-1*t181*t182*t536*t86-5.83679
     4           9999999998d-2*t368*t369*t535*t86+6.0d-2*gammabb*t28*t83
     5           *(-2.737777777777778d+0*gammabb*t537*t83*t85+1.47455999
     6           99999992d-3*t553*t554*t555*t85+7.274666666666665d-1*t18
     7           1*t182*t536*t85-5.836799999999998d-2*t368*t369*t535*t85
     8           +6.0d-2*gammabb*t28*t83*(-2.737777777777778d+0*gammabb*
     9           t537*t83*t84+1.4745599999999992d-3*t553*t554*t555*t84+7
     :           .274666666666665d-1*t181*t182*t536*t84-5.83679999999999
     ;           8d-2*t368*t369*t535*t84+6.0d-2*gammabb*t28*t83*(-2.7377
     <           77777777778d+0*gammabb*t537*t8*t83+1.4745599999999992d-
     =           3*t553*t554*t555*t8+7.274666666666665d-1*t181*t182*t536
     >           *t8-5.836799999999998d-2*t368*t369*t535*t8)-4.799999999
     ?           999999d-1*gammabb*t176*t371*t83+1.76d+0*gammabb*t184*t3
     @           62*t83+2.879999999999999d-2*t181*t182*t183*t371+9.21599
     1           9999999996d-3*t184*t368*t369*t370-2.5919999999999993d-1
     2           *t181*t182*t184*t361)-4.799999999999999d-1*gammabb*t176
     3           *t372*t83+1.76d+0*gammabb*t185*t362*t83+2.8799999999999
     4           99d-2*t181*t182*t183*t372+9.215999999999996d-3*t185*t36
     5           8*t369*t370-2.5919999999999993d-1*t181*t182*t185*t361)-
     6           4.799999999999999d-1*gammabb*t176*t373*t83+1.76d+0*gamm
     7           abb*t186*t362*t83+2.879999999999999d-2*t181*t182*t183*t
     8           373+9.215999999999996d-3*t186*t368*t369*t370-2.59199999
     9           99999993d-1*t181*t182*t186*t361)*t90+1.5d+0*t374*t49*t9
     :           0+1.5d+0*rhob*t164*t374*t90+1.5d+0*rhob*t187*t335*t90+3
     ;           .0d+0*t164*t187*t90+2.5d-1*gammabb*t335*t87*t89+2.5d-1*
     <           gammabb*t374*t49*t89+5.0d-1*gammabb*t164*t187*t89-2.5d-
     =           1*gammabb*t49*t552*t87+2.5d-1*gammabb*t164*t367*t87+2.5
     >           d-1*gammabb*t187*t367*t49)+(1.25d-1*gammabb*t335*t87+1.
     ?           25d-1*gammabb*t374*t49+2.5d-1*gammabb*t164*t187)*t88*t8
     @           9+t367*(-2.5d-1*gammabb*t164*t87-2.5d-1*gammabb*t187*t4
     1           9)*t88+2.5d-1*gammabb*t49*t552*t87*t88+1.0d+0*(3.1d-3*t
     2           29*t31*(3.1d-3*t29*t31*(3.1d-3*t29*t31*(-1.414518518518
     3           5183d-1*gammabb*t27*t31*t537+4.3850074074074064d-4*gamm
     4           abb*t149*t27*t29*t537-4.6606364444444426d-6*t181*t27*t2
     5           9*t302*t536+1.5034311111111107d-3*t149*t181*t27*t536+1.
     6           0507616711111105d-8*t27*t29*t368*t411*t535-3.3895537777
     7           77776d-6*t27*t302*t368*t535)-1.4145185185185183d-1*gamm
     8           abb*t31*t32*t537+4.3850074074074064d-4*gammabb*t149*t29
     9           *t32*t537-4.6606364444444426d-6*t181*t29*t302*t32*t536+
     :           1.5034311111111107d-3*t149*t181*t32*t536+1.050761671111
     ;           1105d-8*t29*t32*t368*t411*t535-3.389553777777776d-6*t30
     <           2*t32*t368*t535-2.4799999999999994d-2*gammabb*t176*t31*
     =           t363+7.687999999999998d-5*gammabb*t149*t176*t29*t363+9.
     >           093333333333331d-2*gammabb*t177*t31*t362-2.818933333333
     ?           332d-4*gammabb*t149*t177*t29*t362+1.271082666666666d-6*
     @           t177*t181*t29*t302*t361-4.100266666666665d-4*t149*t177*
     1           t181*t361)-1.4145185185185183d-1*gammabb*t31*t33*t537+4
     2           .3850074074074064d-4*gammabb*t149*t29*t33*t537-4.660636
     3           4444444426d-6*t181*t29*t302*t33*t536+1.5034311111111107
     4           d-3*t149*t181*t33*t536+1.0507616711111105d-8*t29*t33*t3
     5           68*t411*t535-3.389553777777776d-6*t302*t33*t368*t535-2.
     6           4799999999999994d-2*gammabb*t176*t31*t364+7.68799999999
     7           9998d-5*gammabb*t149*t176*t29*t364+9.093333333333331d-2
     8           *gammabb*t178*t31*t362-2.818933333333332d-4*gammabb*t14
     9           9*t178*t29*t362+1.271082666666666d-6*t178*t181*t29*t302
     :           *t361-4.100266666666665d-4*t149*t178*t181*t361)-1.41451
     ;           85185185183d-1*gammabb*t31*t34*t537+4.3850074074074064d
     <           -4*gammabb*t149*t29*t34*t537-4.6606364444444426d-6*t181
     =           *t29*t302*t34*t536+1.5034311111111107d-3*t149*t181*t34*
     >           t536+1.0507616711111105d-8*t29*t34*t368*t411*t535-3.389
     ?           553777777776d-6*t302*t34*t368*t535-2.4799999999999994d-
     @           2*gammabb*t176*t31*t365+7.687999999999998d-5*gammabb*t1
     1           49*t176*t29*t365+9.093333333333331d-2*gammabb*t179*t31*
     2           t362-2.818933333333332d-4*gammabb*t149*t179*t29*t362+1.
     3           271082666666666d-6*t179*t181*t29*t302*t361-4.1002666666
     4           66665d-4*t149*t179*t181*t361)*t81+1.0d+0*t35*(t50*(1.43
     5           53912472687305d+1*t136*t279*t59*t76*t79-5.9807968636197
     6           11d-2*t54*t544*t55*t76*t79+7.176956236343652d-1*t136*t3
     7           44*t55*t76*t79-2.1530868709030954d+0*t167*t282*t55*t76*
     8           t79+7.176956236343652d-1*t134*t344*t54*t76*t79-3.588478
     9           118171826d+0*t167*t279*t54*t76*t79-5.741564989074922d+0
     :           *t134*t136*t167*t76*t79+2.8461809478463124d-1*t136*t295
     ;           *t59*t79+7.623698967445479d-3*t145*t344*t54*t79-7.11545
     <           236961578d-2*t167*t295*t54*t79-6.098959173956384d-2*t13
     =           6*t145*t167*t79-2.3083932611178434d+1*t121*t122*t136*t2
     >           60*t55*t59*t76+4.616786522235687d+1*t122*t136*t252*t257
     ?           *t55*t59*t76-7.424706620043432d+2*t136*t252*t253*t254*t
     @           55*t59*t76+1.8467146088942746d+2*t120*t121*t122*t134*t1
     1           36*t59*t76+5.770983152794609d+0*t120*t121*t122*t344*t54
     2           *t55*t76+5.770983152794609d+0*t121*t122*t167*t260*t54*t
     3           55*t76-1.1541966305589217d+1*t122*t167*t252*t257*t54*t5
     4           5*t76+1.856176655010858d+2*t167*t252*t253*t254*t54*t55*
     5           t76-4.616786522235687d+1*t120*t121*t122*t136*t167*t55*t
     6           76-4.616786522235687d+1*t120*t121*t122*t134*t167*t54*t7
     7           6+1.9751631321680768d-2*(t551+t550+t549+t548+t547+t546+
     8           t545+1.923661050931536d+0*t544+t518+t489+t487)*t70*t74-
     9           1.363138928244635d-3*t110*t352*t74+1.8175185709928465d-
     :           3*t172*t238*t74-1.7544670867903941d+0*t116*t117*t118*t3
     ;           52*t70-1.7544670867903941d+0*t117*t118*t172*t250*t70+3.
     <           5089341735807883d+0*t118*t172*t242*t247*t70-5.194768824
     =           40587d+1*t172*t242*t243*t244*t70-6.21814d-2*t52*(t551+t
     >           550+t549+t548+t547+t546+t545+t518+t489+t487)*t68+8.2433
     ?           19792565312d-3*t110*t349*t68-1.099109305675375d-2*t170*
     @           t238*t68+1.9616667279785865d+0*t120*t121*t122*t136*t145
     1           *t59-4.904166819946466d-1*t120*t121*t122*t145*t167*t54+
     2           t523+3.0d+0*t112*t113*t114*t349*t52+3.0d+0*t113*t114*t1
     3           70*t240*t52-6.0d+0*t114*t170*t228*t233*t52+4.8245938496
     4           07761d+1*t170*t228*t229*t230*t52+t495+t494+t493+t492+t4
     5           91+t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t4
     6           62+t461+t460+t459+t458+t457+t455+t454+t453+t452+t451+t4
     7           50+t449+t448+t447+t446+t444+t439+t438+t437+t436+t435+t4
     8           34+t433+t432+t431+8.072185179299687d-2*t110*t116*t117*t
     9           118*t172-2.6513779981040353d-1*t110*t112*t113*t114*t170
     :           )-5.741564989074922d+0*t134*t136*t59*t76*t79-1.79423905
     ;           9085913d-1*t344*t54*t55*t76*t79+1.4353912472687305d+0*t
     <           136*t167*t55*t76*t79+1.4353912472687305d+0*t134*t167*t5
     =           4*t76*t79-6.098959173956384d-2*t136*t145*t59*t79+1.5247
     >           39793489096d-2*t145*t167*t54*t79-4.616786522235687d+1*t
     ?           120*t121*t122*t136*t55*t59*t76+1.1541966305589217d+1*t1
     @           20*t121*t122*t167*t54*t55*t76+5.92548939650423d-2*t352*
     1           t70*t74-2.72627785648927d-3*t110*t172*t74-3.50893417358
     2           07883d+0*t116*t117*t118*t172*t70-1.865442d-1*t349*t52*t
     3           68+1.6486639585130625d-2*t110*t170*t68-rhob*t543+6.0d+0
     4           *t112*t113*t114*t170*t52-3.3306690738754696d-16*t154*t1
     5           60*t329*t48+6.661338147750939d-16*t154*t323*t325*t48-5.
     6           356375176299456d-15*t322*t323*t324*t48+1.22025645774057
     7           06d-18*t327*t47-3.0d+0*t161*t163*t334*t44+6.0d+0*t161*t
     8           331*t333*t44-9.649187699215522d+1*t330*t331*t332*t44+5.
     9           284159572535705d-3*t327*t43+t429+t428+t427+t426+t425+t4
     :           24+t423+t422+t421+t420+t419+t418+t417+t416+t415+t414+t4
     ;           13+t412+2.549392377400174d-1*t157*t161*t162*t163+2.9436
     <           20900479655d-17*t154*t157*t159*t160)+3.0d+0*t175*t366+3
     =           .0d+0*t180*t360)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*(3.1d-3*t29*t31*(3.1d-3*t
     1           29*t31*(3.1d-3*t29*t31*(-2.4627226666666663d-108*t215*t
     2           27*t28*t29*t411+1.0592355555555552d-56*t216*t27*t28*t29
     3           *t302+7.944266666666666d-106*t215*t27*t28*t302-3.416888
     4           888888888d-54*t149*t216*t27*t28)-2.4627226666666663d-10
     5           8*t215*t28*t29*t32*t411-4.1333333333333333d-52*t103*t31
     6           *t375+1.2813333333333332d-54*t103*t149*t29*t375+1.05923
     7           55555555552d-56*t216*t28*t29*t302*t32+7.944266666666666
     8           d-106*t215*t28*t302*t32-3.416888888888888d-54*t149*t216
     9           *t28*t32+3.1d-3*t28*t303*t31+5.51111111111111d-52*t188*
     :           t216*t31-9.61d-6*t149*t28*t29*t303-7.944266666666666d-5
     ;           7*t103*t150*t28*t29*t302+2.6480888888888887d-106*t188*t
     <           215*t29*t302-1.708444444444444d-54*t149*t188*t216*t29+2
     =           .5626666666666664d-54*t103*t149*t150*t28-8.542222222222
     >           222d-104*t149*t188*t215)-2.4627226666666663d-108*t215*t
     ?           28*t29*t33*t411-4.1333333333333333d-52*t103*t31*t376+1.
     @           2813333333333332d-54*t103*t149*t29*t376+1.0592355555555
     1           552d-56*t216*t28*t29*t302*t33+7.944266666666666d-106*t2
     2           15*t28*t302*t33-3.416888888888888d-54*t149*t216*t28*t33
     3           +3.1d-3*t28*t304*t31+5.51111111111111d-52*t189*t216*t31
     4           -9.61d-6*t149*t28*t29*t304-7.944266666666666d-57*t103*t
     5           151*t28*t29*t302+2.6480888888888887d-106*t189*t215*t29*
     6           t302-1.708444444444444d-54*t149*t189*t216*t29+2.5626666
     7           666666664d-54*t103*t149*t151*t28-8.542222222222222d-104
     8           *t149*t189*t215)-2.4627226666666663d-108*t215*t28*t29*t
     9           34*t411-4.1333333333333333d-52*t103*t31*t377+1.28133333
     :           33333332d-54*t103*t149*t29*t377+1.0592355555555552d-56*
     ;           t216*t28*t29*t302*t34+7.944266666666666d-106*t215*t28*t
     <           302*t34-3.416888888888888d-54*t149*t216*t28*t34+3.1d-3*
     =           t28*t305*t31+5.51111111111111d-52*t190*t216*t31-9.61d-6
     >           *t149*t28*t29*t305-7.944266666666666d-57*t103*t152*t28*
     ?           t29*t302+2.6480888888888887d-106*t190*t215*t29*t302-1.7
     @           08444444444444d-54*t149*t190*t216*t29+2.562666666666666
     1           4d-54*t103*t149*t152*t28-8.542222222222222d-104*t149*t1
     2           90*t215)*t81+2.0d+0*t148*t378+1.0d+0*t191*t301)*wght+Cm
     3           at3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (1.0d+0*(3.1d-3*t29*t31*(3.1d-3*t
     1           29*t31*(3.1d-3*t29*t31*(-9.850890666666663d-59*gammabb*
     2           t103*t183*t27*t29*t411+1.0592355555555552d-56*t103*t176
     3           *t27*t29*t302+3.177706666666666d-56*gammabb*t103*t183*t
     4           27*t302-3.416888888888888d-54*t103*t149*t176*t27)-9.850
     5           890666666663d-59*gammabb*t103*t183*t29*t32*t411-2.06666
     6           66666666667d-52*t103*t31*t379+6.406666666666666d-55*t10
     7           3*t149*t29*t379-8.266666666666665d-3*gammabb*t176*t31*t
     8           375+2.562666666666666d-5*gammabb*t149*t176*t29*t375+1.0
     9           592355555555552d-56*t103*t176*t29*t302*t32+3.1777066666
     :           66666d-56*gammabb*t103*t183*t302*t32-3.416888888888888d
     ;           -54*t103*t149*t176*t32+3.1d-3*t28*t31*t318-9.61d-6*t149
     <           *t28*t29*t318-8.266666666666665d-3*t150*t176*t31-3.9721
     =           33333333333d-57*t103*t177*t28*t29*t302+1.05923555555555
     >           52d-56*gammabb*t103*t176*t188*t29*t302-1.58885333333333
     ?           27d-7*gammabb*t150*t183*t29*t302+2.562666666666666d-5*t
     @           149*t150*t176*t29+1.2813333333333332d-54*t103*t149*t177
     1           *t28-3.416888888888888d-54*gammabb*t103*t149*t176*t188+
     2           5.125333333333332d-5*gammabb*t149*t150*t183)-9.85089066
     3           6666663d-59*gammabb*t103*t183*t29*t33*t411-2.0666666666
     4           666667d-52*t103*t31*t380+6.406666666666666d-55*t103*t14
     5           9*t29*t380-8.266666666666665d-3*gammabb*t176*t31*t376+2
     6           .562666666666666d-5*gammabb*t149*t176*t29*t376+1.059235
     7           5555555552d-56*t103*t176*t29*t302*t33+3.177706666666666
     8           d-56*gammabb*t103*t183*t302*t33-3.416888888888888d-54*t
     9           103*t149*t176*t33+3.1d-3*t28*t31*t319-9.61d-6*t149*t28*
     :           t29*t319-8.266666666666665d-3*t151*t176*t31-3.972133333
     ;           333333d-57*t103*t178*t28*t29*t302+1.0592355555555552d-5
     <           6*gammabb*t103*t176*t189*t29*t302-1.5888533333333327d-7
     =           *gammabb*t151*t183*t29*t302+2.562666666666666d-5*t149*t
     >           151*t176*t29+1.2813333333333332d-54*t103*t149*t178*t28-
     ?           3.416888888888888d-54*gammabb*t103*t149*t176*t189+5.125
     @           333333333332d-5*gammabb*t149*t151*t183)-9.8508906666666
     1           63d-59*gammabb*t103*t183*t29*t34*t411-2.066666666666666
     2           7d-52*t103*t31*t381+6.406666666666666d-55*t103*t149*t29
     3           *t381-8.266666666666665d-3*gammabb*t176*t31*t377+2.5626
     4           66666666666d-5*gammabb*t149*t176*t29*t377+1.05923555555
     5           55552d-56*t103*t176*t29*t302*t34+3.177706666666666d-56*
     6           gammabb*t103*t183*t302*t34-3.416888888888888d-54*t103*t
     7           149*t176*t34+3.1d-3*t28*t31*t320-9.61d-6*t149*t28*t29*t
     8           320-8.266666666666665d-3*t152*t176*t31-3.97213333333333
     9           3d-57*t103*t179*t28*t29*t302+1.0592355555555552d-56*gam
     :           mabb*t103*t176*t190*t29*t302-1.5888533333333327d-7*gamm
     ;           abb*t152*t183*t29*t302+2.562666666666666d-5*t149*t152*t
     <           176*t29+1.2813333333333332d-54*t103*t149*t179*t28-3.416
     =           888888888888d-54*gammabb*t103*t149*t176*t190+5.12533333
     >           3333332d-5*gammabb*t149*t152*t183)*t81+1.0d+0*t148*t382
     ?           +1.0d+0*t175*t378+1.0d+0*t191*t317)*wght+Cmat3(iq,D3_RA
     @           _RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t88*(5.0d-1*rhob*t49*(5.86666666
     1           6666666d-1*t362*t83*t86-5.529599999999998d-4*t368*t554*
     2           t559*t86+1.9583999999999993d-2*t181*t369*t370*t86-2.079
     3           9999999999996d-1*gammabb*t182*t361*t86+6.0d-2*gammabb*t
     4           28*t83*(5.866666666666666d-1*t362*t83*t85-5.52959999999
     5           9998d-4*t368*t554*t559*t85+1.9583999999999993d-2*t181*t
     6           369*t370*t85-2.0799999999999996d-1*gammabb*t182*t361*t8
     7           5+6.0d-2*gammabb*t28*t83*(5.866666666666666d-1*t362*t83
     8           *t84-5.529599999999998d-4*t368*t554*t559*t84+1.95839999
     9           99999993d-2*t181*t369*t370*t84-2.0799999999999996d-1*ga
     :           mmabb*t182*t361*t84+6.0d-2*gammabb*t28*t83*(5.866666666
     ;           666666d-1*t362*t8*t83-5.529599999999998d-4*t368*t554*t5
     <           59*t8+1.9583999999999993d-2*t181*t369*t370*t8-2.0799999
     =           999999996d-1*gammabb*t182*t361*t8)-3.1999999999999995d-
     >           1*gammabb*t176*t385*t83+6.0d-2*t28*t371*t83+5.866666666
     ?           666666d-1*gammabb*t194*t362*t83-3.1999999999999995d-1*t
     @           176*t184*t83+1.9199999999999995d-2*t181*t182*t183*t385-
     1           2.303999999999999d-3*t181*t184*t369*t384-3.6d-3*gammabb
     2           *t182*t193*t371+3.0719999999999986d-3*t194*t368*t369*t3
     3           70-8.639999999999998d-2*t181*t182*t194*t361+5.759999999
     4           999998d-2*gammabb*t182*t183*t184)-3.1999999999999995d-1
     5           *gammabb*t176*t386*t83+6.0d-2*t28*t372*t83+5.8666666666
     6           66666d-1*gammabb*t195*t362*t83-3.1999999999999995d-1*t1
     7           76*t185*t83+1.9199999999999995d-2*t181*t182*t183*t386-2
     8           .303999999999999d-3*t181*t185*t369*t384-3.6d-3*gammabb*
     9           t182*t193*t372+3.0719999999999986d-3*t195*t368*t369*t37
     :           0-8.639999999999998d-2*t181*t182*t195*t361+5.7599999999
     ;           99998d-2*gammabb*t182*t183*t185)-3.1999999999999995d-1*
     <           gammabb*t176*t387*t83+6.0d-2*t28*t373*t83+5.86666666666
     =           6666d-1*gammabb*t196*t362*t83-3.1999999999999995d-1*t17
     >           6*t186*t83+1.9199999999999995d-2*t181*t182*t183*t387-2.
     ?           303999999999999d-3*t181*t186*t369*t384-3.6d-3*gammabb*t
     @           182*t193*t373+3.0719999999999986d-3*t196*t368*t369*t370
     1           -8.639999999999998d-2*t181*t182*t196*t361+5.75999999999
     2           9998d-2*gammabb*t182*t183*t186)*t90+1.0d+0*t388*t49*t90
     3           +1.0d+0*rhob*t164*t388*t90+5.0d-1*rhob*t197*t335*t90+1.
     4           0d+0*t164*t197*t90-1.25d-1*t164*t87*t89+1.25d-1*gammabb
     5           *t388*t49*t89-1.25d-1*t187*t49*t89+1.25d-1*gammabb*t164
     6           *t197*t89+1.25d-1*t367*t49*t87-1.25d-1*t335*t87-1.25d-1
     7           *t374*t49+1.25d-1*gammabb*t197*t367*t49-2.5d-1*t164*t18
     8           7)+(t558+t557+1.25d-1*gammabb*t388*t49+1.25d-1*gammabb*
     9           t164*t197)*t88*t89+t367*t556*t88+1.0d+0*(3.1d-3*t29*t31
     :           *(3.1d-3*t29*t31*(3.1d-3*t29*t31*(-3.9403562666666647d-
     ;           9*t181*t27*t29*t370*t411+1.271082666666666d-6*t181*t27*
     <           t302*t370+3.0311111111111105d-2*t27*t31*t362-9.39644444
     =           4444442d-5*t149*t27*t29*t362+1.4299679999999995d-6*gamm
     >           abb*t27*t29*t302*t361-4.612799999999999d-4*gammabb*t149
     ?           *t27*t361)-3.9403562666666647d-9*t181*t29*t32*t370*t411
     @           -1.653333333333333d-2*gammabb*t176*t31*t379+5.125333333
     1           333332d-5*gammabb*t149*t176*t29*t379+1.271082666666666d
     2           -6*t181*t302*t32*t370+3.1d-3*t28*t31*t363-9.61d-6*t149*
     3           t28*t29*t363+3.0311111111111105d-2*t31*t32*t362-9.39644
     4           4444444442d-5*t149*t29*t32*t362+3.0311111111111105d-2*g
     5           ammabb*t188*t31*t362-9.396444444444442d-5*gammabb*t149*
     6           t188*t29*t362+1.4299679999999995d-6*gammabb*t29*t302*t3
     7           2*t361-4.612799999999999d-4*gammabb*t149*t32*t361+4.236
     8           9422222222203d-7*t181*t188*t29*t302*t361-1.366755555555
     9           555d-4*t149*t181*t188*t361-1.653333333333333d-2*t176*t1
     :           77*t31-3.1777066666666653d-7*gammabb*t177*t183*t29*t302
     ;           +5.125333333333332d-5*t149*t176*t177*t29+1.025066666666
     <           6663d-4*gammabb*t149*t177*t183)-3.9403562666666647d-9*t
     =           181*t29*t33*t370*t411-1.653333333333333d-2*gammabb*t176
     >           *t31*t380+5.125333333333332d-5*gammabb*t149*t176*t29*t3
     ?           80+1.271082666666666d-6*t181*t302*t33*t370+3.1d-3*t28*t
     @           31*t364-9.61d-6*t149*t28*t29*t364+3.0311111111111105d-2
     1           *t31*t33*t362-9.396444444444442d-5*t149*t29*t33*t362+3.
     2           0311111111111105d-2*gammabb*t189*t31*t362-9.39644444444
     3           4442d-5*gammabb*t149*t189*t29*t362+1.4299679999999995d-
     4           6*gammabb*t29*t302*t33*t361-4.612799999999999d-4*gammab
     5           b*t149*t33*t361+4.2369422222222203d-7*t181*t189*t29*t30
     6           2*t361-1.366755555555555d-4*t149*t181*t189*t361-1.65333
     7           3333333333d-2*t176*t178*t31-3.1777066666666653d-7*gamma
     8           bb*t178*t183*t29*t302+5.125333333333332d-5*t149*t176*t1
     9           78*t29+1.0250666666666663d-4*gammabb*t149*t178*t183)-3.
     :           9403562666666647d-9*t181*t29*t34*t370*t411-1.6533333333
     ;           33333d-2*gammabb*t176*t31*t381+5.125333333333332d-5*gam
     <           mabb*t149*t176*t29*t381+1.271082666666666d-6*t181*t302*
     =           t34*t370+3.1d-3*t28*t31*t365-9.61d-6*t149*t28*t29*t365+
     >           3.0311111111111105d-2*t31*t34*t362-9.396444444444442d-5
     ?           *t149*t29*t34*t362+3.0311111111111105d-2*gammabb*t190*t
     @           31*t362-9.396444444444442d-5*gammabb*t149*t190*t29*t362
     1           +1.4299679999999995d-6*gammabb*t29*t302*t34*t361-4.6127
     2           99999999999d-4*gammabb*t149*t34*t361+4.2369422222222203
     3           d-7*t181*t190*t29*t302*t361-1.366755555555555d-4*t149*t
     4           181*t190*t361-1.653333333333333d-2*t176*t179*t31-3.1777
     5           066666666653d-7*gammabb*t179*t183*t29*t302+5.1253333333
     6           33332d-5*t149*t176*t179*t29+1.0250666666666663d-4*gamma
     7           bb*t149*t179*t183)*t81+2.0d+0*t175*t382+1.0d+0*t191*t36
     8           0)*wght+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*(3.1d-3*t29*t31*(3.1d-3*
     1           t29*t31*(3.1d-3*t29*t31*(3.6940839999999997d-59*t103*t1
     2           93*t27*t29*t411-1.1916399999999998d-56*t103*t193*t27*t3
     3           02)+3.6940839999999997d-59*t103*t193*t29*t32*t411-2.066
     4           6666666666667d-52*t103*t31*t389+6.406666666666666d-55*t
     5           103*t149*t29*t389+6.2d-3*t28*t31*t375-1.921999999999999
     6           8d-5*t149*t28*t29*t375-1.1916399999999998d-56*t103*t193
     7           *t302*t32-7.944266666666666d-57*t103*t188*t28*t29*t302+
     8           5.9582d-8*t150*t193*t29*t302+2.5626666666666664d-54*t10
     9           3*t149*t188*t28-1.9219999999999998d-5*t149*t150*t193)+3
     :           .6940839999999997d-59*t103*t193*t29*t33*t411-2.06666666
     ;           66666667d-52*t103*t31*t390+6.406666666666666d-55*t103*t
     <           149*t29*t390+6.2d-3*t28*t31*t376-1.9219999999999998d-5*
     =           t149*t28*t29*t376-1.1916399999999998d-56*t103*t193*t302
     >           *t33-7.944266666666666d-57*t103*t189*t28*t29*t302+5.958
     ?           2d-8*t151*t193*t29*t302+2.5626666666666664d-54*t103*t14
     @           9*t189*t28-1.9219999999999998d-5*t149*t151*t193)+3.6940
     1           839999999997d-59*t103*t193*t29*t34*t411-2.0666666666666
     2           667d-52*t103*t31*t391+6.406666666666666d-55*t103*t149*t
     3           29*t391+6.2d-3*t28*t31*t377-1.9219999999999998d-5*t149*
     4           t28*t29*t377-1.1916399999999998d-56*t103*t193*t302*t34-
     5           7.944266666666666d-57*t103*t190*t28*t29*t302+5.9582d-8*
     6           t152*t193*t29*t302+2.5626666666666664d-54*t103*t149*t19
     7           0*t28-1.9219999999999998d-5*t149*t152*t193)*t81+1.0d+0*
     8           t148*t392)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t88*(5.0d-1*rhob*t49*(2.0735999
     1           99999999d-4*t181*t554*t561*t86-5.759999999999997d-3*gam
     2           mabb*t369*t384*t86+3.839999999999999d-2*t182*t183*t86+6
     3           .0d-2*gammabb*t28*t83*(2.073599999999999d-4*t181*t554*t
     4           561*t85-5.759999999999997d-3*gammabb*t369*t384*t85+3.83
     5           9999999999999d-2*t182*t183*t85+6.0d-2*gammabb*t28*t83*(
     6           2.073599999999999d-4*t181*t554*t561*t84-5.7599999999999
     7           97d-3*gammabb*t369*t384*t84+3.839999999999999d-2*t182*t
     8           183*t84+6.0d-2*gammabb*t28*(2.073599999999999d-4*t181*t
     9           554*t561*t8-5.759999999999997d-3*gammabb*t369*t384*t8+3
     :           .839999999999999d-2*t182*t183*t8)*t83-1.599999999999999
     ;           8d-1*gammabb*t176*t394*t83+1.2d-1*t28*t385*t83-3.199999
     <           9999999995d-1*t176*t194*t83+9.599999999999997d-3*t181*t
     =           182*t183*t394+4.32d-4*gammabb*t184*t369*t393-7.2d-3*gam
     >           mabb*t182*t193*t385-2.303999999999999d-3*t181*t194*t369
     ?           *t384+5.759999999999998d-2*gammabb*t182*t183*t194-7.2d-
     @           3*t182*t184*t193)-1.5999999999999998d-1*gammabb*t176*t3
     1           95*t83+1.2d-1*t28*t386*t83-3.1999999999999995d-1*t176*t
     2           195*t83+9.599999999999997d-3*t181*t182*t183*t395+4.32d-
     3           4*gammabb*t185*t369*t393-7.2d-3*gammabb*t182*t193*t386-
     4           2.303999999999999d-3*t181*t195*t369*t384+5.759999999999
     5           998d-2*gammabb*t182*t183*t195-7.2d-3*t182*t185*t193)-1.
     6           5999999999999998d-1*gammabb*t176*t396*t83+1.2d-1*t28*t3
     7           87*t83-3.1999999999999995d-1*t176*t196*t83+9.5999999999
     8           99997d-3*t181*t182*t183*t396+4.32d-4*gammabb*t186*t369*
     9           t393-7.2d-3*gammabb*t182*t193*t387-2.303999999999999d-3
     :           *t181*t196*t369*t384+5.759999999999998d-2*gammabb*t182*
     ;           t183*t196-7.2d-3*t182*t186*t193)*t90+5.0d-1*t397*t49*t9
     <           0+5.0d-1*rhob*t164*t397*t90-2.5d-1*t197*t49*t89-2.5d-1*
     =           t388*t49-2.5d-1*t164*t197)+(t560+1.25d-1*gammabb*t397*t
     >           49)*t88*t89+1.0d+0*(3.1d-3*t29*t31*(3.1d-3*t29*t31*(3.1
     ?           d-3*t29*t31*(1.4776335999999993d-9*gammabb*t27*t29*t384
     @           *t411-4.766559999999998d-7*gammabb*t27*t302*t384-3.1777
     1           066666666653d-7*t183*t27*t29*t302+1.0250666666666663d-4
     2           *t149*t183*t27)+1.4776335999999993d-9*gammabb*t29*t32*t
     3           384*t411-8.266666666666665d-3*gammabb*t176*t31*t389+2.5
     4           62666666666666d-5*gammabb*t149*t176*t29*t389-4.76655999
     5           9999998d-7*gammabb*t302*t32*t384+6.2d-3*t28*t31*t379-1.
     6           9219999999999998d-5*t149*t28*t29*t379-3.177706666666665
     7           3d-7*t183*t29*t302*t32+1.0250666666666663d-4*t149*t183*
     8           t32-1.653333333333333d-2*t176*t188*t31+5.9582d-8*t177*t
     9           193*t29*t302-3.1777066666666653d-7*gammabb*t183*t188*t2
     :           9*t302+5.125333333333332d-5*t149*t176*t188*t29-1.921999
     ;           9999999998d-5*t149*t177*t193+1.0250666666666663d-4*gamm
     <           abb*t149*t183*t188)+1.4776335999999993d-9*gammabb*t29*t
     =           33*t384*t411-8.266666666666665d-3*gammabb*t176*t31*t390
     >           +2.562666666666666d-5*gammabb*t149*t176*t29*t390-4.7665
     ?           59999999998d-7*gammabb*t302*t33*t384+6.2d-3*t28*t31*t38
     @           0-1.9219999999999998d-5*t149*t28*t29*t380-3.17770666666
     1           66653d-7*t183*t29*t302*t33+1.0250666666666663d-4*t149*t
     2           183*t33-1.653333333333333d-2*t176*t189*t31+5.9582d-8*t1
     3           78*t193*t29*t302-3.1777066666666653d-7*gammabb*t183*t18
     4           9*t29*t302+5.125333333333332d-5*t149*t176*t189*t29-1.92
     5           19999999999998d-5*t149*t178*t193+1.0250666666666663d-4*
     6           gammabb*t149*t183*t189)+1.4776335999999993d-9*gammabb*t
     7           29*t34*t384*t411-8.266666666666665d-3*gammabb*t176*t31*
     8           t391+2.562666666666666d-5*gammabb*t149*t176*t29*t391-4.
     9           766559999999998d-7*gammabb*t302*t34*t384+6.2d-3*t28*t31
     :           *t381-1.9219999999999998d-5*t149*t28*t29*t381-3.1777066
     ;           666666653d-7*t183*t29*t302*t34+1.0250666666666663d-4*t1
     <           49*t183*t34-1.653333333333333d-2*t176*t190*t31+5.9582d-
     =           8*t179*t193*t29*t302-3.1777066666666653d-7*gammabb*t183
     >           *t190*t29*t302+5.125333333333332d-5*t149*t176*t190*t29-
     ?           1.9219999999999998d-5*t149*t179*t193+1.0250666666666663
     @           d-4*gammabb*t149*t183*t190)*t81+1.0d+0*t175*t392)*wght+
     1           Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = (t88*(5.0d-1*rhob*t49*(-7.776d-
     1           5*gammabb*t554*t562*t86+1.296d-3*t369*t393*t86+6.0d-2*g
     2           ammabb*t28*t83*(-7.776d-5*gammabb*t554*t562*t85+1.296d-
     3           3*t369*t393*t85+6.0d-2*gammabb*t28*t83*(-7.776d-5*gamma
     4           bb*t554*t562*t84+1.296d-3*t369*t393*t84+6.0d-2*gammabb*
     5           t28*(1.296d-3*t369*t393*t8-7.776d-5*gammabb*t554*t562*t
     6           8)*t83+1.8d-1*t28*t394*t83-1.0800000000000001d-2*gammab
     7           b*t182*t193*t394+1.296d-3*gammabb*t194*t369*t393-2.1600
     8           000000000003d-2*t182*t193*t194)+1.8d-1*t28*t395*t83-1.0
     9           800000000000001d-2*gammabb*t182*t193*t395+1.296d-3*gamm
     :           abb*t195*t369*t393-2.1600000000000003d-2*t182*t193*t195
     ;           )+1.8d-1*t28*t396*t83-1.0800000000000001d-2*gammabb*t18
     <           2*t193*t396+1.296d-3*gammabb*t196*t369*t393-2.160000000
     =           0000003d-2*t182*t193*t196)*t90-3.75d-1*t397*t49)+1.0d+0
     >           *(3.1d-3*t29*t31*(3.1d-3*t29*t31*(3.1d-3*t29*t31*(1.787
     ?           46d-7*t27*t302*t393-5.541126d-10*t27*t29*t393*t411)-5.5
     @           41126d-10*t29*t32*t393*t411+1.78746d-7*t302*t32*t393+9.
     1           299999999999999d-3*t28*t31*t389-2.883d-5*t149*t28*t29*t
     2           389+1.78746d-7*t188*t193*t29*t302-5.766d-5*t149*t188*t1
     3           93)-5.541126d-10*t29*t33*t393*t411+1.78746d-7*t302*t33*
     4           t393+9.299999999999999d-3*t28*t31*t390-2.883d-5*t149*t2
     5           8*t29*t390+1.78746d-7*t189*t193*t29*t302-5.766d-5*t149*
     6           t189*t193)-5.541126d-10*t29*t34*t393*t411+1.78746d-7*t3
     7           02*t34*t393+9.299999999999999d-3*t28*t31*t391-2.883d-5*
     8           t149*t28*t29*t391+1.78746d-7*t190*t193*t29*t302-5.766d-
     9           5*t149*t190*t193)*t81)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t198*(-5.0d-1*rhob*t335*t87*t90-1
     1           .0d+0*t164*t87*t90-5.0d-1*rhob*t374*t49*t90-1.0d+0*t187
     2           *t49*t90-1.0d+0*rhob*t164*t187*t90-1.25d-1*gammabb*t164
     3           *t87*t89-1.25d-1*gammabb*t187*t49*t89-1.25d-1*gammabb*t
     4           367*t49*t87)+t198*(-1.25d-1*gammabb*t164*t87-1.25d-1*ga
     5           mmabb*t187*t49)*t89+(1.0d+0*rhob*t335*t87+2.0d+0*t164*t
     6           87+1.0d+0*rhob*t374*t49+2.0d+0*t187*t49+2.0d+0*rhob*t16
     7           4*t187)*t88+1.25d-1*gammabb*t198*t367*t49*t87)*wght+Mma
     8           t3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t198*(-5.0d-1*rhob*t388*t49*t90-
     1           5.0d-1*t197*t49*t90-5.0d-1*rhob*t164*t197*t90+1.25d-1*t
     2           49*t87*t89+t558+t557)+t198*t556*t89+(1.0d+0*rhob*t388*t
     3           49+1.0d+0*t197*t49+1.0d+0*rhob*t164*t197)*t88)*wght+Mma
     4           t3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = (t198*(t560-5.0d-1*rhob*t397*t49
     1           *t90)+1.0d+0*rhob*t397*t49*t88)*wght+Mmat3(iq,D3_GAA_GB
     2           B_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = (-2.0d+0*rhob*t197*t198*t49-2*t39
     1           8*t399)*wght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = (6.0d+0*rhob*t399*t49*t87-3.0d+0*
     1           rhob*t49*t87*t90/taub**4)*wght+Mmat3(iq,D3_GBB_TA_TA)
            else 
              t1 = param(6)
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 2.4d-51*t2+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(8)
              t7 = param(9)
              t8 = param(10)
              t9 = 2.4d-51*t2*t4*t8+t7
              t10 = 2.4d-51*t2*t4*t9+t6
              t11 = t5+2.4d-51*t10*t2*t4
              t12 = 2.4d-51*t11*t2*t4+t1
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.4d-51*t27+1.0d+0
              t29 = 1/t28
              t30 = 2.4d-51*t27*t29*t8+t7
              t31 = t6+2.4d-51*t27*t29*t30
              t32 = t5+2.4d-51*t27*t29*t31
              t33 = 2.4d-51*t27*t29*t32+t1
              t34 = 1/rhob**6.666666666666666d-1
              t35 = rhob**5.0d-1
              t36 = 1/t35
              t37 = 1/rhob**3.333333333333333d-1
              t38 = 1/rhob**1.6666666666666666d-1
              t39 = 1.1120374863094686d+1*t38+3.8447462374472113d+0*t37+
     1           1.644733775567609d+0*t36+2.4058712912881916d-1*t34
              t40 = 3.216395899738507d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.274696188700087d-1*t37+1.0d+0
              t43 = 5.982550435771079d+0*t38+2.2255694211506874d+0*t37+8
     1           .004286349993635d-1*t36+1.8970043257475583d-1*t34
              t44 = 1.6081979498692536d+1/t43+1.0d+0
              t45 = log(t44)
              t46 = 1.3256889990520176d-1*t37+1.0d+0
              t47 = -6.903522198342671d-18*t45*t46-3.1090699999999993d-2
     1           *t41*t42
              t48 = 4.0d-50*t27+4.0d-50*t2
              t49 = 3.1d-3*t48+1.0d+0
              t50 = 1/t49
              t51 = param(5)
              t52 = 3.1d-3*t48*t50*t51+param(4)
              t53 = 3.1d-3*t48*t50*t52+param(3)
              t54 = 3.1d-3*t48*t50*t53+param(2)
              t55 = 3.1d-3*t48*t50*t54+param(1)
              t56 = rhob+rhoa
              t57 = 1/t56**3.333333333333333d-1
              t58 = 1.3256889990520176d-1*t57+1.0d+0
              t59 = rhoa-rhob
              t60 = t59**4
              t61 = 1/t56**4
              t62 = 1/t56
              t63 = 1.0d+0-t59*t62
              t64 = t59*t62+1.0d+0
              t65 = t64**1.3333333333333333d+0+t63**1.3333333333333333d+
     1           0-2.0d+0
              t66 = -1.923661050931536d+0*t60*t61*t65
              t67 = t66+1.0d+0
              t68 = 1/t56**6.666666666666666d-1
              t69 = t56**5.0d-1
              t70 = 1/t69
              t71 = 1/t56**1.6666666666666666d-1
              t72 = 5.982550435771079d+0*t71+8.004286349993635d-1*t70+1.
     1           8970043257475583d-1*t68+2.2255694211506874d+0*t57
              t73 = 1.6081979498692536d+1/t72+1.0d+0
              t74 = log(t73)
              t75 = -6.21814d-2*t58*t67*t74
              t76 = 6.901399211255825d-2*t57+1.0d+0
              t77 = t66+1.923661050931536d+0*t65
              t78 = 8.157414703487641d+0*t71+4.3009724712766434d-1*t70+1
     1           .9115125951273373d-1*t68+2.247591863577616d+0*t57
              t79 = 2.9608813203268075d+1/t78+1.0d+0
              t80 = log(t79)
              t81 = 1.9751631321680768d-2*t76*t77*t80
              t82 = 1.274696188700087d-1*t57+1.0d+0
              t83 = 1.1120374863094686d+1*t71+1.644733775567609d+0*t70+2
     1           .4058712912881916d-1*t68+3.8447462374472113d+0*t57
              t84 = 3.216395899738507d+1/t83+1.0d+0
              t85 = log(t84)
              t86 = -5.980796863619711d-2*t60*t61*t65*t82*t85
              t87 = t56*(t86+t81+t75)-rhob*t47-rhoa*t26
              t88 = 1/t23
              t89 = 1/t14**3
              t90 = 1/rhoa**1.3333333333333333d+0
              t91 = 1/rhoa**1.1666666666666667d+0
              t92 = -9.970917392951799d-1*t91-7.418564737168958d-1*t90-4
     1           .002143174996817d-1*t89-1.264669550498372d-1*t2
              t93 = 1/t22**2
              t94 = 1/t19
              t95 = -1.8533958105157808d+0*t91-1.2815820791490704d+0*t90
     1           -8.223668877838045d-1*t89-1.6039141941921276d-1*t2
              t96 = 1/t18**2
              t97 = 1.0d+0*t21*t94*t95*t96+1.1102230246251565d-16*t25*t8
     1           8*t92*t93+3.0506411443514264d-19*t24*t90+1.321039893133
     2           9265d-3*t20*t90
              t98 = 1/t3**2
              t99 = 1/rhoa**4.333333333333333d+0
              t100 = 1/rhoa**2.6666666666666666d+0
              t101 = 9.6d-102*t8*t98*t99-4.0d-51*t100*t4*t8
              t102 = 9.6d-102*t9*t98*t99-4.0d-51*t100*t4*t9+2.4d-51*t101
     1           *t2*t4
              t103 = 9.6d-102*t10*t98*t99+2.4d-51*t102*t2*t4-4.0d-51*t10
     1           *t100*t4
              t104 = 9.6d-102*t11*t98*t99+2.4d-51*t103*t2*t4-4.0d-51*t10
     1           0*t11*t4
              t105 = 1/t56**1.6666666666666669d+0
              t106 = 1/t69**3
              t107 = 1/t56**1.3333333333333333d+0
              t108 = 1/t56**1.1666666666666667d+0
              t109 = -9.970917392951799d-1*t108-7.418564737168958d-1*t10
     1           7-4.002143174996817d-1*t106-1.264669550498372d-1*t105
              t110 = 1/t72**2
              t111 = 1/t73
              t112 = 1.0d+0*t109*t110*t111*t58*t67
              t113 = -1.3595691172479402d+0*t108-7.491972878592053d-1*t1
     1           07-2.1504862356383217d-1*t106-1.2743417300848914d-1*t10
     2           5
              t114 = 1/t78**2
              t115 = 1/t79
              t116 = -5.848223622634647d-1*t113*t114*t115*t76*t77
              t117 = -1.8533958105157808d+0*t108-1.2815820791490704d+0*t
     1           107-8.223668877838045d-1*t106-1.6039141941921276d-1*t10
     2           5
              t118 = 1/t83**2
              t119 = 1/t84
              t120 = 1.923661050931536d+0*t117*t118*t119*t60*t61*t65*t82
              t121 = 1/t56**2
              t122 = t121*t59
              t123 = -t62
              t124 = t123+t122
              t125 = t63**3.333333333333333d-1
              t126 = -t121*t59
              t127 = t62+t126
              t128 = t64**3.333333333333333d-1
              t129 = 1.3333333333333333d+0*t127*t128+1.3333333333333333d
     1           +0*t124*t125
              t130 = -1.923661050931536d+0*t129*t60*t61
              t131 = 1/t56**5
              t132 = 7.694644203726144d+0*t131*t60*t65
              t133 = t59**3
              t134 = -7.694644203726144d+0*t133*t61*t65
              t135 = t134+t132+t130
              t136 = -6.21814d-2*t135*t58*t74
              t137 = 2.747773264188437d-3*t107*t67*t74
              t138 = t134+t132+t130+1.923661050931536d+0*t129
              t139 = 1.9751631321680768d-2*t138*t76*t80
              t140 = -4.5437964274821163d-4*t107*t77*t80
              t141 = -5.980796863619711d-2*t129*t60*t61*t82*t85
              t142 = 1/t56**5.333333333333333d+0
              t143 = 2.541232989148493d-3*t142*t60*t65*t85
              t144 = 2.3923187454478842d-1*t131*t60*t65*t82*t85
              t145 = -rhoa*t97+t86+t56*(-2.3923187454478842d-1*t133*t61*
     1           t65*t82*t85+t144+t143+t141+t140+t139+t137+t136+t120+t11
     2           6+t112)+t81+t75+6.903522198342671d-18*t24*t25+3.1090699
     3           999999993d-2*t20*t21
              t146 = 1/t49**2
              t147 = 6.406666666666666d-55*t100*t146*t48*t51-2.066666666
     1           6666667d-52*t100*t50*t51
              t148 = -2.0666666666666667d-52*t100*t50*t52+6.406666666666
     1           666d-55*t100*t146*t48*t52+3.1d-3*t147*t48*t50
              t149 = -2.0666666666666667d-52*t100*t50*t53+6.406666666666
     1           666d-55*t100*t146*t48*t53+3.1d-3*t148*t48*t50
              t150 = -2.0666666666666667d-52*t100*t50*t54+6.406666666666
     1           666d-55*t100*t146*t48*t54+3.1d-3*t149*t48*t50
              t151 = 1/t44
              t152 = 1/t35**3
              t153 = 1/rhob**1.3333333333333333d+0
              t154 = 1/rhob**1.1666666666666667d+0
              t155 = -1.264669550498372d-1*t27-9.970917392951799d-1*t154
     1           -7.418564737168958d-1*t153-4.002143174996817d-1*t152
              t156 = 1/t43**2
              t157 = 1/t40
              t158 = -1.6039141941921276d-1*t27-1.8533958105157808d+0*t1
     1           54-1.2815820791490704d+0*t153-8.223668877838045d-1*t152
              t159 = 1/t39**2
              t160 = 1.1102230246251565d-16*t151*t155*t156*t46+3.0506411
     1           443514264d-19*t153*t45+1.0d+0*t157*t158*t159*t42+1.3210
     2           398931339265d-3*t153*t41
              t161 = 1/t28**2
              t162 = 1/rhob**4.333333333333333d+0
              t163 = 1/rhob**2.6666666666666666d+0
              t164 = 9.6d-102*t161*t162*t8-4.0d-51*t163*t29*t8
              t165 = -4.0d-51*t163*t29*t30+9.6d-102*t161*t162*t30+2.4d-5
     1           1*t164*t27*t29
              t166 = -4.0d-51*t163*t29*t31+9.6d-102*t161*t162*t31+2.4d-5
     1           1*t165*t27*t29
              t167 = -4.0d-51*t163*t29*t32+9.6d-102*t161*t162*t32+2.4d-5
     1           1*t166*t27*t29
              t168 = t62+t122
              t169 = t126+t123
              t170 = 1.3333333333333333d+0*t128*t169+1.3333333333333333d
     1           +0*t125*t168
              t171 = -1.923661050931536d+0*t170*t60*t61
              t172 = 7.694644203726144d+0*t133*t61*t65
              t173 = t172+t171+t132
              t174 = -6.21814d-2*t173*t58*t74
              t175 = t172+t171+1.923661050931536d+0*t170+t132
              t176 = 1.9751631321680768d-2*t175*t76*t80
              t177 = -5.980796863619711d-2*t170*t60*t61*t82*t85
              t178 = t86+t56*(2.3923187454478842d-1*t133*t61*t65*t82*t85
     1           +t177+t176+t174+t144+t143+t140+t137+t120+t116+t112)+t81
     2           +t75+6.903522198342671d-18*t45*t46+3.1090699999999993d-
     3           2*t41*t42-rhob*t160
              t179 = 6.406666666666666d-55*t146*t163*t48*t51-2.066666666
     1           6666667d-52*t163*t50*t51
              t180 = -2.0666666666666667d-52*t163*t50*t52+6.406666666666
     1           666d-55*t146*t163*t48*t52+3.1d-3*t179*t48*t50
              t181 = -2.0666666666666667d-52*t163*t50*t53+6.406666666666
     1           666d-55*t146*t163*t48*t53+3.1d-3*t180*t48*t50
              t182 = -2.0666666666666667d-52*t163*t50*t54+6.406666666666
     1           666d-55*t146*t163*t48*t54+3.1d-3*t181*t48*t50
              t183 = 1/t23**2
              t184 = t92**2
              t185 = 1/t22**4
              t186 = 1/t22**3
              t187 = 1/t14**5
              t188 = 1/rhoa**2.3333333333333334d+0
              t189 = 1/rhoa**2.1666666666666665d+0
              t190 = 1.1632736958443765d+0*t189+9.89141964955861d-1*t188
     1           +6.003214762495226d-1*t187+2.1077825841639536d-1*t100
              t191 = 1/t19**2
              t192 = t95**2
              t193 = 1/t18**4
              t194 = 1/t18**3
              t195 = 2.1622951122684114d+0*t189+1.7087761055320938d+0*t1
     1           88+1.2335503316757068d+0*t187+2.673190323653546d-1*t100
              t196 = -8.497974591333913d-2*t90*t94*t95*t96+1.0d+0*t195*t
     1           21*t94*t96-2.0d+0*t192*t194*t21*t94-9.812069668265515d-
     2           18*t88*t90*t92*t93+1.1102230246251565d-16*t190*t25*t88*
     3           t93-2.220446049250313d-16*t184*t186*t25*t88+1.785458392
     4           0998188d-15*t183*t184*t185*t25-4.0675215258019015d-19*t
     5           188*t24+3.216395899738507d+1*t191*t192*t193*t21-1.76138
     6           65241785684d-3*t188*t20
              t197 = 1/t3**3
              t198 = 1/rhoa**7
              t199 = 1/rhoa**5.333333333333333d+0
              t200 = 1/rhoa**3.6666666666666664d+0
              t201 = -5.76d-101*t199*t8*t98+1.0666666666666666d-50*t200*
     1           t4*t8+7.68d-152*t197*t198*t8
              t202 = 1.92d-101*t101*t98*t99-5.76d-101*t199*t9*t98+1.0666
     1           666666666666d-50*t200*t4*t9+7.68d-152*t197*t198*t9+2.4d
     2           -51*t2*t201*t4-8.0d-51*t100*t101*t4
              t203 = 1.92d-101*t102*t98*t99-5.76d-101*t10*t199*t98+2.4d-
     1           51*t2*t202*t4+1.0666666666666666d-50*t10*t200*t4-8.0d-5
     2           1*t100*t102*t4+7.68d-152*t10*t197*t198
              t204 = 1.92d-101*t103*t98*t99-5.76d-101*t11*t199*t98+2.4d-
     1           51*t2*t203*t4+1.0666666666666666d-50*t11*t200*t4-8.0d-5
     2           1*t100*t103*t4+7.68d-152*t11*t197*t198
              t205 = 2.0d+0*t109*t110*t111*t58*t67
              t206 = -1.1696447245269295d+0*t113*t114*t115*t76*t77
              t207 = 3.847322101863072d+0*t117*t118*t119*t60*t61*t65*t82
              t208 = 5.495546528376875d-3*t107*t67*t74
              t209 = -9.087592854964233d-4*t107*t77*t80
              t210 = 5.082465978296986d-3*t142*t60*t65*t85
              t211 = 4.7846374908957684d-1*t131*t60*t65*t82*t85
              t212 = t109**2
              t213 = 1/t72**4
              t214 = 1/t73**2
              t215 = 1.6081979498692536d+1*t212*t213*t214*t58*t67
              t216 = 2.0d+0*t109*t110*t111*t135*t58
              t217 = 1/t72**3
              t218 = -2.0d+0*t111*t212*t217*t58*t67
              t219 = -8.837926660346784d-2*t107*t109*t110*t111*t67
              t220 = 1/t56**2.6666666666666666d+0
              t221 = 1/t69**5
              t222 = 1/t56**2.3333333333333334d+0
              t223 = 1/t56**2.1666666666666665d+0
              t224 = 1.1632736958443765d+0*t223+9.89141964955861d-1*t222
     1           +6.003214762495226d-1*t221+2.1077825841639536d-1*t220
              t225 = 1.0d+0*t110*t111*t224*t58*t67
              t226 = t113**2
              t227 = 1/t78**4
              t228 = 1/t79**2
              t229 = -1.73158960813529d+1*t226*t227*t228*t76*t77
              t230 = -1.1696447245269295d+0*t113*t114*t115*t138*t76
              t231 = 1/t78**3
              t232 = 1.1696447245269295d+0*t115*t226*t231*t76*t77
              t233 = 2.690728393099896d-2*t107*t113*t114*t115*t77
              t234 = 1.5861639701225969d+0*t223+9.98929717145607d-1*t222
     1           +3.2257293534574827d-1*t221+2.1239028834748191d-1*t220
              t235 = -5.848223622634647d-1*t114*t115*t234*t76*t77
              t236 = t117**2
              t237 = 1/t83**4
              t238 = 1/t84**2
              t239 = 6.187255516702861d+1*t236*t237*t238*t60*t61*t65*t82
              t240 = 3.847322101863072d+0*t117*t118*t119*t129*t60*t61*t8
     1           2
              t241 = 1/t83**3
              t242 = -3.847322101863072d+0*t119*t236*t241*t60*t61*t65*t8
     1           2
              t243 = -1.6347222733154887d-1*t117*t118*t119*t142*t60*t65
              t244 = 2.1622951122684114d+0*t223+1.7087761055320938d+0*t2
     1           22+1.2335503316757068d+0*t221+2.673190323653546d-1*t220
              t245 = 1.923661050931536d+0*t118*t119*t244*t60*t61*t65*t82
              t246 = -1.538928840745229d+1*t117*t118*t119*t131*t60*t65*t
     1           82
              t247 = 1.538928840745229d+1*t117*t118*t119*t133*t61*t65*t8
     1           2
              t248 = t124**2
              t249 = 1/t63**6.666666666666666d-1
              t250 = 1/t56**3
              t251 = -2*t250*t59
              t252 = 2*t121
              t253 = t252+t251
              t254 = t127**2
              t255 = 1/t64**6.666666666666666d-1
              t256 = 2*t250*t59
              t257 = -2*t121
              t258 = t257+t256
              t259 = 1.3333333333333333d+0*t128*t258+4.444444444444444d-
     1           1*t254*t255+1.3333333333333333d+0*t125*t253+4.444444444
     2           444444d-1*t248*t249
              t260 = -1.923661050931536d+0*t259*t60*t61
              t261 = 1.5389288407452287d+1*t129*t131*t60
              t262 = -1.5389288407452287d+1*t129*t133*t61
              t263 = 1/t56**6
              t264 = -3.8473221018630716d+1*t263*t60*t65
              t265 = 6.155715362980915d+1*t131*t133*t65
              t266 = t59**2
              t267 = -2.3083932611178434d+1*t266*t61*t65
              t268 = t267+t265+t264+t262+t261+t260
              t269 = -6.21814d-2*t268*t58*t74
              t270 = 5.495546528376875d-3*t107*t135*t74
              t271 = -3.663697685584583d-3*t222*t67*t74
              t272 = t267+t265+t264+t262+t261+t260+1.923661050931536d+0*
     1           t259
              t273 = 1.9751631321680768d-2*t272*t76*t80
              t274 = -9.087592854964233d-4*t107*t138*t80
              t275 = 6.058395236642822d-4*t222*t77*t80
              t276 = -5.980796863619711d-2*t259*t60*t61*t82*t85
              t277 = 5.082465978296986d-3*t129*t142*t60*t85
              t278 = 4.7846374908957684d-1*t129*t131*t60*t82*t85
              t279 = 1/t56**6.333333333333333d+0
              t280 = -2.3718174565385935d-2*t279*t60*t65*t85
              t281 = 2.0329863913187946d-2*t133*t142*t65*t85
              t282 = -1.1961593727239421d+0*t263*t60*t65*t82*t85
              t283 = 1.9138549963583074d+0*t131*t133*t65*t82*t85
              t284 = -7.176956236343652d-1*t266*t61*t65*t82*t85
              t285 = -2.0d+0*t21*t94*t95*t96-2.220446049250313d-16*t25*t
     1           88*t92*t93-6.101282288702853d-19*t24*t90-2.642079786267
     2           853d-3*t20*t90+t56*(-4.7846374908957684d-1*t129*t133*t6
     3           1*t82*t85+t284+t283+t282+t281+t280+t278+t277+t276+t275+
     4           t274+t273+t271+t270+t269+t247+t246+t245+t243+t242+t240+
     5           t239+t235+t233+t232+t230+t229+t225+t219+t218+t216+t215)
     6           -4.7846374908957684d-1*t133*t61*t65*t82*t85-1.196159372
     7           7239421d-1*t129*t60*t61*t82*t85+3.9503262643361536d-2*t
     8           138*t76*t80-1.243628d-1*t135*t58*t74+t211+t210+t209+t20
     9           8+t207+t206+t205-rhoa*t196
              t286 = 1/t49**3
              t287 = 5.51111111111111d-52*t200*t50*t51+2.648088888888888
     1           7d-106*t199*t286*t48*t51-1.708444444444444d-54*t146*t20
     2           0*t48*t51-8.542222222222222d-104*t146*t199*t51
              t288 = 5.51111111111111d-52*t200*t50*t52+2.648088888888888
     1           7d-106*t199*t286*t48*t52-1.708444444444444d-54*t146*t20
     2           0*t48*t52-8.542222222222222d-104*t146*t199*t52+3.1d-3*t
     3           287*t48*t50-4.1333333333333333d-52*t100*t147*t50+1.2813
     4           333333333332d-54*t100*t146*t147*t48
              t289 = 5.51111111111111d-52*t200*t50*t53+2.648088888888888
     1           7d-106*t199*t286*t48*t53-1.708444444444444d-54*t146*t20
     2           0*t48*t53-8.542222222222222d-104*t146*t199*t53+3.1d-3*t
     3           288*t48*t50-4.1333333333333333d-52*t100*t148*t50+1.2813
     4           333333333332d-54*t100*t146*t148*t48
              t290 = 5.51111111111111d-52*t200*t50*t54+2.648088888888888
     1           7d-106*t199*t286*t48*t54-1.708444444444444d-54*t146*t20
     2           0*t48*t54-8.542222222222222d-104*t146*t199*t54+3.1d-3*t
     3           289*t48*t50-4.1333333333333333d-52*t100*t149*t50+1.2813
     4           333333333332d-54*t100*t146*t149*t48
              t291 = 2.6666666666666666d+0*t128*t250*t59-2.6666666666666
     1           666d+0*t125*t250*t59+4.444444444444444d-1*t127*t169*t25
     2           5+4.444444444444444d-1*t124*t168*t249
              t292 = -1.923661050931536d+0*t291*t60*t61
              t293 = 7.694644203726144d+0*t131*t170*t60
              t294 = -7.694644203726144d+0*t133*t170*t61
              t295 = 7.694644203726144d+0*t129*t131*t60
              t296 = 7.694644203726144d+0*t129*t133*t61
              t297 = 2.3083932611178434d+1*t266*t61*t65
              t298 = t297+t296+t295+t294+t293+t292+t264
              t299 = t297+t296+t295+t294+t293+t292+1.923661050931536d+0*
     1           t291+t264
              t300 = 7.176956236343652d-1*t266*t61*t65*t82*t85
              t301 = t56*(-5.980796863619711d-2*t291*t60*t61*t82*t85-2.3
     1           923187454478842d-1*t133*t170*t61*t82*t85+2.392318745447
     2           8842d-1*t129*t133*t61*t82*t85+2.3923187454478842d-1*t13
     3           1*t170*t60*t82*t85+2.3923187454478842d-1*t129*t131*t60*
     4           t82*t85+2.541232989148493d-3*t142*t170*t60*t85+2.541232
     5           989148493d-3*t129*t142*t60*t85+1.923661050931536d+0*t11
     6           7*t118*t119*t170*t60*t61*t82+1.923661050931536d+0*t117*
     7           t118*t119*t129*t60*t61*t82+1.9751631321680768d-2*t299*t
     8           76*t80-4.5437964274821163d-4*t107*t175*t80-4.5437964274
     9           821163d-4*t107*t138*t80-5.848223622634647d-1*t113*t114*
     :           t115*t175*t76-5.848223622634647d-1*t113*t114*t115*t138*
     ;           t76-6.21814d-2*t298*t58*t74+2.747773264188437d-3*t107*t
     <           173*t74+2.747773264188437d-3*t107*t135*t74+1.0d+0*t109*
     =           t110*t111*t173*t58+1.0d+0*t109*t110*t111*t135*t58+t300+
     >           t282+t280+t275+t271+t246+t245+t243+t242+t239+t235+t233+
     ?           t232+t229+t225+t219+t218+t215)+t211+t210+t209+t208+t207
     @           +t206+t205+t177+t176+t174+t141+t139+t136
              t302 = 2.6480888888888887d-106*t100*t163*t286*t48*t51-8.54
     1           2222222222222d-104*t100*t146*t163*t51
              t303 = 2.6480888888888887d-106*t100*t163*t286*t48*t52-8.54
     1           2222222222222d-104*t100*t146*t163*t52+3.1d-3*t302*t48*t
     2           50-2.0666666666666667d-52*t100*t179*t50-2.0666666666666
     3           667d-52*t147*t163*t50+6.406666666666666d-55*t100*t146*t
     4           179*t48+6.406666666666666d-55*t146*t147*t163*t48
              t304 = 2.6480888888888887d-106*t100*t163*t286*t48*t53-8.54
     1           2222222222222d-104*t100*t146*t163*t53+3.1d-3*t303*t48*t
     2           50-2.0666666666666667d-52*t100*t180*t50-2.0666666666666
     3           667d-52*t148*t163*t50+6.406666666666666d-55*t100*t146*t
     4           180*t48+6.406666666666666d-55*t146*t148*t163*t48
              t305 = 2.6480888888888887d-106*t100*t163*t286*t48*t54-8.54
     1           2222222222222d-104*t100*t146*t163*t54+3.1d-3*t304*t48*t
     2           50-2.0666666666666667d-52*t100*t181*t50-2.0666666666666
     3           667d-52*t149*t163*t50+6.406666666666666d-55*t100*t146*t
     4           181*t48+6.406666666666666d-55*t146*t149*t163*t48
              t306 = 1/t44**2
              t307 = t155**2
              t308 = 1/t43**4
              t309 = 1/t43**3
              t310 = 1/t35**5
              t311 = 1/rhob**2.3333333333333334d+0
              t312 = 1/rhob**2.1666666666666665d+0
              t313 = 1.1632736958443765d+0*t312+9.89141964955861d-1*t311
     1           +6.003214762495226d-1*t310+2.1077825841639536d-1*t163
              t314 = 1/t40**2
              t315 = t158**2
              t316 = 1/t39**4
              t317 = 1/t39**3
              t318 = 2.1622951122684114d+0*t312+1.7087761055320938d+0*t3
     1           11+1.2335503316757068d+0*t310+2.673190323653546d-1*t163
              t319 = 1.1102230246251565d-16*t151*t156*t313*t46-2.2204460
     1           49250313d-16*t151*t307*t309*t46+1.7854583920998188d-15*
     2           t306*t307*t308*t46-4.0675215258019015d-19*t311*t45+1.0d
     3           +0*t157*t159*t318*t42-2.0d+0*t157*t315*t317*t42+3.21639
     4           5899738507d+1*t314*t315*t316*t42-1.7613865241785684d-3*
     5           t311*t41-8.497974591333913d-2*t153*t157*t158*t159-9.812
     6           069668265515d-18*t151*t153*t155*t156
              t320 = 1/t28**3
              t321 = 1/rhob**7
              t322 = 1/rhob**5.333333333333333d+0
              t323 = 1/rhob**3.6666666666666664d+0
              t324 = 1.0666666666666666d-50*t29*t323*t8-5.76d-101*t161*t
     1           322*t8+7.68d-152*t320*t321*t8
              t325 = 2.4d-51*t27*t29*t324+1.0666666666666666d-50*t29*t30
     1           *t323-5.76d-101*t161*t30*t322+7.68d-152*t30*t320*t321-8
     2           .0d-51*t163*t164*t29+1.92d-101*t161*t162*t164
              t326 = 2.4d-51*t27*t29*t325+1.0666666666666666d-50*t29*t31
     1           *t323-5.76d-101*t161*t31*t322+7.68d-152*t31*t320*t321-8
     2           .0d-51*t163*t165*t29+1.92d-101*t161*t162*t165
              t327 = 2.4d-51*t27*t29*t326+1.0666666666666666d-50*t29*t32
     1           *t323-5.76d-101*t161*t32*t322+7.68d-152*t32*t320*t321-8
     2           .0d-51*t163*t166*t29+1.92d-101*t161*t162*t166
              t328 = 2.0d+0*t109*t110*t111*t173*t58
              t329 = -1.1696447245269295d+0*t113*t114*t115*t175*t76
              t330 = 3.847322101863072d+0*t117*t118*t119*t170*t60*t61*t8
     1           2
              t331 = -1.538928840745229d+1*t117*t118*t119*t133*t61*t65*t
     1           82
              t332 = t168**2
              t333 = t257+t251
              t334 = t169**2
              t335 = t256+t252
              t336 = 1.3333333333333333d+0*t128*t335+4.444444444444444d-
     1           1*t255*t334+1.3333333333333333d+0*t125*t333+4.444444444
     2           444444d-1*t249*t332
              t337 = -1.923661050931536d+0*t336*t60*t61
              t338 = 1.5389288407452287d+1*t131*t170*t60
              t339 = 1.5389288407452287d+1*t133*t170*t61
              t340 = -6.155715362980915d+1*t131*t133*t65
              t341 = t340+t339+t338+t337+t267+t264
              t342 = -6.21814d-2*t341*t58*t74
              t343 = 5.495546528376875d-3*t107*t173*t74
              t344 = t340+t339+t338+t337+1.923661050931536d+0*t336+t267+
     1           t264
              t345 = 1.9751631321680768d-2*t344*t76*t80
              t346 = -9.087592854964233d-4*t107*t175*t80
              t347 = -5.980796863619711d-2*t336*t60*t61*t82*t85
              t348 = 5.082465978296986d-3*t142*t170*t60*t85
              t349 = 4.7846374908957684d-1*t131*t170*t60*t82*t85
              t350 = -2.0329863913187946d-2*t133*t142*t65*t85
              t351 = -1.9138549963583074d+0*t131*t133*t65*t82*t85
              t352 = t56*(4.7846374908957684d-1*t133*t170*t61*t82*t85+t3
     1           51+t350+t349+t348+t347+t346+t345+t343+t342+t331+t330+t3
     2           29+t328+t284+t282+t280+t275+t271+t246+t245+t243+t242+t2
     3           39+t235+t233+t232+t229+t225+t219+t218+t215)+4.784637490
     4           8957684d-1*t133*t61*t65*t82*t85-1.1961593727239421d-1*t
     5           170*t60*t61*t82*t85+3.9503262643361536d-2*t175*t76*t80-
     6           1.243628d-1*t173*t58*t74-2.220446049250313d-16*t151*t15
     7           5*t156*t46-6.101282288702853d-19*t153*t45-2.0d+0*t157*t
     8           158*t159*t42-2.642079786267853d-3*t153*t41-rhob*t319+t2
     9           11+t210+t209+t208+t207+t206+t205
              t353 = 5.51111111111111d-52*t323*t50*t51-1.708444444444444
     1           d-54*t146*t323*t48*t51+2.6480888888888887d-106*t286*t32
     2           2*t48*t51-8.542222222222222d-104*t146*t322*t51
              t354 = 5.51111111111111d-52*t323*t50*t52-1.708444444444444
     1           d-54*t146*t323*t48*t52+2.6480888888888887d-106*t286*t32
     2           2*t48*t52-8.542222222222222d-104*t146*t322*t52+3.1d-3*t
     3           353*t48*t50-4.1333333333333333d-52*t163*t179*t50+1.2813
     4           333333333332d-54*t146*t163*t179*t48
              t355 = 5.51111111111111d-52*t323*t50*t53-1.708444444444444
     1           d-54*t146*t323*t48*t53+2.6480888888888887d-106*t286*t32
     2           2*t48*t53-8.542222222222222d-104*t146*t322*t53+3.1d-3*t
     3           354*t48*t50-4.1333333333333333d-52*t163*t180*t50+1.2813
     4           333333333332d-54*t146*t163*t180*t48
              t356 = 5.51111111111111d-52*t323*t50*t54-1.708444444444444
     1           d-54*t146*t323*t48*t54+2.6480888888888887d-106*t286*t32
     2           2*t48*t54-8.542222222222222d-104*t146*t322*t54+3.1d-3*t
     3           355*t48*t50-4.1333333333333333d-52*t163*t181*t50+1.2813
     4           333333333332d-54*t146*t163*t181*t48
              t357 = t92**3
              t358 = 1/t14**7
              t359 = 1/rhoa**3.3333333333333337d+0
              t360 = 1/rhoa**3.1666666666666665d+0
              t361 = t95**3
              t362 = 1.6995949182667827d-1*t188*t94*t95*t96-1.2746961887
     1           00087d-1*t195*t90*t94*t96+1.0d+0*t21*(-4.68497274324822
     2           4d+0*t360-3.9871442462415524d+0*t359-3.083875829189267d
     3           +0*t358-7.128507529742789d-1*t200)*t94*t96-6.0d+0*t194*
     4           t195*t21*t94*t95+9.649187699215522d+1*t191*t193*t195*t2
     5           1*t95+2.549392377400174d-1*t192*t194*t90*t94+6.0d+0*t19
     6           3*t21*t361*t94+1.962413933653103d-17*t188*t88*t92*t93-1
     7           .4718104502398274d-17*t190*t88*t90*t93+1.11022302462515
     8           65d-16*t25*(-2.520426340996149d+0*t360-2.30799791823034
     9           28d+0*t359-1.5008036906238065d+0*t358-5.620753557770543
     :           d-1*t200)*t88*t93-6.661338147750939d-16*t186*t190*t25*t
     ;           88*t92+5.356375176299456d-15*t183*t185*t190*t25*t92+2.9
     <           43620900479655d-17*t184*t186*t88*t90-4.0999275947472624
     =           d+0*t191*t192*t193*t90-2.3669625486718335d-16*t183*t184
     >           *t185*t90+6.661338147750939d-16*t185*t25*t357*t88-1.929
     ?           8375398431045d+2*t191*t21*t361/t18**5+2.069040516770936
     @           4d+3*t21*t361/(t18**6*t19**3)+9.490883560204437d-19*t24
     1           *t359+4.1099018897499934d-3*t20*t359+5.742741051503565d
     2           -14*t25*t357/(t22**6*t23**3)-1.0712750352598913d-14*t18
     3           3*t25*t357/t22**5
              t363 = 1/t3**4
              t364 = 1/rhoa**9.666666666666666d+0
              t365 = 1/rhoa**8
              t366 = 1/rhoa**6.333333333333333d+0
              t367 = 1/rhoa**4.666666666666667d+0
              t368 = 1/t49**4
              t369 = 4.824593849607761d+1*t212*t213*t214*t58*t67
              t370 = -6.0d+0*t111*t212*t217*t58*t67
              t371 = -2.6513779981040353d-1*t107*t109*t110*t111*t67
              t372 = 3.0d+0*t110*t111*t224*t58*t67
              t373 = -5.19476882440587d+1*t226*t227*t228*t76*t77
              t374 = 3.5089341735807883d+0*t115*t226*t231*t76*t77
              t375 = 8.072185179299687d-2*t107*t113*t114*t115*t77
              t376 = -1.7544670867903941d+0*t114*t115*t234*t76*t77
              t377 = 1.856176655010858d+2*t236*t237*t238*t60*t61*t65*t82
              t378 = -1.1541966305589217d+1*t119*t236*t241*t60*t61*t65*t
     1           82
              t379 = -4.904166819946466d-1*t117*t118*t119*t142*t60*t65
              t380 = 5.770983152794609d+0*t118*t119*t244*t60*t61*t65*t82
              t381 = -4.616786522235687d+1*t117*t118*t119*t131*t60*t65*t
     1           82
              t382 = -1.099109305675375d-2*t222*t67*t74
              t383 = 1.8175185709928465d-3*t222*t77*t80
              t384 = -7.11545236961578d-2*t279*t60*t65*t85
              t385 = -3.588478118171826d+0*t263*t60*t65*t82*t85
              t386 = -2.1530868709030954d+0*t266*t61*t65*t82*t85
              t387 = t109**3
              t388 = 5.172601291927341d+2*t387*t58*t67/(t72**6*t73**3)
              t389 = -9.649187699215522d+1*t214*t387*t58*t67/t72**5
              t390 = 4.824593849607761d+1*t109*t213*t214*t224*t58*t67
              t391 = -2.1319703304396778d+0*t107*t212*t213*t214*t67
              t392 = 6.0d+0*t111*t213*t387*t58*t67
              t393 = -6.0d+0*t109*t111*t217*t224*t58*t67
              t394 = 2.6513779981040353d-1*t107*t111*t212*t217*t67
              t395 = -1.3256889990520176d-1*t107*t110*t111*t224*t67
              t396 = 1.767585332069357d-1*t109*t110*t111*t222*t67
              t397 = 1/t56**3.6666666666666664d+0
              t398 = 1/t69**7
              t399 = 1/t56**3.3333333333333337d+0
              t400 = 1/t56**3.1666666666666665d+0
              t401 = 1.0d+0*t110*t111*(-2.520426340996149d+0*t400-2.3079
     1           979182303428d+0*t399-1.5008036906238065d+0*t398-5.62075
     2           3557770543d-1*t397)*t58*t67
              t402 = t113**3
              t403 = -1.0254062650399592d+3*t402*t76*t77/(t78**6*t79**3)
              t404 = 1.0389537648811739d+2*t228*t402*t76*t77/t78**5
              t405 = -5.19476882440587d+1*t113*t227*t228*t234*t76*t77
              t406 = 1.1950391155803675d+0*t107*t226*t227*t228*t77
              t407 = -3.5089341735807883d+0*t115*t227*t402*t76*t77
              t408 = 3.5089341735807883d+0*t113*t115*t231*t234*t76*t77
              t409 = -8.072185179299687d-2*t107*t115*t226*t231*t77
              t410 = 4.0360925896498434d-2*t107*t114*t115*t234*t77
              t411 = -5.381456786199791d-2*t113*t114*t115*t222*t77
              t412 = -5.848223622634647d-1*t114*t115*(-3.436688601932293
     1           d+0*t400-2.3308360066730832d+0*t399-8.064323383643707d-
     2           1*t398-5.663741022599518d-1*t397)*t76*t77
              t413 = t117**3
              t414 = 3.9801326549115085d+3*t413*t60*t61*t65*t82/(t83**6*
     1           t84**3)
              t415 = -3.712353310021716d+2*t238*t413*t60*t61*t65*t82/t83
     1           **5
              t416 = 1.856176655010858d+2*t117*t237*t238*t244*t60*t61*t6
     1           5*t82
              t417 = -7.424706620043432d+2*t131*t236*t237*t238*t60*t65*t
     1           82
              t418 = -7.886871025654724d+0*t142*t236*t237*t238*t60*t65
              t419 = 1.1541966305589217d+1*t119*t237*t413*t60*t61*t65*t8
     1           2
              t420 = -1.1541966305589217d+1*t117*t119*t241*t244*t60*t61*
     1           t65*t82
              t421 = 4.616786522235687d+1*t119*t131*t236*t241*t60*t65*t8
     1           2
              t422 = 4.904166819946466d-1*t119*t142*t236*t241*t60*t65
              t423 = -2.452083409973233d-1*t118*t119*t142*t244*t60*t65
              t424 = 2.2886111826416838d+0*t117*t118*t119*t279*t60*t65
              t425 = 1.923661050931536d+0*t118*t119*(-4.684972743248224d
     1           +0*t400-3.9871442462415524d+0*t399-3.083875829189267d+0
     2           *t398-7.128507529742789d-1*t397)*t60*t61*t65*t82
              t426 = -2.3083932611178434d+1*t118*t119*t131*t244*t60*t65*
     1           t82
              t427 = 1.1541966305589217d+2*t117*t118*t119*t263*t60*t65*t
     1           82
              t428 = 6.925179783353531d+1*t117*t118*t119*t266*t61*t65*t8
     1           2
              t429 = 8.548627933030694d-3*t399*t67*t74
              t430 = 1/t63**1.6666666666666669d+0
              t431 = 6*t59*t61
              t432 = -6*t250
              t433 = 1/t64**1.6666666666666669d+0
              t434 = -6*t59*t61
              t435 = 6*t250
              t436 = 1.3333333333333333d+0*t128*(t435+t434)-2.9629629629
     1           62963d-1*t127**3*t433+1.3333333333333333d+0*t125*(t432+
     2           t431)-2.962962962962963d-1*t124**3*t430+1.3333333333333
     3           333d+0*t127*t255*t258+1.3333333333333333d+0*t124*t249*t
     4           253
              t437 = -1.923661050931536d+0*t436*t60*t61
              t438 = 2.3083932611178434d+1*t131*t259*t60
              t439 = -2.3083932611178434d+1*t133*t259*t61
              t440 = -1.1541966305589216d+2*t129*t263*t60
              t441 = 1.8467146088942746d+2*t129*t131*t133
              t442 = -6.925179783353531d+1*t129*t266*t61
              t443 = 1/t56**7
              t444 = 2.3083932611178432d+2*t443*t60*t65
              t445 = -4.6167865222356863d+2*t133*t263*t65
              t446 = 2.770071913341412d+2*t131*t266*t65
              t447 = -4.616786522235687d+1*t59*t61*t65
              t448 = -1.4136255552166585d-3*t399*t77*t80
              t449 = 2.0103976536374746d-1*t60*t65*t85/t56**7.3333333333
     1           33333d+0
              t450 = 9.148438760934575d-2*t142*t266*t65*t85
              t451 = 7.176956236343652d+0*t443*t60*t65*t82*t85
              t452 = 8.612347483612381d+0*t131*t266*t65*t82*t85
              t453 = -1.4353912472687305d+0*t59*t61*t65*t82*t85
              t454 = -1.243628d-1*t298*t58*t74
              t455 = 3.9503262643361536d-2*t299*t76*t80
              t456 = -1.1961593727239421d-1*t291*t60*t61*t82*t85
              t457 = 2.0d+0*t109*t110*t111*t298*t58
              t458 = -1.1696447245269295d+0*t113*t114*t115*t299*t76
              t459 = 3.847322101863072d+0*t117*t118*t119*t291*t60*t61*t8
     1           2
              t460 = -2.3083932611178434d+1*t117*t118*t119*t266*t61*t65*
     1           t82
              t461 = 5.495546528376875d-3*t107*t298*t74
              t462 = 1.5389288407452287d+1*t131*t291*t60
              t463 = -1.5389288407452287d+1*t133*t291*t61
              t464 = 1.7777777777777776d+0*t127*t250*t255*t59-1.77777777
     1           77777776d+0*t124*t249*t250*t59+1.3333333333333333d+0*t1
     2           28*(t434+2*t250)-2.962962962962963d-1*t169*t254*t433+1.
     3           3333333333333333d+0*t125*(t431-2*t250)-2.96296296296296
     4           3d-1*t168*t248*t430+4.444444444444444d-1*t169*t255*t258
     5           +4.444444444444444d-1*t168*t249*t253
              t465 = -1.923661050931536d+0*t464*t60*t61
              t466 = 7.694644203726144d+0*t131*t259*t60
              t467 = 7.694644203726144d+0*t133*t259*t61
              t468 = -3.8473221018630716d+1*t170*t263*t60
              t469 = 6.155715362980915d+1*t131*t133*t170
              t470 = -2.3083932611178434d+1*t170*t266*t61
              t471 = -7.694644203726143d+1*t129*t263*t60
              t472 = 4.616786522235687d+1*t129*t266*t61
              t473 = -1.5389288407452287d+2*t133*t263*t65
              t474 = -9.233573044471374d+1*t131*t266*t65
              t475 = 4.616786522235687d+1*t59*t61*t65
              t476 = -9.087592854964233d-4*t107*t299*t80
              t477 = 5.082465978296986d-3*t142*t291*t60*t85
              t478 = 4.7846374908957684d-1*t131*t291*t60*t82*t85
              t479 = -2.870782494537461d+0*t131*t266*t65*t82*t85
              t480 = 1.4353912472687305d+0*t59*t61*t65*t82*t85
              t481 = -8*t128*t59*t61+8*t125*t59*t61+1.7777777777777776d+
     1           0*t169*t250*t255*t59-1.7777777777777776d+0*t168*t249*t2
     2           50*t59-2.962962962962963d-1*t127*t334*t433-2.9629629629
     3           62963d-1*t124*t332*t430+4.444444444444444d-1*t127*t255*
     4           t335+4.444444444444444d-1*t124*t249*t333-2.666666666666
     5           6666d+0*t128*t250+2.6666666666666666d+0*t125*t250
              t482 = -1.923661050931536d+0*t481*t60*t61
              t483 = 1.5389288407452287d+1*t133*t291*t61
              t484 = 7.694644203726144d+0*t131*t336*t60
              t485 = -7.694644203726144d+0*t133*t336*t61
              t486 = -7.694644203726143d+1*t170*t263*t60
              t487 = 4.616786522235687d+1*t170*t266*t61
              t488 = -3.8473221018630716d+1*t129*t263*t60
              t489 = -6.155715362980915d+1*t129*t131*t133
              t490 = -2.3083932611178434d+1*t129*t266*t61
              t491 = 1.5389288407452287d+2*t133*t263*t65
              t492 = t155**3
              t493 = 1/t35**7
              t494 = 1/rhob**3.3333333333333337d+0
              t495 = 1/rhob**3.1666666666666665d+0
              t496 = t158**3
              t497 = 2.0690405167709364d+3*t42*t496/(t39**6*t40**3)-1.92
     1           98375398431045d+2*t314*t42*t496/t39**5+6.0d+0*t157*t316
     2           *t42*t496+1.1102230246251565d-16*t151*t156*t46*(-2.5204
     3           26340996149d+0*t495-2.3079979182303428d+0*t494-1.500803
     4           6906238065d+0*t493-5.620753557770543d-1*t323)+1.0d+0*t1
     5           57*t159*t42*(-4.684972743248224d+0*t495-3.9871442462415
     6           524d+0*t494-3.083875829189267d+0*t493-7.128507529742789
     7           d-1*t323)+9.490883560204437d-19*t45*t494+4.109901889749
     8           9934d-3*t41*t494+5.742741051503565d-14*t46*t492/(t43**6
     9           *t44**3)-1.0712750352598913d-14*t306*t46*t492/t43**5+6.
     :           661338147750939d-16*t151*t308*t46*t492-6.66133814775093
     ;           9d-16*t151*t155*t309*t313*t46+5.356375176299456d-15*t15
     <           5*t306*t308*t313*t46-6.0d+0*t157*t158*t317*t318*t42+9.6
     =           49187699215522d+1*t158*t314*t316*t318*t42-1.27469618870
     >           0087d-1*t153*t157*t159*t318+2.549392377400174d-1*t153*t
     ?           157*t315*t317-4.0999275947472624d+0*t153*t314*t315*t316
     @           -1.4718104502398274d-17*t151*t153*t156*t313+1.699594918
     1           2667827d-1*t157*t158*t159*t311+1.962413933653103d-17*t1
     2           51*t155*t156*t311+2.943620900479655d-17*t151*t153*t307*
     3           t309-2.3669625486718335d-16*t153*t306*t307*t308
              t498 = 1/t28**4
              t499 = 1/rhob**9.666666666666666d+0
              t500 = 1/rhob**8
              t501 = 1/rhob**6.333333333333333d+0
              t502 = 1/rhob**4.666666666666667d+0
              t503 = 1.3333333333333333d+0*t125*(t435+t431)+1.3333333333
     1           333333d+0*t128*(t434+t432)-2.962962962962963d-1*t169**3
     2           *t433-2.962962962962963d-1*t168**3*t430+1.3333333333333
     3           333d+0*t169*t255*t335+1.3333333333333333d+0*t168*t249*t
     4           333
              t504 = -1.923661050931536d+0*t503*t60*t61
              t505 = 2.3083932611178434d+1*t131*t336*t60
              t506 = 2.3083932611178434d+1*t133*t336*t61
              t507 = -1.1541966305589216d+2*t170*t263*t60
              t508 = -1.8467146088942746d+2*t131*t133*t170
              t509 = -6.925179783353531d+1*t170*t266*t61
              t510 = 4.6167865222356863d+2*t133*t263*t65
              fnc(iq) = (1.0d+0*t55*t87+5.0d-1*rhob*t33*t47+5.0d-1*rhoa*
     1           t12*t26)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t12*t97+1.0d+0*t150*t87+1.0d
     1           +0*t145*t55+5.0d-1*t12*t26+5.0d-1*rhoa*t104*t26)*wght+A
     2           mat(iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t182*t87+1.0d+0*t178*t55+5.0d-1*t
     1           33*t47+5.0d-1*rhob*t167*t47+5.0d-1*rhob*t160*t33)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t12*t97+1.0d+0*rhoa*t104*t97+
     1           1.0d+0*t290*t87+1.0d+0*t285*t55+5.0d-1*rhoa*t204*t26+1.
     2           0d+0*t104*t26+5.0d-1*rhoa*t12*t196+2.0d+0*t145*t150)*wg
     3           ht+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t305*t87+1.0d+0*t301*t55+1.0d
     1           +0*t145*t182+1.0d+0*t150*t178)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t356*t87+1.0d+0*t352*t55+5.0d
     1           -1*rhob*t327*t47+1.0d+0*t167*t47+5.0d-1*rhob*t319*t33+1
     2           .0d+0*t160*t33+2.0d+0*t178*t182+1.0d+0*rhob*t160*t167)*
     3           wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (5.0d-1*rhoa*t26*(2.4d-51*t2*t4*(2
     1           .4d-51*t2*t4*(2.88d-101*t201*t98*t99+2.4d-51*t2*t4*(3.4
     2           986666666666666d-100*t366*t8*t98-3.911111111111111d-50*
     3           t367*t4*t8-9.984000000000001d-151*t197*t365*t8+9.216000
     4           000000001d-202*t363*t364*t8)+3.4986666666666666d-100*t3
     5           66*t9*t98-1.7279999999999998d-100*t101*t199*t98-3.91111
     6           1111111111d-50*t367*t4*t9-9.984000000000001d-151*t197*t
     7           365*t9+9.216000000000001d-202*t363*t364*t9-1.2d-50*t100
     8           *t201*t4+3.2d-50*t101*t200*t4+2.3040000000000002d-151*t
     9           101*t197*t198)+2.88d-101*t202*t98*t99+3.498666666666666
     :           6d-100*t10*t366*t98-1.7279999999999998d-100*t102*t199*t
     ;           98-3.911111111111111d-50*t10*t367*t4-1.2d-50*t100*t202*
     <           t4+3.2d-50*t102*t200*t4-9.984000000000001d-151*t10*t197
     =           *t365+9.216000000000001d-202*t10*t363*t364+2.3040000000
     >           000002d-151*t102*t197*t198)+2.88d-101*t203*t98*t99+3.49
     ?           86666666666666d-100*t11*t366*t98-1.7279999999999998d-10
     @           0*t103*t199*t98-3.911111111111111d-50*t11*t367*t4-1.2d-
     1           50*t100*t203*t4+3.2d-50*t103*t200*t4-9.984000000000001d
     2           -151*t11*t197*t365+9.216000000000001d-202*t11*t363*t364
     3           +2.3040000000000002d-151*t103*t197*t198)+1.5d+0*rhoa*t2
     4           04*t97+3.0d+0*t104*t97+1.0d+0*t55*(2.549392377400174d-1
     5           *t90*t94*t95*t96-3.0d+0*t195*t21*t94*t96+6.0d+0*t192*t1
     6           94*t21*t94+2.943620900479655d-17*t88*t90*t92*t93-3.3306
     7           690738754696d-16*t190*t25*t88*t93+6.661338147750939d-16
     8           *t184*t186*t25*t88+t56*(-1.4353912472687305d+1*t133*t26
     9           3*t65*t82*t85-5.980796863619711d-2*t436*t60*t61*t82*t85
     :           -2.1530868709030954d+0*t129*t266*t61*t82*t85-7.17695623
     ;           6343652d-1*t133*t259*t61*t82*t85-3.588478118171826d+0*t
     <           129*t263*t60*t82*t85+7.176956236343652d-1*t131*t259*t60
     =           *t82*t85+5.741564989074922d+0*t129*t131*t133*t82*t85-2.
     >           8461809478463124d-1*t133*t279*t65*t85-7.11545236961578d
     ?           -2*t129*t279*t60*t85+7.623698967445479d-3*t142*t259*t60
     @           *t85+6.098959173956384d-2*t129*t133*t142*t85+2.30839326
     1           11178434d+1*t118*t119*t133*t244*t61*t65*t82-4.616786522
     2           235687d+1*t119*t133*t236*t241*t61*t65*t82+7.42470662004
     3           3432d+2*t133*t236*t237*t238*t61*t65*t82-1.8467146088942
     4           746d+2*t117*t118*t119*t131*t133*t65*t82+5.7709831527946
     5           09d+0*t117*t118*t119*t259*t60*t61*t82+5.770983152794609
     6           d+0*t118*t119*t129*t244*t60*t61*t82-1.1541966305589217d
     7           +1*t119*t129*t236*t241*t60*t61*t82+1.856176655010858d+2
     8           *t129*t236*t237*t238*t60*t61*t82+4.616786522235687d+1*t
     9           117*t118*t119*t129*t133*t61*t82-4.616786522235687d+1*t1
     :           17*t118*t119*t129*t131*t60*t82+1.9751631321680768d-2*(t
     ;           447+t446+t445+t444+t442+t441+t440+t439+t438+t437+1.9236
     <           61050931536d+0*t436)*t76*t80-1.363138928244635d-3*t107*
     =           t272*t80+1.8175185709928465d-3*t138*t222*t80-1.75446708
     >           67903941d+0*t113*t114*t115*t272*t76-1.7544670867903941d
     ?           +0*t114*t115*t138*t234*t76+3.5089341735807883d+0*t115*t
     @           138*t226*t231*t76-5.19476882440587d+1*t138*t226*t227*t2
     1           28*t76-6.21814d-2*(t447+t446+t445+t444+t442+t441+t440+t
     2           439+t438+t437)*t58*t74+8.243319792565312d-3*t107*t268*t
     3           74-1.099109305675375d-2*t135*t222*t74-1.961666727978586
     4           5d+0*t117*t118*t119*t133*t142*t65-4.904166819946466d-1*
     5           t117*t118*t119*t129*t142*t60+3.0d+0*t109*t110*t111*t268
     6           *t58+3.0d+0*t110*t111*t135*t224*t58-6.0d+0*t111*t135*t2
     7           12*t217*t58+4.824593849607761d+1*t135*t212*t213*t214*t5
     8           8+t453+t452+t451+t450+t449+t448+t429+t428+t427+t426+t42
     9           5+t424+t423+t422+t421+t420+t419+t418+t417+t416+t415+t41
     :           4+t412+t411+t410+t409+t408+t407+t406+t405+t404+t403+t40
     ;           1+t396+t395+t394+t393+t392+t391+t390+t389+t388+8.072185
     <           179299687d-2*t107*t113*t114*t115*t138-2.651377998104035
     =           3d-1*t107*t109*t110*t111*t135)+5.741564989074922d+0*t13
     >           1*t133*t65*t82*t85-1.794239059085913d-1*t259*t60*t61*t8
     ?           2*t85-1.4353912472687305d+0*t129*t133*t61*t82*t85+1.435
     @           3912472687305d+0*t129*t131*t60*t82*t85+6.09895917395638
     1           4d-2*t133*t142*t65*t85+1.524739793489096d-2*t129*t142*t
     2           60*t85+4.616786522235687d+1*t117*t118*t119*t133*t61*t65
     3           *t82+1.1541966305589217d+1*t117*t118*t119*t129*t60*t61*
     4           t82+5.92548939650423d-2*t272*t76*t80-2.72627785648927d-
     5           3*t107*t138*t80-3.5089341735807883d+0*t113*t114*t115*t1
     6           38*t76-1.865442d-1*t268*t58*t74+1.6486639585130625d-2*t
     7           107*t135*t74+6.0d+0*t109*t110*t111*t135*t58+t386+t385+t
     8           384+t383+t382+t381+t380+t379+t378+t377+t376+t375+t374+t
     9           373+t372+t371+t370+t369-rhoa*t362-5.356375176299456d-15
     :           *t183*t184*t185*t25+1.2202564577405706d-18*t188*t24-9.6
     ;           49187699215522d+1*t191*t192*t193*t21+5.284159572535705d
     <           -3*t188*t20)+1.0d+0*(-2.0207407407407404d-51*t367*t50*t
     =           54+1.641815111111111d-157*t365*t368*t48*t54+6.264296296
     >           296294d-54*t146*t367*t48*t54-2.118471111111111d-105*t28
     ?           6*t366*t48*t54+6.833777777777776d-103*t146*t366*t54-5.2
     @           96177777777777d-155*t286*t365*t54+3.1d-3*t48*t50*(-2.02
     1           07407407407404d-51*t367*t50*t53+1.641815111111111d-157*
     2           t365*t368*t48*t53+6.264296296296294d-54*t146*t367*t48*t
     3           53-2.118471111111111d-105*t286*t366*t48*t53+6.833777777
     4           777776d-103*t146*t366*t53-5.296177777777777d-155*t286*t
     5           365*t53+3.1d-3*t48*t50*(-2.0207407407407404d-51*t367*t5
     6           0*t52+1.641815111111111d-157*t365*t368*t48*t52+6.264296
     7           296296294d-54*t146*t367*t48*t52-2.118471111111111d-105*
     8           t286*t366*t48*t52+6.833777777777776d-103*t146*t366*t52-
     9           5.296177777777777d-155*t286*t365*t52+3.1d-3*t48*t50*(-2
     :           .0207407407407404d-51*t367*t50*t51+1.641815111111111d-1
     ;           57*t365*t368*t48*t51+6.264296296296294d-54*t146*t367*t4
     <           8*t51-2.118471111111111d-105*t286*t366*t48*t51+6.833777
     =           777777776d-103*t146*t366*t51-5.296177777777777d-155*t28
     >           6*t365*t51)-6.2d-52*t100*t287*t50+1.6533333333333333d-5
     ?           1*t147*t200*t50+1.9219999999999998d-54*t100*t146*t287*t
     @           48+7.944266666666666d-106*t147*t199*t286*t48-5.12533333
     1           3333332d-54*t146*t147*t200*t48-2.5626666666666664d-103*
     2           t146*t147*t199)-6.2d-52*t100*t288*t50+1.653333333333333
     3           3d-51*t148*t200*t50+1.9219999999999998d-54*t100*t146*t2
     4           88*t48+7.944266666666666d-106*t148*t199*t286*t48-5.1253
     5           33333333332d-54*t146*t148*t200*t48-2.5626666666666664d-
     6           103*t146*t148*t199)-6.2d-52*t100*t289*t50+1.65333333333
     7           33333d-51*t149*t200*t50+1.9219999999999998d-54*t100*t14
     8           6*t289*t48+7.944266666666666d-106*t149*t199*t286*t48-5.
     9           125333333333332d-54*t146*t149*t200*t48-2.56266666666666
     :           64d-103*t146*t149*t199)*t87+5.0d-1*rhoa*t12*t362+3.0d+0
     ;           *t145*t290+3.0d+0*t150*t285+1.5d+0*t204*t26+1.5d+0*t12*
     <           t196+1.5d+0*rhoa*t104*t196)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*(1.641815111111111d-157*t1
     1           63*t199*t368*t48*t54-7.061570370370368d-106*t163*t200*t
     2           286*t48*t54-5.296177777777777d-155*t163*t199*t286*t54+2
     3           .2779259259259252d-103*t146*t163*t200*t54+3.1d-3*t48*t5
     4           0*(1.641815111111111d-157*t163*t199*t368*t48*t53-7.0615
     5           70370370368d-106*t163*t200*t286*t48*t53-5.2961777777777
     6           77d-155*t163*t199*t286*t53+2.2779259259259252d-103*t146
     7           *t163*t200*t53+3.1d-3*t48*t50*(1.641815111111111d-157*t
     8           163*t199*t368*t48*t52-7.061570370370368d-106*t163*t200*
     9           t286*t48*t52-5.296177777777777d-155*t163*t199*t286*t52+
     :           2.2779259259259252d-103*t146*t163*t200*t52+3.1d-3*t48*t
     ;           50*(1.641815111111111d-157*t163*t199*t368*t48*t51-7.061
     <           570370370368d-106*t163*t200*t286*t48*t51-5.296177777777
     =           777d-155*t163*t199*t286*t51+2.2779259259259252d-103*t14
     >           6*t163*t200*t51)-4.1333333333333333d-52*t100*t302*t50-2
     ?           .0666666666666667d-52*t163*t287*t50+5.51111111111111d-5
     @           2*t179*t200*t50+1.2813333333333332d-54*t100*t146*t302*t
     1           48+6.406666666666666d-55*t146*t163*t287*t48+2.648088888
     2           8888887d-106*t179*t199*t286*t48+5.296177777777777d-106*
     3           t100*t147*t163*t286*t48-1.708444444444444d-54*t146*t179
     4           *t200*t48-8.542222222222222d-104*t146*t179*t199-1.70844
     5           44444444444d-103*t100*t146*t147*t163)-4.133333333333333
     6           3d-52*t100*t303*t50-2.0666666666666667d-52*t163*t288*t5
     7           0+5.51111111111111d-52*t180*t200*t50+1.2813333333333332
     8           d-54*t100*t146*t303*t48+6.406666666666666d-55*t146*t163
     9           *t288*t48+2.6480888888888887d-106*t180*t199*t286*t48+5.
     :           296177777777777d-106*t100*t148*t163*t286*t48-1.70844444
     ;           4444444d-54*t146*t180*t200*t48-8.542222222222222d-104*t
     <           146*t180*t199-1.7084444444444444d-103*t100*t146*t148*t1
     =           63)-4.1333333333333333d-52*t100*t304*t50-2.066666666666
     >           6667d-52*t163*t289*t50+5.51111111111111d-52*t181*t200*t
     ?           50+1.2813333333333332d-54*t100*t146*t304*t48+6.40666666
     @           6666666d-55*t146*t163*t289*t48+2.6480888888888887d-106*
     1           t181*t199*t286*t48+5.296177777777777d-106*t100*t149*t16
     2           3*t286*t48-1.708444444444444d-54*t146*t181*t200*t48-8.5
     3           42222222222222d-104*t146*t181*t199-1.7084444444444444d-
     4           103*t100*t146*t149*t163)*t87+1.0d+0*t55*(t56*(-4.784637
     5           4908957684d+0*t133*t263*t65*t82*t85-5.980796863619711d-
     6           2*t464*t60*t61*t82*t85-4.7846374908957684d-1*t133*t291*
     7           t61*t82*t85-7.176956236343652d-1*t170*t266*t61*t82*t85+
     8           1.4353912472687305d+0*t129*t266*t61*t82*t85+2.392318745
     9           4478842d-1*t133*t259*t61*t82*t85-1.1961593727239421d+0*
     :           t170*t263*t60*t82*t85-2.3923187454478842d+0*t129*t263*t
     ;           60*t82*t85+2.3923187454478842d-1*t131*t259*t60*t82*t85+
     <           1.9138549963583074d+0*t131*t133*t170*t82*t85-9.48726982
     =           6154375d-2*t133*t279*t65*t85-3.049479586978192d-2*t142*
     >           t266*t65*t85-2.3718174565385935d-2*t170*t279*t60*t85-4.
     ?           743634913077187d-2*t129*t279*t60*t85+2.541232989148493d
     @           -3*t142*t259*t60*t85+2.0329863913187946d-2*t133*t142*t1
     1           70*t85+7.694644203726144d+0*t118*t119*t133*t244*t61*t65
     2           *t82-1.538928840745229d+1*t119*t133*t236*t241*t61*t65*t
     3           82+2.4749022066811444d+2*t133*t236*t237*t238*t61*t65*t8
     4           2-6.155715362980916d+1*t117*t118*t119*t131*t133*t65*t82
     5           +1.923661050931536d+0*t117*t118*t119*t259*t60*t61*t82+1
     6           .923661050931536d+0*t118*t119*t170*t244*t60*t61*t82+3.8
     7           47322101863072d+0*t118*t119*t129*t244*t60*t61*t82-3.847
     8           322101863072d+0*t119*t170*t236*t241*t60*t61*t82-7.69464
     9           4203726144d+0*t119*t129*t236*t241*t60*t61*t82+6.1872555
     :           16702861d+1*t170*t236*t237*t238*t60*t61*t82+1.237451103
     ;           3405722d+2*t129*t236*t237*t238*t60*t61*t82+1.5389288407
     <           45229d+1*t117*t118*t119*t133*t170*t61*t82-1.53892884074
     =           5229d+1*t117*t118*t119*t131*t170*t60*t82-3.077857681490
     >           458d+1*t117*t118*t119*t129*t131*t60*t82+1.9751631321680
     ?           768d-2*(t475+t474+t473+t472+t471+t470+t469+t468+t467+t4
     @           66+t465+1.923661050931536d+0*t464+t463+t462+t444)*t76*t
     1           80-4.5437964274821163d-4*t107*t272*t80+6.05839523664282
     2           2d-4*t175*t222*t80+1.2116790473285642d-3*t138*t222*t80-
     3           5.848223622634647d-1*t113*t114*t115*t272*t76-5.84822362
     4           2634647d-1*t114*t115*t175*t234*t76-1.1696447245269295d+
     5           0*t114*t115*t138*t234*t76+1.1696447245269295d+0*t115*t1
     6           75*t226*t231*t76+2.339289449053859d+0*t115*t138*t226*t2
     7           31*t76-1.73158960813529d+1*t175*t226*t227*t228*t76-3.46
     8           317921627058d+1*t138*t226*t227*t228*t76-6.21814d-2*(t47
     9           5+t474+t473+t472+t471+t470+t469+t468+t467+t466+t465+t46
     :           3+t462+t444)*t58*t74+2.747773264188437d-3*t107*t268*t74
     ;           -3.663697685584583d-3*t173*t222*t74-7.327395371169166d-
     <           3*t135*t222*t74-6.538889093261956d-1*t117*t118*t119*t13
     =           3*t142*t65-1.6347222733154887d-1*t117*t118*t119*t142*t1
     >           70*t60-3.2694445466309774d-1*t117*t118*t119*t129*t142*t
     ?           60+1.0d+0*t109*t110*t111*t268*t58+1.0d+0*t110*t111*t173
     @           *t224*t58+2.0d+0*t110*t111*t135*t224*t58-2.0d+0*t111*t1
     1           73*t212*t217*t58-4.0d+0*t111*t135*t212*t217*t58+1.60819
     2           79498692536d+1*t173*t212*t213*t214*t58+3.21639589973850
     3           7d+1*t135*t212*t213*t214*t58+t480+t479+t478+t477+t476+t
     4           461+t460+t459+t458+t457+t451+t449+t448+t429+t427+t426+t
     5           425+t424+t423+t422+t421+t420+t419+t418+t417+t416+t415+t
     6           414+t412+t411+t410+t409+t408+t407+t406+t405+t404+t403+t
     7           401+t396+t395+t394+t393+t392+t391+t390+t389+t388+2.6907
     8           28393099896d-2*t107*t113*t114*t115*t175-8.8379266603467
     9           84d-2*t107*t109*t110*t111*t173+5.381456786199792d-2*t10
     :           7*t113*t114*t115*t138-1.767585332069357d-1*t107*t109*t1
     ;           10*t111*t135)-4.7846374908957684d-1*t133*t170*t61*t82*t
     <           85+9.569274981791537d-1*t129*t131*t60*t82*t85+1.0164931
     =           956593973d-2*t129*t142*t60*t85+7.694644203726144d+0*t11
     >           7*t118*t119*t129*t60*t61*t82-1.8175185709928465d-3*t107
     ?           *t138*t80-2.339289449053859d+0*t113*t114*t115*t138*t76+
     @           1.099109305675375d-2*t107*t135*t74+4.0d+0*t109*t110*t11
     1           1*t135*t58+t456+t455+t454+t385+t384+t383+t382+t381+t380
     2           +t379+t378+t377+t376+t375+t374+t373+t372+t371+t370+t369
     3           +t349+t348+t346+t343+t330+t329+t328+t300+t283+t281+t276
     4           +t273+t269+t247)+2.0d+0*t145*t305+2.0d+0*t150*t301+1.0d
     5           +0*t178*t290+1.0d+0*t182*t285)*wght+Amat3(iq,D3_RA_RA_R
     6           B)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*(1.641815111111111d-157*t1
     1           00*t322*t368*t48*t54-7.061570370370369d-106*t100*t286*t
     2           323*t48*t54+2.2779259259259257d-103*t100*t146*t323*t54-
     3           5.296177777777777d-155*t100*t286*t322*t54+3.1d-3*t48*t5
     4           0*(1.641815111111111d-157*t100*t322*t368*t48*t53-7.0615
     5           70370370369d-106*t100*t286*t323*t48*t53+2.2779259259259
     6           257d-103*t100*t146*t323*t53-5.296177777777777d-155*t100
     7           *t286*t322*t53+3.1d-3*t48*t50*(1.641815111111111d-157*t
     8           100*t322*t368*t48*t52-7.061570370370369d-106*t100*t286*
     9           t323*t48*t52+2.2779259259259257d-103*t100*t146*t323*t52
     :           -5.296177777777777d-155*t100*t286*t322*t52+3.1d-3*t48*t
     ;           50*(1.641815111111111d-157*t100*t322*t368*t48*t51-7.061
     <           570370370369d-106*t100*t286*t323*t48*t51+2.277925925925
     =           9257d-103*t100*t146*t323*t51-5.296177777777777d-155*t10
     >           0*t286*t322*t51)-2.0666666666666667d-52*t100*t353*t50+5
     ?           .51111111111111d-52*t147*t323*t50-4.1333333333333333d-5
     @           2*t163*t302*t50+6.406666666666666d-55*t100*t146*t353*t4
     1           8-1.708444444444444d-54*t146*t147*t323*t48+2.6480888888
     2           888887d-106*t147*t286*t322*t48+1.2813333333333332d-54*t
     3           146*t163*t302*t48+5.296177777777777d-106*t100*t163*t179
     4           *t286*t48-8.542222222222222d-104*t146*t147*t322-1.70844
     5           44444444444d-103*t100*t146*t163*t179)-2.066666666666666
     6           7d-52*t100*t354*t50+5.51111111111111d-52*t148*t323*t50-
     7           4.1333333333333333d-52*t163*t303*t50+6.406666666666666d
     8           -55*t100*t146*t354*t48-1.708444444444444d-54*t146*t148*
     9           t323*t48+2.6480888888888887d-106*t148*t286*t322*t48+1.2
     :           813333333333332d-54*t146*t163*t303*t48+5.29617777777777
     ;           7d-106*t100*t163*t180*t286*t48-8.542222222222222d-104*t
     <           146*t148*t322-1.7084444444444444d-103*t100*t146*t163*t1
     =           80)-2.0666666666666667d-52*t100*t355*t50+5.511111111111
     >           11d-52*t149*t323*t50-4.1333333333333333d-52*t163*t304*t
     ?           50+6.406666666666666d-55*t100*t146*t355*t48-1.708444444
     @           444444d-54*t146*t149*t323*t48+2.6480888888888887d-106*t
     1           149*t286*t322*t48+1.2813333333333332d-54*t146*t163*t304
     2           *t48+5.296177777777777d-106*t100*t163*t181*t286*t48-8.5
     3           42222222222222d-104*t146*t149*t322-1.7084444444444444d-
     4           103*t100*t146*t163*t181)*t87+1.0d+0*t55*(t56*(4.7846374
     5           908957684d+0*t133*t263*t65*t82*t85-5.980796863619711d-2
     6           *t481*t60*t61*t82*t85-2.3923187454478842d-1*t133*t336*t
     7           61*t82*t85+4.7846374908957684d-1*t133*t291*t61*t82*t85+
     8           1.4353912472687305d+0*t170*t266*t61*t82*t85-7.176956236
     9           343652d-1*t129*t266*t61*t82*t85+2.3923187454478842d-1*t
     :           131*t336*t60*t82*t85-2.3923187454478842d+0*t170*t263*t6
     ;           0*t82*t85-1.1961593727239421d+0*t129*t263*t60*t82*t85-1
     <           .9138549963583074d+0*t129*t131*t133*t82*t85+9.487269826
     =           154374d-2*t133*t279*t65*t85-3.0494795869781915d-2*t142*
     >           t266*t65*t85+2.541232989148493d-3*t142*t336*t60*t85-4.7
     ?           43634913077187d-2*t170*t279*t60*t85-2.3718174565385935d
     @           -2*t129*t279*t60*t85-2.0329863913187946d-2*t129*t133*t1
     1           42*t85-7.694644203726144d+0*t118*t119*t133*t244*t61*t65
     2           *t82+1.538928840745229d+1*t119*t133*t236*t241*t61*t65*t
     3           82-2.4749022066811444d+2*t133*t236*t237*t238*t61*t65*t8
     4           2+6.155715362980916d+1*t117*t118*t119*t131*t133*t65*t82
     5           +1.923661050931536d+0*t117*t118*t119*t336*t60*t61*t82+3
     6           .847322101863072d+0*t118*t119*t170*t244*t60*t61*t82+1.9
     7           23661050931536d+0*t118*t119*t129*t244*t60*t61*t82-7.694
     8           644203726144d+0*t119*t170*t236*t241*t60*t61*t82-3.84732
     9           2101863072d+0*t119*t129*t236*t241*t60*t61*t82+1.2374511
     :           033405722d+2*t170*t236*t237*t238*t60*t61*t82+6.18725551
     ;           6702861d+1*t129*t236*t237*t238*t60*t61*t82-1.5389288407
     <           45229d+1*t117*t118*t119*t129*t133*t61*t82-3.07785768149
     =           0458d+1*t117*t118*t119*t131*t170*t60*t82-1.538928840745
     >           229d+1*t117*t118*t119*t129*t131*t60*t82+1.9751631321680
     ?           768d-2*(t491+t490+t489+t488+t487+t486+t485+t484+t483+t4
     @           82+1.923661050931536d+0*t481+t474+t462+t447+t444)*t76*t
     1           80-4.5437964274821163d-4*t107*t344*t80+1.21167904732856
     2           42d-3*t175*t222*t80+6.058395236642822d-4*t138*t222*t80-
     3           5.848223622634647d-1*t113*t114*t115*t344*t76-1.16964472
     4           45269295d+0*t114*t115*t175*t234*t76-5.848223622634647d-
     5           1*t114*t115*t138*t234*t76+2.339289449053859d+0*t115*t17
     6           5*t226*t231*t76+1.1696447245269295d+0*t115*t138*t226*t2
     7           31*t76-3.46317921627058d+1*t175*t226*t227*t228*t76-1.73
     8           158960813529d+1*t138*t226*t227*t228*t76-6.21814d-2*(t49
     9           1+t490+t489+t488+t487+t486+t485+t484+t483+t482+t474+t46
     :           2+t447+t444)*t58*t74+2.747773264188437d-3*t107*t341*t74
     ;           -7.327395371169166d-3*t173*t222*t74-3.663697685584583d-
     <           3*t135*t222*t74+6.538889093261955d-1*t117*t118*t119*t13
     =           3*t142*t65-3.2694445466309774d-1*t117*t118*t119*t142*t1
     >           70*t60-1.6347222733154887d-1*t117*t118*t119*t129*t142*t
     ?           60+1.0d+0*t109*t110*t111*t341*t58+2.0d+0*t110*t111*t173
     @           *t224*t58+1.0d+0*t110*t111*t135*t224*t58-4.0d+0*t111*t1
     1           73*t212*t217*t58-2.0d+0*t111*t135*t212*t217*t58+3.21639
     2           5899738507d+1*t173*t212*t213*t214*t58+1.608197949869253
     3           6d+1*t135*t212*t213*t214*t58+t479+t478+t477+t476+t461+t
     4           460+t459+t458+t457+t453+t451+t449+t448+t429+t427+t426+t
     5           425+t424+t423+t422+t421+t420+t419+t418+t417+t416+t415+t
     6           414+t412+t411+t410+t409+t408+t407+t406+t405+t404+t403+t
     7           401+t396+t395+t394+t393+t392+t391+t390+t389+t388+5.3814
     8           56786199792d-2*t107*t113*t114*t115*t175-1.7675853320693
     9           57d-1*t107*t109*t110*t111*t173+2.690728393099896d-2*t10
     :           7*t113*t114*t115*t138-8.837926660346784d-2*t107*t109*t1
     ;           10*t111*t135)+4.7846374908957684d-1*t129*t133*t61*t82*t
     <           85+9.569274981791537d-1*t131*t170*t60*t82*t85+1.0164931
     =           956593973d-2*t142*t170*t60*t85+7.694644203726144d+0*t11
     >           7*t118*t119*t170*t60*t61*t82-1.8175185709928465d-3*t107
     ?           *t175*t80-2.339289449053859d+0*t113*t114*t115*t175*t76+
     @           1.099109305675375d-2*t107*t173*t74+4.0d+0*t109*t110*t11
     1           1*t173*t58+t456+t455+t454+t385+t384+t383+t382+t381+t380
     2           +t379+t378+t377+t376+t375+t374+t373+t372+t371+t370+t369
     3           +t351+t350+t347+t345+t342+t331+t300+t278+t277+t274+t270
     4           +t240+t230+t216)+1.0d+0*t145*t356+1.0d+0*t150*t352+2.0d
     5           +0*t178*t305+2.0d+0*t182*t301)*wght+Amat3(iq,D3_RA_RB_R
     6           B)
              Amat3(iq,D3_RB_RB_RB) = (1.0d+0*(-2.0207407407407404d-51*t
     1           50*t502*t54+6.264296296296294d-54*t146*t48*t502*t54-2.1
     2           18471111111111d-105*t286*t48*t501*t54+6.833777777777776
     3           d-103*t146*t501*t54+1.641815111111111d-157*t368*t48*t50
     4           0*t54-5.296177777777777d-155*t286*t500*t54+3.1d-3*t48*t
     5           50*(-2.0207407407407404d-51*t50*t502*t53+6.264296296296
     6           294d-54*t146*t48*t502*t53-2.118471111111111d-105*t286*t
     7           48*t501*t53+6.833777777777776d-103*t146*t501*t53+1.6418
     8           15111111111d-157*t368*t48*t500*t53-5.296177777777777d-1
     9           55*t286*t500*t53+3.1d-3*t48*t50*(-2.0207407407407404d-5
     :           1*t50*t502*t52+6.264296296296294d-54*t146*t48*t502*t52-
     ;           2.118471111111111d-105*t286*t48*t501*t52+6.833777777777
     <           776d-103*t146*t501*t52+1.641815111111111d-157*t368*t48*
     =           t500*t52-5.296177777777777d-155*t286*t500*t52+3.1d-3*t4
     >           8*t50*(-2.0207407407407404d-51*t50*t502*t51+6.264296296
     ?           296294d-54*t146*t48*t502*t51-2.118471111111111d-105*t28
     @           6*t48*t501*t51+6.833777777777776d-103*t146*t501*t51+1.6
     1           41815111111111d-157*t368*t48*t500*t51-5.296177777777777
     2           d-155*t286*t500*t51)-6.2d-52*t163*t353*t50+1.6533333333
     3           333333d-51*t179*t323*t50+1.9219999999999998d-54*t146*t1
     4           63*t353*t48-5.125333333333332d-54*t146*t179*t323*t48+7.
     5           944266666666666d-106*t179*t286*t322*t48-2.5626666666666
     6           664d-103*t146*t179*t322)-6.2d-52*t163*t354*t50+1.653333
     7           3333333333d-51*t180*t323*t50+1.9219999999999998d-54*t14
     8           6*t163*t354*t48-5.125333333333332d-54*t146*t180*t323*t4
     9           8+7.944266666666666d-106*t180*t286*t322*t48-2.562666666
     :           6666664d-103*t146*t180*t322)-6.2d-52*t163*t355*t50+1.65
     ;           33333333333333d-51*t181*t323*t50+1.9219999999999998d-54
     <           *t146*t163*t355*t48-5.125333333333332d-54*t146*t181*t32
     =           3*t48+7.944266666666666d-106*t181*t286*t322*t48-2.56266
     >           66666666664d-103*t146*t181*t322)*t87+1.0d+0*t55*(t56*(1
     ?           .4353912472687305d+1*t133*t263*t65*t82*t85-5.9807968636
     @           19711d-2*t503*t60*t61*t82*t85+7.176956236343652d-1*t133
     1           *t336*t61*t82*t85-2.1530868709030954d+0*t170*t266*t61*t
     2           82*t85+7.176956236343652d-1*t131*t336*t60*t82*t85-3.588
     3           478118171826d+0*t170*t263*t60*t82*t85-5.741564989074922
     4           d+0*t131*t133*t170*t82*t85+2.8461809478463124d-1*t133*t
     5           279*t65*t85+7.623698967445479d-3*t142*t336*t60*t85-7.11
     6           545236961578d-2*t170*t279*t60*t85-6.098959173956384d-2*
     7           t133*t142*t170*t85-2.3083932611178434d+1*t118*t119*t133
     8           *t244*t61*t65*t82+4.616786522235687d+1*t119*t133*t236*t
     9           241*t61*t65*t82-7.424706620043432d+2*t133*t236*t237*t23
     :           8*t61*t65*t82+1.8467146088942746d+2*t117*t118*t119*t131
     ;           *t133*t65*t82+5.770983152794609d+0*t117*t118*t119*t336*
     <           t60*t61*t82+5.770983152794609d+0*t118*t119*t170*t244*t6
     =           0*t61*t82-1.1541966305589217d+1*t119*t170*t236*t241*t60
     >           *t61*t82+1.856176655010858d+2*t170*t236*t237*t238*t60*t
     ?           61*t82-4.616786522235687d+1*t117*t118*t119*t133*t170*t6
     @           1*t82-4.616786522235687d+1*t117*t118*t119*t131*t170*t60
     1           *t82+1.9751631321680768d-2*(t510+t509+t508+t507+t506+t5
     2           05+t504+1.923661050931536d+0*t503+t475+t446+t444)*t76*t
     3           80-1.363138928244635d-3*t107*t344*t80+1.817518570992846
     4           5d-3*t175*t222*t80-1.7544670867903941d+0*t113*t114*t115
     5           *t344*t76-1.7544670867903941d+0*t114*t115*t175*t234*t76
     6           +3.5089341735807883d+0*t115*t175*t226*t231*t76-5.194768
     7           82440587d+1*t175*t226*t227*t228*t76-6.21814d-2*(t510+t5
     8           09+t508+t507+t506+t505+t504+t475+t446+t444)*t58*t74+8.2
     9           43319792565312d-3*t107*t341*t74-1.099109305675375d-2*t1
     :           73*t222*t74+1.9616667279785865d+0*t117*t118*t119*t133*t
     ;           142*t65-4.904166819946466d-1*t117*t118*t119*t142*t170*t
     <           60+3.0d+0*t109*t110*t111*t341*t58+3.0d+0*t110*t111*t173
     =           *t224*t58-6.0d+0*t111*t173*t212*t217*t58+4.824593849607
     >           761d+1*t173*t212*t213*t214*t58+t480+t452+t451+t450+t449
     ?           +t448+t429+t428+t427+t426+t425+t424+t423+t422+t421+t420
     @           +t419+t418+t417+t416+t415+t414+t412+t411+t410+t409+t408
     1           +t407+t406+t405+t404+t403+t401+t396+t395+t394+t393+t392
     2           +t391+t390+t389+t388+8.072185179299687d-2*t107*t113*t11
     3           4*t115*t175-2.6513779981040353d-1*t107*t109*t110*t111*t
     4           173)-5.741564989074922d+0*t131*t133*t65*t82*t85-1.79423
     5           9059085913d-1*t336*t60*t61*t82*t85+1.4353912472687305d+
     6           0*t133*t170*t61*t82*t85+1.4353912472687305d+0*t131*t170
     7           *t60*t82*t85-6.098959173956384d-2*t133*t142*t65*t85+1.5
     8           24739793489096d-2*t142*t170*t60*t85-4.616786522235687d+
     9           1*t117*t118*t119*t133*t61*t65*t82+1.1541966305589217d+1
     :           *t117*t118*t119*t170*t60*t61*t82+5.92548939650423d-2*t3
     ;           44*t76*t80-2.72627785648927d-3*t107*t175*t80-3.50893417
     <           35807883d+0*t113*t114*t115*t175*t76-1.865442d-1*t341*t5
     =           8*t74+1.6486639585130625d-2*t107*t173*t74+6.0d+0*t109*t
     >           110*t111*t173*t58-rhob*t497-3.3306690738754696d-16*t151
     ?           *t156*t313*t46+6.661338147750939d-16*t151*t307*t309*t46
     @           -5.356375176299456d-15*t306*t307*t308*t46+1.22025645774
     1           05706d-18*t311*t45-3.0d+0*t157*t159*t318*t42+6.0d+0*t15
     2           7*t315*t317*t42-9.649187699215522d+1*t314*t315*t316*t42
     3           +5.284159572535705d-3*t311*t41+t386+t385+t384+t383+t382
     4           +t381+t380+t379+t378+t377+t376+t375+t374+t373+t372+t371
     5           +t370+t369+2.549392377400174d-1*t153*t157*t158*t159+2.9
     6           43620900479655d-17*t151*t153*t155*t156)+5.0d-1*rhob*t47
     7           *(2.4d-51*t27*t29*(2.4d-51*t27*t29*(2.4d-51*t27*t29*(-3
     8           .911111111111111d-50*t29*t502*t8+3.4986666666666666d-10
     9           0*t161*t501*t8-9.984000000000001d-151*t320*t500*t8+9.21
     :           6000000000001d-202*t498*t499*t8)-3.911111111111111d-50*
     ;           t29*t30*t502+3.4986666666666666d-100*t161*t30*t501-9.98
     <           4000000000001d-151*t30*t320*t500+9.216000000000001d-202
     =           *t30*t498*t499-1.2d-50*t163*t29*t324+2.88d-101*t161*t16
     >           2*t324+3.2d-50*t164*t29*t323-1.7279999999999998d-100*t1
     ?           61*t164*t322+2.3040000000000002d-151*t164*t320*t321)-3.
     @           911111111111111d-50*t29*t31*t502+3.4986666666666666d-10
     1           0*t161*t31*t501-9.984000000000001d-151*t31*t320*t500+9.
     2           216000000000001d-202*t31*t498*t499-1.2d-50*t163*t29*t32
     3           5+2.88d-101*t161*t162*t325+3.2d-50*t165*t29*t323-1.7279
     4           999999999998d-100*t161*t165*t322+2.3040000000000002d-15
     5           1*t165*t320*t321)-3.911111111111111d-50*t29*t32*t502+3.
     6           4986666666666666d-100*t161*t32*t501-9.984000000000001d-
     7           151*t32*t320*t500+9.216000000000001d-202*t32*t498*t499-
     8           1.2d-50*t163*t29*t326+2.88d-101*t161*t162*t326+3.2d-50*
     9           t166*t29*t323-1.7279999999999998d-100*t161*t166*t322+2.
     :           3040000000000002d-151*t166*t320*t321)+5.0d-1*rhob*t33*t
     ;           497+1.5d+0*t327*t47+3.0d+0*t178*t356+3.0d+0*t182*t352+1
     <           .5d+0*t319*t33+1.5d+0*rhob*t160*t327+1.5d+0*rhob*t167*t
     =           319+3.0d+0*t160*t167)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/t19
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammaaa**2
              t38 = 1/t2**2
              t39 = 1/rhoa**6.333333333333333d+0
              t40 = 1/rhoa**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammaaa*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammaaa*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammaaa*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammaaa*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammaaa*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammaaa*t1*t3*t43
              t45 = -1.25d-1*t22*t8*wght
              t46 = 1/rhoa**5.333333333333333d+0
              t47 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t38*t4*t46
              t48 = -3.6d-3*gammaaa*t38*t46*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmaaa*t1*t3*t47
              t49 = -3.6d-3*gammaaa*t38*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmaaa*t1*t3*t48
              t50 = -3.6d-3*gammaaa*t38*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t49
              t51 = 1/taua**2
              t52 = 1/rhoa**2
              t53 = 1/t19**2
              t54 = t31**2
              t55 = 1/t18**4
              t56 = 1/t18**3
              t57 = 1/t10**5
              t58 = 1/rhoa**2.3333333333333334d+0
              t59 = 1/rhoa**2.1666666666666665d+0
              t60 = 1.1632736958443765d+0*t59+9.89141964955861d-1*t58+6.
     1           003214762495226d-1*t57+2.1077825841639536d-1*t1
              t61 = 1/t15**2
              t62 = t34**2
              t63 = 1/t14**4
              t64 = 1/t14**3
              t65 = 2.1622951122684114d+0*t59+1.7087761055320938d+0*t58+
     1           1.2335503316757068d+0*t57+2.673190323653546d-1*t1
              t66 = 1.0d+0*t17*t33*t35*t65-2.0d+0*t17*t33*t62*t64+3.2163
     1           95899738507d+1*t17*t61*t62*t63+1.1102230246251565d-16*t
     2           21*t26*t32*t60-4.0675215258019015d-19*t20*t58-1.7613865
     3           241785684d-3*t16*t58-2.220446049250313d-16*t21*t26*t54*
     4           t56+1.7854583920998188d-15*t21*t53*t54*t55-8.4979745913
     5           33913d-2*t29*t33*t34*t35-9.812069668265515d-18*t26*t29*
     6           t31*t32
              t67 = gammaaa**3
              t68 = 1/t2**3
              t69 = 1/rhoa**10
              t70 = 1/rhoa**7.333333333333333d+0
              t71 = 1/rhoa**4.666666666666667d+0
              t72 = 5.866666666666666d-1*gammaaa*t3*t4*t71-8.63999999999
     1           9998d-2*t37*t38*t4*t70+3.0719999999999986d-3*t4*t67*t68
     2           *t69
              t73 = 6.0d-2*gammaaa*t1*t3*t72+5.866666666666666d-1*gammaa
     1           a*t3*t5*t71-8.639999999999998d-2*t37*t38*t5*t70+3.07199
     2           99999999986d-3*t5*t67*t68*t69-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t41+1.9199999999999995d-2*t37*t38*t39*t41
              t74 = 6.0d-2*gammaaa*t1*t3*t73+5.866666666666666d-1*gammaa
     1           a*t3*t6*t71-8.639999999999998d-2*t37*t38*t6*t70+3.07199
     2           99999999986d-3*t6*t67*t68*t69-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t42+1.9199999999999995d-2*t37*t38*t39*t42
              t75 = 6.0d-2*gammaaa*t1*t3*t74+5.866666666666666d-1*gammaa
     1           a*t3*t7*t71-8.639999999999998d-2*t37*t38*t7*t70+3.07199
     2           99999999986d-3*t67*t68*t69*t7-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t43+1.9199999999999995d-2*t37*t38*t39*t43
              t76 = 1.25d-1*t22*t8*wght
              t77 = 1/rhoa**9
              t78 = -1.1519999999999996d-3*t37*t4*t68*t77-1.599999999999
     1           9998d-1*t3*t4*t40+2.879999999999999d-2*gammaaa*t38*t39*
     2           t4
              t79 = 6.0d-2*gammaaa*t1*t3*t78-1.1519999999999996d-3*t37*t
     1           5*t68*t77-1.5999999999999998d-1*t3*t40*t5+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t5-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t47+9.599999999999997d-3*t37*t38*t39*t47-3.6d-
     4           3*gammaaa*t38*t41*t46+6.0d-2*t1*t3*t41
              t80 = 6.0d-2*gammaaa*t1*t3*t79-1.1519999999999996d-3*t37*t
     1           6*t68*t77-1.5999999999999998d-1*t3*t40*t6+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t6-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t48+9.599999999999997d-3*t37*t38*t39*t48-3.6d-
     4           3*gammaaa*t38*t42*t46+6.0d-2*t1*t3*t42
              t81 = 6.0d-2*gammaaa*t1*t3*t80-1.1519999999999996d-3*t37*t
     1           68*t7*t77-1.5999999999999998d-1*t3*t40*t7+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t7-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t49+9.599999999999997d-3*t37*t38*t39*t49-3.6d-
     4           3*gammaaa*t38*t43*t46+6.0d-2*t1*t3*t43
              t82 = 1/rhoa**8
              t83 = 4.32d-4*gammaaa*t4*t68*t82-7.2d-3*t38*t4*t46
              t84 = 6.0d-2*gammaaa*t1*t3*t83+4.32d-4*gammaaa*t5*t68*t82-
     1           7.2d-3*t38*t46*t5-7.2d-3*gammaaa*t38*t46*t47+1.2d-1*t1*
     2           t3*t47
              t85 = 6.0d-2*gammaaa*t1*t3*t84+4.32d-4*gammaaa*t6*t68*t82-
     1           7.2d-3*t38*t46*t6-7.2d-3*gammaaa*t38*t46*t48+1.2d-1*t1*
     2           t3*t48
              t86 = 6.0d-2*gammaaa*t1*t3*t85+4.32d-4*gammaaa*t68*t7*t82-
     1           7.2d-3*t38*t46*t7-7.2d-3*gammaaa*t38*t46*t49+1.2d-1*t1*
     2           t3*t49
              t87 = -5.0d-1*rhoa*t25*t36*t8*wght-5.0d-1*t22*t25*t8*wght-
     1           5.0d-1*rhoa*t22*t25*t44*wght
              t88 = t76-5.0d-1*rhoa*t22*t25*t50*wght
              t89 = 1/taua**3
              t90 = 1/rhoa**3
              t91 = t31**3
              t92 = 1/t10**7
              t93 = 1/rhoa**3.3333333333333337d+0
              t94 = 1/rhoa**3.1666666666666665d+0
              t95 = t34**3
              t96 = gammaaa**4
              t97 = 1/t2**4
              t98 = 1/rhoa**1.3666666666666666d+1
              t99 = 1/rhoa**11
              t100 = 1/rhoa**8.333333333333334d+0
              t101 = 1/rhoa**5.666666666666667d+0
              t102 = 1.25d-1*t36*t8*wght
              t103 = 1.25d-1*t22*t44*wght
              t104 = t45-1.25d-1*gammaaa*t22*t50*wght
              t105 = 1/rhoa**1.2666666666666665d+1
              t106 = 2.5d-1*t22*t50*wght
              t107 = 1/rhoa**1.1666666666666665d+1
              t108 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhoa*t22*t25*t44*wght)+1.25d-1*ga
     2           mmaaa*t22*t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*t50*wght+t45)+C
     1           mat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t51*t8*wght+1.0d+0*r
     1           hoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t23*(5.0d-1*rhoa*t25*t66*t8*wght+1.25
     1           d-1*gammaaa*t22*t52*t8*wght+1.0d+0*t25*t36*t8*wght+1.25
     2           d-1*gammaaa*t24*t36*t8*wght+5.0d-1*rhoa*t22*t25*t75*wgh
     3           t+1.0d+0*rhoa*t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+
     4           1.25d-1*gammaaa*t22*t24*t44*wght)+t23*t24*(1.25d-1*gamm
     5           aaa*t36*t8*wght+1.25d-1*gammaaa*t22*t44*wght)-1.25d-1*g
     6           ammaaa*t22*t23*t52*t8*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t23*(5.0d-1*rhoa*t22*t25*t81*wght-1.
     1           25d-1*t36*t8*wght-1.25d-1*t22*t24*t8*wght+5.0d-1*rhoa*t
     2           25*t36*t50*wght+5.0d-1*t22*t25*t50*wght-1.25d-1*t22*t44
     3           *wght)+t23*t24*(1.25d-1*gammaaa*t22*t50*wght+t76)+Cmat2
     4           (iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*t86*wght-2
     1           .5d-1*t22*t50*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t23*(1.0d+0*rhoa*t36*t8*wght+1.0d+0*t
     1           22*t8*wght+1.0d+0*rhoa*t22*t44*wght)-1.25d-1*gammaaa*t2
     2           2*t24*t51*t8*wght+t51*t87+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.0d+0*rhoa*t22*t23*t50*wght+t51*t88
     1           +Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t22*t25*t8*t89*wght-2.0d+
     1           0*rhoa*t22*t51*t8*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*g
     1           ammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t
     2           3*(-5.836799999999998d-2*t4*t67*t68*t99+1.4745599999999
     3           992d-3*t4*t96*t97*t98+7.274666666666665d-1*t100*t37*t38
     4           *t4-2.737777777777778d+0*gammaaa*t101*t3*t4)-5.83679999
     5           9999998d-2*t5*t67*t68*t99+1.4745599999999992d-3*t5*t96*
     6           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t72+2.87999
     7           9999999999d-2*t37*t38*t39*t72+1.76d+0*gammaaa*t3*t41*t7
     8           1-2.5919999999999993d-1*t37*t38*t41*t70+9.2159999999999
     9           96d-3*t41*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     :           *t5-2.737777777777778d+0*gammaaa*t101*t3*t5)-5.83679999
     ;           9999998d-2*t6*t67*t68*t99+1.4745599999999992d-3*t6*t96*
     <           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t73+2.87999
     =           9999999999d-2*t37*t38*t39*t73+1.76d+0*gammaaa*t3*t42*t7
     >           1-2.5919999999999993d-1*t37*t38*t42*t70+9.2159999999999
     ?           96d-3*t42*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     @           *t6-2.737777777777778d+0*gammaaa*t101*t3*t6)-5.83679999
     1           9999998d-2*t67*t68*t7*t99+1.4745599999999992d-3*t7*t96*
     2           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t74+2.87999
     3           9999999999d-2*t37*t38*t39*t74+1.76d+0*gammaaa*t3*t43*t7
     4           1-2.5919999999999993d-1*t37*t38*t43*t70+7.2746666666666
     5           65d-1*t100*t37*t38*t7-2.737777777777778d+0*gammaaa*t101
     6           *t3*t7+9.215999999999996d-3*t43*t67*t68*t69)*wght+5.0d-
     7           1*rhoa*t25*t8*(6.0d+0*t17*t33*t63*t95-1.929837539843104
     8           5d+2*t17*t61*t95/t14**5+2.0690405167709364d+3*t17*t95/(
     9           t14**6*t15**3)+1.1102230246251565d-16*t21*t26*t32*(-2.5
     :           20426340996149d+0*t94-2.3079979182303428d+0*t93-1.50080
     ;           36906238065d+0*t92-5.620753557770543d-1*t40)+1.0d+0*t17
     <           *t33*t35*(-4.684972743248224d+0*t94-3.9871442462415524d
     =           +0*t93-3.083875829189267d+0*t92-7.128507529742789d-1*t4
     >           0)+9.490883560204437d-19*t20*t93+4.1099018897499934d-3*
     ?           t16*t93+6.661338147750939d-16*t21*t26*t55*t91-1.0712750
     @           352598913d-14*t21*t53*t91/t18**5+5.742741051503565d-14*
     1           t21*t91/(t18**6*t19**3)-6.0d+0*t17*t33*t34*t64*t65+9.64
     2           9187699215522d+1*t17*t34*t61*t63*t65-1.274696188700087d
     3           -1*t29*t33*t35*t65+2.549392377400174d-1*t29*t33*t62*t64
     4           -4.0999275947472624d+0*t29*t61*t62*t63-6.66133814775093
     5           9d-16*t21*t26*t31*t56*t60+5.356375176299456d-15*t21*t31
     6           *t53*t55*t60-1.4718104502398274d-17*t26*t29*t32*t60+1.6
     7           995949182667827d-1*t33*t34*t35*t58+1.962413933653103d-1
     8           7*t26*t31*t32*t58+2.943620900479655d-17*t26*t29*t54*t56
     9           -2.3669625486718335d-16*t29*t53*t54*t55)*wght-2.5d-1*ga
     :           mmaaa*t22*t8*t90*wght+1.5d+0*t25*t66*t8*wght+2.5d-1*gam
     ;           maaa*t24*t66*t8*wght+2.5d-1*gammaaa*t36*t52*t8*wght+1.5
     <           d+0*rhoa*t25*t36*t75*wght+1.5d+0*t22*t25*t75*wght+2.5d-
     =           1*gammaaa*t22*t24*t75*wght+1.5d+0*rhoa*t25*t44*t66*wght
     >           +2.5d-1*gammaaa*t22*t44*t52*wght+3.0d+0*t25*t36*t44*wgh
     ?           t+5.0d-1*gammaaa*t24*t36*t44*wght)+t23*t24*(1.25d-1*gam
     @           maaa*t66*t8*wght+1.25d-1*gammaaa*t22*t75*wght+2.5d-1*ga
     1           mmaaa*t36*t44*wght)+t23*t52*(-2.5d-1*gammaaa*t36*t8*wgh
     2           t-2.5d-1*gammaaa*t22*t44*wght)+2.5d-1*gammaaa*t22*t23*t
     3           8*t90*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*
     1           gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*
     2           t3*(-5.529599999999998d-4*t105*t4*t67*t97+5.86666666666
     3           6666d-1*t3*t4*t71-2.0799999999999996d-1*gammaaa*t38*t4*
     4           t70+1.9583999999999993d-2*t37*t4*t68*t69)-5.52959999999
     5           9998d-4*t105*t5*t67*t97-3.1999999999999995d-1*gammaaa*t
     6           3*t40*t78+1.9199999999999995d-2*t37*t38*t39*t78-2.30399
     7           9999999999d-3*t37*t41*t68*t77-3.6d-3*gammaaa*t38*t46*t7
     8           2+6.0d-2*t1*t3*t72+5.866666666666666d-1*t3*t5*t71+5.866
     9           666666666666d-1*gammaaa*t3*t47*t71-2.0799999999999996d-
     :           1*gammaaa*t38*t5*t70-8.639999999999998d-2*t37*t38*t47*t
     ;           70+3.0719999999999986d-3*t47*t67*t68*t69+1.958399999999
     <           9993d-2*t37*t5*t68*t69-3.1999999999999995d-1*t3*t40*t41
     =           +5.759999999999998d-2*gammaaa*t38*t39*t41)-5.5295999999
     >           99998d-4*t105*t6*t67*t97-3.1999999999999995d-1*gammaaa*
     ?           t3*t40*t79+1.9199999999999995d-2*t37*t38*t39*t79-2.3039
     @           99999999999d-3*t37*t42*t68*t77-3.6d-3*gammaaa*t38*t46*t
     1           73+6.0d-2*t1*t3*t73+5.866666666666666d-1*t3*t6*t71+5.86
     2           6666666666666d-1*gammaaa*t3*t48*t71-2.0799999999999996d
     3           -1*gammaaa*t38*t6*t70-8.639999999999998d-2*t37*t38*t48*
     4           t70+3.0719999999999986d-3*t48*t67*t68*t69+1.95839999999
     5           99993d-2*t37*t6*t68*t69-3.1999999999999995d-1*t3*t40*t4
     6           2+5.759999999999998d-2*gammaaa*t38*t39*t42)-5.529599999
     7           999998d-4*t105*t67*t7*t97-3.1999999999999995d-1*gammaaa
     8           *t3*t40*t80+1.9199999999999995d-2*t37*t38*t39*t80-2.303
     9           999999999999d-3*t37*t43*t68*t77-3.6d-3*gammaaa*t38*t46*
     :           t74+6.0d-2*t1*t3*t74+5.866666666666666d-1*t3*t7*t71+5.8
     ;           66666666666666d-1*gammaaa*t3*t49*t71-2.0799999999999996
     <           d-1*gammaaa*t38*t7*t70-8.639999999999998d-2*t37*t38*t49
     =           *t70+1.9583999999999993d-2*t37*t68*t69*t7+3.07199999999
     >           99986d-3*t49*t67*t68*t69-3.1999999999999995d-1*t3*t40*t
     ?           43+5.759999999999998d-2*gammaaa*t38*t39*t43)*wght+1.0d+
     @           0*rhoa*t25*t36*t81*wght+1.0d+0*t22*t25*t81*wght+1.25d-1
     1           *gammaaa*t22*t24*t81*wght-1.25d-1*t66*t8*wght+1.25d-1*t
     2           22*t52*t8*wght-1.25d-1*t24*t36*t8*wght-1.25d-1*t22*t75*
     3           wght+5.0d-1*rhoa*t25*t50*t66*wght+1.25d-1*gammaaa*t22*t
     4           50*t52*wght+1.0d+0*t25*t36*t50*wght+1.25d-1*gammaaa*t24
     5           *t36*t50*wght-2.5d-1*t36*t44*wght-1.25d-1*t22*t24*t44*w
     6           ght)+t23*t24*(1.25d-1*gammaaa*t22*t81*wght+1.25d-1*gamm
     7           aaa*t36*t50*wght+t103+t102)+t104*t23*t52+Cmat3(iq,D3_RA
     8           _RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2
     1           *gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1
     2           *t3*(2.073599999999999d-4*t107*t37*t4*t97-5.75999999999
     3           9997d-3*gammaaa*t4*t68*t77+3.839999999999999d-2*t38*t39
     4           *t4)+2.073599999999999d-4*t107*t37*t5*t97-1.59999999999
     5           99998d-1*gammaaa*t3*t40*t83+9.599999999999997d-3*t37*t3
     6           8*t39*t83+4.32d-4*gammaaa*t41*t68*t82-7.2d-3*gammaaa*t3
     7           8*t46*t78+1.2d-1*t1*t3*t78-5.759999999999997d-3*gammaaa
     8           *t5*t68*t77-2.303999999999999d-3*t37*t47*t68*t77+3.8399
     9           99999999999d-2*t38*t39*t5-3.1999999999999995d-1*t3*t40*
     :           t47+5.759999999999998d-2*gammaaa*t38*t39*t47-7.2d-3*t38
     ;           *t41*t46)+2.073599999999999d-4*t107*t37*t6*t97-1.599999
     <           9999999998d-1*gammaaa*t3*t40*t84+9.599999999999997d-3*t
     =           37*t38*t39*t84+4.32d-4*gammaaa*t42*t68*t82-7.2d-3*gamma
     >           aa*t38*t46*t79+1.2d-1*t1*t3*t79-5.759999999999997d-3*ga
     ?           mmaaa*t6*t68*t77-2.303999999999999d-3*t37*t48*t68*t77+3
     @           .839999999999999d-2*t38*t39*t6-3.1999999999999995d-1*t3
     1           *t40*t48+5.759999999999998d-2*gammaaa*t38*t39*t48-7.2d-
     2           3*t38*t42*t46)+2.073599999999999d-4*t107*t37*t7*t97-1.5
     3           999999999999998d-1*gammaaa*t3*t40*t85+9.599999999999997
     4           d-3*t37*t38*t39*t85+4.32d-4*gammaaa*t43*t68*t82-7.2d-3*
     5           gammaaa*t38*t46*t80+1.2d-1*t1*t3*t80-5.759999999999997d
     6           -3*gammaaa*t68*t7*t77-2.303999999999999d-3*t37*t49*t68*
     7           t77+3.839999999999999d-2*t38*t39*t7-3.1999999999999995d
     8           -1*t3*t40*t49+5.759999999999998d-2*gammaaa*t38*t39*t49-
     9           7.2d-3*t38*t43*t46)*wght+5.0d-1*rhoa*t25*t36*t86*wght+5
     :           .0d-1*t22*t25*t86*wght-2.5d-1*t22*t81*wght-2.5d-1*t36*t
     ;           50*wght-2.5d-1*t22*t24*t50*wght)+t23*t24*(1.25d-1*gamma
     <           aa*t22*t86*wght+t106)+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-
     1           2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t
     2           1*t3*(1.296d-3*t4*t68*t82-7.776d-5*gammaaa*t108*t4*t97)
     3           -7.776d-5*gammaaa*t108*t5*t97-1.0800000000000001d-2*gam
     4           maaa*t38*t46*t83+1.8d-1*t1*t3*t83+1.296d-3*t5*t68*t82+1
     5           .296d-3*gammaaa*t47*t68*t82-2.1600000000000003d-2*t38*t
     6           46*t47)-7.776d-5*gammaaa*t108*t6*t97-1.0800000000000001
     7           d-2*gammaaa*t38*t46*t84+1.8d-1*t1*t3*t84+1.296d-3*t6*t6
     8           8*t82+1.296d-3*gammaaa*t48*t68*t82-2.1600000000000003d-
     9           2*t38*t46*t48)-7.776d-5*gammaaa*t108*t7*t97-1.080000000
     :           0000001d-2*gammaaa*t38*t46*t85+1.8d-1*t1*t3*t85+1.296d-
     ;           3*t68*t7*t82+1.296d-3*gammaaa*t49*t68*t82-2.16000000000
     <           00003d-2*t38*t46*t49)*wght-3.75d-1*t22*t86*wght)+Cmat3(
     =           iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = t51*(-5.0d-1*rhoa*t25*t66*t8*wght-
     1           1.25d-1*gammaaa*t22*t52*t8*wght-1.0d+0*t25*t36*t8*wght-
     2           1.25d-1*gammaaa*t24*t36*t8*wght-5.0d-1*rhoa*t22*t25*t75
     3           *wght-1.0d+0*rhoa*t25*t36*t44*wght-1.0d+0*t22*t25*t44*w
     4           ght-1.25d-1*gammaaa*t22*t24*t44*wght)+t23*(1.0d+0*rhoa*
     5           t66*t8*wght+2.0d+0*t36*t8*wght+1.0d+0*rhoa*t22*t75*wght
     6           +2.0d+0*rhoa*t36*t44*wght+2.0d+0*t22*t44*wght)+t24*t51*
     7           (-1.25d-1*gammaaa*t36*t8*wght-1.25d-1*gammaaa*t22*t44*w
     8           ght)+1.25d-1*gammaaa*t22*t51*t52*t8*wght+Mmat3(iq,D3_RA
     9           _RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = t51*(-5.0d-1*rhoa*t22*t25*t81*wgh
     1           t+1.25d-1*t22*t24*t8*wght-5.0d-1*rhoa*t25*t36*t50*wght-
     2           5.0d-1*t22*t25*t50*wght+t103+t102)+t23*(1.0d+0*rhoa*t22
     3           *t81*wght+1.0d+0*rhoa*t36*t50*wght+1.0d+0*t22*t50*wght)
     4           +t104*t24*t51+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = t51*(t106-5.0d-1*rhoa*t22*t25*t8
     1           6*wght)+1.0d+0*rhoa*t22*t23*t86*wght+Mmat3(iq,D3_GAA_GA
     2           A_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = t51*(-2.0d+0*rhoa*t36*t8*wght-2.0d
     1           +0*t22*t8*wght-2.0d+0*rhoa*t22*t44*wght)+2.5d-1*gammaaa
     2           *t22*t24*t8*t89*wght-2*t87*t89+Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = -2.0d+0*rhoa*t22*t50*t51*wght-2*t
     1           88*t89+Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -3.0d+0*rhoa*t22*t25*t8*wght/taua*
     1           *4+6.0d+0*rhoa*t22*t8*t89*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1/t19
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammaaa**2
              t38 = 1/t2**2
              t39 = 1/rhoa**6.333333333333333d+0
              t40 = 1/rhoa**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammaaa*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammaaa*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammaaa*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammaaa*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammaaa*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammaaa*t1*t3*t43
              t45 = -1.25d-1*t22*t8*wght
              t46 = 1/rhoa**5.333333333333333d+0
              t47 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t38*t4*t46
              t48 = -3.6d-3*gammaaa*t38*t46*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmaaa*t1*t3*t47
              t49 = -3.6d-3*gammaaa*t38*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmaaa*t1*t3*t48
              t50 = -3.6d-3*gammaaa*t38*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t49
              t51 = 1/taua**2
              t52 = 1/rhoa**2
              t53 = 1/t19**2
              t54 = t31**2
              t55 = 1/t18**4
              t56 = 1/t18**3
              t57 = 1/t10**5
              t58 = 1/rhoa**2.3333333333333334d+0
              t59 = 1/rhoa**2.1666666666666665d+0
              t60 = 1.1632736958443765d+0*t59+9.89141964955861d-1*t58+6.
     1           003214762495226d-1*t57+2.1077825841639536d-1*t1
              t61 = 1/t15**2
              t62 = t34**2
              t63 = 1/t14**4
              t64 = 1/t14**3
              t65 = 2.1622951122684114d+0*t59+1.7087761055320938d+0*t58+
     1           1.2335503316757068d+0*t57+2.673190323653546d-1*t1
              t66 = 1.0d+0*t17*t33*t35*t65-2.0d+0*t17*t33*t62*t64+3.2163
     1           95899738507d+1*t17*t61*t62*t63+1.1102230246251565d-16*t
     2           21*t26*t32*t60-4.0675215258019015d-19*t20*t58-1.7613865
     3           241785684d-3*t16*t58-2.220446049250313d-16*t21*t26*t54*
     4           t56+1.7854583920998188d-15*t21*t53*t54*t55-8.4979745913
     5           33913d-2*t29*t33*t34*t35-9.812069668265515d-18*t26*t29*
     6           t31*t32
              t67 = gammaaa**3
              t68 = 1/t2**3
              t69 = 1/rhoa**10
              t70 = 1/rhoa**7.333333333333333d+0
              t71 = 1/rhoa**4.666666666666667d+0
              t72 = 5.866666666666666d-1*gammaaa*t3*t4*t71-8.63999999999
     1           9998d-2*t37*t38*t4*t70+3.0719999999999986d-3*t4*t67*t68
     2           *t69
              t73 = 6.0d-2*gammaaa*t1*t3*t72+5.866666666666666d-1*gammaa
     1           a*t3*t5*t71-8.639999999999998d-2*t37*t38*t5*t70+3.07199
     2           99999999986d-3*t5*t67*t68*t69-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t41+1.9199999999999995d-2*t37*t38*t39*t41
              t74 = 6.0d-2*gammaaa*t1*t3*t73+5.866666666666666d-1*gammaa
     1           a*t3*t6*t71-8.639999999999998d-2*t37*t38*t6*t70+3.07199
     2           99999999986d-3*t6*t67*t68*t69-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t42+1.9199999999999995d-2*t37*t38*t39*t42
              t75 = 6.0d-2*gammaaa*t1*t3*t74+5.866666666666666d-1*gammaa
     1           a*t3*t7*t71-8.639999999999998d-2*t37*t38*t7*t70+3.07199
     2           99999999986d-3*t67*t68*t69*t7-3.1999999999999995d-1*gam
     3           maaa*t3*t40*t43+1.9199999999999995d-2*t37*t38*t39*t43
              t76 = 1.25d-1*t22*t8*wght
              t77 = 1/rhoa**9
              t78 = -1.1519999999999996d-3*t37*t4*t68*t77-1.599999999999
     1           9998d-1*t3*t4*t40+2.879999999999999d-2*gammaaa*t38*t39*
     2           t4
              t79 = 6.0d-2*gammaaa*t1*t3*t78-1.1519999999999996d-3*t37*t
     1           5*t68*t77-1.5999999999999998d-1*t3*t40*t5+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t5-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t47+9.599999999999997d-3*t37*t38*t39*t47-3.6d-
     4           3*gammaaa*t38*t41*t46+6.0d-2*t1*t3*t41
              t80 = 6.0d-2*gammaaa*t1*t3*t79-1.1519999999999996d-3*t37*t
     1           6*t68*t77-1.5999999999999998d-1*t3*t40*t6+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t6-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t48+9.599999999999997d-3*t37*t38*t39*t48-3.6d-
     4           3*gammaaa*t38*t42*t46+6.0d-2*t1*t3*t42
              t81 = 6.0d-2*gammaaa*t1*t3*t80-1.1519999999999996d-3*t37*t
     1           68*t7*t77-1.5999999999999998d-1*t3*t40*t7+2.87999999999
     2           9999d-2*gammaaa*t38*t39*t7-1.5999999999999998d-1*gammaa
     3           a*t3*t40*t49+9.599999999999997d-3*t37*t38*t39*t49-3.6d-
     4           3*gammaaa*t38*t43*t46+6.0d-2*t1*t3*t43
              t82 = 1/rhoa**8
              t83 = 4.32d-4*gammaaa*t4*t68*t82-7.2d-3*t38*t4*t46
              t84 = 6.0d-2*gammaaa*t1*t3*t83+4.32d-4*gammaaa*t5*t68*t82-
     1           7.2d-3*t38*t46*t5-7.2d-3*gammaaa*t38*t46*t47+1.2d-1*t1*
     2           t3*t47
              t85 = 6.0d-2*gammaaa*t1*t3*t84+4.32d-4*gammaaa*t6*t68*t82-
     1           7.2d-3*t38*t46*t6-7.2d-3*gammaaa*t38*t46*t48+1.2d-1*t1*
     2           t3*t48
              t86 = 6.0d-2*gammaaa*t1*t3*t85+4.32d-4*gammaaa*t68*t7*t82-
     1           7.2d-3*t38*t46*t7-7.2d-3*gammaaa*t38*t46*t49+1.2d-1*t1*
     2           t3*t49
              t87 = -5.0d-1*rhoa*t25*t36*t8*wght-5.0d-1*t22*t25*t8*wght-
     1           5.0d-1*rhoa*t22*t25*t44*wght
              t88 = t76-5.0d-1*rhoa*t22*t25*t50*wght
              t89 = 1/taua**3
              t90 = 1/rhoa**3
              t91 = t31**3
              t92 = 1/t10**7
              t93 = 1/rhoa**3.3333333333333337d+0
              t94 = 1/rhoa**3.1666666666666665d+0
              t95 = t34**3
              t96 = gammaaa**4
              t97 = 1/t2**4
              t98 = 1/rhoa**1.3666666666666666d+1
              t99 = 1/rhoa**11
              t100 = 1/rhoa**8.333333333333334d+0
              t101 = 1/rhoa**5.666666666666667d+0
              t102 = 1.25d-1*t36*t8*wght
              t103 = 1.25d-1*t22*t44*wght
              t104 = t45-1.25d-1*gammaaa*t22*t50*wght
              t105 = 1/rhoa**1.2666666666666665d+1
              t106 = 2.5d-1*t22*t50*wght
              t107 = 1/rhoa**1.1666666666666665d+1
              t108 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhoa*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = t23*(5.0d-1*rhoa*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhoa*t22*t25*t44*wght)+1.25d-1*ga
     2           mmaaa*t22*t23*t24*t8*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t23*(5.0d-1*rhoa*t22*t25*t50*wght+t45)+C
     1           mat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t22*t25*t51*t8*wght+1.0d+0*r
     1           hoa*t22*t23*t8*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t23*(5.0d-1*rhoa*t25*t66*t8*wght+1.25
     1           d-1*gammaaa*t22*t52*t8*wght+1.0d+0*t25*t36*t8*wght+1.25
     2           d-1*gammaaa*t24*t36*t8*wght+5.0d-1*rhoa*t22*t25*t75*wgh
     3           t+1.0d+0*rhoa*t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+
     4           1.25d-1*gammaaa*t22*t24*t44*wght)+t23*t24*(1.25d-1*gamm
     5           aaa*t36*t8*wght+1.25d-1*gammaaa*t22*t44*wght)-1.25d-1*g
     6           ammaaa*t22*t23*t52*t8*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t23*(5.0d-1*rhoa*t22*t25*t81*wght-1.
     1           25d-1*t36*t8*wght-1.25d-1*t22*t24*t8*wght+5.0d-1*rhoa*t
     2           25*t36*t50*wght+5.0d-1*t22*t25*t50*wght-1.25d-1*t22*t44
     3           *wght)+t23*t24*(1.25d-1*gammaaa*t22*t50*wght+t76)+Cmat2
     4           (iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*t86*wght-2
     1           .5d-1*t22*t50*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t23*(1.0d+0*rhoa*t36*t8*wght+1.0d+0*t
     1           22*t8*wght+1.0d+0*rhoa*t22*t44*wght)-1.25d-1*gammaaa*t2
     2           2*t24*t51*t8*wght+t51*t87+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.0d+0*rhoa*t22*t23*t50*wght+t51*t88
     1           +Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t22*t25*t8*t89*wght-2.0d+
     1           0*rhoa*t22*t51*t8*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*g
     1           ammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t
     2           3*(-5.836799999999998d-2*t4*t67*t68*t99+1.4745599999999
     3           992d-3*t4*t96*t97*t98+7.274666666666665d-1*t100*t37*t38
     4           *t4-2.737777777777778d+0*gammaaa*t101*t3*t4)-5.83679999
     5           9999998d-2*t5*t67*t68*t99+1.4745599999999992d-3*t5*t96*
     6           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t72+2.87999
     7           9999999999d-2*t37*t38*t39*t72+1.76d+0*gammaaa*t3*t41*t7
     8           1-2.5919999999999993d-1*t37*t38*t41*t70+9.2159999999999
     9           96d-3*t41*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     :           *t5-2.737777777777778d+0*gammaaa*t101*t3*t5)-5.83679999
     ;           9999998d-2*t6*t67*t68*t99+1.4745599999999992d-3*t6*t96*
     <           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t73+2.87999
     =           9999999999d-2*t37*t38*t39*t73+1.76d+0*gammaaa*t3*t42*t7
     >           1-2.5919999999999993d-1*t37*t38*t42*t70+9.2159999999999
     ?           96d-3*t42*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     @           *t6-2.737777777777778d+0*gammaaa*t101*t3*t6)-5.83679999
     1           9999998d-2*t67*t68*t7*t99+1.4745599999999992d-3*t7*t96*
     2           t97*t98-4.799999999999999d-1*gammaaa*t3*t40*t74+2.87999
     3           9999999999d-2*t37*t38*t39*t74+1.76d+0*gammaaa*t3*t43*t7
     4           1-2.5919999999999993d-1*t37*t38*t43*t70+7.2746666666666
     5           65d-1*t100*t37*t38*t7-2.737777777777778d+0*gammaaa*t101
     6           *t3*t7+9.215999999999996d-3*t43*t67*t68*t69)*wght+5.0d-
     7           1*rhoa*t25*t8*(6.0d+0*t17*t33*t63*t95-1.929837539843104
     8           5d+2*t17*t61*t95/t14**5+2.0690405167709364d+3*t17*t95/(
     9           t14**6*t15**3)+1.1102230246251565d-16*t21*t26*t32*(-2.5
     :           20426340996149d+0*t94-2.3079979182303428d+0*t93-1.50080
     ;           36906238065d+0*t92-5.620753557770543d-1*t40)+1.0d+0*t17
     <           *t33*t35*(-4.684972743248224d+0*t94-3.9871442462415524d
     =           +0*t93-3.083875829189267d+0*t92-7.128507529742789d-1*t4
     >           0)+9.490883560204437d-19*t20*t93+4.1099018897499934d-3*
     ?           t16*t93+6.661338147750939d-16*t21*t26*t55*t91-1.0712750
     @           352598913d-14*t21*t53*t91/t18**5+5.742741051503565d-14*
     1           t21*t91/(t18**6*t19**3)-6.0d+0*t17*t33*t34*t64*t65+9.64
     2           9187699215522d+1*t17*t34*t61*t63*t65-1.274696188700087d
     3           -1*t29*t33*t35*t65+2.549392377400174d-1*t29*t33*t62*t64
     4           -4.0999275947472624d+0*t29*t61*t62*t63-6.66133814775093
     5           9d-16*t21*t26*t31*t56*t60+5.356375176299456d-15*t21*t31
     6           *t53*t55*t60-1.4718104502398274d-17*t26*t29*t32*t60+1.6
     7           995949182667827d-1*t33*t34*t35*t58+1.962413933653103d-1
     8           7*t26*t31*t32*t58+2.943620900479655d-17*t26*t29*t54*t56
     9           -2.3669625486718335d-16*t29*t53*t54*t55)*wght-2.5d-1*ga
     :           mmaaa*t22*t8*t90*wght+1.5d+0*t25*t66*t8*wght+2.5d-1*gam
     ;           maaa*t24*t66*t8*wght+2.5d-1*gammaaa*t36*t52*t8*wght+1.5
     <           d+0*rhoa*t25*t36*t75*wght+1.5d+0*t22*t25*t75*wght+2.5d-
     =           1*gammaaa*t22*t24*t75*wght+1.5d+0*rhoa*t25*t44*t66*wght
     >           +2.5d-1*gammaaa*t22*t44*t52*wght+3.0d+0*t25*t36*t44*wgh
     ?           t+5.0d-1*gammaaa*t24*t36*t44*wght)+t23*t24*(1.25d-1*gam
     @           maaa*t66*t8*wght+1.25d-1*gammaaa*t22*t75*wght+2.5d-1*ga
     1           mmaaa*t36*t44*wght)+t23*t52*(-2.5d-1*gammaaa*t36*t8*wgh
     2           t-2.5d-1*gammaaa*t22*t44*wght)+2.5d-1*gammaaa*t22*t23*t
     3           8*t90*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*
     1           gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*
     2           t3*(-5.529599999999998d-4*t105*t4*t67*t97+5.86666666666
     3           6666d-1*t3*t4*t71-2.0799999999999996d-1*gammaaa*t38*t4*
     4           t70+1.9583999999999993d-2*t37*t4*t68*t69)-5.52959999999
     5           9998d-4*t105*t5*t67*t97-3.1999999999999995d-1*gammaaa*t
     6           3*t40*t78+1.9199999999999995d-2*t37*t38*t39*t78-2.30399
     7           9999999999d-3*t37*t41*t68*t77-3.6d-3*gammaaa*t38*t46*t7
     8           2+6.0d-2*t1*t3*t72+5.866666666666666d-1*t3*t5*t71+5.866
     9           666666666666d-1*gammaaa*t3*t47*t71-2.0799999999999996d-
     :           1*gammaaa*t38*t5*t70-8.639999999999998d-2*t37*t38*t47*t
     ;           70+3.0719999999999986d-3*t47*t67*t68*t69+1.958399999999
     <           9993d-2*t37*t5*t68*t69-3.1999999999999995d-1*t3*t40*t41
     =           +5.759999999999998d-2*gammaaa*t38*t39*t41)-5.5295999999
     >           99998d-4*t105*t6*t67*t97-3.1999999999999995d-1*gammaaa*
     ?           t3*t40*t79+1.9199999999999995d-2*t37*t38*t39*t79-2.3039
     @           99999999999d-3*t37*t42*t68*t77-3.6d-3*gammaaa*t38*t46*t
     1           73+6.0d-2*t1*t3*t73+5.866666666666666d-1*t3*t6*t71+5.86
     2           6666666666666d-1*gammaaa*t3*t48*t71-2.0799999999999996d
     3           -1*gammaaa*t38*t6*t70-8.639999999999998d-2*t37*t38*t48*
     4           t70+3.0719999999999986d-3*t48*t67*t68*t69+1.95839999999
     5           99993d-2*t37*t6*t68*t69-3.1999999999999995d-1*t3*t40*t4
     6           2+5.759999999999998d-2*gammaaa*t38*t39*t42)-5.529599999
     7           999998d-4*t105*t67*t7*t97-3.1999999999999995d-1*gammaaa
     8           *t3*t40*t80+1.9199999999999995d-2*t37*t38*t39*t80-2.303
     9           999999999999d-3*t37*t43*t68*t77-3.6d-3*gammaaa*t38*t46*
     :           t74+6.0d-2*t1*t3*t74+5.866666666666666d-1*t3*t7*t71+5.8
     ;           66666666666666d-1*gammaaa*t3*t49*t71-2.0799999999999996
     <           d-1*gammaaa*t38*t7*t70-8.639999999999998d-2*t37*t38*t49
     =           *t70+1.9583999999999993d-2*t37*t68*t69*t7+3.07199999999
     >           99986d-3*t49*t67*t68*t69-3.1999999999999995d-1*t3*t40*t
     ?           43+5.759999999999998d-2*gammaaa*t38*t39*t43)*wght+1.0d+
     @           0*rhoa*t25*t36*t81*wght+1.0d+0*t22*t25*t81*wght+1.25d-1
     1           *gammaaa*t22*t24*t81*wght-1.25d-1*t66*t8*wght+1.25d-1*t
     2           22*t52*t8*wght-1.25d-1*t24*t36*t8*wght-1.25d-1*t22*t75*
     3           wght+5.0d-1*rhoa*t25*t50*t66*wght+1.25d-1*gammaaa*t22*t
     4           50*t52*wght+1.0d+0*t25*t36*t50*wght+1.25d-1*gammaaa*t24
     5           *t36*t50*wght-2.5d-1*t36*t44*wght-1.25d-1*t22*t24*t44*w
     6           ght)+t23*t24*(1.25d-1*gammaaa*t22*t81*wght+1.25d-1*gamm
     7           aaa*t36*t50*wght+t103+t102)+t104*t23*t52+Cmat3(iq,D3_RA
     8           _RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-2
     1           *gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1
     2           *t3*(2.073599999999999d-4*t107*t37*t4*t97-5.75999999999
     3           9997d-3*gammaaa*t4*t68*t77+3.839999999999999d-2*t38*t39
     4           *t4)+2.073599999999999d-4*t107*t37*t5*t97-1.59999999999
     5           99998d-1*gammaaa*t3*t40*t83+9.599999999999997d-3*t37*t3
     6           8*t39*t83+4.32d-4*gammaaa*t41*t68*t82-7.2d-3*gammaaa*t3
     7           8*t46*t78+1.2d-1*t1*t3*t78-5.759999999999997d-3*gammaaa
     8           *t5*t68*t77-2.303999999999999d-3*t37*t47*t68*t77+3.8399
     9           99999999999d-2*t38*t39*t5-3.1999999999999995d-1*t3*t40*
     :           t47+5.759999999999998d-2*gammaaa*t38*t39*t47-7.2d-3*t38
     ;           *t41*t46)+2.073599999999999d-4*t107*t37*t6*t97-1.599999
     <           9999999998d-1*gammaaa*t3*t40*t84+9.599999999999997d-3*t
     =           37*t38*t39*t84+4.32d-4*gammaaa*t42*t68*t82-7.2d-3*gamma
     >           aa*t38*t46*t79+1.2d-1*t1*t3*t79-5.759999999999997d-3*ga
     ?           mmaaa*t6*t68*t77-2.303999999999999d-3*t37*t48*t68*t77+3
     @           .839999999999999d-2*t38*t39*t6-3.1999999999999995d-1*t3
     1           *t40*t48+5.759999999999998d-2*gammaaa*t38*t39*t48-7.2d-
     2           3*t38*t42*t46)+2.073599999999999d-4*t107*t37*t7*t97-1.5
     3           999999999999998d-1*gammaaa*t3*t40*t85+9.599999999999997
     4           d-3*t37*t38*t39*t85+4.32d-4*gammaaa*t43*t68*t82-7.2d-3*
     5           gammaaa*t38*t46*t80+1.2d-1*t1*t3*t80-5.759999999999997d
     6           -3*gammaaa*t68*t7*t77-2.303999999999999d-3*t37*t49*t68*
     7           t77+3.839999999999999d-2*t38*t39*t7-3.1999999999999995d
     8           -1*t3*t40*t49+5.759999999999998d-2*gammaaa*t38*t39*t49-
     9           7.2d-3*t38*t43*t46)*wght+5.0d-1*rhoa*t25*t36*t86*wght+5
     :           .0d-1*t22*t25*t86*wght-2.5d-1*t22*t81*wght-2.5d-1*t36*t
     ;           50*wght-2.5d-1*t22*t24*t50*wght)+t23*t24*(1.25d-1*gamma
     <           aa*t22*t86*wght+t106)+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = t23*(5.0d-1*rhoa*t22*t25*(6.0d-
     1           2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t
     2           1*t3*(1.296d-3*t4*t68*t82-7.776d-5*gammaaa*t108*t4*t97)
     3           -7.776d-5*gammaaa*t108*t5*t97-1.0800000000000001d-2*gam
     4           maaa*t38*t46*t83+1.8d-1*t1*t3*t83+1.296d-3*t5*t68*t82+1
     5           .296d-3*gammaaa*t47*t68*t82-2.1600000000000003d-2*t38*t
     6           46*t47)-7.776d-5*gammaaa*t108*t6*t97-1.0800000000000001
     7           d-2*gammaaa*t38*t46*t84+1.8d-1*t1*t3*t84+1.296d-3*t6*t6
     8           8*t82+1.296d-3*gammaaa*t48*t68*t82-2.1600000000000003d-
     9           2*t38*t46*t48)-7.776d-5*gammaaa*t108*t7*t97-1.080000000
     :           0000001d-2*gammaaa*t38*t46*t85+1.8d-1*t1*t3*t85+1.296d-
     ;           3*t68*t7*t82+1.296d-3*gammaaa*t49*t68*t82-2.16000000000
     <           00003d-2*t38*t46*t49)*wght-3.75d-1*t22*t86*wght)+Cmat3(
     =           iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = t51*(-5.0d-1*rhoa*t25*t66*t8*wght-
     1           1.25d-1*gammaaa*t22*t52*t8*wght-1.0d+0*t25*t36*t8*wght-
     2           1.25d-1*gammaaa*t24*t36*t8*wght-5.0d-1*rhoa*t22*t25*t75
     3           *wght-1.0d+0*rhoa*t25*t36*t44*wght-1.0d+0*t22*t25*t44*w
     4           ght-1.25d-1*gammaaa*t22*t24*t44*wght)+t23*(1.0d+0*rhoa*
     5           t66*t8*wght+2.0d+0*t36*t8*wght+1.0d+0*rhoa*t22*t75*wght
     6           +2.0d+0*rhoa*t36*t44*wght+2.0d+0*t22*t44*wght)+t24*t51*
     7           (-1.25d-1*gammaaa*t36*t8*wght-1.25d-1*gammaaa*t22*t44*w
     8           ght)+1.25d-1*gammaaa*t22*t51*t52*t8*wght+Mmat3(iq,D3_RA
     9           _RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = t51*(-5.0d-1*rhoa*t22*t25*t81*wgh
     1           t+1.25d-1*t22*t24*t8*wght-5.0d-1*rhoa*t25*t36*t50*wght-
     2           5.0d-1*t22*t25*t50*wght+t103+t102)+t23*(1.0d+0*rhoa*t22
     3           *t81*wght+1.0d+0*rhoa*t36*t50*wght+1.0d+0*t22*t50*wght)
     4           +t104*t24*t51+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = t51*(t106-5.0d-1*rhoa*t22*t25*t8
     1           6*wght)+1.0d+0*rhoa*t22*t23*t86*wght+Mmat3(iq,D3_GAA_GA
     2           A_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = t51*(-2.0d+0*rhoa*t36*t8*wght-2.0d
     1           +0*t22*t8*wght-2.0d+0*rhoa*t22*t44*wght)+2.5d-1*gammaaa
     2           *t22*t24*t8*t89*wght-2*t87*t89+Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = -2.0d+0*rhoa*t22*t50*t51*wght-2*t
     1           88*t89+Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -3.0d+0*rhoa*t22*t25*t8*wght/taua*
     1           *4+6.0d+0*rhoa*t22*t8*t89*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = 1/t19**2
              t41 = t27**2
              t42 = 1/t18**4
              t43 = 1/t18**3
              t44 = 1/t10**5
              t45 = 1/rhoa**2.3333333333333334d+0
              t46 = 1/rhoa**2.1666666666666665d+0
              t47 = 1.1632736958443765d+0*t46+9.89141964955861d-1*t45+6.
     1           003214762495226d-1*t44+2.1077825841639536d-1*t35
              t48 = 1/t15**2
              t49 = t30**2
              t50 = 1/t14**4
              t51 = 1/t14**3
              t52 = 2.1622951122684114d+0*t46+1.7087761055320938d+0*t45+
     1           1.2335503316757068d+0*t44+2.673190323653546d-1*t35
              t53 = 1.0d+0*t17*t29*t31*t52-2.0d+0*t17*t29*t49*t51+3.2163
     1           95899738507d+1*t17*t48*t49*t50+1.1102230246251565d-16*t
     2           21*t23*t28*t47-4.0675215258019015d-19*t20*t45-1.7613865
     3           241785684d-3*t16*t45-2.220446049250313d-16*t21*t23*t41*
     4           t43+1.7854583920998188d-15*t21*t40*t41*t42-8.4979745913
     5           33913d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*
     6           t27*t28
              t54 = 1/t2**3
              t55 = 1/rhoa**7
              t56 = 1/rhoa**5.333333333333333d+0
              t57 = 1/rhoa**3.6666666666666664d+0
              t58 = 1.0666666666666666d-50*t3*t4*t57-5.76d-101*t33*t4*t5
     1           6+7.68d-152*t4*t54*t55
              t59 = 2.4d-51*t1*t3*t58+1.0666666666666666d-50*t3*t5*t57-5
     1           .76d-101*t33*t5*t56+7.68d-152*t5*t54*t55-8.0d-51*t3*t35
     2           *t36+1.92d-101*t33*t34*t36
              t60 = 1.0666666666666666d-50*t3*t57*t6-5.76d-101*t33*t56*t
     1           6+7.68d-152*t54*t55*t6+2.4d-51*t1*t3*t59-8.0d-51*t3*t35
     2           *t37+1.92d-101*t33*t34*t37
              t61 = 1.0666666666666666d-50*t3*t57*t7-5.76d-101*t33*t56*t
     1           7+7.68d-152*t54*t55*t7+2.4d-51*t1*t3*t60-8.0d-51*t3*t35
     2           *t38+1.92d-101*t33*t34*t38
              t62 = t27**3
              t63 = 1/t10**7
              t64 = 1/rhoa**3.3333333333333337d+0
              t65 = 1/rhoa**3.1666666666666665d+0
              t66 = t30**3
              t67 = 1/t2**4
              t68 = 1/rhoa**9.666666666666666d+0
              t69 = 1/rhoa**8
              t70 = 1/rhoa**6.333333333333333d+0
              t71 = 1/rhoa**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhoa*t22*t39*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*t53*t8*wght+1.0d+0*t32*t8
     1           *wght+5.0d-1*rhoa*t22*t61*wght+1.0d+0*rhoa*t32*t39*wght
     2           +1.0d+0*t22*t39*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = 5.0d-1*rhoa*(6.0d+0*t17*t29*t50*t6
     1           6-1.9298375398431045d+2*t17*t48*t66/t14**5+2.0690405167
     2           709364d+3*t17*t66/(t14**6*t15**3)+1.1102230246251565d-1
     3           6*t21*t23*t28*(-2.520426340996149d+0*t65-2.307997918230
     4           3428d+0*t64-1.5008036906238065d+0*t63-5.620753557770543
     5           d-1*t57)+1.0d+0*t17*t29*t31*(-4.684972743248224d+0*t65-
     6           3.9871442462415524d+0*t64-3.083875829189267d+0*t63-7.12
     7           8507529742789d-1*t57)+9.490883560204437d-19*t20*t64+4.1
     8           099018897499934d-3*t16*t64+6.661338147750939d-16*t21*t2
     9           3*t42*t62-1.0712750352598913d-14*t21*t40*t62/t18**5+5.7
     :           42741051503565d-14*t21*t62/(t18**6*t19**3)-6.0d+0*t17*t
     ;           29*t30*t51*t52+9.649187699215522d+1*t17*t30*t48*t50*t52
     <           -1.274696188700087d-1*t25*t29*t31*t52+2.549392377400174
     =           d-1*t25*t29*t49*t51-4.0999275947472624d+0*t25*t48*t49*t
     >           50-6.661338147750939d-16*t21*t23*t27*t43*t47+5.35637517
     ?           6299456d-15*t21*t27*t40*t42*t47-1.4718104502398274d-17*
     @           t23*t25*t28*t47+1.6995949182667827d-1*t29*t30*t31*t45+1
     1           .962413933653103d-17*t23*t27*t28*t45+2.943620900479655d
     2           -17*t23*t25*t41*t43-2.3669625486718335d-16*t25*t40*t41*
     3           t42)*t8*wght+1.5d+0*t53*t8*wght+5.0d-1*rhoa*t22*(2.4d-5
     4           1*t1*t3*(2.4d-51*t1*t3*(2.4d-51*t1*t3*(-3.9111111111111
     5           11d-50*t3*t4*t71+3.4986666666666666d-100*t33*t4*t70-9.9
     6           84000000000001d-151*t4*t54*t69+9.216000000000001d-202*t
     7           4*t67*t68)-3.911111111111111d-50*t3*t5*t71+3.4986666666
     8           666666d-100*t33*t5*t70-9.984000000000001d-151*t5*t54*t6
     9           9+9.216000000000001d-202*t5*t67*t68-1.2d-50*t3*t35*t58+
     :           2.88d-101*t33*t34*t58+3.2d-50*t3*t36*t57-1.727999999999
     ;           9998d-100*t33*t36*t56+2.3040000000000002d-151*t36*t54*t
     <           55)-3.911111111111111d-50*t3*t6*t71+3.4986666666666666d
     =           -100*t33*t6*t70-9.984000000000001d-151*t54*t6*t69+9.216
     >           000000000001d-202*t6*t67*t68-1.2d-50*t3*t35*t59+2.88d-1
     ?           01*t33*t34*t59+3.2d-50*t3*t37*t57-1.7279999999999998d-1
     @           00*t33*t37*t56+2.3040000000000002d-151*t37*t54*t55)-3.9
     1           11111111111111d-50*t3*t7*t71+3.4986666666666666d-100*t3
     2           3*t7*t70-9.984000000000001d-151*t54*t69*t7+9.2160000000
     3           00001d-202*t67*t68*t7-1.2d-50*t3*t35*t60+2.88d-101*t33*
     4           t34*t60+3.2d-50*t3*t38*t57-1.7279999999999998d-100*t33*
     5           t38*t56+2.3040000000000002d-151*t38*t54*t55)*wght+1.5d+
     6           0*rhoa*t32*t61*wght+1.5d+0*t22*t61*wght+1.5d+0*rhoa*t39
     7           *t53*wght+3.0d+0*t32*t39*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = 1/t19**2
              t41 = t27**2
              t42 = 1/t18**4
              t43 = 1/t18**3
              t44 = 1/t10**5
              t45 = 1/rhoa**2.3333333333333334d+0
              t46 = 1/rhoa**2.1666666666666665d+0
              t47 = 1.1632736958443765d+0*t46+9.89141964955861d-1*t45+6.
     1           003214762495226d-1*t44+2.1077825841639536d-1*t35
              t48 = 1/t15**2
              t49 = t30**2
              t50 = 1/t14**4
              t51 = 1/t14**3
              t52 = 2.1622951122684114d+0*t46+1.7087761055320938d+0*t45+
     1           1.2335503316757068d+0*t44+2.673190323653546d-1*t35
              t53 = 1.0d+0*t17*t29*t31*t52-2.0d+0*t17*t29*t49*t51+3.2163
     1           95899738507d+1*t17*t48*t49*t50+1.1102230246251565d-16*t
     2           21*t23*t28*t47-4.0675215258019015d-19*t20*t45-1.7613865
     3           241785684d-3*t16*t45-2.220446049250313d-16*t21*t23*t41*
     4           t43+1.7854583920998188d-15*t21*t40*t41*t42-8.4979745913
     5           33913d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*
     6           t27*t28
              t54 = 1/t2**3
              t55 = 1/rhoa**7
              t56 = 1/rhoa**5.333333333333333d+0
              t57 = 1/rhoa**3.6666666666666664d+0
              t58 = 1.0666666666666666d-50*t3*t4*t57-5.76d-101*t33*t4*t5
     1           6+7.68d-152*t4*t54*t55
              t59 = 2.4d-51*t1*t3*t58+1.0666666666666666d-50*t3*t5*t57-5
     1           .76d-101*t33*t5*t56+7.68d-152*t5*t54*t55-8.0d-51*t3*t35
     2           *t36+1.92d-101*t33*t34*t36
              t60 = 1.0666666666666666d-50*t3*t57*t6-5.76d-101*t33*t56*t
     1           6+7.68d-152*t54*t55*t6+2.4d-51*t1*t3*t59-8.0d-51*t3*t35
     2           *t37+1.92d-101*t33*t34*t37
              t61 = 1.0666666666666666d-50*t3*t57*t7-5.76d-101*t33*t56*t
     1           7+7.68d-152*t54*t55*t7+2.4d-51*t1*t3*t60-8.0d-51*t3*t35
     2           *t38+1.92d-101*t33*t34*t38
              t62 = t27**3
              t63 = 1/t10**7
              t64 = 1/rhoa**3.3333333333333337d+0
              t65 = 1/rhoa**3.1666666666666665d+0
              t66 = t30**3
              t67 = 1/t2**4
              t68 = 1/rhoa**9.666666666666666d+0
              t69 = 1/rhoa**8
              t70 = 1/rhoa**6.333333333333333d+0
              t71 = 1/rhoa**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhoa*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhoa*t22*t39*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*t53*t8*wght+1.0d+0*t32*t8
     1           *wght+5.0d-1*rhoa*t22*t61*wght+1.0d+0*rhoa*t32*t39*wght
     2           +1.0d+0*t22*t39*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = 5.0d-1*rhoa*(6.0d+0*t17*t29*t50*t6
     1           6-1.9298375398431045d+2*t17*t48*t66/t14**5+2.0690405167
     2           709364d+3*t17*t66/(t14**6*t15**3)+1.1102230246251565d-1
     3           6*t21*t23*t28*(-2.520426340996149d+0*t65-2.307997918230
     4           3428d+0*t64-1.5008036906238065d+0*t63-5.620753557770543
     5           d-1*t57)+1.0d+0*t17*t29*t31*(-4.684972743248224d+0*t65-
     6           3.9871442462415524d+0*t64-3.083875829189267d+0*t63-7.12
     7           8507529742789d-1*t57)+9.490883560204437d-19*t20*t64+4.1
     8           099018897499934d-3*t16*t64+6.661338147750939d-16*t21*t2
     9           3*t42*t62-1.0712750352598913d-14*t21*t40*t62/t18**5+5.7
     :           42741051503565d-14*t21*t62/(t18**6*t19**3)-6.0d+0*t17*t
     ;           29*t30*t51*t52+9.649187699215522d+1*t17*t30*t48*t50*t52
     <           -1.274696188700087d-1*t25*t29*t31*t52+2.549392377400174
     =           d-1*t25*t29*t49*t51-4.0999275947472624d+0*t25*t48*t49*t
     >           50-6.661338147750939d-16*t21*t23*t27*t43*t47+5.35637517
     ?           6299456d-15*t21*t27*t40*t42*t47-1.4718104502398274d-17*
     @           t23*t25*t28*t47+1.6995949182667827d-1*t29*t30*t31*t45+1
     1           .962413933653103d-17*t23*t27*t28*t45+2.943620900479655d
     2           -17*t23*t25*t41*t43-2.3669625486718335d-16*t25*t40*t41*
     3           t42)*t8*wght+1.5d+0*t53*t8*wght+5.0d-1*rhoa*t22*(2.4d-5
     4           1*t1*t3*(2.4d-51*t1*t3*(2.4d-51*t1*t3*(-3.9111111111111
     5           11d-50*t3*t4*t71+3.4986666666666666d-100*t33*t4*t70-9.9
     6           84000000000001d-151*t4*t54*t69+9.216000000000001d-202*t
     7           4*t67*t68)-3.911111111111111d-50*t3*t5*t71+3.4986666666
     8           666666d-100*t33*t5*t70-9.984000000000001d-151*t5*t54*t6
     9           9+9.216000000000001d-202*t5*t67*t68-1.2d-50*t3*t35*t58+
     :           2.88d-101*t33*t34*t58+3.2d-50*t3*t36*t57-1.727999999999
     ;           9998d-100*t33*t36*t56+2.3040000000000002d-151*t36*t54*t
     <           55)-3.911111111111111d-50*t3*t6*t71+3.4986666666666666d
     =           -100*t33*t6*t70-9.984000000000001d-151*t54*t6*t69+9.216
     >           000000000001d-202*t6*t67*t68-1.2d-50*t3*t35*t59+2.88d-1
     ?           01*t33*t34*t59+3.2d-50*t3*t37*t57-1.7279999999999998d-1
     @           00*t33*t37*t56+2.3040000000000002d-151*t37*t54*t55)-3.9
     1           11111111111111d-50*t3*t7*t71+3.4986666666666666d-100*t3
     2           3*t7*t70-9.984000000000001d-151*t54*t69*t7+9.2160000000
     3           00001d-202*t67*t68*t7-1.2d-50*t3*t35*t60+2.88d-101*t33*
     4           t34*t60+3.2d-50*t3*t38*t57-1.7279999999999998d-100*t33*
     5           t38*t56+2.3040000000000002d-151*t38*t54*t55)*wght+1.5d+
     6           0*rhoa*t32*t61*wght+1.5d+0*t22*t61*wght+1.5d+0*rhoa*t39
     7           *t53*wght+3.0d+0*t32*t39*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/t19
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammabb**2
              t38 = 1/t2**2
              t39 = 1/rhob**6.333333333333333d+0
              t40 = 1/rhob**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammabb*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammabb*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammabb*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammabb*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammabb*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammabb*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammabb*t1*t3*t43
              t45 = -1.25d-1*t22*t8*wght
              t46 = 1/rhob**5.333333333333333d+0
              t47 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t38*t4*t46
              t48 = -3.6d-3*gammabb*t38*t46*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmabb*t1*t3*t47
              t49 = -3.6d-3*gammabb*t38*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmabb*t1*t3*t48
              t50 = -3.6d-3*gammabb*t38*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t49
              t51 = 1/taub**2
              t52 = 1/rhob**2
              t53 = 1/t19**2
              t54 = t31**2
              t55 = 1/t18**4
              t56 = 1/t18**3
              t57 = 1/t10**5
              t58 = 1/rhob**2.3333333333333334d+0
              t59 = 1/rhob**2.1666666666666665d+0
              t60 = 1.1632736958443765d+0*t59+9.89141964955861d-1*t58+6.
     1           003214762495226d-1*t57+2.1077825841639536d-1*t1
              t61 = 1/t15**2
              t62 = t34**2
              t63 = 1/t14**4
              t64 = 1/t14**3
              t65 = 2.1622951122684114d+0*t59+1.7087761055320938d+0*t58+
     1           1.2335503316757068d+0*t57+2.673190323653546d-1*t1
              t66 = 1.0d+0*t17*t33*t35*t65-2.0d+0*t17*t33*t62*t64+3.2163
     1           95899738507d+1*t17*t61*t62*t63+1.1102230246251565d-16*t
     2           21*t26*t32*t60-4.0675215258019015d-19*t20*t58-1.7613865
     3           241785684d-3*t16*t58-2.220446049250313d-16*t21*t26*t54*
     4           t56+1.7854583920998188d-15*t21*t53*t54*t55-8.4979745913
     5           33913d-2*t29*t33*t34*t35-9.812069668265515d-18*t26*t29*
     6           t31*t32
              t67 = gammabb**3
              t68 = 1/t2**3
              t69 = 1/rhob**10
              t70 = 1/rhob**7.333333333333333d+0
              t71 = 1/rhob**4.666666666666667d+0
              t72 = 5.866666666666666d-1*gammabb*t3*t4*t71-8.63999999999
     1           9998d-2*t37*t38*t4*t70+3.0719999999999986d-3*t4*t67*t68
     2           *t69
              t73 = 6.0d-2*gammabb*t1*t3*t72+5.866666666666666d-1*gammab
     1           b*t3*t5*t71-8.639999999999998d-2*t37*t38*t5*t70+3.07199
     2           99999999986d-3*t5*t67*t68*t69-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t41+1.9199999999999995d-2*t37*t38*t39*t41
              t74 = 6.0d-2*gammabb*t1*t3*t73+5.866666666666666d-1*gammab
     1           b*t3*t6*t71-8.639999999999998d-2*t37*t38*t6*t70+3.07199
     2           99999999986d-3*t6*t67*t68*t69-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t42+1.9199999999999995d-2*t37*t38*t39*t42
              t75 = 6.0d-2*gammabb*t1*t3*t74+5.866666666666666d-1*gammab
     1           b*t3*t7*t71-8.639999999999998d-2*t37*t38*t7*t70+3.07199
     2           99999999986d-3*t67*t68*t69*t7-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t43+1.9199999999999995d-2*t37*t38*t39*t43
              t76 = 1.25d-1*t22*t8*wght
              t77 = 1/rhob**9
              t78 = -1.1519999999999996d-3*t37*t4*t68*t77-1.599999999999
     1           9998d-1*t3*t4*t40+2.879999999999999d-2*gammabb*t38*t39*
     2           t4
              t79 = 6.0d-2*gammabb*t1*t3*t78-1.1519999999999996d-3*t37*t
     1           5*t68*t77-1.5999999999999998d-1*t3*t40*t5+2.87999999999
     2           9999d-2*gammabb*t38*t39*t5-1.5999999999999998d-1*gammab
     3           b*t3*t40*t47+9.599999999999997d-3*t37*t38*t39*t47-3.6d-
     4           3*gammabb*t38*t41*t46+6.0d-2*t1*t3*t41
              t80 = 6.0d-2*gammabb*t1*t3*t79-1.1519999999999996d-3*t37*t
     1           6*t68*t77-1.5999999999999998d-1*t3*t40*t6+2.87999999999
     2           9999d-2*gammabb*t38*t39*t6-1.5999999999999998d-1*gammab
     3           b*t3*t40*t48+9.599999999999997d-3*t37*t38*t39*t48-3.6d-
     4           3*gammabb*t38*t42*t46+6.0d-2*t1*t3*t42
              t81 = 6.0d-2*gammabb*t1*t3*t80-1.1519999999999996d-3*t37*t
     1           68*t7*t77-1.5999999999999998d-1*t3*t40*t7+2.87999999999
     2           9999d-2*gammabb*t38*t39*t7-1.5999999999999998d-1*gammab
     3           b*t3*t40*t49+9.599999999999997d-3*t37*t38*t39*t49-3.6d-
     4           3*gammabb*t38*t43*t46+6.0d-2*t1*t3*t43
              t82 = 1/rhob**8
              t83 = 4.32d-4*gammabb*t4*t68*t82-7.2d-3*t38*t4*t46
              t84 = 6.0d-2*gammabb*t1*t3*t83+4.32d-4*gammabb*t5*t68*t82-
     1           7.2d-3*t38*t46*t5-7.2d-3*gammabb*t38*t46*t47+1.2d-1*t1*
     2           t3*t47
              t85 = 6.0d-2*gammabb*t1*t3*t84+4.32d-4*gammabb*t6*t68*t82-
     1           7.2d-3*t38*t46*t6-7.2d-3*gammabb*t38*t46*t48+1.2d-1*t1*
     2           t3*t48
              t86 = 6.0d-2*gammabb*t1*t3*t85+4.32d-4*gammabb*t68*t7*t82-
     1           7.2d-3*t38*t46*t7-7.2d-3*gammabb*t38*t46*t49+1.2d-1*t1*
     2           t3*t49
              t87 = -5.0d-1*rhob*t25*t36*t8*wght-5.0d-1*t22*t25*t8*wght-
     1           5.0d-1*rhob*t22*t25*t44*wght
              t88 = t76-5.0d-1*rhob*t22*t25*t50*wght
              t89 = 1/taub**3
              t90 = 1/rhob**3
              t91 = t31**3
              t92 = 1/t10**7
              t93 = 1/rhob**3.3333333333333337d+0
              t94 = 1/rhob**3.1666666666666665d+0
              t95 = t34**3
              t96 = gammabb**4
              t97 = 1/t2**4
              t98 = 1/rhob**1.3666666666666666d+1
              t99 = 1/rhob**11
              t100 = 1/rhob**8.333333333333334d+0
              t101 = 1/rhob**5.666666666666667d+0
              t102 = 1.25d-1*t36*t8*wght
              t103 = 1.25d-1*t22*t44*wght
              t104 = t45-1.25d-1*gammabb*t22*t50*wght
              t105 = 1/rhob**1.2666666666666665d+1
              t106 = 2.5d-1*t22*t50*wght
              t107 = 1/rhob**1.1666666666666665d+1
              t108 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhob*t22*t25*t44*wght)+1.25d-1*ga
     2           mmabb*t22*t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*t50*wght+t45)+C
     1           mat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t51*t8*wght+1.0d+0*r
     1           hob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t23*(5.0d-1*rhob*t25*t66*t8*wght+1.25
     1           d-1*gammabb*t22*t52*t8*wght+1.0d+0*t25*t36*t8*wght+1.25
     2           d-1*gammabb*t24*t36*t8*wght+5.0d-1*rhob*t22*t25*t75*wgh
     3           t+1.0d+0*rhob*t25*t36*t44*wght+1.0d+0*t22*t25*t44*wght+
     4           1.25d-1*gammabb*t22*t24*t44*wght)+t23*t24*(1.25d-1*gamm
     5           abb*t36*t8*wght+1.25d-1*gammabb*t22*t44*wght)-1.25d-1*g
     6           ammabb*t22*t23*t52*t8*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t23*(5.0d-1*rhob*t22*t25*t81*wght-1.
     1           25d-1*t36*t8*wght-1.25d-1*t22*t24*t8*wght+5.0d-1*rhob*t
     2           25*t36*t50*wght+5.0d-1*t22*t25*t50*wght-1.25d-1*t22*t44
     3           *wght)+t23*t24*(1.25d-1*gammabb*t22*t50*wght+t76)+Cmat2
     4           (iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = t23*(5.0d-1*rhob*t22*t25*t86*wght-2
     1           .5d-1*t22*t50*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t23*(1.0d+0*rhob*t36*t8*wght+1.0d+0*t
     1           22*t8*wght+1.0d+0*rhob*t22*t44*wght)-1.25d-1*gammabb*t2
     2           2*t24*t51*t8*wght+t51*t87+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.0d+0*rhob*t22*t23*t50*wght+t51*t88
     1           +Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t22*t25*t8*t89*wght-2.0d+
     1           0*rhob*t22*t51*t8*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = t23*(5.0d-1*rhob*t22*t25*(6.0d-2*g
     1           ammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t
     2           3*(-5.836799999999998d-2*t4*t67*t68*t99+1.4745599999999
     3           992d-3*t4*t96*t97*t98+7.274666666666665d-1*t100*t37*t38
     4           *t4-2.737777777777778d+0*gammabb*t101*t3*t4)-5.83679999
     5           9999998d-2*t5*t67*t68*t99+1.4745599999999992d-3*t5*t96*
     6           t97*t98-4.799999999999999d-1*gammabb*t3*t40*t72+2.87999
     7           9999999999d-2*t37*t38*t39*t72+1.76d+0*gammabb*t3*t41*t7
     8           1-2.5919999999999993d-1*t37*t38*t41*t70+9.2159999999999
     9           96d-3*t41*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     :           *t5-2.737777777777778d+0*gammabb*t101*t3*t5)-5.83679999
     ;           9999998d-2*t6*t67*t68*t99+1.4745599999999992d-3*t6*t96*
     <           t97*t98-4.799999999999999d-1*gammabb*t3*t40*t73+2.87999
     =           9999999999d-2*t37*t38*t39*t73+1.76d+0*gammabb*t3*t42*t7
     >           1-2.5919999999999993d-1*t37*t38*t42*t70+9.2159999999999
     ?           96d-3*t42*t67*t68*t69+7.274666666666665d-1*t100*t37*t38
     @           *t6-2.737777777777778d+0*gammabb*t101*t3*t6)-5.83679999
     1           9999998d-2*t67*t68*t7*t99+1.4745599999999992d-3*t7*t96*
     2           t97*t98-4.799999999999999d-1*gammabb*t3*t40*t74+2.87999
     3           9999999999d-2*t37*t38*t39*t74+1.76d+0*gammabb*t3*t43*t7
     4           1-2.5919999999999993d-1*t37*t38*t43*t70+7.2746666666666
     5           65d-1*t100*t37*t38*t7-2.737777777777778d+0*gammabb*t101
     6           *t3*t7+9.215999999999996d-3*t43*t67*t68*t69)*wght+5.0d-
     7           1*rhob*t25*t8*(6.0d+0*t17*t33*t63*t95-1.929837539843104
     8           5d+2*t17*t61*t95/t14**5+2.0690405167709364d+3*t17*t95/(
     9           t14**6*t15**3)+1.1102230246251565d-16*t21*t26*t32*(-2.5
     :           20426340996149d+0*t94-2.3079979182303428d+0*t93-1.50080
     ;           36906238065d+0*t92-5.620753557770543d-1*t40)+1.0d+0*t17
     <           *t33*t35*(-4.684972743248224d+0*t94-3.9871442462415524d
     =           +0*t93-3.083875829189267d+0*t92-7.128507529742789d-1*t4
     >           0)+9.490883560204437d-19*t20*t93+4.1099018897499934d-3*
     ?           t16*t93+6.661338147750939d-16*t21*t26*t55*t91-1.0712750
     @           352598913d-14*t21*t53*t91/t18**5+5.742741051503565d-14*
     1           t21*t91/(t18**6*t19**3)-6.0d+0*t17*t33*t34*t64*t65+9.64
     2           9187699215522d+1*t17*t34*t61*t63*t65-1.274696188700087d
     3           -1*t29*t33*t35*t65+2.549392377400174d-1*t29*t33*t62*t64
     4           -4.0999275947472624d+0*t29*t61*t62*t63-6.66133814775093
     5           9d-16*t21*t26*t31*t56*t60+5.356375176299456d-15*t21*t31
     6           *t53*t55*t60-1.4718104502398274d-17*t26*t29*t32*t60+1.6
     7           995949182667827d-1*t33*t34*t35*t58+1.962413933653103d-1
     8           7*t26*t31*t32*t58+2.943620900479655d-17*t26*t29*t54*t56
     9           -2.3669625486718335d-16*t29*t53*t54*t55)*wght-2.5d-1*ga
     :           mmabb*t22*t8*t90*wght+1.5d+0*t25*t66*t8*wght+2.5d-1*gam
     ;           mabb*t24*t66*t8*wght+2.5d-1*gammabb*t36*t52*t8*wght+1.5
     <           d+0*rhob*t25*t36*t75*wght+1.5d+0*t22*t25*t75*wght+2.5d-
     =           1*gammabb*t22*t24*t75*wght+1.5d+0*rhob*t25*t44*t66*wght
     >           +2.5d-1*gammabb*t22*t44*t52*wght+3.0d+0*t25*t36*t44*wgh
     ?           t+5.0d-1*gammabb*t24*t36*t44*wght)+t23*t24*(1.25d-1*gam
     @           mabb*t66*t8*wght+1.25d-1*gammabb*t22*t75*wght+2.5d-1*ga
     1           mmabb*t36*t44*wght)+t23*t52*(-2.5d-1*gammabb*t36*t8*wgh
     2           t-2.5d-1*gammabb*t22*t44*wght)+2.5d-1*gammabb*t22*t23*t
     3           8*t90*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = t23*(5.0d-1*rhob*t22*t25*(6.0d-2*
     1           gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*
     2           t3*(-5.529599999999998d-4*t105*t4*t67*t97+5.86666666666
     3           6666d-1*t3*t4*t71-2.0799999999999996d-1*gammabb*t38*t4*
     4           t70+1.9583999999999993d-2*t37*t4*t68*t69)-5.52959999999
     5           9998d-4*t105*t5*t67*t97-3.1999999999999995d-1*gammabb*t
     6           3*t40*t78+1.9199999999999995d-2*t37*t38*t39*t78-2.30399
     7           9999999999d-3*t37*t41*t68*t77-3.6d-3*gammabb*t38*t46*t7
     8           2+6.0d-2*t1*t3*t72+5.866666666666666d-1*t3*t5*t71+5.866
     9           666666666666d-1*gammabb*t3*t47*t71-2.0799999999999996d-
     :           1*gammabb*t38*t5*t70-8.639999999999998d-2*t37*t38*t47*t
     ;           70+3.0719999999999986d-3*t47*t67*t68*t69+1.958399999999
     <           9993d-2*t37*t5*t68*t69-3.1999999999999995d-1*t3*t40*t41
     =           +5.759999999999998d-2*gammabb*t38*t39*t41)-5.5295999999
     >           99998d-4*t105*t6*t67*t97-3.1999999999999995d-1*gammabb*
     ?           t3*t40*t79+1.9199999999999995d-2*t37*t38*t39*t79-2.3039
     @           99999999999d-3*t37*t42*t68*t77-3.6d-3*gammabb*t38*t46*t
     1           73+6.0d-2*t1*t3*t73+5.866666666666666d-1*t3*t6*t71+5.86
     2           6666666666666d-1*gammabb*t3*t48*t71-2.0799999999999996d
     3           -1*gammabb*t38*t6*t70-8.639999999999998d-2*t37*t38*t48*
     4           t70+3.0719999999999986d-3*t48*t67*t68*t69+1.95839999999
     5           99993d-2*t37*t6*t68*t69-3.1999999999999995d-1*t3*t40*t4
     6           2+5.759999999999998d-2*gammabb*t38*t39*t42)-5.529599999
     7           999998d-4*t105*t67*t7*t97-3.1999999999999995d-1*gammabb
     8           *t3*t40*t80+1.9199999999999995d-2*t37*t38*t39*t80-2.303
     9           999999999999d-3*t37*t43*t68*t77-3.6d-3*gammabb*t38*t46*
     :           t74+6.0d-2*t1*t3*t74+5.866666666666666d-1*t3*t7*t71+5.8
     ;           66666666666666d-1*gammabb*t3*t49*t71-2.0799999999999996
     <           d-1*gammabb*t38*t7*t70-8.639999999999998d-2*t37*t38*t49
     =           *t70+1.9583999999999993d-2*t37*t68*t69*t7+3.07199999999
     >           99986d-3*t49*t67*t68*t69-3.1999999999999995d-1*t3*t40*t
     ?           43+5.759999999999998d-2*gammabb*t38*t39*t43)*wght+1.0d+
     @           0*rhob*t25*t36*t81*wght+1.0d+0*t22*t25*t81*wght+1.25d-1
     1           *gammabb*t22*t24*t81*wght-1.25d-1*t66*t8*wght+1.25d-1*t
     2           22*t52*t8*wght-1.25d-1*t24*t36*t8*wght-1.25d-1*t22*t75*
     3           wght+5.0d-1*rhob*t25*t50*t66*wght+1.25d-1*gammabb*t22*t
     4           50*t52*wght+1.0d+0*t25*t36*t50*wght+1.25d-1*gammabb*t24
     5           *t36*t50*wght-2.5d-1*t36*t44*wght-1.25d-1*t22*t24*t44*w
     6           ght)+t23*t24*(1.25d-1*gammabb*t22*t81*wght+1.25d-1*gamm
     7           abb*t36*t50*wght+t103+t102)+t104*t23*t52+Cmat3(iq,D3_RB
     8           _RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = t23*(5.0d-1*rhob*t22*t25*(6.0d-2
     1           *gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1
     2           *t3*(2.073599999999999d-4*t107*t37*t4*t97-5.75999999999
     3           9997d-3*gammabb*t4*t68*t77+3.839999999999999d-2*t38*t39
     4           *t4)+2.073599999999999d-4*t107*t37*t5*t97-1.59999999999
     5           99998d-1*gammabb*t3*t40*t83+9.599999999999997d-3*t37*t3
     6           8*t39*t83+4.32d-4*gammabb*t41*t68*t82-7.2d-3*gammabb*t3
     7           8*t46*t78+1.2d-1*t1*t3*t78-5.759999999999997d-3*gammabb
     8           *t5*t68*t77-2.303999999999999d-3*t37*t47*t68*t77+3.8399
     9           99999999999d-2*t38*t39*t5-3.1999999999999995d-1*t3*t40*
     :           t47+5.759999999999998d-2*gammabb*t38*t39*t47-7.2d-3*t38
     ;           *t41*t46)+2.073599999999999d-4*t107*t37*t6*t97-1.599999
     <           9999999998d-1*gammabb*t3*t40*t84+9.599999999999997d-3*t
     =           37*t38*t39*t84+4.32d-4*gammabb*t42*t68*t82-7.2d-3*gamma
     >           bb*t38*t46*t79+1.2d-1*t1*t3*t79-5.759999999999997d-3*ga
     ?           mmabb*t6*t68*t77-2.303999999999999d-3*t37*t48*t68*t77+3
     @           .839999999999999d-2*t38*t39*t6-3.1999999999999995d-1*t3
     1           *t40*t48+5.759999999999998d-2*gammabb*t38*t39*t48-7.2d-
     2           3*t38*t42*t46)+2.073599999999999d-4*t107*t37*t7*t97-1.5
     3           999999999999998d-1*gammabb*t3*t40*t85+9.599999999999997
     4           d-3*t37*t38*t39*t85+4.32d-4*gammabb*t43*t68*t82-7.2d-3*
     5           gammabb*t38*t46*t80+1.2d-1*t1*t3*t80-5.759999999999997d
     6           -3*gammabb*t68*t7*t77-2.303999999999999d-3*t37*t49*t68*
     7           t77+3.839999999999999d-2*t38*t39*t7-3.1999999999999995d
     8           -1*t3*t40*t49+5.759999999999998d-2*gammabb*t38*t39*t49-
     9           7.2d-3*t38*t43*t46)*wght+5.0d-1*rhob*t25*t36*t86*wght+5
     :           .0d-1*t22*t25*t86*wght-2.5d-1*t22*t81*wght-2.5d-1*t36*t
     ;           50*wght-2.5d-1*t22*t24*t50*wght)+t23*t24*(1.25d-1*gamma
     <           bb*t22*t86*wght+t106)+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = t23*(5.0d-1*rhob*t22*t25*(6.0d-
     1           2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t
     2           1*t3*(1.296d-3*t4*t68*t82-7.776d-5*gammabb*t108*t4*t97)
     3           -7.776d-5*gammabb*t108*t5*t97-1.0800000000000001d-2*gam
     4           mabb*t38*t46*t83+1.8d-1*t1*t3*t83+1.296d-3*t5*t68*t82+1
     5           .296d-3*gammabb*t47*t68*t82-2.1600000000000003d-2*t38*t
     6           46*t47)-7.776d-5*gammabb*t108*t6*t97-1.0800000000000001
     7           d-2*gammabb*t38*t46*t84+1.8d-1*t1*t3*t84+1.296d-3*t6*t6
     8           8*t82+1.296d-3*gammabb*t48*t68*t82-2.1600000000000003d-
     9           2*t38*t46*t48)-7.776d-5*gammabb*t108*t7*t97-1.080000000
     :           0000001d-2*gammabb*t38*t46*t85+1.8d-1*t1*t3*t85+1.296d-
     ;           3*t68*t7*t82+1.296d-3*gammabb*t49*t68*t82-2.16000000000
     <           00003d-2*t38*t46*t49)*wght-3.75d-1*t22*t86*wght)+Cmat3(
     =           iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = t51*(-5.0d-1*rhob*t25*t66*t8*wght-
     1           1.25d-1*gammabb*t22*t52*t8*wght-1.0d+0*t25*t36*t8*wght-
     2           1.25d-1*gammabb*t24*t36*t8*wght-5.0d-1*rhob*t22*t25*t75
     3           *wght-1.0d+0*rhob*t25*t36*t44*wght-1.0d+0*t22*t25*t44*w
     4           ght-1.25d-1*gammabb*t22*t24*t44*wght)+t23*(1.0d+0*rhob*
     5           t66*t8*wght+2.0d+0*t36*t8*wght+1.0d+0*rhob*t22*t75*wght
     6           +2.0d+0*rhob*t36*t44*wght+2.0d+0*t22*t44*wght)+t24*t51*
     7           (-1.25d-1*gammabb*t36*t8*wght-1.25d-1*gammabb*t22*t44*w
     8           ght)+1.25d-1*gammabb*t22*t51*t52*t8*wght+Mmat3(iq,D3_RB
     9           _RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = t51*(-5.0d-1*rhob*t22*t25*t81*wgh
     1           t+1.25d-1*t22*t24*t8*wght-5.0d-1*rhob*t25*t36*t50*wght-
     2           5.0d-1*t22*t25*t50*wght+t103+t102)+t23*(1.0d+0*rhob*t22
     3           *t81*wght+1.0d+0*rhob*t36*t50*wght+1.0d+0*t22*t50*wght)
     4           +t104*t24*t51+Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = t51*(t106-5.0d-1*rhob*t22*t25*t8
     1           6*wght)+1.0d+0*rhob*t22*t23*t86*wght+Mmat3(iq,D3_GBB_GB
     2           B_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = t51*(-2.0d+0*rhob*t36*t8*wght-2.0d
     1           +0*t22*t8*wght-2.0d+0*rhob*t22*t44*wght)+2.5d-1*gammabb
     2           *t22*t24*t8*t89*wght-2*t87*t89+Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = -2.0d+0*rhob*t22*t50*t51*wght-2*t
     1           88*t89+Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = -3.0d+0*rhob*t22*t25*t8*wght/taub*
     1           *4+6.0d+0*rhob*t22*t8*t89*wght+Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 2.4d-51*t1*t3*t4+param(9)
              t6 = 2.4d-51*t1*t3*t5+param(8)
              t7 = 2.4d-51*t1*t3*t6+param(7)
              t8 = 2.4d-51*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/t19
              t24 = 1/t10**3
              t25 = 1/rhob**1.3333333333333333d+0
              t26 = 1/rhob**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t18**2
              t29 = 1/t15
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t14**2
              t32 = 1.0d+0*t17*t29*t30*t31+1.1102230246251565d-16*t21*t2
     1           3*t27*t28+3.0506411443514264d-19*t20*t25+1.321039893133
     2           9265d-3*t16*t25
              t33 = 1/t2**2
              t34 = 1/rhob**4.333333333333333d+0
              t35 = 1/rhob**2.6666666666666666d+0
              t36 = 9.6d-102*t33*t34*t4-4.0d-51*t3*t35*t4
              t37 = -4.0d-51*t3*t35*t5+9.6d-102*t33*t34*t5+2.4d-51*t1*t3
     1           *t36
              t38 = -4.0d-51*t3*t35*t6+9.6d-102*t33*t34*t6+2.4d-51*t1*t3
     1           *t37
              t39 = -4.0d-51*t3*t35*t7+9.6d-102*t33*t34*t7+2.4d-51*t1*t3
     1           *t38
              t40 = 1/t19**2
              t41 = t27**2
              t42 = 1/t18**4
              t43 = 1/t18**3
              t44 = 1/t10**5
              t45 = 1/rhob**2.3333333333333334d+0
              t46 = 1/rhob**2.1666666666666665d+0
              t47 = 1.1632736958443765d+0*t46+9.89141964955861d-1*t45+6.
     1           003214762495226d-1*t44+2.1077825841639536d-1*t35
              t48 = 1/t15**2
              t49 = t30**2
              t50 = 1/t14**4
              t51 = 1/t14**3
              t52 = 2.1622951122684114d+0*t46+1.7087761055320938d+0*t45+
     1           1.2335503316757068d+0*t44+2.673190323653546d-1*t35
              t53 = 1.0d+0*t17*t29*t31*t52-2.0d+0*t17*t29*t49*t51+3.2163
     1           95899738507d+1*t17*t48*t49*t50+1.1102230246251565d-16*t
     2           21*t23*t28*t47-4.0675215258019015d-19*t20*t45-1.7613865
     3           241785684d-3*t16*t45-2.220446049250313d-16*t21*t23*t41*
     4           t43+1.7854583920998188d-15*t21*t40*t41*t42-8.4979745913
     5           33913d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*
     6           t27*t28
              t54 = 1/t2**3
              t55 = 1/rhob**7
              t56 = 1/rhob**5.333333333333333d+0
              t57 = 1/rhob**3.6666666666666664d+0
              t58 = 1.0666666666666666d-50*t3*t4*t57-5.76d-101*t33*t4*t5
     1           6+7.68d-152*t4*t54*t55
              t59 = 2.4d-51*t1*t3*t58+1.0666666666666666d-50*t3*t5*t57-5
     1           .76d-101*t33*t5*t56+7.68d-152*t5*t54*t55-8.0d-51*t3*t35
     2           *t36+1.92d-101*t33*t34*t36
              t60 = 1.0666666666666666d-50*t3*t57*t6-5.76d-101*t33*t56*t
     1           6+7.68d-152*t54*t55*t6+2.4d-51*t1*t3*t59-8.0d-51*t3*t35
     2           *t37+1.92d-101*t33*t34*t37
              t61 = 1.0666666666666666d-50*t3*t57*t7-5.76d-101*t33*t56*t
     1           7+7.68d-152*t54*t55*t7+2.4d-51*t1*t3*t60-8.0d-51*t3*t35
     2           *t38+1.92d-101*t33*t34*t38
              t62 = t27**3
              t63 = 1/t10**7
              t64 = 1/rhob**3.3333333333333337d+0
              t65 = 1/rhob**3.1666666666666665d+0
              t66 = t30**3
              t67 = 1/t2**4
              t68 = 1/rhob**9.666666666666666d+0
              t69 = 1/rhob**8
              t70 = 1/rhob**6.333333333333333d+0
              t71 = 1/rhob**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhob*t22*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t32*t8*wght+5.0d-1*t22*t8*wgh
     1           t+5.0d-1*rhob*t22*t39*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*t53*t8*wght+1.0d+0*t32*t8
     1           *wght+5.0d-1*rhob*t22*t61*wght+1.0d+0*rhob*t32*t39*wght
     2           +1.0d+0*t22*t39*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = 5.0d-1*rhob*(6.0d+0*t17*t29*t50*t6
     1           6-1.9298375398431045d+2*t17*t48*t66/t14**5+2.0690405167
     2           709364d+3*t17*t66/(t14**6*t15**3)+1.1102230246251565d-1
     3           6*t21*t23*t28*(-2.520426340996149d+0*t65-2.307997918230
     4           3428d+0*t64-1.5008036906238065d+0*t63-5.620753557770543
     5           d-1*t57)+1.0d+0*t17*t29*t31*(-4.684972743248224d+0*t65-
     6           3.9871442462415524d+0*t64-3.083875829189267d+0*t63-7.12
     7           8507529742789d-1*t57)+9.490883560204437d-19*t20*t64+4.1
     8           099018897499934d-3*t16*t64+6.661338147750939d-16*t21*t2
     9           3*t42*t62-1.0712750352598913d-14*t21*t40*t62/t18**5+5.7
     :           42741051503565d-14*t21*t62/(t18**6*t19**3)-6.0d+0*t17*t
     ;           29*t30*t51*t52+9.649187699215522d+1*t17*t30*t48*t50*t52
     <           -1.274696188700087d-1*t25*t29*t31*t52+2.549392377400174
     =           d-1*t25*t29*t49*t51-4.0999275947472624d+0*t25*t48*t49*t
     >           50-6.661338147750939d-16*t21*t23*t27*t43*t47+5.35637517
     ?           6299456d-15*t21*t27*t40*t42*t47-1.4718104502398274d-17*
     @           t23*t25*t28*t47+1.6995949182667827d-1*t29*t30*t31*t45+1
     1           .962413933653103d-17*t23*t27*t28*t45+2.943620900479655d
     2           -17*t23*t25*t41*t43-2.3669625486718335d-16*t25*t40*t41*
     3           t42)*t8*wght+1.5d+0*t53*t8*wght+5.0d-1*rhob*t22*(2.4d-5
     4           1*t1*t3*(2.4d-51*t1*t3*(2.4d-51*t1*t3*(-3.9111111111111
     5           11d-50*t3*t4*t71+3.4986666666666666d-100*t33*t4*t70-9.9
     6           84000000000001d-151*t4*t54*t69+9.216000000000001d-202*t
     7           4*t67*t68)-3.911111111111111d-50*t3*t5*t71+3.4986666666
     8           666666d-100*t33*t5*t70-9.984000000000001d-151*t5*t54*t6
     9           9+9.216000000000001d-202*t5*t67*t68-1.2d-50*t3*t35*t58+
     :           2.88d-101*t33*t34*t58+3.2d-50*t3*t36*t57-1.727999999999
     ;           9998d-100*t33*t36*t56+2.3040000000000002d-151*t36*t54*t
     <           55)-3.911111111111111d-50*t3*t6*t71+3.4986666666666666d
     =           -100*t33*t6*t70-9.984000000000001d-151*t54*t6*t69+9.216
     >           000000000001d-202*t6*t67*t68-1.2d-50*t3*t35*t59+2.88d-1
     ?           01*t33*t34*t59+3.2d-50*t3*t37*t57-1.7279999999999998d-1
     @           00*t33*t37*t56+2.3040000000000002d-151*t37*t54*t55)-3.9
     1           11111111111111d-50*t3*t7*t71+3.4986666666666666d-100*t3
     2           3*t7*t70-9.984000000000001d-151*t54*t69*t7+9.2160000000
     3           00001d-202*t67*t68*t7-1.2d-50*t3*t35*t60+2.88d-101*t33*
     4           t34*t60+3.2d-50*t3*t38*t57-1.7279999999999998d-100*t33*
     5           t38*t56+2.3040000000000002d-151*t38*t54*t55)*wght+1.5d+
     6           0*rhob*t32*t61*wght+1.5d+0*t22*t61*wght+1.5d+0*rhob*t39
     7           *t53*wght+3.0d+0*t32*t39*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(10)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(9)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(8)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(7)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(6)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1/t19
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 1/t10**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t27
              t32 = 1/t18**2
              t33 = 1/t15
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t27
              t35 = 1/t14**2
              t36 = 1.0d+0*t17*t33*t34*t35+1.1102230246251565d-16*t21*t2
     1           6*t31*t32+3.0506411443514264d-19*t20*t29+1.321039893133
     2           9265d-3*t16*t29
              t37 = gammabb**2
              t38 = 1/t2**2
              t39 = 1/rhob**6.333333333333333d+0
              t40 = 1/rhob**3.6666666666666664d+0
              t41 = 9.599999999999997d-3*t37*t38*t39*t4-1.59999999999999
     1           98d-1*gammabb*t3*t4*t40
              t42 = -1.5999999999999998d-1*gammabb*t3*t40*t5+9.599999999
     1           999997d-3*t37*t38*t39*t5+6.0d-2*gammabb*t1*t3*t41
              t43 = -1.5999999999999998d-1*gammabb*t3*t40*t6+9.599999999
     1           999997d-3*t37*t38*t39*t6+6.0d-2*gammabb*t1*t3*t42
              t44 = -1.5999999999999998d-1*gammabb*t3*t40*t7+9.599999999
     1           999997d-3*t37*t38*t39*t7+6.0d-2*gammabb*t1*t3*t43
              t45 = -1.25d-1*t22*t8*wght
              t46 = 1/rhob**5.333333333333333d+0
              t47 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t38*t4*t46
              t48 = -3.6d-3*gammabb*t38*t46*t5+6.0d-2*t1*t3*t5+6.0d-2*ga
     1           mmabb*t1*t3*t47
              t49 = -3.6d-3*gammabb*t38*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*ga
     1           mmabb*t1*t3*t48
              t50 = -3.6d-3*gammabb*t38*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t49
              t51 = 1/taub**2
              t52 = 1/rhob**2
              t53 = 1/t19**2
              t54 = t31**2
              t55 = 1/t18**4
              t56 = 1/t18**3
              t57 = 1/t10**5
              t58 = 1/rhob**2.3333333333333334d+0
              t59 = 1/rhob**2.1666666666666665d+0
              t60 = 1.1632736958443765d+0*t59+9.89141964955861d-1*t58+6.
     1           003214762495226d-1*t57+2.1077825841639536d-1*t1
              t61 = 1/t15**2
              t62 = t34**2
              t63 = 1/t14**4
              t64 = 1/t14**3
              t65 = 2.1622951122684114d+0*t59+1.7087761055320938d+0*t58+
     1           1.2335503316757068d+0*t57+2.673190323653546d-1*t1
              t66 = 1.0d+0*t17*t33*t35*t65-2.0d+0*t17*t33*t62*t64+3.2163
     1           95899738507d+1*t17*t61*t62*t63+1.1102230246251565d-16*t
     2           21*t26*t32*t60-4.0675215258019015d-19*t20*t58-1.7613865
     3           241785684d-3*t16*t58-2.220446049250313d-16*t21*t26*t54*
     4           t56+1.7854583920998188d-15*t21*t53*t54*t55-8.4979745913
     5           33913d-2*t29*t33*t34*t35-9.812069668265515d-18*t26*t29*
     6           t31*t32
              t67 = gammabb**3
              t68 = 1/t2**3
              t69 = 1/rhob**10
              t70 = 1/rhob**7.333333333333333d+0
              t71 = 1/rhob**4.666666666666667d+0
              t72 = 5.866666666666666d-1*gammabb*t3*t4*t71-8.63999999999
     1           9998d-2*t37*t38*t4*t70+3.0719999999999986d-3*t4*t67*t68
     2           *t69
              t73 = 6.0d-2*gammabb*t1*t3*t72+5.866666666666666d-1*gammab
     1           b*t3*t5*t71-8.639999999999998d-2*t37*t38*t5*t70+3.07199
     2           99999999986d-3*t5*t67*t68*t69-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t41+1.9199999999999995d-2*t37*t38*t39*t41
              t74 = 6.0d-2*gammabb*t1*t3*t73+5.866666666666666d-1*gammab
     1           b*t3*t6*t71-8.639999999999998d-2*t37*t38*t6*t70+3.07199
     2           99999999986d-3*t6*t67*t68*t69-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t42+1.9199999999999995d-2*t37*t38*t39*t42
              t75 = 6.0d-2*gammabb*t1*t3*t74+5.866666666666666d-1*gammab
     1           b*t3*t7*t71-8.639999999999998d-2*t37*t38*t7*t70+3.07199
     2           99999999986d-3*t67*t68*t69*t7-3.1999999999999995d-1*gam
     3           mabb*t3*t40*t43+1.9199999999999995d-2*t37*t38*t39*t43
              t76 = 1.25d-1*t22*t8*wght
              t77 = 1/rhob**9
              t78 = -1.1519999999999996d-3*t37*t4*t68*t77-1.599999999999
     1           9998d-1*t3*t4*t40+2.879999999999999d-2*gammabb*t38*t39*
     2           t4
              t79 = 6.0d-2*gammabb*t1*t3*t78-1.1519999999999996d-3*t37*t
     1           5*t68*t77-1.5999999999999998d-1*t3*t40*t5+2.87999999999
     2           9999d-2*gammabb*t38*t39*t5-1.5999999999999998d-1*gammab
     3           b*t3*t40*t47+9.599999999999997d-3*t37*t38*t39*t47-3.6d-
     4           3*gammabb*t38*t41*t46+6.0d-2*t1*t3*t41
              t80 = 6.0d-2*gammabb*t1*t3*t79-1.1519999999999996d-3*t37*t
     1           6*t68*t77-1.5999999999999998d-1*t3*t40*t6+2.87999999999
     2           9999d-2*gammabb*t38*t39*t6-1.5999999999999998d-1*gammab
     3           b*t3*t40*t48+9.599999999999997d-3*t37*t38*t39*t48-3.6d-
     4           3*gammabb*t38*t42*t46+6.0d-2*t1*t3*t42
              t81 = 6.0d-2*gammabb*t1*t3*t80-1.1519999999999996d-3*t37*t
     1           68*t7*t77-1.5999999999999998d-1*t3*t40*t7+2.87999999999
     2           9999d-2*gammabb*t38*t39*t7-1.5999999999999998d-1*gammab
     3           b*t3*t40*t49+9.599999999999997d-3*t37*t38*t39*t49-3.6d-
     4           3*gammabb*t38*t43*t46+6.0d-2*t1*t3*t43
              t82 = 1/rhob**8
              t83 = 4.32d-4*gammabb*t4*t68*t82-7.2d-3*t38*t4*t46
              t84 = 6.0d-2*gammabb*t1*t3*t83+4.32d-4*gammabb*t5*t68*t82-
     1           7.2d-3*t38*t46*t5-7.2d-3*gammabb*t38*t46*t47+1.2d-1*t1*
     2           t3*t47
              t85 = 6.0d-2*gammabb*t1*t3*t84+4.32d-4*gammabb*t6*t68*t82-
     1           7.2d-3*t38*t46*t6-7.2d-3*gammabb*t38*t46*t48+1.2d-1*t1*
     2           t3*t48
              t86 = 6.0d-2*gammabb*t1*t3*t85+4.32d-4*gammabb*t68*t7*t82-
     1           7.2d-3*t38*t46*t7-7.2d-3*gammabb*t38*t46*t49+1.2d-1*t1*
     2           t3*t49
              t87 = -5.0d-1*rhob*t25*t36*t8*wght-5.0d-1*t22*t25*t8*wght-
     1           5.0d-1*rhob*t22*t25*t44*wght
              t88 = t76-5.0d-1*rhob*t22*t25*t50*wght
              t89 = 1/taub**3
              t90 = 1/rhob**3
              t91 = t31**3
              t92 = 1/t10**7
              t93 = 1/rhob**3.3333333333333337d+0
              t94 = 1/rhob**3.1666666666666665d+0
              t95 = t34**3
              t96 = gammabb**4
              t97 = 1/t2**4
              t98 = 1/rhob**1.3666666666666666d+1
              t99 = 1/rhob**11
              t100 = 1/rhob**8.333333333333334d+0
              t101 = 1/rhob**5.666666666666667d+0
              t102 = 1.25d-1*t36*t8*wght
              t103 = 1.25d-1*t22*t44*wght
              t104 = t45-1.25d-1*gammabb*t22*t50*wght
              t105 = 1/rhob**1.2666666666666665d+1
              t106 = 2.5d-1*t22*t50*wght
              t107 = 1/rhob**1.1666666666666665d+1
              t108 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhob*t22*t23*t25*t8*wght+fnc(iq)
              Amat(iq,D1_RB) = t23*(5.0d-1*rhob*t25*t36*t8*wght+5.0d-1*t
     1           22*t25*t8*wght+5.0d-1*rhob*t22*t25*t44*wght)+1.25d-1*ga
     2           mmabb*t22*t23*t24*t8*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t23*(5.0d-1*rhob*t22*t25*t50*wght+t45)+C
     1           mat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t22*t25*t51*t8*wght+1.0d+0*r
     1           hob*t22*t23*t8*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
