/* $Id: experiments.h,v 1.27 2004/10/22 00:03:08 graziano Exp $ */

#ifndef EXP_PROTOCOL_H
#define EXP_PROTOCOL_H

#include <sys/types.h>

#include "hosts.h"
#include "register.h"
#include "nws_api.h"

#ifdef __cplusplus
extern "C" {
#endif


#define EXP_LABEL_SIZE (31 + 1)
#define EXP_LIST_SIZE (255 + 1)
#define EXP_NAME_SIZE (63 + 1)

/* the experiment format for printf */
#define WEXP_FORMAT "%11.0f %20.5f"


/*
** Contacts the memory connected to #mem_c# to retrieve experiment information
** for the experiment named #exp_name#.  Connects #mem_c# if necessary.  Begins
** retrieval with the first record recorded after time #seq_no#; a non-positive
** value for this parameter indicates that retrieval should begin with the
** first record.  If successful within #timeout# seconds, returns and 1 and
** stores into the array #exper# at most #count# records, along with storing
** the number of records retrieved in #out_count# and the timestamp of the
** final record in #out_seq_no#; otherwise, returns 0.  The newest experiment
** retrieved is stored in exper[0], the oldest in exper[*out_count - 1].
*/
int
LoadExperiments(struct host_cookie *mem_c,
                const char *exp_name,
                NWSAPI_Measurement *exper,
                size_t count,
                double seq_no,
                size_t *out_count,
                double *out_seq_no,
                double timeout);


/**
 * Stores in the memory connected to #mem_c# the experiments in the
 * #count#-long array #exper#, marking the experiments to expire after
 * #forHowLong# seconds.  Connects #mem_c# if necessary. Uses the new
 * STORE_AND_REGISTER message, asking the memory to register the series
 * to the nameserver.  Returns 1 if successful, 0 otherwise.
 */
int
StoreNewExperiments(	struct host_cookie *mem_c,
			const char *id,
			const NWSAPI_Measurement *exper,
			size_t count,
			double forHowLong);


#ifdef __cplusplus
}
#endif

#endif
