/* $Id: connect_exp.c,v 1.32 2004/11/09 22:27:15 graziano Exp $ */

#include "config_nws.h"

#include <stdlib.h> 

#include "diagnostic.h"
#include "osutil.h"
#include "connect_exp.h"
#include "host_protocol.h"
#include "strutil.h"

int
InitiateConnectExp(IPAddress machine,
                   unsigned short port,
                   unsigned int timeOut,
                   double *results) {
	Socket sd;
	long starTime;
	long stopTime;
	char *tmp;

	starTime = MicroTime();
	if(!CallAddr(machine, port, &sd, (double)timeOut)) {
		tmp = IPAddressImage_r(machine);
		ERROR2("InitiateConnectExp: contact of %s:%d failed\n", tmp, port);
		free(tmp);
		return 0;
	}
	stopTime = MicroTime();
	DROP_SOCKET(&sd);
	*results = (stopTime - starTime) / 1000.0;

	return(1);
}

int
TcpConnectAvailable(const char *options) {
	return 1;
}

void
TcpConnectUseSkill(     const char *options,
			int *length,
			SkillResult **results) {

	struct host_cookie host;
	const char *c;
	char name[63 + 1], opts[255+1], *tmp;
	double res, timeout;
	int ret;
	IPAddress address;

	/* get common values */
	tmp = GetOptionValue(options, "timeout", "-1");
	timeout = strtod(tmp, NULL);
	FREE(tmp);

	/* Conduct a connect experiment with each host in the target
	 * option. */
	tmp = GetOptionValue(options, "target", "");
	for(c = tmp; GETTOK(name, c, ",", &c);) {
		ret = 0;
		Host2Cookie(name, DefaultHostPort(SENSOR_HOST), &host);
		if (!IPAddressValue(host.name, &address)) {
			WARN("TcpConnectUseSkill: couldn't resolve hostname\n");
		} else {
			vstrncpy(opts, sizeof(opts), 2, "target:", HostCImage(&host));
			ret = InitiateConnectExp(address, host.port, timeout, &res);
		}
		AppendResult(connectTimeTcp, opts, ret, res, length, results);
	}
	FREE(tmp);
}
