/*

The NWS OpenLDAP backend can be configured as follows:

database		nws		# all backend-specific configs go here
suffix			"service=NWS, o=Grid"	
rootdn			"cn=Manager, service=NWS, o=Grid"
nws_nameserver	hostname.dom.ain[:port]	# where to get registration objects
nws_forecaster	hostname.dom.ain[:port] # to specify external forecasting
nws_vo_grid		name type [filename]
nws_forecaster_size number #number of values stored in the forecaster state
nws_data_size number #number of values stored in the data state
nws_initial_fetch_size  number #number of values to get from the memory
nws_min_refresh_period number #minimum seconds between series refresh

*/

#include "portable.h"
#include <stdio.h>
#include <ac/socket.h>
#include <ac/string.h>
#include <ac/time.h>
#include "nws_back_cache.h"
#include "nws_back.h"
#include "slap.h"
#include "external.h"

int
nws_back_db_config(BackendDB *be, const char *fname, int lineno,
				   int argc, char **argv)
{
  nwsBackConfig *nbc;
  nwsCacheConfig *ncc;

  Debug(LDAP_DEBUG_TRACE,"==>nws_back_db_config()\n",0,0,0);

  nbc = (nwsBackConfig *)be->be_private;
  ncc = (nwsCacheConfig *)be->be_private;

  if (!nbc)  {
	Debug(LDAP_DEBUG_TRACE,"nws_back_db_config: be_private is NULL.\n",0,0,0);
	exit(1);
  }

if (!strcasecmp(argv[0],"nws_min_refresh_period")) {
	if (argc < 2) {
     Debug(LDAP_DEBUG_TRACE,
		   "<==nws_back_db_config (%s line %d): missing argument to nws_min_refresh_period directive\n",
		   fname,lineno,0);
   }
   else {
	 nbc->min_refresh_period = atoi(argv[1]);
   }
	Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_min_refresh_period=%d\n",
		  nbc->min_refresh_period,0,0);
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_initial_fetch_size")) {
	if (argc < 2) {
     Debug(LDAP_DEBUG_TRACE,
		   "<==nws_back_db_config (%s line %d): missing argument to nws_initial_fetch_size directive\n",
		   fname,lineno,0);
   }
   else {
	 nbc->initial_fetch_size = atoi(argv[1]);
   }
	Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_initial_fetch_size=%d\n",
		  nbc->initial_fetch_size,0,0);
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_forecaster_size")) {
	if (argc < 2) {
     Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config (%s line %d): missing argument to nws_forecaster_size directive\n",
                     fname,lineno,0);
   }
   else {
	 nbc->max_forc_entries = atoi(argv[1]);
   }
	Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_forecaster_size=%d\n",
		  nbc->max_forc_entries,0,0);
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_data_size")) {
	if (argc < 2) {
     Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config (%s line %d): missing argument to nws_forecaster_size directive\n",
                     fname,lineno,0);
	}
	else {
	  nbc->max_data_entries = atoi(argv[1]);
	}
	Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_data_size=%d\n",
		  nbc->max_data_entries,0,0);
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_nameserver")) {
   if (argc < 2) {
     Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config (%s line %d): missing argument to nws_nameserver directive\n",
                     fname,lineno,0);
   }
   else {
	 char *tmp_ptr;
	 if ((tmp_ptr = strchr(argv[1], ':')) != NULL) {
	   *tmp_ptr = '\0';
	   tmp_ptr++;
	   nbc->ns_cookie.port = atoi(tmp_ptr);
	 }
	 else {
	   nbc->ns_cookie.port = 8090;
	 }
	 strcpy(nbc->ns_cookie.name, argv[1]);
	 Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_nameserver=%s:%d\n",nbc->ns_cookie.name,nbc->ns_cookie.port,0);
   }
   return(0);
  }
  
  if (!strcasecmp(argv[0],"nws_forecaster")) {
	if (argc < 2) {
	  Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config (%s line %d): missing argument to nws_forecaster directive\n", fname,lineno,0);
    }
	else {
	  char *tmp_ptr;
	  if ((tmp_ptr = strchr(argv[1], ':')) != NULL) {
		*tmp_ptr = '\0';
		tmp_ptr++;
		nbc->forc_cookie.port = atoi(tmp_ptr);
	  }
	  else {
		nbc->forc_cookie.port = 8070;
	  }
	  strcpy(nbc->forc_cookie.name, argv[1]);
	  Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config(): nws_forecaster=%s:%d\n",nbc->forc_cookie.name,nbc->forc_cookie.port,0);
	}
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_archive")) {
	nbc->arch_count++;
	nbc->arch_list = realloc(nbc->arch_list,
							 sizeof(archiveTarget *) * nbc->arch_count + 1);
	if (nbc->arch_list == NULL) {
	  perror("realloc failed");
	  exit(-1);
	}

	nbc->arch_list[nbc->arch_count-1] = malloc(sizeof(archiveTarget));
	nbc->arch_list[nbc->arch_count] = NULL;

	if (nbc->arch_list[nbc->arch_count-1] == NULL) {
	  perror("malloc failed");
	  exit(-1);
	}

	if (argc < 4) {
	  Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_config (%s line %d): incorrect arguments to nws_archive directive\n", fname,lineno,0);
    }
	else  {
	  nbc->arch_list[nbc->arch_count-1]->server = strdup(argv[1]);
	  nbc->arch_list[nbc->arch_count-1]->base = strdup(argv[2]);
	  nbc->arch_list[nbc->arch_count-1]->filter = strdup(argv[3]);
    }
	return(0);
  }

  if (!strcasecmp(argv[0],"nws_vo_grid")) {
	nbc->grid_count++;
	nbc->grid_list = realloc(nbc->grid_list,
							 sizeof(gridTarget *) * nbc->grid_count + 1);
	if (nbc->grid_list == NULL) {
	  perror("nws_back_config(): realloc failed");
	  exit(-1);
	}

	nbc->grid_list[nbc->grid_count-1] = malloc(sizeof(gridTarget));
	memset(nbc->grid_list[nbc->grid_count-1], 0, sizeof(gridTarget));
	nbc->grid_list[nbc->grid_count] = NULL;

	if (nbc->grid_list[nbc->grid_count-1] == NULL) {
	  perror("nws_back_config(): malloc failed");
	  exit(-1);
	}

	if( (!strcmp(argv[2], "file")) || (!strcmp(argv[2], "grads")) ) {
	  FILE *infile;
	  char newmember[512];
	  int i;
	  struct nws_series_collection *nser_coll;
	  const char *formatstring;

	  if(!strcmp(argv[2], "file")) {
		formatstring = strdup("%s");
	  }
	  else {
		/* formatstring = strdup("%s %*[ \_A-Za-z0-9\/]"); */
		formatstring = strdup("%s %*[ A-Za-z0-9]");
	  }

	  nbc->grid_list[nbc->grid_count-1]->file = strdup(argv[3]);
	  infile = fopen(argv[3], "r");
	  if (infile == NULL) {
		printf("Open of nws_vo_grid file \"%s\" failed.  Exiting.\n", argv[3]);
		exit(-1);
	  }

	  nser_coll = nws_new_coll(ncc);
 
	  nser_coll->name = strdup(argv[1]);
	  nser_coll->type = strdup("file");

	  while((i=fscanf(infile, formatstring, newmember)) != EOF) {
		nser_coll->member_count++;
		nser_coll->member = realloc(nser_coll->member,
									sizeof(char *) * nser_coll->member_count + 1);
		nser_coll->member[nser_coll->member_count-1] = strdup(newmember);
	  }

	  /* printf("nser_coll->member_count: %d\n", nser_coll->member_count);  */
	  if(nser_coll->member_count == 0) {
		printf("Problem with nws_vo_grid config.\n");
		exit(0);
	  }

	  for(i=0;i<nser_coll->member_count;i++) {
		  Debug(LDAP_DEBUG_TRACE,"%d: %s\n", i, nser_coll->member[i], 0);
	  }

	  rb_insert(nbc->nser_coll_tree, nser_coll->name, (char *)nser_coll);
	  fclose(infile);
	}
  }

  return(0);
}
