#include "portable.h"

#include <stdio.h>

#include <ac/ctype.h>
#include <ac/socket.h>
#include <ac/string.h> 
#include <ac/time.h>

#include <pwd.h>

#include "slap.h"
#include "external.h"
#include <ldap_pvt.h>

#include "nws_back_cache.h"
#include "nws_back.h"

int
nws_clique(nwsCacheConfig *ncc, const char *name) {
  return(0);
}

nwsSeriesColl *
nws_collection_by_name(nwsCacheConfig *ncc, const char *name) {
  nwsSeriesColl *nser_coll;
  Rb_node rb_ptr;

  rb_traverse(rb_ptr, ncc->nser_coll_tree) {
	nser_coll = (nwsSeriesColl *)rb_ptr->v.val;
	/* printf("nser_coll->name: %s\n", nser_coll->name); */
	if(!strcasecmp(nser_coll->name, name)) {
	  return(nser_coll);
	}
  }

  return(NULL);
}


nwsSeriesCache *
nws_collection_next(nwsCacheConfig *ncc,
					   nwsSeriesColl *nsc,
					   nwsCollIter **ref
					   ) {
  nwsCollIter *nci;
  nci = *ref;

  if(nci == NULL) {
	nci = (nwsCollIter *)malloc(sizeof(nwsCollIter));
	if(nci == NULL) {
	  perror("nws_collection_next(): malloc failed");
	  exit(-1);
	}
	nci->position = -1;
	nci->count = (nsc->member_count * nsc->member_count) - nsc->member_count;
  }

  nci->position += 1;

  if(nci->position == nci->count) {
	free(nci);
	return(NULL);
  }

  return(NULL);

}
