/* $Id: periodic.h,v 1.10 2004/10/21 05:49:26 graziano Exp $ */

#ifndef PERIODIC_H
#define PERIODIC_H

#ifdef __cplusplus
extern "C" {
#endif

/*
** The periodic module is a sensor control module that supports executing
** skills at fixed intervals.
*/


/* The registration name for the periodic control. */
#define PERIODIC_CONTROL_NAME "periodic"

/*
** Checks to see if the expired child process #pid# was performing periodic
** work and does any necessary post-death processing if so.
*/
void
PeriodicChildDeath(int pid);


/**
 * Performs one-time initialization of the periodic experiment module.
 * #options# is a list of name:value options tab delimited (most notably
 * fork:yes or fork:no). Returns 1 if successful, else 0.
 */
int
PeriodicInit(const char *options);


/*
** Performs any periodic work due to occur at the present time or earlier.
*/
void
PeriodicWork(void);


/*
** Returns the earliest time any periodic work is scheduled, or 0.0 if there is
** none.
*/
double
NextPeriodicWork(void);


/*
** Returns 1 or 0 depending on whether or not #name# corresponds to the
** registration name of any known ongoing periodic activity.
*/
int
RecognizedPeriodicActivity(const char *name);


/**
 * Initiates a #skill#-type periodic activity on this machine,
 * configuring the activity using #options#.  Registers the activity
 * using #registration# as name. If #registration# is NULL, create a
 * default name for it. 
 * Returns 1 if successful, else 0.
 */
int
StartPeriodicActivity(const char *registration,
                      const char *skill,
                      const char *options);


/**
 * Terminates the periodic activity named #registration# previously
 * started via a call StartPeriodicActivity().  If #registration# is
 * blank, terminates all ongoing periodic activity.  Returns 1 if
 * activity has been stopped, 0 otherwise.
 */
int
StopPeriodicActivity(const char *registration);

#ifdef __cplusplus
}
#endif


#endif
