#include "portable.h"

#include <stdio.h>

#include <ac/ctype.h>
#include <ac/socket.h>
#include <ac/string.h> 
#include <ac/time.h>

#include <pwd.h>

#include "slap.h"
#include "external.h"
#include <ldap_pvt.h>
#include "nws_back_cache.h"
#include "nws_back.h"

char *
nws_back_ptr2val(const char *attrval) {
  char *tc;

  /*printf("attrval is %s\n", attrval);*/
  tc = strchr(attrval, '=');
  if(tc == NULL) {
	return(NULL);
  }
  tc++;
  /*printf("tc = %s\n", tc); */
  return(tc);
}

int
nws_back_search(
    Backend	*be,
    Connection	*conn,
    Operation	*op,
    const char	*base,
    const char	*nbase,
    int		scope,
    int		deref,
    int		slimit,
    int		tlimit,
    Filter	*filter,
    const char	*filterstr,
    char	**attrs,
    int		attrsonly
)
{
	Entry *e;
	Entry *se;
	char *ctmp;
	time_t stoptime;
	int sent = 0;
	int err = LDAP_SUCCESS;
	char *rdn = NULL;
	char *q_rdn = NULL;
	char *parent = NULL;
	char *matched = NULL;
	int i, j;
	NWSobj *nobj;
	nwsBackConfig *nbc;
	nwsCacheConfig *ncc;
	nwsSeriesCache *nser;
	nwsSeriesColl *nser_coll;
	char **subtrees = NULL;

	Debug(LDAP_DEBUG_TRACE,"==>nws_back_search()\n",0,0,0);

	nbc = (nwsBackConfig *)be->be_private;
	ncc = (nwsCacheConfig *)nbc;

	if (!nbc)  {
	  Debug(LDAP_DEBUG_TRACE,"nws_back_search(): be_private is NULL.\n",0,0,0);
	  return(-1);
	}

	/*
	#define LDAP_SCOPE_DEFAULT  ((ber_int_t) -1)
    #define LDAP_SCOPE_BASE     ((ber_int_t) 0x0000)
    #define LDAP_SCOPE_ONELEVEL ((ber_int_t) 0x0001)
    #define LDAP_SCOPE_SUBTREE  ((ber_int_t) 0x0002)
	*/

	Debug(LDAP_DEBUG_TRACE,"nws_back_search(): scope is %d.\n",scope,0,0);
	/* control the scope */
 	if (scope == LDAP_SCOPE_DEFAULT) {
 	  scope = LDAP_SCOPE_BASE;
	}

	tlimit = (tlimit > be->be_timelimit || tlimit < 1) ? be->be_timelimit
	    : tlimit;
	stoptime = op->o_time + tlimit;
	slimit = (slimit > be->be_sizelimit || slimit < 1) ? be->be_sizelimit
	    : slimit;

	/*
	for ( i = 0; be->be_nsuffix != NULL && be->be_nsuffix[i] != NULL; i++ ) {
	  Debug(LDAP_DEBUG_TRACE, "be->be_nsuffix[i]: %s\n",
			be->be_nsuffix[i], 0, 0);
	}
	*/

	rdn = dn_rdn(be, nbase);
	if (rdn == NULL) {
	  Debug(LDAP_DEBUG_TRACE, "nws_back_search(): rdn is NULL.\n", 0, 0, 0);
	  goto basequery;
	}
	else {
	  Debug(LDAP_DEBUG_TRACE, "nws_back_search(): rdn is '%s'.\n", rdn, 0, 0);
	}

	subtrees = dn_subtree(be, nbase);
	for(i=0; subtrees[i] != NULL; i++) {
	  printf("subtree: %s (rdn:%s)\n", subtrees[i], dn_rdn(be, subtrees[i]));
	}

	if(i > 3) {
	  err = LDAP_NO_SUCH_OBJECT;
	  goto done;
	}

	i -= 2;

	q_rdn = rdn;

	rdn = dn_rdn(be, subtrees[i]);
	Debug(LDAP_DEBUG_TRACE, "operative subtree: %s (rdn:%s)\n",
		   subtrees[i], rdn, 0);

	/*
	if the rdn is one for a "leaf" node, and the scope is probing
	for it's children, then all should return "no such object".
	*/
	if( (scope == LDAP_SCOPE_ONELEVEL) &&
		(
		 (!strncasecmp(rdn, "daemon", sizeof("daemon")-1)) ||
		 (!strncasecmp(rdn, "control", sizeof("control")-1)) ||
		 (!strncasecmp(rdn, "skill", sizeof("skill")-1)) ||
		 (!strncasecmp(rdn, "activity", sizeof("activity")-1)) ||
		 (!strncasecmp(rdn, "forecast", sizeof("forecast")-1)) ||
		 (!strncasecmp(rdn, "event", sizeof("event")-1)) ||
		 (!strncasecmp(rdn, "series", sizeof("series")-1))
		)) {
	  err = LDAP_NO_SUCH_OBJECT;
	  goto done;
	}

 	if(!strncmp(rdn,"CLIQUE",sizeof("clique")-1)) {
	  if(rb_empty(ncc->nser_coll_tree)) {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }	
	  ctmp = nws_back_ptr2val(rdn);
	  nser_coll = nws_collection_by_name(ncc, ctmp);
	  if( (nser_coll == NULL) ||
		  (nser_coll->lastupdate.tv_sec == 0) ) {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }

	  for(i=0; i<nser_coll->series_rel_count; i++) {
		Debug(LDAP_DEBUG_TRACE, "series name from nser is %s\n",
			  nser_coll->series_rel[i]->nser->name, 0, 0);

		nser = nser_coll->series_rel[i]->nser;
		se = getMeasEntry(be, nser, NULL);

		if (test_filter(be, conn, op, se, filter) == LDAP_COMPARE_TRUE ) {
		  send_search_entry( be, conn, op,
							 se, attrs, attrsonly, NULL );
		  sent++;
		}
		if(se != NULL) entry_free(se);
			
		/* check for abandon */
		ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
		if (op->o_abandon) {
		  Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					0,0,0);
		  goto abandon_done;
		  /*
		  ldap_pvt_thread_mutex_unlock(&op->o_abandonmutex);
		  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
		  charray_free(subtrees);
		  return(-1);
		  */
		}
		ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );
		
	  }
	}
	else if(!strncmp(rdn,"VO-GRID",sizeof("vo-grid")-1)) {
	  struct nws_series_cache2coll **i_nc2c;
	  if(rb_empty(ncc->nser_coll_tree)) {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }	
	  ctmp = nws_back_ptr2val(rdn);
	  nser_coll = nws_collection_by_name(ncc, ctmp);
	  if( (nser_coll == NULL) ||
		  (nser_coll->lastupdate.tv_sec == 0) ) {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }
	  

	  if((scope == LDAP_SCOPE_BASE) || (scope == LDAP_SCOPE_SUBTREE)) {
		/*need to emit a collection record */
	  }

	  if(scope == LDAP_SCOPE_BASE) {
		goto done;
	  }


	  /*
	  if((!strcmp(nser_coll->type, "file")) ||
		 (!strcmp(nser_coll->type, "user")) ) {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }
	  */

	  for(i=0; i < nser_coll->member_count; i++) {
		i_nc2c = (struct nws_series_cache2coll **)
		  nser_coll->series_rel[i];
		for(j=0; j < nser_coll->member_count; j++) {
		  if(i==j) {
			/*  printf("%s->%s (LAT): -1\n",
				nser_coll->member[i],
				nser_coll->member[j]);
			*/
		  }
		  else {
			if(i_nc2c[j]->ban_nser == NULL) {
			  Debug(LDAP_DEBUG_TRACE, "no ban_nser from %s to %s\n",
					nser_coll->member[i], nser_coll->member[j], 0);
			  exit(0);
			}
			
			se = getMeasEntry(be, i_nc2c[j]->ban_nser, NULL);
			if(se != NULL) entry_free(se);
			se = nwsColl2entry(be, i_nc2c[j], i_nc2c[j]->ban_nser, rdn);

			if (se == NULL) {
			  Debug(LDAP_DEBUG_TRACE, "%s to %s\n", nser_coll->member[i],
					nser_coll->member[j], 0);
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: se is NULL!\n",
					0,0,0);
			  /* exit(0); */
			}

			else {
			  if (test_filter(be, conn, op, se, filter)
				  == LDAP_COMPARE_TRUE ) {
				send_search_entry( be, conn, op,
								   se, attrs, attrsonly, NULL );
				sent++;
			  }

			  if (se != NULL) {
				entry_free(se);
			  }
			}

			if(i_nc2c[j]->lat_nser == NULL) {
			  Debug(LDAP_DEBUG_TRACE, "no lat_nser from %s to %s\n",
					nser_coll->member[i], nser_coll->member[j], 0);
			  exit(0);
			}
			Debug(LDAP_DEBUG_TRACE, "i_nc2c[j]->lat_nser->name: %s\n",
				  i_nc2c[j]->lat_nser->name, 0, 0);
			se = getMeasEntry(be, i_nc2c[j]->lat_nser, NULL);
			if(se != NULL) entry_free(se);
			se = nwsColl2entry(be, i_nc2c[j], i_nc2c[j]->lat_nser, rdn);

			if (se == NULL) {
			  Debug(LDAP_DEBUG_TRACE, "%s to %s\n",
					nser_coll->member[i],
					nser_coll->member[j],
					0);
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: se is NULL!\n",
					0,0,0);
			  /* exit(0); */
			}
			else {
			  if (test_filter(be, conn, op, se, filter)
				  == LDAP_COMPARE_TRUE ) {
				send_search_entry( be, conn, op,
								   se, attrs, attrsonly, NULL );
				sent++;
			  }
			  if(se != NULL) entry_free(se);
			}
			
			/* check for abandon */
			ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
			if (op->o_abandon) {
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					0,0,0);
			  goto abandon_done;
			  ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );
			  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
			  charray_free(subtrees);
			  return(-1);
			}
			ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );

			/* printf("%s->%s (LAT): %f\n", nser_coll->member[i],
			   nser_coll->member[j],
			   i_nc2c[j]->lat_nser->exper[0].value);
			*/
		  }
		}
	  }
	}
	else if(!strncmp(rdn,"FORECAST",sizeof("FORECAST")-1)) {
	  struct nws_series_cache *series;

	  ctmp = nws_back_ptr2val(rdn);

	  series = nbc->nser;
	  while(series->next != NULL) {
		if (!strcasecmp(series->name, ctmp)) {
		  /*printf("matched: %s\n", series->name); */
		  se = nwsMeas2entry(be, series, rdn);
		  if(se != NULL) entry_free(se);
		  se = getMeasEntry(be, series, NULL);
		  if (test_filter(be, conn, op, se, filter) == LDAP_COMPARE_TRUE ) {
			send_search_entry( be, conn, op, se, attrs, attrsonly, NULL );
			sent++;
		  }
		  err = LDAP_SUCCESS;
		  if(se != NULL) entry_free(se);
		  goto done;
		}
		else {
		  series = series->next;
		}
	  }
	  if (!strcasecmp(series->name, ctmp)) {
		/*printf("matched: %s\n", series->name); */
		se = nwsMeas2entry(be, series, rdn);
		if(se != NULL) entry_free(se);
		se = getMeasEntry(be, series, NULL);
		if (test_filter(be, conn, op, se, filter) == LDAP_COMPARE_TRUE ) {
		  send_search_entry( be, conn, op, se, attrs, attrsonly, NULL );
		  sent++;
		}
		if(se != NULL) entry_free(se);
		err = LDAP_SUCCESS;
		goto done;
	  }
	  else {
		err = LDAP_NO_SUCH_OBJECT;
		goto done;
	  }
	}
	else { /* rdn is null, must be a base query */
	  if(rdn != NULL) {
		Debug(LDAP_DEBUG_TRACE,"nws_back_search(): unrecognized rdn ('%s')\n",
			  rdn,0,0);
	  }
basequery:
	  if((!strcmp(nbase,"O=DATA,SERVICE=NWS,O=GRID,C=US")) ||
		 (!strcmp(nbase,"O=DATA,SERVICE=NWS,O=GRID")) ) {

		if (scope == LDAP_SCOPE_BASE) {
		  if ((e = nwsBaseEntry(be, rdn, nbase)) == NULL) {
			Debug(LDAP_DEBUG_TRACE,
				  "nws_back_search: nwsBaseEntry returned NULL!\n",
				  0,0,0);
		  }
		  else {
			if (test_filter( be, conn, op, e, filter) == LDAP_COMPARE_TRUE ) {
			  send_search_entry( be, conn, op, e, attrs, attrsonly, NULL );
			  sent++;
			}
		  }

		  if(e != NULL) entry_free(e);

		  goto done;
		}

		nser = nbc->nser->next;
		while(nser != NULL) {
		  /* create a "fake" object and test the filter */
		  se = nwsMeas2entry(be, nser, rdn); 

		  /* printf("se->e_dn is %s\n", se->e_dn); */
		  if (test_filter(be, conn, op, se, filter)
			  == LDAP_COMPARE_TRUE ) {
			if(se != NULL) entry_free(se);
			se = getMeasEntry(be, nser, NULL);
			if (se == NULL) {
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: se is NULL!\n",0,0,0);
			  nser = nser->next;
			  continue;
			}
			if (test_filter(be, conn, op, se, filter)
				== LDAP_COMPARE_TRUE ) {
			  if (--slimit == -1 ) {
				send_ldap_result(conn, op, LDAP_SIZELIMIT_EXCEEDED,
								 NULL, NULL, NULL, NULL);
				ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
				if(se != NULL) entry_free(se);
				return(0);
			  }
			  send_search_entry( be, conn, op,
								 se, attrs, attrsonly, NULL );
			  sent++;
			}
			if(se != NULL) entry_free(se);

			/* check for abandon */
			ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
			if (op->o_abandon) {
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					0,0,0);
			  goto abandon_done;
			  ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );
			  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
			  return(-1);
			}
			ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );
		  }
		  else {
			if(se != NULL) entry_free(se);
		  }
		  nser = nser->next;
		}
		goto done;
	  }

	  else {
		if (scope == LDAP_SCOPE_BASE) {
		  if ((e = nwsBaseEntry(be, rdn, base)) == NULL) {
			Debug(LDAP_DEBUG_TRACE,
				  "nws_back_search: nwsBaseEntry returned NULL!\n",
				  0,0,0);
		  }
		  else {
			if (test_filter( be, conn, op, e, filter) == LDAP_COMPARE_TRUE ) {
			  send_search_entry( be, conn, op,
								 e, attrs, attrsonly, NULL );
			  sent++;

			  /* check for abandon */
			  ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
			  if (op->o_abandon) {
				Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					  0,0,0);
				goto abandon_done;
			  }
			  ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );
			}
			else {
			  Debug(LDAP_DEBUG_TRACE,
					"nws_back_search: nwsBaseEntry doesn't match filter.\n",
					0,0,0);
			}
			if(e != NULL) entry_free(e);
		  }
		  goto done;
		}

		if ( scope != LDAP_SCOPE_BASE ) {

		  /* check for abandon */
		  ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
		  if (op->o_abandon) {
			Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					0,0,0);
			goto abandon_done;
		  }
		  ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );

		  /* check time limit */
		  if (slap_get_time() > stoptime) {
			send_ldap_result(conn, op, LDAP_TIMELIMIT_EXCEEDED,
							 NULL, NULL, NULL, NULL);
			return(0);
		  }

		  ldap_pvt_thread_mutex_lock(&nbc->obj_list_mutex);

		  nobj = nbc->nws_obj_list;
		
		  while(nobj != NULL) {
			e = nws2entry(be, nobj, NULL);
		  
			if (e == NULL) {
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: e is NULL!\n",
					0,0,0);
			  continue;
			}

			if (test_filter(be, conn, op, e, filter)
				== LDAP_COMPARE_TRUE ) {
			  /* check size limit */
			  /*
			  if (--slimit == -1 ) {
				send_ldap_result(conn, op, LDAP_SIZELIMIT_EXCEEDED,
								 NULL, NULL, NULL, NULL);
				ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
				return(0);
			  }
			  */
			  send_search_entry( be, conn, op,
								 e, attrs, attrsonly, NULL );
			  sent++;
			}

			if(e != NULL) entry_free(e);

			/* check for abandon */
			ldap_pvt_thread_mutex_lock( &op->o_abandonmutex );
			if (op->o_abandon) {
			  Debug(LDAP_DEBUG_TRACE,"nws_back_search: abandoned.\n",
					0,0,0);
			  goto abandon_done;
			}
			ldap_pvt_thread_mutex_unlock( &op->o_abandonmutex );

			  /*  If series data is available under the series 
				if(nobj->itype == NWS_OBJ_nwsSeries) {
				se = getMeasEntry(be, nobj, NULL);
				if (se == NULL) {
				Debug(LDAP_DEBUG_TRACE,"nws_back_search: se is NULL!\n",0,0,0);
				goto done;
				}
				if (--slimit == -1 ) {
				send_ldap_result(conn, op, LDAP_SIZELIMIT_EXCEEDED,
				NULL, NULL, NULL, NULL);
				return(0);
				}
				send_search_entry( be, conn, op,
				se, attrs, attrsonly, NULL );
				sent++;
				entry_free(se);
				}
			  */
			nobj = nobj->next;
		  }
		  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
		}
	  }

	}

done:
	if(matched != NULL) free(matched);  
	if(parent != NULL) free(parent);  
	if(rdn != NULL) free(rdn);
	if(q_rdn != NULL) free(q_rdn);
	if(subtrees != NULL) charray_free(subtrees);

	Debug(LDAP_DEBUG_TRACE, "==>send_ldap_result()\n",0,0,0);

	if(err == LDAP_PROTOCOL_ERROR) {
	  send_ldap_disconnect(conn, op, LDAP_PROTOCOL_ERROR, NULL);
	  send_ldap_result( conn, op, SLAPD_DISCONNECT, NULL, NULL,
						NULL, NULL );
	  return(SLAPD_DISCONNECT);
	}
	else {
	  send_ldap_result( conn, op, 
						err, err == LDAP_NO_SUCH_OBJECT ? matched : NULL, NULL,
						NULL, NULL );
	  Debug(LDAP_DEBUG_TRACE, "<==send_ldap_result()\n",0,0,0);
	}

	Debug(LDAP_DEBUG_TRACE,"<==nws_back_search()\n",0,0,0);
	return(0);

abandon_done:
	ldap_pvt_thread_mutex_unlock(&op->o_abandonmutex);
	ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
	if(rdn != NULL) free(rdn);
	if(q_rdn != NULL) free(q_rdn);
	if(subtrees != NULL) charray_free(subtrees);
	return(-1);
}

Entry *
getMeasEntry(Backend *be, nwsSeriesCache *nser, char *rdn){
  nwsBackConfig *nbc;
  Entry *e;
  struct timeval now;
  /* int result; */

  Debug(LDAP_DEBUG_TRACE,"==>getMeasEntry()\n",0,0,0); 

  nbc = (nwsBackConfig *)be->be_private;
  
  if(gettimeofday(&now, NULL) < 0) {
	Debug(LDAP_DEBUG_TRACE,"getMeasEntry(): gettimeofday() failed.\n"
		  ,0,0,0);
  }

  pthread_mutex_lock(&nser->nser_mutex);
  Debug(LDAP_DEBUG_TRACE,"==>getMeasEntry() got the lock for nser->name=%s\n",
		nser->name,0,0); 
  /* check whether we need to update the series or not */
  if (now.tv_sec > nser->lastupdate.tv_sec + nser->period) {
	if(nws_update_series(nbc, nser) < 0) {
	  pthread_mutex_unlock(&nser->nser_mutex);
	  return(NULL);
	}
  }
  else {
	Debug(LDAP_DEBUG_TRACE,"getMeasEntry(): series cache hit.\n",0,0,0);
    /*printf("%d\t%f\n", (int)nser->exper[0].timeStamp,
	  nser->exper[0].value) */;
  }

  pthread_mutex_unlock(&nser->nser_mutex);
  /* printf("%d\t%f\n", (int)nser->exper[nser->exp_count-1].timeStamp, */
/*   nser->exper[nser->exp_count-1].value);  */

  if(nser == NULL) {
	Debug(LDAP_DEBUG_TRACE,
		  "nws_get_series returned NULL.\n<==getMeasEntry() returns NULL\n",
		  0,0,0);
	return(NULL);
  }
  else if(nser->forecast_state != NULL) {
	e = nwsForc2entry(be, nser, rdn);
  }
  else if(nser->exper != NULL) {
	e = nwsMeas2entry(be, nser, rdn);
  }
  else if (nser->forc != NULL) {
	e = nwsForc2entry(be, nser, rdn);
  }
  else {
	Debug(LDAP_DEBUG_TRACE,
		  "getMeasEntry(): invalid nser struct.\n<==getMeasEntry() returns NULL\n",
		  0,0,0);
	return(NULL);
  }

  Debug(LDAP_DEBUG_TRACE,"<==getMeasEntry()\n",0,0,0);
  return(e);

}

