unit Output;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Main,
  StdCtrls, SimpleThread, ComCtrls;

const
  CR = #$0D;
  LF = #$0A;
  TerminationWaitTime = 500;
  ExeExt = '.EXE';
  MAXLINES = 5000;
  DELPART = 5;

type
  TOutputForm = class(TForm)
    OutputThread: TSimpleThread;
    OutputMemo: TMemo;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OutputThreadActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure RunningUpdate(Sender: TObject);
  public
    { Public declarations }
    procedure WriteToPipe(AppInput: TStrings);
    function ConsoleKeyboardInput(Key: Char): DWORD;
  end;

var
  OutputForm: TOutputForm;
  hChildStdinRd, hChildStdinWr,
  hChildStdoutRd, hChildStdoutWr: THandle;
  ProcessInfo: TProcessInformation;
  Newline: Boolean;
implementation

{$R *.DFM}
uses ChildWin;

procedure TOutputForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OutputForm.ManualFloat(Rect(0, 0, 0, 0));
  MainForm.WindowOutputItem.Checked := false;
end;

procedure ExecConsoleApp(const ApplicationName, Parameters: String);
var
  StartupInfo:TStartupInfo;
  SecurityAttributes: TSecurityAttributes;
  TempHandle: THandle;
  Ext, CommandLine: String;
  AppNameBuf: array[0..MAX_PATH] of Char;
  ExeName: PChar;

begin
  {Find out about app}
  Ext:= UpperCase(ExtractFileExt(ApplicationName));
  if SearchPath(nil, PChar(ApplicationName), ExeExt, SizeOf(AppNameBuf), AppNameBuf, ExeName) = 0 then
    raise EInOutError.CreateFmt('Could not find file %s', [ApplicationName]);
  FmtStr(CommandLine, '"%s" %s', [AppNameBuf, Parameters]);
  FillChar(StartupInfo,SizeOf(StartupInfo), 0);
  FillChar(SecurityAttributes, SizeOf(SecurityAttributes), 0);

  with SecurityAttributes do
  begin
    nLength:= Sizeof(SecurityAttributes);
    bInheritHandle:= true;
    lpSecurityDescriptor := nil;
  end;
  if not CreatePipe(hChildStdoutRd, hChildStdoutWr, @SecurityAttributes, 0) then
    RaiseLastOSError;
  try
    {Read end should not be inherited by child process}
    if Win32Platform = VER_PLATFORM_WIN32_NT then
    begin
      if not SetHandleInformation(hChildStdoutRd, HANDLE_FLAG_INHERIT, 0) then
        RaiseLastOSError
    end else
    begin
      {SetHandleInformation does not work under Window95, so we
      have to make a copy then close the original}
      if not DuplicateHandle(GetCurrentProcess, hChildStdoutRd,
        GetCurrentProcess, @TempHandle, 0, True, DUPLICATE_SAME_ACCESS) then
        RaiseLastOSError;
      CloseHandle(hChildStdoutRd);
      hChildStdoutRd:= TempHandle
    end;

    if not CreatePipe(hChildStdinRd, hChildStdinWr, @SecurityAttributes, 0) then
      RaiseLastOSError;
    try
      {Read end should not be inherited by child process}
      if Win32Platform = VER_PLATFORM_WIN32_NT then
      begin
        if not SetHandleInformation(hChildStdinWr, HANDLE_FLAG_INHERIT, 0) then
          RaiseLastOSError
      end else
      begin
        {SetHandleInformation does not work under Window95, so we
        have to make a copy then close the original}
        if not DuplicateHandle(GetCurrentProcess, hChildStdinWr,
          GetCurrentProcess, @TempHandle, 0, True, DUPLICATE_SAME_ACCESS) then
          RaiseLastOSError;
        CloseHandle(hChildStdinWr);
        hChildStdinWr:= TempHandle
      end;

      with StartupInfo do
      begin
        cb:= SizeOf(StartupInfo);
        dwFlags:= STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;
        wShowWindow:= SW_HIDE;
        hStdOutput:= hChildStdoutWr;
        hStdInput:= hChildStdinRd;
      end;

      if not CreateProcess(nil, PChar(CommandLine),
         nil, nil,
         true,                   {inherit kernel object handles from parent}
//         CREATE_NO_WINDOW,
//         CREATE_NEW_CONSOLE,
         CREATE_NEW_PROCESS_GROUP,
         nil,
         nil,
         StartupInfo,
         ProcessInfo) then
       RaiseLastOSError;

        CloseHandle(ProcessInfo.hThread);
      CloseHandle(hChildStdoutWr);
//      CloseHandle(hChildStdinRd);
     finally
     end
  finally
  end
end;

Procedure FuncAllowInput();
begin
  with MainForm do
    begin
      if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
        begin
          SpeedButtonLoad.Enabled := Main.AllowInput;
          ProcessLoadItem.Enabled := Main.AllowInput;
        end;
{      SpeedButtonSound.Enabled := AllowInput;
      ProcessReplayItem.Enabled := AllowInput;
      SpeedButtonInfo.Enabled := AllowInput;
      ProcessInfoItem.Enabled := AllowInput;
      SpeedButtonContinue.Enabled := AllowInput;
      ProcessContinueItem.Enabled := AllowInput;
      SpeedButtonTop.Enabled := AllowInput;
      ProcessTopItem.Enabled := AllowInput;
      SpeedButtonUp.Enabled := AllowInput;
      ProcessUpItem.Enabled := AllowInput;
      SpeedButtonBreak.Enabled := not AllowInput;
      ProcessBreakItem.Enabled := not AllowInput;}
    end;
end;

procedure ReadFromPipe(AppOutput: TStrings;     {will receive output of child process}
                       OnNewLine: TNotifyEvent  {if assigned called on each new line}
                      );
var
  ReadBuf: array[0..$10000] of Char;
  BytesRead: Cardinal;
  LineBufPtr: Integer;
  LineBuf: array[0..$10000] of Char;
  i: Integer;

function CheckAllowInput: Boolean;
var i: Integer;
begin
  if (LineBufPtr >= 2) and (LineBuf[LineBufPtr-2] = '>') and (LineBuf[LineBufPtr-1] = ' ') then
   begin
     i := 3;
     while (LineBufPtr-i>=0) and (LineBuf[LineBufPtr-i] in ['0'..'9']) do
      i := i + 1;
     if (LineBufPtr-i<0) or (LineBuf[LineBufPtr-i] in [LF, CR]) then
       Result := true
     else Result := false;
   end
  else Result := false;
end;

procedure OutputLine;
var iNameStart, iNameStop, i: Integer;
    TempStream : TMemoryStream;
    sTemp: String;
begin
  LineBuf[LineBufPtr]:= #0;
  with AppOutput do
   begin
    if Count>MAXLINES then
      begin
        TempStream := TMemoryStream.Create;
        SaveToStream(TempStream);
        TempStream.Position := TempStream.Size div DELPART;
        BeginUpdate;
        Clear;
        LoadFromStream(TempStream);
        Delete(0);
        EndUpdate;
        TempStream.Free;
      end;
    if Newline then
      Add(LineBuf)
    else
      Strings[Count-1]:= Strings[Count-1] + LineBuf; {should never happen with count = 0}
    //For output plot
    if (Main.PlotNow = 0) then                  //For output plot
      begin
        iNameStart := pos('s-plot: writing ', Strings[Count-1]);
        if iNameStart > 0 then
          begin
            sTemp := Copy(Strings[Count-1], iNameStart + 16, length(Strings[Count-1]) - iNameStart - 15);
            iNameStop := pos(' ...', sTemp);
            if iNameStop > 0 then
              begin
                Main.PlotDataFile := Copy(sTemp, 1, iNameStop - 1);
                Main.PlotNow := 1;
              end;
          end;
      end
    else  if (Main.PlotNow = 1) then                  //For output plot
      begin
        iNameStart := pos(' points from', Strings[Count-1]);
        if iNameStart > 0 then
          begin
            //sTemp := Copy(Strings[Count-1], iNameStart + 28, length(Strings[Count-1]) - iNameStart - 27);
            //iNameStop := pos(' POINTS', sTemp);
            //if iNameStop > 0 then
            //  begin
                Main.PlotDataPts := StrToInt(Copy(Strings[Count-1], 1, iNameStart - 1));
                Main.PlotNow := 2;
            //  end;
          end;
      end;
    //End - for output plot
   end;
  Newline:= false;
  LineBufPtr:= 0;
  if Assigned(OnNewLine) then
    OnNewLine(AppOutput);
  {there is no reasonable justification for passing AppOutput as self,
  but I don't have anything else to send, and I fancied using TNotifyEvent}
end;
begin
  LineBufPtr:= 0;
  Newline:= true;
  FillChar(ReadBuf, SizeOf(ReadBuf), 0);
  try
    while ReadFile(hChildStdoutRd, ReadBuf, SizeOf(ReadBuf), BytesRead, nil) do
    begin
      {There are much more efficient ways of doing this: we don't really
      need two buffers, but we do need to scan for CR & LF &&&}
{     ReadBuf[BytesRead] := CR;
      BytesRead := BytesRead + 1;}
      for  i := 0 to BytesRead - 1 do
      begin
        if (ReadBuf[i] = LF) then
        begin
          Newline:= true
        end else
        if (ReadBuf[i] = CR) then
        begin
          OutputLine
        end else
        begin
          LineBuf[LineBufPtr]:= ReadBuf[i];
          Inc(LineBufPtr);
          if LineBufPtr >= (SizeOf(LineBuf) - 1) then //line too long - force a break
          begin
            Newline:= true;
            OutputLine
          end
        end
      end;
      if CheckAllowInput then
        begin
          Main.AllowInput := true;
          OutputLine;
          MainForm.ShowOutput;
        end
      else Main.AllowInput := false;
      FuncAllowInput;
    end;
      OutputLine; {flush the line buffer}
  finally
    CloseHandle(ProcessInfo.hProcess)
  end;
end;

procedure TOutputForm.WriteToPipe(AppInput: TStrings);
var
  BytesWrite: Cardinal;
  i, len: Integer;
  WriteBuf: array[0..$10000] of Char;
begin
  try
    len := length(AppInput.Text);
    i := 1;
    repeat
      if AppInput.Text[i]=#0 then len := i - 1
      else WriteBuf[i-1]:= AppInput.Text[i];
      i := i + 1;
    until i > len;
    WriteBuf[len] := #0;
    Main.AllowInput := false;
    FuncAllowInput;
    if not(WriteFile(hChildStdinWr, WriteBuf, len, BytesWrite, nil)) then
      RaiseLastOSError
  finally
      end;
end;

procedure TOutputForm.OutputThreadActivate(Sender: TObject);
begin
  ReadFromPipe(OutputMemo.Lines, RunningUpdate);
end;

procedure TOutputForm.RunningUpdate(Sender: TObject);
begin
  OutputMemo.Update  {flush paint messages to show progress}
end;

procedure TOutputForm.FormCreate(Sender: TObject);
begin
  ExecConsoleApp(Main.OriDir + '\nyquist.exe', '');
  OutputThread.Active := true;
  Main.AllowInput := false;
  OutputMemo.DoubleBuffered := true;
end;

procedure TOutputForm.FormDestroy(Sender: TObject);
begin
  TerminateProcess(ProcessInfo.hProcess, 0);
  CloseHandle(hChildStdoutRd);
  CloseHandle(hChildStdinWr);
//  OutputThread.Active := false;
  ExitProcess(0);

end;

function TOutputForm.ConsoleKeyboardInput(Key: Char): DWORD;
begin
  if not PostThreadMessage(ProcessInfo.dwThreadId, WM_CHAR, ord(Key), 0) then
    ConsoleKeyboardInput :=  GetLastError
  else ConsoleKeyboardInput := 0;
end;

end.
