SET(LIBFTDI_FOUND "NO")

SET(LIBFTDI_PREFIX "/usr/local/libftdi/" CACHE STRING
	"libftdi is installed in this prefix (if non-standard)")

SET(LIBFTDI_SEARCH_PATHS
	${LIBFTDI_PREFIX}/
	/sw/
	/usr/
	/usr/local/
)

FIND_PATH(LIBFTDI_INCLUDE_DIR
	NAMES ftdi.h
	PATH_SUFFIXES /include/ .
	PATHS ${LIBFTDI_SEARCH_PATHS}
)

FIND_LIBRARY(LIBFTDI_LIBRARY
	NAMES ftdi
	PATH_SUFFIXES /lib/ .
	PATHS ${LIBFTDI_SEARCH_PATHS}
)


IF(LIBFTDI_LIBRARY AND LIBFTDI_INCLUDE_DIR)
  SET(LIBFTDI_FOUND "YES")
ENDIF(LIBFTDI_LIBRARY AND LIBFTDI_INCLUDE_DIR)

IF(LIBFTDI_FOUND)
  IF(NOT LIBFTDI_FIND_QUIETLY)
    MESSAGE(STATUS "Found LIBFTDI: ${LIBFTDI_LIBRARY}")
  ENDIF(NOT LIBFTDI_FIND_QUIETLY)
ELSE(LIBFTDI_FOUND)
  IF(LIBFTDI_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find LIBFTDI Library")
  ENDIF(LIBFTDI_FIND_REQUIRED)
ENDIF(LIBFTDI_FOUND)

