(*
 * Copyright 2007 Samuel Mimram
 *
 * This file is part of ocaml-ogg.
 *
 * ocaml-ogg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ocaml-ogg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with ocaml-ogg; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * As a special exception to the GNU Library General Public License, you may 
 * link, statically or dynamically, a "work that uses the Library" with a publicly 
 * distributed version of the Library to produce an executable file containing 
 * portions of the Library, and distribute that executable file under terms of 
 * your choice, without any of the additional requirements listed in clause 6 
 * of the GNU Library General Public License. 
 * By "a publicly distributed version of the Library", we mean either the unmodified 
 * Library as distributed by INRIA, or a modified version of the Library that is 
 * distributed under the conditions defined in clause 3 of the GNU Library General 
 * Public License. This exception does not however invalidate any other reasons why 
 * the executable file might be covered by the GNU Library General Public License.
 * 
 *)

(*
 * Functions for manipulating ogg streams files using libogg.
 *
 * @author Samuel Mimram
 *)

type page = string

type pages = string

exception Not_enough_data

let () =
  Callback.register_exception "ogg_exn_not_enough_data" Not_enough_data

module Stream =
struct
  type t

  external create : int -> t = "ocaml_ogg_stream_init"

  let create ?(serial = Random.int 0x3FFFFFFF) () = create serial

  external pageout : t -> page = "ocaml_ogg_stream_pageout"

  external pagesout : t -> pages = "ocaml_ogg_stream_pagesout"

  external pagesout_eos : t -> pages = "ocaml_ogg_stream_pagesout_eos"

  external flush : t -> pages = "ocaml_ogg_flush_stream"
end

module Sync =
struct
  type t

  external create : unit -> t = "ocaml_ogg_sync_init"
end
