(*
 * Graph: generic graph library
 * Copyright (C) 2004
 * Sylvain Conchon, Jean-Christophe Filliatre and Julien Signoles
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2, as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the GNU Library General Public License version 2 for more details
 * (enclosed in the file LGPL).
 *)

(* $Id: util.ml,v 1.12 2004/02/05 10:06:02 signoles Exp $ *)

open Sig

module OTProduct(X: ORDERED_TYPE)(Y: ORDERED_TYPE) = struct 

  type t = X.t * Y.t 

  let compare (x1, y1) (x2, y2) = 
    let cv = X.compare x1 x2 in
    if cv != 0 then cv else Y.compare y1 y2

end

module HTProduct(X: HASHABLE)(Y: HASHABLE) = struct

  type t = X.t * Y.t

  let equal (x1, y1) (x2, y2) =
    X.equal x1 x2 && Y.equal y1 y2

  let hash (x, y) = 
    Hashtbl.hash (X.hash x, Y.hash y)

end

module CMPProduct(X: COMPARABLE)(Y: COMPARABLE) = struct 

  include HTProduct(X)(Y)
  include (OTProduct(X)(Y): sig val compare : t -> t -> int end)
      
end
