open StdLabels
open MoreLabels
open Printf

let () = Gsl_error.init ()

let x = [|2004.; 2005.; 2006.; 2007.; 2008.; 2009.; 2010.; 2011.; 2012.;
	  2013.; 2014.; 2015.; 2016.; 2017.; 2018.; 2019.; 2020.; 2021.;
	  2022.; 2023.; 2024.; 2025.; 2026.; 2027.; 2028.; 2029.; 2030.;
	  2031.; 2032.; 2033.|]
let y = [|1.03; 1.32; 1.65; 2.03; 2.42; 2.74; 3.07; 3.36; 3.59; 3.72; 3.84;
	  3.95; 4.06; 4.16; 4.26; 4.35; 4.45; 4.53; 4.61; 4.68; 4.76; 4.79;
	  4.81; 4.82; 4.83; 4.84; 4.85; 4.86; 4.87; 4.87|]


let frange ?(stride=1.) low high =
  let rec loop low high accum =
    if low > high then accum
    else loop (low +. stride) high (low::accum)
  in
  List.rev (loop low high [])

let delta = 0.1

let ix = Array.of_list (frange ~stride:delta x.(0) x.(Array.length x - 1))
let iy = Array.map ~f:(fun x -> 0.) ix

let interp = Gsl_interp.make Gsl_interp.CSPLINE x y
let () = Gsl_interp.eval_array interp ix iy

(* IF we use this line instead, no segfault:
   let iy = Array.map ~f:(Gsl_interp.eval interp) ix*)


let () =
  print_endline "#m=-1,S=2" ;
  for i = 0 to Array.length x - 1 do
    printf "%f %f\n" x.(i) y.(i)
  done;
  print_newline () ;
  print_endline "#m=1,S=0" ;
  for i = 0 to Array.length ix - 1 do
    printf "%f %f\n" ix.(i) iy.(i)
  done

