/* ocamlgsl - OCaml interface to GSL                        */
/* Copyright () 2002 - Olivier Andrieu                     */
/* distributed under the terms of the GPL version 2         */


#include <gsl/gsl_eigen.h>

#include "wrappers.h"
#include "mlgsl_permut.h"
#include "mlgsl_complex.h"

#include "mlgsl_vector_complex.h"
#include "mlgsl_matrix_complex.h"

#undef BASE_TYPE
#undef TYPE
#undef _DECLARE_BASE_TYPE
#undef _CONVERT_BASE_TYPE
#undef DECLARE_BASE_TYPE
#undef FUNCTION

#include "mlgsl_matrix_double.h"
#include "mlgsl_vector_double.h"



value ml_gsl_eigen_symm_alloc(value n)
{
  value v;
  gsl_eigen_symm_workspace *ws = gsl_eigen_symm_alloc(Int_val(n));
  Abstract_ptr(v, ws);
  return v;
}

#define SYMM_WS_val(v) ((gsl_eigen_symm_workspace *)Field(v, 0))

ML1(gsl_eigen_symm_free, SYMM_WS_val, Unit)

value ml_gsl_eigen_symm(value A, value EVAL, value ws)
{
  _DECLARE_MATRIX(A);
  _DECLARE_VECTOR(EVAL);
  _CONVERT_MATRIX(A);
  _CONVERT_VECTOR(EVAL);
  gsl_eigen_symm(&m_A, &v_EVAL, SYMM_WS_val(ws));
  return Val_unit;
}

value ml_gsl_eigen_symmv_alloc(value n)
{
  value v;
  gsl_eigen_symmv_workspace *ws = gsl_eigen_symmv_alloc(Int_val(n));
  Abstract_ptr(v, ws);
  return v;
}

#define SYMMV_WS_val(v) ((gsl_eigen_symmv_workspace *)Field(v, 0))

ML1(gsl_eigen_symmv_free, SYMMV_WS_val, Unit)

value ml_gsl_eigen_symmv(value A, value EVAL, value EVEC, value ws)
{
  _DECLARE_MATRIX2(A, EVEC);
  _DECLARE_VECTOR(EVAL);
  _CONVERT_MATRIX2(A, EVEC);
  _CONVERT_VECTOR(EVAL);
  gsl_eigen_symmv(&m_A, &v_EVAL, &m_EVEC, SYMMV_WS_val(ws));
  return Val_unit;
}

static const gsl_eigen_sort_t eigen_sort_type[] = {
  GSL_EIGEN_SORT_VAL_ASC, GSL_EIGEN_SORT_VAL_DESC,
  GSL_EIGEN_SORT_ABS_ASC, GSL_EIGEN_SORT_ABS_DESC, };

value ml_gsl_eigen_symmv_sort(value E, value sort)
{
  value EVAL = Field(E, 0);
  value EVEC = Field(E, 1);
  _DECLARE_MATRIX(EVEC);
  _DECLARE_VECTOR(EVAL);
  _CONVERT_MATRIX(EVEC);
  _CONVERT_VECTOR(EVAL);
  gsl_eigen_symmv_sort(&v_EVAL, &m_EVEC, eigen_sort_type[ Int_val(sort) ]);
  return Val_unit;
}




/* Hermitian matrices */
value ml_gsl_eigen_herm_alloc(value n)
{
  value v;
  gsl_eigen_herm_workspace *ws = gsl_eigen_herm_alloc(Int_val(n));
  Abstract_ptr(v, ws);
  return v;
}

#define HERM_WS_val(v) ((gsl_eigen_herm_workspace *)Field(v, 0))

ML1(gsl_eigen_herm_free, HERM_WS_val, Unit)

value ml_gsl_eigen_herm(value A, value EVAL, value ws)
{
  _DECLARE_COMPLEX_MATRIX(A);
  _DECLARE_VECTOR(EVAL);
  _CONVERT_COMPLEX_MATRIX(A);
  _CONVERT_VECTOR(EVAL);
  gsl_eigen_herm(&m_A, &v_EVAL, HERM_WS_val(ws));
  return Val_unit;
}

value ml_gsl_eigen_hermv_alloc(value n)
{
  value v;
  gsl_eigen_hermv_workspace *ws = gsl_eigen_hermv_alloc(Int_val(n));
  Abstract_ptr(v, ws);
  return v;
}

#define HERMV_WS_val(v) ((gsl_eigen_hermv_workspace *)Field(v, 0))

ML1(gsl_eigen_hermv_free, HERMV_WS_val, Unit)

value ml_gsl_eigen_hermv(value A, value EVAL, value EVEC, value ws)
{
  _DECLARE_VECTOR(EVAL);
  _DECLARE_COMPLEX_MATRIX2(A, EVEC);
  _CONVERT_VECTOR(EVAL);
  _CONVERT_COMPLEX_MATRIX2(A, EVEC);
  gsl_eigen_hermv(&m_A, &v_EVAL, &m_EVEC, HERMV_WS_val(ws));
  return Val_unit;
}

value ml_gsl_eigen_hermv_sort(value E, value sort)
{
  value EVAL = Field(E, 0);
  value EVEC = Field(E, 1);
  _DECLARE_COMPLEX_MATRIX(EVEC);
  _DECLARE_VECTOR(EVAL);
  _CONVERT_COMPLEX_MATRIX(EVEC);
  _CONVERT_VECTOR(EVAL);
  gsl_eigen_hermv_sort(&v_EVAL, &m_EVEC, eigen_sort_type[ Int_val(sort) ]);
  return Val_unit;
}
