// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_HeaderFile
#define _OSD_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class OSD_Error;
class OSD_Protection;
class OSD_Path;
class OSD_FileNode;
class OSD_Disk;
class OSD_File;
class OSD_FileIterator;
class OSD_Directory;
class OSD_DirectoryIterator;
class OSD_Chronometer;
class OSD_Timer;
class OSD_Printer;
class OSD_Host;
class OSD_Environment;
class OSD_EnvironmentIterator;
class OSD_Process;
class OSD_SharedMemory;
class OSD_Semaphore;
class OSD_MailBox;
class OSD_SharedLibrary;
class OSD_Thread;


//! Set of Operating Sytem Dependent Tools <br>
//!         (O)perating (S)ystem (D)ependent <br>
class OSD  {
public:

  DEFINE_STANDARD_ALLOC

  //! A tool to manage threads <br>
//! Sets signal and exception handlers. <br>
//! <b>Windows-specific notes<\b> <br>
//! Compiled with MS VC++ sets 3 main handlers: <br>
//! @li Signal handlers (via ::signal() functions) that translate system signals <br>
//!     (SIGSEGV, SIGFPE, SIGILL) into C++ exceptions (classes inheriting <br>
//!     Standard_Failure). They only be called if user calls ::raise() function <br>
//!     with one of supported signal type set. <br>
//! @li Exception handler OSD::WntHandler() (via ::SetUnhandledExceptionFilter()) <br>
//!     that will be used when user's code is compiled with /EHs option. <br>
//! @li Structured exception (SE) translator (via _set_se_translator()) that <br>
//!     translates SE exceptions (aka asynchronous exceptions) into the <br>
//!     C++ exceptions inheriting Standard_Failure. This translator will be <br>
//!     used when user's code is compiled with /EHa option. <br>
//! . <br>
//! This approach ensures that regardless of the option the user chooses to <br>
//! compile his code with (/EHs or /EHa), signals (or SE exceptions) will be <br>
//! translated into Open CASCADE C++ exceptions. <br>
//! . <br>
//! If @a theFloatingSignal is TRUE then floating point exceptions will be <br>
//! generated in accordance with the mask <br>
//! <tt>_EM_INVALID | _EM_DENORMAL | _EM_ZERODIVIDE | _EM_OVERFLOW<\tt> that is <br>
//! used to call ::_controlfp() system function. If @a theFloatingSignal is FALSE <br>
//! corresponding operations (e.g. division by zero) will gracefully complete <br>
//! without an exception. <br>
//! . <br>
//! <b>Unix-specific notes<\b> <br>
//! OSD::SetSignal() sets handlers (via ::sigaction()) for multiple signals <br>
//! (SIGFPE, SIGSEGV, etc). Currently the number of handled signals is much <br>
//! greater than for Windows, in the future this may change to provide better <br>
//! consistency with Windows. <br>
//! . <br>
//! @a theFloatingSignal is recognized on Sun Solaris, Linux, and SGI Irix to <br>
//! generate floating-point exception according to the mask <br>
//! <tt>FE_INVALID | FE_DIVBYZERO | FE_OVERFLOW</tt> (in Linux conventions).<br> <br>
//! When compiled with OBJS macro defined, already set signal handlers (e.g. <br>
//! by Data Base Managers) are not redefined. <br>
//! . <br>
//! <b>Common notes<\b> <br>
//! If OSD::SetSignal() method is used in at least one thread, it must also be <br>
//! called in any other thread where Open CASCADE will be used, to ensure <br>
//! consistency of behavior. Its @a aFloatingSignal argument must be consistent <br>
//! across threads. <br>
//! . <br>
//! Keep in mind that whether the C++ exception will really be thrown (i.e. <br>
//! ::throw() will be called) is regulated by the NO_CXX_EXCEPTIONS and <br>
//! OCC_CONVERT_SIGNALS macros used during compilation of Open CASCADE and <br>
//! user's code. Refer to Foundation Classes User's Guide for further details. <br>
//! <br>
  Standard_EXPORT   static  void SetSignal(const Standard_Boolean theFloatingSignal = Standard_True) ;
  //! Returns available memory in Kilobytes. <br>
  Standard_EXPORT   static  Standard_Integer AvailableMemory() ;
  //! Commands the process to sleep for a number of seconds. <br>
  Standard_EXPORT   static  void SecSleep(const Standard_Integer aDelay) ;
  //! Commands the process to sleep for a number of milliseconds <br>
  Standard_EXPORT   static  void MilliSecSleep(const Standard_Integer aDelay) ;
  
//!  Converts aReal into aCstring in exponential format with a period as <br>
//!  decimal point, no thousand separator and no grouping of digits. <br>
//!  The conversion is independant from the current locale <br>
  Standard_EXPORT   static  Standard_Boolean RealToCString(const Standard_Real aReal,Standard_PCharacter& aString) ;
  
//!  Converts aCstring representing a real with a period as <br>
//!  decimal point, no thousand separator and no grouping of digits <br>
//!  into aReal . <br>
//!  The conversion is independant from the current locale. <br>
  Standard_EXPORT   static  Standard_Boolean CStringToReal(const Standard_CString aString,Standard_Real& aReal) ;
  //! Tests if the quotient theDividend/theDivisor <br>
//!          does not overflow <br>
  Standard_EXPORT   static  Standard_Boolean IsDivisible(const Standard_Real aDividend,const Standard_Real aDivisor) ;
  //! Returns the exponent in base 2 of a floating-point number. <br>
  Standard_EXPORT   static  Standard_Integer GetExponent(const Standard_Real aReal) ;
  //! Returns the mantissa of a floating-point number. <br>
  Standard_EXPORT   static  Standard_Real GetMantissa(const Standard_Real aReal) ;
  //! since Windows NT does not support 'SIGINT' signal like UNIX, <br>
//!          then this method checks whether Ctrl-Break keystroke was or <br>
//!          not. If yes then raises Exception_CTRL_BREAK. <br>
  Standard_EXPORT   static  void ControlBreak() ;





protected:





private:




friend class OSD_Error;
friend class OSD_Protection;
friend class OSD_Path;
friend class OSD_FileNode;
friend class OSD_Disk;
friend class OSD_File;
friend class OSD_FileIterator;
friend class OSD_Directory;
friend class OSD_DirectoryIterator;
friend class OSD_Chronometer;
friend class OSD_Timer;
friend class OSD_Printer;
friend class OSD_Host;
friend class OSD_Environment;
friend class OSD_EnvironmentIterator;
friend class OSD_Process;
friend class OSD_SharedMemory;
friend class OSD_Semaphore;
friend class OSD_MailBox;
friend class OSD_SharedLibrary;
friend class OSD_Thread;

};





// other Inline functions and methods (like "C++: function call" methods)


#endif
