// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeAnalysis_ShapeTolerance_HeaderFile
#define _ShapeAnalysis_ShapeTolerance_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Handle_TopTools_HSequenceOfShape_HeaderFile
#include <Handle_TopTools_HSequenceOfShape.hxx>
#endif
class TopoDS_Shape;
class TopTools_HSequenceOfShape;


//! Tool for computing shape tolerances (minimal, maximal, average), <br>
//!          finding shape with tolerance matching given criteria, <br>
//!          setting or limitating tolerances. <br>
class ShapeAnalysis_ShapeTolerance  {
public:

  DEFINE_STANDARD_ALLOC

  //! Empty constructor <br>
  Standard_EXPORT   ShapeAnalysis_ShapeTolerance();
  //! Determines a tolerance from the ones stored in a shape <br>
//!          Remark : calls InitTolerance and AddTolerance, <br>
//!          hence, can be used to start a series for cumulating tolerance <br>
//!          <mode> = 0 : returns the average value between sub-shapes, <br>
//!          <mode> > 0 : returns the maximal found, <br>
//!          <mode> < 0 : returns the minimal found. <br>
//!          <type> defines what kinds of sub-shapes to consider: <br>
//!          SHAPE (default) : all : VERTEX, EDGE, FACE, <br>
//!          VERTEX : only vertices, <br>
//!          EDGE   : only edges, <br>
//!          FACE   : only faces, <br>
//!          SHELL  : combined SHELL + FACE, for each face (and containing <br>
//!          shell), also checks EDGE and VERTEX <br>
  Standard_EXPORT     Standard_Real Tolerance(const TopoDS_Shape& shape,const Standard_Integer mode,const TopAbs_ShapeEnum type = TopAbs_SHAPE) ;
  //! Determines which shapes have a tolerance over the given value <br>
//!          <type> is interpreted as in the method Tolerance <br>
  Standard_EXPORT     Handle_TopTools_HSequenceOfShape OverTolerance(const TopoDS_Shape& shape,const Standard_Real value,const TopAbs_ShapeEnum type = TopAbs_SHAPE) const;
  //! Determines which shapes have a tolerance within a given interval <br>
//!          <type> is interpreted as in the method Tolerance <br>
  Standard_EXPORT     Handle_TopTools_HSequenceOfShape InTolerance(const TopoDS_Shape& shape,const Standard_Real valmin,const Standard_Real valmax,const TopAbs_ShapeEnum type = TopAbs_SHAPE) const;
  //! Initializes computation of cumulated tolerance <br>
  Standard_EXPORT     void InitTolerance() ;
  //! Adds data on new Shape to compute Cumulated Tolerance <br>
//!          (prepares three computations : maximal, average, minimal) <br>
  Standard_EXPORT     void AddTolerance(const TopoDS_Shape& shape,const TopAbs_ShapeEnum type = TopAbs_SHAPE) ;
  //! Returns the computed tolerance according to the <mode> <br>
//!          <mode> = 0 : average <br>
//!          <mode> > 0 : maximal <br>
//!          <mode> < 0 : minimal <br>
  Standard_EXPORT     Standard_Real GlobalTolerance(const Standard_Integer mode) const;





protected:





private:



Standard_Real myTols[3];
Standard_Integer myNbTol;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
