/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Export _dllinfo for FSTYPES.DLL
 *
 * revision history: (please note changes here)
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -first release
 */

#include "config.h"
#include "types.h"
#include "boot/plinkman.h"
#include "mdb.h"

extern struct mdbreadinforegstruct
#ifdef HAVE_MAD
	ampegpReadInfoReg,
#endif
	itpReadInfoReg,
	oggReadInfoReg,
	gmdReadInfoReg,
	xmpReadInfoReg,
	gmiReadInfoReg,
	wavReadInfoReg;

static void __attribute__((constructor))init(void)
{
#ifdef HAVE_MAD
	mdbRegisterReadInfo(&ampegpReadInfoReg);
#endif
	mdbRegisterReadInfo(&itpReadInfoReg);
	mdbRegisterReadInfo(&oggReadInfoReg);
	mdbRegisterReadInfo(&gmdReadInfoReg);
	mdbRegisterReadInfo(&xmpReadInfoReg);
	mdbRegisterReadInfo(&gmiReadInfoReg);
	mdbRegisterReadInfo(&wavReadInfoReg);
}

static void __attribute__((destructor))done(void)
{
#ifdef HAVE_MAD
	mdbUnregisterReadInfo(&ampegpReadInfoReg);
#endif
	mdbUnregisterReadInfo(&itpReadInfoReg);
	mdbUnregisterReadInfo(&oggReadInfoReg);
	mdbUnregisterReadInfo(&gmdReadInfoReg);
	mdbUnregisterReadInfo(&xmpReadInfoReg);
	mdbUnregisterReadInfo(&gmiReadInfoReg);
	mdbUnregisterReadInfo(&wavReadInfoReg);
}

#ifndef SUPPORT_STATIC_PLUGINS
char *dllinfo = "";
#endif

DLLEXTINFO_PREFIX struct linkinfostruct dllextinfo = {"fstypes", "OpenCP Module Detection (c) 1994-04 Niklas Beisert, Tammo Hinrichs", DLLVERSION, 0 LINKINFOSTRUCT_NOEVENTS};
