#ifndef _MCHASM_H
#define _MCHASM_H

#ifdef I386_ASM
#define RP2 __attribute__ ((regparm (2)))
#else
#define RP2
#endif

typedef uint32_t RP2 (*mixAddAbsfn)(const void *ch, uint32_t len);

extern uint32_t RP2 mixAddAbs16M(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs16MS(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs16S(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs16SS(const void *ch, uint32_t len);

extern uint32_t RP2 mixAddAbs8M(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs8MS(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs8S(const void *ch, uint32_t len);
extern uint32_t RP2 mixAddAbs8SS(const void *ch, uint32_t len);


#if defined(I386_ASM) && !defined(__PIC__)
#define RP3 __attribute__ ((regparm (3)))
#else
#define RP3
#endif

typedef void RP3 (*mixGetMasterSamplefn)(int16_t *dst, const void *src, uint32_t len, uint32_t step);

extern void RP3 mixGetMasterSampleMS8M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMU8M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMS8S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMU8S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS8M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU8M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS8S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU8S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS8SR(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU8SR(int16_t *dst, const void *src, uint32_t len, uint32_t step);

extern void RP3 mixGetMasterSampleMS16M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMU16M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMS16S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleMU16S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS16M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU16M(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS16S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU16S(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSS16SR(int16_t *dst, const void *src, uint32_t len, uint32_t step);
extern void RP3 mixGetMasterSampleSU16SR(int16_t *dst, const void *src, uint32_t len, uint32_t step);

/*
#pragma aux mixMasterAddAbs parm [esi] [edi] value [ecx] modify [eax]
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs16M(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs16MS(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs16S(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs16SS(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs8M(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs8MS(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs8S(const void *ch, unsigned long len);
extern "C" unsigned long __pragma("mixMasterAddAbs") mixAddAbs8SS(const void *ch, unsigned long len);
*/

/*
#pragma aux mixGetMasterSample parm [edi] [esi] [ecx] [edx] modify [eax ebx]
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMS8M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMU8M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMS8S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMU8S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS8M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU8M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS8S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU8S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS8SR(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU8SR(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMS16M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMU16M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMS16S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleMU16S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS16M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU16M(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS16S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU16S(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSS16SR(short *buf2, const void *buf, int len, long step);
extern "C" void __pragma("mixGetMasterSample") mixGetMasterSampleSU16SR(short *buf2, const void *buf, int len, long step);
*/

#endif
