/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004, 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <cstdio>
#include <vector>
#include "common.h"
#include "rectangle.h"
#include "ucs.h"
#include "block.h"
#include "blockmap.h"
#include "character.h"
#include "profile.h"
#include "feats.h"


// Recognizes 3 block characters.
// %
void Character::recognize13( const Charset & charset, const Rectangle & charbox ) throw()
  {
  const Block & b1 = block( 0 );
  const Block & b2 = block( 1 );
  const Block & b3 = block( 2 );		// lower block
  Character c( b3 );
  int code = 0;

  c.recognize1( charset, charbox );
  if( c.guesses() )
    {
    if( c.maybe('.') )
      {
      if( b1.bottom() <= b2.top() && b2.bottom() <= b3.top() )
        { if( b2.width() >= 2 * b2.height() ) code = UCS::DIV; }
      else code = '%';
      }
    else if( Ocrad::similar( b1.width(), b2.width(), 20 ) &&
             Ocrad::similar( b1.height(), b2.height(), 20 ) &&
             2 * b1.height() < b3.height() )
      code = UCS::compose( c.guess( 0 ).code, ':' );
    }
  if( charset.only( Charset::ascii ) )
    {
    if( code == UCS::DIV ) code = '%';
    else code = UCS::base_letter( code );
    }
  if( code ) add_guess( code, 0 );
  }
