## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  [in, out] = two_normal_set (n)
##
## Returns a 2 class training set of size n consisting of two bivariate
## normals with unit varianve centered around (1,1) and (-1,-1). The
## misclassification rate of the Bayesian classifier is approx. 8%.
  
## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  Data for 2 normals classification problem
			
function [in, out] = two_normal_set (n)

  n = ceil (n / 2);

  in = [randn (n, 2) + ones (n, 1) * [1 1]; 
        randn (n, 2) + ones (n, 1) * [-1 -1] ];
  out = [ones (n, 1), zeros (n, 1); zeros (n, 1), ones (n, 1)];
  
  k = rand (2 * n, 1);
  [dummy, kind] = sort (k);
  
  in = in (kind, :);
  out = out (kind, :);
  
endfunction


