## Copyright (C) 2007 Muthiah Annamalai 
##
## --parts of code AUTOGENERATED. DONOT EDIT--
## --DONOT EDIT--
##
## This code is released under GPL
## You should have received a copy of the GNU General Public License
## along with this software; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} [@var{Val},@var{unit},@var{uncertanity},@var{desc},@var{name}] {} =physical_constant(@var{arg})
## @var{arg} is the name of the physical constant to retrieve.
## The output arguments are the attributes which you need. 
## By default, the return value is the constant value.
## if no arguments are passed, depending on the output arguments the entire units structure is returned
## @var{Val} is actual value of the constant.
## @var{Unit} is a Units string.
## @var{uncertanity} is +/- value to constant.
##
## Autogenerated on Fri Feb 23 00:35:47 2007
## from NIST database at  http://physics.nist.gov/constants 
## @end deftypefn

## Fundamental Physical Constants --- Complete Listing
## From:  http://physics.nist.gov/constants
## Source: Peter J. Mohr and Barry N. Taylor, CODATA Recommended Values of the 
## Fundamental Physical Constants: 2002, published in Rev. Mod. Phys.
## vol. 77(1) 1-107 (2005).
## Taken from: physics.nist.gov/cuu/Constants/Table/allascii.txt
##
    
function  [rval,unit,uncert,desc,name]=physical_constant(arg)

 persistent unit_data;
 if isstruct(unit_data) == 0 
   unit_data=struct();
   unit_data( 1 ).name="ALPHA_PARTICLE_ELECTRON_MASS_RATIO";
   unit_data( 1 ).description="alpha particle-electron mass ratio";
   unit_data( 1 ).value=7294.2995363;
   unit_data( 1 ).units="";
   unit_data( 1 ).uncertanity=0.0000032;

   unit_data( 2 ).name="ALPHA_PARTICLE_MASS";
   unit_data( 2 ).description="alpha particle mass";
   unit_data( 2 ).value=6.6446565e-27;
   unit_data( 2 ).units="kg";
   unit_data( 2 ).uncertanity=0.0000011e-27;

   unit_data( 3 ).name="ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT";
   unit_data( 3 ).description="alpha particle mass energy equivalent";
   unit_data( 3 ).value=5.9719194e-10;
   unit_data( 3 ).units="J";
   unit_data( 3 ).uncertanity=0.0000010e-10;

   unit_data( 4 ).name="ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 4 ).description="alpha particle mass energy equivalent in MeV";
   unit_data( 4 ).value=3727.37917;
   unit_data( 4 ).units="MeV";
   unit_data( 4 ).uncertanity=0.00032;

   unit_data( 5 ).name="ALPHA_PARTICLE_MASS_IN_U";
   unit_data( 5 ).description="alpha particle mass in u";
   unit_data( 5 ).value=4.001506179149;
   unit_data( 5 ).units="u";
   unit_data( 5 ).uncertanity=0.000000000056;

   unit_data( 6 ).name="ALPHA_PARTICLE_MOLAR_MASS";
   unit_data( 6 ).description="alpha particle molar mass";
   unit_data( 6 ).value=4.001506179149e-3;
   unit_data( 6 ).units="kg mol^-1";
   unit_data( 6 ).uncertanity=0.000000000056e-3;

   unit_data( 7 ).name="ALPHA_PARTICLE_PROTON_MASS_RATIO";
   unit_data( 7 ).description="alpha particle-proton mass ratio";
   unit_data( 7 ).value=3.97259968907;
   unit_data( 7 ).units="";
   unit_data( 7 ).uncertanity=0.00000000052;

   unit_data( 8 ).name="ANGSTROM_STAR";
   unit_data( 8 ).description="Angstrom star";
   unit_data( 8 ).value=1.00001509e-10;
   unit_data( 8 ).units="m";
   unit_data( 8 ).uncertanity=0.00000090e-10;

   unit_data( 9 ).name="ATOMIC_MASS_CONSTANT";
   unit_data( 9 ).description="atomic mass constant";
   unit_data( 9 ).value=1.66053886e-27;
   unit_data( 9 ).units="kg";
   unit_data( 9 ).uncertanity=0.00000028e-27;

   unit_data( 10 ).name="ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT";
   unit_data( 10 ).description="atomic mass constant energy equivalent";
   unit_data( 10 ).value=1.49241790e-10;
   unit_data( 10 ).units="J";
   unit_data( 10 ).uncertanity=0.00000026e-10;

   unit_data( 11 ).name="ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 11 ).description="atomic mass constant energy equivalent in MeV";
   unit_data( 11 ).value=931.494043;
   unit_data( 11 ).units="MeV";
   unit_data( 11 ).uncertanity=0.000080;

   unit_data( 12 ).name="ATOMIC_MASS_UNIT_ELECTRON_VOLT";
   unit_data( 12 ).description="atomic mass unit-electron volt relationship";
   unit_data( 12 ).value=931.494043e6;
   unit_data( 12 ).units="eV";
   unit_data( 12 ).uncertanity=0.000080e6;

   unit_data( 13 ).name="ATOMIC_MASS_UNIT_HARTREE";
   unit_data( 13 ).description="atomic mass unit-hartree relationship";
   unit_data( 13 ).value=3.423177686e7;
   unit_data( 13 ).units="E_h";
   unit_data( 13 ).uncertanity=0.000000023e7;

   unit_data( 14 ).name="ATOMIC_MASS_UNIT_HERTZ";
   unit_data( 14 ).description="atomic mass unit-hertz relationship";
   unit_data( 14 ).value=2.252342718e23;
   unit_data( 14 ).units="Hz";
   unit_data( 14 ).uncertanity=0.000000015e23;

   unit_data( 15 ).name="ATOMIC_MASS_UNIT_INVERSE_METER";
   unit_data( 15 ).description="atomic mass unit-inverse meter relationship";
   unit_data( 15 ).value=7.513006608e14;
   unit_data( 15 ).units="m^-1";
   unit_data( 15 ).uncertanity=0.000000050e14;

   unit_data( 16 ).name="ATOMIC_MASS_UNIT_JOULE";
   unit_data( 16 ).description="atomic mass unit-joule relationship";
   unit_data( 16 ).value=1.49241790e-10;
   unit_data( 16 ).units="J";
   unit_data( 16 ).uncertanity=0.00000026e-10;

   unit_data( 17 ).name="ATOMIC_MASS_UNIT_KELVIN";
   unit_data( 17 ).description="atomic mass unit-kelvin relationship";
   unit_data( 17 ).value=1.0809527e13;
   unit_data( 17 ).units="K";
   unit_data( 17 ).uncertanity=0.0000019e13;

   unit_data( 18 ).name="ATOMIC_MASS_UNIT_KILOGRAM";
   unit_data( 18 ).description="atomic mass unit-kilogram relationship";
   unit_data( 18 ).value=1.66053886e-27;
   unit_data( 18 ).units="kg";
   unit_data( 18 ).uncertanity=0.00000028e-27;

   unit_data( 19 ).name="ATOMIC_UNIT_OF_1ST_HYPERPOLARIZABLITY";
   unit_data( 19 ).description="atomic unit of 1st hyperpolarizablity";
   unit_data( 19 ).value=3.20636151e-53;
   unit_data( 19 ).units="C^3 m^3 J^-2";
   unit_data( 19 ).uncertanity=0.00000028e-53;

   unit_data( 20 ).name="ATOMIC_UNIT_OF_2ND_HYPERPOLARIZABLITY";
   unit_data( 20 ).description="atomic unit of 2nd hyperpolarizablity";
   unit_data( 20 ).value=6.2353808e-65;
   unit_data( 20 ).units="C^4 m^4 J^-3";
   unit_data( 20 ).uncertanity=0.0000011e-65;

   unit_data( 21 ).name="ATOMIC_UNIT_OF_ACTION";
   unit_data( 21 ).description="atomic unit of action";
   unit_data( 21 ).value=1.05457168e-34;
   unit_data( 21 ).units="J s";
   unit_data( 21 ).uncertanity=0.00000018e-34;

   unit_data( 22 ).name="ATOMIC_UNIT_OF_CHARGE";
   unit_data( 22 ).description="atomic unit of charge";
   unit_data( 22 ).value=1.60217653e-19;
   unit_data( 22 ).units="C";
   unit_data( 22 ).uncertanity=0.00000014e-19;

   unit_data( 23 ).name="ATOMIC_UNIT_OF_CHARGE_DENSITY";
   unit_data( 23 ).description="atomic unit of charge density";
   unit_data( 23 ).value=1.081202317e12;
   unit_data( 23 ).units="C m^-3";
   unit_data( 23 ).uncertanity=0.000000093e12;

   unit_data( 24 ).name="ATOMIC_UNIT_OF_CURRENT";
   unit_data( 24 ).description="atomic unit of current";
   unit_data( 24 ).value=6.62361782e-3;
   unit_data( 24 ).units="A";
   unit_data( 24 ).uncertanity=0.00000057e-3;

   unit_data( 25 ).name="ATOMIC_UNIT_OF_ELECTRIC_DIPOLE_MOMENT";
   unit_data( 25 ).description="atomic unit of electric dipole moment";
   unit_data( 25 ).value=8.47835309e-30;
   unit_data( 25 ).units="C m";
   unit_data( 25 ).uncertanity=0.00000073e-30;

   unit_data( 26 ).name="ATOMIC_UNIT_OF_ELECTRIC_FIELD";
   unit_data( 26 ).description="atomic unit of electric field";
   unit_data( 26 ).value=5.14220642e11;
   unit_data( 26 ).units="V m^-1";
   unit_data( 26 ).uncertanity=0.00000044e11;

   unit_data( 27 ).name="ATOMIC_UNIT_OF_ELECTRIC_FIELD_GRADIENT";
   unit_data( 27 ).description="atomic unit of electric field gradient";
   unit_data( 27 ).value=9.71736182e21;
   unit_data( 27 ).units="V m^-2";
   unit_data( 27 ).uncertanity=0.00000083e21;

   unit_data( 28 ).name="ATOMIC_UNIT_OF_ELECTRIC_POLARIZABLITY";
   unit_data( 28 ).description="atomic unit of electric polarizablity";
   unit_data( 28 ).value=1.648777274e-41;
   unit_data( 28 ).units="C^2 m^2 J^-1";
   unit_data( 28 ).uncertanity=0.000000016e-41;

   unit_data( 29 ).name="ATOMIC_UNIT_OF_ELECTRIC_POTENTIAL";
   unit_data( 29 ).description="atomic unit of electric potential";
   unit_data( 29 ).value=27.2113845;
   unit_data( 29 ).units="V";
   unit_data( 29 ).uncertanity=0.0000023;

   unit_data( 30 ).name="ATOMIC_UNIT_OF_ELECTRIC_QUADRUPOLE_MOMENT";
   unit_data( 30 ).description="atomic unit of electric quadrupole moment";
   unit_data( 30 ).value=4.48655124e-40;
   unit_data( 30 ).units="C m^2";
   unit_data( 30 ).uncertanity=0.00000039e-40;

   unit_data( 31 ).name="ATOMIC_UNIT_OF_ENERGY";
   unit_data( 31 ).description="atomic unit of energy";
   unit_data( 31 ).value=4.35974417e-18;
   unit_data( 31 ).units="J";
   unit_data( 31 ).uncertanity=0.00000075e-18;

   unit_data( 32 ).name="ATOMIC_UNIT_OF_FORCE";
   unit_data( 32 ).description="atomic unit of force";
   unit_data( 32 ).value=8.2387225e-8;
   unit_data( 32 ).units="N";
   unit_data( 32 ).uncertanity=0.0000014e-8;

   unit_data( 33 ).name="ATOMIC_UNIT_OF_LENGTH";
   unit_data( 33 ).description="atomic unit of length";
   unit_data( 33 ).value=0.5291772108e-10;
   unit_data( 33 ).units="m";
   unit_data( 33 ).uncertanity=0.0000000018e-10;

   unit_data( 34 ).name="ATOMIC_UNIT_OF_MAGNETIZABILITY";
   unit_data( 34 ).description="atomic unit of magnetizability";
   unit_data( 34 ).value=7.89103660e-29;
   unit_data( 34 ).units="J T^-2";
   unit_data( 34 ).uncertanity=0.00000013e-29;

   unit_data( 35 ).name="ATOMIC_UNIT_OF_MAGN_DIPOLE_MOMENT";
   unit_data( 35 ).description="atomic unit of magn. dipole moment";
   unit_data( 35 ).value=1.85480190e-23;
   unit_data( 35 ).units="J T^-1";
   unit_data( 35 ).uncertanity=0.00000016e-23;

   unit_data( 36 ).name="ATOMIC_UNIT_OF_MAGN_FLUX_DENSITY";
   unit_data( 36 ).description="atomic unit of magn. flux density";
   unit_data( 36 ).value=2.35051742e5;
   unit_data( 36 ).units="T";
   unit_data( 36 ).uncertanity=0.00000020e5;

   unit_data( 37 ).name="ATOMIC_UNIT_OF_MASS";
   unit_data( 37 ).description="atomic unit of mass";
   unit_data( 37 ).value=9.1093826e-31;
   unit_data( 37 ).units="kg";
   unit_data( 37 ).uncertanity=0.0000016e-31;

   unit_data( 38 ).name="ATOMIC_UNIT_OF_MOMENTUM";
   unit_data( 38 ).description="atomic unit of momentum";
   unit_data( 38 ).value=1.99285166e-24;
   unit_data( 38 ).units="kg m s^-1";
   unit_data( 38 ).uncertanity=0.00000034e-24;

   unit_data( 39 ).name="ATOMIC_UNIT_OF_PERMITTIVITY";
   unit_data( 39 ).description="atomic unit of permittivity";
   unit_data( 39 ).value=1.112650056e-10;
   unit_data( 39 ).units="F m^-1";
   unit_data( 39 ).uncertanity=0.0;

   unit_data( 40 ).name="ATOMIC_UNIT_OF_TIME";
   unit_data( 40 ).description="atomic unit of time";
   unit_data( 40 ).value=2.418884326505e-17;
   unit_data( 40 ).units="s";
   unit_data( 40 ).uncertanity=0.000000000016e-17;

   unit_data( 41 ).name="ATOMIC_UNIT_OF_VELOCITY";
   unit_data( 41 ).description="atomic unit of velocity";
   unit_data( 41 ).value=2.1876912633e6;
   unit_data( 41 ).units="m s^-1";
   unit_data( 41 ).uncertanity=0.0000000073e6;

   unit_data( 42 ).name="AVOGADRO_CONSTANT";
   unit_data( 42 ).description="Avogadro constant";
   unit_data( 42 ).value=6.0221415e23;
   unit_data( 42 ).units="mol^-1";
   unit_data( 42 ).uncertanity=0.0000010e23;

   unit_data( 43 ).name="BOHR_MAGNETON";
   unit_data( 43 ).description="Bohr magneton";
   unit_data( 43 ).value=927.400949e-26;
   unit_data( 43 ).units="J T^-1";
   unit_data( 43 ).uncertanity=0.000080e-26;

   unit_data( 44 ).name="BOHR_MAGNETON_IN_EV_PER_T";
   unit_data( 44 ).description="Bohr magneton in eV/T";
   unit_data( 44 ).value=5.788381804e-5;
   unit_data( 44 ).units="eV T^-1";
   unit_data( 44 ).uncertanity=0.000000039e-5;

   unit_data( 45 ).name="BOHR_MAGNETON_IN_HZ_PER_T";
   unit_data( 45 ).description="Bohr magneton in Hz/T";
   unit_data( 45 ).value=13.9962458e9;
   unit_data( 45 ).units="Hz T^-1";
   unit_data( 45 ).uncertanity=0.0000012e9;

   unit_data( 46 ).name="BOHR_MAGNETON_IN_INVERSE_METERS_PER_TESLA";
   unit_data( 46 ).description="Bohr magneton in inverse meters per tesla";
   unit_data( 46 ).value=46.6864507;
   unit_data( 46 ).units="m^-1 T^-1";
   unit_data( 46 ).uncertanity=0.0000040;

   unit_data( 47 ).name="BOHR_MAGNETON_IN_K_PER_T";
   unit_data( 47 ).description="Bohr magneton in K/T";
   unit_data( 47 ).value=0.6717131;
   unit_data( 47 ).units="K T^-1";
   unit_data( 47 ).uncertanity=0.0000012;

   unit_data( 48 ).name="BOHR_RADIUS";
   unit_data( 48 ).description="Bohr radius";
   unit_data( 48 ).value=0.5291772108e-10;
   unit_data( 48 ).units="m";
   unit_data( 48 ).uncertanity=0.0000000018e-10;

   unit_data( 49 ).name="BOLTZMANN_CONSTANT";
   unit_data( 49 ).description="Boltzmann constant";
   unit_data( 49 ).value=1.3806505e-23;
   unit_data( 49 ).units="J K^-1";
   unit_data( 49 ).uncertanity=0.0000024e-23;

   unit_data( 50 ).name="BOLTZMANN_CONSTANT_IN_EV_PER_K";
   unit_data( 50 ).description="Boltzmann constant in eV/K";
   unit_data( 50 ).value=8.617343e-5;
   unit_data( 50 ).units="eV K^-1";
   unit_data( 50 ).uncertanity=0.000015e-5;

   unit_data( 51 ).name="BOLTZMANN_CONSTANT_IN_HZ_PER_K";
   unit_data( 51 ).description="Boltzmann constant in Hz/K";
   unit_data( 51 ).value=2.0836644e10;
   unit_data( 51 ).units="Hz K^-1";
   unit_data( 51 ).uncertanity=0.0000036e10;

   unit_data( 52 ).name="BOLTZMANN_CONSTANT_IN_INVERSE_METERS_PER_KELVIN";
   unit_data( 52 ).description="Boltzmann constant in inverse meters per kelvin";
   unit_data( 52 ).value=69.50356;
   unit_data( 52 ).units="m^-1 K^-1";
   unit_data( 52 ).uncertanity=0.00012;

   unit_data( 53 ).name="CHARACTERISTIC_IMPEDANCE_OF_VACUUM";
   unit_data( 53 ).description="characteristic impedance of vacuum";
   unit_data( 53 ).value=376.730313461;
   unit_data( 53 ).units="ohm";
   unit_data( 53 ).uncertanity=0.0;

   unit_data( 54 ).name="CLASSICAL_ELECTRON_RADIUS";
   unit_data( 54 ).description="classical electron radius";
   unit_data( 54 ).value=2.817940325e-15;
   unit_data( 54 ).units="m";
   unit_data( 54 ).uncertanity=0.000000028e-15;

   unit_data( 55 ).name="COMPTON_WAVELENGTH";
   unit_data( 55 ).description="Compton wavelength";
   unit_data( 55 ).value=2.426310238e-12;
   unit_data( 55 ).units="m";
   unit_data( 55 ).uncertanity=0.000000016e-12;

   unit_data( 56 ).name="COMPTON_WAVELENGTH_BY_2_PI";
   unit_data( 56 ).description="Compton wavelength over 2 pi";
   unit_data( 56 ).value=386.1592678e-15;
   unit_data( 56 ).units="m";
   unit_data( 56 ).uncertanity=0.0000026e-15;

   unit_data( 57 ).name="CONDUCTANCE_QUANTUM";
   unit_data( 57 ).description="conductance quantum";
   unit_data( 57 ).value=7.748091733e-5;
   unit_data( 57 ).units="S";
   unit_data( 57 ).uncertanity=0.000000026e-5;

   unit_data( 58 ).name="CONVENTIONAL_VALUE_OF_JOSEPHSON_CONSTANT";
   unit_data( 58 ).description="conventional value of Josephson constant";
   unit_data( 58 ).value=483597.9e9;
   unit_data( 58 ).units="Hz V^-1";
   unit_data( 58 ).uncertanity=0.0;

   unit_data( 59 ).name="CONVENTIONAL_VALUE_OF_VON_KLITZING_CONSTANT";
   unit_data( 59 ).description="conventional value of von Klitzing constant";
   unit_data( 59 ).value=25812.807;
   unit_data( 59 ).units="ohm";
   unit_data( 59 ).uncertanity=0.0;

   unit_data( 60 ).name="CU_X_UNIT";
   unit_data( 60 ).description="Cu x unit";
   unit_data( 60 ).value=1.00207710e-13;
   unit_data( 60 ).units="m";
   unit_data( 60 ).uncertanity=0.00000029e-13;

   unit_data( 61 ).name="DEUTERON_ELECTRON_MAGN_MOMENT_RATIO";
   unit_data( 61 ).description="deuteron-electron magn. moment ratio";
   unit_data( 61 ).value=-4.664345548e-4;
   unit_data( 61 ).units="";
   unit_data( 61 ).uncertanity=0.000000050e-4;

   unit_data( 62 ).name="DEUTERON_ELECTRON_MASS_RATIO";
   unit_data( 62 ).description="deuteron-electron mass ratio";
   unit_data( 62 ).value=3670.4829652;
   unit_data( 62 ).units="";
   unit_data( 62 ).uncertanity=0.0000018;

   unit_data( 63 ).name="DEUTERON_MAGN_MOMENT";
   unit_data( 63 ).description="deuteron magn. moment";
   unit_data( 63 ).value=0.433073482e-26;
   unit_data( 63 ).units="J T^-1";
   unit_data( 63 ).uncertanity=0.000000038e-26;

   unit_data( 64 ).name="DEUTERON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 64 ).description="deuteron magn. moment to Bohr magneton ratio";
   unit_data( 64 ).value=0.4669754567e-3;
   unit_data( 64 ).units="";
   unit_data( 64 ).uncertanity=0.0000000050e-3;

   unit_data( 65 ).name="DEUTERON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 65 ).description="deuteron magn. moment to nuclear magneton ratio";
   unit_data( 65 ).value=0.8574382329;
   unit_data( 65 ).units="";
   unit_data( 65 ).uncertanity=0.0000000092;

   unit_data( 66 ).name="DEUTERON_MASS";
   unit_data( 66 ).description="deuteron mass";
   unit_data( 66 ).value=3.34358335e-27;
   unit_data( 66 ).units="kg";
   unit_data( 66 ).uncertanity=0.00000057e-27;

   unit_data( 67 ).name="DEUTERON_MASS_ENERGY_EQUIVALENT";
   unit_data( 67 ).description="deuteron mass energy equivalent";
   unit_data( 67 ).value=3.00506285e-10;
   unit_data( 67 ).units="J";
   unit_data( 67 ).uncertanity=0.00000051e-10;

   unit_data( 68 ).name="DEUTERON_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 68 ).description="deuteron mass energy equivalent in MeV";
   unit_data( 68 ).value=1875.61282;
   unit_data( 68 ).units="MeV";
   unit_data( 68 ).uncertanity=0.00016;

   unit_data( 69 ).name="DEUTERON_MASS_IN_U";
   unit_data( 69 ).description="deuteron mass in u";
   unit_data( 69 ).value=2.01355321270;
   unit_data( 69 ).units="u";
   unit_data( 69 ).uncertanity=0.00000000035;

   unit_data( 70 ).name="DEUTERON_MOLAR_MASS";
   unit_data( 70 ).description="deuteron molar mass";
   unit_data( 70 ).value=2.01355321270e-3;
   unit_data( 70 ).units="kg mol^-1";
   unit_data( 70 ).uncertanity=0.00000000035e-3;

   unit_data( 71 ).name="DEUTERON_NEUTRON_MAGN_MOMENT_RATIO";
   unit_data( 71 ).description="deuteron-neutron magn. moment ratio";
   unit_data( 71 ).value=-0.44820652;
   unit_data( 71 ).units="";
   unit_data( 71 ).uncertanity=0.00000011;

   unit_data( 72 ).name="DEUTERON_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 72 ).description="deuteron-proton magn. moment ratio";
   unit_data( 72 ).value=0.3070122084;
   unit_data( 72 ).units="";
   unit_data( 72 ).uncertanity=0.0000000045;

   unit_data( 73 ).name="DEUTERON_PROTON_MASS_RATIO";
   unit_data( 73 ).description="deuteron-proton mass ratio";
   unit_data( 73 ).value=1.99900750082;
   unit_data( 73 ).units="";
   unit_data( 73 ).uncertanity=0.00000000041;

   unit_data( 74 ).name="DEUTERON_RMS_CHARGE_RADIUS";
   unit_data( 74 ).description="deuteron rms charge radius";
   unit_data( 74 ).value=2.1394e-15;
   unit_data( 74 ).units="m";
   unit_data( 74 ).uncertanity=0.0028e-15;

   unit_data( 75 ).name="ELECTRIC_CONSTANT";
   unit_data( 75 ).description="electric constant";
   unit_data( 75 ).value=8.854187817e-12;
   unit_data( 75 ).units="F m^-1";
   unit_data( 75 ).uncertanity=0.0;

   unit_data( 76 ).name="ELECTRON_CHARGE_TO_MASS_QUOTIENT";
   unit_data( 76 ).description="electron charge to mass quotient";
   unit_data( 76 ).value=-1.75882012e11;
   unit_data( 76 ).units="C kg^-1";
   unit_data( 76 ).uncertanity=0.00000015e11;

   unit_data( 77 ).name="ELECTRON_DEUTERON_MAGN_MOMENT_RATIO";
   unit_data( 77 ).description="electron-deuteron magn. moment ratio";
   unit_data( 77 ).value=-2143.923493;
   unit_data( 77 ).units="";
   unit_data( 77 ).uncertanity=0.000023;

   unit_data( 78 ).name="ELECTRON_DEUTERON_MASS_RATIO";
   unit_data( 78 ).description="electron-deuteron mass ratio";
   unit_data( 78 ).value=2.7244371095e-4;
   unit_data( 78 ).units="";
   unit_data( 78 ).uncertanity=0.0000000013e-4;

   unit_data( 79 ).name="ELECTRON_GYROMAGN_RATIO";
   unit_data( 79 ).description="electron gyromagn. ratio";
   unit_data( 79 ).value=1.76085974e11;
   unit_data( 79 ).units="s^-1 T^-1";
   unit_data( 79 ).uncertanity=0.00000015e11;

   unit_data( 80 ).name="ELECTRON_GYROMAGN_RATIO_BY_2_PI";
   unit_data( 80 ).description="electron gyromagn. ratio over 2 pi";
   unit_data( 80 ).value=28024.9532;
   unit_data( 80 ).units="MHz T^-1";
   unit_data( 80 ).uncertanity=0.0024;

   unit_data( 81 ).name="ELECTRON_G_FACTOR";
   unit_data( 81 ).description="electron g factor";
   unit_data( 81 ).value=-2.0023193043718;
   unit_data( 81 ).units="";
   unit_data( 81 ).uncertanity=0.0000000000075;

   unit_data( 82 ).name="ELECTRON_MAGN_MOMENT";
   unit_data( 82 ).description="electron magn. moment";
   unit_data( 82 ).value=-928.476412e-26;
   unit_data( 82 ).units="J T^-1";
   unit_data( 82 ).uncertanity=0.000080e-26;

   unit_data( 83 ).name="ELECTRON_MAGN_MOMENT_ANOMALY";
   unit_data( 83 ).description="electron magn. moment anomaly";
   unit_data( 83 ).value=1.1596521859e-3;
   unit_data( 83 ).units="";
   unit_data( 83 ).uncertanity=0.0000000038e-3;

   unit_data( 84 ).name="ELECTRON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 84 ).description="electron magn. moment to Bohr magneton ratio";
   unit_data( 84 ).value=-1.0011596521859;
   unit_data( 84 ).units="";
   unit_data( 84 ).uncertanity=0.0000000000038;

   unit_data( 85 ).name="ELECTRON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 85 ).description="electron magn. moment to nuclear magneton ratio";
   unit_data( 85 ).value=-1838.28197107;
   unit_data( 85 ).units="";
   unit_data( 85 ).uncertanity=0.00000085;

   unit_data( 86 ).name="ELECTRON_MASS";
   unit_data( 86 ).description="electron mass";
   unit_data( 86 ).value=9.1093826e-31;
   unit_data( 86 ).units="kg";
   unit_data( 86 ).uncertanity=0.0000016e-31;

   unit_data( 87 ).name="ELECTRON_MASS_ENERGY_EQUIVALENT";
   unit_data( 87 ).description="electron mass energy equivalent";
   unit_data( 87 ).value=8.1871047e-14;
   unit_data( 87 ).units="J";
   unit_data( 87 ).uncertanity=0.0000014e-14;

   unit_data( 88 ).name="ELECTRON_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 88 ).description="electron mass energy equivalent in MeV";
   unit_data( 88 ).value=0.510998918;
   unit_data( 88 ).units="MeV";
   unit_data( 88 ).uncertanity=0.000000044;

   unit_data( 89 ).name="ELECTRON_MASS_IN_U";
   unit_data( 89 ).description="electron mass in u";
   unit_data( 89 ).value=5.4857990945e-4;
   unit_data( 89 ).units="u";
   unit_data( 89 ).uncertanity=0.0000000024e-4;

   unit_data( 90 ).name="ELECTRON_MOLAR_MASS";
   unit_data( 90 ).description="electron molar mass";
   unit_data( 90 ).value=5.4857990945e-7;
   unit_data( 90 ).units="kg mol^-1";
   unit_data( 90 ).uncertanity=0.0000000024e-7;

   unit_data( 91 ).name="ELECTRON_MUON_MAGN_MOMENT_RATIO";
   unit_data( 91 ).description="electron-muon magn. moment ratio";
   unit_data( 91 ).value=206.7669894;
   unit_data( 91 ).units="";
   unit_data( 91 ).uncertanity=0.0000054;

   unit_data( 92 ).name="ELECTRON_MUON_MASS_RATIO";
   unit_data( 92 ).description="electron-muon mass ratio";
   unit_data( 92 ).value=4.83633167e-3;
   unit_data( 92 ).units="";
   unit_data( 92 ).uncertanity=0.00000013e-3;

   unit_data( 93 ).name="ELECTRON_NEUTRON_MAGN_MOMENT_RATIO";
   unit_data( 93 ).description="electron-neutron magn. moment ratio";
   unit_data( 93 ).value=960.92050;
   unit_data( 93 ).units="";
   unit_data( 93 ).uncertanity=0.00023;

   unit_data( 94 ).name="ELECTRON_NEUTRON_MASS_RATIO";
   unit_data( 94 ).description="electron-neutron mass ratio";
   unit_data( 94 ).value=5.4386734481e-4;
   unit_data( 94 ).units="";
   unit_data( 94 ).uncertanity=0.0000000038e-4;

   unit_data( 95 ).name="ELECTRON_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 95 ).description="electron-proton magn. moment ratio";
   unit_data( 95 ).value=-658.2106862;
   unit_data( 95 ).units="";
   unit_data( 95 ).uncertanity=0.0000066;

   unit_data( 96 ).name="ELECTRON_PROTON_MASS_RATIO";
   unit_data( 96 ).description="electron-proton mass ratio";
   unit_data( 96 ).value=5.4461702173e-4;
   unit_data( 96 ).units="";
   unit_data( 96 ).uncertanity=0.0000000025e-4;

   unit_data( 97 ).name="ELECTRON_TAU_MASS_RATIO";
   unit_data( 97 ).description="electron-tau mass ratio";
   unit_data( 97 ).value=2.87564e-4;
   unit_data( 97 ).units="";
   unit_data( 97 ).uncertanity=0.00047e-4;

   unit_data( 98 ).name="ELECTRON_TO_ALPHA_PARTICLE_MASS_RATIO";
   unit_data( 98 ).description="electron to alpha particle mass ratio";
   unit_data( 98 ).value=1.37093355575e-4;
   unit_data( 98 ).units="";
   unit_data( 98 ).uncertanity=0.00000000061e-4;

   unit_data( 99 ).name="ELECTRON_TO_SHIELDED_HELION_MAGN_MOMENT_RATIO";
   unit_data( 99 ).description="electron to shielded helion magn. moment ratio";
   unit_data( 99 ).value=864.058255;
   unit_data( 99 ).units="";
   unit_data( 99 ).uncertanity=0.000010;

   unit_data( 100 ).name="ELECTRON_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 100 ).description="electron to shielded proton magn. moment ratio";
   unit_data( 100 ).value=-658.2275956;
   unit_data( 100 ).units="";
   unit_data( 100 ).uncertanity=0.0000071;

   unit_data( 101 ).name="ELECTRON_VOLT";
   unit_data( 101 ).description="electron volt";
   unit_data( 101 ).value=1.60217653e-19;
   unit_data( 101 ).units="J";
   unit_data( 101 ).uncertanity=0.00000014e-19;

   unit_data( 102 ).name="ELECTRON_VOLT_ATOMIC_MASS_UNIT";
   unit_data( 102 ).description="electron volt-atomic mass unit relationship";
   unit_data( 102 ).value=1.073544171e-9;
   unit_data( 102 ).units="u";
   unit_data( 102 ).uncertanity=0.000000092e-9;

   unit_data( 103 ).name="ELECTRON_VOLT_HARTREE";
   unit_data( 103 ).description="electron volt-hartree relationship";
   unit_data( 103 ).value=3.67493245e-2;
   unit_data( 103 ).units="E_h";
   unit_data( 103 ).uncertanity=0.00000031e-2;

   unit_data( 104 ).name="ELECTRON_VOLT_HERTZ";
   unit_data( 104 ).description="electron volt-hertz relationship";
   unit_data( 104 ).value=2.41798940e14;
   unit_data( 104 ).units="Hz";
   unit_data( 104 ).uncertanity=0.00000021e14;

   unit_data( 105 ).name="ELECTRON_VOLT_INVERSE_METER";
   unit_data( 105 ).description="electron volt-inverse meter relationship";
   unit_data( 105 ).value=8.06554445e5;
   unit_data( 105 ).units="m^-1";
   unit_data( 105 ).uncertanity=0.00000069e5;

   unit_data( 106 ).name="ELECTRON_VOLT_JOULE";
   unit_data( 106 ).description="electron volt-joule relationship";
   unit_data( 106 ).value=1.60217653e-19;
   unit_data( 106 ).units="J";
   unit_data( 106 ).uncertanity=0.00000014e-19;

   unit_data( 107 ).name="ELECTRON_VOLT_KELVIN";
   unit_data( 107 ).description="electron volt-kelvin relationship";
   unit_data( 107 ).value=1.1604505e4;
   unit_data( 107 ).units="K";
   unit_data( 107 ).uncertanity=0.0000020e4;

   unit_data( 108 ).name="ELECTRON_VOLT_KILOGRAM";
   unit_data( 108 ).description="electron volt-kilogram relationship";
   unit_data( 108 ).value=1.78266181e-36;
   unit_data( 108 ).units="kg";
   unit_data( 108 ).uncertanity=0.00000015e-36;

   unit_data( 109 ).name="ELEMENTARY_CHARGE";
   unit_data( 109 ).description="elementary charge";
   unit_data( 109 ).value=1.60217653e-19;
   unit_data( 109 ).units="C";
   unit_data( 109 ).uncertanity=0.00000014e-19;

   unit_data( 110 ).name="ELEMENTARY_CHARGE_BY_H";
   unit_data( 110 ).description="elementary charge over h";
   unit_data( 110 ).value=2.41798940e14;
   unit_data( 110 ).units="A J^-1";
   unit_data( 110 ).uncertanity=0.00000021e14;

   unit_data( 111 ).name="FARADAY_CONSTANT";
   unit_data( 111 ).description="Faraday constant";
   unit_data( 111 ).value=96485.3383;
   unit_data( 111 ).units="C mol^-1";
   unit_data( 111 ).uncertanity=0.0083;

   unit_data( 112 ).name="FARADAY_CONSTANT_FOR_CONVENTIONAL_ELECTRIC_CURRENT";
   unit_data( 112 ).description="Faraday constant for conventional electric current";
   unit_data( 112 ).value=96485.336;
   unit_data( 112 ).units="C_90 mol^-1";
   unit_data( 112 ).uncertanity=0.016;

   unit_data( 113 ).name="FERMI_COUPLING_CONSTANT";
   unit_data( 113 ).description="Fermi coupling constant";
   unit_data( 113 ).value=1.16639e-5;
   unit_data( 113 ).units="GeV^-2";
   unit_data( 113 ).uncertanity=0.00001e-5;

   unit_data( 114 ).name="FINE_STRUCTURE_CONSTANT";
   unit_data( 114 ).description="fine-structure constant";
   unit_data( 114 ).value=7.297352568e-3;
   unit_data( 114 ).units="";
   unit_data( 114 ).uncertanity=0.000000024e-3;

   unit_data( 115 ).name="FIRST_RADIATION_CONSTANT";
   unit_data( 115 ).description="first radiation constant";
   unit_data( 115 ).value=3.74177138e-16;
   unit_data( 115 ).units="W m^2";
   unit_data( 115 ).uncertanity=0.00000064e-16;

   unit_data( 116 ).name="FIRST_RADIATION_CONSTANT_FOR_SPECTRAL_RADIANCE";
   unit_data( 116 ).description="first radiation constant for spectral radiance";
   unit_data( 116 ).value=1.19104282e-16;
   unit_data( 116 ).units="W m^2 sr^-1";
   unit_data( 116 ).uncertanity=0.00000020e-16;

   unit_data( 117 ).name="HARTREE_ATOMIC_MASS_UNIT";
   unit_data( 117 ).description="hartree-atomic mass unit relationship";
   unit_data( 117 ).value=2.921262323e-8;
   unit_data( 117 ).units="u";
   unit_data( 117 ).uncertanity=0.000000019e-8;

   unit_data( 118 ).name="HARTREE_ELECTRON_VOLT";
   unit_data( 118 ).description="hartree-electron volt relationship";
   unit_data( 118 ).value=27.2113845;
   unit_data( 118 ).units="eV";
   unit_data( 118 ).uncertanity=0.0000023;

   unit_data( 119 ).name="HARTREE_ENERGY";
   unit_data( 119 ).description="Hartree energy";
   unit_data( 119 ).value=4.35974417e-18;
   unit_data( 119 ).units="J";
   unit_data( 119 ).uncertanity=0.00000075e-18;

   unit_data( 120 ).name="HARTREE_ENERGY_IN_EV";
   unit_data( 120 ).description="Hartree energy in eV";
   unit_data( 120 ).value=27.2113845;
   unit_data( 120 ).units="eV";
   unit_data( 120 ).uncertanity=0.0000023;

   unit_data( 121 ).name="HARTREE_HERTZ";
   unit_data( 121 ).description="hartree-hertz relationship";
   unit_data( 121 ).value=6.579683920721e15;
   unit_data( 121 ).units="Hz";
   unit_data( 121 ).uncertanity=0.000000000044e15;

   unit_data( 122 ).name="HARTREE_INVERSE_METER";
   unit_data( 122 ).description="hartree-inverse meter relationship";
   unit_data( 122 ).value=2.194746313705e7;
   unit_data( 122 ).units="m^-1";
   unit_data( 122 ).uncertanity=0.000000000015e7;

   unit_data( 123 ).name="HARTREE_JOULE";
   unit_data( 123 ).description="hartree-joule relationship";
   unit_data( 123 ).value=4.35974417e-18;
   unit_data( 123 ).units="J";
   unit_data( 123 ).uncertanity=0.00000075e-18;

   unit_data( 124 ).name="HARTREE_KELVIN";
   unit_data( 124 ).description="hartree-kelvin relationship";
   unit_data( 124 ).value=3.1577465e5;
   unit_data( 124 ).units="K";
   unit_data( 124 ).uncertanity=0.0000055e5;

   unit_data( 125 ).name="HARTREE_KILOGRAM";
   unit_data( 125 ).description="hartree-kilogram relationship";
   unit_data( 125 ).value=4.85086960e-35;
   unit_data( 125 ).units="kg";
   unit_data( 125 ).uncertanity=0.00000083e-35;

   unit_data( 126 ).name="HELION_ELECTRON_MASS_RATIO";
   unit_data( 126 ).description="helion-electron mass ratio";
   unit_data( 126 ).value=5495.885269;
   unit_data( 126 ).units="";
   unit_data( 126 ).uncertanity=0.000011;

   unit_data( 127 ).name="HELION_MASS";
   unit_data( 127 ).description="helion mass";
   unit_data( 127 ).value=5.00641214e-27;
   unit_data( 127 ).units="kg";
   unit_data( 127 ).uncertanity=0.00000086e-27;

   unit_data( 128 ).name="HELION_MASS_ENERGY_EQUIVALENT";
   unit_data( 128 ).description="helion mass energy equivalent";
   unit_data( 128 ).value=4.49953884e-10;
   unit_data( 128 ).units="J";
   unit_data( 128 ).uncertanity=0.00000077e-10;

   unit_data( 129 ).name="HELION_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 129 ).description="helion mass energy equivalent in MeV";
   unit_data( 129 ).value=2808.39142;
   unit_data( 129 ).units="MeV";
   unit_data( 129 ).uncertanity=0.00024;

   unit_data( 130 ).name="HELION_MASS_IN_U";
   unit_data( 130 ).description="helion mass in u";
   unit_data( 130 ).value=3.0149322434;
   unit_data( 130 ).units="u";
   unit_data( 130 ).uncertanity=0.0000000058;

   unit_data( 131 ).name="HELION_MOLAR_MASS";
   unit_data( 131 ).description="helion molar mass";
   unit_data( 131 ).value=3.0149322434e-3;
   unit_data( 131 ).units="kg mol^-1";
   unit_data( 131 ).uncertanity=0.0000000058e-3;

   unit_data( 132 ).name="HELION_PROTON_MASS_RATIO";
   unit_data( 132 ).description="helion-proton mass ratio";
   unit_data( 132 ).value=2.9931526671;
   unit_data( 132 ).units="";
   unit_data( 132 ).uncertanity=0.0000000058;

   unit_data( 133 ).name="HERTZ_ATOMIC_MASS_UNIT";
   unit_data( 133 ).description="hertz-atomic mass unit relationship";
   unit_data( 133 ).value=4.439821667e-24;
   unit_data( 133 ).units="u";
   unit_data( 133 ).uncertanity=0.000000030e-24;

   unit_data( 134 ).name="HERTZ_ELECTRON_VOLT";
   unit_data( 134 ).description="hertz-electron volt relationship";
   unit_data( 134 ).value=4.13566743e-15;
   unit_data( 134 ).units="eV";
   unit_data( 134 ).uncertanity=0.00000035e-15;

   unit_data( 135 ).name="HERTZ_HARTREE";
   unit_data( 135 ).description="hertz-hartree relationship";
   unit_data( 135 ).value=1.519829846006e-16;
   unit_data( 135 ).units="E_h";
   unit_data( 135 ).uncertanity=0.000000000010e-16;

   unit_data( 136 ).name="HERTZ_INVERSE_METER";
   unit_data( 136 ).description="hertz-inverse meter relationship";
   unit_data( 136 ).value=3.335640951e-9;
   unit_data( 136 ).units="m^-1";
   unit_data( 136 ).uncertanity=0.0;

   unit_data( 137 ).name="HERTZ_JOULE";
   unit_data( 137 ).description="hertz-joule relationship";
   unit_data( 137 ).value=6.6260693e-34;
   unit_data( 137 ).units="J";
   unit_data( 137 ).uncertanity=0.0000011e-34;

   unit_data( 138 ).name="HERTZ_KELVIN";
   unit_data( 138 ).description="hertz-kelvin relationship";
   unit_data( 138 ).value=4.7992374e-11;
   unit_data( 138 ).units="K";
   unit_data( 138 ).uncertanity=0.0000084e-11;

   unit_data( 139 ).name="HERTZ_KILOGRAM";
   unit_data( 139 ).description="hertz-kilogram relationship";
   unit_data( 139 ).value=7.3724964e-51;
   unit_data( 139 ).units="kg";
   unit_data( 139 ).uncertanity=0.0000013e-51;

   unit_data( 140 ).name="INVERSE_FINE_STRUCTURE_CONSTANT";
   unit_data( 140 ).description="inverse fine-structure constant";
   unit_data( 140 ).value=137.03599911;
   unit_data( 140 ).units="";
   unit_data( 140 ).uncertanity=0.00000046;

   unit_data( 141 ).name="INVERSE_METER_ATOMIC_MASS_UNIT";
   unit_data( 141 ).description="inverse meter-atomic mass unit relationship";
   unit_data( 141 ).value=1.3310250506e-15;
   unit_data( 141 ).units="u";
   unit_data( 141 ).uncertanity=0.0000000089e-15;

   unit_data( 142 ).name="INVERSE_METER_ELECTRON_VOLT";
   unit_data( 142 ).description="inverse meter-electron volt relationship";
   unit_data( 142 ).value=1.23984191e-6;
   unit_data( 142 ).units="eV";
   unit_data( 142 ).uncertanity=0.00000011e-6;

   unit_data( 143 ).name="INVERSE_METER_HARTREE";
   unit_data( 143 ).description="inverse meter-hartree relationship";
   unit_data( 143 ).value=4.556335252760e-8;
   unit_data( 143 ).units="E_h";
   unit_data( 143 ).uncertanity=0.000000000030e-8;

   unit_data( 144 ).name="INVERSE_METER_HERTZ";
   unit_data( 144 ).description="inverse meter-hertz relationship";
   unit_data( 144 ).value=299792458;
   unit_data( 144 ).units="Hz";
   unit_data( 144 ).uncertanity=0.0;

   unit_data( 145 ).name="INVERSE_METER_JOULE";
   unit_data( 145 ).description="inverse meter-joule relationship";
   unit_data( 145 ).value=1.98644561e-25;
   unit_data( 145 ).units="J";
   unit_data( 145 ).uncertanity=0.00000034e-25;

   unit_data( 146 ).name="INVERSE_METER_KELVIN";
   unit_data( 146 ).description="inverse meter-kelvin relationship";
   unit_data( 146 ).value=1.4387752e-2;
   unit_data( 146 ).units="K";
   unit_data( 146 ).uncertanity=0.0000025e-2;

   unit_data( 147 ).name="INVERSE_METER_KILOGRAM";
   unit_data( 147 ).description="inverse meter-kilogram relationship";
   unit_data( 147 ).value=2.21021881e-42;
   unit_data( 147 ).units="kg";
   unit_data( 147 ).uncertanity=0.00000038e-42;

   unit_data( 148 ).name="INVERSE_OF_CONDUCTANCE_QUANTUM";
   unit_data( 148 ).description="inverse of conductance quantum";
   unit_data( 148 ).value=12906.403725;
   unit_data( 148 ).units="ohm";
   unit_data( 148 ).uncertanity=0.000043;

   unit_data( 149 ).name="JOSEPHSON_CONSTANT";
   unit_data( 149 ).description="Josephson constant";
   unit_data( 149 ).value=483597.879e9;
   unit_data( 149 ).units="Hz V^-1";
   unit_data( 149 ).uncertanity=0.041e9;

   unit_data( 150 ).name="JOULE_ATOMIC_MASS_UNIT";
   unit_data( 150 ).description="joule-atomic mass unit relationship";
   unit_data( 150 ).value=6.7005361e9;
   unit_data( 150 ).units="u";
   unit_data( 150 ).uncertanity=0.0000011e9;

   unit_data( 151 ).name="JOULE_ELECTRON_VOLT";
   unit_data( 151 ).description="joule-electron volt relationship";
   unit_data( 151 ).value=6.24150947e18;
   unit_data( 151 ).units="eV";
   unit_data( 151 ).uncertanity=0.00000053e18;

   unit_data( 152 ).name="JOULE_HARTREE";
   unit_data( 152 ).description="joule-hartree relationship";
   unit_data( 152 ).value=2.29371257e17;
   unit_data( 152 ).units="E_h";
   unit_data( 152 ).uncertanity=0.00000039e17;

   unit_data( 153 ).name="JOULE_HERTZ";
   unit_data( 153 ).description="joule-hertz relationship";
   unit_data( 153 ).value=1.50919037e33;
   unit_data( 153 ).units="Hz";
   unit_data( 153 ).uncertanity=0.00000026e33;

   unit_data( 154 ).name="JOULE_INVERSE_METER";
   unit_data( 154 ).description="joule-inverse meter relationship";
   unit_data( 154 ).value=5.03411720e24;
   unit_data( 154 ).units="m^-1";
   unit_data( 154 ).uncertanity=0.00000086e24;

   unit_data( 155 ).name="JOULE_KELVIN";
   unit_data( 155 ).description="joule-kelvin relationship";
   unit_data( 155 ).value=7.242963e22;
   unit_data( 155 ).units="K";
   unit_data( 155 ).uncertanity=0.000013e22;

   unit_data( 156 ).name="JOULE_KILOGRAM";
   unit_data( 156 ).description="joule-kilogram relationship";
   unit_data( 156 ).value=1.112650056e-17;
   unit_data( 156 ).units="kg";
   unit_data( 156 ).uncertanity=0.0;

   unit_data( 157 ).name="KELVIN_ATOMIC_MASS_UNIT";
   unit_data( 157 ).description="kelvin-atomic mass unit relationship";
   unit_data( 157 ).value=9.251098e-14;
   unit_data( 157 ).units="u";
   unit_data( 157 ).uncertanity=0.000016e-14;

   unit_data( 158 ).name="KELVIN_ELECTRON_VOLT";
   unit_data( 158 ).description="kelvin-electron volt relationship";
   unit_data( 158 ).value=8.617343e-5;
   unit_data( 158 ).units="eV";
   unit_data( 158 ).uncertanity=0.000015e-5;

   unit_data( 159 ).name="KELVIN_HARTREE";
   unit_data( 159 ).description="kelvin-hartree relationship";
   unit_data( 159 ).value=3.1668153e-6;
   unit_data( 159 ).units="E_h";
   unit_data( 159 ).uncertanity=0.0000055e-6;

   unit_data( 160 ).name="KELVIN_HERTZ";
   unit_data( 160 ).description="kelvin-hertz relationship";
   unit_data( 160 ).value=2.0836644e10;
   unit_data( 160 ).units="Hz";
   unit_data( 160 ).uncertanity=0.0000036e10;

   unit_data( 161 ).name="KELVIN_INVERSE_METER";
   unit_data( 161 ).description="kelvin-inverse meter relationship";
   unit_data( 161 ).value=69.50356;
   unit_data( 161 ).units="m^-1";
   unit_data( 161 ).uncertanity=0.00012;

   unit_data( 162 ).name="KELVIN_JOULE";
   unit_data( 162 ).description="kelvin-joule relationship";
   unit_data( 162 ).value=1.3806505e-23;
   unit_data( 162 ).units="J";
   unit_data( 162 ).uncertanity=0.0000024e-23;

   unit_data( 163 ).name="KELVIN_KILOGRAM";
   unit_data( 163 ).description="kelvin-kilogram relationship";
   unit_data( 163 ).value=1.5361808e-40;
   unit_data( 163 ).units="kg";
   unit_data( 163 ).uncertanity=0.0000027e-40;

   unit_data( 164 ).name="KILOGRAM_ATOMIC_MASS_UNIT";
   unit_data( 164 ).description="kilogram-atomic mass unit relationship";
   unit_data( 164 ).value=6.0221415e26;
   unit_data( 164 ).units="u";
   unit_data( 164 ).uncertanity=0.0000010e26;

   unit_data( 165 ).name="KILOGRAM_ELECTRON_VOLT";
   unit_data( 165 ).description="kilogram-electron volt relationship";
   unit_data( 165 ).value=5.60958896e35;
   unit_data( 165 ).units="eV";
   unit_data( 165 ).uncertanity=0.00000048e35;

   unit_data( 166 ).name="KILOGRAM_HARTREE";
   unit_data( 166 ).description="kilogram-hartree relationship";
   unit_data( 166 ).value=2.06148605e34;
   unit_data( 166 ).units="E_h";
   unit_data( 166 ).uncertanity=0.00000035e34;

   unit_data( 167 ).name="KILOGRAM_HERTZ";
   unit_data( 167 ).description="kilogram-hertz relationship";
   unit_data( 167 ).value=1.35639266e50;
   unit_data( 167 ).units="Hz";
   unit_data( 167 ).uncertanity=0.00000023e50;

   unit_data( 168 ).name="KILOGRAM_INVERSE_METER";
   unit_data( 168 ).description="kilogram-inverse meter relationship";
   unit_data( 168 ).value=4.52443891e41;
   unit_data( 168 ).units="m^-1";
   unit_data( 168 ).uncertanity=0.00000077e41;

   unit_data( 169 ).name="KILOGRAM_JOULE";
   unit_data( 169 ).description="kilogram-joule relationship";
   unit_data( 169 ).value=8.987551787e16;
   unit_data( 169 ).units="J";
   unit_data( 169 ).uncertanity=0.0;

   unit_data( 170 ).name="KILOGRAM_KELVIN";
   unit_data( 170 ).description="kilogram-kelvin relationship";
   unit_data( 170 ).value=6.509650e39;
   unit_data( 170 ).units="K";
   unit_data( 170 ).uncertanity=0.000011e39;

   unit_data( 171 ).name="LATTICE_PARAMETER_OF_SILICON";
   unit_data( 171 ).description="lattice parameter of silicon";
   unit_data( 171 ).value=543.102122e-12;
   unit_data( 171 ).units="m";
   unit_data( 171 ).uncertanity=0.000020e-12;

   unit_data( 172 ).name="LATTICE_SPACING_OF_SILICON";
   unit_data( 172 ).description="{220} lattice spacing of silicon";
   unit_data( 172 ).value=192.0155965e-12;
   unit_data( 172 ).units="m";
   unit_data( 172 ).uncertanity=0.0000070e-12;

   unit_data( 173 ).name="LOSCHMIDT_CONSTANT";
   unit_data( 173 ).description="Loschmidt constant (273.15 K, 101.325 kPa)";
   unit_data( 173 ).value=2.6867773e25;
   unit_data( 173 ).units="m^-3";
   unit_data( 173 ).uncertanity=0.0000047e25;

   unit_data( 174 ).name="MAGN_CONSTANT";
   unit_data( 174 ).description="magn. constant";
   unit_data( 174 ).value=12.566370614e-7;
   unit_data( 174 ).units="N A^-2";
   unit_data( 174 ).uncertanity=0.0;

   unit_data( 175 ).name="MAGN_FLUX_QUANTUM";
   unit_data( 175 ).description="magn. flux quantum";
   unit_data( 175 ).value=2.06783372e-15;
   unit_data( 175 ).units="Wb";
   unit_data( 175 ).uncertanity=0.00000018e-15;

   unit_data( 176 ).name="MOLAR_GAS_CONSTANT";
   unit_data( 176 ).description="molar gas constant";
   unit_data( 176 ).value=8.314472;
   unit_data( 176 ).units="J mol^-1 K^-1";
   unit_data( 176 ).uncertanity=0.000015;

   unit_data( 177 ).name="MOLAR_MASS_CONSTANT";
   unit_data( 177 ).description="molar mass constant";
   unit_data( 177 ).value=1e-3;
   unit_data( 177 ).units="kg mol^-1";
   unit_data( 177 ).uncertanity=0.0;

   unit_data( 178 ).name="MOLAR_MASS_OF_CARBON_12";
   unit_data( 178 ).description="molar mass of carbon-12";
   unit_data( 178 ).value=12e-3;
   unit_data( 178 ).units="kg mol^-1";
   unit_data( 178 ).uncertanity=0.0;

   unit_data( 179 ).name="MOLAR_PLANCK_CONSTANT";
   unit_data( 179 ).description="molar Planck constant";
   unit_data( 179 ).value=3.990312716e-10;
   unit_data( 179 ).units="J s mol^-1";
   unit_data( 179 ).uncertanity=0.000000027e-10;

   unit_data( 180 ).name="MOLAR_PLANCK_CONSTANT_TIMES_C";
   unit_data( 180 ).description="molar Planck constant times c";
   unit_data( 180 ).value=0.11962656572;
   unit_data( 180 ).units="J m mol^-1";
   unit_data( 180 ).uncertanity=0.00000000080;

   unit_data( 181 ).name="MOLAR_VOLUME_OF_IDEAL_GAS";
   unit_data( 181 ).description="molar volume of ideal gas (273.15 K, 100 kPa)";
   unit_data( 181 ).value=22.710981e-3;
   unit_data( 181 ).units="m^3 mol^-1";
   unit_data( 181 ).uncertanity=0.000040e-3;

   unit_data( 182 ).name="MOLAR_VOLUME_OF_SILICON";
   unit_data( 182 ).description="molar volume of silicon";
   unit_data( 182 ).value=12.0588382e-6;
   unit_data( 182 ).units="m^3 mol^-1";
   unit_data( 182 ).uncertanity=0.0000024e-6;

   unit_data( 183 ).name="MO_X_UNIT";
   unit_data( 183 ).description="Mo x unit";
   unit_data( 183 ).value=1.00209966e-13;
   unit_data( 183 ).units="m";
   unit_data( 183 ).uncertanity=0.00000053e-13;

   unit_data( 184 ).name="MUON_COMPTON_WAVELENGTH";
   unit_data( 184 ).description="muon Compton wavelength";
   unit_data( 184 ).value=11.73444105e-15;
   unit_data( 184 ).units="m";
   unit_data( 184 ).uncertanity=0.00000030e-15;

   unit_data( 185 ).name="MUON_COMPTON_WAVELENGTH_BY_2_PI";
   unit_data( 185 ).description="muon Compton wavelength over 2 pi";
   unit_data( 185 ).value=1.867594298e-15;
   unit_data( 185 ).units="m";
   unit_data( 185 ).uncertanity=0.000000047e-15;

   unit_data( 186 ).name="MUON_ELECTRON_MASS_RATIO";
   unit_data( 186 ).description="muon-electron mass ratio";
   unit_data( 186 ).value=206.7682838;
   unit_data( 186 ).units="";
   unit_data( 186 ).uncertanity=0.0000054;

   unit_data( 187 ).name="MUON_G_FACTOR";
   unit_data( 187 ).description="muon g factor";
   unit_data( 187 ).value=-2.0023318396;
   unit_data( 187 ).units="";
   unit_data( 187 ).uncertanity=0.0000000012;

   unit_data( 188 ).name="MUON_MAGN_MOMENT";
   unit_data( 188 ).description="muon magn. moment";
   unit_data( 188 ).value=-4.49044799e-26;
   unit_data( 188 ).units="J T^-1";
   unit_data( 188 ).uncertanity=0.00000040e-26;

   unit_data( 189 ).name="MUON_MAGN_MOMENT_ANOMALY";
   unit_data( 189 ).description="muon magn. moment anomaly";
   unit_data( 189 ).value=1.16591981e-3;
   unit_data( 189 ).units="";
   unit_data( 189 ).uncertanity=0.00000062e-3;

   unit_data( 190 ).name="MUON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 190 ).description="muon magn. moment to Bohr magneton ratio";
   unit_data( 190 ).value=-4.84197045e-3;
   unit_data( 190 ).units="";
   unit_data( 190 ).uncertanity=0.00000013e-3;

   unit_data( 191 ).name="MUON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 191 ).description="muon magn. moment to nuclear magneton ratio";
   unit_data( 191 ).value=-8.89059698;
   unit_data( 191 ).units="";
   unit_data( 191 ).uncertanity=0.00000023;

   unit_data( 192 ).name="MUON_MASS";
   unit_data( 192 ).description="muon mass";
   unit_data( 192 ).value=1.88353140e-28;
   unit_data( 192 ).units="kg";
   unit_data( 192 ).uncertanity=0.00000033e-28;

   unit_data( 193 ).name="MUON_MASS_ENERGY_EQUIVALENT";
   unit_data( 193 ).description="muon mass energy equivalent";
   unit_data( 193 ).value=1.69283360e-11;
   unit_data( 193 ).units="J";
   unit_data( 193 ).uncertanity=0.00000029e-11;

   unit_data( 194 ).name="MUON_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 194 ).description="muon mass energy equivalent in MeV";
   unit_data( 194 ).value=105.6583692;
   unit_data( 194 ).units="MeV";
   unit_data( 194 ).uncertanity=0.0000094;

   unit_data( 195 ).name="MUON_MASS_IN_U";
   unit_data( 195 ).description="muon mass in u";
   unit_data( 195 ).value=0.1134289264;
   unit_data( 195 ).units="u";
   unit_data( 195 ).uncertanity=0.0000000030;

   unit_data( 196 ).name="MUON_MOLAR_MASS";
   unit_data( 196 ).description="muon molar mass";
   unit_data( 196 ).value=0.1134289264e-3;
   unit_data( 196 ).units="kg mol^-1";
   unit_data( 196 ).uncertanity=0.0000000030e-3;

   unit_data( 197 ).name="MUON_NEUTRON_MASS_RATIO";
   unit_data( 197 ).description="muon-neutron mass ratio";
   unit_data( 197 ).value=0.1124545175;
   unit_data( 197 ).units="";
   unit_data( 197 ).uncertanity=0.0000000029;

   unit_data( 198 ).name="MUON_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 198 ).description="muon-proton magn. moment ratio";
   unit_data( 198 ).value=-3.183345118;
   unit_data( 198 ).units="";
   unit_data( 198 ).uncertanity=0.000000089;

   unit_data( 199 ).name="MUON_PROTON_MASS_RATIO";
   unit_data( 199 ).description="muon-proton mass ratio";
   unit_data( 199 ).value=0.1126095269;
   unit_data( 199 ).units="";
   unit_data( 199 ).uncertanity=0.0000000029;

   unit_data( 200 ).name="MUON_TAU_MASS_RATIO";
   unit_data( 200 ).description="muon-tau mass ratio";
   unit_data( 200 ).value=5.94592e-2;
   unit_data( 200 ).units="";
   unit_data( 200 ).uncertanity=0.00097e-2;

   unit_data( 201 ).name="NATURAL_UNIT_OF_ACTION";
   unit_data( 201 ).description="natural unit of action";
   unit_data( 201 ).value=1.05457168e-34;
   unit_data( 201 ).units="J s";
   unit_data( 201 ).uncertanity=0.00000018e-34;

   unit_data( 202 ).name="NATURAL_UNIT_OF_ACTION_IN_EV_S";
   unit_data( 202 ).description="natural unit of action in eV s";
   unit_data( 202 ).value=6.58211915e-16;
   unit_data( 202 ).units="eV s";
   unit_data( 202 ).uncertanity=0.00000056e-16;

   unit_data( 203 ).name="NATURAL_UNIT_OF_ENERGY";
   unit_data( 203 ).description="natural unit of energy";
   unit_data( 203 ).value=8.1871047e-14;
   unit_data( 203 ).units="J";
   unit_data( 203 ).uncertanity=0.0000014e-14;

   unit_data( 204 ).name="NATURAL_UNIT_OF_ENERGY_IN_MEV";
   unit_data( 204 ).description="natural unit of energy in MeV";
   unit_data( 204 ).value=0.510998918;
   unit_data( 204 ).units="MeV";
   unit_data( 204 ).uncertanity=0.000000044;

   unit_data( 205 ).name="NATURAL_UNIT_OF_LENGTH";
   unit_data( 205 ).description="natural unit of length";
   unit_data( 205 ).value=386.1592678e-15;
   unit_data( 205 ).units="m";
   unit_data( 205 ).uncertanity=0.0000026e-15;

   unit_data( 206 ).name="NATURAL_UNIT_OF_MASS";
   unit_data( 206 ).description="natural unit of mass";
   unit_data( 206 ).value=9.1093826e-31;
   unit_data( 206 ).units="kg";
   unit_data( 206 ).uncertanity=0.0000016e-31;

   unit_data( 207 ).name="NATURAL_UNIT_OF_MOMENTUM";
   unit_data( 207 ).description="natural unit of momentum";
   unit_data( 207 ).value=2.73092419e-22;
   unit_data( 207 ).units="kg m s^-1";
   unit_data( 207 ).uncertanity=0.00000047e-22;

   unit_data( 208 ).name="NATURAL_UNIT_OF_MOMENTUM_IN_MEV_PER_C";
   unit_data( 208 ).description="natural unit of momentum in MeV/c";
   unit_data( 208 ).value=0.510998918;
   unit_data( 208 ).units="MeV/c";
   unit_data( 208 ).uncertanity=0.000000044;

   unit_data( 209 ).name="NATURAL_UNIT_OF_TIME";
   unit_data( 209 ).description="natural unit of time";
   unit_data( 209 ).value=1.2880886677e-21;
   unit_data( 209 ).units="s";
   unit_data( 209 ).uncertanity=0.0000000086e-21;

   unit_data( 210 ).name="NATURAL_UNIT_OF_VELOCITY";
   unit_data( 210 ).description="natural unit of velocity";
   unit_data( 210 ).value=299792458;
   unit_data( 210 ).units="m s^-1";
   unit_data( 210 ).uncertanity=0.0;

   unit_data( 211 ).name="NEUTRON_COMPTON_WAVELENGTH";
   unit_data( 211 ).description="neutron Compton wavelength";
   unit_data( 211 ).value=1.3195909067e-15;
   unit_data( 211 ).units="m";
   unit_data( 211 ).uncertanity=0.0000000088e-15;

   unit_data( 212 ).name="NEUTRON_COMPTON_WAVELENGTH_BY_2_PI";
   unit_data( 212 ).description="neutron Compton wavelength over 2 pi";
   unit_data( 212 ).value=0.2100194157e-15;
   unit_data( 212 ).units="m";
   unit_data( 212 ).uncertanity=0.0000000014e-15;

   unit_data( 213 ).name="NEUTRON_ELECTRON_MAGN_MOMENT_RATIO";
   unit_data( 213 ).description="neutron-electron magn. moment ratio";
   unit_data( 213 ).value=1.04066882e-3;
   unit_data( 213 ).units="";
   unit_data( 213 ).uncertanity=0.00000025e-3;

   unit_data( 214 ).name="NEUTRON_ELECTRON_MASS_RATIO";
   unit_data( 214 ).description="neutron-electron mass ratio";
   unit_data( 214 ).value=1838.6836598;
   unit_data( 214 ).units="";
   unit_data( 214 ).uncertanity=0.0000013;

   unit_data( 215 ).name="NEUTRON_GYROMAGN_RATIO";
   unit_data( 215 ).description="neutron gyromagn. ratio";
   unit_data( 215 ).value=1.83247183e8;
   unit_data( 215 ).units="s^-1 T^-1";
   unit_data( 215 ).uncertanity=0.00000046e8;

   unit_data( 216 ).name="NEUTRON_GYROMAGN_RATIO_BY_2_PI";
   unit_data( 216 ).description="neutron gyromagn. ratio over 2 pi";
   unit_data( 216 ).value=29.1646950;
   unit_data( 216 ).units="MHz T^-1";
   unit_data( 216 ).uncertanity=0.0000073;

   unit_data( 217 ).name="NEUTRON_G_FACTOR";
   unit_data( 217 ).description="neutron g factor";
   unit_data( 217 ).value=-3.82608546;
   unit_data( 217 ).units="";
   unit_data( 217 ).uncertanity=0.00000090;

   unit_data( 218 ).name="NEUTRON_MAGN_MOMENT";
   unit_data( 218 ).description="neutron magn. moment";
   unit_data( 218 ).value=-0.96623645e-26;
   unit_data( 218 ).units="J T^-1";
   unit_data( 218 ).uncertanity=0.00000024e-26;

   unit_data( 219 ).name="NEUTRON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 219 ).description="neutron magn. moment to Bohr magneton ratio";
   unit_data( 219 ).value=-1.04187563e-3;
   unit_data( 219 ).units="";
   unit_data( 219 ).uncertanity=0.00000025e-3;

   unit_data( 220 ).name="NEUTRON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 220 ).description="neutron magn. moment to nuclear magneton ratio";
   unit_data( 220 ).value=-1.91304273;
   unit_data( 220 ).units="";
   unit_data( 220 ).uncertanity=0.00000045;

   unit_data( 221 ).name="NEUTRON_MASS";
   unit_data( 221 ).description="neutron mass";
   unit_data( 221 ).value=1.67492728e-27;
   unit_data( 221 ).units="kg";
   unit_data( 221 ).uncertanity=0.00000029e-27;

   unit_data( 222 ).name="NEUTRON_MASS_ENERGY_EQUIVALENT";
   unit_data( 222 ).description="neutron mass energy equivalent";
   unit_data( 222 ).value=1.50534957e-10;
   unit_data( 222 ).units="J";
   unit_data( 222 ).uncertanity=0.00000026e-10;

   unit_data( 223 ).name="NEUTRON_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 223 ).description="neutron mass energy equivalent in MeV";
   unit_data( 223 ).value=939.565360;
   unit_data( 223 ).units="MeV";
   unit_data( 223 ).uncertanity=0.000081;

   unit_data( 224 ).name="NEUTRON_MASS_IN_U";
   unit_data( 224 ).description="neutron mass in u";
   unit_data( 224 ).value=1.00866491560;
   unit_data( 224 ).units="u";
   unit_data( 224 ).uncertanity=0.00000000055;

   unit_data( 225 ).name="NEUTRON_MOLAR_MASS";
   unit_data( 225 ).description="neutron molar mass";
   unit_data( 225 ).value=1.00866491560e-3;
   unit_data( 225 ).units="kg mol^-1";
   unit_data( 225 ).uncertanity=0.00000000055e-3;

   unit_data( 226 ).name="NEUTRON_MUON_MASS_RATIO";
   unit_data( 226 ).description="neutron-muon mass ratio";
   unit_data( 226 ).value=8.89248402;
   unit_data( 226 ).units="";
   unit_data( 226 ).uncertanity=0.00000023;

   unit_data( 227 ).name="NEUTRON_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 227 ).description="neutron-proton magn. moment ratio";
   unit_data( 227 ).value=-0.68497934;
   unit_data( 227 ).units="";
   unit_data( 227 ).uncertanity=0.00000016;

   unit_data( 228 ).name="NEUTRON_PROTON_MASS_RATIO";
   unit_data( 228 ).description="neutron-proton mass ratio";
   unit_data( 228 ).value=1.00137841870;
   unit_data( 228 ).units="";
   unit_data( 228 ).uncertanity=0.00000000058;

   unit_data( 229 ).name="NEUTRON_TAU_MASS_RATIO";
   unit_data( 229 ).description="neutron-tau mass ratio";
   unit_data( 229 ).value=0.528740;
   unit_data( 229 ).units="";
   unit_data( 229 ).uncertanity=0.000086;

   unit_data( 230 ).name="NEUTRON_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 230 ).description="neutron to shielded proton magn. moment ratio";
   unit_data( 230 ).value=-0.68499694;
   unit_data( 230 ).units="";
   unit_data( 230 ).uncertanity=0.00000016;

   unit_data( 231 ).name="NEWTONIAN_CONSTANT_OF_GRAVITATION";
   unit_data( 231 ).description="Newtonian constant of gravitation";
   unit_data( 231 ).value=6.6742e-11;
   unit_data( 231 ).units="m^3 kg^-1 s^-2";
   unit_data( 231 ).uncertanity=0.0010e-11;

   unit_data( 232 ).name="NEWTONIAN_CONSTANT_OF_GRAVITATION_BY_H_BAR_C";
   unit_data( 232 ).description="Newtonian constant of gravitation over h-bar c";
   unit_data( 232 ).value=6.7087e-39;
   unit_data( 232 ).units="(GeV/c^2)^-2";
   unit_data( 232 ).uncertanity=0.0010e-39;

   unit_data( 233 ).name="NUCLEAR_MAGNETON";
   unit_data( 233 ).description="nuclear magneton";
   unit_data( 233 ).value=5.05078343e-27;
   unit_data( 233 ).units="J T^-1";
   unit_data( 233 ).uncertanity=0.00000043e-27;

   unit_data( 234 ).name="NUCLEAR_MAGNETON_IN_EV_PER_T";
   unit_data( 234 ).description="nuclear magneton in eV/T";
   unit_data( 234 ).value=3.152451259e-8;
   unit_data( 234 ).units="eV T^-1";
   unit_data( 234 ).uncertanity=0.000000021e-8;

   unit_data( 235 ).name="NUCLEAR_MAGNETON_IN_INVERSE_METERS_PER_TESLA";
   unit_data( 235 ).description="nuclear magneton in inverse meters per tesla";
   unit_data( 235 ).value=2.54262358e-2;
   unit_data( 235 ).units="m^-1 T^-1";
   unit_data( 235 ).uncertanity=0.00000022e-2;

   unit_data( 236 ).name="NUCLEAR_MAGNETON_IN_K_PER_T";
   unit_data( 236 ).description="nuclear magneton in K/T";
   unit_data( 236 ).value=3.6582637e-4;
   unit_data( 236 ).units="K T^-1";
   unit_data( 236 ).uncertanity=0.0000064e-4;

   unit_data( 237 ).name="NUCLEAR_MAGNETON_IN_MHZ_PER_T";
   unit_data( 237 ).description="nuclear magneton in MHz/T";
   unit_data( 237 ).value=7.62259371;
   unit_data( 237 ).units="MHz T^-1";
   unit_data( 237 ).uncertanity=0.00000065;

   unit_data( 238 ).name="PLANCK_CONSTANT";
   unit_data( 238 ).description="Planck constant";
   unit_data( 238 ).value=6.6260693e-34;
   unit_data( 238 ).units="J s";
   unit_data( 238 ).uncertanity=0.0000011e-34;

   unit_data( 239 ).name="PLANCK_CONSTANT_BY_2_PI";
   unit_data( 239 ).description="Planck constant over 2 pi";
   unit_data( 239 ).value=1.05457168e-34;
   unit_data( 239 ).units="J s";
   unit_data( 239 ).uncertanity=0.00000018e-34;

   unit_data( 240 ).name="PLANCK_CONSTANT_BY_2_PI_IN_EV_S";
   unit_data( 240 ).description="Planck constant over 2 pi in eV s";
   unit_data( 240 ).value=6.58211915e-16;
   unit_data( 240 ).units="eV s";
   unit_data( 240 ).uncertanity=0.00000056e-16;

   unit_data( 241 ).name="PLANCK_CONSTANT_BY_2_PI_TIMES_C_IN_MEV_FM";
   unit_data( 241 ).description="Planck constant over 2 pi times c in MeV fm";
   unit_data( 241 ).value=197.326968;
   unit_data( 241 ).units="MeV fm";
   unit_data( 241 ).uncertanity=0.000017;

   unit_data( 242 ).name="PLANCK_CONSTANT_IN_EV_S";
   unit_data( 242 ).description="Planck constant in eV s";
   unit_data( 242 ).value=4.13566743e-15;
   unit_data( 242 ).units="eV s";
   unit_data( 242 ).uncertanity=0.00000035e-15;

   unit_data( 243 ).name="PLANCK_LENGTH";
   unit_data( 243 ).description="Planck length";
   unit_data( 243 ).value=1.61624e-35;
   unit_data( 243 ).units="m";
   unit_data( 243 ).uncertanity=0.00012e-35;

   unit_data( 244 ).name="PLANCK_MASS";
   unit_data( 244 ).description="Planck mass";
   unit_data( 244 ).value=2.17645e-8;
   unit_data( 244 ).units="kg";
   unit_data( 244 ).uncertanity=0.00016e-8;

   unit_data( 245 ).name="PLANCK_TEMPERATURE";
   unit_data( 245 ).description="Planck temperature";
   unit_data( 245 ).value=1.41679e32;
   unit_data( 245 ).units="K";
   unit_data( 245 ).uncertanity=0.00011e32;

   unit_data( 246 ).name="PLANCK_TIME";
   unit_data( 246 ).description="Planck time";
   unit_data( 246 ).value=5.39121e-44;
   unit_data( 246 ).units="s";
   unit_data( 246 ).uncertanity=0.00040e-44;

   unit_data( 247 ).name="PROTON_CHARGE_TO_MASS_QUOTIENT";
   unit_data( 247 ).description="proton charge to mass quotient";
   unit_data( 247 ).value=9.57883376e7;
   unit_data( 247 ).units="C kg^-1";
   unit_data( 247 ).uncertanity=0.00000082e7;

   unit_data( 248 ).name="PROTON_COMPTON_WAVELENGTH";
   unit_data( 248 ).description="proton Compton wavelength";
   unit_data( 248 ).value=1.3214098555e-15;
   unit_data( 248 ).units="m";
   unit_data( 248 ).uncertanity=0.0000000088e-15;

   unit_data( 249 ).name="PROTON_COMPTON_WAVELENGTH_BY_2_PI";
   unit_data( 249 ).description="proton Compton wavelength over 2 pi";
   unit_data( 249 ).value=0.2103089104e-15;
   unit_data( 249 ).units="m";
   unit_data( 249 ).uncertanity=0.0000000014e-15;

   unit_data( 250 ).name="PROTON_ELECTRON_MASS_RATIO";
   unit_data( 250 ).description="proton-electron mass ratio";
   unit_data( 250 ).value=1836.15267261;
   unit_data( 250 ).units="";
   unit_data( 250 ).uncertanity=0.00000085;

   unit_data( 251 ).name="PROTON_GYROMAGN_RATIO";
   unit_data( 251 ).description="proton gyromagn. ratio";
   unit_data( 251 ).value=2.67522205e8;
   unit_data( 251 ).units="s^-1 T^-1";
   unit_data( 251 ).uncertanity=0.00000023e8;

   unit_data( 252 ).name="PROTON_GYROMAGN_RATIO_BY_2_PI";
   unit_data( 252 ).description="proton gyromagn. ratio over 2 pi";
   unit_data( 252 ).value=42.5774813;
   unit_data( 252 ).units="MHz T^-1";
   unit_data( 252 ).uncertanity=0.0000037;

   unit_data( 253 ).name="PROTON_G_FACTOR";
   unit_data( 253 ).description="proton g factor";
   unit_data( 253 ).value=5.585694701;
   unit_data( 253 ).units="";
   unit_data( 253 ).uncertanity=0.000000056;

   unit_data( 254 ).name="PROTON_MAGN_MOMENT";
   unit_data( 254 ).description="proton magn. moment";
   unit_data( 254 ).value=1.41060671e-26;
   unit_data( 254 ).units="J T^-1";
   unit_data( 254 ).uncertanity=0.00000012e-26;

   unit_data( 255 ).name="PROTON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 255 ).description="proton magn. moment to Bohr magneton ratio";
   unit_data( 255 ).value=1.521032206e-3;
   unit_data( 255 ).units="";
   unit_data( 255 ).uncertanity=0.000000015e-3;

   unit_data( 256 ).name="PROTON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 256 ).description="proton magn. moment to nuclear magneton ratio";
   unit_data( 256 ).value=2.792847351;
   unit_data( 256 ).units="";
   unit_data( 256 ).uncertanity=0.000000028;

   unit_data( 257 ).name="PROTON_MAGN_SHIELDING_CORRECTION";
   unit_data( 257 ).description="proton magn. shielding correction";
   unit_data( 257 ).value=25.689e-6;
   unit_data( 257 ).units="";
   unit_data( 257 ).uncertanity=0.015e-6;

   unit_data( 258 ).name="PROTON_MASS";
   unit_data( 258 ).description="proton mass";
   unit_data( 258 ).value=1.67262171e-27;
   unit_data( 258 ).units="kg";
   unit_data( 258 ).uncertanity=0.00000029e-27;

   unit_data( 259 ).name="PROTON_MASS_ENERGY_EQUIVALENT";
   unit_data( 259 ).description="proton mass energy equivalent";
   unit_data( 259 ).value=1.50327743e-10;
   unit_data( 259 ).units="J";
   unit_data( 259 ).uncertanity=0.00000026e-10;

   unit_data( 260 ).name="PROTON_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 260 ).description="proton mass energy equivalent in MeV";
   unit_data( 260 ).value=938.272029;
   unit_data( 260 ).units="MeV";
   unit_data( 260 ).uncertanity=0.000080;

   unit_data( 261 ).name="PROTON_MASS_IN_U";
   unit_data( 261 ).description="proton mass in u";
   unit_data( 261 ).value=1.00727646688;
   unit_data( 261 ).units="u";
   unit_data( 261 ).uncertanity=0.00000000013;

   unit_data( 262 ).name="PROTON_MOLAR_MASS";
   unit_data( 262 ).description="proton molar mass";
   unit_data( 262 ).value=1.00727646688e-3;
   unit_data( 262 ).units="kg mol^-1";
   unit_data( 262 ).uncertanity=0.00000000013e-3;

   unit_data( 263 ).name="PROTON_MUON_MASS_RATIO";
   unit_data( 263 ).description="proton-muon mass ratio";
   unit_data( 263 ).value=8.88024333;
   unit_data( 263 ).units="";
   unit_data( 263 ).uncertanity=0.00000023;

   unit_data( 264 ).name="PROTON_NEUTRON_MAGN_MOMENT_RATIO";
   unit_data( 264 ).description="proton-neutron magn. moment ratio";
   unit_data( 264 ).value=-1.45989805;
   unit_data( 264 ).units="";
   unit_data( 264 ).uncertanity=0.00000034;

   unit_data( 265 ).name="PROTON_NEUTRON_MASS_RATIO";
   unit_data( 265 ).description="proton-neutron mass ratio";
   unit_data( 265 ).value=0.99862347872;
   unit_data( 265 ).units="";
   unit_data( 265 ).uncertanity=0.00000000058;

   unit_data( 266 ).name="PROTON_RMS_CHARGE_RADIUS";
   unit_data( 266 ).description="proton rms charge radius";
   unit_data( 266 ).value=0.8750e-15;
   unit_data( 266 ).units="m";
   unit_data( 266 ).uncertanity=0.0068e-15;

   unit_data( 267 ).name="PROTON_TAU_MASS_RATIO";
   unit_data( 267 ).description="proton-tau mass ratio";
   unit_data( 267 ).value=0.528012;
   unit_data( 267 ).units="";
   unit_data( 267 ).uncertanity=0.000086;

   unit_data( 268 ).name="QUANTUM_OF_CIRCULATION";
   unit_data( 268 ).description="quantum of circulation";
   unit_data( 268 ).value=3.636947550e-4;
   unit_data( 268 ).units="m^2 s^-1";
   unit_data( 268 ).uncertanity=0.000000024e-4;

   unit_data( 269 ).name="QUANTUM_OF_CIRCULATION_TIMES_2";
   unit_data( 269 ).description="quantum of circulation times 2";
   unit_data( 269 ).value=7.273895101e-4;
   unit_data( 269 ).units="m^2 s^-1";
   unit_data( 269 ).uncertanity=0.000000048e-4;

   unit_data( 270 ).name="RYDBERG_CONSTANT";
   unit_data( 270 ).description="Rydberg constant";
   unit_data( 270 ).value=10973731.568525;
   unit_data( 270 ).units="m^-1";
   unit_data( 270 ).uncertanity=0.000073;

   unit_data( 271 ).name="RYDBERG_CONSTANT_TIMES_C_IN_HZ";
   unit_data( 271 ).description="Rydberg constant times c in Hz";
   unit_data( 271 ).value=3.289841960360e15;
   unit_data( 271 ).units="Hz";
   unit_data( 271 ).uncertanity=0.000000000022e15;

   unit_data( 272 ).name="RYDBERG_CONSTANT_TIMES_HC_IN_EV";
   unit_data( 272 ).description="Rydberg constant times hc in eV";
   unit_data( 272 ).value=13.6056923;
   unit_data( 272 ).units="eV";
   unit_data( 272 ).uncertanity=0.0000012;

   unit_data( 273 ).name="RYDBERG_CONSTANT_TIMES_HC_IN_J";
   unit_data( 273 ).description="Rydberg constant times hc in J";
   unit_data( 273 ).value=2.17987209e-18;
   unit_data( 273 ).units="J";
   unit_data( 273 ).uncertanity=0.00000037e-18;

   unit_data( 274 ).name="SACKUR_TETRODE_CONSTANT";
   unit_data( 274 ).description="Sackur-Tetrode constant (1 K, 101.325 kPa)";
   unit_data( 274 ).value=-1.1648677;
   unit_data( 274 ).units="";
   unit_data( 274 ).uncertanity=0.0000044;

   unit_data( 275 ).name="SECOND_RADIATION_CONSTANT";
   unit_data( 275 ).description="second radiation constant";
   unit_data( 275 ).value=1.4387752e-2;
   unit_data( 275 ).units="m K";
   unit_data( 275 ).uncertanity=0.0000025e-2;

   unit_data( 276 ).name="SHIELDED_HELION_GYROMAGN_RATIO";
   unit_data( 276 ).description="shielded helion gyromagn. ratio";
   unit_data( 276 ).value=2.03789470e8;
   unit_data( 276 ).units="s^-1 T^-1";
   unit_data( 276 ).uncertanity=0.00000018e8;

   unit_data( 277 ).name="SHIELDED_HELION_GYROMAGN_RATIO_BY_2_PI";
   unit_data( 277 ).description="shielded helion gyromagn. ratio over 2 pi";
   unit_data( 277 ).value=32.4341015;
   unit_data( 277 ).units="MHz T^-1";
   unit_data( 277 ).uncertanity=0.0000028;

   unit_data( 278 ).name="SHIELDED_HELION_MAGN_MOMENT";
   unit_data( 278 ).description="shielded helion magn. moment";
   unit_data( 278 ).value=-1.074553024e-26;
   unit_data( 278 ).units="J T^-1";
   unit_data( 278 ).uncertanity=0.000000093e-26;

   unit_data( 279 ).name="SHIELDED_HELION_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 279 ).description="shielded helion magn. moment to Bohr magneton ratio";
   unit_data( 279 ).value=-1.158671474e-3;
   unit_data( 279 ).units="";
   unit_data( 279 ).uncertanity=0.000000014e-3;

   unit_data( 280 ).name="SHIELDED_HELION_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 280 ).description="shielded helion magn. moment to nuclear magneton ratio";
   unit_data( 280 ).value=-2.127497723;
   unit_data( 280 ).units="";
   unit_data( 280 ).uncertanity=0.000000025;

   unit_data( 281 ).name="SHIELDED_HELION_TO_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 281 ).description="shielded helion to proton magn. moment ratio";
   unit_data( 281 ).value=-0.761766562;
   unit_data( 281 ).units="";
   unit_data( 281 ).uncertanity=0.000000012;

   unit_data( 282 ).name="SHIELDED_HELION_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO";
   unit_data( 282 ).description="shielded helion to shielded proton magn. moment ratio";
   unit_data( 282 ).value=-0.7617861313;
   unit_data( 282 ).units="";
   unit_data( 282 ).uncertanity=0.0000000033;

   unit_data( 283 ).name="SHIELDED_PROTON_GYROMAGN_RATIO";
   unit_data( 283 ).description="shielded proton gyromagn. ratio";
   unit_data( 283 ).value=2.67515333e8;
   unit_data( 283 ).units="s^-1 T^-1";
   unit_data( 283 ).uncertanity=0.00000023e8;

   unit_data( 284 ).name="SHIELDED_PROTON_GYROMAGN_RATIO_BY_2_PI";
   unit_data( 284 ).description="shielded proton gyromagn. ratio over 2 pi";
   unit_data( 284 ).value=42.5763875;
   unit_data( 284 ).units="MHz T^-1";
   unit_data( 284 ).uncertanity=0.0000037;

   unit_data( 285 ).name="SHIELDED_PROTON_MAGN_MOMENT";
   unit_data( 285 ).description="shielded proton magn. moment";
   unit_data( 285 ).value=1.41057047e-26;
   unit_data( 285 ).units="J T^-1";
   unit_data( 285 ).uncertanity=0.00000012e-26;

   unit_data( 286 ).name="SHIELDED_PROTON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO";
   unit_data( 286 ).description="shielded proton magn. moment to Bohr magneton ratio";
   unit_data( 286 ).value=1.520993132e-3;
   unit_data( 286 ).units="";
   unit_data( 286 ).uncertanity=0.000000016e-3;

   unit_data( 287 ).name="SHIELDED_PROTON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO";
   unit_data( 287 ).description="shielded proton magn. moment to nuclear magneton ratio";
   unit_data( 287 ).value=2.792775604;
   unit_data( 287 ).units="";
   unit_data( 287 ).uncertanity=0.000000030;

   unit_data( 288 ).name="SPEED_OF_LIGHT_IN_VACUUM";
   unit_data( 288 ).description="speed of light in vacuum";
   unit_data( 288 ).value=299792458;
   unit_data( 288 ).units="m s^-1";
   unit_data( 288 ).uncertanity=0.0;

   unit_data( 289 ).name="STANDARD_ACCELERATION_OF_GRAVITY";
   unit_data( 289 ).description="standard acceleration of gravity";
   unit_data( 289 ).value=9.80665;
   unit_data( 289 ).units="m s^-2";
   unit_data( 289 ).uncertanity=0.0;

   unit_data( 290 ).name="STANDARD_ATMOSPHERE";
   unit_data( 290 ).description="standard atmosphere";
   unit_data( 290 ).value=101325;
   unit_data( 290 ).units="Pa";
   unit_data( 290 ).uncertanity=0.0;

   unit_data( 291 ).name="STEFAN_BOLTZMANN_CONSTANT";
   unit_data( 291 ).description="Stefan-Boltzmann constant";
   unit_data( 291 ).value=5.670400e-8;
   unit_data( 291 ).units="W m^-2 K^-4";
   unit_data( 291 ).uncertanity=0.000040e-8;

   unit_data( 292 ).name="TAU_COMPTON_WAVELENGTH";
   unit_data( 292 ).description="tau Compton wavelength";
   unit_data( 292 ).value=0.69772e-15;
   unit_data( 292 ).units="m";
   unit_data( 292 ).uncertanity=0.00011e-15;

   unit_data( 293 ).name="TAU_COMPTON_WAVELENGTH_BY_2_PI";
   unit_data( 293 ).description="tau Compton wavelength over 2 pi";
   unit_data( 293 ).value=0.111046e-15;
   unit_data( 293 ).units="m";
   unit_data( 293 ).uncertanity=0.000018e-15;

   unit_data( 294 ).name="TAU_ELECTRON_MASS_RATIO";
   unit_data( 294 ).description="tau-electron mass ratio";
   unit_data( 294 ).value=3477.48;
   unit_data( 294 ).units="";
   unit_data( 294 ).uncertanity=0.57;

   unit_data( 295 ).name="TAU_MASS";
   unit_data( 295 ).description="tau mass";
   unit_data( 295 ).value=3.16777e-27;
   unit_data( 295 ).units="kg";
   unit_data( 295 ).uncertanity=0.00052e-27;

   unit_data( 296 ).name="TAU_MASS_ENERGY_EQUIVALENT";
   unit_data( 296 ).description="tau mass energy equivalent";
   unit_data( 296 ).value=2.84705e-10;
   unit_data( 296 ).units="J";
   unit_data( 296 ).uncertanity=0.00046e-10;

   unit_data( 297 ).name="TAU_MASS_ENERGY_EQUIVALENT_IN_MEV";
   unit_data( 297 ).description="tau mass energy equivalent in MeV";
   unit_data( 297 ).value=1776.99;
   unit_data( 297 ).units="MeV";
   unit_data( 297 ).uncertanity=0.29;

   unit_data( 298 ).name="TAU_MASS_IN_U";
   unit_data( 298 ).description="tau mass in u";
   unit_data( 298 ).value=1.90768;
   unit_data( 298 ).units="u";
   unit_data( 298 ).uncertanity=0.00031;

   unit_data( 299 ).name="TAU_MOLAR_MASS";
   unit_data( 299 ).description="tau molar mass";
   unit_data( 299 ).value=1.90768e-3;
   unit_data( 299 ).units="kg mol^-1";
   unit_data( 299 ).uncertanity=0.00031e-3;

   unit_data( 300 ).name="TAU_MUON_MASS_RATIO";
   unit_data( 300 ).description="tau-muon mass ratio";
   unit_data( 300 ).value=16.8183;
   unit_data( 300 ).units="";
   unit_data( 300 ).uncertanity=0.0027;

   unit_data( 301 ).name="TAU_NEUTRON_MASS_RATIO";
   unit_data( 301 ).description="tau-neutron mass ratio";
   unit_data( 301 ).value=1.89129;
   unit_data( 301 ).units="";
   unit_data( 301 ).uncertanity=0.00031;

   unit_data( 302 ).name="TAU_PROTON_MASS_RATIO";
   unit_data( 302 ).description="tau-proton mass ratio";
   unit_data( 302 ).value=1.89390;
   unit_data( 302 ).units="";
   unit_data( 302 ).uncertanity=0.00031;

   unit_data( 303 ).name="THOMSON_CROSS_SECTION";
   unit_data( 303 ).description="Thomson cross section";
   unit_data( 303 ).value=0.665245873e-28;
   unit_data( 303 ).units="m^2";
   unit_data( 303 ).uncertanity=0.000000013e-28;

   unit_data( 304 ).name="UNIFIED_ATOMIC_MASS_UNIT";
   unit_data( 304 ).description="unified atomic mass unit";
   unit_data( 304 ).value=1.66053886e-27;
   unit_data( 304 ).units="kg";
   unit_data( 304 ).uncertanity=0.00000028e-27;

   unit_data( 305 ).name="VON_KLITZING_CONSTANT";
   unit_data( 305 ).description="von Klitzing constant";
   unit_data( 305 ).value=25812.807449;
   unit_data( 305 ).units="ohm";
   unit_data( 305 ).uncertanity=0.000086;

   unit_data( 306 ).name="WEAK_MIXING_ANGLE";
   unit_data( 306 ).description="weak mixing angle";
   unit_data( 306 ).value=0.22215;
   unit_data( 306 ).units="";
   unit_data( 306 ).uncertanity=0.00076;

   unit_data( 307 ).name="WIEN_DISPLACEMENT_LAW_CONSTANT";
   unit_data( 307 ).description="Wien displacement law constant";
   unit_data( 307 ).value=2.8977685e-3;
   unit_data( 307 ).units="m K";
   unit_data( 307 ).uncertanity=0.0000051e-3;

 end

 if nargin < 1 
    rval=unit_data;
    return;
 end

 matches=[]; pmatches=[];
 LN=length(arg);
 arg=toupper(arg);
 %binary search
 low=1;high=length(unit_data);
 while ( low <= high ) 
   idx=low+floor((high-low)/2);
   val=cstrcmp(unit_data( idx ).name,arg);
   if val == 0
      matches=[matches, idx];
      break;
   elseif val==-1
      low=idx+1;
   else %val ==+1
      high=idx;
   end
   if ( idx == (low + high)/2 )
       warning("Cannot find a perfect-match for %s",arg)
       break;
   end
 end
 if (length(matches) == 0) %search only when we dont have matches
   for idx = 1:length(unit_data)
     if ( strncmp(arg,unit_data( idx ).name,LN) == 1 )
        pmatches=[pmatches, idx];
     end
   end
 end

 matches = [matches, pmatches]; 
 if (length(matches) >= 1)
       if (length(matches) == length(pmatches)) %Only partial matches exist
            warning(" Includes partial matches. Picking first %s (1'st) match with units %s...
 by default for %s.",unit_data(matches(1)).name,unit_data(matches(1)).units,arg)
        end
    match=unit_data(matches(1));
    rval=match.value;
    if (nargout >= 2)
       unit=match.units;
    end
    if (nargout >= 3)
       uncert=match.uncertanity;
    end
    if (nargout >= 4)
       desc=match.description;
    end
    if (nargout >= 5)
       name=match.name;
    end
 else
    error(" No matches found")
 end
 return;
end

function v=cstrcmp(s1,s2)
 L2=length(s2);
 L1=length(s1);
 L=min(L1,L2);
 for idx=1:L
   p=s1(idx);
    q=s2(idx);
    if ( p ~= q )
     v=sign(p-q);
     return
   end
 end
 v=sign(L1-L2);
 return;
end
%!assert( physical_constant( "ALPHA_PARTICLE_ELECTRON_MASS_RATIO" ),7294.2995363,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_MASS" ),6.6446565e-27,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT" ),5.9719194e-10,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT_IN_MEV" ),3727.37917,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_MASS_IN_U" ),4.001506179149,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_MOLAR_MASS" ),4.001506179149e-3,eps);
%!assert( physical_constant( "ALPHA_PARTICLE_PROTON_MASS_RATIO" ),3.97259968907,eps);
%!assert( physical_constant( "ANGSTROM_STAR" ),1.00001509e-10,eps);
%!assert( physical_constant( "ATOMIC_MASS_CONSTANT" ),1.66053886e-27,eps);
%!assert( physical_constant( "ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT" ),1.49241790e-10,eps);
%!assert( physical_constant( "ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT_IN_MEV" ),931.494043,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_ELECTRON_VOLT" ),931.494043e6,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_HARTREE" ),3.423177686e7,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_HERTZ" ),2.252342718e23,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_INVERSE_METER" ),7.513006608e14,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_JOULE" ),1.49241790e-10,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_KELVIN" ),1.0809527e13,eps);
%!assert( physical_constant( "ATOMIC_MASS_UNIT_KILOGRAM" ),1.66053886e-27,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_1ST_HYPERPOLARIZABLITY" ),3.20636151e-53,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_2ND_HYPERPOLARIZABLITY" ),6.2353808e-65,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ACTION" ),1.05457168e-34,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_CHARGE" ),1.60217653e-19,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_CHARGE_DENSITY" ),1.081202317e12,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_CURRENT" ),6.62361782e-3,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_DIPOLE_MOMENT" ),8.47835309e-30,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_FIELD" ),5.14220642e11,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_FIELD_GRADIENT" ),9.71736182e21,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_POLARIZABLITY" ),1.648777274e-41,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_POTENTIAL" ),27.2113845,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ELECTRIC_QUADRUPOLE_MOMENT" ),4.48655124e-40,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_ENERGY" ),4.35974417e-18,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_FORCE" ),8.2387225e-8,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_LENGTH" ),0.5291772108e-10,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_MAGNETIZABILITY" ),7.89103660e-29,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_MAGN_DIPOLE_MOMENT" ),1.85480190e-23,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_MAGN_FLUX_DENSITY" ),2.35051742e5,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_MASS" ),9.1093826e-31,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_MOMENTUM" ),1.99285166e-24,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_PERMITTIVITY" ),1.112650056e-10,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_TIME" ),2.418884326505e-17,eps);
%!assert( physical_constant( "ATOMIC_UNIT_OF_VELOCITY" ),2.1876912633e6,eps);
%!assert( physical_constant( "AVOGADRO_CONSTANT" ),6.0221415e23,eps);
%!assert( physical_constant( "BOHR_MAGNETON" ),927.400949e-26,eps);
%!assert( physical_constant( "BOHR_MAGNETON_IN_EV_PER_T" ),5.788381804e-5,eps);
%!assert( physical_constant( "BOHR_MAGNETON_IN_HZ_PER_T" ),13.9962458e9,eps);
%!assert( physical_constant( "BOHR_MAGNETON_IN_INVERSE_METERS_PER_TESLA" ),46.6864507,eps);
%!assert( physical_constant( "BOHR_MAGNETON_IN_K_PER_T" ),0.6717131,eps);
%!assert( physical_constant( "BOHR_RADIUS" ),0.5291772108e-10,eps);
%!assert( physical_constant( "BOLTZMANN_CONSTANT" ),1.3806505e-23,eps);
%!assert( physical_constant( "BOLTZMANN_CONSTANT_IN_EV_PER_K" ),8.617343e-5,eps);
%!assert( physical_constant( "BOLTZMANN_CONSTANT_IN_HZ_PER_K" ),2.0836644e10,eps);
%!assert( physical_constant( "BOLTZMANN_CONSTANT_IN_INVERSE_METERS_PER_KELVIN" ),69.50356,eps);
%!assert( physical_constant( "CHARACTERISTIC_IMPEDANCE_OF_VACUUM" ),376.730313461,eps);
%!assert( physical_constant( "CLASSICAL_ELECTRON_RADIUS" ),2.817940325e-15,eps);
%!assert( physical_constant( "COMPTON_WAVELENGTH" ),2.426310238e-12,eps);
%!assert( physical_constant( "COMPTON_WAVELENGTH_BY_2_PI" ),386.1592678e-15,eps);
%!assert( physical_constant( "CONDUCTANCE_QUANTUM" ),7.748091733e-5,eps);
%!assert( physical_constant( "CONVENTIONAL_VALUE_OF_JOSEPHSON_CONSTANT" ),483597.9e9,eps);
%!assert( physical_constant( "CONVENTIONAL_VALUE_OF_VON_KLITZING_CONSTANT" ),25812.807,eps);
%!assert( physical_constant( "CU_X_UNIT" ),1.00207710e-13,eps);
%!assert( physical_constant( "DEUTERON_ELECTRON_MAGN_MOMENT_RATIO" ),-4.664345548e-4,eps);
%!assert( physical_constant( "DEUTERON_ELECTRON_MASS_RATIO" ),3670.4829652,eps);
%!assert( physical_constant( "DEUTERON_MAGN_MOMENT" ),0.433073482e-26,eps);
%!assert( physical_constant( "DEUTERON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),0.4669754567e-3,eps);
%!assert( physical_constant( "DEUTERON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),0.8574382329,eps);
%!assert( physical_constant( "DEUTERON_MASS" ),3.34358335e-27,eps);
%!assert( physical_constant( "DEUTERON_MASS_ENERGY_EQUIVALENT" ),3.00506285e-10,eps);
%!assert( physical_constant( "DEUTERON_MASS_ENERGY_EQUIVALENT_IN_MEV" ),1875.61282,eps);
%!assert( physical_constant( "DEUTERON_MASS_IN_U" ),2.01355321270,eps);
%!assert( physical_constant( "DEUTERON_MOLAR_MASS" ),2.01355321270e-3,eps);
%!assert( physical_constant( "DEUTERON_NEUTRON_MAGN_MOMENT_RATIO" ),-0.44820652,eps);
%!assert( physical_constant( "DEUTERON_PROTON_MAGN_MOMENT_RATIO" ),0.3070122084,eps);
%!assert( physical_constant( "DEUTERON_PROTON_MASS_RATIO" ),1.99900750082,eps);
%!assert( physical_constant( "DEUTERON_RMS_CHARGE_RADIUS" ),2.1394e-15,eps);
%!assert( physical_constant( "ELECTRIC_CONSTANT" ),8.854187817e-12,eps);
%!assert( physical_constant( "ELECTRON_CHARGE_TO_MASS_QUOTIENT" ),-1.75882012e11,eps);
%!assert( physical_constant( "ELECTRON_DEUTERON_MAGN_MOMENT_RATIO" ),-2143.923493,eps);
%!assert( physical_constant( "ELECTRON_DEUTERON_MASS_RATIO" ),2.7244371095e-4,eps);
%!assert( physical_constant( "ELECTRON_GYROMAGN_RATIO" ),1.76085974e11,eps);
%!assert( physical_constant( "ELECTRON_GYROMAGN_RATIO_BY_2_PI" ),28024.9532,eps);
%!assert( physical_constant( "ELECTRON_G_FACTOR" ),-2.0023193043718,eps);
%!assert( physical_constant( "ELECTRON_MAGN_MOMENT" ),-928.476412e-26,eps);
%!assert( physical_constant( "ELECTRON_MAGN_MOMENT_ANOMALY" ),1.1596521859e-3,eps);
%!assert( physical_constant( "ELECTRON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),-1.0011596521859,eps);
%!assert( physical_constant( "ELECTRON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),-1838.28197107,eps);
%!assert( physical_constant( "ELECTRON_MASS" ),9.1093826e-31,eps);
%!assert( physical_constant( "ELECTRON_MASS_ENERGY_EQUIVALENT" ),8.1871047e-14,eps);
%!assert( physical_constant( "ELECTRON_MASS_ENERGY_EQUIVALENT_IN_MEV" ),0.510998918,eps);
%!assert( physical_constant( "ELECTRON_MASS_IN_U" ),5.4857990945e-4,eps);
%!assert( physical_constant( "ELECTRON_MOLAR_MASS" ),5.4857990945e-7,eps);
%!assert( physical_constant( "ELECTRON_MUON_MAGN_MOMENT_RATIO" ),206.7669894,eps);
%!assert( physical_constant( "ELECTRON_MUON_MASS_RATIO" ),4.83633167e-3,eps);
%!assert( physical_constant( "ELECTRON_NEUTRON_MAGN_MOMENT_RATIO" ),960.92050,eps);
%!assert( physical_constant( "ELECTRON_NEUTRON_MASS_RATIO" ),5.4386734481e-4,eps);
%!assert( physical_constant( "ELECTRON_PROTON_MAGN_MOMENT_RATIO" ),-658.2106862,eps);
%!assert( physical_constant( "ELECTRON_PROTON_MASS_RATIO" ),5.4461702173e-4,eps);
%!assert( physical_constant( "ELECTRON_TAU_MASS_RATIO" ),2.87564e-4,eps);
%!assert( physical_constant( "ELECTRON_TO_ALPHA_PARTICLE_MASS_RATIO" ),1.37093355575e-4,eps);
%!assert( physical_constant( "ELECTRON_TO_SHIELDED_HELION_MAGN_MOMENT_RATIO" ),864.058255,eps);
%!assert( physical_constant( "ELECTRON_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO" ),-658.2275956,eps);
%!assert( physical_constant( "ELECTRON_VOLT" ),1.60217653e-19,eps);
%!assert( physical_constant( "ELECTRON_VOLT_ATOMIC_MASS_UNIT" ),1.073544171e-9,eps);
%!assert( physical_constant( "ELECTRON_VOLT_HARTREE" ),3.67493245e-2,eps);
%!assert( physical_constant( "ELECTRON_VOLT_HERTZ" ),2.41798940e14,eps);
%!assert( physical_constant( "ELECTRON_VOLT_INVERSE_METER" ),8.06554445e5,eps);
%!assert( physical_constant( "ELECTRON_VOLT_JOULE" ),1.60217653e-19,eps);
%!assert( physical_constant( "ELECTRON_VOLT_KELVIN" ),1.1604505e4,eps);
%!assert( physical_constant( "ELECTRON_VOLT_KILOGRAM" ),1.78266181e-36,eps);
%!assert( physical_constant( "ELEMENTARY_CHARGE" ),1.60217653e-19,eps);
%!assert( physical_constant( "ELEMENTARY_CHARGE_BY_H" ),2.41798940e14,eps);
%!assert( physical_constant( "FARADAY_CONSTANT" ),96485.3383,eps);
%!assert( physical_constant( "FARADAY_CONSTANT_FOR_CONVENTIONAL_ELECTRIC_CURRENT" ),96485.336,eps);
%!assert( physical_constant( "FERMI_COUPLING_CONSTANT" ),1.16639e-5,eps);
%!assert( physical_constant( "FINE_STRUCTURE_CONSTANT" ),7.297352568e-3,eps);
%!assert( physical_constant( "FIRST_RADIATION_CONSTANT" ),3.74177138e-16,eps);
%!assert( physical_constant( "FIRST_RADIATION_CONSTANT_FOR_SPECTRAL_RADIANCE" ),1.19104282e-16,eps);
%!assert( physical_constant( "HARTREE_ATOMIC_MASS_UNIT" ),2.921262323e-8,eps);
%!assert( physical_constant( "HARTREE_ELECTRON_VOLT" ),27.2113845,eps);
%!assert( physical_constant( "HARTREE_ENERGY" ),4.35974417e-18,eps);
%!assert( physical_constant( "HARTREE_ENERGY_IN_EV" ),27.2113845,eps);
%!assert( physical_constant( "HARTREE_HERTZ" ),6.579683920721e15,eps);
%!assert( physical_constant( "HARTREE_INVERSE_METER" ),2.194746313705e7,eps);
%!assert( physical_constant( "HARTREE_JOULE" ),4.35974417e-18,eps);
%!assert( physical_constant( "HARTREE_KELVIN" ),3.1577465e5,eps);
%!assert( physical_constant( "HARTREE_KILOGRAM" ),4.85086960e-35,eps);
%!assert( physical_constant( "HELION_ELECTRON_MASS_RATIO" ),5495.885269,eps);
%!assert( physical_constant( "HELION_MASS" ),5.00641214e-27,eps);
%!assert( physical_constant( "HELION_MASS_ENERGY_EQUIVALENT" ),4.49953884e-10,eps);
%!assert( physical_constant( "HELION_MASS_ENERGY_EQUIVALENT_IN_MEV" ),2808.39142,eps);
%!assert( physical_constant( "HELION_MASS_IN_U" ),3.0149322434,eps);
%!assert( physical_constant( "HELION_MOLAR_MASS" ),3.0149322434e-3,eps);
%!assert( physical_constant( "HELION_PROTON_MASS_RATIO" ),2.9931526671,eps);
%!assert( physical_constant( "HERTZ_ATOMIC_MASS_UNIT" ),4.439821667e-24,eps);
%!assert( physical_constant( "HERTZ_ELECTRON_VOLT" ),4.13566743e-15,eps);
%!assert( physical_constant( "HERTZ_HARTREE" ),1.519829846006e-16,eps);
%!assert( physical_constant( "HERTZ_INVERSE_METER" ),3.335640951e-9,eps);
%!assert( physical_constant( "HERTZ_JOULE" ),6.6260693e-34,eps);
%!assert( physical_constant( "HERTZ_KELVIN" ),4.7992374e-11,eps);
%!assert( physical_constant( "HERTZ_KILOGRAM" ),7.3724964e-51,eps);
%!assert( physical_constant( "INVERSE_FINE_STRUCTURE_CONSTANT" ),137.03599911,eps);
%!assert( physical_constant( "INVERSE_METER_ATOMIC_MASS_UNIT" ),1.3310250506e-15,eps);
%!assert( physical_constant( "INVERSE_METER_ELECTRON_VOLT" ),1.23984191e-6,eps);
%!assert( physical_constant( "INVERSE_METER_HARTREE" ),4.556335252760e-8,eps);
%!assert( physical_constant( "INVERSE_METER_HERTZ" ),299792458,eps);
%!assert( physical_constant( "INVERSE_METER_JOULE" ),1.98644561e-25,eps);
%!assert( physical_constant( "INVERSE_METER_KELVIN" ),1.4387752e-2,eps);
%!assert( physical_constant( "INVERSE_METER_KILOGRAM" ),2.21021881e-42,eps);
%!assert( physical_constant( "INVERSE_OF_CONDUCTANCE_QUANTUM" ),12906.403725,eps);
%!assert( physical_constant( "JOSEPHSON_CONSTANT" ),483597.879e9,eps);
%!assert( physical_constant( "JOULE_ATOMIC_MASS_UNIT" ),6.7005361e9,eps);
%!assert( physical_constant( "JOULE_ELECTRON_VOLT" ),6.24150947e18,eps);
%!assert( physical_constant( "JOULE_HARTREE" ),2.29371257e17,eps);
%!assert( physical_constant( "JOULE_HERTZ" ),1.50919037e33,eps);
%!assert( physical_constant( "JOULE_INVERSE_METER" ),5.03411720e24,eps);
%!assert( physical_constant( "JOULE_KELVIN" ),7.242963e22,eps);
%!assert( physical_constant( "JOULE_KILOGRAM" ),1.112650056e-17,eps);
%!assert( physical_constant( "KELVIN_ATOMIC_MASS_UNIT" ),9.251098e-14,eps);
%!assert( physical_constant( "KELVIN_ELECTRON_VOLT" ),8.617343e-5,eps);
%!assert( physical_constant( "KELVIN_HARTREE" ),3.1668153e-6,eps);
%!assert( physical_constant( "KELVIN_HERTZ" ),2.0836644e10,eps);
%!assert( physical_constant( "KELVIN_INVERSE_METER" ),69.50356,eps);
%!assert( physical_constant( "KELVIN_JOULE" ),1.3806505e-23,eps);
%!assert( physical_constant( "KELVIN_KILOGRAM" ),1.5361808e-40,eps);
%!assert( physical_constant( "KILOGRAM_ATOMIC_MASS_UNIT" ),6.0221415e26,eps);
%!assert( physical_constant( "KILOGRAM_ELECTRON_VOLT" ),5.60958896e35,eps);
%!assert( physical_constant( "KILOGRAM_HARTREE" ),2.06148605e34,eps);
%!assert( physical_constant( "KILOGRAM_HERTZ" ),1.35639266e50,eps);
%!assert( physical_constant( "KILOGRAM_INVERSE_METER" ),4.52443891e41,eps);
%!assert( physical_constant( "KILOGRAM_JOULE" ),8.987551787e16,eps);
%!assert( physical_constant( "KILOGRAM_KELVIN" ),6.509650e39,eps);
%!assert( physical_constant( "LATTICE_PARAMETER_OF_SILICON" ),543.102122e-12,eps);
%!assert( physical_constant( "LATTICE_SPACING_OF_SILICON" ),192.0155965e-12,eps);
%!assert( physical_constant( "LOSCHMIDT_CONSTANT" ),2.6867773e25,eps);
%!assert( physical_constant( "MAGN_CONSTANT" ),12.566370614e-7,eps);
%!assert( physical_constant( "MAGN_FLUX_QUANTUM" ),2.06783372e-15,eps);
%!assert( physical_constant( "MOLAR_GAS_CONSTANT" ),8.314472,eps);
%!assert( physical_constant( "MOLAR_MASS_CONSTANT" ),1e-3,eps);
%!assert( physical_constant( "MOLAR_MASS_OF_CARBON_12" ),12e-3,eps);
%!assert( physical_constant( "MOLAR_PLANCK_CONSTANT" ),3.990312716e-10,eps);
%!assert( physical_constant( "MOLAR_PLANCK_CONSTANT_TIMES_C" ),0.11962656572,eps);
%!assert( physical_constant( "MOLAR_VOLUME_OF_IDEAL_GAS" ),22.710981e-3,eps);
%!assert( physical_constant( "MOLAR_VOLUME_OF_SILICON" ),12.0588382e-6,eps);
%!assert( physical_constant( "MO_X_UNIT" ),1.00209966e-13,eps);
%!assert( physical_constant( "MUON_COMPTON_WAVELENGTH" ),11.73444105e-15,eps);
%!assert( physical_constant( "MUON_COMPTON_WAVELENGTH_BY_2_PI" ),1.867594298e-15,eps);
%!assert( physical_constant( "MUON_ELECTRON_MASS_RATIO" ),206.7682838,eps);
%!assert( physical_constant( "MUON_G_FACTOR" ),-2.0023318396,eps);
%!assert( physical_constant( "MUON_MAGN_MOMENT" ),-4.49044799e-26,eps);
%!assert( physical_constant( "MUON_MAGN_MOMENT_ANOMALY" ),1.16591981e-3,eps);
%!assert( physical_constant( "MUON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),-4.84197045e-3,eps);
%!assert( physical_constant( "MUON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),-8.89059698,eps);
%!assert( physical_constant( "MUON_MASS" ),1.88353140e-28,eps);
%!assert( physical_constant( "MUON_MASS_ENERGY_EQUIVALENT" ),1.69283360e-11,eps);
%!assert( physical_constant( "MUON_MASS_ENERGY_EQUIVALENT_IN_MEV" ),105.6583692,eps);
%!assert( physical_constant( "MUON_MASS_IN_U" ),0.1134289264,eps);
%!assert( physical_constant( "MUON_MOLAR_MASS" ),0.1134289264e-3,eps);
%!assert( physical_constant( "MUON_NEUTRON_MASS_RATIO" ),0.1124545175,eps);
%!assert( physical_constant( "MUON_PROTON_MAGN_MOMENT_RATIO" ),-3.183345118,eps);
%!assert( physical_constant( "MUON_PROTON_MASS_RATIO" ),0.1126095269,eps);
%!assert( physical_constant( "MUON_TAU_MASS_RATIO" ),5.94592e-2,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_ACTION" ),1.05457168e-34,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_ACTION_IN_EV_S" ),6.58211915e-16,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_ENERGY" ),8.1871047e-14,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_ENERGY_IN_MEV" ),0.510998918,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_LENGTH" ),386.1592678e-15,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_MASS" ),9.1093826e-31,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_MOMENTUM" ),2.73092419e-22,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_MOMENTUM_IN_MEV_PER_C" ),0.510998918,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_TIME" ),1.2880886677e-21,eps);
%!assert( physical_constant( "NATURAL_UNIT_OF_VELOCITY" ),299792458,eps);
%!assert( physical_constant( "NEUTRON_COMPTON_WAVELENGTH" ),1.3195909067e-15,eps);
%!assert( physical_constant( "NEUTRON_COMPTON_WAVELENGTH_BY_2_PI" ),0.2100194157e-15,eps);
%!assert( physical_constant( "NEUTRON_ELECTRON_MAGN_MOMENT_RATIO" ),1.04066882e-3,eps);
%!assert( physical_constant( "NEUTRON_ELECTRON_MASS_RATIO" ),1838.6836598,eps);
%!assert( physical_constant( "NEUTRON_GYROMAGN_RATIO" ),1.83247183e8,eps);
%!assert( physical_constant( "NEUTRON_GYROMAGN_RATIO_BY_2_PI" ),29.1646950,eps);
%!assert( physical_constant( "NEUTRON_G_FACTOR" ),-3.82608546,eps);
%!assert( physical_constant( "NEUTRON_MAGN_MOMENT" ),-0.96623645e-26,eps);
%!assert( physical_constant( "NEUTRON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),-1.04187563e-3,eps);
%!assert( physical_constant( "NEUTRON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),-1.91304273,eps);
%!assert( physical_constant( "NEUTRON_MASS" ),1.67492728e-27,eps);
%!assert( physical_constant( "NEUTRON_MASS_ENERGY_EQUIVALENT" ),1.50534957e-10,eps);
%!assert( physical_constant( "NEUTRON_MASS_ENERGY_EQUIVALENT_IN_MEV" ),939.565360,eps);
%!assert( physical_constant( "NEUTRON_MASS_IN_U" ),1.00866491560,eps);
%!assert( physical_constant( "NEUTRON_MOLAR_MASS" ),1.00866491560e-3,eps);
%!assert( physical_constant( "NEUTRON_MUON_MASS_RATIO" ),8.89248402,eps);
%!assert( physical_constant( "NEUTRON_PROTON_MAGN_MOMENT_RATIO" ),-0.68497934,eps);
%!assert( physical_constant( "NEUTRON_PROTON_MASS_RATIO" ),1.00137841870,eps);
%!assert( physical_constant( "NEUTRON_TAU_MASS_RATIO" ),0.528740,eps);
%!assert( physical_constant( "NEUTRON_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO" ),-0.68499694,eps);
%!assert( physical_constant( "NEWTONIAN_CONSTANT_OF_GRAVITATION" ),6.6742e-11,eps);
%!assert( physical_constant( "NEWTONIAN_CONSTANT_OF_GRAVITATION_BY_H_BAR_C" ),6.7087e-39,eps);
%!assert( physical_constant( "NUCLEAR_MAGNETON" ),5.05078343e-27,eps);
%!assert( physical_constant( "NUCLEAR_MAGNETON_IN_EV_PER_T" ),3.152451259e-8,eps);
%!assert( physical_constant( "NUCLEAR_MAGNETON_IN_INVERSE_METERS_PER_TESLA" ),2.54262358e-2,eps);
%!assert( physical_constant( "NUCLEAR_MAGNETON_IN_K_PER_T" ),3.6582637e-4,eps);
%!assert( physical_constant( "NUCLEAR_MAGNETON_IN_MHZ_PER_T" ),7.62259371,eps);
%!assert( physical_constant( "PLANCK_CONSTANT" ),6.6260693e-34,eps);
%!assert( physical_constant( "PLANCK_CONSTANT_BY_2_PI" ),1.05457168e-34,eps);
%!assert( physical_constant( "PLANCK_CONSTANT_BY_2_PI_IN_EV_S" ),6.58211915e-16,eps);
%!assert( physical_constant( "PLANCK_CONSTANT_BY_2_PI_TIMES_C_IN_MEV_FM" ),197.326968,eps);
%!assert( physical_constant( "PLANCK_CONSTANT_IN_EV_S" ),4.13566743e-15,eps);
%!assert( physical_constant( "PLANCK_LENGTH" ),1.61624e-35,eps);
%!assert( physical_constant( "PLANCK_MASS" ),2.17645e-8,eps);
%!assert( physical_constant( "PLANCK_TEMPERATURE" ),1.41679e32,eps);
%!assert( physical_constant( "PLANCK_TIME" ),5.39121e-44,eps);
%!assert( physical_constant( "PROTON_CHARGE_TO_MASS_QUOTIENT" ),9.57883376e7,eps);
%!assert( physical_constant( "PROTON_COMPTON_WAVELENGTH" ),1.3214098555e-15,eps);
%!assert( physical_constant( "PROTON_COMPTON_WAVELENGTH_BY_2_PI" ),0.2103089104e-15,eps);
%!assert( physical_constant( "PROTON_ELECTRON_MASS_RATIO" ),1836.15267261,eps);
%!assert( physical_constant( "PROTON_GYROMAGN_RATIO" ),2.67522205e8,eps);
%!assert( physical_constant( "PROTON_GYROMAGN_RATIO_BY_2_PI" ),42.5774813,eps);
%!assert( physical_constant( "PROTON_G_FACTOR" ),5.585694701,eps);
%!assert( physical_constant( "PROTON_MAGN_MOMENT" ),1.41060671e-26,eps);
%!assert( physical_constant( "PROTON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),1.521032206e-3,eps);
%!assert( physical_constant( "PROTON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),2.792847351,eps);
%!assert( physical_constant( "PROTON_MAGN_SHIELDING_CORRECTION" ),25.689e-6,eps);
%!assert( physical_constant( "PROTON_MASS" ),1.67262171e-27,eps);
%!assert( physical_constant( "PROTON_MASS_ENERGY_EQUIVALENT" ),1.50327743e-10,eps);
%!assert( physical_constant( "PROTON_MASS_ENERGY_EQUIVALENT_IN_MEV" ),938.272029,eps);
%!assert( physical_constant( "PROTON_MASS_IN_U" ),1.00727646688,eps);
%!assert( physical_constant( "PROTON_MOLAR_MASS" ),1.00727646688e-3,eps);
%!assert( physical_constant( "PROTON_MUON_MASS_RATIO" ),8.88024333,eps);
%!assert( physical_constant( "PROTON_NEUTRON_MAGN_MOMENT_RATIO" ),-1.45989805,eps);
%!assert( physical_constant( "PROTON_NEUTRON_MASS_RATIO" ),0.99862347872,eps);
%!assert( physical_constant( "PROTON_RMS_CHARGE_RADIUS" ),0.8750e-15,eps);
%!assert( physical_constant( "PROTON_TAU_MASS_RATIO" ),0.528012,eps);
%!assert( physical_constant( "QUANTUM_OF_CIRCULATION" ),3.636947550e-4,eps);
%!assert( physical_constant( "QUANTUM_OF_CIRCULATION_TIMES_2" ),7.273895101e-4,eps);
%!assert( physical_constant( "RYDBERG_CONSTANT" ),10973731.568525,eps);
%!assert( physical_constant( "RYDBERG_CONSTANT_TIMES_C_IN_HZ" ),3.289841960360e15,eps);
%!assert( physical_constant( "RYDBERG_CONSTANT_TIMES_HC_IN_EV" ),13.6056923,eps);
%!assert( physical_constant( "RYDBERG_CONSTANT_TIMES_HC_IN_J" ),2.17987209e-18,eps);
%!assert( physical_constant( "SACKUR_TETRODE_CONSTANT" ),-1.1648677,eps);
%!assert( physical_constant( "SECOND_RADIATION_CONSTANT" ),1.4387752e-2,eps);
%!assert( physical_constant( "SHIELDED_HELION_GYROMAGN_RATIO" ),2.03789470e8,eps);
%!assert( physical_constant( "SHIELDED_HELION_GYROMAGN_RATIO_BY_2_PI" ),32.4341015,eps);
%!assert( physical_constant( "SHIELDED_HELION_MAGN_MOMENT" ),-1.074553024e-26,eps);
%!assert( physical_constant( "SHIELDED_HELION_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),-1.158671474e-3,eps);
%!assert( physical_constant( "SHIELDED_HELION_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),-2.127497723,eps);
%!assert( physical_constant( "SHIELDED_HELION_TO_PROTON_MAGN_MOMENT_RATIO" ),-0.761766562,eps);
%!assert( physical_constant( "SHIELDED_HELION_TO_SHIELDED_PROTON_MAGN_MOMENT_RATIO" ),-0.7617861313,eps);
%!assert( physical_constant( "SHIELDED_PROTON_GYROMAGN_RATIO" ),2.67515333e8,eps);
%!assert( physical_constant( "SHIELDED_PROTON_GYROMAGN_RATIO_BY_2_PI" ),42.5763875,eps);
%!assert( physical_constant( "SHIELDED_PROTON_MAGN_MOMENT" ),1.41057047e-26,eps);
%!assert( physical_constant( "SHIELDED_PROTON_MAGN_MOMENT_TO_BOHR_MAGNETON_RATIO" ),1.520993132e-3,eps);
%!assert( physical_constant( "SHIELDED_PROTON_MAGN_MOMENT_TO_NUCLEAR_MAGNETON_RATIO" ),2.792775604,eps);
%!assert( physical_constant( "SPEED_OF_LIGHT_IN_VACUUM" ),299792458,eps);
%!assert( physical_constant( "STANDARD_ACCELERATION_OF_GRAVITY" ),9.80665,eps);
%!assert( physical_constant( "STANDARD_ATMOSPHERE" ),101325,eps);
%!assert( physical_constant( "STEFAN_BOLTZMANN_CONSTANT" ),5.670400e-8,eps);
%!assert( physical_constant( "TAU_COMPTON_WAVELENGTH" ),0.69772e-15,eps);
%!assert( physical_constant( "TAU_COMPTON_WAVELENGTH_BY_2_PI" ),0.111046e-15,eps);
%!assert( physical_constant( "TAU_ELECTRON_MASS_RATIO" ),3477.48,eps);
%!assert( physical_constant( "TAU_MASS" ),3.16777e-27,eps);
%!assert( physical_constant( "TAU_MASS_ENERGY_EQUIVALENT" ),2.84705e-10,eps);
%!assert( physical_constant( "TAU_MASS_ENERGY_EQUIVALENT_IN_MEV" ),1776.99,eps);
%!assert( physical_constant( "TAU_MASS_IN_U" ),1.90768,eps);
%!assert( physical_constant( "TAU_MOLAR_MASS" ),1.90768e-3,eps);
%!assert( physical_constant( "TAU_MUON_MASS_RATIO" ),16.8183,eps);
%!assert( physical_constant( "TAU_NEUTRON_MASS_RATIO" ),1.89129,eps);
%!assert( physical_constant( "TAU_PROTON_MASS_RATIO" ),1.89390,eps);
%!assert( physical_constant( "THOMSON_CROSS_SECTION" ),0.665245873e-28,eps);
%!assert( physical_constant( "UNIFIED_ATOMIC_MASS_UNIT" ),1.66053886e-27,eps);
%!assert( physical_constant( "VON_KLITZING_CONSTANT" ),25812.807449,eps);
%!assert( physical_constant( "WEAK_MIXING_ANGLE" ),0.22215,eps);
%!assert( physical_constant( "WIEN_DISPLACEMENT_LAW_CONSTANT" ),2.8977685e-3,eps);
