// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "globals.h"
#include "ftglfontmanager.h"
#include "figure.h"

#include <sstream>

static void* GetCurrContext()
{
  HandleVectNoOwn& cf=
    Get<HandleVectNoOwn>( (ocpl::Handle) 0 , "CurrentFigure");
  Figure* cfig = dynamic_cast<Figure*>(GetObjectD( cf() ));
  return cfig->context();
}

FontAndContext::FontAndContext(FontType* fnt) 
{
  _Font = fnt;
  _Context = GetCurrContext();
}

FTGLFontManager& FTGLFontManager::Instance()
{
  static FTGLFontManager tm;
  return tm;
}

FontType* FTGLFontManager::GetFont( const char *filename, int size)
{
  std::stringstream fontKey;
  String& dir = Get<String>( (ocpl::Handle) 0 , "DefaultFontDir");
  void* context = GetCurrContext();

  fontKey << filename << size;

  FontIter result = fonts.find( fontKey.str());
  if( result != fonts.end())
  {
    //    LOGMSG( "Found font %s in list", filename);
    if(result->second->Context() == context) {
      return result->second->Font();
    }
    else {
      delete result->second;
      fonts.erase(result);
    }
  }
        
  std::stringstream fullpath;

  fullpath << dir() << "/" << filename ;

  FontType* font = new FontType(fullpath.str().c_str());

  if( !font || font->Error() )
  {
    cout << "Font " << fullpath << "failed to open\n";
    delete font;
    return NULL;
  }
            
  if( !font->FaceSize( size))
  {
    cout <<  "Font " << fullpath << " failed to set size " << size << "\n";
    delete font;
    return NULL;
  }
     
  FontAndContext* fac = new FontAndContext(font);
  
  fonts[fontKey.str()] = fac;

  return font;
        
}

