// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "mathutils.h"

//! returns the min & max of matrix, also in log10, taking into acount
// nans. assumes 1:length if matrix is empty
void FindMinMax(Matrix& M, 
		double& min, 
		double& max,
		double& lmin,
		double& lmax,
		long length)
{
  min = max = ocpl::nan;
  lmin = lmax = ocpl::nan;

  if(M.len()) {
    for(long i=0; i<M.len(); i++) {
      if(isnan(M(i))) continue;
      if(M(i)>max || isnan(max) ) max = M(i);
      if(M(i)<min || isnan(min) ) min = M(i);

      if(M(i) > 0) { // compute log limits
	if(M(i) > lmax || isnan(lmax) ) lmax = M(i);
	if(M(i) < lmin || isnan(lmin) ) lmin = M(i);
      }
    }
  }
  else if(length) {
    min  = 1;  
    max  = static_cast<double>(length);
    lmin = 0;
    lmax = log10(static_cast<double>(length));
  }	
}


void InterpColor(Matrix& Colormap, Matrix& Clim, double z, double cv[3])
{
  long last_idx = Colormap.nr()-1;

  double loc = (z - Clim(0))/(Clim(1) - Clim(0));
  if(loc<0) loc = 0;
  if(loc>1) loc = 1;
  
  // special case: loc==1
  if(loc==1) {
    for(int i=0;i<3;i++)
      cv[i] = Colormap(last_idx,i);
  }
  else {
    long cmap_idx = (long) floor(loc*((double) (last_idx)));
    double cmap_offs = loc*((double) last_idx) - (double) cmap_idx;
    
    for(int i=0;i<3;i++)
      cv[i] = 
	( 1.0 - cmap_offs ) * Colormap(cmap_idx,i) +
	cmap_offs * Colormap(cmap_idx+1,i);
  }
}
