// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_bool.h"

void Bool::Get(ocpl::command& com)
{
  ocpl::Real *val = new ocpl::Real(Value ? 1 : 0);
  com.argout(0,ocpl::real,1,1,reinterpret_cast<char*>(val),true);
}

void Bool::Set(ocpl::command& com)
{
   if(com.argin(2)->id != ocpl::real) {
    ret_error(com,"Value of property must be numerical");
    return;
  }
  Value = *(reinterpret_cast<double*>(com.argin(2)->data)) ? true : false ;
  com.init_argout(0);
}

