// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_color_radio.h"

void Color::c2rgba(char c)
{
  // black is the default color
  rgba[0]=rgba[1]=rgba[2]=0;
  rgba[3]=1;
       if(c== 'r') rgba[0] = 1;
  else if(c== 'g') rgba[1] = 1;
  else if(c== 'b') rgba[2] = 1; 
  else if(c== 'c') rgba[1] = rgba[2] = 1;
  else if(c== 'm') rgba[0] = rgba[2] = 1;
  else if(c== 'y') rgba[0] = rgba[1] = 1;
  else if(c== 'w') rgba[0] = rgba[1] = rgba[2] = 1;	
}

void Color::Set(ocpl::command& com)
{
  if(com.argin(2)->id==ocpl::real) {
    int i,j;
    for(i=0; i<4 && i<com.argin(2)->nr*com.argin(2)->nc ; i++)
      rgba[i] = (reinterpret_cast<double*>(com.argin(2)->data))[i];
    for(j=i;j<4;j++)
      rgba[j] = 1;
  }
  else
    c2rgba(com.argin(2)->data[0]);
  com.init_argout(0);
}

void Color::Get(ocpl::command& com)
{
  com.argout(0,ocpl::real,4,1,reinterpret_cast<char*>(rgba));
}

void Color::GetRGBA(double rgba_tmp[]) {
  for(unsigned int i=0;i<4;i++)
    rgba_tmp[i]=rgba[i];
}

void Color::SetRGBA(double rgba_tmp[]) {
  for(unsigned int i=0;i<4;i++)
    rgba[i]=rgba_tmp[i];
}

bool ColorNone::SetColor()
{
  if(!IsNone) {
    glColor4dv(rgba);
    return true;
  }

  return false;
}

void ColorNone::Get(ocpl::command& com)
{
  if(!IsNone) {
    Color::Get(com);
    return;
  }

  com.argout(0,ocpl::str,5,1,"none");
}

void ColorNone::Set(ocpl::command& com)
{
  if(com.argin(2)->id==ocpl::str) {
    std::string tmp=tolower(com.argin(2)->data);
    
    if(tmp=="none") {
      com.init_argout(0);
      IsNone=true;
    }
    else if(tmp.size()==1) {
      IsNone = false;
      Color::Set(com);
    }
    else
      ret_error(com,"Illegal value in set");
  }
  else {
    IsNone  = false;
    Color::Set(com);
  }
}

ColorNone::ColorNone(const char* none) : Color(none)
{
  IsNone = false;
  std::string tmp=tolower(none);
  if( tmp=="none" )
    IsNone=true;
  else if( tmp.size()==1 )
    c2rgba(tmp[0]);
  //black
}

