# Copyright (C) 1996 Her Majesty the Queen in Right of Canada.
# Permission to use, copy, modify and distribute this software and
# its documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies, that
# both the copyright notice and this permission notice appear in
# supporting documentation, and that the name of Her Majesty the Queen
# in Right  of Canada not be used in advertising or publicity pertaining
# to distribution of the software without specific, written prior
# permission.  Her Majesty the Queen in Right of Canada makes no
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

# Release versioning.
# 
# MAJOR releases represent major ABI changes in the exposed shared lib.
# This should not be so offen, only once with major code change wich due
# to a change in how ogdi is called external by other applications.
#
# MINOR releases represents revisions or bugfixes over ogdi.
#
# The exposed soname of lib is libogdi.so.($major) an lies in $(INST_LIB)
# Plugins lies in $(INST_LIB)/ogdi/
#

OGDI_MAJOR	  = 3
OGDI_MINOR	  = 2

OGDI_VERSION      = $(OGDI_MAJOR)$(OGDI_MINOR)

# Common macros and symbols used by all platforms
#
#
#
# !!! IMPORTANT !!!
#
# $TARGET and $TOPDIR must be defined in the environment
#
#	- $TARGET is the platform on which you compile;
#	  it could be 'solaris' or 'win32'
#	- $TOPDIR is the root directory of OGDI source files
#
#


#
# Default definitions
#

ifndef CFG
CFG = release
endif

ifndef TARGET
TARGET = $(shell uname)
endif

#
# Standard location of external components (not maintained
# by LAS)
#


#
# Standard location of compiled component libraries
#

BINDIR		= $(TOPDIR)/bin/$(TARGET)
LIBDIR		= $(TOPDIR)/lib/$(TARGET)

#
#	Final OS installation location.
#
prefix		= /usr/local
exec_prefix 	= ${prefix}
INST_INCLUDE	= ${prefix}/include
INST_LIB	= ${exec_prefix}/lib
INST_BIN	= ${exec_prefix}/bin

#
# A location named $(LINKDIR) will be defined in the system
# specific configuration files.  Under win32 this will point 
# to the location of the export libs $(LIBDIR), but under
# Unix it is the location of the shared objects $(BINDIR).
#

#
# Standard location of software components.
#

CURRENT_DIR	= ./
VPF_DIR		= $(topdir)/vpflib

#
#	The following can be internal or external depending on whether we
#	want to use the built-in versions of these libraries.
#
EXPAT_SETTING	=	internal
ZLIB_SETTING	=	internal
PROJ_SETTING	=	internal

#
# Standard location of include files.
#

CURRENT_INCLUDE	= $(patsubst %,$(INCL_SW)%,$(subst :, ,$(VPATH)))
GENERAL_INCLUDE = $(INCL_SW)$(TOPDIR)/include/$(TARGET)


OGDI_INCLUDE	= $(INCL_SW)$(TOPDIR)/ogdi/include
VRF_INCLUDE	= $(INCL_SW)$(TOPDIR)/ogdi/driver/vrf
PROJ_INCLUDE	= $(INCL_SW)$(TOPDIR)/proj
VPF_INCLUDE	= $(INCL_SW)$(TOPDIR)/vpflib/include $(INCL_SW)$(TOPDIR)/vpflib
ZLIB_INCLUDE	= $(INCL_SW)$(TOPDIR)/external/zlib
GLUTIL_INCLUDE	= $(INCL_SW)$(TOPDIR)/ogdi/glutil
EXPAT_INCLUDE   = $(INCL_SW)$(TOPDIR)/external/expat

#
# Dynamic libraries (shared objects)
#

ODBCEXT_LINKLIB	= $(LINK_SW)$(LINKDIR)$(LIB_SW)odbcext$(LIB_SUFFIX)
OGDI_LINKLIB	= $(LINK_SW)$(LINKDIR)$(LIB_SW)ogdi$(LIB_SUFFIX)
ZLIB_LINKLIB	= $(LINK_SW)$(LINKDIR)$(LIB_SW)zlib_ogdi$(OGDI_VERSION)$(LIB_SUFFIX)
EXPAT_LINKLIB	= $(LINK_SW)$(LINKDIR)$(LIB_SW)expat_ogdi$(OGDI_VERSION)$(LIB_SUFFIX)

#
# Static libraries (archives)
#

PROJ_STATICLIB		= $(LINK_SW)$(LIBDIR)/static$(LIB_SW)proj$(LIB_SUFFIX)
VPF_STATICLIB		= $(LINK_SW)$(LIBDIR)/static$(LIB_SW)vpf$(LIB_SUFFIX)
REMOTE_STATICLIB	= $(LINK_SW)$(LIBDIR)/static$(LIB_SW)remote$(LIB_SUFFIX)
GLUTIL_STATICLIB =	$(LINK_SW)$(LIBDIR)/static$(LIB_SW)glutil$(LIB_SUFFIX)


#
# Library aggregations
#

 
#
# Location of resulting object files
#

OBJDIR		=OBJ.$(TARGET)
DEPENDFILE	= depend.d
OBJECTS		= $(SOURCES:.c=.$(OBJ_EXT))

#
# When compiling in the OBJ.$(TARGET) directory, search for
# the source code files in the parent directory.
#

VPATH		= ..

#
# Standard target names.  Do not redefine them if they have
# already been set in the enclosing makefile.
#

TOBEGEN_STRIPPED=$(patsubst %$(OGDI_VERSION),%,$(TOBEGEN))

ifndef ARCGEN
ARCHGEN = $(TOPDIR)/lib/$(TARGET)/static/$(LIB_PREFIX)$(TOBEGEN).$(ARCH_EXT)
endif
ifndef DYNAGEN
DYNAGEN = $(TOPDIR)/bin/$(TARGET)/$(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT)
endif
ifndef SHRDGEN
SHRDGEN = $(TOPDIR)/bin/$(TARGET)/$(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR).$(OGDI_MINOR)
endif
ifndef PROGGEN
PROGGEN = $(TOPDIR)/bin/$(TARGET)/$(TOBEGEN)$(APP_EXT)
endif

STANDARD_TARGETS	= clean install

#
# Default target to be used if no others are specified.
# This implies that all makefiles that include this configuration
# must provide an 'all' target.
#

all:

#
# Include the platform specific configuration
#

include $(TOPDIR)/config/$(TARGET).mak


#
# Standard targets provided for all sub-makefiles
#

#
# Create a platform-specific object directory
#

MKOBJECTDIR:
	$(MKINSTALLDIR) $(OBJDIR)

#
# Build the dependency file using 'makedepend'
#

$(DEPENDFILE): $(SOURCES)
	touch depend.tmp
	makedepend -f depend.tmp -- $(subst /I,-I,$(subst /D,-D,$(SYSTEM_INCLUDE) $(CFLAGS))) -- $^
	sed  -e 's?^\.\./??g' -e 's?:/?:\\?g' depend.tmp > $@
#
# Clean all possible junk
#

default-clean:
	-$(RMALL) $(OBJDIR) $(TOPDIR)/lib/$(TARGET)/static/$(LIB_PREFIX)$(TOBEGEN).* $(OBJDIR) $(TOPDIR)/lib/$(TARGET)/$(LIB_PREFIX)$(TOBEGEN).* $(TOPDIR)/bin/$(TARGET)/$(LIB_PREFIX)$(TOBEGEN).* $(PROGGEN)

#
#	Default rule(s) to install stuff if appropriate.
#

ifeq ($(TARGETGEN),$(DYNAGEN))
default-install:
	mkdir -p $(INST_LIB)/ogdi
	cp $(TARGETGEN) $(INST_LIB)/ogdi
endif

ifeq ($(TARGETGEN),$(SHRDGEN))
default-install:
	cp $(TARGETGEN) $(INST_LIB)
	pushd $(INST_LIB); \
	      ln -s $(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR).$(OGDI_MINOR) \
	            $(LIB_PREFIX)$(TOBEGEN_STRIPPED).$(SHLIB_EXT).$(OGDI_MAJOR); \
	      ln -s $(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR).$(OGDI_MINOR) \
	            $(LIB_PREFIX)$(TOBEGEN_STRIPPED).$(SHLIB_EXT); \
	popd
endif

ifeq ($(TARGETGEN),$(ARCHGEN))
default-install:
endif

ifeq ($(TARGETGEN),$(PROGGEN))
default-install:
	cp $(TARGETGEN) $(INST_BIN)
endif

ifeq ($(TARGETGEN),)
default-install:
endif

install-so-link:
	mv -f $(INST_LIB)/$(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR).$(OGDI_MINOR) $(INST_LIB)
	mv -f $(INST_LIB)/$(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR) $(INST_LIB)
	pushd $(INST_LIB); ln -s $(LIB_PREFIX)$(TOBEGEN).$(SHLIB_EXT).$(OGDI_MAJOR).$(OGDI_MINOR) \
	      $(LIB_PREFIX)$(TOBEGEN_STRIPPED).$(SHLIB_EXT) ; \
	popd

install:	default-install $(EXTRA_INSTALL_TARGETS)

#
# Include the auto-generated dependency rules.  Only include
# this file if executing from within the OBJ.$(TARGET) directory.
#

# ifeq ($(PASS),depend)
# include $(DEPENDFILE)
# endif

#
# End of the common configuration
#




