/*
-----------------------------------------------------------------------------
This source file is part of LEXIExporter

Copyright 2006 NDS Limited

Author(s):
Lasse Tassing

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA, or go to
http://www.gnu.org/copyleft/lesser.txt.
-----------------------------------------------------------------------------
*/

#ifndef __FILE_LOGGER__
#define __FILE_LOGGER__

class CFileLogger : public ILogReceiver
{
public:
	CFileLogger(const char *pszFile, bool bLogTimes=true, ELogLevel eMinLevel=LOG_INFO);
	~CFileLogger(void);

	// Called from the logsystem
	void ReceiveLogMessage(SYSTEMTIME &LogTime, const char *pszTimeStr, int iMessageLevel, const char *pszMessage);

private:	
	bool			m_bLogTimes;
	HANDLE			m_hFileHandle;
	ELogLevel		m_eMinLevel;
};

#endif
