/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef DUMMYCLIENTHOOKS_H
#define DUMMYCLIENTHOOKS_H

#include "ClientHooks.h"

namespace LibOmClient {

	
/** Dummy ClientHooks for when the user of Comm doesn't care about notification.
 *
 * Comm will create one of these if no ClientHooks is specified in the
 * constructor's parameter list.  It does nothing.
 *
 * \ingroup libomclient
 */
class DummyClientHooks : public ClientHooks
{
public:
	~DummyClientHooks() {};
	
	void error(const string& msg) {}
	void engine_enabled() {}
	void engine_disabled() {}
	void new_patch(PatchModel* pm) {}
	void new_port(PortModel* port_info) {}
	void port_removal(const string& path) {}
	void patch_destruction(const string& path) {}
	void patch_enabled(const string& path) {}
	void patch_disabled(const string& path) {}
	void new_node(NodeModel* nm) {}
	void node_removal(const string& path) {}
	void object_renamed(const string& old_path, const string& new_path) {}
	void connection(ConnectionModel* cm) {}
	void disconnection(const string& src_port_path, const string& dst_port_path) {}
	void metadata_update(MetadataModel* mm) {}
	void control_change(ControlModel* cm) {}
	void new_plugin(PluginModel* pi) {}
};


} // namespace LibOmClient

#endif // DUMMYCLIENTHOOKS_H
