/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OMPATH_H
#define OMPATH_H

#include <string>
using std::string;


/** Utility functions to find parent paths, names, etc
 */
namespace OmPath {

	
/** Return the name from a full path.
 *
 * ie name("/master/snare/osc") == osc
 */
inline static string
name(const string& path)
{
	string name = path;
	
	string::size_type last_slash = path.find_last_of("/");
	if (last_slash != string::npos)
		name = name.substr(last_slash+1);

	return name;
}


/** Return the parent's path (ie chop the name off the end).
 */
inline static string
parent(const string& path)
{
	string parent = path;

	string::size_type last_slash = path.find_last_of("/");
	parent = parent.substr(0, last_slash);
	
	return parent;
}


} // namespace OmPath


#endif // OMPATH_H
