############################################################################
#    Copyright (C) 2007 by Tobias Koenig <tokoe@kde.org>                   #
#    Copyright (C) 2009 by David Palacio <dpalacio@uninorte.edu.co>        #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          #
############################################################################

module OkularComicBookDir
	class Document
		
		MAX_RECURSIVE = 2
		
		attr_reader :last_error_string
		
		def initialize(*args)
			@list = []
			@last_error_string = ''
		end
		
		def open( path )
			close
			url = KDE::Url.new path
			unless url.isLocalFile
				@last_error_string = KDE.i18n('Cannot load on non-local filesystems')
				return false
			end
			base_dir = Qt::Dir.new path
			add_recursive (@list=[]), base_dir, 0
			if @list.size == 0
				@last_error_string = KDE.i18n('Could not find pictures')
				return false
			end
			true
		end
		
		def add_recursive( list, base, level )
			return if level >= MAX_RECURSIVE
			subdirs = base.entry_list(Qt::Dir::AllDirs)
			subdirs.each do |dir|
				add_recursive list, Qt::Dir.new(base.path+'/'+dir), level + 1 unless /(^\.$)|(^\.\.$)/ === dir
			end
			files = base.entry_list
			files.each do |entry|
				list << base.path + '/' + entry if /\.jpg$|\.jpeg$|\.png$/i === entry
			end
		end
		
		def close
			@last_error_string = ''
			@list = []
		end
		
		def pages
			@list.size
		end
		
		def pageTitles
			[]
		end
		
		def page_image( page )
			unless @list.empty?
				return Qt::Image.new @list[ page ]
			end
			Qt::Image.new
		end
		
		def page_size( page )
			page = @list[page]
			if page
				size = ( reader = Qt::ImageReader.new(page) ).size
				return !size.null? ? size : reader.read.size
			end
			return Qt::Size.new
		end
	end
end
