# -*- coding: utf-8 -*-

# Copyright (C) 2004-2005 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os.path
from gettext import gettext as _

import gtk
import gtk.glade

from ontv import NAME, GLADE_DIR, LOCALE_DIR, PIXMAPS_DIR

gtk.glade.bindtextdomain(NAME.lower(), LOCALE_DIR)

class GUI:
    def __init__(self):
        glade_file = os.path.join(GLADE_DIR, "ontv.glade")
        self.xml = gtk.glade.XML(glade_file, domain=NAME.lower())

        icon_file = os.path.join(PIXMAPS_DIR, "ontv.png")
        self.icon = gtk.gdk.pixbuf_new_from_file(icon_file)

class FileChooserDialog(GUI, gtk.FileChooserDialog):
    def __init__(self, title, filters=None):
        GUI.__init__(self)
        gtk.FileChooserDialog.__init__(self, title=title,
                                            action=gtk.FILE_CHOOSER_ACTION_OPEN,
                                            buttons=(gtk.STOCK_CANCEL,
                                            gtk.RESPONSE_CANCEL,
                                            gtk.STOCK_OPEN, gtk.RESPONSE_OK))
        self.set_icon(self.icon)
        if filters:
            for filter in filters:
                self.add_filter(filter)
        all_filter = gtk.FileFilter()
        all_filter.set_name(_("All files"))
        all_filter.add_pattern("*")
        self.add_filter(all_filter)

class ErrorDialog(GUI, gtk.MessageDialog):
    def __init__(self, primary_msg, secondary_msg):
        GUI.__init__(self)
        gtk.MessageDialog.__init__(self, parent=None, flags=gtk.DIALOG_MODAL|gtk. DIALOG_DESTROY_WITH_PARENT, type=gtk.MESSAGE_ERROR, buttons=gtk.BUTTONS_OK, message_format=primary_msg)
        self.format_secondary_text(secondary_msg)
        self.set_icon(self.icon)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
