# -*- coding: utf-8 -*-

# Copyright (C) 2004-2005 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import cPickle
import os.path
import thread

class Listings:
    def __init__(self, config):
        self.file = os.path.join(config.base_dir, "listings.p")
        self.channels = {}
        self.programs = []
        self.selected_channels = []

        self.mtime = None

    def __getstate__(self):
        return self.__dict__.copy()

    def __setstate__(self, listings):
        self.__dict__.update(listings)

    def add_channel(self, channel):
        if channel.name in self.selected_channels:
            channel.selected = True
        self.channels[channel.name] = channel

    def add_program(self, program):
        self.programs.append(program)
        self.channels[program.channel_name].programs.append(program)

    def __save_in_thread(self, debug):
        file = open(self.file, 'w')
        cPickle.dump(self, file, cPickle.HIGHEST_PROTOCOL)
        file.close()
        if debug:
            print("Saved listings file: %s" % self.file)

    def save(self, debug):
        thread.start_new_thread(self.__save_in_thread, (debug,))

    def load(self, debug):
        file = open(self.file)
        self = cPickle.load(file)
        file.close()
        if debug:
            print("Loaded listings from file: %s" % self.file)
        return self

    def search_program(self, search_terms):
        matches = []
        for term in search_terms:
            for program in self.programs:
                if term in program.title.lower():
                    matches.append(program)
        return matches

# vim: set sw=4 et sts=4 tw=79 fo+=l:
