/*
* Copyright (C) 2003 Christian Nitschkowski <segfault_ii@web.de>
*/

#ifndef _OOOQS_H_
#define _OOOQS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ksystemtray.h>

class KConfig;
class KPopupMenu;
class KProcess;
class KToggleAction;

/**
 * @short Application Main Window
 * @author Christian Nitschkowski <segfault_ii@web.de>
 * @version 2.0
 */
class OOoQs : public KSystemTray {
		Q_OBJECT
	public:
		/**
		 * Default Constructor
		 */
		OOoQs();

		/**
		 * Default Destructor
		 */
		virtual ~OOoQs();

		/**
		Returns if it's ok to run the application or if the main-function
		should return with an error.
		*/
		const bool okToRun( void ) const {
			return _okToRun;
			}

	protected:
		/**
		Reimplemented from KSystemTray to detect double-clicks.
		*/
		virtual void mousePressEvent( QMouseEvent* );
	private:
		/**
		Stores the absolute path to the soffice-startscript.
		*/
		QString _exec;
		/**
		A pointer to the global configuration-object.
		*/
		KConfig* _config;
		/**
		A pointer to the last started quickstart-process.
		*/
		KProcess* _quickProcess;
		/**
		The toggle action that configures the autostart-feature.
		*/
		KToggleAction* _autostart;
		/**
		Stores if the main-funktion should quit immediately or
		if it's ok to run the application the normal way.
		*/
		bool _okToRun;
	private slots:
		/**
		Restart the quickstart instance.
		When an quickstart instance is killed,
		it will restart it automatically.
		*/
		void restartQuickInstance( KProcess* );
		/**
		Start the soffice-script with a given parameter.
		May be QString::null.
		*/
		void start( const QString ) const;
		/**
		Start StarCalc.
		*/
		void startCalc( void ) const;
		/**
		Start StarDraw.
		*/
		void startDraw( void ) const;
		/**
		Start the File-Open-dialog.
		*/
		void startOpen( void ) const;
		/**
		Start StarImpress.
		*/
		void startImpress( void ) const;
		/**
		Open the templates-dialog.
		*/
		void startTemplate( void ) const;
		/**
		Start StarWriter.
		*/
		void startWriter( void ) const;
		/**
		En-/Disable the autostart.
		*/
		void toggleAutostart( void );
		/**
		Kills the instance of OpenOffice.org that
		can be accesed through _quickProcess.
		*/
		void shutdownAndKillOffice( void );
	};

#endif // _OOOQS_H_
