// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ChFiDS_Spine_HeaderFile
#define _ChFiDS_Spine_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ChFiDS_Spine_HeaderFile
#include <Handle_ChFiDS_Spine.hxx>
#endif

#ifndef _BRepAdaptor_Curve_HeaderFile
#include <BRepAdaptor_Curve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ChFiDS_State_HeaderFile
#include <ChFiDS_State.hxx>
#endif
#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ChFiDS_ListOfHElSpine_HeaderFile
#include <ChFiDS_ListOfHElSpine.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _ChFiDS_ErrorStatus_HeaderFile
#include <ChFiDS_ErrorStatus.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_ChFiDS_HElSpine_HeaderFile
#include <Handle_ChFiDS_HElSpine.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
class TColStd_HArray1OfReal;
class TopoDS_Edge;
class ChFiDS_HElSpine;
class ChFiDS_ListOfHElSpine;
class gp_Pnt;
class gp_Vec;
class BRepAdaptor_Curve;
class gp_Lin;
class gp_Circ;
class TopoDS_Vertex;


//! Contient  les  informations  necessaires   a    la <br>
//!          construction d un conge volumique : <br>
//! <br>
//! <br>
//!          - ligne guide composee d'edges du solide, tangents <br>
//!          entre eux, et bordes par des faces tangentes entre <br>
//!          elles. <br>
//! <br>
//!          Les outils de construction du   Sp <br>
//!          par propagation a partir d un  edge du solide sont <br>
//!          fournis dans le Builder de Fil3d. <br>
//! <br>
//!          Le Spine contient par aileurs     des <br>
//!          informations concernant la nature des   extremites <br>
//!          du conge ( sur bord libre, sur cassure ou ferme ). <br>
//! <br>
//!          REMARQUE  IMPORTANTE  :    la  ligne  guide  ainsi <br>
//!          representee n est pas C2, alors que le cheminement <br>
//!          le  reclame.   Un  certain  nombre d  amenagements <br>
//!          paliatifs (voir les  methodes en fin) sont prevus, <br>
//!          s  ils  sont insuffisants  il faudra changer notre <br>
//!          fusil d  epaule et doubler le Spine d <br>
//!          une  ligne C2 avec  les consequences que l on sait <br>
//!          pour gerer les va et  vient entre KPart Blend dans <br>
//!          Fil3d. <br>
class ChFiDS_Spine : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT ChFiDS_Spine();


Standard_EXPORT ChFiDS_Spine(const Standard_Real Tol);
//! stocker les edges qui vont composer la ligne guide <br>
  void SetEdges(const TopoDS_Edge& E) ;
//!stocker l edge en premiere position avant tous les autres <br>
  void PutInFirst(const TopoDS_Edge& E) ;

  Standard_Integer NbEdges() const;

 const TopoDS_Edge& Edges(const Standard_Integer I) const;
//! stocker si le debut de l ensemble des edges demarre <br>
//!          sur une cassure un bord libre ou forme un contour ferme <br>
  void SetFirstStatus(const ChFiDS_State S) ;
//! stocker si la fin de l ensemble des edges demarre <br>
//!          sur une cassure un bord libre ou forme un contour ferme <br>
  void SetLastStatus(const ChFiDS_State S) ;


Standard_EXPORT virtual  void AppendElSpine(const Handle(ChFiDS_HElSpine)& Els) ;


Standard_EXPORT   Handle_ChFiDS_HElSpine ElSpine(const Standard_Integer IE) const;


Standard_EXPORT   Handle_ChFiDS_HElSpine ElSpine(const TopoDS_Edge& E) const;


Standard_EXPORT   Handle_ChFiDS_HElSpine ElSpine(const Standard_Real W) const;


Standard_EXPORT   ChFiDS_ListOfHElSpine& ChangeElSpines() ;


Standard_EXPORT virtual  void Reset(const Standard_Boolean AllData = Standard_False) ;


Standard_EXPORT   Standard_Boolean SplitDone() const;


Standard_EXPORT   void SplitDone(const Standard_Boolean B) ;

//! preparer la ligne guide en fonction  des edges qui <br>
//!          sont des arcs elementaires (prendre un parametrage <br>
//!          unique  abscisse curviligne );pour pouvoir appeller <br>
//!          les methodes sur la geometrie (first,last,value,d1,d2) <br>
//!          il faut d abord preparer sinon une exception sera levee <br>
Standard_EXPORT   void Load() ;


Standard_EXPORT   Standard_Real Resolution(const Standard_Real R3d) const;


Standard_EXPORT   Standard_Boolean IsClosed() const;


Standard_EXPORT   Standard_Real FirstParameter() const;


Standard_EXPORT   Standard_Real LastParameter() const;


Standard_EXPORT   void SetFirstParameter(const Standard_Real Par) ;


Standard_EXPORT   void SetLastParameter(const Standard_Real Par) ;

//! donne  la longueur cumulee  de tous les  arcs avant le <br>
//!          numero IndexSp <br>
Standard_EXPORT   Standard_Real FirstParameter(const Standard_Integer IndexSpine) const;

//! donne  la longueur cumulee  jusqu  a l  arc de  numero <br>
//!          IndexSpine (inclus) <br>
Standard_EXPORT   Standard_Real LastParameter(const Standard_Integer IndexSpine) const;

//! donne la longueur de l arc de numero IndexSp <br>
Standard_EXPORT   Standard_Real Length(const Standard_Integer IndexSpine) const;


Standard_EXPORT   Standard_Boolean IsPeriodic() const;


Standard_EXPORT   Standard_Real Period() const;


Standard_EXPORT   Standard_Real Absc(const Standard_Real U) ;


Standard_EXPORT   Standard_Real Absc(const Standard_Real U,const Standard_Integer I) ;


Standard_EXPORT   void Parameter(const Standard_Real AbsC,Standard_Real& U,const Standard_Boolean Oriented = Standard_True) ;


Standard_EXPORT   void Parameter(const Standard_Integer Index,const Standard_Real AbsC,Standard_Real& U,const Standard_Boolean Oriented = Standard_True) ;


Standard_EXPORT   gp_Pnt Value(const Standard_Real AbsC) ;


Standard_EXPORT   void D0(const Standard_Real AbsC,gp_Pnt& P) ;


Standard_EXPORT   void D1(const Standard_Real AbsC,gp_Pnt& P,gp_Vec& V1) ;


Standard_EXPORT   void D2(const Standard_Real AbsC,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) ;


Standard_EXPORT   void SetCurrent(const Standard_Integer Index) ;

//! set la courbe courante et la renvoie <br>
Standard_EXPORT  const BRepAdaptor_Curve& CurrentElementarySpine(const Standard_Integer Index) ;

  Standard_Integer CurrentIndexOfElementarySpine() const;


Standard_EXPORT   GeomAbs_CurveType GetType() const;


Standard_EXPORT   gp_Lin Line() const;


Standard_EXPORT   gp_Circ Circle() const;
//! returns if the set of edges starts on a free boundary <br>
//!          or if the first vertex is a breakpoint or if the set is <br>
//!          closed <br>
  ChFiDS_State FirstStatus() const;
//! returns the state at the end of the set <br>
  ChFiDS_State LastStatus() const;

  ChFiDS_State Status(const Standard_Boolean IsFirst) const;

  void SetStatus(const ChFiDS_State S,const Standard_Boolean IsFirst) ;
//!  returns   if the  set  of  edges starts (or   end) on <br>
//!          Tangency point. <br>
  Standard_Boolean IsTangencyExtremity(const Standard_Boolean IsFirst) const;

  void SetTangencyExtremity(const Standard_Boolean IsTangency,const Standard_Boolean IsFirst) ;


Standard_EXPORT   Standard_Real Absc(const TopoDS_Vertex& V) const;


Standard_EXPORT   TopoDS_Vertex FirstVertex() const;


Standard_EXPORT   TopoDS_Vertex LastVertex() const;


Standard_EXPORT   void SetFirstTgt(const Standard_Real W) ;


Standard_EXPORT   void SetLastTgt(const Standard_Real W) ;


Standard_EXPORT   Standard_Boolean HasFirstTgt() const;


Standard_EXPORT   Standard_Boolean HasLastTgt() const;

//! set a parameter reference for the approx. <br>
Standard_EXPORT   void SetReference(const Standard_Real W) ;

//! set  a  parameter  reference  for  the approx,  at the <br>
//!          middle  of edge I. <br>
Standard_EXPORT   void SetReference(const Standard_Integer I) ;


Standard_EXPORT   Standard_Integer Index(const Standard_Real W,const Standard_Boolean Forward = Standard_True) const;


Standard_EXPORT   Standard_Integer Index(const TopoDS_Edge& E) const;


Standard_EXPORT   void UnsetReference() ;


Standard_EXPORT   void SetErrorStatus(const ChFiDS_ErrorStatus state) ;


Standard_EXPORT   ChFiDS_ErrorStatus ErrorStatus() const;
//Standard_EXPORT ~ChFiDS_Spine();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Boolean splitdone;
ChFiDS_ListOfHElSpine elspines;


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Prepare(Standard_Real& L,Standard_Integer& Index) const;


 // Fields PRIVATE
 //
BRepAdaptor_Curve myCurve;
Standard_Integer indexofcurve;
ChFiDS_State firstState;
ChFiDS_State lastState;
TopTools_SequenceOfShape spine;
Handle_TColStd_HArray1OfReal abscissa;
Standard_Real tolesp;
Standard_Real firstparam;
Standard_Real lastparam;
Standard_Boolean firstprolon;
Standard_Boolean lastprolon;
Standard_Boolean firstistgt;
Standard_Boolean lastistgt;
Standard_Real firsttgtpar;
Standard_Real lasttgtpar;
Standard_Boolean hasfirsttgt;
Standard_Boolean haslasttgt;
gp_Pnt firstori;
gp_Pnt lastori;
gp_Vec firsttgt;
gp_Vec lasttgt;
Standard_Real valref;
Standard_Boolean hasref;
ChFiDS_ErrorStatus errorstate;


};


#include <ChFiDS_Spine.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
