// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepTool_GeomTool_HeaderFile
#define _TopOpeBRepTool_GeomTool_HeaderFile

#ifndef _TopOpeBRepTool_OutCurveType_HeaderFile
#include <TopOpeBRepTool_OutCurveType.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopOpeBRepTool_GeomTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Boolean flags <CompC3D>, <CompPC1>, <CompPC2> <br>
//!          indicate whether  the  corresponding result curves <br>
//!          <C3D>, <PC1>, <PC2> of MakeCurves method  must or not <br>
//!          be computed from an intersection line <L>. <br>
//!          When  the line <L> is a walking one, <TypeC3D> is the <br>
//!          kind  of the 3D curve <C3D>  to  compute  : <br>
//!          - BSPLINE1 to compute  a BSpline of  degree 1 on the <br>
//!          walking   points  of  <L>, <br>
//!          - APPROX  to build  an  approximation curve on the <br>
//!          walking points of <L>. <br>
Standard_EXPORT TopOpeBRepTool_GeomTool(const TopOpeBRepTool_OutCurveType TypeC3D = TopOpeBRepTool_BSPLINE1,const Standard_Boolean CompC3D = Standard_True,const Standard_Boolean CompPC1 = Standard_True,const Standard_Boolean CompPC2 = Standard_True);


Standard_EXPORT   void Define(const TopOpeBRepTool_OutCurveType TypeC3D,const Standard_Boolean CompC3D,const Standard_Boolean CompPC1,const Standard_Boolean CompPC2) ;


Standard_EXPORT   void Define(const TopOpeBRepTool_OutCurveType TypeC3D) ;


Standard_EXPORT   void DefineCurves(const Standard_Boolean CompC3D) ;


Standard_EXPORT   void DefinePCurves1(const Standard_Boolean CompPC1) ;


Standard_EXPORT   void DefinePCurves2(const Standard_Boolean CompPC2) ;


Standard_EXPORT   void Define(const TopOpeBRepTool_GeomTool& GT) ;


Standard_EXPORT   void GetTolerances(Standard_Real& tol3d,Standard_Real& tol2d) const;


Standard_EXPORT   void SetTolerances(const Standard_Real tol3d,const Standard_Real tol2d) ;


Standard_EXPORT   void GetTolerances(Standard_Real& tol3d,Standard_Real& tol2d,Standard_Boolean& relative) const;


Standard_EXPORT   void SetTolerances(const Standard_Real tol3d,const Standard_Real tol2d,const Standard_Boolean relative) ;


Standard_EXPORT   Standard_Integer NbPntMax() const;


Standard_EXPORT   void SetNbPntMax(const Standard_Integer NbPntMax) ;


Standard_EXPORT   TopOpeBRepTool_OutCurveType TypeC3D() const;


Standard_EXPORT   Standard_Boolean CompC3D() const;


Standard_EXPORT   Standard_Boolean CompPC1() const;


Standard_EXPORT   Standard_Boolean CompPC2() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
TopOpeBRepTool_OutCurveType myTypeC3D;
Standard_Boolean myCompC3D;
Standard_Boolean myCompPC1;
Standard_Boolean myCompPC2;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myTol3d;
Standard_Real myTol2d;
Standard_Boolean myRelativeTol;
Standard_Integer myNbPntMax;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
