/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


#include "pthread.h"
#include "pkcsslotd.h"

#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#include <grp.h>


#define MODE (S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP)
#define MAPFILENAME CONFIG_PATH "/.apimap"

/***********************************************************************
 *  CreateSharedMemory - 
 *  
 *      Creates and initializes a shared memory file.  This function will fail if the 
 *      memory is already allocated since we're the owner of it.
 *  
 ***********************************************************************/

int CreateSharedMemory ( void ) {

  struct stat statbuf;
  char *Path = NULL;
  gid_t  gid;
  struct group *grp;
  struct shmid_ds shm_info;

#if !MMAP
  if ( ((Path = getenv("PKCS11_SHMEM_FILE")) == NULL ) || ( Path[0] == '\0' ) ) {
    Path = TOK_PATH;
  }
  InfoLog( "Shared memory file is %s", Path);

   // Get shared memory key token all users of the shared memory
   // need to get the same token

   if ( stat(Path, &statbuf) < 0 ) {
      ErrLog(SLOTD_MSG(SHMEMKEY,
               "Shared Memory Key Token creation file does not exist"));
      return FALSE;
   }
   // SAB  Get the group information for the PKCS#11 group... fail if
   // it does not exist
   grp = getgrnam("pkcs11");
   if ( !grp ) {
     ErrLog("Group PKCS#11 does not exist ");
     return FALSE;  // Group does not exist... setup is wrong..
   }


   tok = ftok(Path ,'b');
   // Allocate the shared memory... Fail if the memory is already
   // allocated since the slot mgr is the owner of it.

   // Is this some attempt at exclusivity, or is that just a side effect? - SCM 9/1

   shmid = shmget( tok, sizeof( Slot_Mgr_Shr_t ),
                   IPC_CREAT | IPC_EXCL |  S_IRUSR |
	           S_IRGRP  | S_IWUSR | S_IWGRP   );

   // Explanation of options to shmget():

   /* 
    *  IPC_CREAT  Creates the data structure if it does not already exist.
    *  IPC_EXCL   Causes the shmget subroutine to be unsuccessful if the 
    *             IPC_CREAT flag is also set, and the data structure already exists.
    *  S_IRUSR    Permits the process that owns the data structure to read it.
    *  S_IWUSR    Permits the process that owns the data structure to modify it.
    *  S_IRGRP    Permits the group associated with the data structure to read it.
    *  S_IWGRP    Permits the group associated with the data structure to modify it.
    *
    *
    *  WE DON"T WANT OTHERS
    *  S_IROTH    Permits others to read the data structure.
    *  S_IWOTH    Permits others to modify the data structure.
    */


   if ( shmid < 0 ) {
      ErrLog(SLOTD_MSG(SHMEMCR, 
              "Shared memory creation failed (0x%X)\n"), errno);
      ErrLog(SLOTD_MSG(IPCRM, "perform ipcrm -M 0x%X\n"), tok);
      return FALSE;
   }

   // SAB Set the group ownership of the shared mem segment..
   // we already have the group structure..
   
   if ( shmctl(shmid, IPC_STAT,&shm_info) == 0 ) {

        shm_info.shm_perm.gid = grp->gr_gid;

        if (shmctl(shmid,IPC_SET,&shm_info) == -1) {
             ErrLog("Failed to set group ownership for shm \n");
             shmctl(shmid, IPC_RMID,NULL);        
        }

   } else {
        ErrLog("Can't get status of shared memory %d\n",errno);
        // we know it was created... we need to destroy it...
        shmctl(shmid, IPC_RMID,NULL);        

   }
   


   return TRUE;
#else   
{
#warning "EXPERIMENTAL"
   int fd;
   int i;
   char *buffer;
   
   grp = getgrnam("pkcs11");
   if ( !grp ) {
     ErrLog("Group \"pkcs11\" does not exist! Please run %s/pkcs11_startup.",
		     SBIN_PATH);
     return FALSE;  // Group does not exist... setup is wrong..
   }

   fd = open(MAPFILENAME,O_RDWR,MODE);
   if (fd < 0 ) {
     // File does not exist... this is cool, we creat it here
     fd = open(MAPFILENAME,O_RDWR|O_CREAT,MODE); // Create the file
     if (fd < 0 ){ // We are really hosed here, since we should be able
       // to create the file now
       ErrLog("%s: open(%s): %s", __FUNCTION__, MAPFILENAME, strerror(errno));
       return FALSE;
     } else {
       if (fchmod(fd, MODE) == -1) {
	 ErrLog("%s: fchmod(%s): %s", __FUNCTION__, MAPFILENAME, strerror(errno));
	 close(fd);
	 return FALSE;
       }
       if (fchown(fd, 0, grp->gr_gid) == -1) {
	 ErrLog("%s: fchown(%s, root, pkcs11): %s", __FUNCTION__, MAPFILENAME,
		strerror(errno));
	 close(fd);
	 return FALSE;
       }
       // Create a buffer and make the file the right length
       i = sizeof(Slot_Mgr_Shr_t);
       buffer = malloc(sizeof(Slot_Mgr_Shr_t));
       memset(buffer,'\0',i);
       write(fd,buffer,i);
       free(buffer);
       close(fd);
     }
   } else {
     ErrLog("%s: [%s] exists; you may already have a pkcsslot daemon running. If this "
	    "is not the case, then the prior daemon was not shut down cleanly. "
	    "Please delete this file and try again\n", __FUNCTION__, MAPFILENAME);
     close(fd); 
     return FALSE;
   }
   return TRUE;
}

#endif

}




/***********************************************************************
 *
 * AttachToSharedMemeory - 
 *
 *     Called after creating the shared memory file
 *     Basically allows us to have access to the memory we've just created
 *
 ***********************************************************************/

int AttachToSharedMemeory ( void ) {

#if !MMAP
   shmp = NULL;
   shmp = (Slot_Mgr_Shr_t *) shmat( shmid, NULL, 0 );

   if ( !shmp ) {
      ErrLog(SLOTD_MSG(SHMEMAT, 
               "Shared memory attach failed (0x%X)\n"), errno);
      return FALSE;
   }

   /* Initizalize the memory to 0  */
   memset ( shmp, '\0', sizeof(*shmp) );

   return TRUE;
#else
{
#warning "EXPERIMENTAL"
   int fd;
   int i;
   char *buffer;

    fd = open(MAPFILENAME,O_RDWR,MODE);
    if (fd < 0 ){
   	return FALSE;  //Failed
    }
   shmp = (Slot_Mgr_Shr_t *)mmap(NULL,sizeof(Slot_Mgr_Shr_t),PROT_READ|PROT_WRITE,
				    MAP_SHARED,fd,0);
   close(fd);
   if ( ! shmp ) {
      return FALSE;
   }
   return TRUE;
}
#endif

}






/***********************************************************************
 *
 * DetachFromSharedMemory - 
 *
 *     Un-does AttachToSharedMemory() :)
 *
 ***********************************************************************/

void DetachFromSharedMemory ( void ) {

#if !MMAP
  if ( shmp == NULL ) return;

  if ( shmdt(shmp) != 0 ) {
    ErrLog(SLOTD_MSG(SHMEMDE, 
             "Attempted to detach from an invalid shared memory pointer"));
  }

  shmp = NULL;
  return;
#else
  if ( shmp == NULL ) return;
  
  munmap((void *)shmp,sizeof(*shmp));

  unlink(MAPFILENAME);
#endif

}




/***********************************************************************
 *
 * DestroySharedMemory -
 *
 *     Closes (destroys) the shared memory file we created with CreateSharedMemory()
 *
 *     We should make sure that everyone else has detached before we do this
 *     if we manage to exit before this gets called, you have to call ipcrm
 *     to clean things up...
 *
 ***********************************************************************/

void DestroySharedMemory ( void ) {

  if (shmctl (shmid, IPC_RMID, 0) != 0) {
    perror ("error in closing shared memory segment");
  }

  return;

}





/***********************************************************************
 *
 * InitSharedMemory - 
 * 
 *      Set up our newly allocated shared memory segment
 *
 *
 ***********************************************************************/


int InitSharedMemory ( Slot_Mgr_Shr_t *sp ) {

#ifdef PKCS64
   CK_INFO_PTR_64      ckinf = NULL;
#else
   CK_INFO_PTR         ckinf = NULL;
#endif

   CK_VERSION_PTR      ckver;
   CK_SLOT_INFO_PTR    ckslot;
   CK_SLOT_ID          id;
   uint16              procindex;
   char *package_version_tmp;
   char *tok_str;
   CK_BYTE lib_major;
   CK_BYTE lib_minor;

   ckinf = &(sp->ck_info);
   ckver = &(ckinf->cryptokiVersion);
   

   ckver->major = CRYPTOKI_API_MAJOR_V;
   ckver->minor = CRYPTOKI_API_MINOR_V;

   sp->ck_info.cryptokiVersion.major = CRYPTOKI_API_MAJOR_V;

   memset ( ckinf->manufacturerID,      ' ', sizeof(ckinf->manufacturerID)     );
   memset ( ckinf->libraryDescription,  ' ', sizeof(ckinf->libraryDescription) );

   memcpy ( ckinf->manufacturerID,     MFG, strlen(MFG) );
   memcpy ( ckinf->libraryDescription, LIB, strlen(LIB) );

   ckver = &(ckinf->libraryVersion);

   ckver->major = LIB_MAJOR_V;
   ckver->minor = LIB_MINOR_V;

#ifdef PACKAGE_VERSION
   package_version_tmp = malloc(strlen(PACKAGE_VERSION)+1);
   if (package_version_tmp) {
	   strcpy(package_version_tmp, PACKAGE_VERSION);
	   tok_str = strtok(package_version_tmp, ".");
	   if (tok_str) {
		   lib_major = (CK_BYTE)atoi(tok_str);
		   tok_str = strtok(NULL, ".");
		   if (tok_str) {
			   lib_minor = (CK_BYTE)atoi(tok_str);
			   ckver->major = lib_major;
			   ckver->minor = lib_minor;
		   } 
	   }
	   free(package_version_tmp);
   }
#endif

   /*  
    *  populate the Slot entries...
    */

   sp->num_slots = NumberSlotsInDB;

   /* FIXME: Change NUMBER_SLOTS_MANAGED in loop condition to NumberSlotsInDB? */
   for ( id=0; ( (id < NUMBER_SLOTS_MANAGED) && (sinfo[id].present == TRUE ) ) ; id++ ) {
     /* Was sinfo[id].pk_slot.slotDescription[0] != '0' - assume typo 9/1 SCM */


#ifdef PKCS64
      CK_SLOT_INFO_64    *dest = &(sp->slot_info[id].pk_slot);
      CK_SLOT_INFO_64    *src  = &(sinfo[id].pk_slot); 
#else
      CK_SLOT_INFO    *dest = &(sp->slot_info[id].pk_slot);
      CK_SLOT_INFO    *src  = &(sinfo[id].pk_slot);
#endif

      sp->slot_info[id].slot_number    = sinfo[id].slot_number;
      sp->slot_info[id].present        = sinfo[id].present;

      memset ( &(dest->slotDescription[0]), ' ', sizeof(dest->slotDescription) );
      memset ( &(dest->manufacturerID[0]),  ' ', sizeof(dest->manufacturerID) );

      memcpy ( &(dest->slotDescription[0]), &(src->slotDescription[0]), sizeof( src->slotDescription ) );
      memcpy ( &(dest->manufacturerID[0]),  &(src->manufacturerID[0]),  sizeof( src->manufacturerID )  );

      dest->flags = src->flags;

      memcpy ( &(dest->hardwareVersion), &(src->hardwareVersion), sizeof(src->hardwareVersion) );
      memcpy ( &(dest->firmwareVersion), &(src->firmwareVersion), sizeof(src->firmwareVersion) );

      /* FIXME: We really should check the length of the strings before copying it */
      strcpy( sp->slot_info[id].dll_location,    sinfo[id].dll_location  );
      strcpy( sp->slot_info[id].slot_init_fcn,   sinfo[id].slot_init_fcn );
      strcpy( sp->slot_info[id].correlator,      sinfo[id].correlator    );

   } /* end for id */

   for( ; id < NUMBER_SLOTS_MANAGED; id++ ) {
      sp->slot_info[id].slot_number = id;
   }


   /* Initialize the process side of things. */
   /* for now don't worry about the condition variables */
   for ( procindex=0; procindex < NUMBER_PROCESSES_ALLOWED; procindex++ ) {
     /* Initialize the mutex variables. */

#if FIXME
#error "No usage of the per process mutexes..."
#ifdef PKCS64
      msem_init( &(sp->proc_table[procindex].proc_mutex), 1 );
#else     
      pthread_mutex_init( &(sp->proc_table[procindex].proc_mutex), &mtxattr );
#endif
#endif

      sp->proc_table[procindex].inuse = FALSE;
   }
      
   return TRUE;



}

