<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/user.php");
include_once("./functions/status_type.php");
include_once("./functions/utils.php");
include_once("./functions/borrowed_item.php");

/**
	You can use this menu options function, with standard image names
	to automatically generate a menu with images, instead of text.

	The image names should match the $LANG_VARS name index for the 'link'
	element.
*/
function get_menu_options($uid, $user_type)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	//dodgy at best!
	global $HTTP_VARS;

	$menu_options = NULL;
	
	// Authenticated user
	if(strlen($uid))
	{
		if(is_user_allowed_to_own($uid, $user_type))
		{
			// No results, whats the point of allowing new item to be added.
			$results = fetch_newitem_status_type_rs($uid);
			if($results && @mysql_num_rows($results)>1)
			{
				$isChecked=FALSE;
				while($status_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					if(!$isChecked && $HTTP_VARS['s_status_type'] == $status_type_r['value'])
					{
						$status_type_r['checked_ind'] = 'Y';
						$isChecked=TRUE;
					}
					else if(strlen($HTTP_VARS['s_status_type'])>0 && $status_type_r['checked_ind'] == 'Y') // If already checked, then uncheck.
					{
						$status_type_r['checked_ind'] = 'N';
					}
						
					// only want to keep partial records.
					$row['value'] = $status_type_r['value'];
					$row['display'] = $status_type_r['display'];
					$row['checked_ind'] = $status_type_r['checked_ind'];
					
					$status_type_rs[] = $row;
				}
				mysql_free_result($results);
			
				$menu_options[] = array(link=>$LANG_VARS['add_new_item'],
							alt=>$LANG_VARS['add_new_item'],
							url=>"item_add.php",
							img=>"add_new_item.gif",
							form=>array(
								'action'=>'item_add.php',
								'fields'=>array(
									's_status_type'=>$status_type_rs)));
			}
			else
			{
				$menu_options[] = array(link=>$LANG_VARS['add_new_item'],
								alt=>$LANG_VARS['add_new_item'],
								url=>"item_add.php",
								img=>"add_new_item.gif");
			}
			
			$menu_options[] = "-";//spacer

			$menu_options[] = array(link=>$LANG_VARS['list_my_items'],
					alt=>$LANG_VARS['list_my_items'],
					url=>"listings.php?owner_id=$uid&order_by=title&sortorder=ASC",
					img=>"list_my_items.gif");
			
			if($CONFIG_VARS['menu.other_items_listing']!==FALSE || $CONFIG_VARS['menu.all_items_listing']!==FALSE)
			{
				if($CONFIG_VARS['menu.other_items_listing']!==FALSE)
				{
					$menu_options[] = array(link=>$LANG_VARS['list_other_items'],
							alt=>$LANG_VARS['list_other_items'],
							url=>"listings.php?not_owner_id=$uid&order_by=title&sortorder=ASC",
							img=>"list_other_items.gif");
				}
					
				if($CONFIG_VARS['menu.all_items_listing']!==FALSE)
				{
					$menu_options[] = array(link=>$LANG_VARS['list_all_items'],
							alt=>$LANG_VARS['list_all_items'],
							url=>"listings.php?order_by=title&sortorder=ASC",
							img=>"list_all_items.gif");
				}
			}
			
			$menu_options[] = "-";//spacer
			if(is_file_upload_enabled())
			{
				$menu_options[] = array(link=>$LANG_VARS['import_my_items'],img=>'import_my_items.gif',alt=>$LANG_VARS['import_my_items'],url=>"importcsv.php?owner_id=$uid");
			}
			$menu_options[] = array(link=>$LANG_VARS['export_my_items'],img=>'export_my_items.gif',alt=>$LANG_VARS['export_my_items'],url=>"export.php?owner_id=$uid");
			$menu_options[] = "-";//spacer
		}//if(is_user_allowed_to_own($uid, $user_type))
		else 
		{
			$menu_options[] = array(link=>$LANG_VARS['list_all_items'],
						alt=>$LANG_VARS['list_all_items'],
						url=>"listings.php?order_by=title&sortorder=ASC",
						img=>"list_all_items.gif");
			$menu_options[] = "-";//spacer
		}
		
		// Is borrow functionality enabled?
		if($CONFIG_VARS['borrow.enable']!==FALSE && is_user_allowed_to_borrow($uid, $type))
		{
			if(($CONFIG_VARS['borrow.list_all_borrowed']!==FALSE) || ($CONFIG_VARS['borrow.list_all_reserved']!==FALSE))
			{
				$include_spacer=FALSE;
				if($CONFIG_VARS['borrow.list_all_borrowed']!==FALSE && is_exists_borrowed())
				{
					$menu_options[] = array(link=>$LANG_VARS['items_borrowed'],img=>'items_borrowed.gif',alt=>$LANG_VARS['items_borrowed'],url=>"borrow.php?op=all_borrowed");
					$include_spacer=TRUE;
				}
					
				if($CONFIG_VARS['borrow.list_all_reserved']!==FALSE && is_exists_reserved())
				{
					$menu_options[] = array(link=>$LANG_VARS['items_reserved'],img=>'items_borrowed.gif',alt=>$LANG_VARS['items_reserved'],url=>"borrow.php?op=all_reserved");
					$include_spacer=TRUE;
				}
				if($include_spacer!==FALSE)
				$menu_options[] = "-";//spacer
			}
			
			$include_spacer=FALSE;
			if(is_exists_borrower_history($uid))
			{
				$menu_options[] = array(link=>$LANG_VARS['my_history'],img=>'my_history.gif',alt=>$LANG_VARS['my_history'],url=>"borrow.php?op=my_history");
				$include_spacer=TRUE;
			}
			
			if(is_exists_borrower_borrowed($uid))
			{
				$menu_options[] = array(link=>$LANG_VARS['my_borrowed_items'],img=>'my_borrowed_items.gif',alt=>$LANG_VARS['my_borrowed_items'],url=>"borrow.php?op=my_borrowed");
				$include_spacer=TRUE;
			}
			
			if(is_exists_borrower_reserved($uid))
			{
				$menu_options[] = array(link=>$LANG_VARS['my_reserved_items'],img=>'my_reserved_items.gif',alt=>$LANG_VARS['my_reserved_items'],url=>"borrow.php?op=my_reserved");
				$include_spacer=TRUE;
			}
				
			if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing']))
			{
				$menu_options[] = array(link=>$LANG_VARS['item_reserve_list'],img=>'item_reserve_list.gif',alt=>$LANG_VARS['item_reserve_list'],url=>"borrow.php?op=my_reserve_basket&order_by=title&sortorder=ASC");
				$include_spacer=TRUE;
			}
			
			if($include_spacer!==FALSE)
				$menu_options[] = "-";//spacer

			if(is_user_allowed_to_own($uid, $user_type))
			{
				$include_spacer=FALSE;
				if(is_exists_owner_reserved($uid))
				{
					$menu_options[] = array(link=>$LANG_VARS['item_check_out'],img=>'item_check_out.gif',alt=>$LANG_VARS['item_check_out'],url=>"borrow.php?op=owner_reserved");
					$include_spacer=TRUE;
				}
				
				if(is_exists_owner_borrowed($uid))
				{
					$menu_options[] = array(link=>$LANG_VARS['item_check_in'],img=>'item_check_in.gif',alt=>$LANG_VARS['item_check_in'],url=>"borrow.php?op=owner_borrowed");
					$include_spacer=TRUE;
				}
				if($include_spacer!==FALSE)
					$menu_options[] = "-";//spacer
			}
		} //if(is_user_allowed_to_borrow($uid, $type))

		$menu_options[] = array(link=>$LANG_VARS['item_search'],img=>'item_search.gif',alt=>$LANG_VARS['item_search'],url=>"search.php");
		$menu_options[] = array(link=>$LANG_VARS['statistics'],img=>'statistics.gif',alt=>$LANG_VARS['user_db_stats'],url=>"stats.php");
		$menu_options[] = "-";
	
		if(is_user_admin($uid, $user_type) || is_user_normal($uid, $user_type) || is_user_borrower($uid, $user_type))
		{
			$menu_options[] = array(link=>$LANG_VARS['edit_my_info'],img=>'edit_my_info.gif',alt=>$LANG_VARS['user_detail_pwd'],url=>"user_admin.php?op=edit&uid=$uid");
		}
	
		if(!is_site_public_access_enabled())
		{
			$menu_options[] = "-";//spacer
			$menu_options[] = array(link=>$LANG_VARS['logout'],img=>'logout.gif',alt=>$LANG_VARS['logout_of_db'],url=>"logout.php");
		}
		
		if(is_user_admin($uid, $user_type))
		{
			$admin_options[] = array(link=>$LANG_VARS['add_new_user'],img=>'add_new_user.gif',alt=>$LANG_VARS['add_new_user'],url=>"user_admin.php?op=new_user");
			$admin_options[] = "-";//spacer
			$admin_options[] = array(link=>$LANG_VARS['user_list'],img=>'list_all_users.gif',alt=>$LANG_VARS['list_all_users_blurb'],url=>"user_listing.php?order_by=fullname&sortorder=ASC");
			
			// Is borrow functionality enabled?
			if($CONFIG_VARS['borrow.enable']!==FALSE && is_exists_history())
			{
				$admin_options[] = array(link=>$LANG_VARS['borrower_history'],img=>'borrower_history.gif',alt=>$LANG_VARS['borrower_history'],url=>"borrow.php?op=admin_history");
			}			
			
			$admin_options[] = array(link=>$LANG_VARS['email_users'],img=>'email_users.gif',alt=>$LANG_VARS['email_users'],url=>"email.php?op=send_to_all");
			$admin_options[] = "-";//spacer
		
			if(is_file_upload_enabled())
			{
				$admin_options[] = array(link=>$LANG_VARS['import_items'],img=>'import_items.gif',alt=>$LANG_VARS['import_items'],url=>"importcsv.php");
			}
			$admin_options[] = array(link=>$LANG_VARS['export_items'],img=>'export.gif',alt=>$LANG_VARS['export_items'],url=>"export.php");
			$admin_options[] = "-";//spacer
		
			$admin_options[] = array(link=>$LANG_VARS['view_log_file'],img=>'view_log_file.gif',alt=>$LANG_VARS['view_log_file'],url=>"logfile.php");
			$admin_options[] = array(link=>$LANG_VARS['backup_database'],img=>'backup_database.gif',alt=>replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['backup_db_blurb']),url=>"backup.php");
			$admin_options[] = array(link=>$LANG_VARS['system_admin_tools'],img=>'system_admin_tools.gif',alt=>$LANG_VARS['system_admin_tools'],url=>"admin.php");
			if($CONFIG_VARS['patch.enable'] === TRUE || $CONFIG_VARS['patch.allow_admin_override']===TRUE)
				$admin_options[] = array(link=>$LANG_VARS['patch_facility'],img=>'patch_facility.gif',alt=>$LANG_VARS['patch_facility'],url=>"patch.php");	
		}
		
		
		
	}//if(strlen($uid))
	else// non-authenticated user
	{
		//$menu_options[] = array(link=>$LANG_VARS['?????'],img=>'?????.gif',alt=>$LANG_VARS['?????'],url=>"?????");
	}
	
	return array(normal=>$menu_options,admin=>$admin_options);
}

// stub
function get_menu_options_with_images($uid, $user_type){return get_menu_options($uid, $user_type);}

/**
	Build up a list of valid menu options based on what type of $uid
	is passed in.  This assumes that session is valid at this point.

	This function groups menu items into a hierarchical structure,
	with the following groupings:

		+Item
			Add New Item
			Import My Items
			List All Items
			List My Items
			All Other Items
		+Borrow
			My History
			Items Borrowed
			Items Reserved
			Reservation Basket
			Item Check Out
			Item Check In
		+User
			Edit My Info

		-Item Search
		-Statistics

		+Admin
			Borrower History
			List All Users
			Add New User
			Import Items
			View Log File
			Backup Database

		-Logout

	This is designed for use by hierarchical menu building
	themes.
*/
function get_hierarchical_menu_options($uid, $user_type)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;

	// Authenticated user
	if(strlen($uid))
	{
		if(is_user_allowed_to_own($uid, $user_type))
		{
			$result = fetch_newitem_status_type_rs($uid);
			if($result && @mysql_num_rows($result))
			{
				while($status_type_r = mysql_fetch_array($result, MYSQL_ASSOC))
				{
					$menu_options['Item'][$LANG_VARS['add_new_item']][] = array(link=>$status_type_r['value'].' - '.$status_type_r['display'],alt=>$status_type_r['value'],url=>"item_add.php?s_status_type=".$status_type_r['value']);
				}
				mysql_free_result($result);
			}
			else
			{
				$menu_options['Item'][] = array(link=>$LANG_VARS['add_new_item'],alt=>$LANG_VARS['add_new_item'],url=>"item_add.php");
			}
			
			$menu_options['Item'][] = array(link=>$LANG_VARS['list_my_items'],alt=>$LANG_VARS['list_my_items'],url=>"listings.php?owner_id=$uid&order_by=title&sortorder=ASC");

			if($CONFIG_VARS['menu.other_items_listing']!==FALSE || $CONFIG_VARS['menu.all_items_listing']!==FALSE)
			{
				if($CONFIG_VARS['menu.other_items_listing']!==FALSE)
					$menu_options['Item'][] = array(link=>$LANG_VARS['list_other_items'],alt=>$LANG_VARS['list_other_items'],url=>"listings.php?not_owner_id=$uid&order_by=title&sortorder=ASC");
						
				if($CONFIG_VARS['menu.all_items_listing']!==FALSE)
					$menu_options['Item'][] = array(link=>$LANG_VARS['list_all_items'],alt=>$LANG_VARS['list_all_items'],url=>"listings.php?order_by=title&sortorder=ASC");
			}
			
			if(is_file_upload_enabled())
			{
				$menu_options['Item'][] = array(link=>$LANG_VARS['import_my_items'],alt=>$LANG_VARS['import_my_items'],url=>"importcsv.php?owner_id=$uid");
			}
			$menu_options['Item'][] = array(link=>$LANG_VARS['export_my_items'],alt=>$LANG_VARS['export_my_items'],url=>"export.php?owner_id=$uid");
			
		}//if(is_user_allowed_to_own($uid, $user_type))
		else
		{
			$menu_options['Item'][] = array(link=>$LANG_VARS['list_all_items'],alt=>$LANG_VARS['list_all_items'],url=>"listings.php?order_by=title&sortorder=ASC");
		}	
		
		// Is borrow functionality enabled?
		if($CONFIG_VARS['borrow.enable']!==FALSE && is_user_allowed_to_borrow($uid, $user_type))
		{
			$menu_options['Borrow'] = array();

			if(($CONFIG_VARS['borrow.list_all_borrowed']!==FALSE) || ($CONFIG_VARS['borrow.list_all_reserved']!==FALSE))
			{
				if($CONFIG_VARS['borrow.list_all_borrowed']!==FALSE && is_exists_borrowed())
					$menu_options['Borrow'][] = array(link=>$LANG_VARS['items_borrowed'],alt=>$LANG_VARS['items_borrowed'],url=>"borrow.php?op=all_borrowed");
				if($CONFIG_VARS['borrow.list_all_reserved']!==FALSE && is_exists_reserved())
					$menu_options['Borrow'][] = array(link=>$LANG_VARS['items_reserved'],alt=>$LANG_VARS['items_reserved'],url=>"borrow.php?op=all_reserved");
			}
			
			if(is_exists_borrower_history($uid))
				$menu_options['Borrow'][] = array(link=>$LANG_VARS['my_history'],alt=>$LANG_VARS['my_history'],url=>"borrow.php?op=my_history");
	
			if(is_exists_borrower_borrowed($uid))
				$menu_options['Borrow'][] = array(link=>$LANG_VARS['my_borrowed_items'],alt=>$LANG_VARS['my_borrowed_items'],url=>"borrow.php?op=my_borrowed");
	
			if(is_exists_borrower_reserved($uid))
				$menu_options['Borrow'][] = array(link=>$LANG_VARS['my_reserved_items'],alt=>$LANG_VARS['my_reserved_items'],url=>"borrow.php?op=my_reserved");
	
			if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing']))
				$menu_options['Borrow'][] = array(link=>$LANG_VARS['item_reserve_list'],alt=>$LANG_VARS['item_reserve_list'],url=>"borrow.php?op=my_reserve_basket&order_by=title&sortorder=ASC");

			if(is_user_allowed_to_own($uid, $user_type))
			{
				if(is_exists_owner_reserved($uid))
					$menu_options['Borrow'][] = array(link=>$LANG_VARS['item_check_out'],alt=>$LANG_VARS['item_check_out'],url=>"borrow.php?op=owner_reserved");
				if(is_exists_owner_borrowed($uid))
					$menu_options['Borrow'][] = array(link=>$LANG_VARS['item_check_in'],alt=>$LANG_VARS['item_check_in'],url=>"borrow.php?op=owner_borrowed");
			}
		}//if(is_user_allowed_to_borrow($uid, $user_type))

		if(is_user_admin($uid, $user_type) || is_user_normal($uid, $user_type) || is_user_borrower($uid, $user_type))
		{
			$menu_options['User'] = array();
			$menu_options['User'][] = array(link=>$LANG_VARS['edit_my_info'],alt=>$LANG_VARS['user_detail_pwd'],url=>"user_admin.php?op=edit&uid=$uid");
		}

		$menu_options['item_search'] = array(link=>$LANG_VARS['item_search'],alt=>$LANG_VARS['item_search'],url=>"search.php");
		$menu_options['statistics'] = array(link=>$LANG_VARS['statistics'],alt=>$LANG_VARS['user_db_stats'],url=>"stats.php");

		if(is_user_admin($uid, $user_type))
		{
			$menu_options['Admin'] = array();

			$menu_options['Admin'][] = array(link=>$LANG_VARS['add_new_user'],alt=>$LANG_VARS['add_new_user'],url=>"user_admin.php?op=new_user");
			$menu_options['Admin'][] = array(link=>$LANG_VARS['user_list'],alt=>$LANG_VARS['list_all_users_blurb'],url=>"user_listing.php?order_by=fullname&sortorder=ASC");
			
			// Is borrow functionality enabled?
			if($CONFIG_VARS['borrow.enable']!==FALSE && is_exists_history())
			{
				$menu_options['Admin'][] = array(link=>$LANG_VARS['borrower_history'],alt=>$LANG_VARS['borrower_history'],url=>"borrow.php?op=admin_history");
			}			
			
			$menu_options['Admin'][] = array(link=>$LANG_VARS['email_users'],alt=>$LANG_VARS['email_users'],url=>"email.php?op=send_to_all");
		
			if(is_file_upload_enabled())
			{
				$menu_options['Admin'][] = array(link=>$LANG_VARS['import_items'],alt=>$LANG_VARS['import_items'],url=>"importcsv.php");
			}
			$menu_options['Admin'][] = array(link=>$LANG_VARS['export_items'],alt=>$LANG_VARS['export_items'],url=>"export.php");

			$menu_options['Admin'][] = array(link=>$LANG_VARS['view_log_file'],alt=>$LANG_VARS['view_log_file'],url=>"logfile.php");
			$menu_options['Admin'][] = array(link=>$LANG_VARS['backup_database'],alt=>replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['backup_db_blurb']),url=>"backup.php");
			$menu_options['Admin'][] = array(link=>$LANG_VARS['system_admin_tools'],alt=>$LANG_VARS['system_admin_tools'],url=>"admin.php");
		
			if($CONFIG_VARS['patch.enable'] === TRUE || $CONFIG_VARS['patch.allow_admin_override']===TRUE)
				$menu_options['Admin'][] = array(link=>$LANG_VARS['patch_facility'],alt=>$LANG_VARS['patch_facility'],url=>"patch.php");
		}
		
		if(!is_site_public_access_enabled())
		{
			$menu_options['logout'] = array(link=>$LANG_VARS['logout'],alt=>$LANG_VARS['logout_of_db'],url=>"logout.php");
		}
	}//if(strlen($uid))
	else//non-authenticated user
	{
		//$menu_options['????'] = array(link=>$LANG_VARS['?????'],img=>'?????.gif',alt=>$LANG_VARS['?????'],url=>"?????");
	}
	return $menu_options;
}

// Utility functions
/*
* Will return a complete form menu option.  This is a basic form widget, and
* could be used as a basis of a more complex form action.
*/
function get_menu_option_form($option, $target=NULL)
{
	if(is_array($option['form']))
	{
		$form = "<form action=\"".ifempty($option['form']['action'],$option['url'])."\" ".(strlen($target)>0?"target=\"$target\"":"").">";
		while(list($name, $field) = each($option['form']['fields']))
		{
			// A select list is the only form field supported.
			if(is_array($field))
			{
				$form .= "<select name=\"$name\" class=\"menutext\">\n";
				while(list(,$row) = each($field))
				{
					$form .= "<option value=\"".$row['value']."\"".($row['checked_ind']=='Y'?' SELECTED':'').">".$row['value'];
					if(isset($row['display']))
					{
						if(strlen($row['value'])>0)
							$form .= " - ".$row['display'];
						else
							$form .= $row['display'];
					}
					$form .= "\n";
				}
				$form .= "</select>";
			}
			else if(strlen($field)>0)
			{ 
				$form .= "<input type=hidden name=\"$name\" value=\"$field\">";
			}
			else// only text field supported.
			{ 
				$form .= "<input class=\"menutext\" type=text name=\"$name\">";
			}
		}
		
		$form .= "<br />";
		$form .= "<input type=submit class=\"menutext\" value=\"".$option['link']."\">";
		$form .= "</form>";
		return $form;
	}
	else // no form element
		return FALSE;
}

/*
* A single column will force VERTICAL layout.
*/
function get_table_menu_options($options, $columns, $option_mask=NULL, $table_options_r, $target=NULL)
{
	$block = "<table cellpadding=1 border=0 ";
	if(is_array($table_options_r))
	{
		while(list($key,$value) = each($table_options_r))
			$block .= ($key."=\"".$value."\" ");
	}			
	$block .= ">";
	
	$count=0;
	while (list(,$option) = @each($options))
	{
		if($count==0)
			$block .= "<tr>";
		if($columns==1 || $option != "-")
		{
			$block .= "<td>";
			if($option == "-")
				$block .= "&nbsp";
			else if(is_array($option['form']))
				$block .= get_menu_option_form($option, $target);
			else //if($option != "-")//not spacer
			{
				
				$link = "<a href=\"".$option['url']."\" title=\"".$option['alt']."\"".(strlen($target)>0?"target=\"$target\"":"").">".str_replace(" ", "&nbsp;", $option['link'])."</a>";
				if($option_mask!=NULL)
					$link = str_replace("%option%", $link, $option_mask);
				$block .= $link;
			}				
			$block .= "</td>\n";
			
			$count++;
			if($count>=$columns)
			{
				$block .= "</tr>";
				$count=0;
			}
		}
	}
	
	if($count>0 && $count<$columns)
	{
		for($i=$count; $i<$columns; $i++)
			$block .= "<td>&nbsp;</td>";
			
		$block .= "</tr>";
	}
	$block .= "</table>";
	
	return $block;
}
?>