<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/item_type.php");
include_once("./functions/parseutils.php");
include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/site.php");
include_once("./functions/item.php");
include_once("./functions/user.php");
include_once("./functions/status_type.php");

function display_search_fields($HTTP_VARS, $item_r=NULL)
{
	global $CONFIG_VARS;
	global $LANG_VARS;

	// Site type's for specific s_item_type only.
	if(strlen($HTTP_VARS['s_item_type'])>0)
		$site_type_rs = fetch_site_type_rs($HTTP_VARS['s_item_type']);
	else // Else get all site type's available.
		$site_type_rs = get_site_type_r();

	// Order the array here.
	$site_type_rs = get_ordered_site_type_rs($site_type_rs);

	// At least one input field provided for user input.
	$input_field_provided=FALSE;

	while (list($key,$site) = @each($site_type_rs))
	{
		// Only plugins with an index.php file will be displayed here!
		if(is_legal_site($site))
		{
			// Start the ordered list off here.
			if(!$input_field_provided)
			{
				echo("<ol>");

				// Yes we have one.
				$input_field_provided=TRUE;
			}

			$site_r = get_site_config_r($site);
			
    		// Do not get s_item_type records if s_item_type already defined.  We would not be inside
        	// unless this site_type was compatible with the specified s_item_type...
    		if(strlen($HTTP_VARS['s_item_type'])==0)
				$results = fetch_site_item_type_rs($site);

			if(strlen($HTTP_VARS['s_item_type'])>0 || $results)
			{
				echo("<li><form action=\"site.php\" method=\"get\">");
				echo("\n<p><a target=\"_blank\" href=\"".$site_r['external_link']."\">");
				if(strlen($site_r['image'])>0)
				{
					echo("\n<img src=\"".$site_r['image']."\" title=\"".$site_r['title']."\" alt=\"".$site_r['title']."\" valign=absmiddle align=absmiddle border=0>");
				}
				echo("</a>");
				echo("&nbsp;".$site_r['description']."<br>");
				
				echo("\n<input type=hidden name=\"op\" value=\"search\">");
				echo("\n<input type=hidden name=\"site\" value=\"$site\">");
				
				// Let the item_input script validate the owner_id, just pass it through for now.
				if(strlen($HTTP_VARS['owner_id'])>0)
					echo("\n<input type=hidden name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");

				echo("\n<input type=hidden name=\"s_status_type\" value=\"".$HTTP_VARS['s_status_type']."\">");
				echo("\n<input type=hidden name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">");
				echo("\n<input type=hidden name=\"item_id\" value=\"".$HTTP_VARS['item_id']."\">");
				echo("\n<input type=hidden name=\"instance_no\" value=\"".$HTTP_VARS['instance_no']."\">");
				echo("\n<input type=hidden name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">");
				echo("\n<input type=hidden name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">");

				$fields = get_site_input_fields($site);
				while (list($key,$field) = @each($fields))
				{
					// Only if we are are refreshing an item.
					if(is_not_empty_array($item_r))
						$value = expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $field['refresh_mask']);
					else
						$value = $field['value'];
					
					// The format of the field is defined here.  Currently only 'hidden'
					// is supported, otherwise the default text field will be displayed.
					switch($field['type'])
					{
						case 'hidden':
							echo("\n<input type=hidden name=\"".$field['field']."\" value=\"$value\">\n");
							break;
						default:
							// If no prompt defined, don't try to display it!
							if(strlen($field['title'])>0)
							{
								echo("\n".$field['title'].": ");
							}	
							echo("\n<input type=text name=\"".$field['field']."\" value=\"$value\">\n");
					}
				}

   				if(is_exists_item_type($HTTP_VARS['s_item_type']))
				{
       		    	echo ("\n<input type=hidden name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">");
       	    	}
				else
				{
					echo("<br>");
					echo single_select("s_item_type", $results, "%value% - %display%", NULL, NULL);
				}
				echo("\n<input type=submit value=\"".replace_lang_var("site", $site_r['title'], $LANG_VARS['site_search'])."\">");
				echo("\n</p></form></li>\n");
			}
		}
	}

	if($item_r == NULL)
	{
		// Start the ordered list off here.
		if(!$input_field_provided)
		{
			echo("<ol>");

			// Yes we have one.
			$input_field_provided=TRUE;
		}

		echo("<li>");
		echo("<form action=\"item_input.php\" method=\"get\">");
		echo("\n<input type=hidden name=op value=\"new\">");
		
		// Let the item_input script validate the owner_id, just pass it through for now.
		if(strlen($HTTP_VARS['owner_id'])>0)
			echo("\n<input type=hidden name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");
			
		echo("\n<input type=hidden name=\"s_status_type\" value=\"".$HTTP_VARS['s_status_type']."\">");
		echo("\n<input type=hidden name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">");
		echo("\n<input type=hidden name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">");
		echo("\n<input type=hidden name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">");

		echo($LANG_VARS['manual_entry'].":");
		if(is_exists_item_type($HTTP_VARS['s_item_type']))
		{
	    	echo ("\n<input type=hidden name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">");
		}
		else
		{
			echo("<br>");
			$results = fetch_item_type_rs(TRUE);
	    	if($results)
			{
				echo single_select("s_item_type", $results, "%value% - %display%", NULL, NULL);
			}
		}

		echo("<input type=submit value=\"".$LANG_VARS['do_it_yourself']."\">");
		echo("</form>");
		echo("</li>");
	}

	// Indicates to caller whether we succeeded in providing at least one input field.
	if($input_field_provided)
	{
		echo("</ol>");
		return TRUE;
	}
	else
		return FALSE;
}

session_start();
if (is_opendb_valid_session())
{
	if ( is_user_allowed_to_own($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) ) 
	{
		if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
			$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
		
		// At least the item_id specified, now we check if item or item_instance.
		if(is_numeric($HTTP_VARS['item_id']))
		{
			if(is_not_empty_array($parent_item_r))
				$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
			else if(is_numeric($HTTP_VARS['instance_no']))
			{
				$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
			}
		}
		
		// New parent item.
		if(!is_array($parent_item_r) && !is_array($item_r))
		{
			if(!is_numeric($HTTP_VARS['item_id']))
			{
				if(strlen($HTTP_VARS['s_status_type'])>0)
					$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type']);
			
				if(is_array($status_type_r))
					$page_title = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['add_s_status_type_item']);
				else
					$page_title = $LANG_VARS['add_item'];
				echo _theme_header($page_title);

				if(is_exists_item_type($HTTP_VARS['s_item_type']))
					echo("<h2>".$page_title." ".get_item_image($HTTP_VARS['s_item_type'])."</h2>");
				else
					echo("<h2>".$page_title."</h2>");
								
				// If status_type for this item is closed, we must generate an error, as this is illegal.	
				if(!is_array($status_type_r) || $status_type_r['closed_ind'] != 'Y')
				{	
					if(!is_array($status_type_r) || $status_type_r['insert_ind'] == 'Y')
					{
						if(!is_array($status_type_r) || strlen($status_type_r['min_create_user_type'])==0 || in_array($status_type_r['min_create_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
						{
							// Do display choices dialog if refreshing an item!
							echo("<div class=\"colortext\">");
							echo("<b>".$LANG_VARS['you_have_several_choices']."</b><br><br>");
							echo($LANG_VARS['item_add_intro']."<br><br>");
							if(!display_search_fields($HTTP_VARS, $item_r))
								echo("</div><div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
							else
								echo("</div>");
						}
						else //if(in_array($status_type_r['min_create_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
						{
							echo("<div class=\"error\">".
								replace_lang_vars(array('usertype'=>get_usertype_description($HTTP_SESSION_VARS['user_type']),'s_status_type_desc'=>$status_type_r['description']),$LANG_VARS['s_status_type_create_access_disabled_for_usertype']).
								"</div>");
						}
					}
					else//if($status_type_r['insert_ind'] == 'Y')
					{
						echo("<div class=\"error\">".
								replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['operation_not_avail_s_status_type']).
								"</div>");
					}
				}
				else // if($status_type_r['closed_ind'] != 'Y')
				{
					echo("<div class=\"error\">".
						replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['s_status_type_not_supported']).
						"</div>");
				}
			}
			else //if(!is_numeric($HTTP_VARS['item_id']))
			{
				echo _theme_header($lang_var['item_not_found']);
				echo("<div class=\"error\">".$lang_var['item_not_found']."</div>");
			}
		}
		else if(is_not_empty_array($parent_item_r)) // Child item edit/add
		{
			$page_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($parent_item_r['title'], $parent_item_r['s_item_type'], $parent_item_r['item_id'], $parent_item_r['instance_no'], $parent_item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['edit_title']);
			echo _theme_header($page_title);
			echo("\n<h2>".$page_title." ".get_item_image($parent_item_r['s_item_type'])."</h2>");
			
			if(is_not_empty_array($item_r)) // Child item refresh
			{
				echo("\n<h3>".replace_lang_var("title", $item_r['title'], $LANG_VARS['refresh_linked_title'])." ".get_item_image($item_r['s_item_type'], NULL, TRUE)."</h3>\n");
			}
			else // Add new child item.
			{
				// Enforce the $s_item_type in this case.
				if($CONFIG_VARS['item_input.link_same_type_only']===TRUE)
				{
					$HTTP_VARS['s_item_type'] = $parent_item_r['s_item_type'];
					echo ("<h3>".$LANG_VARS['add_linked_item']." ".get_item_image($parent_item_r['s_item_type'])."</h3>\n");
				}
				else
					echo ("<h3>".$LANG_VARS['add_linked_item']."</h3>\n");
			}
			
			echo("<div class=\"colortext\">");
			if(!display_search_fields($HTTP_VARS, $item_r))
				echo("</div><div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
			else
				echo("</div>");
		}
		else if(is_not_empty_array($item_r)) // Parent item refresh
		{
			$HTTP_VARS['s_item_type'] = $item_r['s_item_type'];
			
			$page_title = replace_lang_vars(array('display_title'=>expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['refresh_title']);
			echo _theme_header($page_title);
			echo("<h2>".$page_title." ".get_item_image($item_r['s_item_type'])."</h2>\n");
			
			echo("<div class=\"colortext\">");
			if(!display_search_fields($HTTP_VARS, $item_r))
				echo("</div><div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
			else
				echo("</div>");
		}

		// Now the links...
		if($HTTP_VARS['item_link'] === "y" && is_exists_item_instance($HTTP_VARS['item_id'],$HTTP_VARS['instance_no']))
		{
			$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
		}

		if(is_array($parent_item_r))
		{
			//$footer_links_r[] = array(url=>"item_input.php?op=edit&item_id=".$HTTP_VARS['parent_id']."&instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['edit_parent']);
			$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['parent_id']."&instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
		}
		
		// Include a Back to Listing link.
		if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
		{
			$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
		}
	}//no guests allowed!
	else
	{				 
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}
	
	echo format_footer_links($footer_links_r);
	echo _theme_footer();
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
