<?php
//
// English language pack
//
$lang_var['days_abbrev'] = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
$lang_var['months_abbrev'] = array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
$lang_var['days_full'] = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
$lang_var['months_full'] = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

$lang_var['hours'] = 'Hours';
$lang_var['hour'] = 'Hour';
$lang_var['minutes'] = 'Minutes';
$lang_var['minute'] = 'Minute';

$lang_var['patch_facility'] = 'Patch Facility';

$lang_var['add_s_status_type_item'] = 'Add {s_status_type_desc} Item';

$lang_var['edit_title'] = 'Edit {display_title}';// {display_title} = $CONFIG_VARS['item_display.title_display_mask']
$lang_var['refresh_title'] = 'Refresh {display_title}';// {display_title} = $CONFIG_VARS['item_display.title_display_mask']
$lang_var['refresh_linked_title'] = 'Refresh linked "{title}"';// {display_title} = $CONFIG_VARS['item_display.title_display_mask']
$lang_var['update_title'] = 'Update {display_title}';// {display_title} = $CONFIG_VARS['item_display.title_display_mask']
$lang_var['update_item'] = 'Update Item';
$lang_var['delete_item'] = 'Delete Item';

$lang_var['s_status_type_items_cannot_be_borrowed'] = '{s_status_type_desc} items cannot be borrowed';
$lang_var['s_status_type_status_comments_not_supported'] = 'Status Comments not supported for {s_status_type_desc} items';
$lang_var['s_status_type_borrow_duration_not_supported'] = 'Borrow duration not supported for {s_status_type_desc} items';
$lang_var['operation_not_avail_s_status_type'] = 'Operation not available for {s_status_type_desc} items.';
$lang_var['invalid_s_status_type'] = 'Invalid Status Type ({s_status_type}) specified';

// For closed_ind = 'Y'
$lang_var['s_status_type_not_supported'] = '{s_status_type_desc} item support is disabled';

$lang_var['s_status_type_display_access_disabled_for_usertype'] = '{usertype} users are not permitted to display {s_status_type_desc} items.';
$lang_var['s_status_type_create_access_disabled_for_usertype'] = '{usertype} users are not permitted to create {s_status_type_desc} items.';

$lang_var['confirm_item_instance_update'] = 'Are you sure you want to update this item?';
$lang_var['confirm_clone_item'] = 'Are you sure you want to clone this item?';

$lang_var['include'] = 'Include';
$lang_var['exclude'] = 'Exclude';

// Refresh operation
$lang_var['old_value'] = 'Old';
$lang_var['new_value'] = 'New';

// Missing s_field_type relationships, most likely!!!
$lang_var['invalid_item_type_structure'] = 'The item type \'{s_item_type}\' has an illegal structure';

$lang_var['linked_item_must_be_type'] = 'Linked Item must be a {s_item_type} item type';
$lang_var['cannot_clone_linked_item'] = 'You cannot clone a linked item';
$lang_var['failed_to_clone_item'] = 'Item Clone failed.';
$lang_var['clone_title'] = 'Clone {display_title}';
$lang_var['clone_item'] = 'Clone Item';
$lang_var['coerce_child_item_types'] = 'Coerce Child Item Type(s)';
$lang_var['item_cloned'] = 'Item cloned';
$lang_var['item_not_cloned'] = 'Item not cloned';
$lang_var['clone_item_not_supported'] = 'Clone item support is disabled';

$lang_var['cannot_edit_item_not_owned'] = 'You cannot edit an item you do not own';
$lang_var['linked_items_not_supported'] = 'Linked item support is disabled';

$lang_var['update'] = 'Update';

// Newuser.php script variables
$lang_var['new_account'] = 'New {site} Account';
$lang_var['new_account_edit_info'] = 'New {site} Account (Edit Info)';
$lang_var['new_account_send_info'] = 'New {site} Account (Send Info)';
$lang_var['edit_info'] = 'Edit Info >';
$lang_var['send_info'] = 'Send Info >';
$lang_var['new_account_reply'] = 'Thank you for requesting a {site} account.';
$lang_var['new_account_add_user_url'] = 'You can use this URL to add the user to {site}:\n{url}';
$lang_var['new_account_usertype_intro'] = array(
		'N'=>"As a <i>Normal</i> user you have all the rights and privleges that a <i>Borrower</i> has, ".
			"with the added ability of maintaining a list of items within the Library. Any items you ".
			"add to the Library, you are agreeing to allow others to borrow. ".
			"When a member of the Library requests an item of yours, you must promptly send it to the ".
			"individual. You will need to give your full address and phone number so your items can be ".
			"sent back to you. This information will be verified prior to account creation.",
		'B'=>"With a <i>Borrower</i> account you can browse the library and borrow any on the ".
			"Items from within. You will need to give your full address and phone number so that ".
			"the items you borrow can be sent to you. This information will be verified prior to ".
			"account creation.");

// These may be removed in a later release.			
$lang_var['phone_number'] = 'Phone Number';
$lang_var['address'] = 'Address';
$lang_var['city'] = 'City';
$lang_var['state'] = 'State';
$lang_var['zip'] = 'Zip';
$lang_var['country'] = 'Country Code';
// end of newuser variables

// item_display/item_input variables
$lang_var['not_reviewed'] = 'Not reviewed by anyone yet.';
$lang_var['rating'] = 'Rating';
$lang_var['no_rating'] = 'No Rating';
$lang_var['review'] = 'Review';
$lang_var['review(s)'] = 'Review(s)';
$lang_var['instance_info'] = 'Instance Info';
$lang_var['status_info'] = 'Status Info';
$lang_var['current_item_instance'] = 'Current Item instance';
$lang_var['on_date_name_wrote_the_following'] = 'On {date} {fullname} wrote the following';//{date},{fullname},{user_id}
$lang_var['linked_item(s)'] = 'Linked Item(s)';
$lang_var['cancel_reservation'] = 'Cancel Reservation';
$lang_var['reserve_item'] = 'Reserve Item';
$lang_var['borrow_item'] = 'Borrow Item';
$lang_var['borrow_not_supported'] = 'Borrow functionality is disabled.';
$lang_var['quick_check_out'] = 'Quick Checkout';
$lang_var['not_applicable'] = 'N/A';
$lang_var['current_user'] = '<i>Current user</i>'; //{fullname}, {user_id}
$lang_var['user_name'] = '{fullname} ({user_id})'; //{fullname}, {user_id}
$lang_var['undefined'] = 'Undefined';
$lang_var['unknown'] = 'Unknown';
$lang_var['due_date_or_duration'] = 'Due Date /<br>Borrow Duration';
$lang_var['total_duration'] = 'Total Days';
$lang_var['overdue_duration'] = 'Days Overdue';
$lang_var['return_date'] = 'Returned';
$lang_var['reserve_date'] = 'Reserved';

$lang_var['use_item_duration'] = 'Use Item Duration';
$lang_var['override_duration'] = 'Override Duration';

// check_out will also be displayed for quick_check_out.
$lang_var['check_out_borrow_duration_moreinfo_help'] = 
											array('The <i>Use Item Duration</i> checkbox will force the check out process to use the duration value defined for the item instance, instead of the overriding <i>Override Duration</i> value included in the form.',
											'If you check the <i>Use Item Duration</i> checkbox and specify a <i>Override Duration</i>, it will be used for item instances with an <b>Undefined</b> duration, instead of overriding all durations.');

// external.php
$lang_var['external_url_error'] = 'No url specified.';
$lang_var['external_header_text'] = 'You are visiting an external web site.  To return to {site}, close this browser window.'; // vars {site}, {url}, {title}
$lang_var['external_noframes_link_text'] = 'Your browser does not support frames.  But you can still navigate to <a HREF="{url}">{url}</a>';

// whats new
$lang_var['whats_new'] = 'What\'s New';
$lang_var['cnt_review(s)'] = '{count} Review(s)';
$lang_var['cnt_item(s)_added_updated'] = '{count} {s_status_type_desc} Item(s) added/updated.';
$lang_var['cnt_item(s)_returned'] = '{count} Item(s) returned.';
$lang_var['cnt_item(s)_borrowed'] = '{count} Item(s) borrowed.';
$lang_var['cnt_item(s)_reserved'] = '{count} Item(s) reserved.';

$lang_var['add_linked'] = 'Add Linked';
$lang_var['new_item_instance'] = 'New Copy';
$lang_var['add_item_instance'] = 'Add Item Instance';

$lang_var['refresh'] = 'Refresh';
$lang_var['refreshed'] = 'Refreshed';

$lang_var['add_linked_item'] = 'Add linked item';
$lang_var['edit_linked_item'] = 'Edit linked item';
$lang_var['delete_linked_item'] = 'Delete linked item';
$lang_var['update_linked_item'] = 'Update linked item';
$lang_var['confirm_delete_title'] = 'Are you sure you want to permanently delete {display_title}?';
$lang_var['operation_not_avail_linked_items'] = 'Operation not available for linked items.';
$lang_var['operation_not_avail_new_instance'] = 'New Copy Operation not available.';

$lang_var['file_upload_error'] = 'Error uploading {prompt} file.';
$lang_var['url_save_error'] = 'Error saving {prompt} url.';
$lang_var['invalid_url_error'] = '{prompt} url cannot be saved.';

$lang_var['file_upload_not_available'] = 'File Upload not available.';
$lang_var['operation_not_available'] = 'Operation not available.';
$lang_var['yes'] = 'Yes';
$lang_var['no'] = 'No';

$lang_var['title_same_type_and_owner_exists'] = 'You already have a {s_item_type} item "{title}"';
$lang_var['confirm_title_same_type_and_owner_insert'] = 'You already have a {s_item_type} item "{title}".  Do you want to continue?';
$lang_var['title_same_type_exists'] = 'This {s_item_type} item "{title}" already exists.';
$lang_var['confirm_title_same_type_insert'] = 'This item "{title}" already exists.  Do you want to continue?';
$lang_var['title_linked_item_exists'] = 'This linked item "{title}" already exists.';
$lang_var['confirm_title_linked_item_insert'] = 'This linked item "{title}" already exists.  Do you want to continue?';

$lang_var['list_duplicate_title(s)'] = 'List Duplicate Title(s)';

$lang_var['cannot_delete_item_not_owned'] = 'You cannot delete an item you do not own';
$lang_var['cannot_update_item_not_owned'] = 'You cannot update an item you do not own';

$lang_var['item_deleted'] = 'Item deleted.';
$lang_var['item_not_deleted'] = 'Item not deleted.';
$lang_var['item_added'] = 'Item added.';
$lang_var['item_not_added'] = 'Item not added.';
$lang_var['item_instance_added'] = 'Item instance added.';
$lang_var['item_instance_not_added'] = 'Item instance not added.';
$lang_var['item_instance_updated'] = 'Item instance updated.';
$lang_var['item_instance_not_updated'] = 'Item instance not updated.';

$lang_var['item_updated'] = 'Item updated.';
$lang_var['item_not_updated'] = 'Item not updated.';
											 
$lang_var['add_item'] = 'Add Item';
$lang_var['save_item'] = 'Save Item';

$lang_var['edit_parent'] = 'Edit Parent';

$lang_var['no_records_found'] = 'No Records Found';
$lang_var['not_authorized_to_page'] = 'You are not authorized to access this page';

$lang_var['item_not_found'] = 'Item not found';
$lang_var['linked_item_not_found'] = 'Linked item not found';
$lang_var['parent_item_not_found'] = 'Parent item not found';

$lang_var['instance'] = '#';
$lang_var['owner'] = 'Owner';
$lang_var['location'] = 'Location';
$lang_var['status'] = 'Status';
$lang_var['back_to_parent'] = 'Back to Parent';
$lang_var['back_to_item'] = 'Back to Item';

// This refers to the generic item 'title'
$lang_var['title'] = 'Title';
$lang_var['action'] = 'Action';

// Reservation messages
$lang_var['item_reserved_or_borrowed'] = 'Item is currently reserved or borrowed';
$lang_var['item_has_inactive_borrowed_item'] = 'Item has inactive borrowed item record(s) attached.';

// item_add
$lang_var['you_have_several_choices'] = 'You have <i>several</i> choices:';
$lang_var['do_it_yourself'] = 'Do it yourself';
$lang_var['site_search'] = 'Search {site}';
$lang_var['manual_entry'] = 'Manual entry';
$lang_var['item_add_intro'] = 'Either you enter the data by connecting to one of the external sites (for example IMDb) or you can enter it yourself.  Be patient, this may take a few minutes.';

// item_review
$lang_var['review_title'] = 'Review {display_title}';
$lang_var['save_review'] = 'Save Review';
$lang_var['review_added'] = 'Your review has been recorded.';
$lang_var['review_not_added'] = 'Your review has not been recorded.';
$lang_var['review_updated'] = 'Your review has been updated.';
$lang_var['review_not_updated'] = 'Your review has not been updated.';
$lang_var['confirm_delete_review'] = 'Are you sure you want to delete the review?';
$lang_var['review_deleted'] = 'Review deleted.';
$lang_var['review_not_deleted'] = 'Review not deleted.';

// index
$lang_var['site_is_disabled'] = 'This site is currently disabled.';
$lang_var['try_again_later'] = 'Please try again later.';

//stats
$lang_var['statistics'] = 'Statistics';
$lang_var['status_stats'] = 'Status Stats';
$lang_var['borrow_stats'] = 'Borrow Stats';
$lang_var['general_facts'] = 'General Facts';
$lang_var['owner(s)'] = 'Owner(s)';
$lang_var['item(s)'] = 'Item(s)';
$lang_var['average_rating'] = 'Average Rating';
$lang_var['owner_information'] = 'Owner Information';
$lang_var['total'] = 'Total';
$lang_var['all_item_breakdown'] = 'Breakdown for all items';
$lang_var['item_ownership'] = 'Item Ownership';
$lang_var['item_types'] = 'Item Types';
$lang_var['database_ownership_piechart'] = 'DataBase Ownership Pie Chart';
$lang_var['database_itemtype_piechart'] = 'DataBase Item Types Pie Chart';
$lang_var['itemtype_breakdown'] = 'Breakdown for {desc} ({s_item_type}) items';
$lang_var['itemtype_items'] = '{count} Item(s)';
$lang_var['itemtype_ownership_piechart'] = '{s_item_type} Ownership Pie Chart';
$lang_var['itemtype_ownership'] = '{s_item_type} Ownership';
$lang_var['itemtype_category_piechart'] = '{s_item_type} Category Pie Chart';
$lang_var['itemtype_category'] = '{s_item_type} Category';
$lang_var['stats_help'] = array(
				'Click Owner to list their items.');

// backup
$lang_var['backup_database'] = 'Backup Database';
$lang_var['table'] = 'Table(s)';
$lang_var['format'] = 'Format';
$lang_var['sql_inserts'] = 'SQL Inserts';
$lang_var['delimiter'] = 'Delimiter';
$lang_var['send_as_file'] = 'Send as File';

//start export
$lang_var['item_id'] = 'Item';
$lang_var['parent_id'] = 'Parent';
$lang_var['owner_id'] = 'Owner';
$lang_var['instance_no'] = 'Instance';

$lang_var['s_item_type_group'] = 'Item Type Group';
$lang_var['s_item_type'] = 'Item Type';
$lang_var['s_status_type'] = 'Status';
$lang_var['status_comment'] = 'Status Comment';

$lang_var['export_items'] = 'Export Items';
$lang_var['export_my_items'] = 'Export My Items';

$lang_var['type_export_for_name_item_type'] = '{type} Export for {fullname} ({user_id}) [{s_item_type}]';
$lang_var['type_export_for_item_type'] = '{type} {s_item_type} Export';
$lang_var['type_export_for_item_instance'] = '{type} Export for {title} (item_id={item_id},instance_no={instance_no})';
$lang_var['type_export_for_item'] = '{type} Export for {title} (item_id={item_id})';
$lang_var['type_export_for_name'] = '{type} Export for {fullname} ({user_id})';
$lang_var['type_export_item_record'] = '{type} Record';
$lang_var['type_export'] = '{type} Export';
$lang_var['illegal_export_type'] = 'Illegal export ({type}) specified.';
// end export ***

// borrow
$lang_var['more_information'] = 'More Information';

$lang_var['continue'] = 'Continue';
$lang_var['cannot_reserve_items_you_own'] = 'You cannot reserve an item you own';
$lang_var['you_have_it_borrowed'] = 'You have it borrowed';
$lang_var['you_have_reservation'] = 'You have an existing reservation';
$lang_var['not_allowed_cancel_reserve'] = 'You are not allowed to cancel this reservation';
$lang_var['not_owner_of_item'] = 'You are not the owner of this item';
$lang_var['item_is_already_reserved'] = 'Item already reserved';
$lang_var['item_is_already_checked_out'] = 'Item already checked out';

$lang_var['invalid_borrower_user'] = 'Borrower {user_id} is not valid'; // {user_id} may be empty!
$lang_var['user_must_be_borrower'] = 'User \'{user_id}\' must be at least <i>Borrower</i> type.';

// Used for new purpose now - even though not new!
$lang_var['reservation_cancelled'] = '<i>Reservation cancelled</i>';

// Help entries for borrow.php
$lang_var['borrow_help'] = array('The <b>Borrow Duration</b> may be overriden by an owner when the item is checked out.');
$lang_var['borrow_item_history_help'] = array('If <b>Status</b> is <i>Checked In</i>, then date is <i>Returned</i> date.',
											'If <b>Status</b> is <i>Checked In</i> or <i>Checked Out</i> the duration is <i>Total Days</i>.');
$lang_var['reserve_basket_help'] = array('Items in your reservation basket, are <i>not</i> reserved, until you either \'Reserve Item(s)\' or \'Reserve All Item(s)\'.');

// -------------------------------------------------------
// New in 0.39
$lang_var['to_user_email_intro'] = 'Hi {fullname},';
$lang_var['borrow_item_title_listing'] = '{display_title}'; //{item_id}, {instance_no}
$lang_var['borrow_error_detail'] = 'Reason: <i>{error}</i>';
$lang_var['due_date'] = 'Due Date';

$lang_var['due_date_detail'] = 'Due/Duration: {date}/{borrow_duration} day(s)';
$lang_var['check_in_detail'] = 'Total/Overdue: {total_duration} day(s)/{overdue_duration} day(s)';

$lang_var['no_items_checked'] = 'No items checked';
$lang_var['already_cancelled'] = 'Item reservation already cancelled';
$lang_var['already_checked_in'] = 'Item already checked in';
$lang_var['borrow_duration'] = 'Borrow Duration';
$lang_var['borrowed_item_not_found'] = 'Borrowed item record not found';

$lang_var['notication_email_sent'] = '<i>Email notification has been sent</i>';
$lang_var['notication_email_not_sent'] = '<i>Email notification was not sent</i>';

$lang_var['item_reserve_list'] = 'My Reserve Basket';
$lang_var['item_in_reserve_list'] = 'In Reserve Basket';

$lang_var['item_reservation'] = 'Item Reservation';
$lang_var['items_have_been_registered'] = 'The following item(s) have been reserved:';
$lang_var['items_have_not_been_registered'] = 'The following item(s) were not reserved:';

$lang_var['item_cancel_reservation'] = 'Cancel item reservation';
$lang_var['reserve_items_have_been_cancelled'] = 'The following reservations for item(s) have been cancelled:';
$lang_var['reserve_items_have_not_been_cancelled'] = 'The following reservations for item(s) were not cancelled:';

$lang_var['items_have_been_checked_out'] = 'The following item(s) have been checked out:';
$lang_var['items_have_not_been_checked_out'] = 'The following item(s) were not checked out:';

$lang_var['items_have_been_checked_in'] = 'The following item(s) have been checked in:';
$lang_var['items_have_not_been_checked_in'] = 'The following item(s) were not checked in:';

$lang_var['check_in_reminder'] = 'Check In Reminder';
$lang_var['check_in_reminder_for_items'] = 'Check in reminder for the following items(s):';
$lang_var['check_in_reminder_not_for_items'] = 'No check in reminder for the following items(s):';

$lang_var['borrow_duration_extension'] = 'Extend Borrow Duration';
$lang_var['borrow_duration_extension_for_items'] = 'The following item(s) have had their borrow duration extended:';
$lang_var['borrow_duration_extension_not_for_items'] = 'The following item(s) did not have their borrow duration extended:';
$lang_var['borrow_duration_extension_must_be_specified'] = 'Borrow duration must be specified';

$lang_var['back_to_listing'] = 'Back to Listing';
$lang_var['back_to_user_listing'] = 'Back to User Listing';
$lang_var['reserve_item(s)'] = 'Reserve Item(s)';
$lang_var['reserve_all_item(s)'] = 'Reserve All Item(s)';
$lang_var['add_to_reserve_list'] = 'Add to Basket';
$lang_var['delete_from_reserve_list'] = 'Remove from Basket';
$lang_var['update_reserve_list'] = 'Update Basket';

$lang_var['cancel_reservation(s)'] = 'Cancel Reservation(s)';
$lang_var['check_out_item(s)'] = 'Check Out Item(s)';
$lang_var['check_in_item(s)'] = 'Check In Item(s)';
$lang_var['send_reminder(s)'] = 'Send Reminder(s)';
$lang_var['borrow_duration_extension(s)'] = 'Duration Extension(s)';
// ---------------------------------------------

// menu as well
$lang_var['items_borrowed'] = 'All Borrowed Items';
$lang_var['items_reserved'] = 'All Reserved Items';
$lang_var['item_check_in'] = 'Item Check In';
$lang_var['item_check_out'] = 'Item Check Out';
$lang_var['item_quick_check_out'] = 'Item Quick Check Out';
$lang_var['my_history'] = 'My History';
$lang_var['item_history'] = 'History';
$lang_var['history_for_title'] = 'History for {display_title}';
$lang_var['borrower_history'] = 'Borrower History';
$lang_var['borrower_history_for_fullname'] = 'History for {fullname} ({user_id})';

$lang_var['my_reserved_items'] = 'My Reserved Items';
$lang_var['my_borrowed_items'] = 'My Borrowed Items';

//borrow/listings
$lang_var['page_listing_index'] = 'Listing Items {first_row} to {last_row} of {total}';
$lang_var['show_item_image'] = 'Display Images';
$lang_var['previous_page'] = 'Previous Page';
$lang_var['next_page'] = 'Next Page';
$lang_var['check_in'] = 'Check In';
$lang_var['check_out'] = 'Check Out';
$lang_var['cancel'] = 'Cancel';
$lang_var['reserve'] = 'Reserve';
$lang_var['borrow'] = 'Borrow';
$lang_var['item'] = 'Item';
$lang_var['type'] = 'Type';

//item_input/item_display
$lang_var['edit'] = 'Edit';
$lang_var['delete'] = 'Delete';

//also used by site plugin
$lang_var['no_matches_found'] = 'No Matches Found';

$lang_var['category'] = 'Category';

//$lang_var['alpha_listing'] = 'Alphabetical Index:';

$lang_var['my_item_listing'] = 'My Items';
$lang_var['all_item_listing'] = 'All Items';
$lang_var['other_item_listing'] = 'Other Items';
$lang_var['my_s_status_type_item_listing'] = 'My {s_status_type_desc} Items';
$lang_var['all_s_status_type_item_listing'] = 'All {s_status_type_desc} Items';
$lang_var['other_s_status_type_item_listing'] = 'Other {s_status_type_desc} Items';

$lang_var['item_listing_for_name'] = 'Items for {fullname} ({user_id})';
$lang_var['s_status_type_item_listing_for_name'] = '{s_status_type_desc} Items for {fullname} ({user_id})';

$lang_var['all'] = 'All';
$lang_var['printable_version'] = 'Printable version';
$lang_var['item_reviewed'] = 'Item has been reviewed';
$lang_var['youve_borrow_or_return'] = 'You have previously borrowed this item';
$lang_var['printable_version_notes'] = 'The <i>Printable version</i> will display all {total} matching item(s)';

// Any help lines added here.
$lang_var['listings_help'] = array('Click a column heading to sort by that column',
									'Linked items cannot be reserved.');

//item_display/listings/stats
$lang_var['borrowed'] = 'Borrowed';
$lang_var['reserved'] = 'Reserved';

// borrow history
$lang_var['cancelled'] = 'Cancelled';
$lang_var['checked_in'] = 'Checked In';	
$lang_var['checked_out'] = 'Checked Out';

// New in 0.50-dev18
$lang_var['linked_item'] = 'Linked item';

//email
$lang_var['users'] = '{user_desc} Users';
$lang_var['to'] = 'To';
$lang_var['from'] = 'From';
$lang_var['subject'] = 'Subject';
$lang_var['message'] = 'Message';
$lang_var['message_sent_to'] = 'Message sent to';
$lang_var['message_not_sent_to'] = 'Message not sent to';
$lang_var['required'] = 'Required';
$lang_var['errors'] = 'Error(s)';
$lang_var['send_email'] = 'Send Email';
$lang_var['email_users'] = 'Email Users';
$lang_var['no_subject'] = 'No Subject';

// Supported variables here: {site},{version},{site_url}
$lang_var['email_footer'] = '{site} {version} - Open Lending Database Project.\n{site_url}';

// functions/email
$lang_var['invalid_from_address'] = 'Invalid <b>From</b> address.';
$lang_var['invalid_to_address'] = 'Invalid <b>To</b> address.';
$lang_var['invalid_subject'] = '<b>Subject</b> not specified.';

// invalidsession
$lang_var['session_invalid'] = 'Session Invalid.';
$lang_var['session_has_expired'] = 'Your session has expired or has been invalidated. Please re-login.';

//backup
$lang_var['tbl_dump_header'] = '{site} {version} [MYSQL-Dump]'; // {site}, {version}
$lang_var['backup_log_generated'] = 'Backup log generated: {date}';
$lang_var['dumping_data_for_table'] = 'Dumping data for table \'{table}\'';

//login
$lang_var['login_welcome'] = 'Welcome to <h1>{site}</h1> your site for sharing Stuff with friends.'; //version,site
// Define a message for logged in users.
$lang_var['logged_in_welcome'] = 'Welcome back to <h1>{site}</h1> your site for sharing Stuff with friends.'; //version,site

$lang_var['new_passwd_sent'] = 'Your new password has been sent to your email address.';
$lang_var['lost_password'] = 'Lost Password';
$lang_var['userid'] = 'Userid';
$lang_var['password'] = 'Password';
$lang_var['new_passwd_email'] = 'You are receiving this email because you have requested a new password.\nYou can change your password to something else once you have logged in.';
$lang_var['return_to_login_page'] = 'Return to Login Page';

$lang_var['error_updating_pwd'] = 'An error occured while updating your new password.';
$lang_var['error_sending_email'] = 'An error occured while sending the email.';
$lang_var['if_problem_persists_contact_your_administrator'] = 'If this problem persists, contact your <a href="{url}">{site} Administrator</a>.';
$lang_var['site_administrator'] = '{site} Administrator';

$lang_var['site_login'] = '{site} Login';//This is the login button on login page.
$lang_var['login_successful'] = 'Login successful';
$lang_var['login_failure'] = 'Login failure';
$lang_var['double_check_info'] = 'Double check your username and password.';
$lang_var['forgot_your_pwd'] = 'Forgot your password?';
$lang_var['id_like_to_join'] = 'Hi there, I\'d like to join your {site}';
$lang_var['sign_me_up'] = 'Sign me up!';

//logout
$lang_var['thanks_for_using'] = 'Thank you for using {site}. Come again soon.';
$lang_var['unable_to_logout'] = 'Unable to log out.';
$lang_var['logout'] = 'Logout';

//menu
$lang_var['uid_is_logged_in'] = '<b>{user_id}</b><br> is logged in';
$lang_var['add_new_item'] = 'Add New Item';
$lang_var['list_all_items'] = 'List All Items';
$lang_var['list_my_items'] = 'List My Items';
$lang_var['list_other_items'] = 'List Other Items';
$lang_var['user_db_stats'] = 'User and Database Statistics';
$lang_var['item_search'] = 'Item Search';
$lang_var['edit_my_info'] = 'Edit My Info';
$lang_var['edit_user_info'] = 'Edit User Info';
$lang_var['user_detail_pwd'] = 'User Details/Password';
$lang_var['logout_of_db'] = 'Log out of database';
$lang_var['admin'] = 'Admin';
$lang_var['system_admin_tools'] = 'System Admin Tools';
$lang_var['connected_to'] = 'Connected to {host}';

$lang_var['list_all_users'] = 'List All Users';
$lang_var['list_all_users_blurb'] = 'View/Edit user settings';
$lang_var['add_new_user'] = 'Add New User';
$lang_var['view_log_file'] = 'View log file';
$lang_var['backup_db_blurb'] = 'Backup {site} database tables';

$lang_var['import_items'] = 'Import Items';
$lang_var['import_my_items'] = 'Import My Items';

//search
$lang_var['updated'] = 'Updated';
$lang_var['one_day_ago'] = 'One Day ago';
$lang_var['one_week_ago'] = 'One Week ago';
$lang_var['one_month_ago'] = 'One Month ago';
$lang_var['one_year_ago'] = 'One Year ago';
$lang_var['specify_datetime'] = 'Specify a date/time';
$lang_var['exact_match'] = 'Exact';
$lang_var['word_match'] = 'Word match';
$lang_var['partial_match'] = 'Partial';

$lang_var['s_attribute_type_lookup'] = 'Attribute Type Lookup';
$lang_var['s_attribute_type'] = 'Attribute Type';
$lang_var['attribute_val'] = 'Attribute Value';

$lang_var['value'] = 'Value';
$lang_var['use_the_value_field'] = 'Use the value field';
$lang_var['order_by'] = 'Order By';
$lang_var['update_date'] = 'Update Date';
$lang_var['item_type'] = 'Item Type';
$lang_var['asc'] = 'Asc';
$lang_var['desc'] = 'Desc';
$lang_var['search_now'] = 'Search Now';

// The block down the bottom of the page.
$lang_var['search_help'] = array(
								'Use Boolean operators and nesting to search for combinations of words or phrases.'.
								'For Example:',
									array('Rambo AND III',
										'II OR III OR IV',
										'Rambo AND (II OR III)',
										'((2 OR II) AND (Rambo OR "First Blood")) NOT (III OR Box)'),
								'Use \'_\' wildcard for matching only <i>one</i> character and \'%\' wildcard for matching <i>any</i> number of characters.'.
								'For Example:',
									array('Searching for &quot;se_en&quot; could match, &quot;seven&quot; or &quot;seben&quot; or &quot;sewen&quot;',
										'Searching for &quot;%ve%&quot; could match, &quot;seven&quot; or &quot;fugitive&quot; or &quot;maverick&quot; or &quot;driver&quot;',
										'Searching for &quot;ve%&quot; could match, &quot;version&quot; or &quot;vex&quot; or &quot;vehicle&quot; or &quot;driver&quot;'),
								'If you use \'word\' match, some titles may not show up if the item has a \':\' (colon) as part of the title.  Include the \':\', or a wildcard to match such titles.'.
								'For Example:',
									array('The title \'Rambo: First Blood Part II\', would not be matched in <u>word</u> mode by the query: <i>Rambo AND II</i>.  You would need to '.
											'specify <i>%Rambo% AND II</i> instead.'),
								'If you use wildcards with a &quot;Title&quot; or &quot;Attribute&quot; word, the <u>Word / Partial</u> match options will be ignored for that word.',
								'Matches will be case INsensitive in all cases.'
							);											

// define our colors to select from
$lang_var['colors'] = array(
		Array('None', ''),
		Array('Red', '#FF0000'),
		Array('Orange', '#FF8C00'),
		Array('Green', '#00FF00'),
		Array('Blue', '#0000FF'),
		Array('Yellow', '#FFFF00'),
		Array('Cyan', '#00FFFF'),
		Array('Magenta', '#FF00FF'),
		Array('White', '#FFFFFF'),
		Array('Grey', '#C0C0C0'),
		Array('Beige', '#FAEBD7'),
		Array('Brown', '#A52A2A'),
		Array('Black', '#000000'),
		Array('Pink', '#FF69B4'),
		Array('Teal', '#008080'),
		Array('Aquamarine', '#7FFFD4'),
		Array('Lavender', '#F0F8FF'),
		Array('Purple', '#8A2BE2')
	);

$lang_var['log_file_options'] = 'Log File Options';
$lang_var['list_usagelog'] = 'List Usagelog';
$lang_var['highlight_usagelog'] = 'Highlight Usagelog';
$lang_var['clear_usagelog'] = 'Clear Usagelog';
$lang_var['backup_usagelog'] = 'Backup Usagelog';
$lang_var['download_usagelog'] = 'Download Usagelog';
$lang_var['are_you_sure'] = 'Are you sure?';
$lang_var['clear_log_warning'] = 'Clearing the log will permanently delete it from the server.  You may want to consider doing a <b>usagelog backup</b> or <b>download</b> first.';
$lang_var['log_cleared'] = 'Usagelog Cleared.';
$lang_var['log_not_cleared'] = 'Unable to clear log.';
$lang_var['enter_backup_filename'] = 'Enter filename to backup usagelog to';
$lang_var['backup_successful'] = 'Usagelog backup to {filename} successfully.';
$lang_var['backup_unsuccessful'] = 'Unable to make usagelog backup to {filename}.';
$lang_var['highlight_options'] = 'Highlight Options';
$lang_var['foreground'] = 'Foreground';
$lang_var['background'] = 'Background';
$lang_var['highlight_type'] = 'Highlight Type';
$lang_var['keyword'] = 'Keyword';
$lang_var['line'] = 'Line';
$lang_var['word'] = 'Word';
$lang_var['less_highlight_fields'] = 'Show Less Highlight Fields';
$lang_var['more_highlight_fields'] = 'Show More Highlight Fields';
$lang_var['log_file'] = 'Log File';
$lang_var['date'] = 'Date';
$lang_var['details'] = 'Details';
$lang_var['user_ip'] = 'User I.P.';
$lang_var['no_logfile_found'] = 'No logfile found.';
$lang_var['no_logfile_defined'] = 'No log file defined.';

// New in 0.50-dev15
$lang_var['apply_to_usagelog'] = 'Apply to usagelog';

//user_admin
$lang_var['confirm_your_type_change'] = 'You will no longer be a {usertype} User';
$lang_var['confirm_user_type_change'] = 'User \\\'{user_id}\\\' will no longer be a {usertype} User';

// The user types.
$lang_var['administrator'] = 'Administrator';
$lang_var['normal'] = 'Normal';
$lang_var['borrower'] = 'Borrower';
$lang_var['guest'] = 'Guest';

$lang_var['my_info'] = 'My Info';
$lang_var['user_list'] = 'User Listing';
$lang_var['user'] = 'User';
$lang_var['user_info'] = 'User Info';
$lang_var['create_new_user'] = 'Create New User Info';
$lang_var['user_added'] = 'User "{user_id}" added.';
$lang_var['user_not_added'] = 'User "{user_id}" <b>not</b> added.';
$lang_var['user_exists'] = 'User "{user_id}" already exists.';
$lang_var['user_not_found'] = 'User "{user_id}" not found.';
$lang_var['welcome_to_site'] = 'Welcome to {site}';
$lang_var['welcome_email'] = 'You are receiving this email because you have been invited to join {site}.\nYou can change your password to something else once you have logged in.';
$lang_var['welcome_email_sent'] = 'A welcome email has been sent to {fullname} ({user_id})';//supports {fullname}, and {user_id}
$lang_var['welcome_email_error'] = 'An error has occured while trying to send a welcome email to {fullname} ({user_id})';//supports {fullname}, and {user_id}

$lang_var['cannot_delete_yourself'] = 'You cannot delete yourself';
$lang_var['user_with_reviews_not_deleted'] = 'A review author cannot be deleted.';

$lang_var['user_with_borrows_not_deleted'] = 'A user with item(s) checked out to them cannot be deleted.';
$lang_var['user_with_owner_borrows_not_deleted'] = 'A user with item(s) checked out cannot be deleted.';

$lang_var['user_with_inactive_borrowed_items_not_deleted'] = 'A user with inactive borrowed item record(s) cannot be deleted.';
$lang_var['user_with_owner_inactive_borrowed_items_not_deleted'] = 'A user with items that have inactive borrowed item record(s) attached cannot be deleted.';

$lang_var['user_delete_not_supported'] = 'User deletion is not supported.';
$lang_var['user_deactivate_not_supported'] = 'User deactivation is not supported.';

$lang_var['user_delete'] = 'Delete User';
$lang_var['user_deleted'] = 'User deleted.';
$lang_var['user_not_deleted'] = 'User not deleted.';
$lang_var['confirm_user_delete'] = 'Are you sure you want to permanently delete user "{fullname}" ({user_id})?';//supports {fullname}, and {user_id}
$lang_var['confirm_user_delete_deactivate'] = 'Do you you want to deactivate user "{fullname}" ({user_id}) instead?';
		
$lang_var['cannot_deactivate_yourself'] = 'You cannot deactivate yourself';
$lang_var['user_with_borrows_not_deactivated'] = 'A user with item(s) checked out to them cannot be deactivated.';
$lang_var['user_with_owner_borrows_not_deactivated'] = 'A user with item(s) checked out cannot be deactivated.';

$lang_var['user_deactivate'] = 'Deactivate User';
$lang_var['user_deactivated'] = 'User deactivated.';
$lang_var['deactivated'] = 'Deactivated';
$lang_var['user_not_deactivated'] = 'User not deactivated.';
$lang_var['confirm_user_deactivate'] = 'Are you sure you want to deactivate user "{fullname}" ({user_id})?';//supports {fullname}, and {user_id}

$lang_var['user_updated'] = 'User updated.';
$lang_var['user_not_updated'] = 'User not updated.';

// New in 0.50
$lang_var['usertype_updated'] = 'User type updated.';
$lang_var['usertype_not_updated'] = 'User type not updated.';
$lang_var['usertype_not_updated_for_user_with_items'] = 'A user with items cannot be changed to a Borrower or Guest user.';
$lang_var['usertype_not_updated_for_user_with_borrow_or_reserve_items'] = 'A user with Reservations or Borrowed items cannot be changed to a Guest user.';

$lang_var['passwds_do_not_match'] = 'Passwords do not match.';
$lang_var['passwd_not_specified'] = 'Password not specified.';
$lang_var['passwd_changed'] = 'Password changed.';
$lang_var['passwd_not_changed'] = 'Password <b>not</b> changed.';
$lang_var['add_user'] = 'Add User';
$lang_var['update_user'] = 'Update User';
$lang_var['update_details'] = 'Update Details';
$lang_var['delete_user'] = 'Delete User';
$lang_var['deactivate_user'] = 'Deactivate User';
$lang_var['change_passwd'] = 'Change Password';
$lang_var['fullname'] = 'Fullname';
$lang_var['user_theme'] = 'Theme';
$lang_var['user_language'] = 'Language';
$lang_var['email'] = 'Email';
$lang_var['user_type'] = 'User Type';
$lang_var['last_visit'] = 'Last Visit';
$lang_var['never_logged_in'] = 'Never';
$lang_var['no_users_checked'] = 'No Users Checked';
$lang_var['user_listing_help'] = array(
					'Click User to list their items.');
$lang_var['send_welcome_email'] = 'Welcome email';
$lang_var['new_passwd'] = 'New Password';
$lang_var['confirm_passwd'] = 'Confirm';

$lang_var['user_add_help'] = array('A password will be auto-generated if not specified.');

// functions/formatfield
// The ' must be escaped thus \\\' because the "\'" needs to actually find its way into the
// javascript alert.  If we only used \', then the \ would disappear!!
$lang_var['prompt_must_be_specified'] = '{prompt} must be specified.';
$lang_var['email_is_not_valid'] = '{prompt} must be a valid email address.';
$lang_var['filename_is_not_valid'] = '{prompt} filename must have a valid extension. ({extensions})';
$lang_var['url_is_not_valid'] = '{prompt} url must have a valid extension. ({extensions})';
$lang_var['url_already_saved_local'] = '{prompt} url is already saved locally.';
$lang_var['prompt_must_be_format'] = '{prompt} must be {format} format.';

$lang_var['save'] = 'Save';
$lang_var['view'] = 'View';
$lang_var['clear'] = 'Clear';
$lang_var['file_not_found'] = 'File not found';
// Used in upload, saveurl and upload_or_saveurl widgets
$lang_var['upload_prompt'] = 'Upload {prompt}';
$lang_var['saveurl_prompt'] = '{prompt} Url';

$lang_var['list_items_with_same_prompt'] = 'List items with same {prompt}';
$lang_var['search_results'] = 'Search Results';
$lang_var['search_query'] = 'Search Query';

//
// Import
//
$lang_var['type_import'] = '{type} Import';
$lang_var['illegal_import_type'] = 'Illegal import ({type}) specified.';

$lang_var['none'] = 'None';
$lang_var['undefined_error'] = 'Undefined Error Occurred';
$lang_var['title_exists'] = 'Title already exists';
$lang_var['ignore_title_exists'] = 'Allow Duplicate Titles';
$lang_var['specify_title'] = 'Title must be specified.';
$lang_var['file'] = 'File';

$lang_var['import_type_column_mapping'] = 'Define {type} Column mappings';
$lang_var['import_type_column_mapping_preview'] = 'Define {type} Column mappings (<i>Preview</i>)';
$lang_var['import_type_process_file'] = 'Process {type} File';
$lang_var['import_type_process_file_trial'] = 'Process {type} File (<i>Trial</i>)';
$lang_var['import_type_upload_file'] = 'Upload {type} File';

$lang_var['item_type_column'] = 'Item Type Column';
$lang_var['include_first_line'] = 'Include first line';
$lang_var['column'] = 'Column';
$lang_var['default'] = 'Default';
$lang_var['trial_run'] = 'Trial Run';
$lang_var['initcap'] = 'Initcap';
$lang_var['attributes'] = 'Attributes';
$lang_var['skipped'] = 'Skipped';
$lang_var['no_items_added'] = 'No items added';
$lang_var['back'] = 'Back';

// Like whatsnew, except whats new is {count} Item(s) added/updated
// so this is why we need a separate one here!
$lang_var['list_imported_items'] = 'List Imported Item(s)';//{count}

//
// CSV Specific Help
//
$lang_var['import_csv_help'] = array(
			'Any columns that include the delimiter should be &quot;...&quot; quoted.',
			'The CSV file should have a single header line, which will be ignored when the import takes place.',
			'For <b>Preview mode</b> click the <i>\'Continue\'</i> button without choosing a CSV File.',
			'Data Interchange Format (DIF) files are also supported.  Just be sure you upload a file with either a .csv or .dif extension.');

$lang_var['import_csv_column_mapping_help'] = array(
			'The <i>Item Type Column</i> is the column in the CSV data which specifies a item type (CD,VHS,VCD,DVD,etc).&nbsp;&nbsp;The rows will be restricted to only the rows that have the same type as the selected s_item_type.',
			'Unfortunately in order for the import to work properly, when dealing with attributes, you must supply the \'value\', not the \'display\' column from the s_attribute_type_lookup, otherwise there will be no match.',
			'The Default values are only used if a column is not selected from CSV file.',
			'If you do not specify a Category, a empty category will be inserted.',
			'\'Initcap\' will -except for the first letter in each word- set everything to lowercase.  Any uppercase roman numerals up to XX will not be initcap\'d.');
			
//
// Site plugins
//
$lang_var['you_searched_for'] = 'You searched for "{search}"';
$lang_var['title_search'] = '{sitetitle} Search';
$lang_var['site_new_search'] = 'New Search';
$lang_var['site_page_redirect'] = 'Please wait...<br><br>If you are not redirected in a few seconds, you can <i><u><a href="{url}">click here...</a></u></i>';

$lang_var['url_not_available'] = 'The URL <u>{url}</u> is not available.';//Variables {url}, {error} are available.

$lang_var['this_blurb_suits_me'] = 'This {prompt} please';
$lang_var['no_blurb'] = 'No {prompt}';

$lang_var['more_info'] = 'More Info';
$lang_var['trailer'] = 'Trailer';
$lang_var['screenshots'] = 'Screenshots';

// New in 0.50-dev13
$lang_var['most_popular_titles'] = 'Most popular title(s)';
$lang_var['cnt_titles_found'] = '{count} title(s) found';
$lang_var['show_all_cnt_titles'] = 'Show all {count} title(s)';
$lang_var['the_following_titles_matched'] = 'The following titles matched <u>{search}</u><br>(Years searched: {year-1} to {year-2})';

// ----------------------------------------------------------------
// These are actual site plugin configuration items, which is
// why they are specifically named.
//
// These values will be used by functions/site.php to expand the 
// input_field title value to the language dependent value.  You
// need to be sure that your input_fields key value matches that
// used by the plugin itself.
// ----------------------------------------------------------------
$lang_var['site']['imdb'] = array('description'=>'<i>The</i> source of movie information, but with nothing specific to distribution formats such as DVD and VHS.',
								'input_fields'=>array('title'=>'Title Search'));

$lang_var['site']['freedb'] = array('description'=>'A free approach to cddbp.',
								'input_fields'=>array('words'=>'<i>Artist / Title</i> Search'));
?>
