# --------------------------------------------------------
# OpenDb MySQL Install Script
# --------------------------------------------------------

#
# Table structure for table 'user'
#
DROP TABLE IF EXISTS user;
CREATE TABLE user (
  user_id		varchar(20) NOT NULL,
  fullname		varchar(100) NOT NULL,
  pwd			varchar(40) NOT NULL,
  type			varchar(1) NOT NULL default 'N',
  location		varchar(50) NOT NULL,
  email			varchar(50) NOT NULL,
  language		varchar(10),
  theme			varchar(10),
  lastvisit		datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY ( user_id )
) TYPE=MyISAM COMMENT='User table';

#
# Dumping data for table 'user'
#

INSERT INTO user (user_id, fullname, pwd, type, location, email) VALUES ( 'test', 'Test User', '098f6bcd4621d373cade4e832627b4f6', 'A', 'local', 'jasonpell@hotmail.com');

#
# Table structure for table 'borrowed_item'
#
DROP TABLE IF EXISTS borrowed_item;
CREATE TABLE borrowed_item (
  sequence_number	integer(10) unsigned NOT NULL auto_increment,
  item_id			integer(10) unsigned NOT NULL,
  instance_no		smallint(5) unsigned NOT NULL,
  borrower_id		varchar(20) NOT NULL,
  borrow_duration	smallint(3) unsigned,
  total_duration	smallint(3) unsigned,
  status			varchar(1) NOT NULL,
  update_on			timestamp(14) NOT NULL,
  PRIMARY KEY ( sequence_number ),
  KEY borrower_idx ( borrower_id ),
  KEY item_instance_idx ( item_id, instance_no )
) TYPE=MyISAM COMMENT='Borrowed Item table';

#
# Table structure for table 'review'
#
DROP TABLE IF EXISTS review;
CREATE TABLE review (
  sequence_number	integer(10) unsigned NOT NULL auto_increment,
  author_id		varchar(20) NOT NULL,
  item_id		integer(10) unsigned NOT NULL,
  comment		text,
  rating		varchar(1) NOT NULL,
  update_on		timestamp(14) NOT NULL,
  PRIMARY KEY ( sequence_number ),
  KEY author_idx ( author_id ),
  KEY item_idx ( item_id )
) TYPE=MyISAM COMMENT='Item Review table';

#
# Table structure for table 'item'
#
DROP TABLE IF EXISTS item;
CREATE TABLE item (
  id			integer(10) unsigned NOT NULL auto_increment,
  parent_id		integer(10) unsigned,
  title			varchar(255) NOT NULL,
  category		varchar(100),
  s_item_type	varchar(10) NOT NULL,
  PRIMARY KEY ( id ),
  KEY title_idx ( title ),
  KEY s_item_type_idx ( s_item_type )
) TYPE=MyISAM COMMENT='Item table';

#
# Item instance table.
#
DROP TABLE IF EXISTS item_instance;
CREATE table item_instance (
  item_id			bigint(10) unsigned NOT NULL,
  instance_no		smallint(5) unsigned NOT NULL,
  owner_id			varchar(20) NOT NULL,
  borrow_duration	smallint(3) unsigned,
  s_status_type		varchar(1) NOT NULL default 'Y',
  status_comment 	varchar(255),
  update_on			timestamp(14) NOT NULL,
  PRIMARY KEY ( item_id, instance_no ),
  KEY owner_id_idx ( owner_id ),
  KEY s_status_type_idx ( s_status_type )
) TYPE=MyISAM COMMENT='Item Instance table';

#
# Table structure for table 'item_attribute'
#
DROP TABLE IF EXISTS item_attribute;
CREATE TABLE item_attribute (
  item_id			integer(10) unsigned NOT NULL,
  s_attribute_type	varchar(10) NOT NULL,
  order_no			tinyint(3) unsigned NOT NULL,
  attribute_val		text NOT NULL,
  update_on			timestamp(14) NOT NULL,
  PRIMARY KEY ( item_id, s_attribute_type, order_no )
) TYPE=MyISAM COMMENT='Item Attribute table';

#
# System Item Status table
#
DROP TABLE IF EXISTS s_status_type;
CREATE table s_status_type (
	s_status_type				varchar(1) NOT NULL default 'Y',
	description					varchar(30) NOT NULL,
    img							varchar(255),
	insert_ind					varchar(1) NOT NULL default 'Y',
	update_ind					varchar(1) NOT NULL default 'Y',
	delete_ind					varchar(1) NOT NULL default 'Y',
    min_display_user_type		varchar(1),
	min_create_user_type		varchar(1),
	new_owner_instance_ind		varchar(1) NOT NULL default 'Y',
	new_not_owner_instance_ind	varchar(1) NOT NULL default 'Y',
	borrow_ind					varchar(1) NOT NULL default 'Y',
	status_comment_ind			varchar(1) NOT NULL default 'N',
	default_ind					varchar(1),
	closed_ind					varchar(1) NOT NULL default 'N',
	PRIMARY KEY ( s_status_type )
) TYPE=MyISAM COMMENT='System Item Status table';

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('A', 'Available', 'avail.gif', 'Y', 'Y', 'Y', 'G', 'N', 'Y', 'Y', 'Y', 'N', 'Y', 'N');

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('H', 'Hidden', 'hidden.gif', 'Y', 'Y', 'Y', 'A', 'N', 'Y', 'Y', 'Y',  'N', '', 'N');

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('N', 'Inactive', 'inactive.gif', 'Y', 'Y', 'Y', 'G', 'N', 'Y', 'Y', 'N',  'Y', '', 'N');

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('O', 'Ordered', 'ordered.gif', 'Y', 'Y', 'Y', 'G', 'N', 'N', 'Y', 'X',  'Y', '', 'N');

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('W', 'Wishlist', 'wishlist.gif', 'Y', 'Y', 'Y', 'G', 'N', 'N', 'Y', 'X',  'Y', '', 'N');

INSERT INTO s_status_type ( s_status_type, description, img, insert_ind, update_ind, delete_ind, min_display_user_type, min_create_user_type, new_owner_instance_ind, new_not_owner_instance_ind, borrow_ind, status_comment_ind, default_ind, closed_ind )
VALUES ('X', 'External', 'external.gif', 'N', 'Y', 'N', 'G', 'N', 'Y', 'Y', 'N',  'H', '', 'N');

#
# Table structure for table 's_item_type'
#
DROP TABLE IF EXISTS s_item_type;
CREATE TABLE s_item_type (
  s_item_type		varchar(10) NOT NULL,
  description		varchar(60) NOT NULL,
  image				varchar(255),
  default_site_type	varchar(10),
  order_no			tinyint(2),
  PRIMARY KEY ( s_item_type )
) TYPE=MyISAM COMMENT='System Item Type table';

#
# Dumping data for table 's_item_type'
#
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'DVD', 'Digital Versatile Disc', 'dvd.gif', 'imdb', '0');
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'VHS', 'VHS Video', 'vhs.gif', 'imdb', '1');
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'CD', 'Compact Disc', 'cd.gif', 'freedb', '2');
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'DIVX', 'DivX Video', 'divX.gif', 'imdb', '3');
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'VCD', 'Video Disc', 'vcd.gif', 'imdb', '4');
INSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( 'LD', 'Laser Disc', 'ld.gif', 'imdb', '5');

# --------------------------------------------------------

#
# Table structure for table 's_attribute_type'
#
DROP TABLE IF EXISTS s_attribute_type;
CREATE TABLE s_attribute_type (
  s_attribute_type	varchar(10) NOT NULL,
  description		varchar(60) NOT NULL,
  prompt			varchar(30) default NULL,
  input_type		varchar(255),
  display_type		varchar(255),
  s_field_type		varchar(10),
  site_type			varchar(10),
  PRIMARY KEY ( s_attribute_type )
) TYPE=MyISAM COMMENT='System Attribute table';

#
# Dumping data for table 's_attribute_type'
#
# Special attributes for configuring input_type for S_TITLE and S_STATUS
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'S_TITLE', 'Item Title', 'Title', 'text(50,255)', 'hidden', 'TITLE', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'S_STATUS', 'System Status Type', 'Status Type', NULL, 'hidden', 'STATUSTYPE', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'S_STATCMNT', 'System Status Comment', 'Status Comment', 'textarea(50,5)', 'hidden', 'STATUSCMNT', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'ALT_TITLE', 'Alternate Title', 'Alternate Title', 'text(50)', 'display(%value%)', '', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'ACTORS', 'List of Actors in a movie', 'Actors', 'text(50)', 'list(plain, ",", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIRECTOR', 'Director of a Movie', 'Director', 'text(50)', 'list(plain, ",", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'RUN_TIME', 'Running time','Length', 'number(4, %field% <i>minutes</i>)', 'format_mins(%h %H %m %M)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AUDIO_LANG', 'Audio Languages', 'Language', 'checkbox_grid(%img% %display%, 3)', 'display(%img% %display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'SUBTITLES', 'Subtitle languages', 'Subtitles', 'checkbox_grid(%img% %display%, 4)', 'display(%img% %display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AGE_RATING', 'Age Recommendation', 'Age', 'radio_grid(%img% %display%, 1)', 'display(%img%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'MOVIEGENRE', 'Movie Genre', 'Genre', 'checkbox_grid(%display%, 4)', 'category(%display%, list-link)', 'CATEGORY', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IMAGEURL', 'Item Image URL', 'Image', 'upload_or_saveurl(50,*,"gif,jpg,png")', 'hidden', 'IMAGE', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DVD_EXTRAS', 'DVD Extra Features Details', 'Extras', 'textarea(50,5)', 'list(ticks)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DVD_REGION','DVD Region', 'Region', 'checkbox_grid(%value% - %display%, 1)', 'list(plain, " ", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'RATIO', 'Aspect Ratio of Movie', 'Aspect Ratio', 'checkbox_grid(%value%, *)', 'list(plain, " ", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'VID_FORMAT', 'Encoding Format of Video','Video Format', 'single_select(%value%)', 'display(%value%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'VHS_TYPE', 'Video Type', 'VHS Format', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'VIDQUALITY', 'Quality of Video', 'Quality', 'radio_grid(%display%, *)', 'display(%display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'COMMENTS', 'Extra Comments', 'Comments', 'textarea(50,5)', 'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'MOVIE_PLOT', 'Plot of a Movie', 'Plot', 'textarea(50,5)', 'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'YEAR', 'Year of Release', 'Year', 'number(4)', 'display(%value%, list-link)', NULL, NULL);

# CD Attributes
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'ARTIST', 'Music Artist', 'Artist', 'text(50)', 'list(plain, ",", list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'CDTRACK', 'CD Track Title', 'Track', 'text(30)', 'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'CDTIME', 'CD Play Length', 'Time', 'text(6)', 'display(%value%)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'MUSICGENRE', 'Music Style', 'Style', 'single_select(%display%)', 'category(%display%, list-link)', 'CATEGORY', NULL);

# DivX Attributes
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXVIDVER', 'Video Codec Version', 'Video Codec', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXAUDVER', 'Audio Codec Version', 'Audio Codec', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXQUALIT', 'DIVX Quality', 'Quality', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 

# Freedb Site Attributes
# This attribute is specific genre as recorded by client program, there is no way to know what will be specified before hand.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'CDDBGENRE', 'CDDB Genre', 'Genre', 'hidden', 'hidden', NULL, 'freedb');
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'FREEDB_ID', 'Freedb ID', 'Disc ID', 'hidden', 'hidden', NULL, 'freedb');

# IMDB Site Attributes
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IMDB_ID', 'ImDb ID', 'Imdb ID', 'hidden', 'hidden', NULL, 'imdb');
# The TRAILER attribute is not currently used.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'TRAILER', 'ImDb Trailer', 'Trailer', 'hidden', 'hidden', NULL, 'imdb');

#
# This attribute is reserved for use in item_review.  Please do not use it for your own s_item_attribute_type structures.
# Note: display_type will be ignored when review actually displayed!!!
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ('S_RATING', 'Item Rating', 'Rating', 'review_options(%display%, VERTICAL)', NULL, '', NULL);

#
# This attribute is reserved for use in Borrow Duration functionality.  Please do not use it for your own s_item_attribute_type structures.
# If you want you could run this update to change the input type for S_DURATION a numeric input field instead:
# UPDATE s_attribute_type SET input_type = 'number(3, %field% <i>days</i>)' WHERE s_attribute_type = 'S_DURATION'
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ('S_DURATION', 'Borrow Duration', 'Borrow Duration', 'single_select(%display%)', 'display(%display%)', 'DURATION', NULL);

#
# Used to display item.id in item_display.php script.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'S_ITEM_ID', 'OpenDb Item ID', 'ID#', 'hidden', 'hidden', 'ITEM_ID', NULL);

#
# Table structure for table 's_item_attribute_type'
#
DROP TABLE IF EXISTS s_item_attribute_type;
CREATE TABLE s_item_attribute_type (
  s_item_type		varchar(10) NOT NULL,
  s_attribute_type	varchar(10) NOT NULL,
  order_no		tinyint(3) unsigned NOT NULL,
  prompt		varchar(30),
  compulsory_ind	varchar(1),
  PRIMARY KEY ( s_item_type, s_attribute_type, order_no )
) TYPE=MyISAM COMMENT='System Item Attribute table';

#
# Dumping data for table 's_item_attribute_type'
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'MOVIE_PLOT', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'DIRECTOR', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'ACTORS', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'MOVIEGENRE', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'YEAR', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'RUN_TIME', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AUDIO_LANG', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'SUBTITLES', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AGE_RATING', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'DVD_REGION', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'RATIO', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'VID_FORMAT', '120', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'DVD_EXTRAS', '130', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'S_STATCMNT', '255', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'MOVIE_PLOT', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'DIRECTOR', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'ACTORS', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'MOVIEGENRE', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'YEAR', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'RUN_TIME', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'AUDIO_LANG', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'SUBTITLES', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'AGE_RATING', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'RATIO', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'VID_FORMAT', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'COMMENTS', '120', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'S_STATCMNT', '255', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'MOVIE_PLOT', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'DIRECTOR', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'ACTORS', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'MOVIEGENRE', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'YEAR', '50', NULL,NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'RUN_TIME', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'SUBTITLES', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'AGE_RATING', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'VID_FORMAT', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'VIDQUALITY', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'COMMENTS', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'S_STATCMNT', '255', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'MOVIE_PLOT', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'DIRECTOR', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'ACTORS', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'MOVIEGENRE', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'YEAR', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'RUN_TIME', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'SUBTITLES', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'AGE_RATING', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'VID_FORMAT', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'VHS_TYPE', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'VIDQUALITY', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'COMMENTS', '120', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'S_STATCMNT', '255', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'FREEDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDDBGENRE', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'S_TITLE', '1', 'CD Title', 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'ARTIST', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'MUSICGENRE', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTIME', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'YEAR', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '50', 'Track 1', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '51', 'Track 2', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '52', 'Track 3', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '53', 'Track 4', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '54', 'Track 5', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '55', 'Track 6', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '56', 'Track 7', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '57', 'Track 8', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '58', 'Track 9', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '59', 'Track 10', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '60', 'Track 11', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '61', 'Track 12', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '62', 'Track 13', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '63', 'Track 14', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '64', 'Track 15', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '65', 'Track 16', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '66', 'Track 17', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '67', 'Track 18', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '68', 'Track 19', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '69', 'Track 20', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'S_STATCMNT', '255', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'MOVIE_PLOT', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIRECTOR', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'ACTORS', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'MOVIEGENRE', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'YEAR', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'RUN_TIME', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AUDIO_LANG', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'SUBTITLES', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AGE_RATING', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'RATIO', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXVIDVER', '120', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXAUDVER', '130', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXQUALIT', '140', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DVD_FORMAT', '150', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DVD_EXTRAS', '160', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_STATCMNT', '255', NULL, NULL);

# --------------------------------------------------------

#
# Table structure for table 's_attribute_type_lookup'
#
DROP TABLE IF EXISTS s_attribute_type_lookup;
CREATE TABLE s_attribute_type_lookup (
  s_attribute_type	varchar(10) NOT NULL,
  order_no		tinyint(3) unsigned,
  value			varchar(100) NOT NULL,
  display		varchar(255),
  img			varchar(255),
  checked_ind		varchar(1),
  PRIMARY KEY ( s_attribute_type, value )
) TYPE=MyISAM COMMENT='System Attribute Type Lookup table';

#
# Dumping data for table 's_attribute_type_lookup'
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '1', 'United States & Canada', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '2', 'Europe, Near East, South Africa & Japan', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '3', 'South East Asia', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '4', 'Australasia, Middle & South America', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '5', 'Africa, Asia, Eastern Europe', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '6', 'People\'s Republic of China', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_REGION', NULL, '0', 'No Region Encoding', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '1.33', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '1.78', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '1.85', NULL, NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '2.35', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '2.78', NULL, NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VID_FORMAT', NULL, 'NTSC', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VID_FORMAT', NULL, 'PAL', NULL, NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VID_FORMAT', NULL, 'SECAM', NULL, NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VHS_TYPE', NULL, 'PIRATED', 'Pirated/Copied', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VHS_TYPE', NULL, 'TV', 'TV Recording', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VHS_TYPE', NULL, 'PRERECORD', 'Pre-Recorded', NULL, 'Y');

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VIDQUALITY', NULL, '1', 'Excellent', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VIDQUALITY', NULL, '2', 'Good', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VIDQUALITY', NULL, '3', 'Fair', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VIDQUALITY', NULL, '4', 'Poor', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'VIDQUALITY', NULL, '5', 'Awful', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '0', 'G', 'General Exhibition', 'G.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '1', 'PG', 'Parental Guidance Recommended', 'PG.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '2', 'M', 'Mature Audience Recommended', 'M.gif', 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '3', 'MA', 'Mature Audience', 'MA.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '4', 'R', 'Restricted 18+', 'R.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '5', 'X', 'Adult Videos', 'X.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AGE_RATING', '6', 'NR', 'Not Rated Material', 'NR.gif', NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Action', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Adventure', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Adult', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Animation', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Biblical', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Comedy', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Documentary', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Drama', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Horror', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Fantasy', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Music', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Musical', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Mystery', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Romance', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'ScienceFiction', 'Science Fiction', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Suspense', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Thriller', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'War', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Western', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MOVIEGENRE', NULL, 'Other', NULL, NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_6.1_DTS_ES', 'English (6.1 DTS ES)', 'dts.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_6.1_EX', 'English(6.1 EX)', 'dolby.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_6.1', 'English(6.1)', 'dolby.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_5.1', 'English(5.1)', 'dolby.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_DTS', 'English(DTS)', 'dts.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_THX', 'English(THX)', 'thx.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_5.0', 'English(5.0)', 'dolby.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_SR', 'English(Surround)', 'english.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH_2.0', 'English(2.0)', 'english.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ENGLISH', 'English', 'english.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'GERMAN', 'German', 'german.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'FRENCH', 'French', 'french.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'SPANISH', 'Spanish', 'spanish.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'ITALIAN', 'Italian', 'italian.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'AUDIO_LANG', NULL, 'DIR_COMMENT', 'Director\'s Commentary', 'director.gif', NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'SUBTITLES', NULL, 'ENGLISH', 'English', 'english.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'SUBTITLES', NULL, 'FRENCH', 'French', 'french.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'SUBTITLES', NULL, 'GERMAN', 'German', 'german.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'SUBTITLES', NULL, 'SPANISH', 'Spanish', 'spanish.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'SUBTITLES', NULL, 'ITALIAN', 'Italian', 'italian.gif', NULL);

# These actually match with the CDDB defined genres.
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'blues', 'Blues', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'classical', 'Classical', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'country', 'Country', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'folk', 'Folk', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'jazz', 'Jazz', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'newage', 'New Age', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'reggae', 'Reggae', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'rock', 'Rock', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'pop', 'Popular', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'soundtrack', 'Soundtrack', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'MUSICGENRE', NULL, 'misc', 'Miscellaneous', NULL, NULL);

# DIVX Audio codec
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp3', 'Mp3', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp2', 'Mp2', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'ogg', 'Ogg', NULL, NULL);

# DIVX Video codec
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx3', 'Divx3 3.11 Alpha', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx4', 'Divx4', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx5', 'Divx5', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'xvid', 'Xvid', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'angelpotion', 'Angel Potion Codec', NULL, NULL);

# DIVX Quality
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'poor', 'Poor', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'medium', 'Medium', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'Good', 'Good', NULL, NULL);

#
# This attribute is reserved for use in item_review.  Please do not use it for your own s_item_attribute_type structures.
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '1', 'Disgraceful!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '2', 'Terrible!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '3', 'Decent!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '4', 'Great!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '5', 'Sensational!', NULL, NULL);

#
# Duration support
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '0', '', 'Undefined', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '1', '1', 'One Day', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '2', '3', 'Three Days', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '3', '7', 'One Week', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '4', '14', 'Two Weeks', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '5', '28', 'One Month', NULL, NULL);
# --------------------------------------------------------
