<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/review.php");
include_once("./functions/item_type.php");
include_once("./functions/item.php");
include_once("./functions/widgets.php");
include_once("./functions/user.php");

function get_edit_form($op, $review_r, $HTTP_VARS)
{
	global $CONFIG_VARS;
	global $PHP_SELF;
	global $LANG_VARS;
	
	$formContents = "";
	
	// Include validation javascript here.
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$formContents .= get_validation_javascript();
	
	$formContents .= "<form action=\"$PHP_SELF\" method=\"post\">".
			"<table border=0 frameborder=0 cellspacing=1>";
			
	$formContents .= get_input_field("comment",
				NULL,
				$LANG_VARS['review'],
               	"htmlarea(55,10)",
				"Y",
            	$review_r['comment'],//value
				TRUE);

	// We are now able to configure this in the database.
	$attribute_type_r = fetch_attribute_type_r("S_RATING");
	$formContents .= get_input_field("rating",
				$attribute_type_r['s_attribute_type'],
				$attribute_type_r['prompt'],
    			$attribute_type_r['input_type'],
				$attribute_type_r['compulsory_ind'],//not supported for radio buttons yet! 
				$review_r['rating'],//value
				TRUE);
							
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
	else
		$onclick_event = "this.form.submit();";

	$formContents .= "<tr><td colspan=2 align=center>
		<br>
		<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['save_review']."\">
		<input type=\"hidden\" name=\"op\" value=\"$op\">
		<input type=\"hidden\" name=\"sequence_number\" value=\"".$review_r['sequence_number']."\">
		<input type=\"hidden\" name=\"item_id\" value=\"".$HTTP_VARS['item_id']."\">
		<input type=\"hidden\" name=\"instance_no\" value=\"".$HTTP_VARS['instance_no']."\">
		<input type=\"hidden\" name=\"parent_id\" value=\"".$HTTP_VARS['parent_id']."\">
		<input type=\"hidden\" name=\"parent_instance_no\" value=\"".$HTTP_VARS['parent_instance_no']."\">
		<input type=\"hidden\" name=\"listing_link\" value=\"".$HTTP_VARS['listing_link']."\">
		</td></tr></table>
		</form>";
		
	return $formContents;
}

session_start();
if (is_opendb_valid_session())
{
	if(is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) 
	{
		if(is_numeric($HTTP_VARS['item_id']) && ($HTTP_VARS['op'] == 'insert' || $HTTP_VARS['op'] == 'add'))
		{
			$item_r = fetch_item_r($HTTP_VARS['item_id']);
		}
		else if(is_numeric($HTTP_VARS['sequence_number']) && ($HTTP_VARS['op'] == 'update' || $HTTP_VARS['op'] == 'delete' || $HTTP_VARS['op'] == 'edit'))
		{
			$review_r = fetch_review_r($HTTP_VARS['sequence_number']);
			
			// Copy reference only.
			$item_r = $review_r;
		}
		
		if(is_not_empty_array($item_r))
		{
			$item_r['title'] = expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], NULL, NULL, $CONFIG_VARS['item_display.title_display_mask']);
			$page_title = replace_lang_var('display_title', $item_r['title'], $LANG_VARS['review_title']);

			echo _theme_header($page_title);
			echo("<h2>".$page_title." ".get_item_image($item_r['s_item_type'])."</h2>\n");
				
			if($HTTP_VARS['op'] == 'insert')
			{
				$HTTP_VARS['comment'] = filter_input_field(NULL, 'htmlarea(55,10)', $HTTP_VARS['comment']);
				if(strlen($HTTP_VARS['comment'])>0)
				{
					if(insert_review($HTTP_VARS['item_id'], $HTTP_SESSION_VARS['user_id'], $HTTP_VARS['comment'], $HTTP_VARS['rating']))
						echo ("<div class=\"success\">".$LANG_VARS['review_added']."</div>");
					else
						echo("<div class=\"error\">".$LANG_VARS['review_not_added']."</div>");
						
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
					
					// Include a Back to Listing link.
					if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
					{
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
				else
				{
					echo(format_error_block(array(error=>replace_lang_var("prompt", $LANG_VARS['review'], $LANG_VARS['prompt_must_be_specified']))));
					echo(get_edit_form('insert', array(), $HTTP_VARS));
				}
			}
			else if($HTTP_VARS['op'] == 'update')
			{
				if($CONFIG_VARS['item_review.update_support']!==FALSE)
				{
					if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						$HTTP_VARS['comment'] = filter_input_field(NULL, 'htmlarea(55,10)', $HTTP_VARS['comment']);
						if(strlen($HTTP_VARS['comment'])>0)
						{
							if(update_review($HTTP_VARS['sequence_number'], $HTTP_VARS['comment'], $HTTP_VARS['rating']))
								echo ("<div class=\"success\">".$LANG_VARS['review_updated']."</div>");
							else
								echo("<div class=\"error\">".$LANG_VARS['review_not_updated']."</div>");
								
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
							
							// Include a Back to Listing link.
							if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
						}
						else
						{
							echo(format_error_block(array(error=>replace_lang_var("prompt", $LANG_VARS['review'], $LANG_VARS['prompt_must_be_specified']))));
							echo(get_edit_form('update', array(), $HTTP_VARS));
						}
					}
					else//if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
						$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
						
						// Include a Back to Listing link.
						if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
						{
							$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
						}
					}
				}
				else//if($CONFIG_VARS['item_review.update_support']!==FALSE)
				{
					echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
					
					// Include a Back to Listing link.
					if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
					{
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
			}
			else if($HTTP_VARS['op'] == 'delete')
			{
				if($CONFIG_VARS['item_review.delete_support']!==FALSE)
				{
					if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || 
								is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						if($HTTP_VARS['confirmed'] == 'true')
						{
							if(delete_review($HTTP_VARS['sequence_number']))
								echo ("<div class=\"success\">".$LANG_VARS['review_deleted']."</div>");
							else
								echo("<div class=\"error\">".$LANG_VARS['review_not_deleted']."</div>");
							
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
				
							// Include a Back to Listing link.
							if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
						}
						else if($HTTP_VARS['confirmed'] == 'false')
						{
							echo ("<div class=\"success\">".$LANG_VARS['review_not_deleted']."</div>");
							
							$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
				
							// Include a Back to Listing link.
							if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
							{
								$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
							}
						}
						else
						{
							echo get_op_confirm_form($PHP_SELF, $LANG_VARS['confirm_delete_review'], $HTTP_VARS);
						}
					}
					else//if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
					}
				}
				else//if($CONFIG_VARS['item_review.delete_support']!==FALSE)
				{
					echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
				}
			}
			else if($HTTP_VARS['op'] == 'edit')
			{
				if($CONFIG_VARS['item_review.update_support']!==FALSE)
				{
					if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						echo get_edit_form('update', $review_r, $HTTP_VARS);
					}
					else//if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id']))
					{
						echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
						$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
					}
				}
				else//if($CONFIG_VARS['item_review.update_support']!==FALSE)
				{
					echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
				}
			}
			else if($HTTP_VARS['op'] == 'add')
			{
				echo get_edit_form('insert', array(), $HTTP_VARS);
			}
		}
		else//if(is_not_empty_array($item_r))
		{
			echo _theme_header($LANG_VARS['item_not_found']);
			echo("<h2>".$LANG_VARS['item_not_found']."</h2>");
			echo("<div class=\"error\">".$LANG_VARS['item_not_found']."</div>");
		}
	}
	else//if(is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) 
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}

	echo format_footer_links($footer_links_r);
	echo _theme_footer();
}else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
